/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: library.cpp,v 1.1 2009/08/20 13:03:32 sirakaba Exp $
*******************************************************************************/

//******************************************************************************
//    Includes
//******************************************************************************

#include "library.h"

//******************************************************************************
//    Functions
//******************************************************************************

wxString MakeCommandLineSend(wxString szCommandLine, wxString szArcName, TPI_SWITCHES * swInfo, wxArrayString asFiles, wxString szResponceFileName)
{
	// R}hCϐւB
	wxString szCommandLineSend;
	for (size_t i = 0; i < szCommandLine.Len(); i++)
	{
		if (szCommandLine[i] == wxT('%'))
		{
			// ϐ͊JnB
			switch (szCommandLine[++i])
			{
			case wxT('-'):
				// ꕶB
				szCommandLineSend += szCommandLine[++i];
				break;
			case wxT('9'):
				switch (szCommandLine[++i])
				{
				case wxT('0'):
				{
					// ɖB
					wxString s = szArcName;
					s.Replace(wxT("/"), wxT("\\"));
					szCommandLineSend += s;
					break;
				}
				case wxT('1'):
				{
					// o͐B
					szCommandLineSend += swInfo->fnDestinationDirectory.GetPathWithSep();
					break;
				}
				case wxT('2'):
					// X|Xt@CB
					szCommandLineSend += szResponceFileName;
					break;
				case wxT('3'):
					// t@CXgB
					for (size_t j = 0; j < asFiles.GetCount(); j++)
					{
						szCommandLineSend += wxT("\"") + asFiles[j] + wxT("\" ");
					}
					break;
				}
				break;
			case wxT('a'):
				switch (szCommandLine[++i])
				{
				case wxT('0'):
					// pXLɂ邩B
					if (szCommandLine[++i] == wxT('{'))
					{
						// ʁB
						for (i++; i < szCommandLine.Len() && szCommandLine[i] != wxT('|'); i++)
						{
							if (swInfo->fStoreDirectoryPathes)
							{
								szCommandLineSend += szCommandLine[i];
							}
						}
						for (i++; i < szCommandLine.Len() && szCommandLine[i] != wxT('}'); i++)
						{
							if (! swInfo->fStoreDirectoryPathes)
							{
								szCommandLineSend += szCommandLine[i];
							}
						}
					}
					else
					{
						// boollԋpB
						szCommandLineSend += swInfo->fStoreDirectoryPathes ? wxT('1') : wxT('0');
						i--;
					}
					break;
				case wxT('1'):
					// SFX쐬邩B
					if (szCommandLine[++i] == wxT('{'))
					{
						// ʁB
						for (i++; i < szCommandLine.Len() && szCommandLine[i] != wxT('|'); i++)
						{
							if (swInfo->fMakeSFX)
							{
								szCommandLineSend += szCommandLine[i];
							}
						}
						for (i++; i < szCommandLine.Len() && szCommandLine[i] != wxT('}'); i++)
						{
							if (! swInfo->fMakeSFX)
							{
								szCommandLineSend += szCommandLine[i];
							}
						}
					}
					else
					{
						// boollԋpB
						szCommandLineSend += swInfo->fMakeSFX ? wxT('1') : wxT('0');
						i--;
					}
					break;
				}
				break;
			}
		}
		else
		{
			szCommandLineSend += szCommandLine[i];
		}
	}

	return szCommandLineSend;
}

wxString MakeResponceFile(wxArrayString asFiles)
{
	wxFile fListFile;
	wxString szFileName = wxFileName::CreateTempFileName(wxT("__listfile"), & fListFile);
	if (szFileName.IsEmpty())
	{
		return wxEmptyString;
	}

	// t@CXgݏB
	if (asFiles.GetCount() == 0)
	{
		fListFile.Write(wxT("*"));
	}
	else
	{
		// pŊďB
		for (size_t i = 0; i < asFiles.GetCount(); i++)
		{
			// ŌɉsƓ삪Ȃꍇ͗lB
			if (i != 0)
			{
				fListFile.Write(wxT("\r\n"));
			}
			fListFile.Write(wxT("\"") + asFiles[i] + wxT("\""));
		}
	}
	fListFile.Close();

	return szFileName;
}
