/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: rarArc.cpp 96 2009-11-11 14:38:24Z sirakaba $
*******************************************************************************/

//******************************************************************************
//    Includes
//******************************************************************************

#define wxUSE_DYNLIB_CLASS 1
#include "../../common/header/plugin.h"
#include "../../common/header/plugin-extra.h"
#include "../../common/library/library.h"
#include <wx/dynlib.h>
#include <windows.h>
#include "rarArc.h"

//******************************************************************************
//    Global varients
//******************************************************************************

wxDynamicLibrary g_hLib;
TPI_PROC g_prProc;
TPI_SWITCHES * g_swInfo;
const wxArrayString * g_asFiles;
char g_szComment[64001];
RAROpenArchiveDataEx g_oaInfo;
RARHeaderDataEx * g_hdInfo;

//******************************************************************************
//    Callback Wrapper
//******************************************************************************

int __stdcall CallbackProc(unsigned int msg, long UserData, long P1, long P2)
{
	// \̂B
	static TPI_PROCESSINFO piInfo;

	switch (msg)
	{
	case UCM_CHANGEVOLUME:
		switch (P2)
		{
		case RAR_VOL_ASK:
			// ɂ̎̕vB
			piInfo.uMessage = TPI_MESSAGE_ASK;
			piInfo.uStatus  = TPI_PARAM_NEXTVOLUME;
			piInfo.szParam  = wxEmptyString;
			break;
		case RAR_VOL_NOTIFY:
			// ̓ǂݍ݂JnB
			piInfo.uMessage = TPI_MESSAGE_STATUS;
			piInfo.uStatus  = TPI_STATUS_OPENARCHIVE;
			piInfo.fiInfo.fnFileName = wxFileName(UTF82String((char *) P1));
			break;
		default:
			return 1;
		}
		break;
	case UCM_PROCESSDATA:
		piInfo.uMessage = TPI_MESSAGE_STATUS;
		piInfo.uStatus  = TPI_STATUS_INPROCESS;
		piInfo.llProcessedSize += P2;
		break;
	case UCM_NEEDPASSWORD:
		piInfo.uMessage = TPI_MESSAGE_ASK;
		piInfo.uStatus  = TPI_PARAM_PASSWORD;
		piInfo.szParam  = wxEmptyString;
		break;
	default:
		return 1;
	}

	// R[obN֐ɑMB
	if (g_prProc == NULL || g_prProc(TPI_NOTIFY_COMMON, & piInfo) == TPI_CALLBACK_CONTINUE)
	{
		if (msg != UCM_PROCESSDATA && P2 != RAR_VOL_NOTIFY)
		{
			strncpy((char *) P1, piInfo.szParam.char_str(), (msg == UCM_CHANGEVOLUME ? 1024 : P2) - 1);
		}
		return 1;
	}
	else
	{
		return -1;
	}
}

//******************************************************************************
//    Inside Functions
//******************************************************************************

int nErrorCodeConvert(int nErrorCode)
{
	switch (nErrorCode)
	{
	case 0:                     return TPI_ERROR_SUCCESS;
	case 1:                     return TPI_ERROR_SUCCESS;
	case ERAR_END_ARCHIVE:      return TPI_ERROR_S_ENDOFDATA;
	case ERAR_NO_MEMORY:        return TPI_ERROR_D_OUTOFMEMORY;
	case ERAR_BAD_DATA:         return TPI_ERROR_ARC_BROKEN_MISC;
	case ERAR_BAD_ARCHIVE:      return TPI_ERROR_ARC_UNSUPPORTED;
	case ERAR_UNKNOWN_FORMAT:   return TPI_ERROR_ARC_ENCRYPTED;
	case ERAR_EOPEN:            return TPI_ERROR_IO_ARC_OPEN;
	case ERAR_ECREATE:          return TPI_ERROR_IO_FILE_OPEN;
	case ERAR_ECLOSE:           return TPI_ERROR_IO_CLOSE;
	case ERAR_EREAD:            return TPI_ERROR_IO_ARC_READ;
	case ERAR_EWRITE:           return TPI_ERROR_IO_FILE_WRITE;
	case ERAR_SMALL_BUF:        return TPI_ERROR_UNDEFINED;
	case ERAR_UNKNOWN:          return TPI_ERROR_UNDEFINED;
	case ERAR_MISSING_PASSWORD: return TPI_ERROR_ARC_ENCRYPTED;
	default:                    return TPI_ERROR_UNDEFINED;
	}
}

//******************************************************************************
//    Functions
//******************************************************************************

#ifdef __cplusplus
extern "C"
{
#endif

int __stdcall GetPluginInformation
(
	unsigned int _uInfoId,
	wxULongLong,
	void * _pPtr
)
{
	if (_pPtr == NULL)
	{
		return TPI_ERROR_D_PARAMETER;
	}
	switch (LOWORD(_uInfoId))
	{
	case TPI_INFO_VERSION_MAJOR:
	case TPI_INFO_VERSION_MINOR:
		* (int *) _pPtr = 0;
		break;
	case TPI_INFO_VERSION_API:
		* (int *) _pPtr = 2;
		break;
	default:
		return TPI_ERROR_D_UNSUPPORTED;
	}
	return TPI_ERROR_SUCCESS;
}

int __stdcall GetFormatInformation(TPI_FORMATINFO * _fiInfo, bool _bFirst)
{
	if (! _bFirst)
	{
		return TPI_ERROR_S_ENDOFDATA;
	}

	_fiInfo->szTypeName   = wxT("RAR");
	_fiInfo->szSuffix     = wxT(".rar");
	_fiInfo->szEngineName = g_hLib.CanonicalizeName(wxT("unrar"));
	_fiInfo->szTPIName    = wxT("rarArc");
	_fiInfo->llTypeId     = 0;
	_fiInfo->llSupportedCommand = TPI_COMMAND_EXTRACT | TPI_COMMAND_TEST;
	_fiInfo->fComment     = true;
	_fiInfo->fSFX         = true;
	_fiInfo->fSolid       = true;
	_fiInfo->fEncryptPassword = true;
	_fiInfo->fMultiVolume = true;

	return TPI_ERROR_SUCCESS;
}

int __stdcall LoadPlugin
(
	const wxString & _szArcName,
	wxULongLong
)
{
	g_hLib.Load(g_hLib.CanonicalizeName(wxT("unrar")));
	if (! g_hLib.IsLoaded() || CheckArchive(_szArcName, NULL) != TPI_ERROR_SUCCESS)
	{
		g_hLib.Unload();
		return TPI_ERROR_U_LOAD_LIBRARY;
	}

	return TPI_ERROR_SUCCESS;
}

int __stdcall FreePlugin
(
	void * // _pReserved
)
{
	g_hLib.Unload();
	return TPI_ERROR_SUCCESS;
}

int __stdcall CheckArchive
(
	const wxString & _szArcName,
	int * _nFileCount
)
{
	void * _hArchive;
	int nErrorCode = OpenArchive(_szArcName, & _hArchive);
	if (nErrorCode != TPI_ERROR_SUCCESS)
	{
		return nErrorCode;
	}

	if (_nFileCount != NULL)
	{
		* _nFileCount = 1;
	}

	return CloseArchive(_hArchive);
}

int __stdcall OpenArchive
(
	const wxString & _szArcName,
	void * * _hArchive
)
{
	if (! g_hLib.HasSymbol(wxT("RAROpenArchiveEx")))
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}
	void * p = g_hLib.GetSymbol(wxT("RAROpenArchiveEx"));
	if (! p)
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}

	// TODO : PpB
	wchar_t sz[2048];
	wcsncpy(sz, _szArcName.wchar_str(), 2047);
	memset(& g_oaInfo, 0, sizeof(g_oaInfo));
	g_oaInfo.ArcName    = NULL;
	g_oaInfo.ArcNameW   = sz;
	g_oaInfo.OpenMode   = RAR_OM_EXTRACT;
	g_oaInfo.CmtBuf     = g_szComment;
	g_oaInfo.CmtBufSize = sizeof(g_szComment) - 1;
	* _hArchive = ((void * (__stdcall *)(RAROpenArchiveDataEx *)) p)(& g_oaInfo);
	if (* _hArchive == NULL)
	{
		return TPI_ERROR_UNDEFINED;
	}
	int nErrorCode = nErrorCodeConvert(g_oaInfo.OpenResult);
	if (nErrorCode != TPI_ERROR_SUCCESS)
	{
		return nErrorCode;
	}

	// R[obN֐ݒB
	if (! g_hLib.HasSymbol(wxT("RARSetCallback")))
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}
	p = g_hLib.GetSymbol(wxT("RARSetCallback"));
	if (! p)
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}
	((void (__stdcall *)(void *, FARPROC, LPARAM)) p)(* _hArchive, (FARPROC) CallbackProc, (LPARAM) & g_hdInfo);

	return TPI_ERROR_SUCCESS;
}

int __stdcall CloseArchive
(
	void * _hArchive
)
{
	if (! g_hLib.HasSymbol(wxT("RARCloseArchive")))
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}
	void * p = g_hLib.GetSymbol(wxT("RARCloseArchive"));
	return (! p || _hArchive == NULL) ? TPI_ERROR_U_USE_LIBRARY : nErrorCodeConvert(((int (__stdcall *)(void *)) p)(_hArchive));
}

int __stdcall GetFileInformation
(
	void * _hArchive,
	TPI_FILEINFO * _fiInfo,
	bool _bFirst
)
{
	static unsigned int s_uFileID;
	static void * pR, * pP;
	int nErrorCode;

	if (_bFirst)
	{
		s_uFileID = 0;
		pR = g_hLib.HasSymbol(wxT("RARReadHeaderEx")) ? g_hLib.GetSymbol(wxT("RARReadHeaderEx")) : NULL;
		pP = g_hLib.HasSymbol(wxT("RARProcessFileW"))  ? g_hLib.GetSymbol(wxT("RARProcessFileW")) : NULL;
		if (! pR || ! pP)
		{
			return TPI_ERROR_U_USE_LIBRARY;
		}
	}

	RARHeaderDataEx hdInfo;
	nErrorCode = nErrorCodeConvert(((int (__stdcall *)(void *, RARHeaderDataEx *)) pR)(_hArchive, & hdInfo));
	if (nErrorCode == TPI_ERROR_SUCCESS)
	{
		_fiInfo->dwAttribute    = hdInfo.FileAttr;
		_fiInfo->dwCRC32        = hdInfo.FileCRC;
		_fiInfo->llPackedSize   = wxLongLong(hdInfo.PackSizeHigh, hdInfo.PackSize);
		_fiInfo->llUnpackedSize = wxLongLong(hdInfo.UnpSizeHigh,  hdInfo.UnpSize);
		_fiInfo->tmModified.SetFromDOS(hdInfo.FileTime);
		_fiInfo->uOSType        = hdInfo.HostOS;
		_fiInfo->szStoredName   = WC2String(hdInfo.FileNameW);
//		_fiInfo->szMethod       = hdInfo.Method;
		_fiInfo->llFileID       = s_uFileID++;
		_fiInfo->fnFileName     = wxFileName(_fiInfo->szStoredName);

		// ̃t@CցB
		nErrorCode = nErrorCodeConvert(((int (__stdcall *)(void *, int, wchar_t *, wchar_t *)) pP)(_hArchive, RAR_SKIP, NULL, NULL));
		if (nErrorCode != TPI_ERROR_SUCCESS)
		{
			return nErrorCode;
		}
	}

	return nErrorCode;
}

int __stdcall GetArchiveInformation
(
	void *,
	TPI_ARCHIVEINFO * _aiInfo
)
{
	_aiInfo->fSolid         = (g_oaInfo.Flags & 0x0008) == 1;
	_aiInfo->fEncryptHeader = (g_oaInfo.Flags & 0x0080) == 1;
	_aiInfo->szComment      = UTF82String(g_szComment);
	GetFormatInformation(& _aiInfo->fiInfo, true);
	return TPI_ERROR_SUCCESS;
}

int __stdcall Command
(
	unsigned int _uCommand,
	TPI_SWITCHES * _swInfo,
	const wxString & _szArcName,
	const wxArrayString & _szFiles
)
{
	if (_uCommand != TPI_COMMAND_EXTRACT && _uCommand != TPI_COMMAND_TEST)
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}

	// JȂB
	void * hArc;
	int nErrorCode = OpenArchive(_szArcName, & hArc);
	if (nErrorCode != TPI_ERROR_SUCCESS)
	{
		return nErrorCode;
	}

	void
		* pS = g_hLib.HasSymbol(wxT("RARSetPassword"))  ? g_hLib.GetSymbol(wxT("RARSetPassword"))  : NULL,
		* pR = g_hLib.HasSymbol(wxT("RARReadHeaderEx")) ? g_hLib.GetSymbol(wxT("RARReadHeaderEx")) : NULL,
		* pP = g_hLib.HasSymbol(wxT("RARProcessFileW")) ? g_hLib.GetSymbol(wxT("RARProcessFileW")) : NULL;
	if (! pR || ! pP)
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}
	if (pS)
	{
		((void (__stdcall *)(void *, char *)) pS)(hArc, _swInfo->szPassword.char_str());
	}

	RARHeaderDataEx hdInfo;
	g_hdInfo = & hdInfo;
	while (nErrorCode == TPI_ERROR_SUCCESS && nErrorCodeConvert(((int (__stdcall *)(void *, RARHeaderDataEx *)) pR)(hArc, & hdInfo)) == TPI_ERROR_SUCCESS)
	{
		nErrorCode =
			nErrorCodeConvert(
				((int (__stdcall *)(void *, int, wchar_t *, wchar_t *)) pP)(
					hArc,
					(_szFiles.Count() != 0 && _szFiles.Index(wxString(hdInfo.FileNameW)) == wxNOT_FOUND) ? RAR_SKIP : _uCommand == TPI_COMMAND_EXTRACT ? RAR_EXTRACT : RAR_TEST,
					_swInfo->fStoreDirectoryPathes ? _swInfo->fnDestinationDirectory.GetFullPath().wchar_str() : NULL,
					_swInfo->fStoreDirectoryPathes ? NULL : (_swInfo->fnDestinationDirectory.GetPathWithSep() + wxFileName(hdInfo.FileNameW).GetFullName()).wchar_str()
				)
			);
	}
	CloseArchive(hArc);
	return nErrorCode;
}

int __stdcall SetCallbackProc
(
	TPI_PROC _prArcProc
)
{
	// |C^ۑB
	if (_prArcProc == NULL)
	{
		return TPI_ERROR_D_PARAMETER;
	}
	g_prProc = * _prArcProc;

	return TPI_ERROR_SUCCESS;
}

#ifdef __cplusplus
}
#endif
