/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: lychee.cpp 175 2009-12-27 07:41:44Z sirakaba $
*******************************************************************************/

#include "lychee.h"
#include "frm_main.h"

//******************************************************************************
// Lychee
//******************************************************************************

IMPLEMENT_APP(Lychee)

bool Lychee::OnInit()
{
	wxInitAllImageHandlers();
	::wxXmlResource::Get()->InitAllHandlers();

	// 作業パスを設定。
	wxString szCwd;
	{
		wxChar cSep = wxFileName::GetPathSeparator();
		szCwd = ::wxGetCwd() + cSep;
		wxStandardPaths p;
		::wxSetWorkingDirectory(::wxPathOnly(p.GetExecutablePath()) + cSep);
	}

	// 言語ファイルのパスを指定。
	this->lc.AddCatalogLookupPathPrefix(L_DIR_S_LOC);
	this->lc.AddCatalog(wxT("lychee"));

	MainFrame * frm_main = new MainFrame();
	frm_main->szCurrentPath = szCwd;
	if (! ::wxXmlResource::Get()->Load(L_DIR_S_XRC wxT("frm_main.xrc")))
	{
		::wxLogError(_("Unable to find XRC!"));
		return false;
	}

	::wxXmlResource::Get()->LoadFrame(frm_main, NULL, wxT("frame_main"));
	::wxXmlResource::Get()->Unload(L_DIR_S_XRC wxT("frm_main.xrc"));
	SetTopWindow(frm_main);
	frm_main->cmdLine.SetCmdLine(this->argc, this->argv);
	frm_main->InitDialog();
	frm_main->Show();

	return true;
}
