/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: cls_config.h 248 2010-02-21 02:54:39Z sirakaba $
*******************************************************************************/

#include <wx/fileconf.h>

#ifndef H_LOADED_CLS_CONF
#define H_LOADED_CLS_CONF

// Config ID.
enum myConfigId
{
	CONF_WINDOW_HEIGHT,
	CONF_WINDOW_WIDTH,
	CONF_WINDOW_X,
	CONF_WINDOW_Y,
	CONF_WINDOW_SPLITTER_POS,
	CONF_WINDOW_STATUSBAR,
	CONF_WINDOW_TOOLBAR,
	CONF_LISTVIEW_SHOWMODE,
	CONF_LISTVIEW_C_FILENAME,
	CONF_LISTVIEW_C_UNPACKED,
	CONF_LISTVIEW_C_PACKED,
	CONF_LISTVIEW_C_RATIO,
	CONF_LISTVIEW_C_METHOD,
	CONF_LISTVIEW_C_ATTR,
	CONF_LISTVIEW_C_LASTMOD,
	CONF_LISTVIEW_C_PATH,
	CONF_LISTVIEW_C_TYPE,
	CONF_LISTVIEW_C_NO,
	CONF_LISTVIEW_S_COLUMN,
	CONF_LISTVIEW_S_ASCEND,

	CONF_DEFAULT_EXT,
	CONF_DEFAULT_PATH,

	CONF_HISTORY_PATH,
	CONF_HISTORY_NAME,
	CONF_HISTORY_FULL,
	CONF_HISTORY_COUNT,

	CONF_LAST
};

class myConfig : public wxFileConfig
{
public:
	myConfig();
	~myConfig();

	// General
	wxString ReadId(myConfigId confId, const wxString & defaultVal);
	long ReadId(myConfigId confId, long defaultVal);
	bool ReadId(myConfigId confId, bool defaultVal);

	bool WriteId(myConfigId confId, const wxString & value);
	bool WriteId(myConfigId confId, int value);
	bool WriteId(myConfigId confId, bool value);

	// History
	size_t GetHistoryCount(myConfigId confId);
	wxString ReadHistory(myConfigId confId, size_t i);
	void WriteHistory(myConfigId confId, wxString sz);

private:
	wxString label[CONF_LAST];
	wxArrayString asHistory[CONF_HISTORY_COUNT - CONF_HISTORY_PATH];
	bool bWriteHistory;

	void myReadHistory(myConfigId confId, size_t i);
	void myWriteHistory(myConfigId confId, size_t i);
};

#endif
