/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: dlg_process.cpp 281 2010-03-04 03:04:32Z sirakaba $
*******************************************************************************/

#include "lychee.h"
#include "dlg_process.h"

ProcessDialog * g_procDlg = NULL;

//******************************************************************************
// ProcessDialog
//******************************************************************************

ProcessDialog::ProcessDialog(): wxDialog()
{
	::wxXmlResource::Get()->Load(L_DIR_S_XRC wxT("dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(this, this->GetParent(), wxT("dlg_process"));	
}

ProcessDialog::~ProcessDialog()
{
	g_procDlg = NULL;
}

//******************************************************************************
// Event table.
//******************************************************************************

BEGIN_EVENT_TABLE(ProcessDialog, wxDialog)
	EVT_INIT_DIALOG(ProcessDialog::OnInit)
	EVT_CLOSE(      ProcessDialog::OnClose)
END_EVENT_TABLE()

//******************************************************************************
// Event handler.
//******************************************************************************

void ProcessDialog::OnInit(wxInitDialogEvent &)
{
	// XRCと結びつけ。
	this->ebSource          = XRCCTRL(* this, "ebSource",     wxTextCtrl);
	this->ebTarget          = XRCCTRL(* this, "ebTarget",     wxTextCtrl);
	this->gFile             = XRCCTRL(* this, "gFile",        wxGauge);
	this->gArchive          = XRCCTRL(* this, "gArchive",     wxGauge);
	this->fCancel           = false;
	g_procDlg = this;

	::wxXmlResource::Get()->Unload(L_DIR_S_XRC wxT("dlg_process.xrc"));
}

void ProcessDialog::OnClose(wxCloseEvent & e)
{
	if (e.CanVeto() && ::AskDlg(_("Really do you want to cancel this operation?"), this) == wxYES)
	{
		this->fCancel = true;
	}
	e.Veto();
}

int ProcessDialog::CallbackProc(unsigned int _uMsg, void * _pStructure)
{
	if (_uMsg != TPI_NOTIFY_COMMON)
	{
		return TPI_CALLBACK_UNSUPPORTED;
	}

	TPI_PROCESSINFO * piInfo = (TPI_PROCESSINFO *) _pStructure;
	if (piInfo == NULL || ! this->IsShown())
	{
		return TPI_CALLBACK_CONTINUE;
	}

	switch (piInfo->eMessage)
	{
	case TPI_MESSAGE_STATUS:
	{
		static int s_nGaugeCounter = 0, s_nInterval = 0;
		switch (piInfo->eStatus)
		{
		case TPI_STATUS_OPENARCHIVE:
			this->ebSource->ChangeValue(piInfo->fiInfo.fnFileName.GetFullPath());
			break;
		case TPI_STATUS_BEGINPROCESS:
			// 小さなファイルなら表示しない。
			if (piInfo->fiInfo.nUnpackedSize > 10000)
			{
				this->ebSource->ChangeValue(piInfo->fiInfo.fnFileName.GetFullPath());
				this->ebTarget->ChangeValue(piInfo->fnDestination.GetFullPath());
				this->gFile->SetRange(piInfo->fiInfo.nUnpackedSize);
				this->gFile->SetValue(0);
				::wxSafeYield(this, true);
			}
			break;
		case TPI_STATUS_INPROCESS:
			if (piInfo->fiInfo.nUnpackedSize > 10000)
			{
				this->gFile->SetValue(piInfo->nProcessedSize);
				::wxSafeYield(this, true);
			}
			break;
		case TPI_STATUS_ENDPROCESS:
			if (s_nGaugeCounter++ > s_nInterval)
			{
				this->gArchive->SetValue(this->gArchive->GetValue() + s_nInterval);
				::wxSafeYield(this, true);
				s_nGaugeCounter = 0;
			}
			break;
		// 書庫ロード時用の独自仕様。
		case 0x1000:
			this->ebSource->ChangeValue(piInfo->fiInfo.fnFileName.GetFullPath());
			this->gArchive->SetRange(piInfo->fiInfo.nUnpackedSize);
			this->gArchive->SetValue(0);
			s_nInterval = piInfo->fiInfo.nUnpackedSize / 10;
			break;
		case 0x1001:
			if (piInfo->fiInfo.nUnpackedSize > 10000)
			{
				this->ebTarget->ChangeValue(piInfo->fiInfo.fnFileName.GetFullPath());
			}
			if (s_nGaugeCounter++ > s_nInterval)
			{
				this->gArchive->SetValue(piInfo->nProcessedSize);
				::wxSafeYield(this, true);
				s_nGaugeCounter = 0;
			}
			break;
		}
		break;
	}
	case TPI_MESSAGE_ASK:
	{
		switch (piInfo->eStatus)
		{
		case TPI_PARAM_PASSWORD:
			piInfo->szParam = ::wxGetPasswordFromUser(_("Password for:\n") + piInfo->fiInfo.fnFileName.GetFullPath(), wxT("Lychee"), wxEmptyString, this);
			if (piInfo->szParam.IsEmpty())
			{
				this->fCancel = true;
			}
			break;
		case TPI_PARAM_NEXTVOLUME:
		{
			wxFileDialog fd(this, _("Select next volume of: ") + piInfo->fiInfo.fnFileName.GetFullName());
			fd.SetWindowStyleFlag(wxFD_FILE_MUST_EXIST);
			if (fd.ShowModal() == wxID_CANCEL)
			{
				this->fCancel = true;
			}
			piInfo->szParam = fd.GetPath();
			break;
		}
		default:
			return TPI_CALLBACK_UNSUPPORTED;
		}
		break;
	}
	default:
		return TPI_CALLBACK_UNSUPPORTED;
	}

	return this->fCancel ? TPI_CALLBACK_CANCEL : TPI_CALLBACK_CONTINUE;
}

//******************************************************************************
//    ダイアログプロシージャ
//******************************************************************************

int __stdcall TPICallbackProc(unsigned int _uMsg, void * _pStructure)
{
	return g_procDlg == NULL ? TPI_CALLBACK_CONTINUE : g_procDlg->CallbackProc(_uMsg, _pStructure);
}
