/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: frm_main.h 233 2010-02-20 02:15:53Z sirakaba $
*******************************************************************************/

#include <wx/splitter.h>

#ifndef H_LOADED_FRM_MAIN
#define H_LOADED_FRM_MAIN

class MainFrame: public wxFrame {
public:
    wxTreeCtrl * tree_ctrl;
    myListCtrl * list_ctrl;
	ArrayTPI_FILEINFO fileinfo;
	TPIHandle tpi;
	wxFileName fnArchive;
	TPI_ARCHIVEINFO aiArchive;
	myConfig conf;

    // Event handler.
    void OnInit(    wxInitDialogEvent&);

	void OnExit(       wxCommandEvent&);
    void OnArcCreate(  wxCommandEvent&);
    void OnArcOpen(    wxCommandEvent&);
    void OnArcClose(   wxCommandEvent&);
    void OnArcAdd(     wxCommandEvent&);
    void OnArcConvert( wxCommandEvent&);

	void OnArcExtract( wxCommandEvent&);
    void OnArcDelete(  wxCommandEvent&);
    void OnArcTest(    wxCommandEvent&);
    void OnArcRepair(  wxCommandEvent&);

	void OnViewMode(wxCommandEvent&);

	void OnShowToolBar(  wxCommandEvent&);
	void OnShowStatusBar(wxCommandEvent&);

	void OnSelectAll(wxCommandEvent&);

	void OnTreeChanged(wxTreeEvent&);
	void OnTreeBeginDrag(wxTreeEvent&);

	void OnListItemDClick(wxListEvent&);
    void OnListBeginDrag( wxListEvent&);

	void OnFilter(wxCommandEvent&);

	wxULongLong_t LoadTPI(wxString);
	int ErrorCheck(int);

	MainFrame();
	~MainFrame();

protected:
    wxMenuBar * menubar;
    wxToolBar * toolbar;
    wxStatusBar * statusbar;
    wxSplitterWindow * window_splitter;
    wxTextCtrl * tcFilter;
    DECLARE_EVENT_TABLE()
};

#endif
