/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: dlg_process.h 464 2011-01-09 09:40:44Z sirakaba $
*******************************************************************************/

#ifndef H_LOADED_DLG_PROCESS
#define H_LOADED_DLG_PROCESS

class ProcessDialog: public wxDialog {
public:
    void OnInit(wxInitDialogEvent &);
	void OnClose(wxCloseEvent &);
	int CallbackProc(unsigned int, void *);

	ProcessDialog();
	~ProcessDialog();

	wxFileName * fnArchive;
	wxULongLong_t nFileCount;

	DECLARE_EVENT_TABLE()

private:
	bool fCancel;
	int nOverwriteMode;
	wxTextCtrl* ebTarget;
	wxTextCtrl* ebSource;
	wxGauge* gFile;
	wxGauge* gArchive;
};

class OverwriteDialog: public wxDialog {
public:
    void OnInit(wxInitDialogEvent &);
	void OnClose(wxCloseEvent &);
    void OnBtnOverwrite(wxCommandEvent&);
    void OnBtnSkip(     wxCommandEvent&);
    void OnBtnAuto(     wxCommandEvent&);
    void OnBtnBrowse(   wxCommandEvent&);

	OverwriteDialog();

	wxFileName * fnExist;
	wxDateTime * tmWrite;
	wxULongLong_t nWriteSize;
	wxCheckBox* cbApplyAll;

	DECLARE_EVENT_TABLE()

private:
	wxTextCtrl* ebTarget;
};

//******************************************************************************
//    プロシージャ
//******************************************************************************

int __stdcall TPICallbackProc(unsigned int, void *);

#endif
