/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: cuiWrapper.cpp 482 2011-02-09 13:29:52Z sirakaba $
*******************************************************************************/

//******************************************************************************
//    Includes
//******************************************************************************

#include "../../common/header/plugin.h"
#include "../../common/header/plugin-extra.h"
#include "../../common/library/library.h"
#include "../../common/library/xmldoc.h"
#include <wx/config.h>
#include <wx/tokenzr.h>
#include "cuiWrapper.h"

//******************************************************************************
//    Global varients
//******************************************************************************

struct g_LibInfo
{
	wxString szExeFile;
	wxString szExeFileAlt;
	wxString szListCommand;
	wxULongLong_t nLibIndex;
	wxXmlNode node;
}	g_LibInfo;

TPI_PROC g_prProc;

//******************************************************************************
//    Inside Functions
//******************************************************************************

int myExecute(const wxString & szCommandLine, wxString * szOutput, const wxString & szCwd, bool fWine)
{
#ifdef __LINUX__
	wxString sz = ::wxGetCwd();
	::wxSetWorkingDirectory(szCwd);
	FILE * fp = popen(fWine ? (wxT("wine ") + szCommandLine).ToUTF8() : szCommandLine.ToUTF8(), "r");
	::wxSetWorkingDirectory(sz);
	if (fp == NULL)
	{
		wxLogError(L"Error :\n\nCommandLine:\n%s", szCommandLine.c_str());
		return TPI_ERROR_U_USE_LIBRARY;
	}

	if (szOutput != NULL)
	{
		char sz[32769];
		while (! feof(fp))
		{
			memset(sz, 0, sizeof(sz));
			fread(sz, sizeof(char), sizeof(sz) - 1, fp);
			* szOutput += UTF82String(sz);
		}
//		::wxMessageBox(* szOutput);
	}

	// 127を返した場合はコマンドが存在しない。
	int nErrorCode = pclose(fp);
	return (WIFEXITED(nErrorCode) && WEXITSTATUS(nErrorCode) != 127) ? TPI_ERROR_SUCCESS : TPI_ERROR_U_USE_LIBRARY;
#else
	SECURITY_ATTRIBUTES sa;
	memset(& sa, 0, sizeof(SECURITY_ATTRIBUTES));
	sa.bInheritHandle = TRUE;
	sa.nLength = sizeof(SECURITY_ATTRIBUTES);
	HANDLE hRead, hWrite;
	if (! ::CreatePipe(& hRead, & hWrite, & sa, 0))
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}
	STARTUPINFO si;
	memset(& si, 0, sizeof(STARTUPINFO));
	si.cb = sizeof(STARTUPINFO);
	si.dwFlags = STARTF_USESTDHANDLES;
	si.hStdOutput = hWrite;
	si.hStdError = hWrite;
	PROCESS_INFORMATION pi;
	if (! ::CreateProcess(NULL, szCommandLine.wchar_str(), NULL, NULL, TRUE, CREATE_NO_WINDOW, NULL, szCwd.IsEmpty() ? NULL : szCwd.wchar_str(), & si, & pi))
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}
	::CloseHandle(pi.hThread);

	if (szOutput != NULL)
	{
		char sz[32768];
		while (true)
		{
			DWORD dwSize = 0;
			if (! ::PeekNamedPipe(hRead, NULL, 0, NULL, & dwSize, NULL))
			{
				continue;
			}

			if (dwSize > 0)
			{
				memset(sz, 0, sizeof(sz));
				::ReadFile(hRead, & sz, sizeof(sz), & dwSize, NULL);
				* szOutput += wxString(sz);
				// UTF-8以外の文字コードだと、UTF82Stringを使うと書庫が開けなくなる。データの切り出しにも影響。
//				* szOutput += UTF82String(sz);
//				::MessageBoxA(NULL, sz, NULL, 0);
			}
			else if (::WaitForSingleObject(pi.hProcess, 0) == WAIT_OBJECT_0)
			{
				break;
			}
		}
	}

	::CloseHandle(pi.hProcess);
	::CloseHandle(hRead);
	::CloseHandle(hWrite);
	return TPI_ERROR_SUCCESS;
#endif
}

PosInfo MakePosInfo(const wxString & szPrefix)
{
	PosInfo pi;
	pi.nStart = myGetAttributeInt(& g_LibInfo.node, wxT("list-") + szPrefix + wxT("-s"));
	pi.nCount = myGetAttributeInt(& g_LibInfo.node, wxT("list-") + szPrefix + wxT("-c"));
	pi.nLine  = myGetAttributeInt(& g_LibInfo.node, wxT("list-") + szPrefix + wxT("-l"));
	return pi;
}

wxULongLong_t GetSize(const PosInfo & pi, wxULongLong_t nCurrent, const wxArrayString & as)
{
	if (pi.nStart == 0 && pi.nCount == 0)
	{
		return 0;
	}

	wxULongLong_t nTemp = 0, nPos = nCurrent + pi.nLine;
	wxString sz = pi.nCount == 0 ? as[nPos].Mid(pi.nStart) : as[nPos].Mid(pi.nStart, pi.nCount);
	sz.ToULongLong(& nTemp);
	return nTemp;
}

//******************************************************************************
//    Functions
//******************************************************************************

#ifdef __cplusplus
extern "C"
{
#endif

int __stdcall GetPluginInformation
(
	unsigned int _uInfoId,
	wxULongLong_t,
	void * _pPtr
)
{
	if (_pPtr == NULL)
	{
		return TPI_ERROR_D_PARAMETER;
	}
	switch (_uInfoId)
	{
	case TPI_INFO_VERSION_MAJOR:
	case TPI_INFO_VERSION_MINOR:
		* (int *) _pPtr = 0;
		break;
	case TPI_INFO_VERSION_API:
		* (int *) _pPtr = 2;
		break;
	default:
		return TPI_ERROR_D_UNSUPPORTED;
	}
	return TPI_ERROR_SUCCESS;
}

int __stdcall GetFormatInformation(TPI_FORMATINFO * _fiInfo, bool _bFirst)
{
	static wxULongLong_t s_nFileId;
	static wxXmlDocument xmlDoc(myMakeXMLName(wxT("cuiWrapper")));
	static wxXmlNode * xmlLibrary;
	if (_bFirst)
	{
		// xml解析開始。
		s_nFileId = 0;
		xmlLibrary = myGetFirstLib(& xmlDoc);
	}
	else
	{
		xmlLibrary = myGetNextLib(xmlLibrary);
	}
	if (xmlLibrary == NULL)
	{
		// データの終端に達した場合。
		return TPI_ERROR_S_ENDOFDATA;
	}

	MakeFormatInfo(xmlLibrary, wxT("cuiWrapper"), _fiInfo, s_nFileId++);
	wxString szExeFile = xmlLibrary->GetAttribute(wxT("name"), wxEmptyString);
	if (myExecute(szExeFile, NULL, wxEmptyString, szExeFile.Find(wxT('.')) != wxNOT_FOUND && szExeFile.AfterLast(wxT('.')) == wxT("exe")) != TPI_ERROR_SUCCESS)
	{
		_fiInfo->eSupportedCommand = 0;
	}
	return TPI_ERROR_SUCCESS;
}

int __stdcall LoadPlugin
(
	const wxString & _szArcName,
	wxULongLong_t _nTypeId
)
{
	// xml解析開始。
	wxXmlDocument xmlDoc(myMakeXMLName(wxT("cuiWrapper")));
	wxXmlNode * xmlLibrary;

	// 対象が存在するならば対応するライブラリを調査、
	// 対象が存在しないならば指示されたライブラリをロード。
	if (! ::wxFileExists(_szArcName))
	{
		xmlLibrary = myGetFirstLib(& xmlDoc, _nTypeId);
		if (xmlLibrary == NULL)
		{
			// xml文法エラー。
			return TPI_ERROR_UNDEFINED;
		}
		g_LibInfo.szExeFile = xmlLibrary->GetAttribute(wxT("name"), wxEmptyString);
		g_LibInfo.szExeFileAlt = xmlLibrary->GetAttribute(wxT("name-alt"), wxEmptyString);
		g_LibInfo.node = * xmlLibrary;
		g_LibInfo.nLibIndex = _nTypeId;
		return TPI_ERROR_SUCCESS;
	}

	// 無限ループに陥らないよう上限を設定。
	xmlLibrary = myGetFirstLib(& xmlDoc);
	for (g_LibInfo.nLibIndex = 0; g_LibInfo.nLibIndex < 300 && xmlLibrary != NULL; g_LibInfo.nLibIndex++)
	{
		// 書庫に対応しているかチェック。
		wxFileName fnArchive(_szArcName);
		wxArrayString asExt = ::wxStringTokenize(xmlLibrary->GetAttribute(wxT("suffix"), wxEmptyString), wxT(";"));
		if (xmlLibrary->HasAttribute(wxT("list")))
		{
			for (size_t i = 0; i < asExt.GetCount(); i++)
			{
				// .tar.XXXなど二重判定への対応。
//				if (asExt[i].IsSameAs(fnArchive.GetExt(), false))
				if (fnArchive.GetFullName().EndsWith(wxT('.') + asExt[i]))
				{
					// ライブラリをロード。
					g_LibInfo.szExeFile = xmlLibrary->GetAttribute(wxT("name"), wxEmptyString);
					g_LibInfo.szExeFileAlt = xmlLibrary->GetAttribute(wxT("name-alt"), wxEmptyString);
					g_LibInfo.node = * xmlLibrary;
					g_LibInfo.nLibIndex = _nTypeId;
					return TPI_ERROR_SUCCESS;
				}
			}
		}
		xmlLibrary = myGetNextLib(xmlLibrary);
	}
	return TPI_ERROR_U_LOAD_LIBRARY;
}

int __stdcall FreePlugin
(
	void * // _pReserved
)
{
	return TPI_ERROR_SUCCESS;
}

int __stdcall OpenArchive
(
	const wxString & _szArcName,
	void * * _hArchive,
	wxULongLong_t * _nFileCount
)
{
	wxString szOutput;
	if (myExecute(g_LibInfo.szExeFile + wxT(" ") + MakeCommandLineSend(g_LibInfo.node.GetAttribute(wxT("list"), wxEmptyString), _szArcName), & szOutput, wxEmptyString, g_LibInfo.szExeFile.Find(wxT('.')) != wxNOT_FOUND && g_LibInfo.szExeFile.AfterLast(wxT('.')) == wxT("exe")) != TPI_ERROR_SUCCESS)
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}
	wxArrayString * as = new wxArrayString(::wxStringTokenize(szOutput, wxT("\r\n")));
	* _hArchive = (void *) as;
	as->Shrink();
	if (_nFileCount != NULL)
	{
		* _nFileCount = as->GetCount();
	}
	return as->IsEmpty() ? TPI_ERROR_UNDEFINED : TPI_ERROR_SUCCESS;
}

int __stdcall CloseArchive
(
	void * _hArchive
)
{
	wxArrayString * as = (wxArrayString *) _hArchive;
	as->Clear();
	delete as;
	return TPI_ERROR_SUCCESS;
}

int __stdcall GetFileInformation
(
	void * _hArchive,
	TPI_FILEINFO * _fiInfo,
	bool _bFirst
)
{
	static size_t s_nCurrentLine;
	static wxULongLong_t s_nFileId;
	if (_hArchive == NULL)
	{
		return TPI_ERROR_UNDEFINED;
	}
	wxArrayString asOutput = * (wxArrayString *) _hArchive;

	// XMLからの読み込みは初回に行う。
	static wxString szEndLine, szDateFormat;
	static wxULongLong_t nProcessPerLine;
	static PosInfo piFName, piPSize, piUSize, piDate;
	if (_bFirst)
	{
		s_nFileId = 0;
		wxString szStartLine = g_LibInfo.node.GetAttribute(wxT("list-line-s"), wxEmptyString);
		if (! szStartLine.IsEmpty())
		{
			// 開始行の次の行にセット。
			s_nCurrentLine = asOutput.Index(szStartLine) + 1;
			if (s_nCurrentLine == wxNOT_FOUND + 1)
			{
				// 書庫が読み込めなかった？
				return TPI_ERROR_ARC_UNSUPPORTED;
			}
		}

		// 初期設定。
		nProcessPerLine = myGetAttributeInt(& g_LibInfo.node, wxT("list-line-c"), 1);
		szEndLine = g_LibInfo.node.GetAttribute(wxT("list-line-e"), szStartLine);
		szDateFormat = g_LibInfo.node.GetAttribute(wxT("list-date-f"), wxDefaultDateTimeFormat);
		piFName = MakePosInfo(wxT("fname"));
		piPSize = MakePosInfo(wxT("psize"));
		piUSize = MakePosInfo(wxT("usize"));
		piDate  = MakePosInfo(wxT("date"));
	}

	if (s_nCurrentLine >= asOutput.GetCount())
	{
		// 空行で終わるとき以外はエラーとする。
		return szEndLine.IsEmpty() ? TPI_ERROR_S_ENDOFDATA : TPI_ERROR_ARC_UNSUPPORTED;
	}

	// 最終行かどうか確認。
	if (asOutput[s_nCurrentLine] == szEndLine)
	{
		return TPI_ERROR_S_ENDOFDATA;
	}

	// ファイル名を取得。
	_fiInfo->szStoredName = piFName.nCount == 0 ? asOutput[s_nCurrentLine + piFName.nLine].Mid(piFName.nStart) : asOutput[s_nCurrentLine + piFName.nLine].Mid(piFName.nStart, piFName.nCount);
	_fiInfo->szStoredName.Trim();
	_fiInfo->fnFileName = wxFileName(_fiInfo->szStoredName, wxPATH_DOS);

	// サイズ取得。
	_fiInfo->nPackedSize   = GetSize(piPSize, s_nCurrentLine, asOutput);
	_fiInfo->nUnpackedSize = GetSize(piUSize, s_nCurrentLine, asOutput);

	// 更新時刻取得。
	if (piDate.nStart != 0 || piDate.nCount != 0)
	{
		_fiInfo->tmModify.ParseFormat(piDate.nCount == 0 ? asOutput[s_nCurrentLine + piDate.nLine].Mid(piDate.nStart) : asOutput[s_nCurrentLine + piDate.nLine].Mid(piDate.nStart, piDate.nCount), szDateFormat);
	}

	// 最後に次の行へ進めておく。
	_fiInfo->nFileId = s_nFileId++;
	s_nCurrentLine += nProcessPerLine;

	return TPI_ERROR_SUCCESS;
}

int __stdcall GetArchiveInformation
(
	void *,
	TPI_ARCHIVEINFO * _aiInfo
)
{
	// 形式に関する情報を取得。
	MakeFormatInfo(& g_LibInfo.node, wxT("cuiWrapper"), & _aiInfo->fiInfo, 0);
	return TPI_ERROR_SUCCESS;
}

int __stdcall Command
(
	wxULongLong_t _eCommand,
	TPI_SWITCHES * _swInfo,
	const wxString & _szArcName,
	const wxArrayString & _szFiles
)
{
	// xmlからコマンドラインを取得。
	wxString szPath, szCommandLine;

	// APIアドレス取得。
	if (! g_LibInfo.node.GetAttribute(
			_eCommand == TPI_COMMAND_CREATE  ? wxT("create") :
			_eCommand == TPI_COMMAND_ADD     ? wxT("add") :
			_eCommand == TPI_COMMAND_EXTRACT ? wxT("extract") : 
			_eCommand == TPI_COMMAND_DELETE  ? wxT("delete") : 
			_eCommand == TPI_COMMAND_UPDATE  ? wxT("update") : 
			_eCommand == TPI_COMMAND_TEST    ? wxT("test") : 
			_eCommand == TPI_COMMAND_REPAIR  ? wxT("repair") : 
			_eCommand == TPI_COMMAND_MOVE    ? wxT("move") : 
			_eCommand == TPI_COMMAND_SFX     ? wxT("sfx") : 
			_eCommand == TPI_COMMAND_UNSFX   ? wxT("unsfx") : wxEmptyString, & szCommandLine))
	{
		g_LibInfo.node.GetAttribute(
			_eCommand == TPI_COMMAND_CREATE  ? wxT("create-alt") :
			_eCommand == TPI_COMMAND_ADD     ? wxT("add-alt") :
			_eCommand == TPI_COMMAND_EXTRACT ? wxT("extract-alt") : 
			_eCommand == TPI_COMMAND_DELETE  ? wxT("delete-alt") : 
			_eCommand == TPI_COMMAND_UPDATE  ? wxT("update-alt") : 
			_eCommand == TPI_COMMAND_TEST    ? wxT("test-alt") : 
			_eCommand == TPI_COMMAND_REPAIR  ? wxT("repair-alt") : 
			_eCommand == TPI_COMMAND_MOVE    ? wxT("move-alt") : 
			_eCommand == TPI_COMMAND_SFX     ? wxT("sfx-alt") : 
			_eCommand == TPI_COMMAND_UNSFX   ? wxT("unsfx-alt") : wxEmptyString, & szCommandLine);
	}

	if (szCommandLine.IsEmpty())
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}

	// コマンドライン・レスポンスファイル作成。
	wxString
		szResponceFileName = MakeResponceFile(_szFiles, myGetAttributeBool(& g_LibInfo.node, wxT("quote-resp"), true)),
		szCommandLineSend  = MakeCommandLineSend(szCommandLine, _szArcName, _swInfo, _szFiles, szResponceFileName);

	// コマンドライン実行。
	wxString szOutput;
	int nErrorCode = myExecute(g_LibInfo.szExeFile + wxT(" ") + szCommandLineSend, & szOutput, _swInfo->fnDestinationDirectory.GetFullPath(), g_LibInfo.szExeFile.Find(wxT('.')) != wxNOT_FOUND && g_LibInfo.szExeFile.AfterLast(wxT('.')) == wxT("exe"));

	// レスポンスファイル削除。
	::wxRemoveFile(szResponceFileName);

	if (nErrorCode != TPI_ERROR_SUCCESS)
	{
		wxLogError(L"Error :\n%x\n\nCommandLine:\n%s\n\nOutput:\n%s", nErrorCode, szCommandLineSend.c_str(), szOutput.c_str());
	}
	return nErrorCode;
}

int __stdcall SetCallbackProc
(
	TPI_PROC _prArcProc
)
{
	// ポインタを保存。
	if (_prArcProc == NULL)
	{
		return TPI_ERROR_D_PARAMETER;
	}
	g_prProc = * _prArcProc;

	return TPI_ERROR_SUCCESS;
}

#ifdef __cplusplus
}
#endif
