/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: cls_filedroptarget.cpp 518 2011-03-25 08:23:57Z sirakaba $
*******************************************************************************/

#include "lychee.h"

#include "frm_main.h"
#include "cls_filedroptarget.h"

//******************************************************************************
// myFileDropTarget
//******************************************************************************

myFileDropTarget::myFileDropTarget(MainFrame * mainFrame)
{
	this->mainFrame = mainFrame;
}

//******************************************************************************
// Event handler.
//******************************************************************************

#if ! wxCHECK_VERSION(2, 9, 0)
#define wxThreadEvent wxCommandEvent
#endif

bool myFileDropTarget::OnDropFiles(wxCoord, wxCoord, const wxArrayString & asFiles)
{
	wxThreadEvent * e;
	this->as = asFiles;
	if (::wxGetKeyState(WXK_SHIFT) && this->mainFrame->aiArchive.fiInfo.eSupportedCommand & TPI_COMMAND_ADD)
	{
		// 書庫へ追加。
		e = new wxThreadEvent(wxEVT_COMMAND_MENU_SELECTED, XRCID("Arc_Add"));
		e->SetClientData(& this->as);
		e->SetInt(2);
#if wxCHECK_VERSION(2, 9, 0)
		::wxQueueEvent(this->mainFrame, e);
#else
		this->mainFrame->OnArcOpen(* e);
		delete e;
#endif
		return true;
	}

	// ファイルが存在するか確認。
	if (asFiles.GetCount() == 1 && ::wxFileExists(asFiles[0]))
	{
		// 書庫を開く。
		e = new wxThreadEvent(wxEVT_COMMAND_MENU_SELECTED, XRCID("Arc_Open"));
		e->SetClientData(& this->as);
		e->SetInt(2);
		this->mainFrame->fnArchive = wxFileName(asFiles[0]);
#if wxCHECK_VERSION(2, 9, 0)
		::wxQueueEvent(this->mainFrame, e);
#else
		this->mainFrame->OnArcOpen(* e);
		delete e;
#endif
		return true;
	}

	// 対応していない場合は書庫の作成を試みる。
	e = new wxThreadEvent(wxEVT_COMMAND_MENU_SELECTED, XRCID("Arc_Create"));
	e->SetClientData(& this->as);
#if wxCHECK_VERSION(2, 9, 0)
	::wxQueueEvent(this->mainFrame, e);
#else
	this->mainFrame->OnArcCreate(* e);
	delete e;
#endif
	return true;
}

//******************************************************************************
// myFileDataObject
//******************************************************************************

myFileDataObject::~myFileDataObject()
{
	// ファイルを削除。
	for (size_t i = 0; i < this->m_filenames.GetCount(); i++)
	{
		chmod(this->m_filenames[i].ToUTF8(), 0600);
		::wxRemoveFile(this->m_filenames[i]);
	}

	// 一時ディレクトリを削除。
	::wxRmdir(this->szTempDir);
}

#ifdef __LINUX__
// wxGTKのwxFileDataObjectでは多バイト文字の扱いに問題があるので代替。
bool myFileDataObject::GetDataHere(void * buf) const
{
	wxString filenames;
	for (size_t i = 0; i < m_filenames.GetCount(); i++)
	{
		filenames += wxT("file:") + m_filenames[i] + wxT("\r\n");
	}
	memcpy(buf, filenames.mbc_str(), strlen(filenames.mbc_str()) + 1);
	return true;
}

size_t myFileDataObject::GetDataSize() const
{
	size_t res = 1;
	for (size_t i = 0; i < m_filenames.GetCount(); i++)
	{
		res += strlen(m_filenames[i].mbc_str()) + 5 + 2; // "file:" (5) + "\r\n" (2)
	}
	return res;
}

void myFileDataObject::AddFile(const wxString & filename)
{
	m_filenames.Add(filename);
}
#endif
