<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns    ="http://www.w3.org/1999/xhtml"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:template match="/">
 <xsl:apply-templates select="libraries" />
</xsl:template>

<xsl:template match="libraries">
 <html xml:lang="ja">
  <head>
   <title>Configuration file</title>
   <meta http-equiv="content-type" content="application/xhtml+xml; charset=utf-8" />
   <link rel="stylesheet" href="../../doc/style.css" type="text/css" />
  </head>
  <body>
   <h1>Configuration file</h1>
   <h2 id="about">About</h2>
   <p>This is TPI configuration XML file. The schema of this file is <a href="../../doc/schema.xsd">schema.xsd</a>.</p>
   <xsl:apply-templates select="library" />
  </body>
 </html>
</xsl:template>

<xsl:template name="command">
 <xsl:param name="cmd" />
 <xsl:param name="cmdline" />
 <xsl:param name="mode">0</xsl:param>
 <xsl:if test="$cmdline!=''">
  <tr>
   <td>
    <xsl:choose>
     <xsl:when test="$mode=1">
      <xsl:attribute name="style">background-color: #fff0f0</xsl:attribute>
      <xsl:attribute name="title">This command is passed to alternative library.</xsl:attribute>
     </xsl:when>
     <xsl:when test="$mode=2 or @disable=1">
      <xsl:attribute name="style">background-color: #f0f0f0</xsl:attribute>
      <xsl:attribute name="title">This command is disabled.</xsl:attribute>
     </xsl:when>
     <xsl:when test="@disable-win=1">
      <xsl:attribute name="style">background-color: #f0f0f0</xsl:attribute>
      <xsl:attribute name="title">This command is disabled under Windows.</xsl:attribute>
     </xsl:when>
     <xsl:when test="@disable-lin=1">
      <xsl:attribute name="style">background-color: #f0f0f0</xsl:attribute>
      <xsl:attribute name="title">This command is disabled under Linux.</xsl:attribute>
     </xsl:when>
    </xsl:choose>
    <xsl:value-of select="$cmd" />
   </td>
   <td><code><xsl:value-of select="$cmdline" /></code></td>
  </tr>
 </xsl:if>
</xsl:template>

<xsl:template name="name">
 <xsl:param name="alt">0</xsl:param>
 <strong>
  <xsl:if test="($alt=0 and @prefix!='') or ($alt=1 and @prefix-alt!='')">
   <xsl:attribute name="title">Prefix:
    <xsl:choose>
     <xsl:when test="$alt=0"><xsl:value-of select="@prefix" /></xsl:when>
     <xsl:when test="$alt=1"><xsl:value-of select="@prefix-alt" /></xsl:when>
    </xsl:choose>
   </xsl:attribute>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="$alt=0"><xsl:value-of select="@name" /></xsl:when>
   <xsl:when test="$alt=1"><xsl:value-of select="@name-alt" /></xsl:when>
  </xsl:choose>
 </strong>
</xsl:template>

<xsl:template match="library">
 <h2>
  <xsl:value-of select="@name" />
  <xsl:if test="@name-alt!=''"> / <xsl:value-of select="@name-alt" /></xsl:if>
 </h2>
 <p>
  <xsl:call-template name="name" /> is library for the type <em><xsl:value-of select="@typename" /></em>(extension is &quot;<xsl:value-of select="translate(@suffix, ';', ',')" />&quot;).
  <xsl:if test="@name-alt!=''">
   <xsl:call-template name="name">
    <xsl:with-param name="alt">1</xsl:with-param>
   </xsl:call-template>
    is used as alternative library.
  </xsl:if>
 </p>
 <table>
  <thead>
   <tr><th>Command</th><th>Command line passed to library</th></tr>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">list</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@list" /></xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">list</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@list-alt" /></xsl:with-param>
    <xsl:with-param name="mode">1</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">create</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@create" /></xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">create</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@create-alt" /></xsl:with-param>
    <xsl:with-param name="mode">1</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">create</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@create-disabled" /></xsl:with-param>
    <xsl:with-param name="mode">2</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">add</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@add" /></xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">add</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@add-alt" /></xsl:with-param>
    <xsl:with-param name="mode">1</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">add</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@add-disabled" /></xsl:with-param>
    <xsl:with-param name="mode">2</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">extract</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@extract" /></xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">extract</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@extract-alt" /></xsl:with-param>
    <xsl:with-param name="mode">1</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">extract</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@extract-disabled" /></xsl:with-param>
    <xsl:with-param name="mode">2</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">delete</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@delete" /></xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">delete</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@delete-alt" /></xsl:with-param>
    <xsl:with-param name="mode">1</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">delete</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@delete-disabled" /></xsl:with-param>
    <xsl:with-param name="mode">2</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">update</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@update" /></xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">update</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@update-alt" /></xsl:with-param>
    <xsl:with-param name="mode">1</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">update</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@update-disabled" /></xsl:with-param>
    <xsl:with-param name="mode">2</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">test</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@test" /></xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">test</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@test-alt" /></xsl:with-param>
    <xsl:with-param name="mode">1</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">test</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@test-disabled" /></xsl:with-param>
    <xsl:with-param name="mode">2</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">repair</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@repair" /></xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">repair</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@repair-alt" /></xsl:with-param>
    <xsl:with-param name="mode">1</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">repair</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@repair-disabled" /></xsl:with-param>
    <xsl:with-param name="mode">2</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">move</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@move" /></xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">move</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@move-alt" /></xsl:with-param>
    <xsl:with-param name="mode">1</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">move</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@move-disabled" /></xsl:with-param>
    <xsl:with-param name="mode">2</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">sfx</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@sfx" /></xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">sfx</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@sfx-alt" /></xsl:with-param>
    <xsl:with-param name="mode">1</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">sfx</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@sfx-disabled" /></xsl:with-param>
    <xsl:with-param name="mode">2</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">unsfx</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@unsfx" /></xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">unsfx</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@unsfx-alt" /></xsl:with-param>
    <xsl:with-param name="mode">1</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="command">
    <xsl:with-param name="cmd">unsfx</xsl:with-param>
    <xsl:with-param name="cmdline"><xsl:value-of select="@unsfx-disabled" /></xsl:with-param>
    <xsl:with-param name="mode">2</xsl:with-param>
   </xsl:call-template>
  </thead>
  <tbody>
  </tbody>
 </table>
</xsl:template>

</xsl:stylesheet>