/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.component;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jp.snowgoose.treno.component.InstanceProvider;
import jp.snowgoose.treno.component.UniqueAddon;
import jp.snowgoose.treno.util.ClassCollector;
import jp.snowgoose.treno.util.ReflectionUtils;
import jp.snowgoose.treno.util.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scanner {
    private Collection<ClassCollector> classCollectors;
    private InstanceProvider instanceProvider;

    public Scanner(Collection<ClassCollector> classCollectors, InstanceProvider instanceProvider) {
        this(classCollectors);
        this.instanceProvider = instanceProvider;
    }

    public Scanner(Collection<ClassCollector> classCollectors) {
        this.classCollectors = classCollectors;
    }

    public Scanned scan(Collection<String> packageNames) {
        return this.scan(packageNames.toArray(new String[packageNames.size()]));
    }

    public Scanned scan(String[] packageNames) {
        ArrayList collectedClasses = new ArrayList();
        for (String packageName : packageNames) {
            for (URL resourceURL : this.getPackageResources(packageName)) {
                for (ClassCollector collector : this.classCollectors) {
                    collectedClasses.addAll(collector.collect(packageName, resourceURL));
                }
            }
        }
        return new Scanned(collectedClasses, this.instanceProvider);
    }

    private List<URL> getPackageResources(String packageName) {
        return ResourceUtils.findResources(packageName.replace('.', '/'));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Scanned {
        private Collection<Class<?>> collectedClasses;
        private InstanceProvider instanceProvider;

        protected Scanned(Collection<Class<?>> collectedClasses, InstanceProvider instanceProvider) {
            this(collectedClasses);
            this.instanceProvider = instanceProvider;
        }

        protected Scanned(Collection<Class<?>> collectedClasses) {
            this.collectedClasses = collectedClasses;
        }

        public <T> Collection<T> getInstances(Condition<T> condition) {
            ArrayList result = new ArrayList();
            for (Class<?> clazz : this.collectedClasses) {
                Object instance;
                if (!condition.filter(clazz) || (instance = this.instanceProvider.resolveInstance(clazz)) == null) continue;
                result.add(instance);
            }
            return result;
        }

        public <T extends UniqueAddon> T getInstance(Condition<T> condition, String id) {
            for (Class<?> clazz : this.collectedClasses) {
                UniqueAddon unique;
                if (!condition.filter(clazz) || !ReflectionUtils.isImplements(clazz, UniqueAddon.class) || clazz.isInterface() || !(unique = (UniqueAddon)this.instanceProvider.resolveInstance(clazz)).getUniqueId().equals(id)) continue;
                return (T)unique;
            }
            return null;
        }

        public <T> Collection<Class<?>> getClasses(Condition<T> condition) {
            ArrayList result = new ArrayList();
            for (Class<?> clazz : this.collectedClasses) {
                if (!condition.filter(clazz)) continue;
                result.add(clazz);
            }
            return result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ExtendsClass<T>
        implements Condition<T> {
            private Class<T> extendsIf;

            public ExtendsClass(Class<T> extendsIf) {
                this.extendsIf = extendsIf;
            }

            @Override
            public boolean filter(Class<?> clazz) {
                Class<?> superClass = clazz.getSuperclass();
                if (superClass == null || superClass.equals(Object.class)) {
                    return false;
                }
                if (superClass.equals(this.extendsIf)) {
                    return true;
                }
                return this.filter(superClass);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Implements<T>
        implements Condition<T> {
            private Class<T> implementsIf;

            public Implements(Class<T> implementsIf) {
                this.implementsIf = implementsIf;
            }

            @Override
            public boolean filter(Class<?> clazz) {
                return ReflectionUtils.isImplements(clazz, this.implementsIf);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class AnnotateWith<T extends Annotation>
        implements Condition<T> {
            private Class<T> annotateWith;

            public AnnotateWith(Class<T> annotateClass) {
                this.annotateWith = annotateClass;
            }

            @Override
            public boolean filter(Class<?> clazz) {
                return ReflectionUtils.annotateWith(this.annotateWith, clazz);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Conditions {
            public static <T extends Annotation> Condition<T> annotateWith(Class<T> annotateWith) {
                return new AnnotateWith<T>(annotateWith);
            }

            public static <T> Condition<T> implementsInterface(Class<T> clazz) {
                return new Implements<T>(clazz);
            }

            public static <T> Condition<T> extendsClass(Class<T> clazz) {
                return new ExtendsClass<T>(clazz);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Condition<T> {
            public boolean filter(Class<?> var1);
        }
    }
}

