/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.snowgoose.treno.component.ActionInstance;
import jp.snowgoose.treno.context.AbstractRequestValueMapper;
import jp.snowgoose.treno.context.ParameterConverter;
import jp.snowgoose.treno.context.ParameterConverters;
import jp.snowgoose.treno.context.RequestContext;
import jp.snowgoose.treno.metadata.BindDescriptor;
import jp.snowgoose.treno.metadata.BindDescriptors;
import jp.snowgoose.treno.metadata.Scope;
import jp.snowgoose.treno.util.ReflectionUtils;
import jp.snowgoose.treno.util.ThreadLocalMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleValueMapper
extends AbstractRequestValueMapper {
    private Map<Object, Object> responseMap = new ThreadLocalMap<Object, Object>();

    public SimpleValueMapper(RequestContext request, ParameterConverters converters) {
        super(request, converters);
    }

    @Override
    public boolean requestSupported(HttpServletRequest request) {
        return false;
    }

    @Override
    public Object get(Scope scope, String name) {
        if (Scope.PARAMETER == scope) {
            return this.getRequest().getParameter(name);
        }
        if (Scope.REQUEST == scope) {
            String value = this.getRequest().getParameter(name);
            if (value == null) {
                return this.getRequest().getAttribute(name);
            }
            return value;
        }
        if (Scope.SESSION == scope) {
            HttpSession session = this.getRequest().getSession(false);
            if (session == null) {
                return null;
            }
            return session.getAttribute(name);
        }
        if (Scope.RESPONSE == scope) {
            return this.responseMap.get(name);
        }
        return null;
    }

    @Override
    public Map<?, ?> getAll(Scope scope) {
        if (scope == Scope.RESPONSE) {
            return this.responseMap;
        }
        return null;
    }

    @Override
    public void put(String name, Object value, Scope scope) {
        if (Scope.REQUEST == scope) {
            this.getRequest().setAttribute(name, value);
        } else if (Scope.SESSION == scope) {
            this.getRequest().getSession(true).setAttribute(name, value);
        } else if (Scope.RESPONSE == scope) {
            this.responseMap.put(name, value);
        }
    }

    @Override
    public void map(ActionInstance instance) {
        ArrayList args = new ArrayList();
        BindDescriptors bindDescriptors = instance.getActionDescriptor().getBindDescriptors();
        for (BindDescriptor bindDescriptor : bindDescriptors.getAll()) {
            ParameterConverter converter = this.getParameterConverters().getParameterConverter(bindDescriptor.getConverterType());
            Object rowValue = this.get(bindDescriptor.getScope(), bindDescriptor.getName());
            Object value = converter.convert(rowValue, bindDescriptor);
            if (bindDescriptor.bindTypeIs(BindDescriptor.BindElementType.BindType.METHOD)) {
                this.bindToMethod(instance.getInstance(), bindDescriptor, value);
                continue;
            }
            if (bindDescriptor.bindTypeIs(BindDescriptor.BindElementType.BindType.FIELD)) {
                this.bindToField(instance.getInstance(), bindDescriptor, value);
                continue;
            }
            if (!bindDescriptor.bindTypeIs(BindDescriptor.BindElementType.BindType.PARAMETER)) continue;
            args.add(converter.convert(this.get(bindDescriptor.getScope(), bindDescriptor.getName()), bindDescriptor));
        }
        this.mapArgs(instance);
    }

    private void bindToField(Object instance, BindDescriptor bindDescriptor, Object value) {
        BindDescriptor.BindElementType.FieldBindElement element = (BindDescriptor.BindElementType.FieldBindElement)bindDescriptor.getBindElementType();
        ReflectionUtils.setValueToField(element.getFieldName(), element.getModefier(), instance, value);
    }

    private void bindToMethod(Object instance, BindDescriptor bindDescriptor, Object value) {
        BindDescriptor.BindElementType.MethodBindElement element = (BindDescriptor.BindElementType.MethodBindElement)bindDescriptor.getBindElementType();
        ReflectionUtils.invokeMethodSilently(instance, element.getMethodName(), this.getArgTypes(bindDescriptor), value);
    }

    private Class<?>[] getArgTypes(BindDescriptor bindDescriptor) {
        return new Class[]{bindDescriptor.getParameterType()};
    }

    @Override
    public void unmap(ActionInstance instance) {
        BindDescriptors bindDescriptors = instance.getActionDescriptor().getBindDescriptors();
        for (BindDescriptor bindDescriptor : bindDescriptors.getAll()) {
            Object value;
            if (bindDescriptor.bindTypeIs(BindDescriptor.BindElementType.BindType.METHOD)) {
                value = this.getValueViaMethod(instance.getInstance(), (BindDescriptor.BindElementType.MethodBindElement)bindDescriptor.getBindElementType());
                this.put(bindDescriptor.getName(), value, bindDescriptor.getScope());
                continue;
            }
            if (bindDescriptor.bindTypeIs(BindDescriptor.BindElementType.BindType.TYPE)) {
                this.put(bindDescriptor.getName(), instance.getInstance(), bindDescriptor.getScope());
                continue;
            }
            if (!bindDescriptor.bindTypeIs(BindDescriptor.BindElementType.BindType.FIELD)) continue;
            value = this.getValueViaField(instance.getInstance(), (BindDescriptor.BindElementType.FieldBindElement)bindDescriptor.getBindElementType());
            this.put(bindDescriptor.getName(), value, bindDescriptor.getScope());
        }
    }

    private Object getValueViaField(Object invokedInstance, BindDescriptor.BindElementType.FieldBindElement elementType) {
        return ReflectionUtils.getValueViaField(elementType.getFieldName(), elementType.getModefier(), invokedInstance);
    }

    private Object getValueViaMethod(Object invokedInstance, BindDescriptor.BindElementType.MethodBindElement bindDescriptor) {
        return ReflectionUtils.invokeMethodSilently(invokedInstance, bindDescriptor.getMethodName(), new Class[0], new Object[0]);
    }

    private void mapArgs(ActionInstance instance) {
        Collection<BindDescriptor> parameterDescriptors = instance.getActionDescriptor().getBindDescriptors().getParameterBindDescriptors();
        if (!parameterDescriptors.isEmpty()) {
            ArrayList<Object> args = new ArrayList<Object>();
            ParameterConverters converters = this.getParameterConverters();
            for (BindDescriptor bindDesc : parameterDescriptors) {
                ParameterConverter converter = converters.getParameterConverter(bindDesc.getConverterType());
                Object argValue = this.get(bindDesc.getScope(), bindDesc.getName());
                args.add(converter.convert(argValue, bindDesc));
            }
            instance.setPreparedArgs(args);
        }
    }
}

