/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jp.snowgoose.treno.annotation.BindValue;
import jp.snowgoose.treno.annotation.Direction;
import jp.snowgoose.treno.annotation.InvokeAction;
import jp.snowgoose.treno.annotation.InvokeActions;
import jp.snowgoose.treno.metadata.ActionDescriptor;
import jp.snowgoose.treno.metadata.ActionDescriptorFactory;
import jp.snowgoose.treno.metadata.BindDescriptor;
import jp.snowgoose.treno.metadata.BindDescriptors;
import jp.snowgoose.treno.metadata.MappedPath;
import jp.snowgoose.treno.metadata.ResultDescriptor;
import jp.snowgoose.treno.metadata.ResultDescriptors;
import jp.snowgoose.treno.util.Assertion;
import jp.snowgoose.treno.util.Maps;
import jp.snowgoose.treno.util.ReflectionUtils;
import jp.snowgoose.treno.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationActionDescriptorFactory
implements ActionDescriptorFactory {
    private static final Logger log = LoggerFactory.getLogger(AnnotationActionDescriptorFactory.class);
    private final ActionDescriptorFactory.BindDescriptorFactory bindFactory = new AnnotationBindDescriptorFactory();
    private final ActionDescriptorFactory.ResultDescriptorFactory resultFactory = new AnnotationResultDescriptorFactory();

    @Override
    public String getUniqueId() {
        return "annotation";
    }

    @Override
    public Collection<ActionDescriptor> createActionDescriptors(Class<?> clazz) {
        Assertion.notNull(clazz, "ActionClass");
        InvokeActions actions = this.findAction(clazz);
        if (actions != null) {
            return this.findActionDescriptors(clazz, actions);
        }
        log.debug(String.format("action not found at class %s", clazz));
        return Collections.emptyList();
    }

    private List<ActionDescriptor> findActionDescriptors(Class<?> clazz, InvokeActions actions) {
        Method[] methods = clazz.getDeclaredMethods();
        ArrayList<ActionDescriptor> result = new ArrayList<ActionDescriptor>();
        for (Method method : methods) {
            InvokeAction action = method.getAnnotation(InvokeAction.class);
            if (action == null) continue;
            result.add(this.createActionDescriptor(clazz, method, actions, action));
        }
        return result;
    }

    private ActionDescriptor createActionDescriptor(Class<?> clazz, Method method, InvokeActions actions, InvokeAction action) {
        MappedPath mappedPath = new MappedPath(actions.value(), action.path());
        ActionDescriptor.ActionMethod actionMethod = new ActionDescriptor.ActionMethod();
        actionMethod.actionClass = clazz;
        actionMethod.argumentTypes = method.getParameterTypes();
        actionMethod.methodName = method.getName();
        ActionDescriptor actionDesc = new ActionDescriptor();
        actionDesc.actionMethod = actionMethod;
        actionDesc.bindDescriptors = this.bindFactory.createBindDescriptors(clazz, method);
        actionDesc.mappedPath = mappedPath;
        actionDesc.resultDescriptors = this.resultFactory.createResultDescriptors(clazz, action);
        log.info(String.format("action created on %s", mappedPath.getPath()));
        return actionDesc;
    }

    private InvokeActions findAction(Class<?> clazz) {
        return clazz.getAnnotation(InvokeActions.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotationResultDescriptorFactory
    implements ActionDescriptorFactory.ResultDescriptorFactory {
        @Override
        public ResultDescriptors createResultDescriptors(Class<?> clazz, InvokeAction action) {
            Direction[] results;
            ResultDescriptors resultDescs = new ResultDescriptors();
            for (Direction result : results = action.directions()) {
                ResultDescriptor resultDesc = new ResultDescriptor();
                resultDesc.resultType = result.type();
                resultDesc.to = result.to();
                resultDesc.when = result.when();
                resultDescs.put(resultDesc);
            }
            return resultDescs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotationBindDescriptorFactory
    implements ActionDescriptorFactory.BindDescriptorFactory {
        private static final Map<Class<?>, Class<?>> primitiveWrapMap = Maps.newLinkedHashMap();

        @Override
        public BindDescriptors createBindDescriptors(Class<?> clazz, Method actionMethod) {
            BindDescriptors bindDescriptors = new BindDescriptors();
            bindDescriptors.put(this.createClassBindDescriptor(clazz));
            bindDescriptors.putAll(this.createMethodBindDescriptors(clazz));
            bindDescriptors.putAll(this.createFieldBindDescriptors(clazz));
            int length = actionMethod.getParameterTypes().length;
            for (int i = 0; i < length; ++i) {
                bindDescriptors.put(this.createParameterBindDescriptor(actionMethod, i));
            }
            return bindDescriptors;
        }

        private BindDescriptor createClassBindDescriptor(Class<?> clazz) {
            BindValue classBind = clazz.getAnnotation(BindValue.class);
            if (classBind != null) {
                BindDescriptor bindDesc = new BindDescriptor();
                String name = classBind.value();
                if (StringUtils.isEmpty(name)) {
                    name = StringUtils.decapitalize(clazz.getSimpleName());
                }
                bindDesc.name = name;
                bindDesc.bindElementType = new BindDescriptor.BindElementType.TypeBindElement(clazz);
                bindDesc.parameterType = clazz;
                bindDesc.scope = classBind.scope();
                return bindDesc;
            }
            return null;
        }

        private Collection<BindDescriptor> createFieldBindDescriptors(Class<?> clazz) {
            ArrayList<BindDescriptor> bindDescriptors = new ArrayList<BindDescriptor>();
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                BindValue bind = field.getAnnotation(BindValue.class);
                if (bind == null) continue;
                BindDescriptor bindDesc = new BindDescriptor();
                String name = bind.value();
                if (StringUtils.isEmpty(name)) {
                    name = field.getName();
                }
                bindDesc.name = name;
                bindDesc.bindElementType = new BindDescriptor.BindElementType.FieldBindElement(field.getModifiers(), field.getName());
                bindDesc.parameterType = field.getType();
                bindDesc.scope = bind.scope();
                bindDesc.format = bind.format();
                bindDesc.converterType = bind.converter();
                bindDescriptors.add(bindDesc);
            }
            return bindDescriptors;
        }

        private Collection<BindDescriptor> createMethodBindDescriptors(Class<?> clazz) {
            ArrayList<BindDescriptor> bindDescriptors = new ArrayList<BindDescriptor>();
            for (Method method : clazz.getDeclaredMethods()) {
                BindValue bind;
                if (!method.getName().startsWith("get") || (bind = method.getAnnotation(BindValue.class)) == null || method.getAnnotation(InvokeAction.class) != null) continue;
                BindDescriptor bindDesc = new BindDescriptor();
                String name = bind.value();
                if (StringUtils.isEmpty(name)) {
                    name = this.removeGet(method.getName());
                }
                bindDesc.name = name;
                bindDesc.bindElementType = new BindDescriptor.BindElementType.MethodBindElement(method.getName());
                bindDesc.parameterType = method.getReturnType();
                bindDesc.scope = bind.scope();
                bindDesc.format = bind.format();
                bindDesc.converterType = bind.converter();
                bindDescriptors.add(bindDesc);
            }
            return bindDescriptors;
        }

        private String removeGet(String methodName) {
            if (methodName.startsWith("get")) {
                return methodName.substring(3, methodName.length()).toLowerCase(Locale.getDefault());
            }
            return methodName;
        }

        private BindDescriptor createParameterBindDescriptor(Method method, int parameterIndex) {
            BindValue bind = ReflectionUtils.getMethodParameterAnnotation(method, BindValue.class, parameterIndex);
            if (bind != null) {
                BindDescriptor bindDesc = new BindDescriptor();
                bindDesc.bindElementType = new BindDescriptor.BindElementType.ParameterBindElement(parameterIndex);
                bindDesc.name = bind.value();
                bindDesc.scope = bind.scope();
                Class<?> type = method.getParameterTypes()[parameterIndex];
                bindDesc.parameterType = type.isPrimitive() ? this.wrapPrimitive(type) : type;
                bindDesc.format = bind.format();
                bindDesc.converterType = bind.converter();
                return bindDesc;
            }
            return null;
        }

        private Class<?> wrapPrimitive(Class<?> type) {
            Class<?> result = primitiveWrapMap.get(type);
            if (result != null) {
                return result;
            }
            return type;
        }

        static {
            primitiveWrapMap.put(Boolean.TYPE, Boolean.class);
            primitiveWrapMap.put(Byte.TYPE, Byte.class);
            primitiveWrapMap.put(Character.TYPE, Character.class);
            primitiveWrapMap.put(Short.TYPE, Short.class);
            primitiveWrapMap.put(Float.TYPE, Float.class);
            primitiveWrapMap.put(Double.TYPE, Double.class);
            primitiveWrapMap.put(Integer.TYPE, Integer.class);
            primitiveWrapMap.put(Long.TYPE, Long.class);
        }
    }
}

