/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.result;

import jp.snowgoose.treno.context.RequestContext;
import jp.snowgoose.treno.context.RequestValueMapper;
import jp.snowgoose.treno.metadata.ResultDescriptor;
import jp.snowgoose.treno.result.InvocationResult;
import jp.snowgoose.treno.result.type.DirectionType;
import jp.snowgoose.treno.result.type.DirectionTypes;

public class InvocationResultEvaluator {
    private final InvocationResult result;
    private final DirectionTypes resultTypeRegistry;
    private final RequestContext context;
    private final RequestValueMapper valueMapper;

    public InvocationResultEvaluator(InvocationResult result, DirectionTypes resultTypeRegistry, RequestContext context, RequestValueMapper valueMapper) {
        this.result = result;
        this.resultTypeRegistry = resultTypeRegistry;
        this.context = context;
        this.valueMapper = valueMapper;
    }

    public void evaluate() {
        ResultDescriptor resultDesc = this.result.getInvokedInstance().getActionDescriptor().getResultDescriptors().getResultDescriptor(this.result.getResultStatus());
        DirectionType type = this.resultTypeRegistry.getResultType(resultDesc.getResultType());
        this.valueMapper.unmap(this.result.getInvokedInstance());
        type.render(this.context, this.valueMapper, this.result.getInvokedInstance(), resultDesc);
    }
}

