/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.util;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import jp.snowgoose.treno.util.ClassCollector;
import jp.snowgoose.treno.util.ClassUtils;
import jp.snowgoose.treno.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileClassCollector
implements ClassCollector {
    private static final Logger log = LoggerFactory.getLogger(FileClassCollector.class);

    public Collection<Class> collect(String packageName, URL url) {
        File[] files;
        if (packageName == null || url == null || !url.getProtocol().equals("file")) {
            return Collections.EMPTY_LIST;
        }
        File root = new File(url.getPath());
        HashSet<Class> classes = new HashSet<Class>();
        for (File file : files = root.listFiles()) {
            String fileName = file.getName();
            if (file.isDirectory()) {
                String newPackageName = packageName + "." + fileName;
                classes.addAll(this.collect(newPackageName, ResourceUtils.findResource('/' + file.getPath(), Arrays.asList(ResourceUtils.FindResourceStrategies.FILE))));
                continue;
            }
            if (!fileName.endsWith(".class")) continue;
            String shortClassName = fileName.substring(0, fileName.length() - ".class".length());
            Class<?> clazz = ClassUtils.forNameSilentry(packageName + "." + shortClassName);
            if (log.isDebugEnabled()) {
                log.debug("adding found class resource : " + clazz);
            }
            classes.add(clazz);
        }
        return classes;
    }
}

