/* A Bison parser, made by GNU Bison 1.875c.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse MYSQLparse
#define yylex   MYSQLlex
#define yyerror MYSQLerror
#define yylval  MYSQLlval
#define yychar  MYSQLchar
#define yydebug MYSQLdebug
#define yynerrs MYSQLnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     END_OF_INPUT = 258,
     ABORT_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     ATAN = 277,
     AUTO_INC = 278,
     AVG_ROW_LENGTH = 279,
     AVG_SYM = 280,
     BACKUP_SYM = 281,
     BEFORE_SYM = 282,
     BEGIN_SYM = 283,
     BENCHMARK_SYM = 284,
     BERKELEY_DB_SYM = 285,
     BIGINT = 286,
     BINARY = 287,
     BINLOG_SYM = 288,
     BIN_NUM = 289,
     BIT_AND = 290,
     BIT_OR = 291,
     BIT_SYM = 292,
     BIT_XOR = 293,
     BLOB_SYM = 294,
     BLOCK_SYM = 295,
     BOOLEAN_SYM = 296,
     BOOL_SYM = 297,
     BOTH = 298,
     BTREE_SYM = 299,
     BY = 300,
     BYTE_SYM = 301,
     CACHE_SYM = 302,
     CALL_SYM = 303,
     CASCADE = 304,
     CASCADED = 305,
     CAST_SYM = 306,
     CHAIN_SYM = 307,
     CHANGE = 308,
     CHANGED = 309,
     CHARSET = 310,
     CHAR_SYM = 311,
     CHECKSUM_SYM = 312,
     CHECK_SYM = 313,
     CIPHER_SYM = 314,
     CLIENT_SYM = 315,
     CLOSE_SYM = 316,
     COALESCE = 317,
     CODE_SYM = 318,
     COLLATE_SYM = 319,
     COLLATION_SYM = 320,
     COLUMNS = 321,
     COLUMN_SYM = 322,
     COMMENT_SYM = 323,
     COMMITTED_SYM = 324,
     COMMIT_SYM = 325,
     COMPACT_SYM = 326,
     COMPRESSED_SYM = 327,
     CONCAT = 328,
     CONCAT_WS = 329,
     CONCURRENT = 330,
     CONDITION_SYM = 331,
     CONNECTION_SYM = 332,
     CONSISTENT_SYM = 333,
     CONSTRAINT = 334,
     CONTAINS_SYM = 335,
     CONTEXT_SYM = 336,
     CONTINUE_SYM = 337,
     CONVERT_SYM = 338,
     CONVERT_TZ_SYM = 339,
     COUNT_SYM = 340,
     CPU_SYM = 341,
     CREATE = 342,
     CROSS = 343,
     CUBE_SYM = 344,
     CURDATE = 345,
     CURRENT_USER = 346,
     CURSOR_SYM = 347,
     CURTIME = 348,
     DATABASE = 349,
     DATABASES = 350,
     DATA_SYM = 351,
     DATETIME = 352,
     DATE_ADD_INTERVAL = 353,
     DATE_SUB_INTERVAL = 354,
     DATE_SYM = 355,
     DAY_HOUR_SYM = 356,
     DAY_MICROSECOND_SYM = 357,
     DAY_MINUTE_SYM = 358,
     DAY_SECOND_SYM = 359,
     DAY_SYM = 360,
     DEALLOCATE_SYM = 361,
     DECIMAL_NUM = 362,
     DECIMAL_SYM = 363,
     DECLARE_SYM = 364,
     DECODE_SYM = 365,
     DEFAULT = 366,
     DEFINER_SYM = 367,
     DELAYED_SYM = 368,
     DELAY_KEY_WRITE_SYM = 369,
     DELETE_SYM = 370,
     DESC = 371,
     DESCRIBE = 372,
     DES_DECRYPT_SYM = 373,
     DES_ENCRYPT_SYM = 374,
     DES_KEY_FILE = 375,
     DETERMINISTIC_SYM = 376,
     DIRECTORY_SYM = 377,
     DISABLE_SYM = 378,
     DISCARD = 379,
     DISTINCT = 380,
     DIV_SYM = 381,
     DOUBLE_SYM = 382,
     DO_SYM = 383,
     DROP = 384,
     DUAL_SYM = 385,
     DUMPFILE = 386,
     DUPLICATE_SYM = 387,
     DYNAMIC_SYM = 388,
     EACH_SYM = 389,
     ELSEIF_SYM = 390,
     ELT_FUNC = 391,
     ENABLE_SYM = 392,
     ENCLOSED = 393,
     ENCODE_SYM = 394,
     ENCRYPT = 395,
     END = 396,
     ENGINES_SYM = 397,
     ENGINE_SYM = 398,
     ENUM = 399,
     EQ = 400,
     EQUAL_SYM = 401,
     ERRORS = 402,
     ESCAPED = 403,
     ESCAPE_SYM = 404,
     EVENTS_SYM = 405,
     EXECUTE_SYM = 406,
     EXISTS = 407,
     EXIT_SYM = 408,
     EXPANSION_SYM = 409,
     EXPORT_SET = 410,
     EXTENDED_SYM = 411,
     EXTRACT_SYM = 412,
     FALSE_SYM = 413,
     FAST_SYM = 414,
     FAULTS_SYM = 415,
     FETCH_SYM = 416,
     FIELD_FUNC = 417,
     FILE_SYM = 418,
     FIRST_SYM = 419,
     FIXED_SYM = 420,
     FLOAT_NUM = 421,
     FLOAT_SYM = 422,
     FLUSH_SYM = 423,
     FORCE_SYM = 424,
     FOREIGN = 425,
     FORMAT_SYM = 426,
     FOR_SYM = 427,
     FOUND_SYM = 428,
     FRAC_SECOND_SYM = 429,
     FROM = 430,
     FROM_UNIXTIME = 431,
     FULL = 432,
     FULLTEXT_SYM = 433,
     FUNCTION_SYM = 434,
     FUNC_ARG0 = 435,
     FUNC_ARG1 = 436,
     FUNC_ARG2 = 437,
     FUNC_ARG3 = 438,
     GE = 439,
     GEOMCOLLFROMTEXT = 440,
     GEOMETRYCOLLECTION = 441,
     GEOMETRY_SYM = 442,
     GEOMFROMTEXT = 443,
     GEOMFROMWKB = 444,
     GET_FORMAT = 445,
     GLOBAL_SYM = 446,
     GRANT = 447,
     GRANTS = 448,
     GREATEST_SYM = 449,
     GROUP = 450,
     GROUP_CONCAT_SYM = 451,
     GROUP_UNIQUE_USERS = 452,
     GT_SYM = 453,
     HANDLER_SYM = 454,
     HASH_SYM = 455,
     HAVING = 456,
     HELP_SYM = 457,
     HEX_NUM = 458,
     HIGH_PRIORITY = 459,
     HOSTS_SYM = 460,
     HOUR_MICROSECOND_SYM = 461,
     HOUR_MINUTE_SYM = 462,
     HOUR_SECOND_SYM = 463,
     HOUR_SYM = 464,
     IDENT = 465,
     IDENTIFIED_SYM = 466,
     IDENT_QUOTED = 467,
     IF = 468,
     IGNORE_SYM = 469,
     IMPORT = 470,
     INDEXES = 471,
     INDEX_SYM = 472,
     INFILE = 473,
     INNER_SYM = 474,
     INNOBASE_SYM = 475,
     INOUT_SYM = 476,
     INSENSITIVE_SYM = 477,
     INSERT = 478,
     INSERT_METHOD = 479,
     INTERVAL_SYM = 480,
     INTO = 481,
     INT_SYM = 482,
     INVOKER_SYM = 483,
     IN_SYM = 484,
     IO_SYM = 485,
     IPC_SYM = 486,
     IS = 487,
     ISOLATION = 488,
     ISSUER_SYM = 489,
     ITERATE_SYM = 490,
     JOIN_SYM = 491,
     KEYS = 492,
     KEY_SYM = 493,
     KILL_SYM = 494,
     LABEL_SYM = 495,
     LANGUAGE_SYM = 496,
     LAST_INSERT_ID = 497,
     LAST_SYM = 498,
     LE = 499,
     LEADING = 500,
     LEAST_SYM = 501,
     LEAVES = 502,
     LEAVE_SYM = 503,
     LEFT = 504,
     LEVEL_SYM = 505,
     LEX_HOSTNAME = 506,
     LIKE = 507,
     LIMIT = 508,
     LINEFROMTEXT = 509,
     LINES = 510,
     LINESTRING = 511,
     LOAD = 512,
     LOCAL_SYM = 513,
     LOCATE = 514,
     LOCATOR_SYM = 515,
     LOCKS_SYM = 516,
     LOCK_SYM = 517,
     LOGS_SYM = 518,
     LOG_SYM = 519,
     LONGBLOB = 520,
     LONGTEXT = 521,
     LONG_NUM = 522,
     LONG_SYM = 523,
     LOOP_SYM = 524,
     LOW_PRIORITY = 525,
     LT = 526,
     MAKE_SET_SYM = 527,
     MASTER_CONNECT_RETRY_SYM = 528,
     MASTER_HOST_SYM = 529,
     MASTER_LOG_FILE_SYM = 530,
     MASTER_LOG_POS_SYM = 531,
     MASTER_PASSWORD_SYM = 532,
     MASTER_PORT_SYM = 533,
     MASTER_POS_WAIT = 534,
     MASTER_SERVER_ID_SYM = 535,
     MASTER_SSL_CAPATH_SYM = 536,
     MASTER_SSL_CA_SYM = 537,
     MASTER_SSL_CERT_SYM = 538,
     MASTER_SSL_CIPHER_SYM = 539,
     MASTER_SSL_KEY_SYM = 540,
     MASTER_SSL_SYM = 541,
     MASTER_SYM = 542,
     MASTER_USER_SYM = 543,
     MATCH = 544,
     MAX_CONNECTIONS_PER_HOUR = 545,
     MAX_QUERIES_PER_HOUR = 546,
     MAX_ROWS = 547,
     MAX_SYM = 548,
     MAX_UPDATES_PER_HOUR = 549,
     MAX_USER_CONNECTIONS_SYM = 550,
     MEDIUMBLOB = 551,
     MEDIUMINT = 552,
     MEDIUMTEXT = 553,
     MEDIUM_SYM = 554,
     MEMORY_SYM = 555,
     MERGE_SYM = 556,
     MICROSECOND_SYM = 557,
     MIGRATE_SYM = 558,
     MINUTE_MICROSECOND_SYM = 559,
     MINUTE_SECOND_SYM = 560,
     MINUTE_SYM = 561,
     MIN_ROWS = 562,
     MIN_SYM = 563,
     MLINEFROMTEXT = 564,
     MODE_SYM = 565,
     MODIFIES_SYM = 566,
     MODIFY_SYM = 567,
     MOD_SYM = 568,
     MONTH_SYM = 569,
     MPOINTFROMTEXT = 570,
     MPOLYFROMTEXT = 571,
     MULTILINESTRING = 572,
     MULTIPOINT = 573,
     MULTIPOLYGON = 574,
     MUTEX_SYM = 575,
     NAMES_SYM = 576,
     NAME_SYM = 577,
     NATIONAL_SYM = 578,
     NATURAL = 579,
     NCHAR_STRING = 580,
     NCHAR_SYM = 581,
     NDBCLUSTER_SYM = 582,
     NE = 583,
     NEW_SYM = 584,
     NEXT_SYM = 585,
     NONE_SYM = 586,
     NOT2_SYM = 587,
     NOT_SYM = 588,
     NOW_SYM = 589,
     NO_SYM = 590,
     NO_WRITE_TO_BINLOG = 591,
     NULL_SYM = 592,
     NUM = 593,
     NUMERIC_SYM = 594,
     NVARCHAR_SYM = 595,
     OFFSET_SYM = 596,
     OJ_SYM = 597,
     OLD_PASSWORD = 598,
     ON = 599,
     ONE_SHOT_SYM = 600,
     ONE_SYM = 601,
     OPEN_SYM = 602,
     OPTIMIZE = 603,
     OPTION = 604,
     OPTIONALLY = 605,
     OR2_SYM = 606,
     ORDER_SYM = 607,
     OR_OR_SYM = 608,
     OR_SYM = 609,
     OUTER = 610,
     OUTFILE = 611,
     OUT_SYM = 612,
     PACK_KEYS_SYM = 613,
     PAGE_SYM = 614,
     PARTIAL = 615,
     PASSWORD = 616,
     PARAM_MARKER = 617,
     PHASE_SYM = 618,
     POINTFROMTEXT = 619,
     POINT_SYM = 620,
     POLYFROMTEXT = 621,
     POLYGON = 622,
     POSITION_SYM = 623,
     PRECISION = 624,
     PREPARE_SYM = 625,
     PREV_SYM = 626,
     PRIMARY_SYM = 627,
     PRIVILEGES = 628,
     PROCEDURE = 629,
     PROCESS = 630,
     PROCESSLIST_SYM = 631,
     PROFILE_SYM = 632,
     PROFILES_SYM = 633,
     PURGE = 634,
     QUARTER_SYM = 635,
     QUERY_SYM = 636,
     QUICK = 637,
     RAID_0_SYM = 638,
     RAID_CHUNKS = 639,
     RAID_CHUNKSIZE = 640,
     RAID_STRIPED_SYM = 641,
     RAID_TYPE = 642,
     RAND = 643,
     READS_SYM = 644,
     READ_SYM = 645,
     REAL = 646,
     RECOVER_SYM = 647,
     REDUNDANT_SYM = 648,
     REFERENCES = 649,
     REGEXP = 650,
     RELAY_LOG_FILE_SYM = 651,
     RELAY_LOG_POS_SYM = 652,
     RELAY_THREAD = 653,
     RELEASE_SYM = 654,
     RELOAD = 655,
     RENAME = 656,
     REPAIR = 657,
     REPEATABLE_SYM = 658,
     REPEAT_SYM = 659,
     REPLACE = 660,
     REPLICATION = 661,
     REQUIRE_SYM = 662,
     RESET_SYM = 663,
     RESOURCES = 664,
     RESTORE_SYM = 665,
     RESTRICT = 666,
     RESUME_SYM = 667,
     RETURNS_SYM = 668,
     RETURN_SYM = 669,
     REVOKE = 670,
     RIGHT = 671,
     ROLLBACK_SYM = 672,
     ROLLUP_SYM = 673,
     ROUND = 674,
     ROUTINE_SYM = 675,
     ROWS_SYM = 676,
     ROW_COUNT_SYM = 677,
     ROW_FORMAT_SYM = 678,
     ROW_SYM = 679,
     RTREE_SYM = 680,
     SAVEPOINT_SYM = 681,
     SECOND_MICROSECOND_SYM = 682,
     SECOND_SYM = 683,
     SECURITY_SYM = 684,
     SELECT_SYM = 685,
     SENNA_DELIMITED_SYM = 686,
     SENNA_KWIC_SYM = 687,
     SENNA_MECAB_SYM = 688,
     SENNA_NGRAM_SYM = 689,
     SENNA_NORMALIZE_SYM = 690,
     SENNA_SECTIONALIZE_SYM = 691,
     SENNA_SPLIT_ALPHA_SYM = 692,
     SENNA_SPLIT_DIGIT_SYM = 693,
     SENNA_SPLIT_SYMBOL_SYM = 694,
     SENNA_SYM = 695,
     SENSITIVE_SYM = 696,
     SEPARATOR_SYM = 697,
     SERIALIZABLE_SYM = 698,
     SERIAL_SYM = 699,
     SESSION_SYM = 700,
     SET = 701,
     SET_VAR = 702,
     SHARE_SYM = 703,
     SHIFT_LEFT = 704,
     SHIFT_RIGHT = 705,
     SHOW = 706,
     SHUTDOWN = 707,
     SIGNED_SYM = 708,
     SIMPLE_SYM = 709,
     SLAVE = 710,
     SMALLINT = 711,
     SNAPSHOT_SYM = 712,
     SOUNDS_SYM = 713,
     SOURCE_SYM = 714,
     SPATIAL_SYM = 715,
     SPECIFIC_SYM = 716,
     SQLEXCEPTION_SYM = 717,
     SQLSTATE_SYM = 718,
     SQLWARNING_SYM = 719,
     SQL_BIG_RESULT = 720,
     SQL_BUFFER_RESULT = 721,
     SQL_CACHE_SYM = 722,
     SQL_CALC_FOUND_ROWS = 723,
     SQL_NO_CACHE_SYM = 724,
     SQL_SMALL_RESULT = 725,
     SQL_SYM = 726,
     SQL_THREAD = 727,
     SSL_SYM = 728,
     STARTING = 729,
     START_SYM = 730,
     STATUS_SYM = 731,
     STD_SYM = 732,
     STDDEV_SAMP_SYM = 733,
     STOP_SYM = 734,
     STORAGE_SYM = 735,
     STRAIGHT_JOIN = 736,
     STRING_SYM = 737,
     SUBDATE_SYM = 738,
     SUBJECT_SYM = 739,
     SUBSTRING = 740,
     SUBSTRING_INDEX = 741,
     SUM_SYM = 742,
     SUPER_SYM = 743,
     SUSPEND_SYM = 744,
     SWAPS_SYM = 745,
     SWITCHES_SYM = 746,
     SYSDATE = 747,
     TABLES = 748,
     TABLESPACE = 749,
     TABLE_SYM = 750,
     TEMPORARY = 751,
     TEMPTABLE_SYM = 752,
     TERMINATED = 753,
     TEXT_STRING = 754,
     TEXT_SYM = 755,
     TIMESTAMP = 756,
     TIMESTAMP_ADD = 757,
     TIMESTAMP_DIFF = 758,
     TIME_SYM = 759,
     TINYBLOB = 760,
     TINYINT = 761,
     TINYTEXT = 762,
     TO_SYM = 763,
     TRAILING = 764,
     TRANSACTION_SYM = 765,
     TRIGGER_SYM = 766,
     TRIGGERS_SYM = 767,
     TRIM = 768,
     TRUE_SYM = 769,
     TRUNCATE_SYM = 770,
     TYPES_SYM = 771,
     TYPE_SYM = 772,
     UDF_RETURNS_SYM = 773,
     UDF_SONAME_SYM = 774,
     ULONGLONG_NUM = 775,
     UNCOMMITTED_SYM = 776,
     UNDEFINED_SYM = 777,
     UNDERSCORE_CHARSET = 778,
     UNDO_SYM = 779,
     UNICODE_SYM = 780,
     UNION_SYM = 781,
     UNIQUE_SYM = 782,
     UNIQUE_USERS = 783,
     UNIX_TIMESTAMP = 784,
     UNKNOWN_SYM = 785,
     UNLOCK_SYM = 786,
     UNSIGNED = 787,
     UNTIL_SYM = 788,
     UPDATE_SYM = 789,
     UPGRADE_SYM = 790,
     USAGE = 791,
     USER = 792,
     USE_FRM = 793,
     USE_SYM = 794,
     USING = 795,
     UTC_DATE_SYM = 796,
     UTC_TIMESTAMP_SYM = 797,
     UTC_TIME_SYM = 798,
     VAR_SAMP_SYM = 799,
     VALUES = 800,
     VALUE_SYM = 801,
     VARBINARY = 802,
     VARCHAR = 803,
     VARIABLES = 804,
     VARIANCE_SYM = 805,
     VARYING = 806,
     VIEW_SYM = 807,
     WARNINGS = 808,
     WEEK_SYM = 809,
     WHEN_SYM = 810,
     WHERE = 811,
     WHILE_SYM = 812,
     WITH = 813,
     WORK_SYM = 814,
     WRITE_SYM = 815,
     X509_SYM = 816,
     XA_SYM = 817,
     XOR = 818,
     YEARWEEK = 819,
     YEAR_MONTH_SYM = 820,
     YEAR_SYM = 821,
     ZEROFILL = 822,
     TABLE_REF_PRIORITY = 823,
     ELSE = 824,
     THEN_SYM = 825,
     CASE_SYM = 826,
     BETWEEN_SYM = 827,
     NEG = 828
   };
#endif
#define END_OF_INPUT 258
#define ABORT_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define ATAN 277
#define AUTO_INC 278
#define AVG_ROW_LENGTH 279
#define AVG_SYM 280
#define BACKUP_SYM 281
#define BEFORE_SYM 282
#define BEGIN_SYM 283
#define BENCHMARK_SYM 284
#define BERKELEY_DB_SYM 285
#define BIGINT 286
#define BINARY 287
#define BINLOG_SYM 288
#define BIN_NUM 289
#define BIT_AND 290
#define BIT_OR 291
#define BIT_SYM 292
#define BIT_XOR 293
#define BLOB_SYM 294
#define BLOCK_SYM 295
#define BOOLEAN_SYM 296
#define BOOL_SYM 297
#define BOTH 298
#define BTREE_SYM 299
#define BY 300
#define BYTE_SYM 301
#define CACHE_SYM 302
#define CALL_SYM 303
#define CASCADE 304
#define CASCADED 305
#define CAST_SYM 306
#define CHAIN_SYM 307
#define CHANGE 308
#define CHANGED 309
#define CHARSET 310
#define CHAR_SYM 311
#define CHECKSUM_SYM 312
#define CHECK_SYM 313
#define CIPHER_SYM 314
#define CLIENT_SYM 315
#define CLOSE_SYM 316
#define COALESCE 317
#define CODE_SYM 318
#define COLLATE_SYM 319
#define COLLATION_SYM 320
#define COLUMNS 321
#define COLUMN_SYM 322
#define COMMENT_SYM 323
#define COMMITTED_SYM 324
#define COMMIT_SYM 325
#define COMPACT_SYM 326
#define COMPRESSED_SYM 327
#define CONCAT 328
#define CONCAT_WS 329
#define CONCURRENT 330
#define CONDITION_SYM 331
#define CONNECTION_SYM 332
#define CONSISTENT_SYM 333
#define CONSTRAINT 334
#define CONTAINS_SYM 335
#define CONTEXT_SYM 336
#define CONTINUE_SYM 337
#define CONVERT_SYM 338
#define CONVERT_TZ_SYM 339
#define COUNT_SYM 340
#define CPU_SYM 341
#define CREATE 342
#define CROSS 343
#define CUBE_SYM 344
#define CURDATE 345
#define CURRENT_USER 346
#define CURSOR_SYM 347
#define CURTIME 348
#define DATABASE 349
#define DATABASES 350
#define DATA_SYM 351
#define DATETIME 352
#define DATE_ADD_INTERVAL 353
#define DATE_SUB_INTERVAL 354
#define DATE_SYM 355
#define DAY_HOUR_SYM 356
#define DAY_MICROSECOND_SYM 357
#define DAY_MINUTE_SYM 358
#define DAY_SECOND_SYM 359
#define DAY_SYM 360
#define DEALLOCATE_SYM 361
#define DECIMAL_NUM 362
#define DECIMAL_SYM 363
#define DECLARE_SYM 364
#define DECODE_SYM 365
#define DEFAULT 366
#define DEFINER_SYM 367
#define DELAYED_SYM 368
#define DELAY_KEY_WRITE_SYM 369
#define DELETE_SYM 370
#define DESC 371
#define DESCRIBE 372
#define DES_DECRYPT_SYM 373
#define DES_ENCRYPT_SYM 374
#define DES_KEY_FILE 375
#define DETERMINISTIC_SYM 376
#define DIRECTORY_SYM 377
#define DISABLE_SYM 378
#define DISCARD 379
#define DISTINCT 380
#define DIV_SYM 381
#define DOUBLE_SYM 382
#define DO_SYM 383
#define DROP 384
#define DUAL_SYM 385
#define DUMPFILE 386
#define DUPLICATE_SYM 387
#define DYNAMIC_SYM 388
#define EACH_SYM 389
#define ELSEIF_SYM 390
#define ELT_FUNC 391
#define ENABLE_SYM 392
#define ENCLOSED 393
#define ENCODE_SYM 394
#define ENCRYPT 395
#define END 396
#define ENGINES_SYM 397
#define ENGINE_SYM 398
#define ENUM 399
#define EQ 400
#define EQUAL_SYM 401
#define ERRORS 402
#define ESCAPED 403
#define ESCAPE_SYM 404
#define EVENTS_SYM 405
#define EXECUTE_SYM 406
#define EXISTS 407
#define EXIT_SYM 408
#define EXPANSION_SYM 409
#define EXPORT_SET 410
#define EXTENDED_SYM 411
#define EXTRACT_SYM 412
#define FALSE_SYM 413
#define FAST_SYM 414
#define FAULTS_SYM 415
#define FETCH_SYM 416
#define FIELD_FUNC 417
#define FILE_SYM 418
#define FIRST_SYM 419
#define FIXED_SYM 420
#define FLOAT_NUM 421
#define FLOAT_SYM 422
#define FLUSH_SYM 423
#define FORCE_SYM 424
#define FOREIGN 425
#define FORMAT_SYM 426
#define FOR_SYM 427
#define FOUND_SYM 428
#define FRAC_SECOND_SYM 429
#define FROM 430
#define FROM_UNIXTIME 431
#define FULL 432
#define FULLTEXT_SYM 433
#define FUNCTION_SYM 434
#define FUNC_ARG0 435
#define FUNC_ARG1 436
#define FUNC_ARG2 437
#define FUNC_ARG3 438
#define GE 439
#define GEOMCOLLFROMTEXT 440
#define GEOMETRYCOLLECTION 441
#define GEOMETRY_SYM 442
#define GEOMFROMTEXT 443
#define GEOMFROMWKB 444
#define GET_FORMAT 445
#define GLOBAL_SYM 446
#define GRANT 447
#define GRANTS 448
#define GREATEST_SYM 449
#define GROUP 450
#define GROUP_CONCAT_SYM 451
#define GROUP_UNIQUE_USERS 452
#define GT_SYM 453
#define HANDLER_SYM 454
#define HASH_SYM 455
#define HAVING 456
#define HELP_SYM 457
#define HEX_NUM 458
#define HIGH_PRIORITY 459
#define HOSTS_SYM 460
#define HOUR_MICROSECOND_SYM 461
#define HOUR_MINUTE_SYM 462
#define HOUR_SECOND_SYM 463
#define HOUR_SYM 464
#define IDENT 465
#define IDENTIFIED_SYM 466
#define IDENT_QUOTED 467
#define IF 468
#define IGNORE_SYM 469
#define IMPORT 470
#define INDEXES 471
#define INDEX_SYM 472
#define INFILE 473
#define INNER_SYM 474
#define INNOBASE_SYM 475
#define INOUT_SYM 476
#define INSENSITIVE_SYM 477
#define INSERT 478
#define INSERT_METHOD 479
#define INTERVAL_SYM 480
#define INTO 481
#define INT_SYM 482
#define INVOKER_SYM 483
#define IN_SYM 484
#define IO_SYM 485
#define IPC_SYM 486
#define IS 487
#define ISOLATION 488
#define ISSUER_SYM 489
#define ITERATE_SYM 490
#define JOIN_SYM 491
#define KEYS 492
#define KEY_SYM 493
#define KILL_SYM 494
#define LABEL_SYM 495
#define LANGUAGE_SYM 496
#define LAST_INSERT_ID 497
#define LAST_SYM 498
#define LE 499
#define LEADING 500
#define LEAST_SYM 501
#define LEAVES 502
#define LEAVE_SYM 503
#define LEFT 504
#define LEVEL_SYM 505
#define LEX_HOSTNAME 506
#define LIKE 507
#define LIMIT 508
#define LINEFROMTEXT 509
#define LINES 510
#define LINESTRING 511
#define LOAD 512
#define LOCAL_SYM 513
#define LOCATE 514
#define LOCATOR_SYM 515
#define LOCKS_SYM 516
#define LOCK_SYM 517
#define LOGS_SYM 518
#define LOG_SYM 519
#define LONGBLOB 520
#define LONGTEXT 521
#define LONG_NUM 522
#define LONG_SYM 523
#define LOOP_SYM 524
#define LOW_PRIORITY 525
#define LT 526
#define MAKE_SET_SYM 527
#define MASTER_CONNECT_RETRY_SYM 528
#define MASTER_HOST_SYM 529
#define MASTER_LOG_FILE_SYM 530
#define MASTER_LOG_POS_SYM 531
#define MASTER_PASSWORD_SYM 532
#define MASTER_PORT_SYM 533
#define MASTER_POS_WAIT 534
#define MASTER_SERVER_ID_SYM 535
#define MASTER_SSL_CAPATH_SYM 536
#define MASTER_SSL_CA_SYM 537
#define MASTER_SSL_CERT_SYM 538
#define MASTER_SSL_CIPHER_SYM 539
#define MASTER_SSL_KEY_SYM 540
#define MASTER_SSL_SYM 541
#define MASTER_SYM 542
#define MASTER_USER_SYM 543
#define MATCH 544
#define MAX_CONNECTIONS_PER_HOUR 545
#define MAX_QUERIES_PER_HOUR 546
#define MAX_ROWS 547
#define MAX_SYM 548
#define MAX_UPDATES_PER_HOUR 549
#define MAX_USER_CONNECTIONS_SYM 550
#define MEDIUMBLOB 551
#define MEDIUMINT 552
#define MEDIUMTEXT 553
#define MEDIUM_SYM 554
#define MEMORY_SYM 555
#define MERGE_SYM 556
#define MICROSECOND_SYM 557
#define MIGRATE_SYM 558
#define MINUTE_MICROSECOND_SYM 559
#define MINUTE_SECOND_SYM 560
#define MINUTE_SYM 561
#define MIN_ROWS 562
#define MIN_SYM 563
#define MLINEFROMTEXT 564
#define MODE_SYM 565
#define MODIFIES_SYM 566
#define MODIFY_SYM 567
#define MOD_SYM 568
#define MONTH_SYM 569
#define MPOINTFROMTEXT 570
#define MPOLYFROMTEXT 571
#define MULTILINESTRING 572
#define MULTIPOINT 573
#define MULTIPOLYGON 574
#define MUTEX_SYM 575
#define NAMES_SYM 576
#define NAME_SYM 577
#define NATIONAL_SYM 578
#define NATURAL 579
#define NCHAR_STRING 580
#define NCHAR_SYM 581
#define NDBCLUSTER_SYM 582
#define NE 583
#define NEW_SYM 584
#define NEXT_SYM 585
#define NONE_SYM 586
#define NOT2_SYM 587
#define NOT_SYM 588
#define NOW_SYM 589
#define NO_SYM 590
#define NO_WRITE_TO_BINLOG 591
#define NULL_SYM 592
#define NUM 593
#define NUMERIC_SYM 594
#define NVARCHAR_SYM 595
#define OFFSET_SYM 596
#define OJ_SYM 597
#define OLD_PASSWORD 598
#define ON 599
#define ONE_SHOT_SYM 600
#define ONE_SYM 601
#define OPEN_SYM 602
#define OPTIMIZE 603
#define OPTION 604
#define OPTIONALLY 605
#define OR2_SYM 606
#define ORDER_SYM 607
#define OR_OR_SYM 608
#define OR_SYM 609
#define OUTER 610
#define OUTFILE 611
#define OUT_SYM 612
#define PACK_KEYS_SYM 613
#define PAGE_SYM 614
#define PARTIAL 615
#define PASSWORD 616
#define PARAM_MARKER 617
#define PHASE_SYM 618
#define POINTFROMTEXT 619
#define POINT_SYM 620
#define POLYFROMTEXT 621
#define POLYGON 622
#define POSITION_SYM 623
#define PRECISION 624
#define PREPARE_SYM 625
#define PREV_SYM 626
#define PRIMARY_SYM 627
#define PRIVILEGES 628
#define PROCEDURE 629
#define PROCESS 630
#define PROCESSLIST_SYM 631
#define PROFILE_SYM 632
#define PROFILES_SYM 633
#define PURGE 634
#define QUARTER_SYM 635
#define QUERY_SYM 636
#define QUICK 637
#define RAID_0_SYM 638
#define RAID_CHUNKS 639
#define RAID_CHUNKSIZE 640
#define RAID_STRIPED_SYM 641
#define RAID_TYPE 642
#define RAND 643
#define READS_SYM 644
#define READ_SYM 645
#define REAL 646
#define RECOVER_SYM 647
#define REDUNDANT_SYM 648
#define REFERENCES 649
#define REGEXP 650
#define RELAY_LOG_FILE_SYM 651
#define RELAY_LOG_POS_SYM 652
#define RELAY_THREAD 653
#define RELEASE_SYM 654
#define RELOAD 655
#define RENAME 656
#define REPAIR 657
#define REPEATABLE_SYM 658
#define REPEAT_SYM 659
#define REPLACE 660
#define REPLICATION 661
#define REQUIRE_SYM 662
#define RESET_SYM 663
#define RESOURCES 664
#define RESTORE_SYM 665
#define RESTRICT 666
#define RESUME_SYM 667
#define RETURNS_SYM 668
#define RETURN_SYM 669
#define REVOKE 670
#define RIGHT 671
#define ROLLBACK_SYM 672
#define ROLLUP_SYM 673
#define ROUND 674
#define ROUTINE_SYM 675
#define ROWS_SYM 676
#define ROW_COUNT_SYM 677
#define ROW_FORMAT_SYM 678
#define ROW_SYM 679
#define RTREE_SYM 680
#define SAVEPOINT_SYM 681
#define SECOND_MICROSECOND_SYM 682
#define SECOND_SYM 683
#define SECURITY_SYM 684
#define SELECT_SYM 685
#define SENNA_DELIMITED_SYM 686
#define SENNA_KWIC_SYM 687
#define SENNA_MECAB_SYM 688
#define SENNA_NGRAM_SYM 689
#define SENNA_NORMALIZE_SYM 690
#define SENNA_SECTIONALIZE_SYM 691
#define SENNA_SPLIT_ALPHA_SYM 692
#define SENNA_SPLIT_DIGIT_SYM 693
#define SENNA_SPLIT_SYMBOL_SYM 694
#define SENNA_SYM 695
#define SENSITIVE_SYM 696
#define SEPARATOR_SYM 697
#define SERIALIZABLE_SYM 698
#define SERIAL_SYM 699
#define SESSION_SYM 700
#define SET 701
#define SET_VAR 702
#define SHARE_SYM 703
#define SHIFT_LEFT 704
#define SHIFT_RIGHT 705
#define SHOW 706
#define SHUTDOWN 707
#define SIGNED_SYM 708
#define SIMPLE_SYM 709
#define SLAVE 710
#define SMALLINT 711
#define SNAPSHOT_SYM 712
#define SOUNDS_SYM 713
#define SOURCE_SYM 714
#define SPATIAL_SYM 715
#define SPECIFIC_SYM 716
#define SQLEXCEPTION_SYM 717
#define SQLSTATE_SYM 718
#define SQLWARNING_SYM 719
#define SQL_BIG_RESULT 720
#define SQL_BUFFER_RESULT 721
#define SQL_CACHE_SYM 722
#define SQL_CALC_FOUND_ROWS 723
#define SQL_NO_CACHE_SYM 724
#define SQL_SMALL_RESULT 725
#define SQL_SYM 726
#define SQL_THREAD 727
#define SSL_SYM 728
#define STARTING 729
#define START_SYM 730
#define STATUS_SYM 731
#define STD_SYM 732
#define STDDEV_SAMP_SYM 733
#define STOP_SYM 734
#define STORAGE_SYM 735
#define STRAIGHT_JOIN 736
#define STRING_SYM 737
#define SUBDATE_SYM 738
#define SUBJECT_SYM 739
#define SUBSTRING 740
#define SUBSTRING_INDEX 741
#define SUM_SYM 742
#define SUPER_SYM 743
#define SUSPEND_SYM 744
#define SWAPS_SYM 745
#define SWITCHES_SYM 746
#define SYSDATE 747
#define TABLES 748
#define TABLESPACE 749
#define TABLE_SYM 750
#define TEMPORARY 751
#define TEMPTABLE_SYM 752
#define TERMINATED 753
#define TEXT_STRING 754
#define TEXT_SYM 755
#define TIMESTAMP 756
#define TIMESTAMP_ADD 757
#define TIMESTAMP_DIFF 758
#define TIME_SYM 759
#define TINYBLOB 760
#define TINYINT 761
#define TINYTEXT 762
#define TO_SYM 763
#define TRAILING 764
#define TRANSACTION_SYM 765
#define TRIGGER_SYM 766
#define TRIGGERS_SYM 767
#define TRIM 768
#define TRUE_SYM 769
#define TRUNCATE_SYM 770
#define TYPES_SYM 771
#define TYPE_SYM 772
#define UDF_RETURNS_SYM 773
#define UDF_SONAME_SYM 774
#define ULONGLONG_NUM 775
#define UNCOMMITTED_SYM 776
#define UNDEFINED_SYM 777
#define UNDERSCORE_CHARSET 778
#define UNDO_SYM 779
#define UNICODE_SYM 780
#define UNION_SYM 781
#define UNIQUE_SYM 782
#define UNIQUE_USERS 783
#define UNIX_TIMESTAMP 784
#define UNKNOWN_SYM 785
#define UNLOCK_SYM 786
#define UNSIGNED 787
#define UNTIL_SYM 788
#define UPDATE_SYM 789
#define UPGRADE_SYM 790
#define USAGE 791
#define USER 792
#define USE_FRM 793
#define USE_SYM 794
#define USING 795
#define UTC_DATE_SYM 796
#define UTC_TIMESTAMP_SYM 797
#define UTC_TIME_SYM 798
#define VAR_SAMP_SYM 799
#define VALUES 800
#define VALUE_SYM 801
#define VARBINARY 802
#define VARCHAR 803
#define VARIABLES 804
#define VARIANCE_SYM 805
#define VARYING 806
#define VIEW_SYM 807
#define WARNINGS 808
#define WEEK_SYM 809
#define WHEN_SYM 810
#define WHERE 811
#define WHILE_SYM 812
#define WITH 813
#define WORK_SYM 814
#define WRITE_SYM 815
#define X509_SYM 816
#define XA_SYM 817
#define XOR 818
#define YEARWEEK 819
#define YEAR_MONTH_SYM 820
#define YEAR_SYM 821
#define ZEROFILL 822
#define TABLE_REF_PRIORITY 823
#define ELSE 824
#define THEN_SYM 825
#define CASE_SYM 826
#define BETWEEN_SYM 827
#define NEG 828




/* Copy the first part of user declarations.  */
#line 18 "sql_yacc.yy"

/* thd is passed as an arg to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200				/* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "mysql_priv.h"
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include <myisam.h>
#include <myisammrg.h>

int yylex(void *yylval, void *yythd);

const LEX_STRING null_lex_str={0,0};

#define yyoverflow(A,B,C,D,E,F) {ulong val= *(F); if (my_yyoverflow((B), (D), &val)) { yyerror((char*) (A)); return 2; } else { *(F)= (YYSIZE_T)val; }}

#undef 	WARN_DEPRECATED			/* this macro is also defined in mysql_priv.h */
#define WARN_DEPRECATED(A,B)                                        \
  push_warning_printf(((THD *)yythd), MYSQL_ERROR::WARN_LEVEL_WARN, \
		      ER_WARN_DEPRECATED_SYNTAX,                    \
		      ER(ER_WARN_DEPRECATED_SYNTAX), (A), (B));

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= thd->m_lip;

  const char *yytext= lip->tok_start;
  /* Push an error into the error stack */
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  (yytext ? yytext : ""),
                  lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(const char *s)
{
  THD *thd= current_thd;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  sp->add_instr(i);

  return 0;
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->push_backpatch(i, ctx->push_label((char *)"", 0));
  sp->add_cont_backpatch(i);
  sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

void case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  sp->add_instr(i);

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 415 "sql_yacc.yy"
typedef union YYSTYPE {
  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  enum db_type db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  struct st_lex *lex;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 1669 "sql_yacc.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 455 "sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 214 of yacc.c.  */
#line 1684 "sql_yacc.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   define YYSTACK_ALLOC alloca
#  endif
# else
#  if defined (alloca) || defined (_ALLOCA_H)
#   define YYSTACK_ALLOC alloca
#  else
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  477
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   45027

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  593
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  680
/* YYNRULES -- Number of rules. */
#define YYNRULES  2078
/* YYNRULES -- Number of states. */
#define YYNSTATES  3739

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   828

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   586,     2,     2,     2,   579,   574,     2,
     583,   584,   577,   576,   585,   575,   590,   578,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   592,   591,
       2,     2,     2,     2,   589,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   580,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   587,   573,   588,   581,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   582
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    90,    92,    94,    96,    98,
     100,   102,   104,   106,   110,   112,   114,   119,   121,   124,
     125,   130,   131,   134,   138,   140,   143,   144,   148,   149,
     155,   157,   161,   165,   169,   173,   177,   181,   185,   189,
     193,   197,   201,   205,   207,   211,   215,   219,   223,   224,
     232,   233,   245,   246,   253,   254,   258,   263,   264,   268,
     270,   275,   276,   277,   278,   279,   280,   293,   294,   297,
     298,   301,   304,   307,   310,   313,   317,   321,   323,   325,
     327,   330,   334,   338,   339,   344,   345,   349,   350,   352,
     356,   358,   359,   361,   365,   367,   368,   372,   373,   375,
     379,   381,   386,   387,   389,   391,   393,   394,   398,   401,
     405,   406,   410,   411,   417,   423,   424,   432,   438,   439,
     442,   444,   446,   448,   452,   454,   456,   460,   461,   463,
     465,   467,   469,   472,   474,   476,   480,   481,   484,   485,
     488,   489,   493,   494,   500,   502,   504,   505,   508,   511,
     514,   517,   518,   525,   528,   529,   532,   534,   536,   540,
     541,   542,   543,   551,   552,   555,   558,   560,   562,   563,
     564,   573,   574,   581,   583,   586,   588,   591,   592,   593,
     600,   601,   602,   609,   610,   613,   614,   620,   621,   623,
     624,   630,   635,   636,   637,   646,   647,   655,   657,   659,
     661,   663,   665,   668,   671,   674,   679,   684,   685,   690,
     691,   692,   698,   699,   707,   708,   709,   716,   717,   719,
     720,   722,   724,   727,   729,   731,   732,   734,   736,   739,
     741,   742,   746,   747,   749,   751,   754,   756,   759,   763,
     767,   771,   775,   779,   783,   787,   791,   795,   799,   803,
     807,   811,   815,   819,   823,   827,   833,   835,   837,   841,
     846,   851,   855,   860,   865,   867,   869,   871,   873,   875,
     877,   879,   881,   883,   885,   887,   889,   891,   893,   896,
     897,   899,   901,   903,   905,   907,   909,   913,   915,   917,
     920,   923,   930,   938,   947,   950,   953,   954,   956,   959,
     960,   962,   965,   966,   971,   975,   979,   983,   985,   990,
     992,   994,  1000,  1003,  1009,  1012,  1017,  1019,  1025,  1031,
    1036,  1040,  1042,  1044,  1047,  1049,  1051,  1054,  1056,  1058,
    1060,  1063,  1067,  1070,  1074,  1077,  1080,  1084,  1088,  1092,
    1093,  1100,  1101,  1108,  1111,  1113,  1115,  1117,  1119,  1121,
    1123,  1125,  1127,  1129,  1131,  1133,  1136,  1139,  1141,  1144,
    1146,  1149,  1153,  1156,  1158,  1160,  1162,  1164,  1166,  1168,
    1170,  1173,  1174,  1178,  1180,  1186,  1187,  1189,  1192,  1194,
    1196,  1198,  1200,  1201,  1205,  1206,  1208,  1209,  1211,  1214,
    1216,  1218,  1221,  1224,  1229,  1231,  1235,  1238,  1240,  1243,
    1246,  1249,  1252,  1254,  1257,  1259,  1261,  1263,  1265,  1267,
    1268,  1271,  1273,  1275,  1277,  1279,  1281,  1282,  1285,  1287,
    1289,  1290,  1292,  1293,  1296,  1298,  1301,  1305,  1308,  1309,
    1311,  1312,  1314,  1316,  1319,  1320,  1322,  1323,  1328,  1330,
    1335,  1339,  1341,  1342,  1344,  1347,  1349,  1353,  1357,  1360,
    1363,  1366,  1368,  1370,  1373,  1376,  1379,  1381,  1384,  1387,
    1390,  1393,  1395,  1397,  1398,  1400,  1402,  1404,  1406,  1407,
    1409,  1411,  1413,  1414,  1417,  1420,  1422,  1424,  1426,  1428,
    1430,  1434,  1436,  1439,  1441,  1444,  1446,  1448,  1450,  1452,
    1454,  1456,  1458,  1460,  1465,  1468,  1470,  1475,  1476,  1478,
    1479,  1482,  1484,  1488,  1489,  1496,  1497,  1503,  1504,  1510,
    1511,  1517,  1518,  1530,  1531,  1533,  1534,  1537,  1540,  1542,
    1546,  1549,  1553,  1556,  1561,  1562,  1569,  1570,  1571,  1580,
    1585,  1590,  1594,  1598,  1601,  1604,  1611,  1617,  1621,  1627,
    1629,  1631,  1633,  1634,  1636,  1637,  1639,  1640,  1642,  1644,
    1645,  1648,  1650,  1651,  1653,  1655,  1657,  1658,  1664,  1668,
    1669,  1675,  1679,  1683,  1684,  1688,  1689,  1692,  1694,  1698,
    1699,  1701,  1703,  1704,  1707,  1709,  1713,  1714,  1721,  1722,
    1729,  1730,  1736,  1737,  1739,  1741,  1742,  1749,  1750,  1752,
    1754,  1757,  1759,  1761,  1763,  1764,  1771,  1772,  1778,  1779,
    1781,  1783,  1786,  1788,  1790,  1792,  1794,  1796,  1799,  1800,
    1807,  1808,  1810,  1812,  1813,  1818,  1823,  1827,  1833,  1835,
    1839,  1843,  1849,  1851,  1855,  1858,  1860,  1862,  1863,  1870,
    1872,  1876,  1880,  1881,  1884,  1885,  1890,  1891,  1894,  1896,
    1899,  1904,  1907,  1911,  1912,  1916,  1917,  1918,  1925,  1928,
    1930,  1932,  1935,  1938,  1947,  1952,  1953,  1955,  1958,  1960,
    1962,  1964,  1966,  1968,  1970,  1972,  1974,  1976,  1978,  1980,
    1981,  1984,  1989,  1993,  1995,  1997,  2002,  2003,  2004,  2006,
    2008,  2009,  2012,  2015,  2017,  2019,  2020,  2023,  2024,  2028,
    2029,  2033,  2037,  2038,  2042,  2043,  2047,  2050,  2052,  2056,
    2061,  2065,  2070,  2074,  2079,  2081,  2085,  2090,  2094,  2098,
    2105,  2107,  2113,  2120,  2126,  2134,  2141,  2150,  2156,  2163,
    2168,  2173,  2179,  2183,  2188,  2190,  2194,  2196,  2200,  2202,
    2206,  2210,  2212,  2216,  2220,  2225,  2230,  2232,  2236,  2240,
    2244,  2248,  2252,  2254,  2258,  2260,  2262,  2264,  2266,  2268,
    2270,  2272,  2274,  2276,  2278,  2280,  2282,  2284,  2286,  2288,
    2290,  2292,  2295,  2297,  2301,  2303,  2305,  2307,  2309,  2313,
    2316,  2319,  2322,  2325,  2329,  2333,  2339,  2346,  2351,  2356,
    2364,  2369,  2372,  2379,  2385,  2392,  2399,  2404,  2409,  2413,
    2418,  2425,  2434,  2441,  2450,  2457,  2462,  2469,  2474,  2481,
    2486,  2491,  2496,  2501,  2508,  2517,  2520,  2523,  2528,  2531,
    2539,  2547,  2551,  2556,  2561,  2568,  2575,  2580,  2587,  2594,
    2601,  2606,  2613,  2618,  2625,  2634,  2645,  2658,  2665,  2670,
    2677,  2684,  2686,  2693,  2698,  2707,  2718,  2723,  2725,  2729,
    2734,  2741,  2748,  2757,  2764,  2771,  2776,  2783,  2790,  2799,
    2804,  2809,  2816,  2821,  2824,  2829,  2834,  2839,  2846,  2851,
    2856,  2860,  2869,  2876,  2881,  2888,  2892,  2897,  2904,  2913,
    2918,  2927,  2934,  2943,  2950,  2959,  2962,  2967,  2972,  2977,
    2984,  2993,  3002,  3007,  3015,  3023,  3031,  3038,  3045,  3052,
    3059,  3066,  3073,  3074,  3080,  3091,  3095,  3100,  3104,  3107,
    3110,  3113,  3118,  3125,  3130,  3135,  3142,  3149,  3156,  3163,
    3168,  3175,  3180,  3187,  3192,  3197,  3202,  3207,  3214,  3219,
    3226,  3231,  3238,  3243,  3248,  3255,  3260,  3267,  3272,  3279,
    3284,  3289,  3296,  3301,  3308,  3309,  3313,  3317,  3318,  3320,
    3321,  3324,  3326,  3330,  3335,  3340,  3346,  3351,  3356,  3361,
    3367,  3372,  3373,  3374,  3382,  3393,  3398,  3404,  3409,  3415,
    3420,  3425,  3430,  3435,  3440,  3446,  3447,  3456,  3457,  3461,
    3465,  3467,  3472,  3473,  3475,  3476,  3479,  3480,  3482,  3483,
    3487,  3490,  3494,  3497,  3499,  3502,  3504,  3507,  3509,  3511,
    3513,  3516,  3517,  3519,  3520,  3523,  3525,  3529,  3531,  3535,
    3536,  3539,  3541,  3545,  3546,  3548,  3549,  3552,  3557,  3563,
    3565,  3567,  3569,  3571,  3575,  3579,  3583,  3584,  3591,  3592,
    3599,  3600,  3609,  3614,  3615,  3624,  3625,  3636,  3643,  3644,
    3653,  3654,  3665,  3672,  3674,  3677,  3680,  3681,  3686,  3687,
    3699,  3703,  3710,  3711,  3715,  3716,  3717,  3723,  3724,  3726,
    3727,  3729,  3730,  3733,  3734,  3737,  3740,  3743,  3744,  3751,
    3752,  3754,  3758,  3760,  3762,  3764,  3768,  3770,  3772,  3774,
    3776,  3778,  3780,  3782,  3784,  3786,  3788,  3790,  3792,  3794,
    3796,  3798,  3800,  3802,  3804,  3806,  3808,  3810,  3812,  3814,
    3816,  3818,  3820,  3821,  3823,  3825,  3826,  3829,  3830,  3832,
    3833,  3834,  3838,  3839,  3840,  3844,  3847,  3848,  3849,  3854,
    3859,  3862,  3863,  3866,  3869,  3873,  3877,  3879,  3882,  3883,
    3885,  3886,  3891,  3896,  3899,  3900,  3902,  3904,  3905,  3907,
    3908,  3910,  3913,  3915,  3919,  3923,  3925,  3927,  3929,  3931,
    3932,  3935,  3937,  3939,  3941,  3943,  3945,  3947,  3949,  3951,
    3953,  3955,  3957,  3958,  3959,  3966,  3967,  3969,  3973,  3975,
    3978,  3979,  3982,  3986,  3988,  3991,  3993,  3994,  3998,  3999,
    4005,  4008,  4010,  4011,  4015,  4022,  4023,  4030,  4035,  4040,
    4045,  4050,  4056,  4061,  4063,  4067,  4069,  4070,  4073,  4074,
    4076,  4077,  4078,  4087,  4088,  4089,  4096,  4097,  4099,  4101,
    4103,  4105,  4107,  4110,  4112,  4114,  4116,  4120,  4125,  4126,
    4130,  4134,  4136,  4139,  4142,  4143,  4147,  4148,  4154,  4158,
    4160,  4164,  4166,  4170,  4172,  4174,  4175,  4177,  4178,  4183,
    4184,  4186,  4190,  4192,  4194,  4196,  4197,  4198,  4205,  4206,
    4207,  4219,  4223,  4225,  4229,  4233,  4235,  4239,  4240,  4242,
    4243,  4248,  4249,  4256,  4257,  4263,  4264,  4271,  4273,  4277,
    4281,  4287,  4288,  4291,  4292,  4295,  4297,  4299,  4301,  4305,
    4306,  4308,  4309,  4311,  4313,  4317,  4319,  4321,  4324,  4327,
    4330,  4332,  4334,  4336,  4338,  4339,  4343,  4344,  4348,  4351,
    4356,  4361,  4366,  4371,  4372,  4377,  4384,  4401,  4404,  4407,
    4408,  4415,  4421,  4424,  4427,  4430,  4432,  4438,  4444,  4447,
    4450,  4452,  4457,  4461,  4464,  4467,  4470,  4474,  4477,  4480,
    4483,  4485,  4487,  4491,  4496,  4500,  4504,  4507,  4510,  4514,
    4518,  4522,  4526,  4530,  4534,  4539,  4541,  4543,  4545,  4547,
    4548,  4550,  4551,  4554,  4555,  4557,  4559,  4561,  4562,  4565,
    4566,  4569,  4570,  4573,  4576,  4577,  4582,  4583,  4588,  4590,
    4592,  4593,  4595,  4596,  4598,  4600,  4601,  4606,  4610,  4612,
    4613,  4617,  4622,  4625,  4627,  4629,  4631,  4633,  4635,  4637,
    4639,  4641,  4642,  4644,  4645,  4649,  4653,  4655,  4657,  4659,
    4662,  4663,  4667,  4671,  4674,  4677,  4678,  4683,  4684,  4686,
    4688,  4691,  4692,  4697,  4703,  4704,  4705,  4706,  4707,  4726,
    4729,  4730,  4732,  4733,  4735,  4737,  4738,  4740,  4742,  4743,
    4746,  4749,  4751,  4755,  4760,  4764,  4768,  4769,  4772,  4775,
    4777,  4781,  4785,  4786,  4790,  4791,  4795,  4798,  4802,  4804,
    4806,  4809,  4810,  4813,  4815,  4817,  4820,  4823,  4825,  4827,
    4829,  4831,  4833,  4836,  4839,  4841,  4843,  4845,  4847,  4849,
    4851,  4853,  4856,  4859,  4862,  4865,  4868,  4870,  4872,  4874,
    4876,  4878,  4880,  4882,  4886,  4892,  4894,  4896,  4898,  4900,
    4902,  4906,  4911,  4917,  4919,  4925,  4929,  4932,  4934,  4938,
    4941,  4943,  4945,  4947,  4949,  4951,  4953,  4955,  4957,  4959,
    4961,  4963,  4965,  4967,  4969,  4973,  4976,  4978,  4980,  4982,
    4984,  4986,  4988,  4990,  4992,  4994,  4996,  4998,  5000,  5002,
    5004,  5006,  5008,  5010,  5012,  5014,  5016,  5018,  5020,  5022,
    5024,  5026,  5028,  5030,  5032,  5034,  5036,  5038,  5040,  5042,
    5044,  5046,  5048,  5050,  5052,  5054,  5056,  5058,  5060,  5062,
    5064,  5066,  5068,  5070,  5072,  5074,  5076,  5078,  5080,  5082,
    5084,  5086,  5088,  5090,  5092,  5094,  5096,  5098,  5100,  5102,
    5104,  5106,  5108,  5110,  5112,  5114,  5116,  5118,  5120,  5122,
    5124,  5126,  5128,  5130,  5132,  5134,  5136,  5138,  5140,  5142,
    5144,  5146,  5148,  5150,  5152,  5154,  5156,  5158,  5160,  5162,
    5164,  5166,  5168,  5170,  5172,  5174,  5176,  5178,  5180,  5182,
    5184,  5186,  5188,  5190,  5192,  5194,  5196,  5198,  5200,  5202,
    5204,  5206,  5208,  5210,  5212,  5214,  5216,  5218,  5220,  5222,
    5224,  5226,  5228,  5230,  5232,  5234,  5236,  5238,  5240,  5242,
    5244,  5246,  5248,  5250,  5252,  5254,  5256,  5258,  5260,  5262,
    5264,  5266,  5268,  5270,  5272,  5274,  5276,  5278,  5280,  5282,
    5284,  5286,  5288,  5290,  5292,  5294,  5296,  5298,  5300,  5302,
    5304,  5306,  5308,  5310,  5312,  5314,  5316,  5318,  5320,  5322,
    5324,  5326,  5328,  5330,  5332,  5334,  5336,  5338,  5340,  5342,
    5344,  5346,  5348,  5350,  5352,  5354,  5356,  5358,  5360,  5362,
    5364,  5366,  5368,  5370,  5372,  5374,  5376,  5378,  5380,  5382,
    5384,  5386,  5388,  5390,  5392,  5394,  5396,  5398,  5400,  5402,
    5404,  5406,  5408,  5410,  5412,  5414,  5416,  5418,  5420,  5422,
    5424,  5426,  5428,  5430,  5432,  5434,  5436,  5438,  5440,  5442,
    5444,  5446,  5448,  5450,  5452,  5454,  5456,  5458,  5460,  5462,
    5464,  5466,  5468,  5470,  5472,  5474,  5476,  5478,  5480,  5482,
    5484,  5486,  5488,  5490,  5492,  5494,  5496,  5498,  5500,  5502,
    5504,  5506,  5508,  5510,  5512,  5513,  5518,  5519,  5521,  5523,
    5527,  5528,  5531,  5533,  5535,  5537,  5539,  5540,  5542,  5543,
    5545,  5547,  5549,  5550,  5553,  5556,  5559,  5561,  5564,  5569,
    5575,  5580,  5587,  5590,  5594,  5598,  5602,  5608,  5610,  5614,
    5618,  5621,  5624,  5627,  5629,  5631,  5636,  5641,  5643,  5645,
    5647,  5649,  5651,  5652,  5657,  5659,  5661,  5663,  5667,  5671,
    5673,  5675,  5678,  5681,  5682,  5686,  5691,  5695,  5696,  5704,
    5706,  5709,  5711,  5713,  5715,  5717,  5719,  5721,  5722,  5728,
    5730,  5732,  5734,  5736,  5738,  5742,  5749,  5756,  5763,  5771,
    5775,  5784,  5793,  5802,  5803,  5805,  5807,  5810,  5811,  5813,
    5815,  5819,  5820,  5824,  5825,  5829,  5830,  5834,  5835,  5839,
    5841,  5843,  5845,  5847,  5849,  5851,  5853,  5855,  5857,  5859,
    5861,  5864,  5867,  5869,  5873,  5876,  5879,  5882,  5885,  5888,
    5891,  5894,  5897,  5898,  5900,  5904,  5906,  5909,  5912,  5915,
    5917,  5921,  5925,  5927,  5929,  5933,  5935,  5939,  5944,  5950,
    5952,  5953,  5957,  5961,  5963,  5965,  5966,  5969,  5972,  5975,
    5978,  5979,  5982,  5985,  5987,  5990,  5993,  5996,  5999,  6002,
    6003,  6007,  6008,  6010,  6011,  6015,  6018,  6019,  6021,  6024,
    6025,  6027,  6032,  6037,  6043,  6046,  6050,  6051,  6053,  6054,
    6059,  6060,  6062,  6064,  6065,  6068,  6071,  6073,  6074,  6076,
    6078,  6083,  6084,  6092,  6094,  6095,  6096,  6099,  6103,  6105,
    6107,  6109,  6110,  6114,  6116,  6119,  6121,  6124,  6128,  6132,
    6136,  6137,  6139,  6140,  6144,  6148,  6149,  6158,  6159,  6163,
    6165,  6169,  6170,  6173,  6177,  6183,  6184,  6188,  6193,  6198,
    6199,  6214,  6215,  6222,  6223,  6224,  6225,  6226,  6239,  6244,
    6249,  6253,  6258,  6262,  6265,  6267,  6271,  6277,  6279,  6281,
    6282,  6284,  6286,  6287,  6290,  6291,  6292,  6296,  6297
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     594,     0,    -1,     3,    -1,   595,     3,    -1,   596,    -1,
    1218,    -1,   796,    -1,   837,    -1,   827,    -1,   631,    -1,
     608,    -1,   839,    -1,   829,    -1,  1224,    -1,   613,    -1,
     597,    -1,  1058,    -1,  1089,    -1,  1014,    -1,  1016,    -1,
     601,    -1,  1095,    -1,  1193,    -1,  1184,    -1,   606,    -1,
    1022,    -1,  1109,    -1,  1113,    -1,  1176,    -1,   844,    -1,
     852,    -1,   856,    -1,   599,    -1,  1105,    -1,  1227,    -1,
     847,    -1,   832,    -1,  1025,    -1,  1101,    -1,   825,    -1,
    1191,    -1,  1225,    -1,  1226,    -1,   864,    -1,  1159,    -1,
    1075,    -1,   814,    -1,   817,    -1,  1069,    -1,  1182,    -1,
    1050,    -1,  1112,    -1,  1265,    -1,   598,   370,  1153,    -1,
     106,    -1,   129,    -1,   370,  1153,   175,   600,    -1,  1150,
      -1,   589,  1155,    -1,    -1,   151,  1153,   602,   603,    -1,
      -1,   540,   604,    -1,   604,   585,   605,    -1,   605,    -1,
     589,  1155,    -1,    -1,   202,   607,  1155,    -1,    -1,    53,
     287,   508,   609,   610,    -1,   611,    -1,   610,   585,   611,
      -1,   274,   145,  1150,    -1,   288,   145,  1150,    -1,   277,
     145,  1150,    -1,   278,   145,   999,    -1,   273,   145,   999,
      -1,   286,   145,   999,    -1,   282,   145,  1150,    -1,   281,
     145,  1150,    -1,   283,   145,  1150,    -1,   284,   145,  1150,
      -1,   285,   145,  1150,    -1,   612,    -1,   275,   145,  1150,
      -1,   276,   145,  1000,    -1,   396,   145,  1150,    -1,   397,
     145,   999,    -1,    -1,    87,   711,   495,   714,  1147,   614,
     698,    -1,    -1,    87,   786,   217,  1153,   787,   344,  1147,
     615,   583,   791,   584,    -1,    -1,    87,    94,   714,  1153,
     616,   708,    -1,    -1,    87,   617,  1241,    -1,    87,   537,
     618,  1209,    -1,    -1,  1153,   590,  1153,    -1,  1153,    -1,
     413,   727,   519,  1150,    -1,    -1,    -1,    -1,    -1,    -1,
     583,   621,   636,   584,   622,   413,   623,   738,   624,   627,
     625,   660,    -1,    -1,   626,   628,    -1,    -1,   627,   629,
      -1,    68,  1150,    -1,   241,   471,    -1,   335,   471,    -1,
      80,   471,    -1,   389,   471,    96,    -1,   311,   471,    96,
      -1,   630,    -1,   628,    -1,   121,    -1,   903,   121,    -1,
     471,   429,   112,    -1,   471,   429,   228,    -1,    -1,    48,
     619,   632,   633,    -1,    -1,   583,   634,   584,    -1,    -1,
     635,    -1,   635,   585,   885,    -1,   885,    -1,    -1,   637,
      -1,   637,   585,   639,    -1,   639,    -1,    -1,  1153,   638,
     738,    -1,    -1,   641,    -1,   641,   585,   642,    -1,   642,
      -1,   643,   638,  1153,   738,    -1,    -1,   229,    -1,   357,
      -1,   221,    -1,    -1,   644,   660,   591,    -1,   660,   591,
      -1,   645,   660,   591,    -1,    -1,   646,   647,   591,    -1,
      -1,   109,   658,   648,   738,   659,    -1,   109,  1153,    76,
     172,   655,    -1,    -1,   109,   652,   199,   172,   649,   653,
     660,    -1,   109,  1153,    92,   172,   650,    -1,    -1,   651,
     596,    -1,   153,    -1,    82,    -1,   654,    -1,   653,   585,
     654,    -1,   657,    -1,   999,    -1,   463,   656,  1151,    -1,
      -1,   546,    -1,   655,    -1,  1153,    -1,   464,    -1,   903,
     173,    -1,   462,    -1,  1153,    -1,   658,   585,  1153,    -1,
      -1,   111,   885,    -1,    -1,   661,   596,    -1,    -1,   414,
     662,   885,    -1,    -1,   213,   663,   668,   141,   213,    -1,
     673,    -1,   688,    -1,    -1,   664,   691,    -1,   248,  1154,
      -1,   235,  1154,    -1,   347,  1153,    -1,    -1,   161,   666,
    1153,   226,   665,   667,    -1,    61,  1153,    -1,    -1,   330,
     175,    -1,   175,    -1,  1153,    -1,   667,   585,  1153,    -1,
      -1,    -1,    -1,   669,   885,   570,   670,   645,   671,   672,
      -1,    -1,   135,   668,    -1,   569,   645,    -1,   674,    -1,
     677,    -1,    -1,    -1,   571,   675,   885,   676,   679,   687,
     141,   571,    -1,    -1,   571,   678,   680,   687,   141,   571,
      -1,   681,    -1,   679,   681,    -1,   684,    -1,   680,   684,
      -1,    -1,    -1,   555,   682,   885,   683,   570,   645,    -1,
      -1,    -1,   555,   685,   885,   686,   570,   645,    -1,    -1,
     569,   645,    -1,    -1,  1154,   592,   689,   691,   690,    -1,
      -1,  1154,    -1,    -1,    28,   692,   646,   644,   141,    -1,
     269,   645,   141,   269,    -1,    -1,    -1,   557,   693,   885,
     128,   694,   645,   141,   557,    -1,    -1,   404,   645,   533,
     695,   885,   141,   404,    -1,    27,    -1,     8,    -1,   223,
      -1,   534,    -1,   115,    -1,   583,   699,    -1,   715,   701,
      -1,   252,  1147,    -1,   583,   252,  1147,   584,    -1,   728,
     584,   715,   701,    -1,    -1,   704,   584,   700,  1231,    -1,
      -1,    -1,  1122,   707,   704,   702,  1228,    -1,    -1,  1122,
     707,   583,   704,   584,   703,  1231,    -1,    -1,    -1,   430,
     705,   874,   878,   706,   725,    -1,    -1,    18,    -1,    -1,
     709,    -1,   710,    -1,   709,   710,    -1,   720,    -1,   719,
      -1,    -1,   712,    -1,   713,    -1,   713,   712,    -1,   496,
      -1,    -1,   213,   903,   152,    -1,    -1,   717,    -1,   718,
      -1,   718,   716,    -1,   718,    -1,   718,   717,    -1,   718,
     585,   717,    -1,   143,  1042,   721,    -1,   517,  1042,   721,
      -1,   292,  1042,  1000,    -1,   307,  1042,  1000,    -1,    24,
    1042,   999,    -1,   361,  1042,  1150,    -1,    68,  1042,  1150,
      -1,    23,  1042,  1000,    -1,   358,  1042,   999,    -1,   358,
    1042,   111,    -1,    57,  1042,   999,    -1,   114,  1042,   999,
      -1,   423,  1042,   722,    -1,   387,  1042,   723,    -1,   384,
    1042,   999,    -1,   385,  1042,   999,    -1,   526,  1042,   583,
    1018,   584,    -1,   719,    -1,   720,    -1,   224,  1042,   724,
      -1,    96,   122,  1042,  1150,    -1,   217,   122,  1042,  1150,
      -1,    77,  1042,  1150,    -1,   768,   759,  1042,   761,    -1,
     768,    64,  1042,   767,    -1,  1155,    -1,   111,    -1,   165,
      -1,   133,    -1,    72,    -1,   393,    -1,    71,    -1,   386,
      -1,   383,    -1,   999,    -1,   335,    -1,   164,    -1,   243,
      -1,   994,    -1,   873,   877,    -1,    -1,    10,    -1,   482,
      -1,   391,    -1,   108,    -1,   227,    -1,   729,    -1,   728,
     585,   729,    -1,   730,    -1,   731,    -1,   736,   732,    -1,
     736,   773,    -1,   781,   793,   787,   583,   791,   584,    -1,
     734,   782,   793,   787,   583,   791,   584,    -1,   734,   170,
     238,   793,   583,   791,   584,   773,    -1,   735,   732,    -1,
     734,   733,    -1,    -1,   733,    -1,    58,   885,    -1,    -1,
     735,    -1,    79,   793,    -1,    -1,  1146,   737,   738,   755,
      -1,   746,   753,   750,    -1,   747,   754,   750,    -1,   167,
     748,   750,    -1,    37,    -1,    37,   583,   338,   584,    -1,
      42,    -1,    41,    -1,   742,   583,   338,   584,   769,    -1,
     742,   769,    -1,   743,   583,   338,   584,   770,    -1,   743,
     770,    -1,    32,   583,   338,   584,    -1,    32,    -1,   744,
     583,   338,   584,   769,    -1,   745,   583,   338,   584,   770,
      -1,   547,   583,   338,   584,    -1,   566,   753,   750,    -1,
     100,    -1,   504,    -1,   501,   753,    -1,    97,    -1,   505,
      -1,    39,   753,    -1,   741,    -1,   296,    -1,   265,    -1,
     268,   547,    -1,   268,   744,   769,    -1,   507,   769,    -1,
     500,   753,   769,    -1,   298,   769,    -1,   266,   769,    -1,
     108,   748,   750,    -1,   339,   748,   750,    -1,   165,   748,
     750,    -1,    -1,   144,   739,   583,   795,   584,   769,    -1,
      -1,   446,   740,   583,   795,   584,   769,    -1,   268,   769,
      -1,   444,    -1,   187,    -1,   186,    -1,   365,    -1,   318,
      -1,   256,    -1,   317,    -1,   367,    -1,   319,    -1,    56,
      -1,   326,    -1,   323,    56,    -1,   742,   551,    -1,   548,
      -1,   323,   548,    -1,   340,    -1,   326,   548,    -1,   323,
      56,   551,    -1,   326,   551,    -1,   227,    -1,   506,    -1,
     456,    -1,   297,    -1,    31,    -1,   391,    -1,   127,    -1,
     127,   369,    -1,    -1,   583,   338,   584,    -1,   749,    -1,
     583,   338,   585,   338,   584,    -1,    -1,   751,    -1,   751,
     752,    -1,   752,    -1,   453,    -1,   532,    -1,   567,    -1,
      -1,   583,   338,   584,    -1,    -1,   749,    -1,    -1,   756,
      -1,   756,   757,    -1,   757,    -1,   337,    -1,   903,   337,
      -1,   111,   758,    -1,   344,   534,   334,   884,    -1,    23,
      -1,   444,   111,   546,    -1,   772,   238,    -1,   527,    -1,
     527,   238,    -1,    68,  1150,    -1,    64,   765,    -1,   334,
     884,    -1,  1137,    -1,    56,   446,    -1,    55,    -1,  1155,
      -1,    32,    -1,   760,    -1,   111,    -1,    -1,   759,   761,
      -1,  1155,    -1,    32,    -1,   763,    -1,   111,    -1,  1155,
      -1,    -1,    64,   767,    -1,   765,    -1,   111,    -1,    -1,
     111,    -1,    -1,    20,   770,    -1,    46,    -1,   525,   770,
      -1,   759,   760,   770,    -1,    32,   771,    -1,    -1,    32,
      -1,    -1,    20,    -1,   525,    -1,   759,   760,    -1,    -1,
     372,    -1,    -1,   394,  1147,   774,   775,    -1,   777,    -1,
     583,   776,   584,   777,    -1,   776,   585,  1153,    -1,  1153,
      -1,    -1,   778,    -1,   778,   779,    -1,   779,    -1,   344,
     115,   780,    -1,   344,   534,   780,    -1,   289,   177,    -1,
     289,   360,    -1,   289,   454,    -1,   411,    -1,    49,    -1,
     446,   337,    -1,   335,     5,    -1,   446,   111,    -1,   783,
      -1,   178,   784,    -1,   460,   784,    -1,   372,   238,    -1,
     527,   784,    -1,   238,    -1,   217,    -1,    -1,   783,    -1,
     237,    -1,   217,    -1,   216,    -1,    -1,   527,    -1,   178,
      -1,   460,    -1,    -1,   540,   788,    -1,   517,   788,    -1,
      44,    -1,   425,    -1,   200,    -1,   789,    -1,   790,    -1,
     790,   585,   789,    -1,   440,    -1,   335,   440,    -1,   435,
      -1,   335,   435,    -1,   437,    -1,   438,    -1,   439,    -1,
     431,    -1,   433,    -1,   434,    -1,   436,    -1,   999,    -1,
     791,   585,   792,   992,    -1,   792,   992,    -1,  1153,    -1,
    1153,   583,   338,   584,    -1,    -1,  1146,    -1,    -1,   590,
    1153,    -1,  1135,    -1,   795,   585,  1135,    -1,    -1,    13,
     810,   495,  1147,   797,   803,    -1,    -1,    13,    94,   802,
     798,   708,    -1,    -1,    13,   374,   619,   799,   626,    -1,
      -1,    13,   179,   619,   800,   626,    -1,    -1,    13,  1247,
    1243,  1248,   552,  1147,   801,  1251,    18,  1253,  1256,    -1,
      -1,  1153,    -1,    -1,   124,   494,    -1,   215,   494,    -1,
     805,    -1,   803,   585,   805,    -1,     6,   809,    -1,   804,
     730,   812,    -1,     6,   731,    -1,   804,   583,   728,   584,
      -1,    -1,    53,   809,  1146,   806,   736,   812,    -1,    -1,
      -1,   312,   809,  1146,   807,   738,   755,   808,   812,    -1,
     129,   809,  1146,   811,    -1,   129,   170,   238,   793,    -1,
     129,   372,   238,    -1,   129,   783,  1146,    -1,   123,   237,
      -1,   137,   237,    -1,    13,   809,  1146,   446,   111,  1137,
      -1,    13,   809,  1146,   129,   111,    -1,   401,   813,  1147,
      -1,    83,   508,   759,   761,   766,    -1,   716,    -1,   169,
      -1,   985,    -1,    -1,    67,    -1,    -1,   214,    -1,    -1,
     411,    -1,    49,    -1,    -1,     8,  1153,    -1,   164,    -1,
      -1,   508,    -1,   145,    -1,    18,    -1,    -1,   475,   455,
     819,   815,   823,    -1,   479,   455,   819,    -1,    -1,   455,
     475,   819,   816,   823,    -1,   455,   479,   819,    -1,   475,
     510,   818,    -1,    -1,   558,    78,   457,    -1,    -1,   820,
     821,    -1,   822,    -1,   821,   585,   822,    -1,    -1,   472,
      -1,   398,    -1,    -1,   533,   824,    -1,   612,    -1,   824,
     585,   612,    -1,    -1,   410,  1178,   826,  1018,   175,  1150,
      -1,    -1,    26,  1178,   828,  1018,   508,  1150,    -1,    -1,
      57,  1178,   830,  1018,   831,    -1,    -1,   382,    -1,   156,
      -1,    -1,   402,   846,  1178,   833,  1018,   834,    -1,    -1,
     835,    -1,   836,    -1,   836,   835,    -1,   382,    -1,   156,
      -1,   538,    -1,    -1,    14,   846,  1178,   838,  1018,   841,
      -1,    -1,    58,  1178,   840,  1018,   841,    -1,    -1,   842,
      -1,   843,    -1,   843,   842,    -1,   382,    -1,   159,    -1,
     299,    -1,   156,    -1,    54,    -1,   172,   535,    -1,    -1,
     348,   846,  1178,   845,  1018,   841,    -1,    -1,   336,    -1,
     258,    -1,    -1,   401,  1178,   848,   850,    -1,   401,   537,
     618,   849,    -1,  1156,   508,  1156,    -1,   849,   585,  1156,
     508,  1156,    -1,   851,    -1,   850,   585,   851,    -1,  1147,
     508,  1147,    -1,    47,   217,   853,   229,   855,    -1,   854,
      -1,   853,   585,   854,    -1,  1147,   860,    -1,  1153,    -1,
     111,    -1,    -1,   257,   217,   226,    47,   857,   858,    -1,
     859,    -1,   858,   585,   859,    -1,  1147,   860,   863,    -1,
      -1,   861,   862,    -1,    -1,   784,   583,   969,   584,    -1,
      -1,   214,   247,    -1,   865,    -1,   430,   867,    -1,   583,
     866,   584,  1231,    -1,   430,   869,    -1,   583,   866,   584,
      -1,    -1,   869,   868,  1228,    -1,    -1,    -1,   870,   874,
     878,   871,   872,   877,    -1,   988,   994,    -1,  1010,    -1,
     873,    -1,  1010,   873,    -1,   873,  1010,    -1,   175,   942,
     977,   982,   979,   988,   994,  1001,    -1,   175,   130,   977,
     994,    -1,    -1,   875,    -1,   875,   876,    -1,   876,    -1,
     481,    -1,   204,    -1,   125,    -1,   470,    -1,   465,    -1,
     466,    -1,   468,    -1,   469,    -1,   467,    -1,    12,    -1,
      -1,   172,   534,    -1,   262,   229,   448,   310,    -1,   878,
     585,   879,    -1,   879,    -1,   577,    -1,   880,   882,   881,
     883,    -1,    -1,    -1,  1141,    -1,   885,    -1,    -1,    18,
    1153,    -1,    18,  1150,    -1,  1153,    -1,  1150,    -1,    -1,
     583,   584,    -1,    -1,   888,   886,   887,    -1,    -1,   887,
     901,   888,    -1,   888,   563,   888,    -1,    -1,   891,   889,
     890,    -1,    -1,   890,   902,   891,    -1,   333,   891,    -1,
     892,    -1,   893,   232,   514,    -1,   893,   232,   903,   514,
      -1,   893,   232,   158,    -1,   893,   232,   903,   158,    -1,
     893,   232,   530,    -1,   893,   232,   903,   530,    -1,   893,
      -1,   893,   232,   337,    -1,   893,   232,   903,   337,    -1,
     893,   146,   894,    -1,   893,   905,   894,    -1,   893,   905,
     906,   583,  1236,   584,    -1,   894,    -1,   895,   229,   583,
    1236,   584,    -1,   895,   903,   229,   583,  1236,   584,    -1,
     895,   229,   583,   885,   584,    -1,   895,   229,   583,   885,
     585,   931,   584,    -1,   895,   903,   229,   583,   885,   584,
      -1,   895,   903,   229,   583,   885,   585,   931,   584,    -1,
     895,   572,   895,    16,   894,    -1,   895,   903,   572,   895,
      16,   894,    -1,   895,   458,   252,   895,    -1,   895,   252,
     908,   981,    -1,   895,   903,   252,   908,   981,    -1,   895,
     395,   895,    -1,   895,   903,   395,   895,    -1,   895,    -1,
     895,   573,   896,    -1,   896,    -1,   896,   574,   897,    -1,
     897,    -1,   897,   449,   898,    -1,   897,   450,   898,    -1,
     898,    -1,   898,   576,   899,    -1,   898,   575,   899,    -1,
     898,   576,   907,   971,    -1,   898,   575,   907,   971,    -1,
     899,    -1,   899,   577,   900,    -1,   899,   578,   900,    -1,
     899,   579,   900,    -1,   899,   126,   900,    -1,   899,   313,
     900,    -1,   900,    -1,   900,   580,   908,    -1,   908,    -1,
     354,    -1,   351,    -1,    16,    -1,    15,    -1,   333,    -1,
     332,    -1,   586,    -1,   332,    -1,   145,    -1,   184,    -1,
     198,    -1,   244,    -1,   271,    -1,   328,    -1,    12,    -1,
      17,    -1,   225,   885,    -1,  1143,    -1,   908,    64,  1155,
      -1,  1138,    -1,  1136,    -1,   921,    -1,   917,    -1,   908,
     353,   908,    -1,   576,   908,    -1,   575,   908,    -1,   581,
     908,    -1,   904,   908,    -1,   583,  1236,   584,    -1,   583,
     885,   584,    -1,   583,   885,   585,   931,   584,    -1,   424,
     583,   885,   585,   931,   584,    -1,   152,   583,  1236,   584,
      -1,   587,  1153,   885,   588,    -1,   289,   934,     9,   583,
     895,   911,   584,    -1,    20,   583,   885,   584,    -1,    32,
     908,    -1,    51,   583,   885,    18,   929,   584,    -1,   571,
     938,   940,   939,   141,    -1,    83,   583,   885,   585,   929,
     584,    -1,    83,   583,   885,   540,   760,   584,    -1,   111,
     583,  1143,   584,    -1,   545,   583,  1144,   584,    -1,   180,
     583,   584,    -1,   181,   583,   885,   584,    -1,   182,   583,
     885,   585,   885,   584,    -1,   183,   583,   885,   585,   885,
     585,   885,   584,    -1,     7,   583,   885,   585,   885,   584,
      -1,     7,   583,   885,   585,   225,   885,   971,   584,    -1,
     404,   583,   885,   585,   885,   584,    -1,    22,   583,   885,
     584,    -1,    22,   583,   885,   585,   885,   584,    -1,    56,
     583,   931,   584,    -1,    56,   583,   931,   540,   760,   584,
      -1,    55,   583,   885,   584,    -1,    62,   583,   931,   584,
      -1,    65,   583,   885,   584,    -1,    73,   583,   931,   584,
      -1,    74,   583,   885,   585,   931,   584,    -1,    84,   583,
     885,   585,   885,   585,   885,   584,    -1,    90,   884,    -1,
      93,   884,    -1,    93,   583,   885,   584,    -1,    91,   884,
      -1,    98,   583,   885,   585,   907,   971,   584,    -1,    99,
     583,   885,   585,   907,   971,   584,    -1,    94,   583,   584,
      -1,   100,   583,   885,   584,    -1,   105,   583,   885,   584,
      -1,   136,   583,   885,   585,   931,   584,    -1,   272,   583,
     885,   585,   931,   584,    -1,   140,   583,   885,   584,    -1,
     140,   583,   885,   585,   885,   584,    -1,   110,   583,   885,
     585,  1151,   584,    -1,   139,   583,   885,   585,  1151,   584,
      -1,   118,   583,   885,   584,    -1,   118,   583,   885,   585,
     885,   584,    -1,   119,   583,   885,   584,    -1,   119,   583,
     885,   585,   885,   584,    -1,   155,   583,   885,   585,   885,
     585,   885,   584,    -1,   155,   583,   885,   585,   885,   585,
     885,   585,   885,   584,    -1,   155,   583,   885,   585,   885,
     585,   885,   585,   885,   585,   885,   584,    -1,   171,   583,
     885,   585,   338,   584,    -1,   176,   583,   885,   584,    -1,
     176,   583,   885,   585,   885,   584,    -1,   162,   583,   885,
     585,   931,   584,    -1,   910,    -1,   190,   583,   973,   585,
     885,   584,    -1,   209,   583,   885,   584,    -1,   213,   583,
     885,   585,   885,   585,   885,   584,    -1,   223,   583,   885,
     585,   885,   585,   885,   585,   885,   584,    -1,   907,   971,
     576,   885,    -1,   907,    -1,   242,   583,   584,    -1,   242,
     583,   885,   584,    -1,   249,   583,   885,   585,   885,   584,
      -1,   259,   583,   885,   585,   885,   584,    -1,   259,   583,
     885,   585,   885,   585,   885,   584,    -1,   194,   583,   885,
     585,   931,   584,    -1,   246,   583,   885,   585,   931,   584,
      -1,   264,   583,   885,   584,    -1,   264,   583,   885,   585,
     885,   584,    -1,   279,   583,   885,   585,   885,   584,    -1,
     279,   583,   885,   585,   885,   585,   885,   584,    -1,   302,
     583,   885,   584,    -1,   306,   583,   885,   584,    -1,   313,
     583,   885,   585,   885,   584,    -1,   314,   583,   885,   584,
      -1,   334,   884,    -1,   334,   583,   885,   584,    -1,   361,
     583,   885,   584,    -1,   343,   583,   885,   584,    -1,   368,
     583,   895,   229,   885,   584,    -1,   380,   583,   885,   584,
      -1,   388,   583,   885,   584,    -1,   388,   583,   584,    -1,
     405,   583,   885,   585,   885,   585,   885,   584,    -1,   416,
     583,   885,   585,   885,   584,    -1,   419,   583,   885,   584,
      -1,   419,   583,   885,   585,   885,   584,    -1,   422,   583,
     584,    -1,   432,   583,   931,   584,    -1,   483,   583,   885,
     585,   885,   584,    -1,   483,   583,   885,   585,   225,   885,
     971,   584,    -1,   428,   583,   885,   584,    -1,   485,   583,
     885,   585,   885,   585,   885,   584,    -1,   485,   583,   885,
     585,   885,   584,    -1,   485,   583,   885,   175,   885,   172,
     885,   584,    -1,   485,   583,   885,   175,   885,   584,    -1,
     486,   583,   885,   585,   885,   585,   885,   584,    -1,   492,
     884,    -1,   492,   583,   885,   584,    -1,   504,   583,   885,
     584,    -1,   501,   583,   885,   584,    -1,   501,   583,   885,
     585,   885,   584,    -1,   502,   583,   972,   585,   885,   585,
     885,   584,    -1,   503,   583,   972,   585,   885,   585,   885,
     584,    -1,   513,   583,   885,   584,    -1,   513,   583,   245,
     885,   175,   885,   584,    -1,   513,   583,   509,   885,   175,
     885,   584,    -1,   513,   583,    43,   885,   175,   885,   584,
      -1,   513,   583,   245,   175,   885,   584,    -1,   513,   583,
     509,   175,   885,   584,    -1,   513,   583,    43,   175,   885,
     584,    -1,   513,   583,   885,   175,   885,   584,    -1,   515,
     583,   885,   585,   885,   584,    -1,  1153,   590,  1153,   583,
     930,   584,    -1,    -1,  1149,   583,   909,   912,   584,    -1,
     528,   583,  1134,   585,   338,   585,   338,   585,   931,   584,
      -1,   529,   583,   584,    -1,   529,   583,   885,   584,    -1,
     537,   583,   584,    -1,   541,   884,    -1,   543,   884,    -1,
     542,   884,    -1,   554,   583,   885,   584,    -1,   554,   583,
     885,   585,   885,   584,    -1,   566,   583,   885,   584,    -1,
     564,   583,   885,   584,    -1,   564,   583,   885,   585,   885,
     584,    -1,    29,   583,   999,   585,   885,   584,    -1,   157,
     583,   971,   175,   885,   584,    -1,    80,   583,   885,   585,
     885,   584,    -1,   188,   583,   885,   584,    -1,   188,   583,
     885,   585,   885,   584,    -1,   189,   583,   885,   584,    -1,
     189,   583,   885,   585,   885,   584,    -1,   186,   583,   931,
     584,    -1,   256,   583,   931,   584,    -1,   317,   583,   931,
     584,    -1,   309,   583,   885,   584,    -1,   309,   583,   885,
     585,   885,   584,    -1,   315,   583,   885,   584,    -1,   315,
     583,   885,   585,   885,   584,    -1,   316,   583,   885,   584,
      -1,   316,   583,   885,   585,   885,   584,    -1,   318,   583,
     931,   584,    -1,   319,   583,   931,   584,    -1,   365,   583,
     885,   585,   885,   584,    -1,   364,   583,   885,   584,    -1,
     364,   583,   885,   585,   885,   584,    -1,   366,   583,   885,
     584,    -1,   366,   583,   885,   585,   885,   584,    -1,   367,
     583,   931,   584,    -1,   185,   583,   885,   584,    -1,   185,
     583,   885,   585,   885,   584,    -1,   254,   583,   885,   584,
      -1,   254,   583,   885,   585,   885,   584,    -1,    -1,   558,
     381,   154,    -1,   229,    41,   310,    -1,    -1,   913,    -1,
      -1,   914,   915,    -1,   916,    -1,   915,   585,   916,    -1,
     880,   885,   881,   883,    -1,    25,   583,   927,   584,    -1,
      25,   583,   125,   927,   584,    -1,    35,   583,   927,   584,
      -1,    36,   583,   927,   584,    -1,    38,   583,   927,   584,
      -1,    85,   583,   976,   577,   584,    -1,    85,   583,   927,
     584,    -1,    -1,    -1,    85,   583,   125,   918,   931,   919,
     584,    -1,   197,   583,  1134,   585,   338,   585,   338,   585,
     927,   584,    -1,   308,   583,   927,   584,    -1,   308,   583,
     125,   927,   584,    -1,   293,   583,   927,   584,    -1,   293,
     583,   125,   927,   584,    -1,   477,   583,   927,   584,    -1,
     550,   583,   927,   584,    -1,   478,   583,   927,   584,    -1,
     544,   583,   927,   584,    -1,   487,   583,   927,   584,    -1,
     487,   583,   125,   927,   584,    -1,    -1,   196,   583,   924,
     920,   931,   926,   925,   584,    -1,    -1,   589,   922,   923,
      -1,  1155,   447,   885,    -1,  1155,    -1,   589,  1168,  1155,
     794,    -1,    -1,   125,    -1,    -1,   442,  1135,    -1,    -1,
     989,    -1,    -1,   976,   928,   885,    -1,    32,   753,    -1,
      56,   753,   769,    -1,   326,   753,    -1,   453,    -1,   453,
     227,    -1,   532,    -1,   532,   227,    -1,   100,    -1,   504,
      -1,    97,    -1,   108,   748,    -1,    -1,   931,    -1,    -1,
     932,   933,    -1,   885,    -1,   933,   585,   885,    -1,   935,
      -1,   583,   935,   584,    -1,    -1,   936,   937,    -1,  1143,
      -1,   937,   585,  1143,    -1,    -1,   885,    -1,    -1,   569,
     885,    -1,   555,   885,   570,   885,    -1,   940,   555,   885,
     570,   885,    -1,   953,    -1,   944,    -1,   943,    -1,   941,
      -1,   943,   585,   941,    -1,   941,   952,   941,    -1,   941,
     481,   953,    -1,    -1,   941,   952,   941,   344,   945,   885,
      -1,    -1,   941,   481,   953,   344,   946,   885,    -1,    -1,
     941,   952,   941,   540,   947,   583,   970,   584,    -1,   941,
     324,   236,   953,    -1,    -1,   941,   249,   963,   236,   941,
     344,   948,   885,    -1,    -1,   941,   249,   963,   236,   953,
     949,   540,   583,   970,   584,    -1,   941,   324,   249,   963,
     236,   953,    -1,    -1,   941,   416,   963,   236,   941,   344,
     950,   885,    -1,    -1,   941,   416,   963,   236,   953,   951,
     540,   583,   970,   584,    -1,   941,   324,   416,   963,   236,
     953,    -1,   236,    -1,   219,   236,    -1,    88,   236,    -1,
      -1,   954,  1147,   975,   965,    -1,    -1,   587,  1153,   941,
     249,   355,   236,   941,   344,   955,   885,   588,    -1,   962,
     961,   958,    -1,   583,   961,   956,  1231,   584,   975,    -1,
      -1,   961,   957,   943,    -1,    -1,    -1,   959,   874,   878,
     960,   725,    -1,    -1,   430,    -1,    -1,   355,    -1,    -1,
     172,   236,    -1,    -1,   539,   966,    -1,   169,   966,    -1,
     214,   966,    -1,    -1,   783,   964,   967,   583,   968,   584,
      -1,    -1,   969,    -1,   969,   585,  1153,    -1,  1153,    -1,
     372,    -1,  1153,    -1,   970,   585,  1153,    -1,   972,    -1,
     101,    -1,   102,    -1,   103,    -1,   104,    -1,   206,    -1,
     207,    -1,   208,    -1,   302,    -1,   304,    -1,   305,    -1,
     427,    -1,   565,    -1,   105,    -1,   554,    -1,   209,    -1,
     174,    -1,   306,    -1,   314,    -1,   380,    -1,   428,    -1,
     566,    -1,   100,    -1,   504,    -1,    97,    -1,   501,    -1,
      -1,    18,    -1,   145,    -1,    -1,   974,  1153,    -1,    -1,
      12,    -1,    -1,    -1,   556,   978,   885,    -1,    -1,    -1,
     201,   980,   885,    -1,   149,   908,    -1,    -1,    -1,   195,
      45,   983,   984,    -1,   983,   585,  1142,   992,    -1,  1142,
     992,    -1,    -1,   558,    89,    -1,   558,   418,    -1,   352,
      45,   986,    -1,   986,   585,   987,    -1,   987,    -1,  1144,
     992,    -1,    -1,   989,    -1,    -1,   352,    45,   990,   991,
      -1,   991,   585,  1142,   992,    -1,  1142,   992,    -1,    -1,
      19,    -1,   116,    -1,    -1,   995,    -1,    -1,   995,    -1,
     253,   996,    -1,   997,    -1,   997,   585,   997,    -1,   997,
     341,   997,    -1,  1136,    -1,   520,    -1,   267,    -1,   338,
      -1,    -1,   253,   997,    -1,   338,    -1,   203,    -1,   267,
      -1,   520,    -1,   107,    -1,   166,    -1,   338,    -1,   520,
      -1,   267,    -1,   107,    -1,   166,    -1,    -1,    -1,   374,
    1153,  1002,   583,  1003,   584,    -1,    -1,  1004,    -1,  1004,
     585,  1005,    -1,  1005,    -1,   880,   885,    -1,    -1,  1007,
    1008,    -1,  1008,   585,  1009,    -1,  1009,    -1,   589,  1155,
      -1,  1155,    -1,    -1,   226,  1011,  1012,    -1,    -1,   356,
    1152,  1013,  1123,  1126,    -1,   131,  1152,    -1,  1006,    -1,
      -1,   128,  1015,   931,    -1,   129,  1021,  1178,  1020,  1018,
     811,    -1,    -1,   129,   217,  1153,   344,  1147,  1017,    -1,
     129,    94,  1020,  1153,    -1,   129,   179,  1020,   619,    -1,
     129,   374,  1020,   619,    -1,   129,   537,   618,  1208,    -1,
     129,   552,  1020,  1018,   811,    -1,   129,   511,  1020,   619,
      -1,  1019,    -1,  1018,   585,  1019,    -1,  1147,    -1,    -1,
     213,   152,    -1,    -1,   496,    -1,    -1,    -1,   223,  1023,
    1028,   810,  1030,  1024,  1032,  1048,    -1,    -1,    -1,   405,
    1026,  1029,  1030,  1027,  1032,    -1,    -1,   270,    -1,   113,
      -1,   204,    -1,  1057,    -1,   113,    -1,   226,  1031,    -1,
    1031,    -1,  1019,    -1,  1035,    -1,   583,   584,  1035,    -1,
     583,  1034,   584,  1035,    -1,    -1,   446,  1033,  1039,    -1,
    1034,   585,  1140,    -1,  1140,    -1,   545,  1038,    -1,   546,
    1038,    -1,    -1,   704,  1036,  1228,    -1,    -1,   583,   704,
     584,  1037,  1231,    -1,  1038,   585,  1043,    -1,  1043,    -1,
    1039,   585,  1040,    -1,  1040,    -1,  1144,  1041,  1047,    -1,
     145,    -1,   447,    -1,    -1,  1041,    -1,    -1,   583,  1044,
    1045,   584,    -1,    -1,  1046,    -1,  1046,   585,  1047,    -1,
    1047,    -1,   885,    -1,   111,    -1,    -1,    -1,   344,   132,
    1049,   238,   534,  1055,    -1,    -1,    -1,   534,  1051,  1057,
     810,   942,   446,  1053,  1052,   977,   988,   998,    -1,  1053,
     585,  1054,    -1,  1054,    -1,  1144,  1041,  1047,    -1,  1055,
     585,  1056,    -1,  1056,    -1,  1144,  1041,  1047,    -1,    -1,
     270,    -1,    -1,   115,  1059,  1067,  1060,    -1,    -1,   175,
    1147,  1061,   977,   988,   998,    -1,    -1,  1064,  1062,   175,
     942,   977,    -1,    -1,   175,  1064,  1063,   540,   942,   977,
      -1,  1065,    -1,  1064,   585,  1065,    -1,  1153,  1066,   975,
      -1,  1153,   590,  1153,  1066,   975,    -1,    -1,   590,   577,
      -1,    -1,  1068,  1067,    -1,   382,    -1,   270,    -1,   214,
      -1,   515,  1070,  1019,    -1,    -1,   495,    -1,    -1,  1072,
      -1,  1073,    -1,  1072,   585,  1073,    -1,    86,    -1,   300,
      -1,    40,   230,    -1,    81,   491,    -1,   359,   160,    -1,
     231,    -1,   490,    -1,   459,    -1,    12,    -1,    -1,   172,
     381,   338,    -1,    -1,   451,  1076,  1077,    -1,    95,  1088,
      -1,  1084,   493,  1083,  1088,    -1,  1084,   512,  1083,  1088,
      -1,   495,   476,  1083,  1088,    -1,   347,   493,  1083,  1088,
      -1,    -1,   143,   721,  1078,  1080,    -1,  1084,    66,  1085,
    1147,  1083,  1088,    -1,   329,   287,   172,   455,   558,   275,
     145,  1150,    16,   276,   145,  1000,    16,   280,   145,   999,
      -1,  1081,   263,    -1,   455,   205,    -1,    -1,    33,   150,
    1086,  1087,  1079,   993,    -1,   785,  1085,  1147,  1083,   977,
      -1,    67,   516,    -1,   495,   516,    -1,  1082,   142,    -1,
     373,    -1,    85,   583,   577,   584,   553,    -1,    85,   583,
     577,   584,   147,    -1,   553,   993,    -1,   147,   993,    -1,
     378,    -1,   377,  1071,  1074,   993,    -1,  1167,   476,  1088,
      -1,   220,   476,    -1,   320,   476,    -1,  1084,   376,    -1,
    1167,   549,  1088,    -1,   759,  1088,    -1,    65,  1088,    -1,
      30,   263,    -1,   263,    -1,   193,    -1,   193,   172,  1156,
      -1,    87,    94,   714,  1153,    -1,    87,   495,  1147,    -1,
      87,   552,  1147,    -1,   287,   476,    -1,   455,   476,    -1,
      87,   374,   619,    -1,    87,   179,   619,    -1,   374,   476,
    1088,    -1,   179,   476,  1088,    -1,   374,    63,   619,    -1,
     179,    63,   619,    -1,   440,   476,  1083,  1088,    -1,   476,
      -1,   263,    -1,   287,    -1,    32,    -1,    -1,   480,    -1,
      -1,  1085,  1153,    -1,    -1,   177,    -1,   175,    -1,   229,
      -1,    -1,   229,  1150,    -1,    -1,   175,  1000,    -1,    -1,
     252,  1150,    -1,   556,   885,    -1,    -1,  1092,  1147,  1090,
    1094,    -1,    -1,  1092,  1093,  1091,   864,    -1,   116,    -1,
     117,    -1,    -1,   156,    -1,    -1,  1135,    -1,  1153,    -1,
      -1,   168,   846,  1096,  1097,    -1,  1097,   585,  1098,    -1,
    1098,    -1,    -1,  1178,  1099,  1100,    -1,   493,   558,   390,
     262,    -1,   381,    47,    -1,   205,    -1,   373,    -1,   263,
      -1,   476,    -1,   455,    -1,   287,    -1,   120,    -1,   409,
      -1,    -1,  1018,    -1,    -1,   408,  1102,  1103,    -1,  1103,
     585,  1104,    -1,  1104,    -1,   455,    -1,   287,    -1,   381,
      47,    -1,    -1,   379,  1106,  1107,    -1,  1081,   263,  1108,
      -1,   508,  1150,    -1,    27,   885,    -1,    -1,   239,  1110,
    1111,   885,    -1,    -1,    77,    -1,   381,    -1,   539,  1153,
      -1,    -1,   257,    96,  1114,  1115,    -1,   257,   495,  1147,
     175,   287,    -1,    -1,    -1,    -1,    -1,  1121,  1120,   218,
    1152,  1116,  1122,   226,  1117,   495,  1147,  1118,   762,  1119,
    1123,  1126,  1129,  1130,  1133,    -1,   175,   287,    -1,    -1,
     258,    -1,    -1,    75,    -1,   270,    -1,    -1,   405,    -1,
     214,    -1,    -1,    66,  1124,    -1,  1124,  1125,    -1,  1125,
      -1,   498,    45,  1135,    -1,   350,   138,    45,  1135,    -1,
     138,    45,  1135,    -1,   148,    45,  1135,    -1,    -1,   255,
    1127,    -1,  1127,  1128,    -1,  1128,    -1,   498,    45,  1135,
      -1,   474,    45,  1135,    -1,    -1,   214,   338,   255,    -1,
      -1,   583,  1131,   584,    -1,   583,   584,    -1,  1131,   585,
    1132,    -1,  1132,    -1,  1144,    -1,   589,  1155,    -1,    -1,
     446,  1055,    -1,  1151,    -1,   325,    -1,   523,   499,    -1,
    1134,  1151,    -1,  1151,    -1,   203,    -1,    34,    -1,   362,
      -1,  1138,    -1,   576,  1139,    -1,   575,  1139,    -1,  1134,
      -1,  1139,    -1,   337,    -1,   158,    -1,   514,    -1,   203,
      -1,    34,    -1,   523,   203,    -1,   523,    34,    -1,   100,
    1134,    -1,   504,  1134,    -1,   501,  1134,    -1,   338,    -1,
     267,    -1,   520,    -1,   107,    -1,   166,    -1,  1144,    -1,
    1141,    -1,  1153,   590,   577,    -1,  1153,   590,  1153,   590,
     577,    -1,   885,    -1,  1153,    -1,  1145,    -1,  1153,    -1,
    1145,    -1,  1153,   590,  1153,    -1,   590,  1153,   590,  1153,
      -1,  1153,   590,  1153,   590,  1153,    -1,  1153,    -1,  1153,
     590,  1153,   590,  1153,    -1,  1153,   590,  1153,    -1,   590,
    1153,    -1,  1153,    -1,  1153,   590,  1153,    -1,   590,  1153,
      -1,  1153,    -1,   210,    -1,   212,    -1,   499,    -1,   499,
      -1,   499,    -1,  1149,    -1,  1157,    -1,  1149,    -1,  1158,
      -1,  1153,    -1,  1150,    -1,   251,    -1,  1155,    -1,  1155,
     589,  1155,    -1,    91,   884,    -1,  1158,    -1,    20,    -1,
      26,    -1,    28,    -1,    46,    -1,    47,    -1,    55,    -1,
      57,    -1,    61,    -1,    68,    -1,    70,    -1,    80,    -1,
     106,    -1,   128,    -1,   141,    -1,   151,    -1,   168,    -1,
     199,    -1,   202,    -1,   241,    -1,   335,    -1,   347,    -1,
     370,    -1,   402,    -1,   408,    -1,   410,    -1,   417,    -1,
     426,    -1,   429,    -1,   453,    -1,   455,    -1,   475,    -1,
     479,    -1,   515,    -1,   525,    -1,   562,    -1,   535,    -1,
       5,    -1,     7,    -1,     8,    -1,     9,    -1,    10,    -1,
      11,    -1,    17,    -1,    23,    -1,    24,    -1,    25,    -1,
      30,    -1,    33,    -1,    37,    -1,    40,    -1,    42,    -1,
      41,    -1,    44,    -1,    50,    -1,    52,    -1,    54,    -1,
      59,    -1,    60,    -1,    63,    -1,    65,    -1,    66,    -1,
      69,    -1,    71,    -1,    72,    -1,    75,    -1,    77,    -1,
      78,    -1,    81,    -1,    86,    -1,    89,    -1,    96,    -1,
      97,    -1,   100,    -1,   105,    -1,   112,    -1,   114,    -1,
     120,    -1,   122,    -1,   124,    -1,   131,    -1,   132,    -1,
     133,    -1,   144,    -1,   143,    -1,   142,    -1,   147,    -1,
     149,    -1,   150,    -1,   154,    -1,   156,    -1,   159,    -1,
     160,    -1,   173,    -1,   123,    -1,   137,    -1,   177,    -1,
     163,    -1,   164,    -1,   165,    -1,   174,    -1,   187,    -1,
     186,    -1,   190,    -1,   193,    -1,   191,    -1,   200,    -1,
     205,    -1,   209,    -1,   211,    -1,   228,    -1,   215,    -1,
     216,    -1,   233,    -1,   234,    -1,   220,    -1,   224,    -1,
     230,    -1,   231,    -1,   398,    -1,   243,    -1,   247,    -1,
     250,    -1,   256,    -1,   258,    -1,   261,    -1,   263,    -1,
     292,    -1,   287,    -1,   274,    -1,   278,    -1,   275,    -1,
     276,    -1,   288,    -1,   277,    -1,   280,    -1,   273,    -1,
     286,    -1,   282,    -1,   281,    -1,   283,    -1,   284,    -1,
     285,    -1,   290,    -1,   291,    -1,   294,    -1,   295,    -1,
     299,    -1,   300,    -1,   301,    -1,   302,    -1,   303,    -1,
     306,    -1,   307,    -1,   312,    -1,   310,    -1,   314,    -1,
     317,    -1,   318,    -1,   319,    -1,   320,    -1,   322,    -1,
     321,    -1,   323,    -1,   326,    -1,   327,    -1,   330,    -1,
     329,    -1,   331,    -1,   340,    -1,   341,    -1,   343,    -1,
     345,    -1,   346,    -1,   358,    -1,   359,    -1,   360,    -1,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,   371,    -1,
     373,    -1,   375,    -1,   376,    -1,   377,    -1,   378,    -1,
     380,    -1,   381,    -1,   382,    -1,   383,    -1,   384,    -1,
     385,    -1,   386,    -1,   387,    -1,   392,    -1,   393,    -1,
     396,    -1,   397,    -1,   400,    -1,   403,    -1,   406,    -1,
     409,    -1,   412,    -1,   413,    -1,   418,    -1,   420,    -1,
     421,    -1,   423,    -1,   424,    -1,   425,    -1,   428,    -1,
     431,    -1,   433,    -1,   434,    -1,   435,    -1,   440,    -1,
     444,    -1,   443,    -1,   445,    -1,   454,    -1,   448,    -1,
     452,    -1,   457,    -1,   458,    -1,   459,    -1,   467,    -1,
     466,    -1,   469,    -1,   472,    -1,   476,    -1,   480,    -1,
     482,    -1,   483,    -1,   484,    -1,   488,    -1,   489,    -1,
     490,    -1,   491,    -1,   493,    -1,   494,    -1,   496,    -1,
     497,    -1,   500,    -1,   510,    -1,   512,    -1,   501,    -1,
     502,    -1,   503,    -1,   504,    -1,   516,    -1,   517,    -1,
     518,    -1,   179,    -1,   521,    -1,   522,    -1,   530,    -1,
     533,    -1,   537,    -1,   538,    -1,   549,    -1,   552,    -1,
     546,    -1,   553,    -1,   554,    -1,   559,    -1,   561,    -1,
     566,    -1,    -1,   446,  1161,  1160,  1162,    -1,    -1,   349,
      -1,  1163,    -1,  1162,   585,  1163,    -1,    -1,  1164,  1169,
      -1,  1166,    -1,   191,    -1,   258,    -1,   445,    -1,    -1,
     345,    -1,    -1,   191,    -1,   258,    -1,   445,    -1,    -1,
     191,   590,    -1,   258,   590,    -1,   445,   590,    -1,  1170,
      -1,  1166,  1171,    -1,  1165,  1172,  1041,  1175,    -1,  1165,
     510,   233,   250,  1173,    -1,   589,  1155,  1041,   885,    -1,
     589,   589,  1168,  1172,  1041,  1175,    -1,   759,   764,    -1,
     321,  1041,   885,    -1,   321,   761,   766,    -1,   361,  1041,
    1174,    -1,   361,   172,  1156,  1041,  1174,    -1,  1153,    -1,
    1153,   590,  1153,    -1,   111,   590,  1153,    -1,   390,   521,
      -1,   390,    69,    -1,   403,   390,    -1,   443,    -1,   499,
      -1,   361,   583,   499,   584,    -1,   343,   583,   499,   584,
      -1,   885,    -1,   111,    -1,   344,    -1,    12,    -1,    32,
      -1,    -1,   262,  1178,  1177,  1179,    -1,   495,    -1,   493,
      -1,  1180,    -1,  1179,   585,  1180,    -1,  1147,   975,  1181,
      -1,   390,    -1,   560,    -1,   270,   560,    -1,   390,   258,
      -1,    -1,   531,  1183,  1178,    -1,   199,  1147,   347,   975,
      -1,   199,  1148,    61,    -1,    -1,   199,  1148,   390,  1185,
    1186,   977,   994,    -1,  1187,    -1,  1153,  1188,    -1,   164,
      -1,   330,    -1,   164,    -1,   330,    -1,   371,    -1,   243,
      -1,    -1,  1190,  1189,   583,  1046,   584,    -1,   145,    -1,
     184,    -1,   244,    -1,   198,    -1,   271,    -1,   415,   618,
    1192,    -1,  1196,   344,  1195,  1207,   175,  1209,    -1,  1196,
     344,   179,  1207,   175,  1209,    -1,  1196,   344,   374,  1207,
     175,  1209,    -1,    12,  1197,   585,   192,   349,   175,  1209,
      -1,   192,   618,  1194,    -1,  1196,   344,  1195,  1207,   508,
    1209,  1214,  1215,    -1,  1196,   344,   179,  1207,   508,  1209,
    1214,  1215,    -1,  1196,   344,   374,  1207,   508,  1209,  1214,
    1215,    -1,    -1,   495,    -1,  1198,    -1,    12,  1197,    -1,
      -1,   373,    -1,  1199,    -1,  1198,   585,  1199,    -1,    -1,
     430,  1200,  1211,    -1,    -1,   223,  1201,  1211,    -1,    -1,
     534,  1202,  1211,    -1,    -1,   394,  1203,  1211,    -1,   115,
      -1,   536,    -1,   217,    -1,    13,    -1,    87,    -1,   129,
      -1,   151,    -1,   400,    -1,   452,    -1,   375,    -1,   163,
      -1,   192,   349,    -1,   451,    95,    -1,   488,    -1,    87,
     496,   493,    -1,   262,   493,    -1,   406,   455,    -1,   406,
      60,    -1,    87,   552,    -1,   451,   552,    -1,    87,   420,
      -1,    13,   420,    -1,    87,   537,    -1,    -1,    16,    -1,
    1206,  1204,  1205,    -1,  1206,    -1,   484,   499,    -1,   234,
     499,    -1,    59,   499,    -1,   577,    -1,  1153,   590,   577,
      -1,   577,   590,   577,    -1,  1147,    -1,  1156,    -1,  1208,
     585,  1156,    -1,  1210,    -1,  1209,   585,  1210,    -1,  1156,
     211,    45,   499,    -1,  1156,   211,    45,   361,   499,    -1,
    1156,    -1,    -1,   583,  1212,   584,    -1,  1212,   585,  1213,
      -1,  1213,    -1,  1153,    -1,    -1,   407,  1205,    -1,   407,
     473,    -1,   407,   561,    -1,   407,   331,    -1,    -1,   558,
    1216,    -1,  1216,  1217,    -1,  1217,    -1,   192,   349,    -1,
     291,   999,    -1,   294,   999,    -1,   290,   999,    -1,   295,
     999,    -1,    -1,    28,  1219,  1220,    -1,    -1,   559,    -1,
      -1,    16,   335,    52,    -1,    16,    52,    -1,    -1,   399,
      -1,   335,   399,    -1,    -1,   426,    -1,    70,  1220,  1221,
    1222,    -1,   417,  1220,  1221,  1222,    -1,   417,  1220,   508,
    1223,  1153,    -1,   426,  1153,    -1,   399,   426,  1153,    -1,
      -1,  1229,    -1,    -1,   526,  1235,  1230,   865,    -1,    -1,
    1229,    -1,  1232,    -1,    -1,  1233,  1234,    -1,   989,   993,
      -1,   995,    -1,    -1,   125,    -1,    12,    -1,   430,  1239,
    1238,  1240,    -1,    -1,   583,  1239,  1236,   584,  1237,  1228,
    1240,    -1,   867,    -1,    -1,    -1,  1243,  1242,    -1,  1244,
    1243,  1249,    -1,  1249,    -1,  1257,    -1,  1259,    -1,    -1,
     112,   145,  1156,    -1,  1245,    -1,  1245,  1246,    -1,  1246,
      -1,   354,   405,    -1,    11,   145,   522,    -1,    11,   145,
     301,    -1,    11,   145,   497,    -1,    -1,  1246,    -1,    -1,
     471,   429,   112,    -1,   471,   429,   228,    -1,    -1,  1248,
     552,  1147,  1250,  1251,    18,  1253,  1256,    -1,    -1,   583,
    1252,   584,    -1,  1153,    -1,  1252,   585,  1153,    -1,    -1,
    1254,  1255,    -1,   430,   880,   867,    -1,   583,   880,   866,
     584,  1231,    -1,    -1,   558,    58,   349,    -1,   558,    50,
      58,   349,    -1,   558,   258,    58,   349,    -1,    -1,   511,
     880,   619,   696,   697,   344,   880,  1147,   172,   880,   134,
     424,  1258,   660,    -1,    -1,   726,   880,   179,   619,  1260,
     620,    -1,    -1,    -1,    -1,    -1,   374,   880,   619,  1261,
     583,  1262,   640,   584,  1263,   627,  1264,   660,    -1,   562,
    1267,  1266,  1268,    -1,   562,   141,  1266,  1270,    -1,   562,
     370,  1266,    -1,   562,    70,  1266,  1269,    -1,   562,   417,
    1266,    -1,   562,   392,    -1,  1135,    -1,  1135,   585,  1135,
      -1,  1135,   585,  1135,   585,   999,    -1,    28,    -1,   475,
      -1,    -1,   236,    -1,   412,    -1,    -1,   346,   363,    -1,
      -1,    -1,   489,  1271,  1272,    -1,    -1,   172,   303,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,  1226,  1226,  1240,  1243,  1244,  1249,  1250,  1251,  1252,
    1253,  1254,  1255,  1256,  1257,  1258,  1259,  1260,  1261,  1262,
    1263,  1264,  1265,  1266,  1267,  1268,  1269,  1270,  1271,  1272,
    1273,  1274,  1275,  1276,  1277,  1278,  1279,  1280,  1281,  1282,
    1283,  1284,  1285,  1286,  1287,  1288,  1289,  1290,  1291,  1292,
    1293,  1294,  1295,  1299,  1308,  1309,  1314,  1323,  1330,  1340,
    1339,  1350,  1352,  1356,  1357,  1360,  1373,  1372,  1391,  1390,
    1401,  1402,  1405,  1410,  1415,  1420,  1425,  1429,  1434,  1438,
    1442,  1446,  1450,  1455,  1459,  1463,  1479,  1483,  1495,  1494,
    1517,  1516,  1543,  1542,  1555,  1554,  1562,  1570,  1584,  1599,
    1617,  1637,  1676,  1684,  1692,  1704,  1636,  1735,  1736,  1740,
    1741,  1746,  1748,  1750,  1752,  1754,  1756,  1758,  1764,  1765,
    1766,  1770,  1774,  1782,  1781,  1794,  1796,  1799,  1801,  1805,
    1809,  1816,  1818,  1822,  1823,  1828,  1847,  1873,  1875,  1879,
    1880,  1884,  1910,  1911,  1912,  1913,  1917,  1918,  1922,  1923,
    1928,  1931,  1958,  1957,  2013,  2028,  2027,  2071,  2095,  2095,
    2126,  2127,  2132,  2134,  2139,  2162,  2168,  2183,  2184,  2188,
    2192,  2201,  2206,  2211,  2219,  2234,  2252,  2253,  2257,  2257,
    2307,  2306,  2330,  2329,  2333,  2334,  2336,  2336,  2347,  2376,
    2404,  2420,  2419,  2436,  2453,  2455,  2456,  2460,  2481,  2504,
    2506,  2520,  2504,  2538,  2540,  2541,  2545,  2546,  2551,  2557,
    2550,  2576,  2575,  2591,  2592,  2596,  2597,  2602,  2606,  2601,
    2623,  2627,  2622,  2642,  2650,  2655,  2654,  2692,  2693,  2698,
    2697,  2724,  2735,  2737,  2734,  2761,  2760,  2778,  2780,  2785,
    2787,  2789,  2794,  2795,  2796,  2802,  2811,  2812,  2812,  2816,
    2818,  2817,  2820,  2819,  2825,  2841,  2824,  2855,  2856,  2859,
    2860,  2863,  2864,  2867,  2868,  2871,  2872,  2875,  2876,  2879,
    2882,  2883,  2885,  2887,  2890,  2891,  2894,  2895,  2896,  2899,
    2900,  2901,  2902,  2903,  2904,  2905,  2906,  2907,  2922,  2928,
    2929,  2930,  2931,  2936,  2941,  2946,  2961,  2962,  2963,  2964,
    2965,  2966,  2970,  2987,  3003,  3013,  3014,  3015,  3016,  3017,
    3018,  3021,  3022,  3023,  3026,  3027,  3028,  3031,  3032,  3035,
    3036,  3039,  3040,  3041,  3042,  3045,  3046,  3050,  3051,  3055,
    3056,  3066,  3080,  3095,  3115,  3122,  3131,  3133,  3137,  3141,
    3142,  3146,  3151,  3150,  3172,  3173,  3174,  3175,  3177,  3179,
    3181,  3183,  3185,  3187,  3190,  3193,  3196,  3199,  3201,  3204,
    3207,  3208,  3209,  3210,  3223,  3224,  3226,  3228,  3240,  3242,
    3244,  3246,  3247,  3248,  3249,  3250,  3251,  3253,  3255,  3257,
    3257,  3259,  3259,  3261,  3262,  3271,  3272,  3273,  3276,  3277,
    3278,  3279,  3280,  3284,  3288,  3289,  3293,  3294,  3298,  3299,
    3300,  3301,  3302,  3306,  3307,  3308,  3309,  3310,  3313,  3315,
    3316,  3320,  3321,  3322,  3325,  3332,  3333,  3336,  3337,  3340,
    3341,  3342,  3345,  3346,  3349,  3350,  3353,  3354,  3357,  3358,
    3361,  3362,  3363,  3364,  3366,  3367,  3373,  3379,  3385,  3391,
    3392,  3408,  3409,  3413,  3414,  3418,  3426,  3430,  3431,  3434,
    3435,  3439,  3448,  3452,  3453,  3456,  3466,  3467,  3471,  3472,
    3475,  3476,  3479,  3480,  3481,  3482,  3491,  3492,  3495,  3496,
    3499,  3500,  3501,  3510,  3512,  3514,  3519,  3518,  3530,  3531,
    3534,  3535,  3539,  3540,  3543,  3544,  3547,  3548,  3549,  3550,
    3551,  3554,  3555,  3556,  3557,  3558,  3561,  3562,  3563,  3575,
    3576,  3579,  3580,  3583,  3584,  3588,  3589,  3590,  3593,  3594,
    3595,  3596,  3609,  3610,  3611,  3614,  3615,  3619,  3620,  3623,
    3624,  3627,  3632,  3637,  3642,  3647,  3652,  3657,  3662,  3667,
    3672,  3677,  3682,  3693,  3694,  3697,  3698,  3709,  3710,  3713,
    3714,  3717,  3718,  3726,  3725,  3752,  3751,  3766,  3765,  3784,
    3783,  3803,  3801,  3816,  3817,  3819,  3820,  3821,  3822,  3823,
    3826,  3834,  3835,  3839,  3844,  3843,  3851,  3860,  3850,  3872,
    3879,  3883,  3890,  3897,  3903,  3909,  3915,  3922,  3941,  3962,
    3967,  3971,  3978,  3979,  3982,  3983,  3987,  3988,  3989,  3993,
    3994,  3995,  3998,  3999,  4000,  4001,  4009,  4008,  4019,  4027,
    4026,  4036,  4046,  4055,  4056,  4063,  4063,  4069,  4070,  4074,
    4075,  4076,  4080,  4081,  4098,  4099,  4104,  4103,  4114,  4113,
    4124,  4123,  4133,  4134,  4135,  4140,  4139,  4151,  4152,  4155,
    4156,  4159,  4160,  4161,  4165,  4164,  4177,  4176,  4193,  4194,
    4197,  4198,  4201,  4202,  4203,  4204,  4205,  4206,  4210,  4209,
    4221,  4222,  4223,  4228,  4227,  4233,  4240,  4245,  4253,  4254,
    4257,  4269,  4278,  4279,  4282,  4295,  4296,  4301,  4300,  4310,
    4311,  4314,  4327,  4327,  4337,  4338,  4347,  4348,  4357,  4366,
    4368,  4371,  4393,  4397,  4396,  4416,  4424,  4416,  4430,  4431,
    4432,  4433,  4434,  4437,  4444,  4451,  4453,  4464,  4465,  4468,
    4469,  4475,  4476,  4477,  4478,  4484,  4490,  4496,  4506,  4509,
    4511,  4517,  4527,  4528,  4529,  4542,  4562,  4569,  4576,  4577,
    4580,  4581,  4582,  4583,  4584,  4588,  4589,  4593,  4593,  4610,
    4612,  4617,  4618,  4618,  4635,  4637,  4642,  4643,  4646,  4648,
    4650,  4652,  4654,  4655,  4656,  4660,  4661,  4662,  4663,  4665,
    4667,  4670,  4674,  4680,  4684,  4690,  4694,  4702,  4704,  4710,
    4713,  4715,  4717,  4718,  4720,  4723,  4724,  4727,  4728,  4731,
    4733,  4735,  4738,  4739,  4740,  4742,  4744,  4747,  4748,  4749,
    4750,  4751,  4752,  4755,  4756,  4758,  4758,  4759,  4759,  4760,
    4760,  4761,  4761,  4763,  4764,  4765,  4766,  4767,  4768,  4771,
    4772,  4776,  4780,  4781,  4788,  4789,  4790,  4791,  4792,  4794,
    4795,  4796,  4797,  4798,  4802,  4803,  4808,  4813,  4817,  4818,
    4822,  4823,  4827,  4834,  4836,  4842,  4844,  4855,  4857,  4868,
    4879,  4890,  4901,  4903,  4905,  4907,  4909,  4911,  4913,  4915,
    4917,  4919,  4921,  4923,  4925,  4931,  4933,  4935,  4940,  4945,
    4947,  4949,  4954,  4956,  4958,  4960,  4962,  4967,  4968,  4970,
    4972,  4974,  4976,  4978,  4980,  4982,  4984,  4986,  4988,  4990,
    4994,  4996,  5006,  5008,  5010,  5012,  5014,  5017,  5026,  5031,
    5036,  5038,  5040,  5042,  5044,  5046,  5048,  5050,  5055,  5060,
    5062,  5064,  5066,  5068,  5070,  5072,  5078,  5080,  5082,  5084,
    5086,  5088,  5090,  5092,  5094,  5095,  5101,  5106,  5108,  5110,
    5112,  5114,  5116,  5118,  5120,  5122,  5129,  5136,  5138,  5140,
    5142,  5144,  5146,  5148,  5150,  5152,  5154,  5156,  5158,  5160,
    5162,  5164,  5178,  5177,  5294,  5298,  5303,  5305,  5307,  5309,
    5311,  5313,  5318,  5320,  5322,  5324,  5326,  5331,  5335,  5337,
    5339,  5341,  5343,  5345,  5349,  5352,  5355,  5357,  5359,  5361,
    5363,  5365,  5367,  5370,  5373,  5375,  5377,  5379,  5381,  5383,
    5386,  5388,  5390,  5392,  5397,  5398,  5399,  5403,  5404,  5408,
    5408,  5414,  5418,  5425,  5456,  5458,  5460,  5462,  5464,  5466,
    5468,  5471,  5473,  5470,  5476,  5478,  5485,  5487,  5489,  5491,
    5493,  5495,  5497,  5499,  5501,  5504,  5503,  5518,  5517,  5532,
    5538,  5544,  5557,  5558,  5561,  5562,  5567,  5570,  5582,  5581,
    5597,  5598,  5599,  5600,  5601,  5602,  5603,  5604,  5605,  5606,
    5607,  5611,  5612,  5616,  5616,  5621,  5622,  5625,  5626,  5629,
    5629,  5634,  5635,  5638,  5639,  5642,  5643,  5646,  5652,  5662,
    5663,  5672,  5677,  5678,  5698,  5700,  5704,  5702,  5719,  5717,
    5735,  5733,  5740,  5749,  5747,  5765,  5764,  5774,  5785,  5783,
    5802,  5801,  5812,  5822,  5823,  5824,  5829,  5829,  5848,  5846,
    5865,  5887,  5935,  5934,  5957,  5975,  5957,  5982,  5986,  6012,
    6013,  6015,  6017,  6020,  6021,  6027,  6034,  6043,  6042,  6049,
    6050,  6054,  6058,  6062,  6068,  6076,  6085,  6086,  6087,  6088,
    6089,  6090,  6091,  6092,  6093,  6094,  6095,  6096,  6097,  6100,
    6101,  6102,  6103,  6104,  6105,  6106,  6107,  6108,  6112,  6113,
    6114,  6115,  6118,  6120,  6121,  6124,  6125,  6128,  6130,  6134,
    6136,  6135,  6149,  6152,  6151,  6166,  6172,  6185,  6187,  6190,
    6192,  6196,  6197,  6210,  6228,  6232,  6233,  6237,  6250,  6252,
    6256,  6255,  6287,  6289,  6293,  6294,  6295,  6300,  6306,  6310,
    6311,  6315,  6319,  6326,  6333,  6342,  6346,  6347,  6348,  6353,
    6357,  6365,  6366,  6367,  6368,  6369,  6370,  6374,  6375,  6376,
    6377,  6378,  6381,  6384,  6383,  6412,  6413,  6416,  6417,  6420,
    6435,  6435,  6445,  6446,  6450,  6462,  6495,  6494,  6507,  6506,
    6515,  6527,  6538,  6537,  6554,  6561,  6561,  6573,  6580,  6592,
    6604,  6608,  6614,  6624,  6625,  6628,  6636,  6637,  6641,  6642,
    6650,  6659,  6649,  6669,  6676,  6668,  6686,  6698,  6699,  6700,
    6704,  6705,  6708,  6709,  6712,  6721,  6722,  6723,  6725,  6724,
    6734,  6735,  6738,  6739,  6740,  6740,  6741,  6741,  6745,  6746,
    6749,  6751,  6754,  6762,  6763,  6767,  6768,  6773,  6772,  6785,
    6786,  6789,  6794,  6802,  6803,  6806,  6808,  6808,  6816,  6825,
    6815,  6847,  6848,  6851,  6858,  6859,  6862,  6871,  6872,  6878,
    6877,  6891,  6890,  6899,  6898,  6906,  6905,  6915,  6916,  6919,
    6926,  6939,  6940,  6944,  6945,  6948,  6949,  6950,  6953,  6963,
    6965,  6967,  6969,  6972,  6973,  6976,  6980,  6984,  6988,  6992,
    6996,  7000,  7004,  7008,  7016,  7019,  7028,  7027,  7041,  7049,
    7058,  7067,  7076,  7086,  7085,  7088,  7098,  7108,  7112,  7117,
    7116,  7121,  7131,  7136,  7142,  7147,  7152,  7154,  7156,  7158,
    7160,  7162,  7170,  7179,  7181,  7183,  7185,  7194,  7202,  7210,
    7212,  7214,  7224,  7231,  7237,  7245,  7253,  7257,  7261,  7268,
    7275,  7285,  7295,  7305,  7316,  7325,  7339,  7352,  7353,  7355,
    7357,  7360,  7361,  7364,  7365,  7368,  7369,  7372,  7373,  7376,
    7377,  7379,  7381,  7384,  7396,  7395,  7410,  7409,  7419,  7420,
    7423,  7424,  7428,  7429,  7430,  7438,  7437,  7449,  7450,  7453,
    7453,  7454,  7455,  7456,  7457,  7458,  7459,  7460,  7461,  7462,
    7463,  7466,  7467,  7471,  7470,  7479,  7480,  7483,  7484,  7485,
    7489,  7488,  7498,  7502,  7506,  7518,  7518,  7526,  7527,  7528,
    7533,  7543,  7542,  7558,  7576,  7587,  7594,  7604,  7575,  7609,
    7618,  7619,  7622,  7623,  7635,  7639,  7640,  7641,  7643,  7645,
    7648,  7649,  7652,  7657,  7664,  7669,  7675,  7677,  7680,  7681,
    7684,  7689,  7695,  7697,  7704,  7705,  7706,  7709,  7711,  7716,
    7717,  7722,  7723,  7729,  7734,  7736,  7738,  7743,  7745,  7756,
    7769,  7790,  7791,  7792,  7801,  7802,  7803,  7808,  7809,  7810,
    7811,  7812,  7826,  7840,  7841,  7842,  7845,  7846,  7847,  7848,
    7856,  7871,  7872,  7875,  7881,  7892,  7895,  7931,  7935,  7943,
    7947,  8015,  8030,  8054,  8055,  8071,  8081,  8084,  8085,  8086,
    8090,  8094,  8095,  8120,  8132,  8145,  8157,  8158,  8167,  8168,
    8177,  8178,  8179,  8182,  8195,  8208,  8222,  8223,  8224,  8225,
    8226,  8227,  8228,  8229,  8230,  8231,  8232,  8233,  8234,  8235,
    8236,  8237,  8238,  8239,  8240,  8241,  8242,  8243,  8244,  8245,
    8246,  8247,  8248,  8249,  8250,  8251,  8252,  8253,  8254,  8255,
    8256,  8257,  8258,  8268,  8269,  8270,  8271,  8272,  8273,  8274,
    8275,  8276,  8277,  8278,  8279,  8280,  8281,  8282,  8283,  8284,
    8285,  8286,  8287,  8288,  8289,  8290,  8291,  8292,  8293,  8294,
    8295,  8296,  8297,  8298,  8299,  8300,  8301,  8302,  8303,  8304,
    8305,  8306,  8307,  8308,  8309,  8310,  8311,  8312,  8313,  8314,
    8315,  8316,  8317,  8318,  8319,  8320,  8321,  8322,  8323,  8324,
    8325,  8326,  8327,  8328,  8329,  8330,  8331,  8332,  8333,  8334,
    8335,  8336,  8337,  8338,  8339,  8340,  8341,  8342,  8343,  8344,
    8345,  8346,  8347,  8348,  8349,  8350,  8351,  8352,  8353,  8354,
    8355,  8356,  8357,  8358,  8359,  8360,  8361,  8362,  8363,  8364,
    8365,  8366,  8367,  8368,  8369,  8370,  8371,  8372,  8373,  8374,
    8375,  8376,  8377,  8378,  8379,  8380,  8381,  8382,  8383,  8384,
    8385,  8386,  8387,  8388,  8389,  8390,  8391,  8392,  8393,  8394,
    8395,  8396,  8397,  8398,  8399,  8400,  8401,  8402,  8403,  8404,
    8405,  8406,  8407,  8408,  8409,  8410,  8411,  8412,  8413,  8414,
    8415,  8416,  8417,  8418,  8419,  8420,  8421,  8422,  8423,  8424,
    8425,  8426,  8427,  8428,  8429,  8430,  8431,  8432,  8433,  8434,
    8435,  8436,  8437,  8438,  8439,  8440,  8441,  8442,  8443,  8444,
    8445,  8446,  8447,  8448,  8449,  8450,  8451,  8452,  8453,  8454,
    8455,  8456,  8457,  8458,  8459,  8460,  8461,  8462,  8463,  8464,
    8465,  8466,  8467,  8468,  8469,  8470,  8471,  8472,  8473,  8474,
    8475,  8476,  8477,  8478,  8479,  8480,  8481,  8482,  8483,  8484,
    8485,  8486,  8487,  8488,  8489,  8490,  8491,  8492,  8493,  8494,
    8495,  8496,  8497,  8498,  8505,  8504,  8518,  8519,  8522,  8523,
    8526,  8526,  8603,  8604,  8605,  8606,  8610,  8611,  8615,  8616,
    8617,  8618,  8622,  8623,  8624,  8625,  8629,  8630,  8633,  8713,
    8726,  8730,  8735,  8742,  8757,  8770,  8791,  8798,  8836,  8879,
    8893,  8894,  8895,  8896,  8900,  8901,  8908,  8917,  8918,  8919,
    8920,  8921,  8929,  8928,  8944,  8945,  8948,  8949,  8952,  8960,
    8961,  8962,  8963,  8968,  8967,  8988,  9000,  9013,  9012,  9031,
    9032,  9036,  9037,  9041,  9042,  9043,  9044,  9046,  9045,  9056,
    9057,  9058,  9059,  9060,  9066,  9071,  9078,  9091,  9103,  9110,
    9115,  9123,  9136,  9150,  9152,  9155,  9156,  9163,  9165,  9169,
    9170,  9173,  9173,  9174,  9174,  9175,  9175,  9176,  9176,  9177,
    9178,  9179,  9180,  9181,  9182,  9183,  9184,  9185,  9186,  9187,
    9188,  9189,  9190,  9191,  9192,  9193,  9194,  9195,  9196,  9197,
    9198,  9199,  9204,  9205,  9209,  9210,  9214,  9224,  9234,  9247,
    9262,  9275,  9288,  9301,  9302,  9311,  9312,  9321,  9346,  9348,
    9355,  9359,  9362,  9363,  9366,  9387,  9388,  9392,  9396,  9400,
    9407,  9408,  9411,  9412,  9416,  9417,  9423,  9429,  9435,  9445,
    9444,  9454,  9455,  9459,  9460,  9461,  9465,  9466,  9467,  9471,
    9472,  9476,  9486,  9493,  9503,  9512,  9526,  9527,  9532,  9531,
    9566,  9567,  9568,  9572,  9572,  9596,  9597,  9601,  9602,  9603,
    9607,  9612,  9611,  9631,  9637,  9658,  9680,  9682,  9687,  9689,
    9691,  9703,  9713,  9726,  9728,  9730,  9735,  9740,  9742,  9744,
    9750,  9751,  9757,  9758,  9760,  9766,  9765,  9780,  9781,  9785,
    9790,  9798,  9798,  9816,  9825,  9838,  9839,  9841,  9843,  9856,
    9854,  9931,  9930,  9940,  9969,  9978,  9987,  9939, 10011, 10015,
   10019, 10023, 10027, 10031, 10037, 10044, 10051, 10060, 10061, 10065,
   10066, 10067, 10071, 10072, 10076, 10077, 10077, 10082, 10083
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "END_OF_INPUT", "ABORT_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "ATAN",
  "AUTO_INC", "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM",
  "BEGIN_SYM", "BENCHMARK_SYM", "BERKELEY_DB_SYM", "BIGINT", "BINARY",
  "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR", "BIT_SYM", "BIT_XOR",
  "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM", "BOTH", "BTREE_SYM",
  "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM", "CASCADE", "CASCADED",
  "CAST_SYM", "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM",
  "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM", "CLIENT_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_SYM", "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM",
  "COMPACT_SYM", "COMPRESSED_SYM", "CONCAT", "CONCAT_WS", "CONCURRENT",
  "CONDITION_SYM", "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT",
  "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM", "CONVERT_SYM",
  "CONVERT_TZ_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_USER", "CURSOR_SYM", "CURTIME", "DATABASE",
  "DATABASES", "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL",
  "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM",
  "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM",
  "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DECODE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_DECRYPT_SYM", "DES_ENCRYPT_SYM", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSEIF_SYM",
  "ELT_FUNC", "ENABLE_SYM", "ENCLOSED", "ENCODE_SYM", "ENCRYPT", "END",
  "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM", "ERRORS",
  "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM", "EXECUTE_SYM", "EXISTS",
  "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SET", "EXTENDED_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FAST_SYM", "FAULTS_SYM", "FETCH_SYM", "FIELD_FUNC",
  "FILE_SYM", "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM",
  "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FORMAT_SYM", "FOR_SYM",
  "FOUND_SYM", "FRAC_SECOND_SYM", "FROM", "FROM_UNIXTIME", "FULL",
  "FULLTEXT_SYM", "FUNCTION_SYM", "FUNC_ARG0", "FUNC_ARG1", "FUNC_ARG2",
  "FUNC_ARG3", "GE", "GEOMCOLLFROMTEXT", "GEOMETRYCOLLECTION",
  "GEOMETRY_SYM", "GEOMFROMTEXT", "GEOMFROMWKB", "GET_FORMAT",
  "GLOBAL_SYM", "GRANT", "GRANTS", "GREATEST_SYM", "GROUP",
  "GROUP_CONCAT_SYM", "GROUP_UNIQUE_USERS", "GT_SYM", "HANDLER_SYM",
  "HASH_SYM", "HAVING", "HELP_SYM", "HEX_NUM", "HIGH_PRIORITY",
  "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED",
  "IF", "IGNORE_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE",
  "INNER_SYM", "INNOBASE_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT",
  "INSERT_METHOD", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IO_SYM", "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM",
  "ITERATE_SYM", "JOIN_SYM", "KEYS", "KEY_SYM", "KILL_SYM", "LABEL_SYM",
  "LANGUAGE_SYM", "LAST_INSERT_ID", "LAST_SYM", "LE", "LEADING",
  "LEAST_SYM", "LEAVES", "LEAVE_SYM", "LEFT", "LEVEL_SYM", "LEX_HOSTNAME",
  "LIKE", "LIMIT", "LINEFROMTEXT", "LINES", "LINESTRING", "LOAD",
  "LOCAL_SYM", "LOCATE", "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM",
  "LOGS_SYM", "LOG_SYM", "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM",
  "LOOP_SYM", "LOW_PRIORITY", "LT", "MAKE_SET_SYM",
  "MASTER_CONNECT_RETRY_SYM", "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM",
  "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM",
  "MASTER_POS_WAIT", "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM",
  "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MATCH", "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SYM", "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS_SYM",
  "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM",
  "MERGE_SYM", "MICROSECOND_SYM", "MIGRATE_SYM", "MINUTE_MICROSECOND_SYM",
  "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS", "MIN_SYM",
  "MLINEFROMTEXT", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MPOINTFROMTEXT", "MPOLYFROMTEXT", "MULTILINESTRING",
  "MULTIPOINT", "MULTIPOLYGON", "MUTEX_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEW_SYM", "NEXT_SYM", "NONE_SYM", "NOT2_SYM", "NOT_SYM",
  "NOW_SYM", "NO_SYM", "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM",
  "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM", "OJ_SYM", "OLD_PASSWORD",
  "ON", "ONE_SHOT_SYM", "ONE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTION",
  "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER",
  "OUTFILE", "OUT_SYM", "PACK_KEYS_SYM", "PAGE_SYM", "PARTIAL", "PASSWORD",
  "PARAM_MARKER", "PHASE_SYM", "POINTFROMTEXT", "POINT_SYM",
  "POLYFROMTEXT", "POLYGON", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE", "PROCESS",
  "PROCESSLIST_SYM", "PROFILE_SYM", "PROFILES_SYM", "PURGE", "QUARTER_SYM",
  "QUERY_SYM", "QUICK", "RAID_0_SYM", "RAID_CHUNKS", "RAID_CHUNKSIZE",
  "RAID_STRIPED_SYM", "RAID_TYPE", "RAND", "READS_SYM", "READ_SYM", "REAL",
  "RECOVER_SYM", "REDUNDANT_SYM", "REFERENCES", "REGEXP",
  "RELAY_LOG_FILE_SYM", "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM",
  "RELOAD", "RENAME", "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE",
  "REPLICATION", "REQUIRE_SYM", "RESET_SYM", "RESOURCES", "RESTORE_SYM",
  "RESTRICT", "RESUME_SYM", "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT",
  "ROLLBACK_SYM", "ROLLUP_SYM", "ROUND", "ROUTINE_SYM", "ROWS_SYM",
  "ROW_COUNT_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM",
  "SELECT_SYM", "SENNA_DELIMITED_SYM", "SENNA_KWIC_SYM", "SENNA_MECAB_SYM",
  "SENNA_NGRAM_SYM", "SENNA_NORMALIZE_SYM", "SENNA_SECTIONALIZE_SYM",
  "SENNA_SPLIT_ALPHA_SYM", "SENNA_SPLIT_DIGIT_SYM",
  "SENNA_SPLIT_SYMBOL_SYM", "SENNA_SYM", "SENSITIVE_SYM", "SEPARATOR_SYM",
  "SERIALIZABLE_SYM", "SERIAL_SYM", "SESSION_SYM", "SET", "SET_VAR",
  "SHARE_SYM", "SHIFT_LEFT", "SHIFT_RIGHT", "SHOW", "SHUTDOWN",
  "SIGNED_SYM", "SIMPLE_SYM", "SLAVE", "SMALLINT", "SNAPSHOT_SYM",
  "SOUNDS_SYM", "SOURCE_SYM", "SPATIAL_SYM", "SPECIFIC_SYM",
  "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM", "SQL_BIG_RESULT",
  "SQL_BUFFER_RESULT", "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS",
  "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD",
  "SSL_SYM", "STARTING", "START_SYM", "STATUS_SYM", "STD_SYM",
  "STDDEV_SAMP_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBSTRING",
  "SUBSTRING_INDEX", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM",
  "SWITCHES_SYM", "SYSDATE", "TABLES", "TABLESPACE", "TABLE_SYM",
  "TEMPORARY", "TEMPTABLE_SYM", "TERMINATED", "TEXT_STRING", "TEXT_SYM",
  "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB",
  "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING", "TRANSACTION_SYM",
  "TRIGGER_SYM", "TRIGGERS_SYM", "TRIM", "TRUE_SYM", "TRUNCATE_SYM",
  "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM", "UDF_SONAME_SYM",
  "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDO_SYM", "UNICODE_SYM", "UNION_SYM",
  "UNIQUE_SYM", "UNIQUE_USERS", "UNIX_TIMESTAMP", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USE_FRM", "USE_SYM", "USING", "UTC_DATE_SYM",
  "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VAR_SAMP_SYM", "VALUES",
  "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES", "VARIANCE_SYM",
  "VARYING", "VIEW_SYM", "WARNINGS", "WEEK_SYM", "WHEN_SYM", "WHERE",
  "WHILE_SYM", "WITH", "WORK_SYM", "WRITE_SYM", "X509_SYM", "XA_SYM",
  "XOR", "YEARWEEK", "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL",
  "TABLE_REF_PRIORITY", "ELSE", "THEN_SYM", "CASE_SYM", "BETWEEN_SYM",
  "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'", "'~'", "NEG",
  "'('", "')'", "','", "'!'", "'{'", "'}'", "'@'", "'.'", "';'", "':'",
  "$accept", "query", "verb_clause", "statement", "deallocate",
  "deallocate_or_drop", "prepare", "prepare_src", "execute", "@1",
  "execute_using", "execute_var_list", "execute_var_ident", "help", "@2",
  "change", "@3", "master_defs", "master_def", "master_file_def", "create",
  "@4", "@5", "@6", "@7", "clear_privileges", "sp_name",
  "create_function_tail", "@8", "@9", "@10", "@11", "@12", "sp_a_chistics",
  "sp_c_chistics", "sp_chistic", "sp_c_chistic", "sp_suid", "call", "@13",
  "opt_sp_cparam_list", "opt_sp_cparams", "sp_cparams", "sp_fdparam_list",
  "sp_fdparams", "sp_init_param", "sp_fdparam", "sp_pdparam_list",
  "sp_pdparams", "sp_pdparam", "sp_opt_inout", "sp_proc_stmts",
  "sp_proc_stmts1", "sp_decls", "sp_decl", "@14", "@15", "sp_cursor_stmt",
  "@16", "sp_handler_type", "sp_hcond_list", "sp_hcond_element", "sp_cond",
  "opt_value", "sp_hcond", "sp_decl_idents", "sp_opt_default",
  "sp_proc_stmt", "@17", "@18", "@19", "@20", "@21", "sp_opt_fetch_noise",
  "sp_fetch_list", "sp_if", "@22", "@23", "@24", "sp_elseifs",
  "case_stmt_specification", "simple_case_stmt", "@25", "@26",
  "searched_case_stmt", "@27", "simple_when_clause_list",
  "searched_when_clause_list", "simple_when_clause", "@28", "@29",
  "searched_when_clause", "@30", "@31", "else_clause_opt",
  "sp_labeled_control", "@32", "sp_opt_label", "sp_unlabeled_control",
  "@33", "@34", "@35", "@36", "trg_action_time", "trg_event", "create2",
  "create2a", "@37", "create3", "@38", "@39", "create_select", "@40",
  "@41", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "default_charset",
  "default_collation", "storage_engines", "row_types", "raid_types",
  "merge_insert_types", "opt_select_from", "udf_func_type", "udf_type",
  "field_list", "field_list_item", "column_def", "key_def",
  "opt_check_constraint", "check_constraint", "opt_constraint",
  "constraint", "field_spec", "@42", "type", "@43", "@44", "spatial_type",
  "char", "nchar", "varchar", "nvarchar", "int_type", "real_type",
  "float_options", "precision", "field_options", "field_opt_list",
  "field_option", "opt_len", "opt_precision", "opt_attribute",
  "opt_attribute_list", "attribute", "now_or_signed_literal", "charset",
  "charset_name", "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "opt_binary", "opt_bin_mod", "opt_bin_charset",
  "opt_primary", "references", "@45", "opt_ref_list", "ref_list",
  "opt_on_delete", "opt_on_delete_list", "opt_on_delete_item",
  "delete_option", "key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique_or_fulltext", "key_alg",
  "opt_btree_or_rtree", "opt_senna_list", "opt_senna_item", "key_list",
  "key_part", "opt_ident", "opt_component", "string_list", "alter", "@46",
  "@47", "@48", "@49", "@50", "ident_or_empty", "alter_list", "add_column",
  "alter_list_item", "@51", "@52", "@53", "opt_column", "opt_ignore",
  "opt_restrict", "opt_place", "opt_to", "slave", "@54", "@55", "start",
  "start_transaction_opts", "slave_thread_opts", "@56",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "restore", "@57", "backup", "@58", "checksum", "@59",
  "opt_checksum_type", "repair", "@60", "opt_mi_repair_type",
  "mi_repair_types", "mi_repair_type", "analyze", "@61", "check", "@62",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "@63", "opt_no_write_to_binlog", "rename", "@64", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "keycache_list",
  "assign_to_keycache", "key_cache_name", "preload", "@65", "preload_list",
  "preload_keys", "cache_keys_spec", "@66", "cache_key_list_or_empty",
  "opt_ignore_leaves", "select", "select_init", "select_paren",
  "select_init2", "@67", "select_part2", "@68", "@69", "select_into",
  "select_from", "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_item2", "select_alias", "optional_braces",
  "expr", "@70", "bool_or_expr", "bool_term", "@71", "bool_and_expr",
  "bool_factor", "bool_test", "bool_pri", "predicate", "bit_expr",
  "bit_term", "bit_factor", "value_expr", "term", "factor", "or", "and",
  "not", "not2", "comp_op", "all_or_any", "interval_expr", "simple_expr",
  "@72", "geometry_function", "fulltext_options", "udf_expr_list",
  "udf_expr_list2", "@73", "udf_expr_list3", "udf_expr", "sum_expr", "@74",
  "@75", "@76", "variable", "@77", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "in_sum_expr", "@78",
  "cast_type", "opt_expr_list", "expr_list", "@79", "expr_list2",
  "ident_list_arg", "ident_list", "@80", "ident_list2", "opt_expr",
  "opt_else", "when_list", "table_ref", "join_table_list",
  "derived_table_list", "join_table", "@81", "@82", "@83", "@84", "@85",
  "@86", "@87", "normal_join", "table_factor", "@88", "@89",
  "select_derived", "@90", "select_derived2", "@91", "@92",
  "get_select_lex", "select_derived_init", "opt_outer", "opt_for_join",
  "opt_key_definition", "key_usage_list", "@93", "key_list_or_empty",
  "key_usage_list2", "using_list", "interval", "interval_time_st",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "@94", "having_clause", "@95", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "@96", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "ulonglong_num", "procedure_clause", "@97", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "@98",
  "select_var_list", "select_var_ident", "into", "@99", "into_destination",
  "@100", "do", "@101", "drop", "@102", "table_list", "table_name",
  "if_exists", "opt_temporary", "insert", "@103", "@104", "replace",
  "@105", "@106", "insert_lock_option", "replace_lock_option", "insert2",
  "insert_table", "insert_field_spec", "@107", "fields", "insert_values",
  "@108", "@109", "values_list", "ident_eq_list", "ident_eq_value",
  "equal", "opt_equal", "no_braces", "@110", "opt_values", "values",
  "expr_or_default", "opt_insert_update", "@111", "update", "@112", "@113",
  "update_list", "update_elem", "insert_update_list", "insert_update_elem",
  "opt_low_priority", "delete", "@114", "single_multi", "@115", "@116",
  "@117", "table_wild_list", "table_wild_one", "opt_wild",
  "opt_delete_options", "opt_delete_option", "truncate", "opt_table_sym",
  "opt_profile_defs", "profile_defs", "profile_def", "opt_profile_args",
  "show", "@118", "show_param", "@119", "@120", "show_engine_param",
  "master_or_binary", "opt_storage", "opt_db", "opt_full", "from_or_in",
  "binlog_in", "binlog_from", "wild_and_where", "describe", "@121", "@122",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "@123", "flush_options", "flush_option", "@124",
  "opt_table_list", "reset", "@125", "reset_options", "reset_option",
  "purge", "@126", "purge_options", "purge_option", "kill", "@127",
  "kill_option", "use", "load", "@128", "load_data", "@129", "@130",
  "@131", "@132", "opt_local", "load_data_lock", "opt_duplicate",
  "opt_field_term", "field_term_list", "field_term", "opt_line_term",
  "line_term_list", "line_term", "opt_ignore_lines",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "text_literal", "text_string", "param_marker",
  "signed_literal", "literal", "NUM_literal", "insert_ident", "table_wild",
  "order_ident", "simple_ident", "simple_ident_nospvar", "simple_ident_q",
  "field_ident", "table_ident", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user", "keyword", "keyword_sp",
  "set", "@133", "opt_option", "option_value_list", "option_type_value",
  "@134", "option_type", "option_type2", "opt_var_type",
  "opt_var_ident_type", "ext_option_value", "sys_option_value",
  "option_value", "internal_variable_name", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "@135",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "@136", "handler", "@137", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "@138",
  "handler_rkey_mode", "revoke", "revoke_command", "grant",
  "grant_command", "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "object_privilege", "@139", "@140", "@141",
  "@142", "opt_and", "require_list", "require_list_element", "grant_ident",
  "user_list", "grant_list", "grant_user", "opt_column_list",
  "column_list", "column_list_id", "require_clause", "grant_options",
  "grant_option_list", "grant_option", "begin", "@143", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "@144",
  "union_opt", "union_order_or_limit", "@145", "order_or_limit",
  "union_option", "subselect", "@146", "subselect_init", "subselect_start",
  "subselect_end", "view_or_trigger_or_sp", "view_or_trigger_or_sp_tail",
  "definer", "view_replace_or_algorithm", "view_replace", "view_algorithm",
  "view_algorithm_opt", "view_suid", "view_tail", "@147", "view_list_opt",
  "view_list", "view_select", "@148", "view_select_aux",
  "view_check_option", "trigger_tail", "@149", "sp_tail", "@150", "@151",
  "@152", "@153", "@154", "xa", "xid", "begin_or_start",
  "opt_join_or_resume", "opt_one_phase", "opt_suspend", "@155",
  "opt_migrate", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   124,    38,    45,    43,    42,    47,    37,
      94,   126,   828,    40,    41,    44,    33,   123,   125,    64,
      46,    59,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   593,   594,   594,   595,   595,   596,   596,   596,   596,
     596,   596,   596,   596,   596,   596,   596,   596,   596,   596,
     596,   596,   596,   596,   596,   596,   596,   596,   596,   596,
     596,   596,   596,   596,   596,   596,   596,   596,   596,   596,
     596,   596,   596,   596,   596,   596,   596,   596,   596,   596,
     596,   596,   596,   597,   598,   598,   599,   600,   600,   602,
     601,   603,   603,   604,   604,   605,   607,   606,   609,   608,
     610,   610,   611,   611,   611,   611,   611,   611,   611,   611,
     611,   611,   611,   611,   612,   612,   612,   612,   614,   613,
     615,   613,   616,   613,   617,   613,   613,   618,   619,   619,
     620,   621,   622,   623,   624,   625,   620,   626,   626,   627,
     627,   628,   628,   628,   628,   628,   628,   628,   629,   629,
     629,   630,   630,   632,   631,   633,   633,   634,   634,   635,
     635,   636,   636,   637,   637,   638,   639,   640,   640,   641,
     641,   642,   643,   643,   643,   643,   644,   644,   645,   645,
     646,   646,   648,   647,   647,   649,   647,   647,   651,   650,
     652,   652,   653,   653,   654,   655,   655,   656,   656,   657,
     657,   657,   657,   657,   658,   658,   659,   659,   661,   660,
     662,   660,   663,   660,   660,   660,   664,   660,   660,   660,
     660,   665,   660,   660,   666,   666,   666,   667,   667,   669,
     670,   671,   668,   672,   672,   672,   673,   673,   675,   676,
     674,   678,   677,   679,   679,   680,   680,   682,   683,   681,
     685,   686,   684,   687,   687,   689,   688,   690,   690,   692,
     691,   691,   693,   694,   691,   695,   691,   696,   696,   697,
     697,   697,   698,   698,   698,   698,   699,   700,   699,   701,
     702,   701,   703,   701,   705,   706,   704,   707,   707,   708,
     708,   709,   709,   710,   710,   711,   711,   712,   712,   713,
     714,   714,   715,   715,   716,   716,   717,   717,   717,   718,
     718,   718,   718,   718,   718,   718,   718,   718,   718,   718,
     718,   718,   718,   718,   718,   718,   718,   718,   718,   718,
     718,   718,   719,   720,   721,   722,   722,   722,   722,   722,
     722,   723,   723,   723,   724,   724,   724,   725,   725,   726,
     726,   727,   727,   727,   727,   728,   728,   729,   729,   730,
     730,   731,   731,   731,   731,   731,   732,   732,   733,   734,
     734,   735,   737,   736,   738,   738,   738,   738,   738,   738,
     738,   738,   738,   738,   738,   738,   738,   738,   738,   738,
     738,   738,   738,   738,   738,   738,   738,   738,   738,   738,
     738,   738,   738,   738,   738,   738,   738,   738,   738,   739,
     738,   740,   738,   738,   738,   741,   741,   741,   741,   741,
     741,   741,   741,   742,   743,   743,   744,   744,   745,   745,
     745,   745,   745,   746,   746,   746,   746,   746,   747,   747,
     747,   748,   748,   748,   749,   750,   750,   751,   751,   752,
     752,   752,   753,   753,   754,   754,   755,   755,   756,   756,
     757,   757,   757,   757,   757,   757,   757,   757,   757,   757,
     757,   758,   758,   759,   759,   760,   760,   761,   761,   762,
     762,   763,   763,   764,   764,   765,   766,   766,   767,   767,
     768,   768,   769,   769,   769,   769,   769,   769,   770,   770,
     771,   771,   771,   771,   772,   772,   774,   773,   775,   775,
     776,   776,   777,   777,   778,   778,   779,   779,   779,   779,
     779,   780,   780,   780,   780,   780,   781,   781,   781,   782,
     782,   783,   783,   784,   784,   785,   785,   785,   786,   786,
     786,   786,   787,   787,   787,   788,   788,   788,   788,   789,
     789,   790,   790,   790,   790,   790,   790,   790,   790,   790,
     790,   790,   790,   791,   791,   792,   792,   793,   793,   794,
     794,   795,   795,   797,   796,   798,   796,   799,   796,   800,
     796,   801,   796,   802,   802,   803,   803,   803,   803,   803,
     804,   805,   805,   805,   806,   805,   807,   808,   805,   805,
     805,   805,   805,   805,   805,   805,   805,   805,   805,   805,
     805,   805,   809,   809,   810,   810,   811,   811,   811,   812,
     812,   812,   813,   813,   813,   813,   815,   814,   814,   816,
     814,   814,   817,   818,   818,   820,   819,   821,   821,   822,
     822,   822,   823,   823,   824,   824,   826,   825,   828,   827,
     830,   829,   831,   831,   831,   833,   832,   834,   834,   835,
     835,   836,   836,   836,   838,   837,   840,   839,   841,   841,
     842,   842,   843,   843,   843,   843,   843,   843,   845,   844,
     846,   846,   846,   848,   847,   847,   849,   849,   850,   850,
     851,   852,   853,   853,   854,   855,   855,   857,   856,   858,
     858,   859,   861,   860,   862,   862,   863,   863,   864,   865,
     865,   866,   866,   868,   867,   870,   871,   869,   872,   872,
     872,   872,   872,   873,   873,   874,   874,   875,   875,   876,
     876,   876,   876,   876,   876,   876,   876,   876,   876,   877,
     877,   877,   878,   878,   878,   879,   880,   881,   882,   882,
     883,   883,   883,   883,   883,   884,   884,   886,   885,   887,
     887,   888,   889,   888,   890,   890,   891,   891,   892,   892,
     892,   892,   892,   892,   892,   893,   893,   893,   893,   893,
     893,   894,   894,   894,   894,   894,   894,   894,   894,   894,
     894,   894,   894,   894,   894,   895,   895,   896,   896,   897,
     897,   897,   898,   898,   898,   898,   898,   899,   899,   899,
     899,   899,   899,   900,   900,   901,   901,   902,   902,   903,
     903,   904,   904,   905,   905,   905,   905,   905,   905,   906,
     906,   907,   908,   908,   908,   908,   908,   908,   908,   908,
     908,   908,   908,   908,   908,   908,   908,   908,   908,   908,
     908,   908,   908,   908,   908,   908,   908,   908,   908,   908,
     908,   908,   908,   908,   908,   908,   908,   908,   908,   908,
     908,   908,   908,   908,   908,   908,   908,   908,   908,   908,
     908,   908,   908,   908,   908,   908,   908,   908,   908,   908,
     908,   908,   908,   908,   908,   908,   908,   908,   908,   908,
     908,   908,   908,   908,   908,   908,   908,   908,   908,   908,
     908,   908,   908,   908,   908,   908,   908,   908,   908,   908,
     908,   908,   908,   908,   908,   908,   908,   908,   908,   908,
     908,   908,   908,   908,   908,   908,   908,   908,   908,   908,
     908,   908,   908,   908,   908,   908,   908,   908,   908,   908,
     908,   908,   908,   908,   908,   908,   908,   908,   908,   908,
     908,   908,   909,   908,   908,   908,   908,   908,   908,   908,
     908,   908,   908,   908,   908,   908,   908,   908,   910,   910,
     910,   910,   910,   910,   910,   910,   910,   910,   910,   910,
     910,   910,   910,   910,   910,   910,   910,   910,   910,   910,
     910,   910,   910,   910,   911,   911,   911,   912,   912,   914,
     913,   915,   915,   916,   917,   917,   917,   917,   917,   917,
     917,   918,   919,   917,   917,   917,   917,   917,   917,   917,
     917,   917,   917,   917,   917,   920,   917,   922,   921,   923,
     923,   923,   924,   924,   925,   925,   926,   926,   928,   927,
     929,   929,   929,   929,   929,   929,   929,   929,   929,   929,
     929,   930,   930,   932,   931,   933,   933,   934,   934,   936,
     935,   937,   937,   938,   938,   939,   939,   940,   940,   941,
     941,   942,   943,   943,   944,   944,   945,   944,   946,   944,
     947,   944,   944,   948,   944,   949,   944,   944,   950,   944,
     951,   944,   944,   952,   952,   952,   954,   953,   955,   953,
     953,   953,   957,   956,   959,   960,   958,   961,   962,   963,
     963,   964,   964,   965,   965,   965,   965,   967,   966,   968,
     968,   969,   969,   969,   970,   970,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   973,   973,
     973,   973,   974,   974,   974,   975,   975,   976,   976,   977,
     978,   977,   979,   980,   979,   981,   981,   982,   982,   983,
     983,   984,   984,   984,   985,   986,   986,   987,   988,   988,
     990,   989,   991,   991,   992,   992,   992,   993,   993,   994,
     994,   995,   996,   996,   996,   997,   997,   997,   997,   998,
     998,   999,   999,   999,   999,   999,   999,  1000,  1000,  1000,
    1000,  1000,  1001,  1002,  1001,  1003,  1003,  1004,  1004,  1005,
    1007,  1006,  1008,  1008,  1009,  1009,  1011,  1010,  1013,  1012,
    1012,  1012,  1015,  1014,  1016,  1017,  1016,  1016,  1016,  1016,
    1016,  1016,  1016,  1018,  1018,  1019,  1020,  1020,  1021,  1021,
    1023,  1024,  1022,  1026,  1027,  1025,  1028,  1028,  1028,  1028,
    1029,  1029,  1030,  1030,  1031,  1032,  1032,  1032,  1033,  1032,
    1034,  1034,  1035,  1035,  1036,  1035,  1037,  1035,  1038,  1038,
    1039,  1039,  1040,  1041,  1041,  1042,  1042,  1044,  1043,  1045,
    1045,  1046,  1046,  1047,  1047,  1048,  1049,  1048,  1051,  1052,
    1050,  1053,  1053,  1054,  1055,  1055,  1056,  1057,  1057,  1059,
    1058,  1061,  1060,  1062,  1060,  1063,  1060,  1064,  1064,  1065,
    1065,  1066,  1066,  1067,  1067,  1068,  1068,  1068,  1069,  1070,
    1070,  1071,  1071,  1072,  1072,  1073,  1073,  1073,  1073,  1073,
    1073,  1073,  1073,  1073,  1074,  1074,  1076,  1075,  1077,  1077,
    1077,  1077,  1077,  1078,  1077,  1077,  1077,  1077,  1077,  1079,
    1077,  1077,  1077,  1077,  1077,  1077,  1077,  1077,  1077,  1077,
    1077,  1077,  1077,  1077,  1077,  1077,  1077,  1077,  1077,  1077,
    1077,  1077,  1077,  1077,  1077,  1077,  1077,  1077,  1077,  1077,
    1077,  1077,  1077,  1077,  1077,  1080,  1080,  1081,  1081,  1082,
    1082,  1083,  1083,  1084,  1084,  1085,  1085,  1086,  1086,  1087,
    1087,  1088,  1088,  1088,  1090,  1089,  1091,  1089,  1092,  1092,
    1093,  1093,  1094,  1094,  1094,  1096,  1095,  1097,  1097,  1099,
    1098,  1098,  1098,  1098,  1098,  1098,  1098,  1098,  1098,  1098,
    1098,  1100,  1100,  1102,  1101,  1103,  1103,  1104,  1104,  1104,
    1106,  1105,  1107,  1108,  1108,  1110,  1109,  1111,  1111,  1111,
    1112,  1114,  1113,  1113,  1116,  1117,  1118,  1119,  1115,  1115,
    1120,  1120,  1121,  1121,  1121,  1122,  1122,  1122,  1123,  1123,
    1124,  1124,  1125,  1125,  1125,  1125,  1126,  1126,  1127,  1127,
    1128,  1128,  1129,  1129,  1130,  1130,  1130,  1131,  1131,  1132,
    1132,  1133,  1133,  1134,  1134,  1134,  1134,  1135,  1135,  1135,
    1136,  1137,  1137,  1137,  1138,  1138,  1138,  1138,  1138,  1138,
    1138,  1138,  1138,  1138,  1138,  1138,  1139,  1139,  1139,  1139,
    1139,  1140,  1140,  1141,  1141,  1142,  1143,  1143,  1144,  1144,
    1145,  1145,  1145,  1146,  1146,  1146,  1146,  1147,  1147,  1147,
    1148,  1149,  1149,  1150,  1151,  1152,  1153,  1153,  1154,  1154,
    1155,  1155,  1155,  1156,  1156,  1156,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,
    1157,  1157,  1157,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1160,  1159,  1161,  1161,  1162,  1162,
    1164,  1163,  1165,  1165,  1165,  1165,  1166,  1166,  1167,  1167,
    1167,  1167,  1168,  1168,  1168,  1168,  1169,  1169,  1170,  1170,
    1171,  1171,  1171,  1171,  1171,  1171,  1171,  1172,  1172,  1172,
    1173,  1173,  1173,  1173,  1174,  1174,  1174,  1175,  1175,  1175,
    1175,  1175,  1177,  1176,  1178,  1178,  1179,  1179,  1180,  1181,
    1181,  1181,  1181,  1183,  1182,  1184,  1184,  1185,  1184,  1186,
    1186,  1187,  1187,  1188,  1188,  1188,  1188,  1189,  1188,  1190,
    1190,  1190,  1190,  1190,  1191,  1192,  1192,  1192,  1192,  1193,
    1194,  1194,  1194,  1195,  1195,  1196,  1196,  1197,  1197,  1198,
    1198,  1200,  1199,  1201,  1199,  1202,  1199,  1203,  1199,  1199,
    1199,  1199,  1199,  1199,  1199,  1199,  1199,  1199,  1199,  1199,
    1199,  1199,  1199,  1199,  1199,  1199,  1199,  1199,  1199,  1199,
    1199,  1199,  1204,  1204,  1205,  1205,  1206,  1206,  1206,  1207,
    1207,  1207,  1207,  1208,  1208,  1209,  1209,  1210,  1210,  1210,
    1211,  1211,  1212,  1212,  1213,  1214,  1214,  1214,  1214,  1214,
    1215,  1215,  1216,  1216,  1217,  1217,  1217,  1217,  1217,  1219,
    1218,  1220,  1220,  1221,  1221,  1221,  1222,  1222,  1222,  1223,
    1223,  1224,  1225,  1225,  1226,  1227,  1228,  1228,  1230,  1229,
    1231,  1231,  1231,  1233,  1232,  1234,  1234,  1235,  1235,  1235,
    1236,  1237,  1236,  1238,  1239,  1240,  1241,  1241,  1242,  1242,
    1242,  1243,  1243,  1244,  1244,  1244,  1245,  1246,  1246,  1246,
    1247,  1247,  1248,  1248,  1248,  1250,  1249,  1251,  1251,  1252,
    1252,  1254,  1253,  1255,  1255,  1256,  1256,  1256,  1256,  1258,
    1257,  1260,  1259,  1261,  1262,  1263,  1264,  1259,  1265,  1265,
    1265,  1265,  1265,  1265,  1266,  1266,  1266,  1267,  1267,  1268,
    1268,  1268,  1269,  1269,  1270,  1271,  1270,  1272,  1272
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     4,     1,     2,     0,
       4,     0,     2,     3,     1,     2,     0,     3,     0,     5,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     1,     3,     3,     3,     3,     0,     7,
       0,    11,     0,     6,     0,     3,     4,     0,     3,     1,
       4,     0,     0,     0,     0,     0,    12,     0,     2,     0,
       2,     2,     2,     2,     2,     3,     3,     1,     1,     1,
       2,     3,     3,     0,     4,     0,     3,     0,     1,     3,
       1,     0,     1,     3,     1,     0,     3,     0,     1,     3,
       1,     4,     0,     1,     1,     1,     0,     3,     2,     3,
       0,     3,     0,     5,     5,     0,     7,     5,     0,     2,
       1,     1,     1,     3,     1,     1,     3,     0,     1,     1,
       1,     1,     2,     1,     1,     3,     0,     2,     0,     2,
       0,     3,     0,     5,     1,     1,     0,     2,     2,     2,
       2,     0,     6,     2,     0,     2,     1,     1,     3,     0,
       0,     0,     7,     0,     2,     2,     1,     1,     0,     0,
       8,     0,     6,     1,     2,     1,     2,     0,     0,     6,
       0,     0,     6,     0,     2,     0,     5,     0,     1,     0,
       5,     4,     0,     0,     8,     0,     7,     1,     1,     1,
       1,     1,     2,     2,     2,     4,     4,     0,     4,     0,
       0,     5,     0,     7,     0,     0,     6,     0,     1,     0,
       1,     1,     2,     1,     1,     0,     1,     1,     2,     1,
       0,     3,     0,     1,     1,     2,     1,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     5,     1,     1,     3,     4,
       4,     3,     4,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     0,
       1,     1,     1,     1,     1,     1,     3,     1,     1,     2,
       2,     6,     7,     8,     2,     2,     0,     1,     2,     0,
       1,     2,     0,     4,     3,     3,     3,     1,     4,     1,
       1,     5,     2,     5,     2,     4,     1,     5,     5,     4,
       3,     1,     1,     2,     1,     1,     2,     1,     1,     1,
       2,     3,     2,     3,     2,     2,     3,     3,     3,     0,
       6,     0,     6,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     2,     1,
       2,     3,     2,     1,     1,     1,     1,     1,     1,     1,
       2,     0,     3,     1,     5,     0,     1,     2,     1,     1,
       1,     1,     0,     3,     0,     1,     0,     1,     2,     1,
       1,     2,     2,     4,     1,     3,     2,     1,     2,     2,
       2,     2,     1,     2,     1,     1,     1,     1,     1,     0,
       2,     1,     1,     1,     1,     1,     0,     2,     1,     1,
       0,     1,     0,     2,     1,     2,     3,     2,     0,     1,
       0,     1,     1,     2,     0,     1,     0,     4,     1,     4,
       3,     1,     0,     1,     2,     1,     3,     3,     2,     2,
       2,     1,     1,     2,     2,     2,     1,     2,     2,     2,
       2,     1,     1,     0,     1,     1,     1,     1,     0,     1,
       1,     1,     0,     2,     2,     1,     1,     1,     1,     1,
       3,     1,     2,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     2,     1,     4,     0,     1,     0,
       2,     1,     3,     0,     6,     0,     5,     0,     5,     0,
       5,     0,    11,     0,     1,     0,     2,     2,     1,     3,
       2,     3,     2,     4,     0,     6,     0,     0,     8,     4,
       4,     3,     3,     2,     2,     6,     5,     3,     5,     1,
       1,     1,     0,     1,     0,     1,     0,     1,     1,     0,
       2,     1,     0,     1,     1,     1,     0,     5,     3,     0,
       5,     3,     3,     0,     3,     0,     2,     1,     3,     0,
       1,     1,     0,     2,     1,     3,     0,     6,     0,     6,
       0,     5,     0,     1,     1,     0,     6,     0,     1,     1,
       2,     1,     1,     1,     0,     6,     0,     5,     0,     1,
       1,     2,     1,     1,     1,     1,     1,     2,     0,     6,
       0,     1,     1,     0,     4,     4,     3,     5,     1,     3,
       3,     5,     1,     3,     2,     1,     1,     0,     6,     1,
       3,     3,     0,     2,     0,     4,     0,     2,     1,     2,
       4,     2,     3,     0,     3,     0,     0,     6,     2,     1,
       1,     2,     2,     8,     4,     0,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       2,     4,     3,     1,     1,     4,     0,     0,     1,     1,
       0,     2,     2,     1,     1,     0,     2,     0,     3,     0,
       3,     3,     0,     3,     0,     3,     2,     1,     3,     4,
       3,     4,     3,     4,     1,     3,     4,     3,     3,     6,
       1,     5,     6,     5,     7,     6,     8,     5,     6,     4,
       4,     5,     3,     4,     1,     3,     1,     3,     1,     3,
       3,     1,     3,     3,     4,     4,     1,     3,     3,     3,
       3,     3,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     3,     1,     1,     1,     1,     3,     2,
       2,     2,     2,     3,     3,     5,     6,     4,     4,     7,
       4,     2,     6,     5,     6,     6,     4,     4,     3,     4,
       6,     8,     6,     8,     6,     4,     6,     4,     6,     4,
       4,     4,     4,     6,     8,     2,     2,     4,     2,     7,
       7,     3,     4,     4,     6,     6,     4,     6,     6,     6,
       4,     6,     4,     6,     8,    10,    12,     6,     4,     6,
       6,     1,     6,     4,     8,    10,     4,     1,     3,     4,
       6,     6,     8,     6,     6,     4,     6,     6,     8,     4,
       4,     6,     4,     2,     4,     4,     4,     6,     4,     4,
       3,     8,     6,     4,     6,     3,     4,     6,     8,     4,
       8,     6,     8,     6,     8,     2,     4,     4,     4,     6,
       8,     8,     4,     7,     7,     7,     6,     6,     6,     6,
       6,     6,     0,     5,    10,     3,     4,     3,     2,     2,
       2,     4,     6,     4,     4,     6,     6,     6,     6,     4,
       6,     4,     6,     4,     4,     4,     4,     6,     4,     6,
       4,     6,     4,     4,     6,     4,     6,     4,     6,     4,
       4,     6,     4,     6,     0,     3,     3,     0,     1,     0,
       2,     1,     3,     4,     4,     5,     4,     4,     4,     5,
       4,     0,     0,     7,    10,     4,     5,     4,     5,     4,
       4,     4,     4,     4,     5,     0,     8,     0,     3,     3,
       1,     4,     0,     1,     0,     2,     0,     1,     0,     3,
       2,     3,     2,     1,     2,     1,     2,     1,     1,     1,
       2,     0,     1,     0,     2,     1,     3,     1,     3,     0,
       2,     1,     3,     0,     1,     0,     2,     4,     5,     1,
       1,     1,     1,     3,     3,     3,     0,     6,     0,     6,
       0,     8,     4,     0,     8,     0,    10,     6,     0,     8,
       0,    10,     6,     1,     2,     2,     0,     4,     0,    11,
       3,     6,     0,     3,     0,     0,     5,     0,     1,     0,
       1,     0,     2,     0,     2,     2,     2,     0,     6,     0,
       1,     3,     1,     1,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     1,     0,     2,     0,     1,     0,
       0,     3,     0,     0,     3,     2,     0,     0,     4,     4,
       2,     0,     2,     2,     3,     3,     1,     2,     0,     1,
       0,     4,     4,     2,     0,     1,     1,     0,     1,     0,
       1,     2,     1,     3,     3,     1,     1,     1,     1,     0,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     0,     6,     0,     1,     3,     1,     2,
       0,     2,     3,     1,     2,     1,     0,     3,     0,     5,
       2,     1,     0,     3,     6,     0,     6,     4,     4,     4,
       4,     5,     4,     1,     3,     1,     0,     2,     0,     1,
       0,     0,     8,     0,     0,     6,     0,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     3,     4,     0,     3,
       3,     1,     2,     2,     0,     3,     0,     5,     3,     1,
       3,     1,     3,     1,     1,     0,     1,     0,     4,     0,
       1,     3,     1,     1,     1,     0,     0,     6,     0,     0,
      11,     3,     1,     3,     3,     1,     3,     0,     1,     0,
       4,     0,     6,     0,     5,     0,     6,     1,     3,     3,
       5,     0,     2,     0,     2,     1,     1,     1,     3,     0,
       1,     0,     1,     1,     3,     1,     1,     2,     2,     2,
       1,     1,     1,     1,     0,     3,     0,     3,     2,     4,
       4,     4,     4,     0,     4,     6,    16,     2,     2,     0,
       6,     5,     2,     2,     2,     1,     5,     5,     2,     2,
       1,     4,     3,     2,     2,     2,     3,     2,     2,     2,
       1,     1,     3,     4,     3,     3,     2,     2,     3,     3,
       3,     3,     3,     3,     4,     1,     1,     1,     1,     0,
       1,     0,     2,     0,     1,     1,     1,     0,     2,     0,
       2,     0,     2,     2,     0,     4,     0,     4,     1,     1,
       0,     1,     0,     1,     1,     0,     4,     3,     1,     0,
       3,     4,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     0,     3,     3,     1,     1,     1,     2,
       0,     3,     3,     2,     2,     0,     4,     0,     1,     1,
       2,     0,     4,     5,     0,     0,     0,     0,    18,     2,
       0,     1,     0,     1,     1,     0,     1,     1,     0,     2,
       2,     1,     3,     4,     3,     3,     0,     2,     2,     1,
       3,     3,     0,     3,     0,     3,     2,     3,     1,     1,
       2,     0,     2,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     2,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     3,     5,     1,     1,     1,     1,     1,
       3,     4,     5,     1,     5,     3,     2,     1,     3,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     4,     0,     1,     1,     3,
       0,     2,     1,     1,     1,     1,     0,     1,     0,     1,
       1,     1,     0,     2,     2,     2,     1,     2,     4,     5,
       4,     6,     2,     3,     3,     3,     5,     1,     3,     3,
       2,     2,     2,     1,     1,     4,     4,     1,     1,     1,
       1,     1,     0,     4,     1,     1,     1,     3,     3,     1,
       1,     2,     2,     0,     3,     4,     3,     0,     7,     1,
       2,     1,     1,     1,     1,     1,     1,     0,     5,     1,
       1,     1,     1,     1,     3,     6,     6,     6,     7,     3,
       8,     8,     8,     0,     1,     1,     2,     0,     1,     1,
       3,     0,     3,     0,     3,     0,     3,     0,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     2,     1,     3,     2,     2,     2,     2,     2,     2,
       2,     2,     0,     1,     3,     1,     2,     2,     2,     1,
       3,     3,     1,     1,     3,     1,     3,     4,     5,     1,
       0,     3,     3,     1,     1,     0,     2,     2,     2,     2,
       0,     2,     2,     1,     2,     2,     2,     2,     2,     0,
       3,     0,     1,     0,     3,     2,     0,     1,     2,     0,
       1,     4,     4,     5,     2,     3,     0,     1,     0,     4,
       0,     1,     1,     0,     2,     2,     1,     0,     1,     1,
       4,     0,     7,     1,     0,     0,     2,     3,     1,     1,
       1,     0,     3,     1,     2,     1,     2,     3,     3,     3,
       0,     1,     0,     3,     3,     0,     8,     0,     3,     1,
       3,     0,     2,     3,     5,     0,     3,     4,     4,     0,
      14,     0,     6,     0,     0,     0,     0,    12,     4,     4,
       3,     4,     3,     2,     1,     3,     5,     1,     1,     0,
       1,     1,     0,     2,     0,     0,     3,     0,     2
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       0,     2,  2030,   650,     0,  1979,     0,     0,     0,     0,
       0,  1981,    94,    54,  1289,  1398,  1399,  1212,  1228,     0,
     650,    97,     0,    66,  1230,  1435,     0,     0,   650,     0,
    1430,     0,     0,   650,  1233,  1423,     0,    97,  1981,     0,
     685,  1816,  1326,     0,     0,     0,  1309,  1873,  1278,     0,
       0,     0,     0,     0,     4,    15,     0,    32,    20,    24,
      10,    14,     9,     6,    46,    47,    39,     8,    12,    36,
       7,    11,    29,    35,    30,    31,    43,   678,    18,    19,
      25,    37,    50,    16,    48,    45,    17,  1400,    21,    38,
      33,    26,    51,    27,    44,    28,    49,    23,    40,    22,
       5,    13,    41,    42,    34,    52,     0,   553,     0,   585,
       0,     0,  2031,  2021,   652,   651,     0,  1865,  1864,   618,
    1981,     0,  1583,  1584,  1585,  1586,  1587,  1588,  1589,  1547,
    1590,  1591,  1592,  1548,  1549,  1593,  1594,  1595,  1596,  1598,
    1597,  1599,  1550,  1551,  1600,  1601,  1602,  1552,  1553,  1603,
    1604,  1554,  1605,  1606,  1607,  1555,  1608,  1556,  1609,  1610,
    1611,  1612,  1613,  1557,  1614,  1615,  1616,  1617,  1618,  1619,
    1620,  1558,  1621,  1622,  1623,  1624,  1640,  1625,  1559,  1626,
    1627,  1628,  1641,  1560,  1631,  1630,  1629,  1632,  1633,  1634,
    1561,  1635,  1636,  1637,  1638,  1643,  1644,  1645,  1562,  1639,
    1646,  1642,  1799,  1648,  1647,  1649,  1651,  1650,  1563,  1652,
    1564,  1653,  1654,  1531,  1655,  1532,  1657,  1658,  1661,  1662,
    1656,  1663,  1664,  1659,  1660,  1565,  1666,  1667,  1668,  1669,
    1670,  1671,  1672,  1682,  1675,  1677,  1678,  1680,  1676,  1681,
    1685,  1684,  1686,  1687,  1688,  1683,  1674,  1679,  1689,  1690,
    1673,  1691,  1692,  1693,  1694,  1695,  1696,  1697,  1698,  1699,
    1701,  1700,  1702,  1703,  1704,  1705,  1706,  1708,  1707,  1709,
    1710,  1711,  1713,  1712,  1714,  1566,  1715,  1716,  1717,  1718,
    1719,  1567,  1720,  1721,  1722,  1723,  1724,  1725,  1726,  1568,
    1727,  1728,  1729,  1730,  1731,  1732,  1733,  1734,  1735,  1736,
    1737,  1738,  1739,  1740,  1741,  1742,  1743,  1744,  1665,  1745,
    1569,  1746,  1747,  1570,  1748,  1571,  1749,  1750,  1572,  1751,
    1752,  1753,  1754,  1755,  1756,  1573,  1757,  1574,  1758,  1759,
    1760,  1761,  1762,  1764,  1763,  1765,  1767,  1768,  1575,  1766,
    1576,  1769,  1770,  1771,  1773,  1772,  1774,  1775,  1577,  1776,
    1578,  1777,  1778,  1779,  1780,  1781,  1782,  1783,  1784,  1785,
    1786,  1787,  1788,  1789,  1792,  1793,  1794,  1795,  1790,  1791,
    1579,  1796,  1797,  1798,  1800,  1801,  1580,  1802,  1803,  1582,
    1804,  1805,  1808,  1806,  1807,  1809,  1810,  1811,  1812,  1581,
    1813,   123,  1536,    99,  1537,  1546,     0,   620,   636,  1982,
    1983,   270,   510,   511,   269,   509,    97,  2021,     0,   266,
     267,     0,  1303,  1033,  1226,  1226,     0,  1226,  1229,  1226,
      97,  1226,     0,    59,  1405,     0,     0,     0,     0,  1530,
       0,  1236,  1437,  1441,     0,     0,  1862,     0,     0,     0,
       0,    97,   653,     0,  1287,     0,   616,     0,  1983,  1994,
     679,   683,   695,  1817,  1814,  1383,   605,   605,   605,   603,
     605,  1310,     0,     0,  1287,  1440,  2067,     0,     0,     0,
    2063,     0,  2068,     0,   685,     0,     0,     1,     3,     0,
    1636,  1396,  1394,  1527,     0,   545,   554,   549,   547,     0,
       0,  2032,   634,     0,  1980,     0,   662,   672,   125,     0,
      68,     0,     0,     0,  1986,     0,     0,     0,     0,    95,
     319,  2021,  2023,  2025,   270,   268,     0,  1307,  1306,  1305,
       0,  1303,  1213,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1226,    61,     0,  1907,  1922,  1923,  1919,  1924,
    1925,  1929,     0,  1921,  1913,     0,  1928,  1917,  1926,     0,
    1911,     0,  1927,  1932,  1915,  1920,  1899,     0,  1905,  1909,
    1529,  1132,  1876,  1877,     0,  1542,  1533,  1541,  1540,    67,
    1238,  1239,  1237,   584,  1438,  1439,     0,  1452,     0,     0,
       0,   648,     0,  1378,  1377,     0,  1431,  1995,     0,     0,
     625,  1241,  1288,     0,  1240,  1428,     0,  1427,  1424,  1426,
       0,  1907,  1894,     0,  1989,  1986,  1996,   708,   701,   700,
     703,   704,   707,   705,   706,   702,   699,   716,   696,   698,
    1820,     0,     0,   444,     0,  1391,     0,     0,     0,  1391,
       0,  1167,  1384,     0,  1829,  1361,   507,   506,     0,   505,
    1830,  1360,  1377,     0,     0,     0,  1345,     0,  1311,  1350,
       0,  1831,     0,  1380,     0,  1167,  1391,     0,  1327,     0,
       0,     0,     0,   599,   609,   601,   596,     0,   602,   598,
    1308,  1225,  1874,   584,  1489,  1488,  1534,  2064,  1487,  2072,
    2074,  2060,  2062,  2069,   681,     0,  2000,    53,     0,  1402,
    2028,  2029,  2027,   460,   107,   107,   543,     0,     0,     0,
       0,     0,  1223,     0,     0,   664,   674,   127,   124,    98,
       0,   622,   638,  1985,     0,     0,  1987,  1991,   790,   789,
       0,    92,   725,  1543,  1959,    96,  1955,  2026,   320,   716,
     716,   716,  2016,     0,  2018,  2019,  2020,  2032,  2024,     0,
     512,     0,  1290,  1293,  1297,  1301,  1304,  1584,  1547,     0,
    1592,     0,     0,  1500,     0,     0,     0,     0,  1552,     0,
       0,  1606,     0,     0,  1557,     0,     0,     0,   725,   725,
     725,     0,     0,     0,  1619,  1620,  1509,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1497,     0,  1510,
       0,     0,     0,     0,     0,     0,     0,  1648,     0,     0,
    1649,     0,     0,     0,  1499,  1654,     0,     0,     0,     0,
       0,     0,     0,  1669,     0,     0,  1507,     0,     0,  1039,
       0,  1696,  1698,     0,     0,     0,  1702,     0,     0,  1703,
    1704,  1705,  1484,   792,     0,   725,  1496,  1506,  1717,  1723,
    1490,     0,  1725,     0,  1726,     0,  1733,     0,     0,     0,
       0,     0,     0,  1755,  1757,     0,     0,     0,  1779,     0,
       0,     0,   725,  1792,  1793,  1794,  1795,     0,  1498,  1579,
    1508,     0,     0,     0,  1804,   725,   725,   725,     0,     0,
       0,  1810,     0,  1813,  1043,     0,     0,     0,     0,   791,
       0,  1007,     0,  1035,   727,   732,   737,   744,   750,   764,
     766,   768,   771,   776,   782,     0,   877,   784,   871,   807,
     806,  1034,  1494,   805,   804,  1495,   802,  1517,  1536,  1483,
    1516,  1227,  1217,  1218,     0,  1219,  1222,  1953,  1220,   586,
       0,     0,    60,  1419,  1413,  1415,  1418,  1414,     0,  1420,
    1417,  1416,  1865,  1406,  1408,  1409,  1908,  1906,  1940,  1939,
       0,  1941,  1937,  1930,  1960,  1934,  1960,  1936,  1935,  1960,
    1931,  1938,  1960,  1903,     0,  1133,  1134,     0,  1875,     0,
    1528,     0,  1436,  1453,     0,  1454,  1442,  1450,   667,     0,
    1132,  1863,  1866,     0,     0,    56,    57,     0,   655,     0,
     654,   658,     0,     0,     0,  1244,  1234,  1243,  1429,     0,
       0,  1906,  1903,  1990,     0,  1992,  2007,   684,  1997,   714,
     686,   713,     0,   697,  1815,  1818,  1826,  1359,  1387,   443,
       0,     0,  1358,  1342,     0,   270,     0,     0,     0,     0,
    1328,  1333,   304,     0,  1349,  1168,     0,  1391,     0,  1353,
    1366,  1354,     0,  1381,     0,  1391,  1323,     0,     0,  1315,
    1320,  1316,     0,  1322,  1321,  1324,  1312,  1313,  1381,  1338,
    1367,  1381,  1343,  1348,  1357,  1385,  1386,     0,  1337,  1344,
       0,  1355,  1381,  1381,  1391,  1391,   612,   611,   610,   606,
     607,   612,     0,  1076,     0,     0,  2061,  2075,  2059,  2070,
    2071,  2058,   682,  2001,   680,  2002,     0,  1397,  1395,  1403,
    1404,   461,   546,   460,   261,   264,   263,     0,   550,   548,
     460,  2022,     0,     0,   638,     0,     0,   666,   661,   665,
     663,   502,   501,   504,     0,   673,     0,   128,   130,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    69,    70,    83,   624,   623,   621,
     646,   645,   643,     0,   644,   642,   637,   639,   640,  1984,
    1988,   271,   460,     0,  1545,     0,     0,     0,     0,     0,
       0,     0,  2017,    88,     0,     0,     0,  1295,  1291,  1301,
       0,     0,     0,  1132,     0,     0,     0,  1137,     0,   821,
    1137,  1137,  1137,     0,     0,  1033,  1033,     0,  1033,     0,
       0,     0,     0,  1137,   845,   848,     0,   846,     0,     0,
       0,     0,     0,  1503,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1033,     0,     0,     0,     0,  1012,     0,
       0,     0,     0,   801,     0,     0,     0,     0,  1033,     0,
       0,     0,     0,  1039,     0,  1037,     0,  1137,     0,     0,
    1137,     0,     0,     0,     0,     0,  1033,  1033,  1033,   736,
       0,   893,     0,     0,     0,     0,     0,  1033,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1033,  1137,
    1137,     0,     0,     0,  1137,     0,   915,     0,  1505,     0,
       0,     0,  1504,     0,     0,  1502,  1501,  1485,     0,     0,
       0,   938,   940,   939,  1137,     0,  1137,     0,     0,     0,
    1044,     0,   810,   809,   811,  2014,     0,     0,     0,     0,
       0,     0,     0,   729,   734,   793,     0,   794,   795,     0,
     796,   797,   798,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   812,  1107,  1108,  1109,  1110,  1119,  1122,  1111,
    1112,  1113,  1121,  1114,  1115,  1116,  1123,  1124,  1125,  1117,
    1126,  1120,  1118,  1127,     0,  1106,     0,     0,     0,  1486,
     932,     0,  1215,     0,   588,   587,  1221,   586,     0,    62,
      64,  1412,     0,     0,  1421,  1933,     0,  1914,  1918,  1912,
    1916,     0,     0,  1904,     0,  1910,  1136,  1644,  1712,     0,
    1139,  1879,  1231,  1449,  1451,     0,     0,  1443,     0,     0,
     638,    58,     0,     0,  1432,     0,     0,     0,     0,   627,
    1242,     0,  1425,     0,     0,     0,     0,     0,  1993,  2009,
    2008,  1998,   716,  1158,   717,   719,   718,  1516,  1820,  1823,
    1824,  1827,  1825,     0,  1822,  1821,  1836,     0,  1389,  1392,
    1393,     0,     0,  1369,  1368,  1364,  1365,     0,  1177,  1178,
    1176,  1171,  1172,  1175,  1373,  1371,  1362,     0,  1391,     0,
    1372,  1370,  1317,  1318,  1319,     0,  1167,     0,  1391,  1391,
    1381,     0,  1391,  1391,  1352,  1356,     0,   600,   609,   597,
     604,  1088,  1087,     0,  1052,     0,  1051,  1050,  1049,     0,
    1087,  2065,  2073,  2077,     0,  1167,  2006,  2004,   262,  1265,
    1265,     0,     0,     0,     0,     0,     0,     0,   108,   117,
     582,   582,  1265,  1265,   582,  1265,  1265,  1265,     0,     0,
    1265,     0,     0,   582,     0,  1265,   580,     0,     0,  1265,
    1265,  1265,   582,     0,  1265,  1265,  1265,  1265,  1265,   592,
    1265,  1265,  1265,   579,   274,   296,   297,   544,     0,   558,
     581,  2033,  2034,   551,   635,   619,  1224,     0,   126,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   647,   641,    93,   726,
    1544,     0,  1956,  2053,     0,     0,  2035,   272,   515,  1185,
    1186,   517,  1182,  1183,     0,  1181,   516,   528,   529,   530,
     523,   531,   525,   526,   527,   521,  1184,   514,   518,   519,
     532,   513,     0,     0,  1139,     0,  1298,  1076,  1302,  1301,
    1299,     0,     0,     0,  1138,  1137,     0,  1018,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   991,     0,  1018,     0,   851,     0,     0,     0,
       0,     0,     0,  1516,     0,     0,     0,     0,     0,  2014,
       0,     0,     0,     0,     0,     0,   828,     0,     0,     0,
       0,     0,     0,     0,  1130,  1128,  1131,  1129,     0,     0,
    1013,  1005,     0,     0,     0,     0,   878,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1040,  1041,
    1137,     0,     0,     0,  1137,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   900,     0,     0,     0,     0,     0,   905,
       0,     0,     0,     0,     0,     0,     0,     0,  1137,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   935,     0,   937,     0,     0,  1519,  1518,     0,     0,
       0,     0,     0,  1045,   685,     0,   814,  1033,   813,     0,
    1832,  1008,  1010,     0,   731,   728,   733,   747,   740,   745,
     738,   742,     0,   799,  1589,   748,     0,     0,  1146,   762,
       0,     0,   765,     0,     0,     0,     0,   767,   769,   770,
     773,   877,   772,   877,   780,   781,   777,   778,   779,   783,
       0,   803,   808,  1036,   979,  1520,  1216,  1954,  1214,    65,
       0,     0,  1407,  1422,  1410,  1964,     0,  1963,  1949,  1952,
    1527,     0,     0,     0,  1889,  1883,  1890,  1892,  1886,  1891,
    1893,  1884,  1885,  1880,  1887,  1140,  1169,     0,     0,   668,
     669,   672,     0,  1869,  1870,  1868,  1867,   649,  1434,  1433,
       0,   656,   659,   660,   632,   631,   633,   626,   628,   629,
     254,  1248,     0,     0,     0,  1254,  1235,  1245,   617,     0,
       0,     0,     0,     0,   712,  1076,  1206,   709,   690,  1169,
    1159,   689,   720,     0,  1819,     0,  1790,  1847,     0,     0,
       0,     0,     0,  1837,  1388,     0,  1339,     0,  1363,  1376,
    1375,  1334,     0,     0,     0,  1332,  1382,     0,  1351,  1314,
    1374,  1331,  1139,  1381,  1329,  1330,   614,   613,   608,  1087,
    1076,     0,     0,  1073,  1089,     0,  1089,  1076,  1076,     0,
    1076,  1132,  1084,     0,     0,  2076,  1160,  2005,  1263,  1264,
    1266,     0,     0,   111,   114,   112,     0,   113,     0,     0,
     583,   537,   503,   503,   562,     0,   336,   537,   496,   560,
       0,     0,     0,     0,     0,     0,     0,     0,  1265,     0,
     573,   556,     0,     0,     0,     0,   574,     0,   557,  1265,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     595,   594,   593,     0,     0,     0,     0,   275,   460,   339,
       0,   589,   336,   342,  1523,  2037,  1103,     0,  1102,   129,
      76,    72,    84,  1190,  1191,  1189,  1187,  1188,    85,    74,
      75,    79,    78,    80,    81,    82,    77,    73,    86,    87,
      71,     0,  1957,     0,   238,   237,     0,  2051,  2037,     0,
     339,    89,  1455,   273,   276,   524,   522,     0,    90,  1076,
    1158,  1301,  1139,     0,  1132,     0,   820,   835,     0,     0,
     984,     0,     0,   986,   987,   988,     0,   839,     0,   837,
     840,   841,   842,  1033,     0,     0,     0,     0,  1033,   990,
       0,   847,     0,     0,   852,   853,     0,   826,     0,   860,
       0,   862,     0,  1033,     0,   856,     0,   817,     0,     0,
    1033,     0,   868,     0,   829,     0,     0,   970,     0,   953,
     949,     0,   951,     0,     0,  1033,  1033,     0,   873,     0,
       0,   879,  1033,     0,   972,     0,   954,     0,   885,     0,
    1033,     0,  1038,     0,     0,     0,   997,   889,   890,     0,
     995,   956,     0,     0,   892,   958,     0,   960,     0,   955,
     962,   963,   894,   896,   895,   965,     0,     0,   967,     0,
     969,     0,   898,   899,     0,     0,     0,   903,     0,  1033,
     909,   906,   999,  1001,     0,     0,     0,     0,     0,  1003,
     916,   918,     0,     0,     0,   917,     0,     0,     0,     0,
       0,     0,     0,   922,     0,     0,   936,  1002,   827,  1000,
     941,     0,   944,     0,   943,     0,     0,     0,     0,  2013,
    2015,     0,     0,   818,     0,     0,     0,     0,     0,  1521,
     786,   785,     0,   788,   787,     0,   741,   746,   739,   743,
       0,     0,     0,     0,   760,   759,     0,     0,  1146,   763,
       0,   775,   774,   876,     0,   978,   716,  1033,     0,    63,
    1411,  1961,     0,     0,     0,     0,     0,     0,     0,     0,
    1878,  1170,  1275,  1535,  1444,     0,   676,  1871,  1872,     0,
     630,   695,     0,  1267,  1252,  1259,  1253,     0,     0,     0,
    1251,  1512,  1511,  1518,  1996,     0,     0,     0,     0,  1999,
    1139,  1139,  1200,     0,     0,   687,   692,   688,   691,     0,
     715,   724,   723,  1513,  1520,     0,     0,     0,     0,   446,
     448,   447,   456,     0,   445,     0,     0,  1832,     0,   452,
     454,   453,  1842,   451,  1390,  1167,  1347,  1346,  1174,  1173,
       0,  1325,  1341,  1391,     0,  2003,  1082,     0,  1075,  1074,
    1090,     0,  1076,  1089,  1089,     0,  1055,  1054,  1279,  1282,
       0,  1053,  1093,  1080,   695,  2066,  2078,     0,   459,   458,
     303,   455,   302,   116,   115,   121,   122,   341,   538,   497,
     498,     0,     0,     0,   503,   335,   537,   334,   337,   512,
       0,   286,   283,   564,   289,   285,   301,     0,     0,   290,
     537,   571,   572,   586,   279,     0,   315,   316,   314,   298,
     281,   282,   566,  1154,  1156,  1164,   288,   287,   284,   293,
     294,   312,   311,   292,   313,   577,   310,   308,   305,   307,
     306,   309,   291,   280,     0,   559,     0,   325,   327,   328,
    1526,     0,   591,   561,     0,   329,   330,     0,     0,     0,
       0,   675,     0,  1958,  2054,   241,   239,   240,     0,     0,
       0,   244,     0,   242,     0,     0,  1457,  1456,   243,   257,
     460,   277,   520,     0,  1139,  1179,  1294,  1300,     0,     0,
       0,   985,  1019,     0,   422,   422,  1029,  1027,   411,   422,
    1023,  1028,  1025,     0,     0,     0,     0,     0,     0,     0,
     992,   989,     0,     0,     0,  1520,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1016,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   974,  1042,   998,   996,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1004,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1046,   823,  2010,  2011,   815,  1833,  1834,
    1835,   539,  1009,   730,   735,     0,   753,  1033,   751,  1145,
     757,     0,     0,   761,     0,   933,     0,   980,   981,     0,
    1032,  1522,  1962,  1951,  1950,  1965,  1965,  1965,     0,  1141,
       0,  1232,  1455,   670,     0,   671,   657,   716,  1249,  1261,
       0,  1269,     0,     0,  1246,  1256,     0,     0,     0,  1255,
       0,  1896,  1897,  1895,  1169,  1147,     0,     0,  1211,     0,
    1207,   710,     0,   722,   721,     0,  1849,     0,  1848,  1860,
    1861,  1858,  1859,  1857,  1838,     0,  1844,  1843,     0,     0,
       0,  1854,  1845,     0,     0,  1340,     0,  1335,   615,     0,
    1076,  1089,  1076,  1062,     0,     0,  1076,  1058,  1056,  1060,
       0,  1139,     0,     0,     0,     0,  1077,   716,  1515,  1161,
    1164,   338,   537,   499,   500,   512,     0,     0,     0,     0,
     456,   299,   570,   569,   300,     0,     0,  1165,  1166,  1157,
       0,   563,   339,   590,   476,   407,   356,   347,   422,   350,
     349,   393,   364,   361,   411,   409,   379,   411,   411,   386,
     385,   403,   389,   369,   462,   462,   368,   406,   462,   390,
     388,   392,     0,   394,   411,   399,   387,   391,   408,   384,
     381,   405,   422,   422,   362,   365,   404,   462,     0,   397,
     422,   426,   367,   462,   468,     0,     0,   422,   424,  1525,
    2039,     0,  2041,  1101,   142,   716,     0,   101,  2052,  2041,
       0,   247,   272,   258,     0,   278,     0,  1296,     0,  1292,
     801,   832,   836,   946,     0,  1020,   462,     0,  1030,   413,
    1022,  1024,  1026,   822,   838,   843,   948,   825,   824,     0,
       0,     0,     0,   858,   861,   863,   854,   859,   857,     0,
     947,   870,   867,   869,   830,     0,   971,   950,   952,   872,
     883,  1014,  1017,     0,     0,     0,   884,   880,   973,   881,
       0,   886,   855,   887,     0,     0,     0,     0,   957,   891,
     959,   961,   966,   964,   968,   897,   834,     0,   902,   904,
     816,   801,   907,     0,   913,   911,     0,     0,   919,     0,
       0,   928,     0,   926,     0,   927,     0,   929,   930,     0,
     942,   945,  1047,     0,  1996,     0,  1011,   749,     0,   755,
    1033,   752,   758,   717,   716,   931,     0,  1970,  1970,  1970,
    1274,  1273,     0,  1272,  1276,     0,   677,   255,     0,     0,
       0,  1270,  1258,  2000,  1247,  1250,  1520,  1898,   694,     0,
    1142,  1210,  1208,     0,  1201,  1203,  1205,     0,  1514,     0,
       0,  1853,  1839,   457,     0,     0,     0,     0,  1840,     0,
    1132,  1083,     0,     0,  1049,  1076,  1076,     0,  1049,     0,
       0,     0,  1281,  1158,  1283,  1091,  1095,  1096,  1094,  1085,
       0,  1163,     0,     0,     0,   576,     0,   589,   578,   426,
    1155,   295,   326,   482,     0,     0,   366,   415,   410,     0,
     415,   415,   468,   470,   464,   468,     0,   375,   393,   370,
       0,   462,   383,   374,   395,   398,   400,   402,   415,     0,
     462,   363,   372,     0,   415,   434,     0,     0,     0,   430,
       0,   475,     0,   437,   343,   427,   429,     0,     0,   396,
       0,   352,   469,     0,   354,     0,     0,   415,     0,   425,
     415,     0,  2038,     0,  2045,     0,   145,   143,   144,     0,
     138,   140,   135,     0,   323,   324,   322,   321,     0,   131,
    2045,   245,  2000,  1455,     0,   250,     0,  1164,   535,  1180,
       0,     0,  1021,     0,     0,   993,   849,   850,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   819,
       0,     0,     0,     0,     0,     0,     0,   925,   923,   924,
       0,  1048,  2015,   540,   754,     0,   720,   982,     0,     0,
    1969,  1967,     0,  1968,  1966,  1942,     0,  1901,  1902,  1900,
    1888,     0,     0,  1445,  1169,  1260,  1262,  1268,  1257,     0,
    1143,  1158,  1458,  1204,     0,   711,  1851,  1850,  1852,  1846,
       0,     0,     0,     0,  1081,  1076,  1063,     0,  1067,  1072,
    1068,     0,  1059,  1057,     0,  1179,     0,  1097,  1169,  1164,
       0,     0,     0,     0,     0,     0,     0,     0,   575,  1491,
     565,   567,     0,     0,     0,   477,   478,   483,   485,     0,
       0,   419,   420,   421,   376,   416,   418,     0,   378,   346,
     463,   471,   472,     0,   467,   465,   468,   371,   401,   377,
       0,   373,     0,   360,   440,   439,   725,   432,   442,     0,
       0,   438,   428,   436,   431,     0,     0,     0,     0,   344,
       0,   345,  1524,  2040,     0,   552,   716,   716,  2042,  2055,
     142,     0,     0,     0,     0,   132,   134,   135,  2036,   248,
     246,     0,  1996,    91,     0,   534,     0,   833,   423,   412,
       0,   844,   864,     0,   831,  1015,  1006,  1137,   874,     0,
     882,   888,   976,   975,   901,   908,   912,   910,   914,   920,
     921,  1033,  2012,   756,   983,  1948,  1947,  1946,  1943,     0,
       0,     0,     0,     0,     0,  1971,  1973,  1271,     0,     0,
     256,   709,   317,  1151,  1164,     0,  1169,     0,  1466,  1202,
    1856,  1855,  1841,     0,     0,     0,     0,     0,     0,     0,
    1104,  1280,  1092,     0,  1086,  1162,     0,     0,   331,  1493,
    1492,   589,   488,   489,   490,     0,     0,     0,   481,   484,
     355,   348,   417,     0,   541,   473,   466,     0,   359,   441,
     725,   435,   462,   468,   462,   468,     0,     0,     0,   685,
       0,   109,   139,     0,   716,   100,   102,     0,     0,   252,
     251,  1164,     0,     0,     0,     0,     0,     0,  1944,  1974,
    1977,  1975,  1976,  1978,  1972,     0,     0,   318,     0,     0,
    1148,  1150,  1144,  1192,     0,     0,     0,     0,  1459,  1461,
       0,  1209,     0,  1078,  1064,     0,  1069,     0,  1061,     0,
    1099,     0,   332,   568,   492,     0,   491,     0,   486,   487,
     482,     0,   462,     0,   462,   433,   351,   353,   357,   358,
       0,  2046,     0,  2043,     0,  2056,   141,     0,     0,   133,
     136,  2000,   533,   536,   414,   865,     0,   994,   875,   934,
    1277,  1285,     0,  1446,  1152,  1153,  1164,     0,   693,     0,
       0,     0,     0,  1460,     0,     0,  1467,  1469,     0,     0,
       0,     0,  1105,     0,  1100,   333,   494,   495,   493,   479,
     480,   380,   542,   382,  2047,  2048,  2000,   119,   118,   110,
       0,   178,     0,   103,   253,     0,     0,     0,   449,  1149,
    1193,  1464,  1465,     0,  1462,     0,     0,  1468,     0,     0,
    1066,  1071,  1098,  2044,   120,     0,   194,   182,     0,     0,
       0,   180,   208,  2057,     0,     0,   184,   206,   207,   185,
    1538,     0,  1539,  2049,     0,   866,  1284,  1286,     0,  1447,
       0,  1463,  1471,  1470,     0,  1079,   193,   196,     0,     0,
     199,   189,   188,   190,     0,     0,     0,   179,   229,   178,
     178,   232,   187,   225,   178,   104,   450,  1458,   716,     0,
     195,     0,     0,     0,   181,   209,   220,   223,   215,   150,
     178,     0,   178,     0,     0,  2050,   109,  1466,     0,     0,
    1196,  1198,     0,   191,     0,     0,     0,     0,   178,   216,
       0,   146,     0,     0,   148,   235,     0,   227,   105,  1472,
    1199,  1194,   716,  1336,     0,   183,   200,   217,   223,   213,
     221,   178,     0,     0,   178,     0,   231,   149,     0,   233,
     226,   228,   178,     0,  1474,  1197,   192,   197,   178,     0,
     214,     0,     0,   212,   161,   160,     0,   152,   174,   230,
       0,   151,     0,   178,   106,     0,     0,  1481,     0,   178,
     218,     0,   178,     0,     0,     0,     0,     0,   147,     0,
     178,  1473,  1476,     0,     0,  1478,  1479,     0,  1448,   198,
     203,     0,   210,   178,   155,   175,   176,     0,   158,   236,
       0,  1480,  1475,     0,  1482,   199,   178,   202,   178,     0,
       0,   153,   167,   154,   165,   157,     0,   234,  1477,   204,
     178,   178,   173,   171,   178,   162,   169,   164,     0,   170,
     177,   168,     0,   159,     0,   156,   172,   166,   163
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,    52,    53,    54,    55,    56,    57,   985,    58,   533,
     932,  1399,  1400,    59,   430,    60,   710,  1144,  1145,  1146,
      61,  1617,  2503,  1162,   407,   425,   391,  2808,  3079,  3448,
    3544,  3596,  3642,  1108,  3445,  1538,  3499,  1539,    62,   498,
     708,  1126,  1127,  3254,  3255,  3251,  3256,  3069,  3070,  3071,
    3072,  3634,  3590,  3611,  3635,  3675,  3709,  3715,  3716,  3656,
    3724,  3725,  3726,  3732,  3727,  3657,  3711,  3591,  3534,  3564,
    3560,  3535,  3624,  3559,  3646,  3582,  3583,  3648,  3690,  3707,
    3536,  3537,  3565,  3606,  3538,  3566,  3628,  3587,  3629,  3649,
    3691,  3588,  3607,  3652,  3610,  3539,  3594,  3640,  3572,  3589,
    3593,  3663,  3638,  2076,  2488,  2081,  2493,  3082,  2498,  3262,
    3451,  1905,  2311,  3144,  2814,  1102,  1103,  1104,   408,   409,
     410,   506,  2082,  1573,  2083,  2084,  1575,  1576,  1031,  2462,
    2453,  2439,  3310,   731,  3078,  2466,  2467,  2468,  2469,  2417,
    2418,  1995,  1996,  2042,  2477,  2791,  3009,  3029,  2792,  2793,
    2794,  2795,  2796,  2797,  2798,  2828,  2829,  3204,  3205,  3206,
    2825,  3060,  3044,  3045,  3046,  3227,  3016,  2351,  2352,  3549,
    2361,  2362,  2399,  2686,  2400,  1107,  3017,  3054,  3214,  3047,
    2476,  3003,  3195,  3347,  3196,  3197,  3198,  3428,  1997,  2416,
    1123,  1124,   657,   411,  1176,  1637,  1638,  1639,  3086,  3087,
    2407,  2916,  3353,    63,  1110,   693,   695,   694,  2045,   485,
    1577,  1578,  1579,  2729,  2735,  3341,  1999,   111,  1396,  2473,
    2033,    64,  1081,  1076,    65,   668,   663,   664,  1079,  1080,
    1507,  1957,    66,   600,    67,   493,    68,   501,  1149,    69,
     993,  1897,  1898,  1899,    70,   700,    71,   502,  1156,  1157,
    1158,    72,   983,   116,    73,   589,   988,   990,   991,    74,
     495,   496,  1118,    75,  1426,  1879,  1880,   705,   706,  1125,
    2645,    76,    77,   476,   450,   606,   451,   452,  1453,  1917,
    3311,   617,   618,   619,  2335,  1010,  1011,  1012,  1922,  1454,
    2340,  1164,  2931,  1333,  1805,   894,  1334,  1806,   895,   896,
     897,   898,   899,   900,   901,   902,   903,   904,  2262,  2265,
    3048,   905,  1343,  1816,   906,   907,  1844,   908,  2877,  2284,
    2285,  2286,  2627,  2628,   909,  2118,  2840,  2156,   910,  1330,
    1801,  1711,  3101,  2861,  1656,  2101,  2523,  2629,   522,   523,
     911,  1254,  1255,  1256,  1728,  1321,  2248,  1793,  1514,  1515,
    1516,  1517,  2980,  2979,  2981,  3325,  3167,  3327,  3171,  1968,
    1518,  1519,  3479,  2375,  2700,  2393,  2394,  3178,  1959,  1520,
    2381,  3177,  2716,  2986,  3333,  3483,  2047,  3329,  1384,  1385,
    1708,   967,   968,  1657,  1876,  2299,  3151,  3315,  2274,  2950,
    3313,  3400,  1580,  2443,  2444,  1919,  1920,  2397,  2719,  2739,
    1034,  3312,  2301,  1481,  1482,  2819,  1640,  2058,  3468,  3550,
    3599,  3600,  3601,  2668,  2669,  2954,  2955,  1921,  2332,  2670,
    3152,    78,   413,    79,  1846,   701,   702,   525,   422,    80,
     431,  1877,    81,   444,  1441,   573,   593,   996,   997,  1906,
    2312,  2319,  1907,  2324,  2943,  2314,  2648,  2649,  1980,  1981,
    2315,  2651,  2940,  2932,  2933,  2641,  3142,    82,   464,  2711,
    2388,  2389,  3460,  3461,   594,    83,   412,   742,  1644,  1181,
    1643,   743,   744,  1183,   520,   521,    84,   462,  1055,  1056,
    1057,  1496,    85,   455,   658,  1477,  2365,  1941,   585,   660,
    1488,   661,  1489,  1468,  1936,  1022,    86,   689,   688,    87,
     481,  1098,    88,   534,   943,   944,  1404,  1854,    89,   445,
     598,   599,    90,   439,   586,  1434,    91,   432,   576,    92,
      93,   577,   976,  2642,  3309,  3508,  3577,  1425,   977,  2499,
    3318,  3408,  3409,  3411,  3476,  3477,  3644,  3667,  3684,  3685,
    3688,   912,   677,   913,  3188,   914,   915,  2320,  2321,  2720,
     916,  3462,   917,  2043,   671,   428,   918,   567,   919,  2304,
     920,  3541,   723,   724,   394,   395,    94,   620,   454,  1014,
    1015,  1016,  1463,  1464,   662,  2257,  1465,  1466,  1933,  1928,
    2962,  2692,  2684,    95,   580,   945,   981,   982,  1885,    96,
     463,    97,   969,  1420,  1421,  1873,  2298,  1874,    98,   602,
      99,   556,  1414,   557,   947,   558,   559,   959,   954,   962,
     956,  3299,  3134,  3135,  1861,   928,   725,   726,  1407,  1856,
    1857,  2927,  3137,  3305,  3306,   100,   120,   400,   504,   717,
    1004,   101,   102,   103,   104,  1007,  1093,  1913,  1094,  1095,
    1096,  1527,  1451,  1328,  2914,  2250,  1795,  2605,   509,   732,
     491,   511,   512,   112,   113,   733,   734,  2078,  2480,  2801,
    3064,  3065,  3248,  3245,   735,  3574,   736,  2489,  2073,  2804,
    3371,  3501,   105,   679,   473,  1091,  1086,  1088,  1523,  1975
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3269
static const int yypact[] =
{
    3776, -3269,   176,   655,   760, -3269,   142, 43341,    85,   760,
     760,   152,   657, -3269, -3269, -3269, -3269, -3269,   733, 43341,
     655, -3269, 21424, -3269, -3269, -3269,   157,   760,   655, 43341,
   -3269,   388,   711,   655, -3269, -3269,   760, -3269,   152, 43341,
   -3269,   488, -3269,   371,   528,   544,   382, -3269, -3269, 43341,
     684,  -141,  1005,  1013, -3269, -3269,   658, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, 21987, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269,   936, 43341, 43341, -3269,
   43341,   631, -3269,  1070, -3269, -3269,   760, -3269, -3269, -3269,
     152, 21424, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269,   598, -3269, -3269,   685, -3269, -3269, -3269,
    1186,   995, -3269, -3269, -3269, -3269, -3269,   216,   724, -3269,
     729,  1014,   536, -3269,  1029,  1029, 43341,  1029, -3269,  1029,
   -3269,  1029,   760, -3269, -3269,   642, 43341,   910,   173,   -84,
   38301,   720,   156, -3269,  1086, 21424, -3269,   760,  1121,   210,
   43341, -3269, -3269,   760,   180,    -4, -3269,  1108,   127, -3269,
   -3269, -3269,   307, -3269, -3269,  5224, -3269, -3269, -3269,   764,
   -3269, -3269, 21424,   760,  1057, -3269, -3269,   106,   106,   106,
   -3269,   106, -3269,   106, -3269,  -141,   750, -3269, -3269, 43341,
     278, -3269, -3269,   753,   412, -3269, -3269, -3269, -3269, 21424,
    1202,   883, -3269, 21424, -3269,   -55, -3269, -3269,   777, 43341,
   -3269, 21424, 21424,   451,   554,   950, 43341, 36061,   971, -3269,
     113,  1070,  1345, -3269,   995, -3269, 43341, -3269, -3269, -3269,
   39981,   536, -3269, 13389,  1221, 43341, 43341,  1046, 43341, 43341,
   36061, 21424,  1029,   840,  1306,  1012,   974,   693, -3269, -3269,
   -3269, -3269,  1051, -3269, -3269,   909, -3269, -3269, -3269,   121,
   -3269,    42, -3269, -3269, -3269, -3269, -3269,  1062,   825, -3269,
   -3269,    75, -3269, -3269, 43341, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269,  1199, -3269, -3269, 13389,   703,  1371,  1246,
   21424, -3269,   420, -3269, -3269,  1164, -3269, -3269, 36061, 21424,
   -3269, -3269, -3269, 19162, -3269, -3269,  1389, -3269,   859, -3269,
   21424,  1012, -3269,  1110,  1047,   554,   938, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269,   904,   307, -3269,
   -3269,  1226,  1343, -3269,  1061,    -8,   985,   935,   233,    -8,
   38301,  1268, -3269,   135, -3269,  1362, -3269, -3269,  1088, -3269,
   -3269, -3269,  1091,  1100,  1250,  1063, -3269,   162,   381, -3269,
    1123, -3269,    57, -3269,  -180,  1268,    -8,   810, -3269,  1287,
    1430,   195,   537, -3269,   551, -3269, -3269,  1504, -3269, -3269,
   -3269, -3269, -3269,  1199, -3269, -3269, -3269,  1001, -3269,  1251,
    1114, -3269, -3269,    61, -3269,  1023,     5, -3269,   322, 36621,
   -3269, -3269, -3269,    94, -3269, -3269, -3269, 36061,  1185,  1085,
   21424,   466, -3269, 40541, 21424, -3269,     9, 13389, -3269, -3269,
    1939,    84,    93, -3269,  1589,  1244, -3269, -3269, -3269, -3269,
    1493, -3269,  1064,  1073,  1439,  1067, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269,  1120, -3269, -3269, -3269,   883, -3269, 21424,
    -187, 21424, -3269,  1084, -3269,  1094, -3269,  1095,  1103,  1135,
    1143,  1162, 16319, -3269,  1173,  1189,  1190,  1193,  1194,  1195,
    1196,  1198,  1200,  1203,  1204,  1206,  1207,  1208,  1064,  1064,
    1210,  1214,  1217,  1219,   423,  1222, -3269,  1223,  1227,  1229,
    1234,  1235,  1236,  1238,  1239,  1241,  1242, -3269,  1245, -3269,
    1247,  1248,  1254,  1257,  1260,  1261,  1262,  1264,  1265,  1269,
    1270,  1271,  1272,  1273, -3269,  1274,  1275,  1278, 13389,  1280,
    1281,  1284,  1286,  1289,  1290,  1291, -3269,  1293,  1294,  1295,
    1296,  1297,  1298,  1299,  1302,  1303,  1304,  1305,  1307,  1308,
    1309,  1311, -3269, -3269, 13389,  1312, -3269, -3269,  1315,  1316,
   -3269,  1318,  1319,  1320,  1321,  1322,  1324,  1325,  1326,  1329,
    1330,  1331,  1334,  1335,  1344,  1346,  1347,  1348,  1350,  1351,
    1352,  1353,  1354,   548,  1355,  1357,   591,  1359, -3269,  1363,
   -3269,   128,  1364,  1365,  1367,  1064,  1064,  1064,  1368,  1369,
    1370,  1373,  1374,  1376, 13389, 16319, 16319, 16319,  8701, -3269,
   43341, -3269, 43341, -3269,  1130, -3269, -3269,  1040, -3269,   823,
    1157,   867,   745,   213,  1188, 16319,  2395,   196, -3269, -3269,
   -3269,  1124,  1310, -3269, -3269, -3269, -3269, -3269,  1377, -3269,
    1116, -3269, -3269, -3269, 21424, -3269, -3269, -3269,  1249,    90,
   21424,  1181, -3269, -3269, -3269, -3269, -3269, -3269,  1656, -3269,
   -3269, -3269,  1387,  1266, -3269, -3269, -3269, -3269, -3269, -3269,
    1292, -3269, -3269, -3269,  1378, -3269,  1378, -3269, -3269,  1378,
   -3269, -3269,  1378,   610,  1432, -3269, -3269, 43341, -3269, 43901,
   -3269, 19162, -3269, -3269,  1540, -3269, -3269,  1571, -3269,  1583,
     114,  1380, -3269, 21424, 38301, -3269, -3269,   126,  1382,  1418,
    1384, -3269,  1420, 21424, 21424, -3269, -3269, -3269, -3269,    -4,
       3,  1385,   634, -3269, 43341, -3269,   269, -3269, -3269, -3269,
    1388, -3269, 13389, -3269,  1391, -3269,   888, -3269,  1725, -3269,
    1473, 13389, -3269, -3269,  1400,   995, 43341, 43341, 21424, 21424,
   -3269, -3269, -3269,   773, -3269, -3269, 43341,    -8, 36061, -3269,
   -3269, -3269,  1806,   810, 43341,    -8, -3269,  1749,  1489, -3269,
   -3269, -3269,  1821, -3269, -3269,  1810,  1401, -3269,   810, -3269,
   -3269,   810, -3269, -3269, -3269, -3269, -3269, 21424, -3269, -3269,
     810, -3269,   810,   810,    -8,    -8,  1452, -3269, -3269,  1402,
   -3269,  1452,  1532,   353,   106,  1628, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269,   502, -3269, -3269, -3269,
   -3269, -3269, -3269,   104, -3269, -3269, -3269,  1205,   900,   900,
    1651, -3269,   675, 21424,    93,  1473, 21424, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269,  1409, -3269,  1411,  1412, -3269,  1854,
    1857,  1859,  1860,  1861,  1870,  1873,  1874,  1875,  1876,  1878,
    1879,  1880,  1882,  1884,  1446, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269,  1499, -3269, -3269, -3269, -3269,  1118, -3269,
   -3269, -3269,    94,  1453, -3269, 38301,  1994, 36061, 43341, 43341,
    1862, 21424, -3269, -3269,  2814,  2814,  1696,  1084, -3269,   101,
   43341,  1867, 25923,    76, 13389, 13389, 13389,   289,   799,  1981,
    2034,  2034,  2034, 13389, 13389, -3269, -3269, 13389, -3269, 13389,
   13389, 13389, 13389,   301, -3269, -3269,  9287, -3269,  1463, 13389,
   13389,  1549, 13389,  1310, 13389, 13389, 22550, 13389, 13389, 13389,
   13389, 13389,   352, 13389,  2395, 13389, 13389, 13389,  1465, 13389,
   13389, 13389, 13389, -3269, 13389, 13389,   237, 13389,  1925,   443,
   13389, 13389, 13389, -3269,  9873, 13389, 13389, 13389, -3269, 13389,
   13389, 13389, 13389, -3269,  2042, -3269, 22550,   790, 13389, 13389,
     795, 13389, 13389, 13389, 13389, 13389, -3269, -3269, -3269, -3269,
    9287, -3269, 13389, 13389, 13389, 13389, 13389, -3269, 16319, 13389,
   10459, 13389, 13389, 13389, 13389,  1469, 13389, 13389, -3269,  2034,
    2034, 13389, 13389, 13389,   966,  9287, -3269, 13389,  1310,   712,
     712, 13389,  1310,  7529, 13389, -3269, -3269, -3269,   443, 11045,
    1471, -3269, -3269, -3269,  2034, 22550,  2034, 13389, 13389, 13389,
   -3269,  1501,  1981,  1981,  1981, -3269,  8701,   754,  1474, 13389,
   23676,  1467, 13389, -3269, -3269, -3269, 16319, -3269, -3269,   737,
   -3269, -3269, -3269, 13975,  1476, 16319, 16319,  1808, 16319, 16319,
     117, 16319, 16319, 16319, 16319, 16319, 16319, 16319, 16319, 16319,
   16319, 16319,  1981, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269,  1485, -3269, 38301, 16319, 13389, -3269,
   -3269, 43341, -3269, 36061, -3269, -3269, -3269,    90, 38301,  1477,
   -3269, -3269,  1673,  1306, 21424, -3269, 43341, -3269, -3269, -3269,
   -3269, 19725, 19725, -3269, 19725, -3269, -3269,    89,    92,  1341,
    1508, -3269, -3269, -3269, -3269,  1847, 21424, -3269,   -22, 21424,
      93, -3269, 13389,  1473, -3269, 36061, 36061, 21424, 21424,    62,
   -3269,   757, -3269,  1473,  1877, 19725, 19725, 19725, -3269, -3269,
   -3269, -3269, -3269,   636, -3269, -3269, -3269,  1478, -3269, -3269,
   -3269, -3269, -3269, 41101,   115, -3269, -3269,  1473,  1891, -3269,
   -3269,  1483, 43341, -3269, -3269, -3269, -3269,    22, -3269, -3269,
   -3269, -3269,   -95, -3269, -3269, -3269, -3269,  1615,    -8, 43341,
   -3269, -3269, -3269, -3269, -3269,  1690,  1268,   381,    -8,    -8,
     810, 21424,    -8,    -8, -3269, -3269,   895, -3269,   551, -3269,
   -3269, -3269, -3269, 43341,  1039,  1629,  1491, -3269, -3269, 21424,
   -3269,  1492, -3269,  1907,  2035,  1268, -3269, -3269, -3269,    96,
      96,  1473,  1612,  1613,  1614,  1616,  1617,  1660, -3269, -3269,
     652,  2023,    96,    96,  2023,    96,    96,    96,  1586,  1969,
      96,  1858,  1602,  1080,  1865,    96, -3269,  1603,  1976,    96,
      96,    96,  2023,  2054,    96,    96,    96,    96,    96,   131,
      96,    96,    96, -3269,  2499, -3269, -3269,  1518, 20288, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, 41661, -3269, 13389,
     799,  1473,  1473,   198,  1473,   799,  1473,  1473,  1473,  1473,
    1473,   799,  1473,  1473,   799,  1939, -3269, -3269, -3269, -3269,
   -3269,   -38, -3269, -3269,  1081, 43341, -3269,  2372, -3269, -3269,
   -3269, -3269, -3269, -3269,   710, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,  1520,
   -3269, -3269, 21424,  1566,  1508, 25923, -3269,   353, -3269,  1517,
   -3269,  1524,  1526,   761, -3269,  2034,  1528, -3269,  1534,  1536,
    1541,  1543,  2099,  1544,   441,  1545,  1546,  1547,  1539,  1548,
    -229,  1554, -3269,  1550,  1555,  1560, -3269,  1561,  1562,  1564,
    1565,  1567,  1572,  1568,   831,   839,  1574,  1575,   858, -3269,
    1573,  1576,  1943,  1577,  1578,   878, -3269,  1580,  1581,  1585,
     894,  1587,   912,   914, -3269, -3269, -3269, -3269,  1588,  1590,
   -3269, -3269,  -158,  1592,  1593,  1595, -3269,  1599,  1600,  1601,
     919,  1605,  1606,   925,  1607,  1608,  1611,  1582,  1618, -3269,
    2034,  1621,  1622,  1623,  2034,  1624,   939,  1633,  1625,   942,
     951,  1635,  1645,  1646,  1648,  1649,  1650,   958,  1652,   960,
    1654,   -32,  1655, -3269,  1657,  1658,  1659,  1661,   964, -3269,
    1662,  1665,  1667,  1668,  1672,  1674,    11,  1675,  2034,  1678,
    1679,   968,  1680,  1681,  1683, 11631, 12217, 12803,    60,  1685,
     271, -3269,  1684, -3269,  1689,  1692, -3269,  1568,  1693,   970,
     990,  1694, 13389,   563, -3269,   352, -3269, -3269, -3269,  1557,
     562, -3269,  1703, 43341, -3269,   800,  1314, -3269, -3269, -3269,
   -3269, -3269,   396, -3269,  1591, -3269,  1604,  8701,   226,  1626,
   16319,    86,  1157,  1619, 16319, 16319, 16319,   867,   745,   745,
     213,  2395,   213,  2395,  1188,  1188,  1188,  1188,  1188,  1981,
   13389, -3269,  1981, -3269,  1695,   653, -3269, -3269, -3269, -3269,
    1181,  1922, -3269,  1698, -3269, -3269,   994, -3269,  1610, -3269,
    1701,  1682,  1727,  1732, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269,  1268,   757,  1699,  1707,
   -3269, -3269,  1637,  1999, -3269, -3269, -3269, -3269, -3269, -3269,
    1750, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,    34,
   -3269, -3269,  1697,  1697, 18031, -3269, -3269, -3269, -3269,  1915,
    2109,  2111,  2118,   322, -3269,    50, -3269,   772,  2068,  1268,
   -3269,  2120, 38861, 26485, -3269,  1706,  2064,  1709,    96, 34381,
     273, 24236, 34941, -3269, -3269,   198, -3269,    69, -3269, -3269,
   -3269, -3269,   773,   773,  1742, -3269, -3269,  1963, -3269, -3269,
   -3269, -3269,  1508,   810, -3269, -3269, -3269,  1718, -3269, -3269,
     353,  2070,  2071, -3269,  1949,    33,  1949,   353,   353, 22550,
     353,  1597, -3269,   799,  2005, -3269, -3269, -3269, -3269, -3269,
   -3269, 37181, 35501, -3269, -3269, -3269,  2213, -3269,  2215,   697,
   -3269, 23113,   952,   952, -3269,    98,   174, 23113, -3269, -3269,
   23113,   198,   799, 23113,   799,  1473,  1473,  1533,    96,   799,
   -3269, -3269,  2074,  2075, 23113, 23113, -3269, 38301, -3269,    96,
     553,   198,   198, 23113, 22550,   207,  1473,   799,   799,   660,
   -3269, -3269, -3269, 21424,   922, 38301,  1731, -3269,  3086, 17468,
   43341,   403,   221, -3269,  1726,  1735, -3269,  1020, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269,  1816, -3269,  1739, -3269, -3269,    80, -3269,  1735, 21424,
   16905, -3269,   103, -3269,  2058, -3269, -3269,  2559, -3269,   353,
    1971,   112,  1508,  1747,    76, 14561, -3269, -3269, 13389,  1741,
   -3269, 13389, 13389, -3269, -3269, -3269,   252, -3269, 37741, -3269,
   -3269, -3269, -3269, -3269, 13389, 37741,   252, 13389, -3269, -3269,
    1743, -3269,  2103,  2103, -3269, -3269,  1310, -3269, 43341, -3269,
   13389, -3269, 13389, -3269,  1310, -3269, 13389, -3269, 13389, 13389,
   -3269,  1991, -3269, 13389, -3269, 13389, 13389, -3269, 13389, -3269,
   -3269, 13389, -3269, 13389, 13389, -3269, -3269,  1992, -3269, 13389,
   13389, -3269, -3269, 13389, -3269, 13389, -3269, 13389, -3269, 13389,
   -3269, 13389, -3269, 16319, 22550,  1753, -3269, -3269, -3269,  1755,
   -3269, -3269, 13389, 13389, -3269, -3269, 13389, -3269, 13389, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, 13389, 13389, -3269, 13389,
   -3269, 13389, -3269, -3269, 13389, 13389, 13389, -3269, 13389, -3269,
   -3269, -3269, -3269, -3269, 15147, 13389, 13389, 13389,  1757, -3269,
   -3269, -3269, 13389, 13389, 13389, -3269, 13389,  2156, 13389,  2158,
   13389,  2159, 13389, -3269, 13389,  2004, -3269, -3269, -3269, -3269,
   -3269, 13389, -3269, 13389, -3269,  1773, 13389, 13389,  2203, -3269,
   -3269,  1761,  1762, -3269,  1759,  1763,  1764, 38301, 13389, -3269,
   -3269, -3269, 13389, -3269, -3269, 13389, -3269, -3269, -3269, -3269,
     352,  1026,  1767, 16319, -3269,  1626, 16319,  8701,   226,  1626,
     100, -3269, -3269, -3269,  1768, -3269, -3269,  1772, 43341, -3269,
   -3269, -3269, 43341,  1770, 27047, 36061, 36061, 36061,  1774, 13389,
   -3269, -3269,  2014, -3269, -3269, 21424,  2145, -3269, -3269, 36061,
   -3269,   307, 22550, -3269,  1775, -3269,  1775,   409,  1777,  1033,
   -3269, -3269, -3269,  1776,   938,  2187, 36061, 36061, 36061, -3269,
    1508,  1508,   140,  1829,  2139, -3269, -3269, -3269, -3269, 42221,
   -3269, -3269, -3269, -3269,   704, 43341,  2119, 43341,  8115, -3269,
   -3269, -3269,  2307, 13389, -3269, 36061,   -28,   562,    96, -3269,
   -3269, -3269, -3269, -3269, -3269,  1268, -3269, -3269, -3269, -3269,
    2097, -3269, -3269,    -8,   895,   316, -3269,  1332, -3269, -3269,
   -3269,  2137,   353,  1949,  1949,  2138,  2031,   -49,  1791, -3269,
      96,  1039,    25, -3269,   307, -3269, -3269, 13389, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, 13389,  2140,  2141,   952, -3269, 23113, -3269, -3269,  -187,
     107, -3269, -3269, -3269, -3269, -3269, -3269, 35501,  1473, -3269,
   23113, -3269, -3269,   239, -3269,  1473, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269,  1795, -3269,   306, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, 21424, -3269,  1036, -3269, -3269, -3269,
   -3269, 43341, -3269, -3269, 21424, -3269, -3269,  4464, 43341, 43341,
    2364, -3269, 43341, -3269, -3269, -3269, -3269, -3269,  2039,  -146,
    2366, -3269, 21424, -3269,  1802,  1038, -3269, -3269, -3269,  2370,
    1887, -3269, -3269,  1807,  1508,  2136, -3269, -3269, 13389,  1809,
    1814, -3269, -3269,  1815,  1811,  1811, -3269, -3269,  1817,  1811,
    2164, -3269,  2165,  1818,  1819,  1822,  1823,  1824,  1826,  1820,
   -3269, -3269,  2395,  2395,  1827,  1825,  1828,  1830,  1833,  1837,
    1838,  1839,  1841,  1842,  1846,  1848,  1849,  1863,  1866,  1868,
    1869,  1881,  1886,  1971,  1888,  1889,  1893,  1892,  1895,  1896,
    1041,  1898,  1900,  1043,   186, -3269, -3269, -3269,  1903,  1904,
    1905,  1906,  1908,  1909,  1910,  1917,  1919,  1920,  1923,  1924,
    1926, 13389,  1927,    65,  1055,  1921, -3269,  1928,  1929,  1931,
    1933, 13389,  1934, 13389,  1935, 13389,  1936,  1937,  1940,  1942,
    1944, 13389,  1890, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269,  1864, -3269,  1130, -3269,  1945, -3269, -3269, -3269,   196,
   -3269,  1074,  1946, -3269, 16319, -3269, 13389,  1947, -3269,  1951,
   -3269, -3269, -3269, -3269, -3269,  -127,  -127,  -127, 15733, -3269,
    2299, -3269,    58, -3269,  2197, -3269, -3269,   904,  1953, -3269,
      96, 15733,  1697,  2017, -3269, -3269,   409, 22550, 26485, -3269,
   36061,  1067,  1067,  1067,  1268,  2256,  1699,  1699, -3269, 24796,
   -3269, -3269,  2011, -3269, -3269, 27609, -3269,   809, -3269, -3269,
   16319,  1227, -3269, -3269, -3269, 37181, -3269, -3269,    96,  1883,
    1941, -3269, -3269, 42781, 13389, -3269,  2316, -3269, -3269,  1955,
     353,  2107,   353, -3269,  2227,  2255,   353, -3269, -3269, -3269,
   22550,  1508, 15733,   952,   952,   952, -3269,   904, -3269,  1956,
     306, -3269, 23113, -3269, -3269,  -187,  1948,  2393,  2398, 23113,
    2307, -3269, -3269, -3269, -3269,  4464, 22550, -3269, -3269, -3269,
    1092, -3269, 17468, -3269, -3269, -3269,  1957,  1959,  1811, -3269,
   -3269, -3269, -3269, -3269,  1817,  2174, -3269,  1817,  1817, -3269,
   -3269, -3269, -3269, -3269,   199,   218, -3269, -3269,   199, -3269,
   -3269, -3269,    35,   725,  1817, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269,  1811,  1811, -3269, -3269, -3269,   199,  1961, -3269,
    1811,   884, -3269,   147,    73,  1962,  1964,  1811,  1966,  1960,
   -3269,  1096, -3269, -3269,    78, -3269,   178, -3269, -3269, -3269,
    1967, -3269,  2499, -3269,   386, -3269, 43341, -3269,   773, -3269,
    2395, -3269, -3269, -3269,  2189, -3269,   199,  2208, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, 13389,
    1968,  1973,  1974, -3269, -3269, -3269, -3269, -3269, -3269, 13389,
   -3269, -3269, -3269, -3269, -3269, 13389, -3269, -3269, -3269, -3269,
   -3269,  2117, -3269,  2222, 13389, 13389, -3269, -3269, -3269, -3269,
   13389, -3269, -3269, -3269, 13389,  2520,  2181,  1984, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, 13389, -3269, -3269,
   -3269,  2395, -3269, 13389, -3269, -3269, 13389, 13389, -3269, 13389,
   13389, -3269,  1986, -3269,  1987, -3269,  1988, -3269, -3269,  2236,
   -3269, -3269, -3269, 13389,   938, 43341, -3269, -3269,  1993, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269,    82,  2007,  2007,  2007,
    1227, -3269,  1098, -3269, -3269,  2352, -3269,  1388, 22550, 15733,
    1995,  1996, -3269,     5, -3269, -3269,  1990,  1067, -3269,  2537,
    2382, -3269, -3269, 38301,  2000, -3269, -3269,  2276, -3269,    88,
    2198, -3269, -3269, -3269,   -28,  2088,  2091,    96, -3269,  1473,
    1670,  1491,  2356,  1113,  2053,   353,   353,  1117,  2057, 13389,
   13389,  2015, -3269,  1971, -3269,  2422, -3269, -3269, -3269,  1388,
   13389, -3269,  2016,  2022, 43341, -3269,  1147,   403, -3269,   884,
   -3269, -3269, -3269,   417,  2268,  2269, -3269,  -143, -3269,  2025,
    -143,  -143,  2577,   145, -3269,  2577, 37741, -3269,  1061, -3269,
    2061,   199, -3269, -3269,  2063, -3269, -3269, -3269,  -143,  2032,
     199, -3269, -3269,  2278,  -143, -3269, 38301,  1473,   222, -3269,
    2083, -3269,  2507,  2381, -3269,   884, -3269,  2383,  2285, -3269,
    2287, -3269, -3269,  2288, -3269,  2289,  2290,  -143,  2291, -3269,
    -143, 43341, -3269, 43341,  2065,   389, -3269, -3269, -3269,  2046,
    2047, -3269, -3269, 21424, -3269, -3269, -3269, -3269,  2112, 43341,
    2065, -3269,     5,   103,  2017, -3269,  1106,   306,  2050, -3269,
    2051,  2052, -3269,  1111,  2055, -3269, -3269, -3269,  1126,  2056,
     106,  2060,  2062,  2072,  2067,  2073,  2076,  2327,  2484, -3269,
    2079,  2085,  2086,  2087,  2089,  2090,  2092, -3269, -3269, -3269,
    2069, -3269, -3269, -3269, -3269,  2093, 38861, -3269,  2142,  2146,
   -3269, -3269,  2147, -3269, -3269,    95,  1087, -3269, -3269, -3269,
   -3269, 15733,  2410, -3269,   866, -3269, -3269, -3269, -3269, 13389,
   -3269,  1971,  2583, -3269, 24796, -3269, -3269, -3269, -3269, -3269,
    2096,  2098,  8115,  2639, -3269,   353, -3269,  2127, -3269, -3269,
   -3269,  2132, -3269, -3269, 43341,  2136,  2423, -3269,   866,   306,
   43341, 43341,  1129,   443,   443,   443,   694,   694, -3269, -3269,
   -3269, -3269,   581,    53, 43341, -3269, -3269,    23, -3269,  2100,
    2101, -3269, -3269, -3269, -3269,  -143, -3269,   106, -3269, -3269,
   -3269, -3269, -3269, 37741, -3269, -3269,  2577, -3269, -3269, -3269,
     106, -3269,  2104, -3269, -3269, -3269,  1064, -3269, -3269,  2324,
    2129, -3269, -3269, -3269, -3269,  2105,  2106,  2108,  2110, -3269,
    2102, -3269, -3269, -3269,   293, -3269, -3269, -3269, -3269, -3269,
     594, 43341,  2509,  1473,  2114,  2121, -3269, -3269, -3269, -3269,
   -3269,  2123,   938, -3269, 43341, -3269,  2345, -3269, -3269, -3269,
    2353, -3269, -3269, 13389, -3269, -3269, -3269,  2034, -3269, 13389,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,   137,
    2344,   799,   799,   799,   799,  1087, -3269, -3269,  2161,  2201,
   -3269,   772, -3269,  -223,   306, 13389,  1268,   202,  2447, -3269,
   -3269, -3269, -3269,  2428,  1125, 13389,  2122, 13389,  2125,  1132,
   -3269, -3269, -3269,  2128, -3269, -3269,  1136,  1140, -3269, -3269,
   -3269,   403, -3269, -3269, -3269,   465,   465,  1145, -3269, -3269,
   -3269, -3269, -3269,  1148, -3269, -3269, -3269,  1151, -3269, -3269,
    1064, -3269,   199,  2577,   199,  2577,  2652,  2363,  2655, -3269,
    -141, -3269, -3269,  4464, -3269, -3269, -3269, 43341,  4464, -3269,
   -3269,   306,  2130,  2133,  1153,  2135,  2143,  2144, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, 22550, 21424, -3269,   258, 13389,
   -3269, -3269, -3269,  2346,  2676,  2679,  2588,  2686,   202, -3269,
    -150, -3269,  2587, -3269, -3269, 43341, -3269, 43341, -3269, 43341,
   41661,  2340, -3269, -3269, -3269,  2731, -3269,   146, -3269, -3269,
      23, 43341,   199,   106,   199, -3269, -3269, -3269, -3269, -3269,
    2388, -3269,  2390, -3269,  2160,  1142, -3269,  2606,  2329, -3269,
   -3269,     5, -3269, -3269, -3269, -3269, 13389, -3269, -3269, -3269,
    2162, -3269,    96, -3269, -3269, -3269,   306, 43341, -3269,   106,
     106,  2698,   106, -3269,  2700,  2701,  -150, -3269,   198, 13389,
    1155,  1159, -3269,  2166,  2163, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269,     5, -3269, -3269, -3269,
    2628, 32691,  2328, -3269, -3269,  2167, 22550, 15733,  1533, -3269,
   -3269, -3269, -3269,   106, -3269,   106,   106, -3269,  2737,  2170,
   -3269, -3269, -3269, -3269, -3269, 43341,   212, -3269, 44461, 44461,
   43341, -3269,  2200, -3269,  4006,   130, -3269, -3269, -3269, -3269,
   -3269,  2168, -3269, -3269,  4464, -3269, -3269, -3269, 35501, -3269,
    2178, -3269, -3269, -3269,  2483, -3269, -3269, -3269,  2590, 43341,
   -3269, -3269, -3269, -3269, 13389, 13389,  2211, -3269, -3269, 32691,
   32691, -3269, -3269, -3269, 32691, -3269, -3269,  2583,  2183,  2623,
   -3269,  2543,  2629, 13389, -3269, -3269, -3269,   573, -3269, -3269,
   29866,  2180, 33256, 13389,   130, -3269, -3269,  2447, 13389,  2188,
    2191, -3269,   799, -3269,  2560,  2207,  2225, 13389, 32691, -3269,
    2640,  2673,  2515,  2194, -3269,  2195,  2658, 44461,  1142,  2575,
   -3269, -3269, -3269, -3269, 43341, -3269, -3269, -3269,   622, -3269,
   -3269, 30431,  2219, 39421, 30996,  2202, -3269, -3269, 13389, -3269,
   -3269, -3269, 32691,  2454,  2216, -3269,  2209, -3269, 32691, 13389,
   -3269,  2657,  2226, -3269, -3269, -3269,  2601,  2217,  1006, -3269,
    2210, -3269,  2662, 32691, -3269,  2549, 18594,  2359, 43341, 28171,
   -3269,  2237, 32691,  2635, 43341,  4464,  2641,  2642, -3269,  2407,
   31561, -3269, -3269, 38301,  1166, -3269, -3269, 22550, -3269, -3269,
      28,  2242, -3269, 28736, -3269, -3269,  2706,   997, -3269, -3269,
    2262, -3269, -3269, 20856,  2162, -3269, 32691, -3269, 32691, 33821,
   13389, -3269,  2274, -3269, -3269, -3269,  4006, -3269, -3269, -3269,
   32126, 29301, -3269, -3269, 25356, -3269, -3269, -3269,  2648, -3269,
   -3269, -3269,  1310, -3269, 33821, -3269, -3269, -3269, -3269
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -3269, -3269, -3269, -3268, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269,   975, -3269, -3269, -3269, -3269, -3269,  1224, -1431,
   -3269, -3269, -3269, -3269, -3269,   404,   -69, -3269, -3269, -3269,
   -3269, -3269, -3269,  2148,  -772, -3113, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269,  -429,  -547, -3269, -3269,  -419,
   -3269, -3269, -2260, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269,  -902,  -864, -3269, -3269, -3269, -3269, -1885, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269,  -871, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,  -793, -3269,
   -3269,  -751, -3269, -3269,  -790, -3269, -3269, -3269,  -755, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,  -243, -3269,
   -3269, -1858, -3269, -3269, -3269,  1686, -3269,  1748, -3269,  2432,
   -3269,  -389,    32,  1279, -1925, -1034,  -564,  -545,  -892, -3269,
   -3269, -3269,  -333, -3269, -3269,   766,   110,  1285,  1327,   814,
     871, -3269, -3269,   141, -3269, -2664, -3269, -3269, -3269,   116,
   -3269,   120, -3269, -3269, -3269, -1365,    71, -1659, -3269,  -334,
   -1220, -3269,  -124, -3269,  -173, -3269,  -449, -2045, -1946, -3269,
   -3269, -3269,  -156,   158,   197, -3269, -2583, -2131, -3269, -3269,
    -534, -3269, -3269, -3269,  -540, -3269,  -306,  -454, -3269, -3269,
   -1474, -1715, -3269, -3269, -2190,  1720,   806, -3269, -2702,  -368,
   -1901, -3269,  -321, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269,   862, -3269, -3269, -3269,  -405,  -253, -1349, -2767,
   -3269, -3269, -3269, -3269, -3269, -3269,   907, -3269, -3269,  1393,
    1832, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269,  1003, -3269, -3269, -3269, -3269, -3269,  -903,  1746,
   -3269, -3269, -3269,  1187, -3269, -3269, -3269, -3269,  1468, -3269,
   -3269,  2206, -3269, -3269, -3269, -3269,   601,  1030, -3269, -3269,
   -3269,  2228,  1002,  -467, -1760, -3269,  2433, -3269, -3269, -3269,
   -1344, -2024, -3269,  2296,  -394, -2356,  1466,  -713,    -3, -3269,
    -207,  -749,  3907, -3269, -3269, -1259, -3269, -3269,  -789, -3269,
   -3269, -1287, -1194,  1584,  1579,   238,   311,   274, -3269, -3269,
    -501, -3269, -3269, -3269, -1265,  -741, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269,    -1, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -1139, -3269,   808, -3269, -1060, -3269,
   -3269, -3269,  1676, -3269, -3269, -3269, -3269, -3269, -1903, -1438,
     225, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -1898, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -1331, -3269,
   -1668, -3269, -3269, -1017, -3269, -3269,  -494, -2108, -1191,   402,
   -3269, -3269,  -970,  1724, -1567, -3269, -3269, -3269,   654, -3269,
   -3269, -3269, -3269, -3269,   203, -2036, -1058, -3269, -3269, -2635,
    -624, -1836,  -594, -3269, -1855,  -241, -1161, -1891, -3269, -3269,
   -3269, -3269,  -687, -3269, -3269, -3269,  -216,  1022, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269,  -476,  -381,  -115, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269,  1972,  1958,  1065,
   -3269, -3269, -1979, -3269, -3269,  1042, -3269,    12, -1870, -1164,
     295, -3269, -3269,   300, -2613, -3269, -3269, -3269, -3269, -3269,
   -3269,   243,  -733,  -550,  2493, -3269, -3269, -3269, -3269, -3269,
   -3269,  2218,  1778, -1488,  2441, -3269, -3269, -3269, -3269, -3269,
    1472, -3269, -3269, -3269, -3269, -3269, -3269, -3269,  2508, -3269,
    -939, -3269,  -481, -3269, -3269,  -606, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269,  1563, -3269, -3269, -3269, -3269,
   -3269,  1965, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,   323,
    -609, -3269,  -438,  -626, -3269,  -504, -3269, -3269, -3269,  -730,
   -3269,  -746,  -654, -1004,   -64, -2675, -1434,   318,  1970, -2791,
   -1144, -1285, -1302, -1831,    21, -3269,    -7,  -535,  -466,  -912,
    2348, -2484,  -416,  -506, -3269,  -371, -3269, -3269, -3269, -3269,
    1519, -3269, -3269, -3269, -3269,   619, -3269, -3269, -3269,   286,
   -3269,    17,  -179, -3269, -3269,   843, -3269,  1556, -3269, -3269,
   -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269,  1982,  2539,  2387, -3269,  2027, -3269, -3269, -3269,
   -3269, -3269,  -310, -3269,   -88, -3269, -1130,  1834,   342, -3269,
     708,  -877, -1165, -3269,  -303, -3269, -3269,   256,  2557,  2402,
   -3269, -3269, -3269, -3269, -3269, -2250,  -597, -3269, -2313, -3269,
   -3269, -3269, -3269, -1154, -3269, -3269,  1687,  -114, -3269, -3269,
     422, -3269, -3269,   387, -3269,  2519,  2281, -3269,   933, -3269,
     204, -3269, -3269,   -65, -3269, -3269, -3269, -3269, -3269, -3269,
   -3269, -3269, -3269,  1019, -3269, -3269, -3269, -3269, -3269, -3269
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2033
static const short yytable[] =
{
     392,   678,   678,   678,   720,   678,   656,   678,   685,  1008,
    1428,  1189,   392,  1786,   569,   392,  1168,  1169,  1170,  1204,
    1205,  1207,   392,  1030,   927,   711,   712,  1658,  1213,  1483,
    1785,  1063,   392,  1692,  2249,  1099,  2402,  1035,  1525,   487,
    2300,   488,   392,   427,  2364,  1269,  2318,   986,  1848,  1807,
    1064,  1659,  1660,  1661,  2505,   929,  1815,  2377,  2348,  2353,
    2356,  1035,  2699,  2524,  1673,  2387,  1998,  2391,  1690,  2386,
    2527,  2999,  1682,  1804,  2659,  1956,  1574,  2090, -1135,  2014,
     392,   670,   989,  2337,  1751,  2991,  1271,  2368,  2369,  1831,
    1833,  3024, -1881,   965,   965, -1882,  2419,  -259, -1945,  2984,
     392,   392,  2276,   392, -1527,  3052,  -249,  -260,   482,  1918,
    2421,  3298,  1729,  1296,   392, -1528,  2624,  1298,  1731,  1498,
    1302,  1735,  1499,   728,  1000,   739,  1311,  1312,  1313,  1105,
    2440,  2441,   965,  1502,  1503,  1664,  1665,   960,  1667,  1394,
     674,  3128,   497,   503,  1322,  1323,  1324,  1150,  1106,  2030,
    1763,  1764,  1819,  1432,  1821,  1769,  2411,  3156,  3568,  2501,
    2408,  2094,  1305,  3705,  1362,  3211,  2408,  3012,  3345,  2420,
     623,   624,  2423,  1701,   703,  1784,  1067,  1788,  1443,  3013,
    2330,   957,  3022,  2432,  2433,  3023,  2215,   106,  1721,  1972,
    1894,  1111,  2442,  3014,  2713,  2485,  3128,  2201,  1036,  3179,
     623,   624,   623,   624,  3032,  1101,  1741,  1742,  1743,  2092,
    3051,  1584,   995,  1650,  1032,  1101,  2366,  1750,  1894,  3012,
     966,   966,  2494,   678,  1114,  1044,  1121,   106,  1762,  2726,
    3190,  3013,  2411,   574,   562,  2232,  2727,  2893,  3012,  2714,
    1147,  1978,   583,  3092,  1020,  3014,  1942,  1122,  1882,  1151,
    3013, -1135,  1152,   433,   623,   624,   753,  3487, -2003,   966,
    1386,  1070,  1059, -1527,  3014,  1153,  3567,  2806,  2412,  2382,
     107,  2666,  2496,   623,  3018,  1965,  2031,  2409,  2410,  2411,
    2926,  1449,  2383,   595,  2514,  1939,  3074,  2647,  1394,   474,
    1386,  2937,  3182,   591,   448,  2708,  1061,  1089,  2385,  3066,
     526,  1654,   528,  2486,   529,  2053,   531,  3067,  2515,   675,
    3201,  2115,  3192,  1654,  1619,  2689,  3129,  2496,  2446,   607,
     971,  3189,  3183,  2071,  3474,  2737,  3146,  1025,   490,   776,
    1174,  1306,  3498,  2690,  1704,  3398,  1062,  1705,  2654,  1356,
    3404,   676, -1881,  3366,  -340, -1882,  1823,  3464,  3475,  2516,
    3405,  3367,  2517,  1175, -1527,   108,  2116, -2003,  3314,   121,
    2518,  2989,  3399,  3189,  2054, -1528,  1982,  3193,  1883,  1824,
    2717,  3129,   396,  1620,   434,  2273,   494,   596,  2001,  2002,
     787,  2004,  2005,  2006, -1135,  2372,  2009,  3557,   789,  3202,
     109,  2017,  1154,  1046,  1450,  2020,  2021,  2022,  1350,  3569,
    2025,  2026,  2027,  2028,  2029,  3075,  2034,  2035,  2036,   392,
    1622,  2471,  1026,  3130,  1655,  2875,  1895,   930,  1978,   392,
    1083,  1047,  2738,   392,  3203,   804,  1672,  2157,   392,  2050,
    1521,  1485,   608,   392,  2060,  3068,  1929,  2807,  3217,  1491,
    2066,   447,   475,  2069,  1895,  2355,  1389,  3221,  3733,  2384,
     592,   597,  3265, -1527,  1397,   392,   579,   923,  1167,   925,
     926,  2072,  1048,  2497, -1528,  2055,  1148,  1049,  1504,  1505,
    2413,  2691,   392,  1090,  1623,  1155,  1930,  2331,  3336,  3337,
    1511,  2730,   392,  3488,  2703,  1469,   392,   729,  2694,   816,
    1943,  2709,   392,  1712,   392,   392,  2667,   584,  1940,   392,
     392,  1395,  1526,   713, -1135,  3498,   564,  1430,  2497,   392,
     696,   609,  1825,   392,  3424,  2725,  2099,  1439,   392,   392,
    2712,   392,   392,   392,   392,  2506,  1357,  1887,  3307,  2732,
     704,  1006,  1486,  1060,  3570,  2993,  2056,   575,  1884,  1105,
    1574,  1349,  3558,  1979,  3335,  1625,  -340,   832,  1021,  1387,
     110,  3368,  3406,  2728,  2266,  3131,  3226,   392,  1106,   836,
     837,  1952,  1780,   563,  2715,  1998,  3132,  2472,  1431,  3076,
     508,  1071,  1896,   392,  3423,  2815,   958,  2338,  2519,  1387,
    1585,   392,   392,  3025,   698,  2408,   392,  3346,  1116,  1501,
     995,  2175,  -503,   392,   961,  2179,  2216,  3706,  1105,  2408,
    1896,   980,  1786,  2094,  1818,   676,  1998,  1027,  3466,  3157,
     992,  1037,  1050,   995,  2487,  2474, -1135,  1106,   678,  2322,
    1839,  3132,  2367,   392,   730,  2414,  2275,  1307,  2376,  2218,
    3148,  2279,  2280,  1512,  1433,   604,  1472,  1513,  1045,  2032,
    2281,  2251,  2282,  3133,  2233, -1881,  1842,  1116, -1882,  2894,
    1395,  2504,   435, -1945,   535,   536,  3053, -1527,  1530,  1349,
    3077, -1135,  -137,  2272,  3122, -2032, -1135,  1786, -1528,  1116,
    3212,  -584,  3015,  1349, -1135,  1116,  3465,  2944,  1116,  3401,
   -1881,  1051,   392, -1882,  2390,  -259, -1945,  3571,  1072,  1826,
     392,  1645, -1527,   392,  -249,  -260,   392,   392,  3049,  2724,
    3407,  -340,  2093, -1528,  1931,  2520,  3192,  1073, -1401,  3446,
    -339,   399,   466,   690,  3450,  2704,  2705,  2436,  2057,  1990,
    1979,   676,  1786,  3184,  3015,   497,  3185,  1636,  1028,   537,
    3050,  1991,   392,  2267,   392,  1586,   868,  2252,  1706,  2445,
    1052,  1707,   870,  3015,  2876,   871,  3452,  1389,   832,  1610,
     517,   401,    40,  2254,   467,  1033,  2521,   538,  3342,  1349,
    1173,  3193,  1178,  2664,  2665,  3019,  2789,  1619,   832,  3259,
     676,   539,   610,   611,   612,   613,   614,   615,   973,  3436,
    2939,  3438,  1325,  1511,  2522,  1029,   714,  1581,   616,  1411,
    1358,  1359,  1360,   540,   513,  2318,  2437,  3186,  3187,  2973,
    3425,   776,  1654,  2977,  2974,   541,   518,  1654,  2978,  2405,
     507,  1915,  2395,  1445,   440,  3066,  1900,  1367,  2964,  3246,
    2255,  2992,  -339,  3067,   530,   468,  1620,   414,  2948,   510,
    1992,  3509,  1389,   570,   542,   402,  1389,   453,  1812,  1900,
    1053,  2422,  1006,  2424,  2428,   588,   456,   119,  2429,  3491,
     457,  3493,   397,   398,  1524,  2435,  2235,  2532,  2533,   543,
     789, -1401,  1916,  1622,  2447,   544,  2449,  2450,  2454,  1121,
     436,  1054,  1948,   832,  -508,   442,  3426,   461,   974,   446,
    3575,  3210,  1945,   392,  3215,   392,  1368,  1847,  2438,   715,
    1122,  2408,  1950,  1951,  3547,  1808,  1954,  1955,  1889,   738,
   -2000,  1977,  1035,  1582,   545,    51,  1619,  3035,  1908,   691,
    2268,  3427,   415,   114,  1802,  1730,   832,   392,   519,   566,
    1734,  1372,   676,   392,   571,  2406,  2269,  1623,  1853,  1890,
    1891,  1035,  1934,   737,   692,  1689,  1512,  2817,  1483,  1483,
    1513,  3343,   676,  2698,  2333,  1392,  1211,  3175,  3036,  1077,
     416,  3068,  3037,   716,  1902,  1903,  3085,  1473,  1474,   492,
     392,   816,   392,  3089,   392,  1620,  1211,  1484,  1531,  3084,
    1841,  3216,  3247,   975,  1115,  1490,   392,   392,  1654,  2564,
    1532,  2108,  1849,   458,  1412,  1065,   392,   392,  1524,  2620,
     572,   115,  2653,  2456,  2457,  3038,  1983,   392,  1625,   460,
    3194,  2392,  1622,  2613,  1574,   477,  1212,  2256,  1446,   984,
    1786,  3696,  3380,  1074,  2373,  1932,   478,   546,  1376,   392,
     392,   392,   392,  1078,  -339,  2109,  1377,  2650,   479,   392,
    2565,   392,   837,  2458,  2334,  3344,   547,   392,   459,  1066,
    1478,  1915,   548,  2451,  3561,  3562,  2452,   676,   549,  1475,
    1476,  1116,  1344,  2525,   469,  2459,  2051,  2052,  2530,  2059,
     392,  2061,  2062,  2063,  2064,  2065,  1623,  2067,  2068,   718,
     719,  1211,   550,  2538,  1809,  1345,   470,  3168,  3169,  1459,
    2543,   484,  3676,  2278,  2733,  3356,  1075,  2460,  1500,  2074,
     676,  1768,  1378,   551,   552,  2552,  2553,  3162,  3677,  1613,
    1614,   471,  2557,   -55,  1619,  1413,   392,   417,  2075,   392,
    2562,  1479,  1993,   949,  1211,  3316,  2615,   403,  2246,  1033,
     601,   536,  -474,  2622,  2507,  2434,   489,  1961,  3586,  1413,
     553,  1297,  2247,  3641,  1583,   840,  2000,  1625,  3504,  2003,
    1380,  1533,  3608,  2463,  2983,  2085,  1460,  1990,  2015,  2580,
    2086,  2260,  -265,   404,  2261,   718,   719,  2023,   392,   472,
     392,   392,   392,  1620,   392,  2635,  2636,  2637,  3355,  1121,
    1131,  1132,  1150,   392,  1301,   392,   554,  3627,   555,  -339,
    1636,   753,   490,  3523,   405,  1335,  1336,  1900,   499,   950,
    1122,  3608,  1616,   500,   406,   537,  2661,  2662,  2663,  2959,
    1622,  1961,   503,  1901,   117,  1961,   118,   424,   505,   392,
    1531,  1534,  2960,  1961,   870,   437,   718,   719,  1346,   514,
     443,  3039,  1532,   538,  1337,   404,  3261,  2630,  3040,   418,
     951,   516,  3437,  1461,  3439,  1535,  2287,   539,  1338,  2985,
    2985,  2985,   524,  2288,   419,   952,  1389,  3183,   441,   392,
    2012,  1810,  2961,   117,   776,   118,  3041,   561,  1962,   540,
     623,   624,  3324,  3497,  1623,   532,  1381,  1811,  1998,  1529,
     420,   541,  1339,  3026,  1151,  1963,  3027,  1152,  1383,  3300,
     581,  1347,   718,   719,  1340,   421,   590,  2287,  1964,  1536,
    1153,  1142,  1143,  1480,  2675,  2826,   582,  1121,  1408,  2830,
     542,  1409,  1902,  1903,  1410,   787,   672,  3480,   392,  3481,
    3592,  1341,   578,   789,  1389,  2461,  1352,  1353,  1122,  1636,
    1354,  1355,   667,   392,  1862,   543,  1863,   592,  3042,  2263,
    2264,   544,  1962,  1462,   686,  1625,  1962,  2922,  1796,  1797,
    1904,  2841,  2842,   564,  1962,  2097,  2098,   697,  3631,  1963,
     804,  3208,  3209,  1963,   698,  1786,   106,  1910,  1911,  1912,
     707,  1963,  1964,  1965,   665,   666,  1964,   669,  1342,  3219,
     545,  1537,  2322,   921,  1964,  3223,   727,  3301,  3302,   392,
     931,  3303,  3304,  1533,   392,   946,   392,  2341,  3669,  3007,
     924,   392,  3010,  3011,   948,  1348,  1349,   392,  3239,   392,
     953,  3241,   955,  3680,   392,   392,   963,   392,  1786,  3028,
     964,  3043,  3693,   109,   816,  2129,  2130,  1154,   978,   392,
    1961,   979,   392,  2131,  2132,  2390,   933,   987,   392,   392,
     392,   392,  1859,  1859,  1786,  1859,   998,  1965,   392,   392,
     392,  1965,  2135,  2136,   999,   536,  3720,  1881,  3721,  1965,
     980,  2445,  2013,  1534,  1002,  1966,   392,  3166,   992,  1893,
    3712,  3170,  2142,  2143,  1006,   392,  1859,  1859,  1859,  3413,
    2425,  2426,   832,  1003,   718,   719,  2614,  1535,  2147,  2148,
    3403,  1009,   392,   546,   836,   837,  1864,   680,   681,  1017,
     682,  2448,   683,  1018,   392,  2862,  2150,  2151,  2152,  2153,
    1155,  1023,   547,  2164,  2165,  1865,   392,  1019,   548,  2168,
    2169,   934,   392,  2354,   549,  2358,  2363,  1636,  1024,   537,
    1967,  1033,  1953,  2181,  2182,  1866,  2185,  2186,  3006,  1966,
    2947,  1536,  2619,  1966,  1038,  2187,  2188,  1042,   550,  1867,
    1971,  1966,  2195,  2196,  2198,  2199,  2077,   538,  2207,  2208,
    1068,  1962,  2221,  2222,  2240,  2241,  1043,  2918,  2427,   551,
     552,   539,  3030,  3031,  1039,  2401,  2354,  1040,  1963,   935,
    3034,   392,  1069,  2626,  2242,  2243,  1041,  3057,  2291,  2292,
     392,  2701,  1082,   540,  1868,  1869,  1084,  3518,   623,   624,
    1828,  1829,  3507,   936,  1967,   541,   553,  1085,  1967,  1058,
   -1135,  1032,  3576,  1087,  2481,  2482,  1967,  1092,   392,  3443,
    2616,  2617,  1870,  1537,  1112,   965,  3533,  2656,  2657,  1032,
    2741,  2742,  2812,  2742,   542,  2869,  2870,  2873,  2874,  3090,
    1834,  1835,  1836,  1837,  1838,   392,  1786,  1113,   392,  2895,
    2896,  1159,   554,  1160,   555,  1161,   676,  1163,  3184,   543,
    1166,  3185,  1167,  2650,  -555,   544,  1965,  1540,  2919,  2920,
    2534,   868,  1165,  2088,  1541,  1830,  1832,   870,  2539,  1180,
     871,  1871,  1171, -1135,  1542,  1543,  3001,  1116,  1184,   937,
    3062,  3063,  3140,  3141,  1182, -1135,  1185,   938,   965,  3595,
    3263,  3264,  2354,  1332,   545,  3269,  3270,  2987,  2988,  2354,
    3111,  1772,  1773,  1401,  1544,  3613,  1391,  3613,  1545,  1388,
    3272,  3273,  1872,  3338,  3264,   939,  3418,  3419,  1186,  1546,
    3421,  3264,  3186,  3187,  3422,  3264,  1187,  1008,  1547,  3430,
    3431,  1351,  3432,  3433,  1548,  3434,  3433,  3455,  3456,  3520,
    3419,  2695,   966,  3521,  3419,  1188,  3613,  1549,  1966,  3660,
    3702,  3703,  3339,  3340,  2951,  2952,  1190,  3664, -1135,  2928,
    2929,   940,  1101,  3138,  3139,  1550, -1135,  2697,  1361, -1135,
    1398,  1035,  1191,  1192,  1551,  1552,  1193,  1194,  1195,  1196,
    1553,  1197,   941,  1198,  3613,  1405,  1199,  1200,  1554,  1201,
    1202,  1203, -1135,  1206,  1555,  3613,   392,  1208, -1135,   942,
    1209,   118,  1210,  2646,  2673,  1214,  1215,   546,  3613,   676,
    1216, -1135,  1217,  1967,  1483,   966, -1135,  1218,  1219,  1220,
    1556,  1221,  1222, -1135,  1223,  1224,   547,  1423,  1225,  1424,
    1226,  1227,   548, -1135,  1393,  3613,  3613,  1228,   549,  3735,
    1229,  2611, -1135,  1230,  1231,  1232, -1135,  1233,  1234,  2688,
   -1135,  1403,  1235,  1236,  1237,  1238,  1239,  1240,  1241, -1135,
    3125,  1242,   550,  1244,  1245, -1135,  1557,  1246,  1558,  1247,
    1427, -1135,  1248,  1249,  1250,  1559,  1251,  1252,  1253,  1257,
    1258,  1259,  1260,   551,   552,  1261,  1262,  1263,  1264, -1135,
    1265,  1266,  1267,  2731,  1268,  1270, -1135,   392,  1272,  1273,
    2734,  1274,  1275,  1276,  1277,  1278, -1135,  1279,  1280,  1281,
    1542,  1543,  1282,  1283,  1284,   392,   392,  1285,  1286, -1135,
     553, -1135,   392, -1135,   392,   392,  1436,  1287,  1438,  1288,
    1289,  1290, -1135,  1291,  1292,  1293,  1294,  1295,  1299,  1189,
    1300, -1135,  1303,  1560,  1545,  1402,  1304,  1308,  1309, -1135,
    1310,  1314,  1315,  1316,  1467,  1546,  1317,  1318,  1561,  1319,
    1390,  1406,   392,  1562,  1547,  1429,   554,  1435,   555,  1437,
    1444, -1135,   566,  1452,   392,   392,  1458,  1471,  1487,  1492,
    1493,  1494,  1495,  1549,   392,  1506,  1497,  1508,  2740,  1510,
     392,  1522,  1587,   392, -1135,  1588,   392,  1589,  1101,  1590,
    3164,  1550,  1591,  1563,  1592,  1593,  1594,   392,   392,  1564,
     392,  2354,  1565, -1135, -1135,  1595,   392,   392,  1596,  1597,
    1598,  1599, -1135,  1600,  1601,  1602,   392,  1603,   392,  1604,
    1555,  1605,   392,   392,  1606,  1566,  1567,  1609,  1568,  1611,
    1642,  1615,  1647, -1135, -1135,  1386,  1654,  1676,  1307,  1696,
    1710,  1727,  1569,  1759,  2455,  1783,  1792,  1803,  1798,  1817,
    1820,  1840,  1850,  1851,  1875,  1878,  1935,  1937,  1923,  1909,
    1944,  1947,   392,   392,  1570,  1969,  1970,  1973, -1135,  1974,
    1976,  1542,  1543,  1984,  1985,  1986, -1135,  1987,  1988,  1989,
    1990,  2008,  3073,  1786,  2007,  2010,  2011,  2018,  2019,  2024,
    2491,   392,  2016,  2038,  1558,  2087,  2089,  2093,   392,  2095,
    2096,  1559,  2100,  -460,  -460,  1545, -1135,  2106,  2139,  2102,
    2103,   392,  -460, -1135,  2113,  2104,  1546,  2105,  2107,  2110,
    2111,  2112,  2120,  2114,  2119,  1547, -1135, -1135,  3385,  2117,
    3390,  3391,  3392,  3393,  2121,  2253,  2122,  2123,  2124,  2125,
    2258, -1135,  2126, -1135,  1549, -1135,  2127,  2137,  2128,  2133,
    2134,  2138,  2140,  2141,  2144,  2173,  2145,   392,  1571,  1101,
    2146,  2149,  1550,  2154,  -800,  2155,  2158,  1572,  2159,  1560,
    2160, -1135, -1135,  2161,  2290,  2162,  2163,  2270, -1135,  2166,
    2295,  2167,  2170,  2171,  1561,  2172, -1135,  2307,  2303,  1349,
    2293,  1555,  2277,  2174,  1786,  2176,  2177,  2178,  2180,  2184,
   -1135,  2626,  1129,  1130,  1131,  1132,  1133,  1134,  2183,  2189,
    1135,  1136,  1137,  1138,  1139,  1140, -1135,  1141, -1135,  2190,
    2191,  3387,  2192,  2193,  2194,  2296,  -555,  2197,  2200,  2202,
    2297,  2203,  -555,  2204,  2205,  1564,  2206,  2209,  1565,  2210,
     392,  2211,  2212,  2956, -1135, -1135,  2213,  2308,  2309,  2214,
    2217, -1135,  2219,  2220,  2325,  2223,  2224,  2225,  2236,  2401,
    2234,  1566,  1567,  2237,  1568,  1558,  2238,  2239,  2244,  -977,
    2313,   392,  1559,  1116,  2326,   392,  2327,   392,   392,   392,
     392,  2294,  2305,  2328,  1916,  1915,  2345,  2346,   392,  2347,
    2370,  2371,   392,  2374,  2380,   392,  2378,  2379,  2396,  2403,
    1570,  2404,  2430,  2431,  2464,  2483,  2478,  1008,  2479,   392,
     392,   392,  2484,  1524,  1648,  2511,  1881,  2531,   808,  2544,
    2554,  2591,   392,  2593,  2595,  1142,  1143,  2566,   392,  2567,
     392,  2586,  2598,  2601,  2604,  2606,  2607,  2633,   392,  2608,
    1560,  2618,  2625,  2609,  2610,   393, -1031,  2638,  2640,  2644,
    2652,  2655,  2660,  2671,  1786,  1561,  2658,   423,  2672,  2677,
     429,  2685,  2696,  2702,  2706,  2707,  2710,   438,  2722,  2723,
    2736,  3686,  2802,  2805,  2809,  1786,  2811,   449,  2813,  2818,
    2816,  2831,  2832,  2821,  2824,  1542,  1543,   465,  2822,  2823,
    2827,  1786,  2833,  2834,  1571,  2839,  2835,  2836,  2837,   392,
    2838,  2843,  2844,  1572,  2845,  2288,  1564,  2846,  3686,  1565,
     392,  2847,  2848,   392,  2849,  2850,  2851,  -460,  -460,  1545,
    2852,  2934,  2853,  2854,  3163,   483,  -460,  1213,  1298,  1302,
    1546,  3623,  1566,  1567,  2936,  1568,  3275,  1900,  2855,  1547,
    2856,  2949,  2857,  2858,  2915,   486,   393,   392,   393,  2957,
    2913,  2969,  2972,  2975,   392,  2859,  2965,   392,  1549,   483,
    2860,   392,   392,  2863,  2864,   392,  2866,  3359,  2865,  2867,
    2868,  1570,  2871,  1101,  2872,   392,  1550,  2878,  2879,  2880,
    2881,  2976,  2882,  2883,  2884,  2744,  1363,  1364,  1365,  1366,
    1367,  2885,  3225,  2886,  2995,  2887,  2897,  2888,  2889,  2996,
    2890,  2892,  2898,  2810,  2899,  1555,  2900,  2901,  2903,  2905,
    2907,  2908,  1542,  1543,  2966,  2909,  2910,  3091,  2911,  2917,
    2921,  2994,  2924,  3369,  3370,  2925,  3714,  3153,  2938,  2970,
    3004,  2990,  3005,  3008,  3033,  3055,  3093,  3056,  3714,  3058,
    3061,  3081,  3095,  3354,  -460,  -460,  1545,  3096,  3097,  3100,
    3102,  3107,  3108,  -460,  3213,  3136,  3354,  1546,  3109,  1368,
    3117,  3118,  3119,  3714,  3120,  1571,  1547,  3124,  3143,  3147,
    2675,  3141,  3149,  3150,  1572,  3154,  3155,  3160,  3158,  1558,
    3161,  2341,  3165, -1065,  3176,  1549,  1559, -1070,  3174,  3180,
    2354,  1369,  1370,  1371,  1372,  3181,  3199,  3200,  3207,  3052,
    1101,  3435,  3049,  1550,  3218,  3220,  3222,  3229,  3230,  3231,
    2401,  3233,  3234,  3244,  2079,  3235,  3236,  3237,  3238,  3240,
    3249,  3253,  3250,  3266,   678,  3267,  3268,  3282,  3283,  3271,
    3274,  3295,  1555,  2500,  3276,  3296,  3297,  3277,  3308,  3317,
     392,   392,  3279,   392,  3291,  3323,  3278,  3280,  3360,  3332,
    3281,  3447,   392,  3284,  1560,  1008,  1619,  3326,   392,  3285,
    3286,  3287,  3328,  3288,  3289,  3361,  3290,  3293,   392,  1561,
    3320,  3374,  3321,  3382,  3350,  3351,   392,  3270,  3358,  3362,
    3363,  3383,  3364,  3389,  3365,  3395,  3396,  1373,  3376,  1374,
    1375,  1376,  3410,   392,  3412,  3415,  3377,  3379,  3417,  1377,
    3440,  3420,  3441,  3442,  3453,   392,  1558,  3454,  3375,  3457,
    3467,  3469,   392,  1559,  3470,  1620,  3471,  3458,  3459,   392,
    1564,  3472,  3478,  1565,  2474,   392,  3486,  3494,  2956,  3495,
    3502,   678,  3503,  3513,  3496,  3515,  3516,  3506,  2482,  3524,
    3522,  3545,  3543,  3554,   678,  -211,  1566,  1567,  3555,  1568,
    3573,  3578,  1622,  3579,   527,  3580,  3586, -1195,  3602,  3603,
    3604,  3614,  3621,  3625,   560,  1378,  3622,  3626,   568,  3492,
    3627,  3632,  3633,   483,  3636,  3637,  3639, -1803,   587,  3643,
    3653,  1560,  3665,  3661,  3668,  1570,  3672,  2354,  3671,  3666,
    3673,  3678,  3674,  3679,  3681,  3687,  1561,  3694,  3692,   392,
     483,  3699,  3708,  3697,  3698,  3511,  3512,  3710,  3514,  3717,
    3731,  3736,  1379,  1380,  3618,  2289,  1623,   687,  3378,  2070,
    3449,  3372,  3738,  3713,  3719,  3650,  3609,   483,  3651,  3617,
    3260,   483,   515,  1109,  3083,  3334,  2495,   709,  1608,   483,
     483,  1528,  3002,  2037,   721,   568,  2475,  1564,  1618,  3551,
    1565,  3552,  3553,  2041,   740,  3598,  2415,  1994,   745,  3059,
    2997,  3352,  3232,   922,   393,  3191,   393,   393,   568,   483,
    3224,  3020,  2963,  1566,  1567,  3021,  1568,  3485,  2998,  1571,
    3489,  3349,  3429,  2502,  1624,  1641,  3381,  1625,  1572,  3357,
    2465,  1958,  2310,  3444,  1607,  1892,  2643,   684,   392,  3598,
    1120,  2306,   970,  1509,  1013,  2329,  1097,  3397,  1914,  3294,
    3126,  1619,  1570,  3127,  2528,  2971,  3484,  1674,   483,  1726,
    1827,   392,  2623,  1822,  3331,  3645,   568,   483,  3319,  3000,
    2336,   483,  2302,  1422,  3500,  2316,   392,  2942,   483,  1381,
    3145,  2941,  1440,  2982,  3704,  2080,  3546,   673,  1646,  1177,
    1382,  1383,   746,   659,  1442,  2935,  1852,   678,  3597,  1949,
    3473,  3619,  3517,  3718,  3228,  2945,  2693,  1924,   568,  2967,
    1620,  3159,  1456,  3322,  1447,  1886,   603,   392,  1001,  3388,
    1627,  1415,  1628,  1629,  1630,  1631,  1632,  1633,  1634,  1635,
    2632,  1612,  3394,   678,   678,   605,   678,  1005,  3292,   392,
     699,  2490,  1794,  3080,  1621,  3258,  1571,  1622,  1172,     0,
       0,     0,     0,     0,     0,  1572,     0,     0,     0,   392,
       0,     0,     0,     0,     0,     0,     0,  1100,     0,     0,
       0,     0,     0,     0,     0,   568,     0,   678,   483,   678,
     678,  1119,   483,     0,   392,     0,   392,     0,     0,  3548,
       0,     0,     0,     0,     0,     0,   392,     0,     0,     0,
       0,     0,   392,     0,     0,     0,     0,     0,     0,  1636,
       0,  1623,     0,     0,     0,     0,     0,   483,     0,  1179,
       0,     0,  1540,     0,  3252,     0,     0,     0,     0,  1541,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1542,
    1543,     0,     0,     0,     0,     0,     0,  3500,     0,   392,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3542,     0,  2354,     0,     0,     0,     0,     0,     0,  1544,
       0,     0,     0,  1545,     0,     0,     0,   392,     0,  1624,
       0,     0,  1625,     0,  1546,     0,     0,  3542,  3542,     0,
       0,     0,     0,  1547,     0,     0,     0,   392,     0,  1548,
       0,     0,     0,   392,   392,     0,     0,     0,     0,     0,
       0,     0,  1549,     0,     0,     0,     0,   392,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1101,  3542,  3542,
    1550,     0,     0,  3542,     0,     0,   392,     0,  3728,  1551,
       0,     0,     0,     0,     0,  1553,     0,     0,     0,  3542,
       0,  3542,     0,  1554,     0,     0,     0,     0,     0,  1555,
       0,     0,     0,  3728,     0,     0,     0,  3542,  1329,  1626,
    1331,     0,     0,     0,   392,  1627,  3542,  1628,  1629,  1630,
    1631,  1632,  1633,  1634,  1635,  1556,     0,   392,     0,     0,
    3542,     0,     0,  3542,     0,     0,  3737,  3701,     0,     0,
       0,  3542,   483,     0,     0,     0,     0,  3542,   483,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3542,     0,     0,     0,     0,     0,  3542,     0,
       0,  3542,     0,  1558,     0,     0,     0,     0,     0,  3542,
    1559,     0,     0,     0,     0,  1416,     0,  1419,     0,   483,
       0,     0,  3542,     0,     0,     0,     0,     0,     0,     0,
       0,   483,   568,     0,  1636,  3542,     0,  3542,     0,     0,
       0,   483,   483,     0,     0,     0,     0,     0,     0,  3542,
    3542,     0,  1448,  3542,     0,     0,     0,     0,     0,     0,
    1457,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     392,     0,     0,     0,   393,   393,   483,   483,  1560,     0,
       0,     0,     0,     0,   393,     0,   568,     0,   392,   392,
       0,     0,   393,  1561,     0,     0,     0,     0,  1562,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   392,     0,
     392,     0,   392,   392,     0,   483,     0,  3463,     0,     0,
       0,     0,     0,     0,   392,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1563,     0,
       0,     0,     0,     0,  1564,     0,     0,  1565,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     392,   483,     0,     0,   483,     0,     0,     0,     0,     0,
    1566,  1567,     0,  1568,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1569,     0,     0,
       0,     0,     0,     0,  3540,     0,     0,     0,     0,   392,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1570,
       0,     0,     0,   568,     0,   568,   393,   393,   392,   483,
       0,  3540,  3540,   392,     0,     0,     0,     0,   745,     0,
    1649,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   392,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   392,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3540,  3540,  1683,     0,     0,  3540,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3540,     0,  3540,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3540,     0,  1571,  1683,     0,     0,     0,     0,     0,
    3540,     0,  1572,     0,     0,     0,     0,   392,     0,     0,
       0,     0,     0,     0,  3540,     0,   392,  3540,     0,     0,
       0,     0,     0,     0,     0,  3540,     0,     0,     0,     0,
       0,  3540,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3540,     0,     0,   392,
       0,   392,  3540,  1787,     0,  3540,     0,   392,     0,     0,
       0,     0,     0,  3540,     0,     0,   392,     0,   568,     0,
     392,     0,     0,     0,     0,     0,  3540,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   392,     0,     0,  3540,
       0,  3540,   392,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3540,  3540,     0,     0,  3540,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   392,     0,     0,
       0,     0,     0,     0,   568,     0,     0,     0,     0,  1845,
       0,   568,     0,     0,     0,     0,   568,     0,     0,     0,
       0,     0,   483,     0,  1855,     0,     0,     0,     0,  1860,
    1860,     0,  1860,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   483,     0,     0,   483,     0,     1,
       0,     0,     0,   568,   568,   483,   483,     0,     0,     2,
       3,     0,     0,  1860,  1860,  1860,     0,     0,     0,     0,
       0,     0,     4,     0,     5,     0,     0,     0,     0,     0,
       0,  1927,     0,     0,     0,     0,     0,     0,     0,     0,
    1938,     0,     0,     6,     7,     0,     0,     0,     0,     8,
       0,     0,     0,     9,    10,     0,     0,  1946,     0,     0,
       0,     0,     0,     0,     0,     0,    11,     0,     0,   483,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1960,     0,    12,     0,     0,     0,   483,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    13,     0,     0,     0,     0,     0,     0,     0,
       0,    14,    15,    16,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    17,    18,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2044,    19,     0,     0,
       0,     0,     0,     0,     0,  2048,     0,     0,     0,     0,
       0,     0,     0,     0,    20,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   393,     0,     0,     0,     0,    21,     0,
       0,     0,     0,     0,     0,    22,     0,     0,    23,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     483,     0,     0,  2091,     0,     0,     0,     0,     0,    24,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    25,     0,     0,     0,     2,
       3,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     4,    26,     0,     0,     0,     0,    27,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     6,     7,     0,     0,     0,     0,     8,
       0,     0,     0,     9,    10,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    11,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    12,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    13,     0,     0,     0,     0,     0,     0,     0,
       0,    14,    15,    16,    28,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    17,    18,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    29,     0,     0,     0,
       0,  2259,     0,     0,     0,    30,     0,    19,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    20,    31,     0,    32,    33,     0,
       0,    34,     0,     0,    35,     0,    36,     0,     0,     0,
       0,    37,     0,    38,     0,     0,     0,     0,    21,     0,
       0,     0,    39,     0,     0,    22,    40,     0,    23,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,     0,    42,     0,    24,
       0,    43,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    25,     0,     0,     0,     0,
       0,    44,  2323,     0,     0,    45,     0,     0,     0,     0,
       0,     0,     0,    26,     0,     0,     0,     0,    27,     0,
    2342,  2344,     0,     0,     0,     0,     0,   568,     0,   568,
     568,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
      48,     0,     0,     0,     0,    49,     0,  1787,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   568,
     568,     0,     0,     0,     0,     0,     0,     0,    50,  2044,
       0,     0,     0,     0,     0,  2044,     0,     0,  2044,     0,
       0,  2044,     0,     0,    28,     0,     0,     0,     0,    51,
       0,     0,  2044,  2044,     0,   568,     0,     0,     0,     0,
       0,  2044,  1787,     0,     0,     0,    29,     0,     0,     0,
       0,   483,     0,   568,     0,    30,     0,  2044,  2470,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    31,     0,    32,    33,     0,
       0,    34,     0,     0,    35,     0,    36,     0,     0,     0,
       0,    37,     0,    38,     0,     0,     0,   483,  2044,     0,
     893,     0,    39,     0,     0,     0,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,   568,    42,     0,     0,
       0,    43,     0,   568,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2535,     0,     0,     0,
       0,    44,     0,   972,     0,    45,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2745,  2746,     0,     0,     0,
       0,  2747,     0,  2748,     0,  2749,  2750,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2751,    46,  1683,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
      48,     0,     0,     0,     0,    49,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2752,     0,     0,  2753,     0,     0,     0,    50,     0,
       0,     0,  2754,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    51,
       0,  2755,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   568,     0,     0,  2756,     0,
       0,     0,     0,     0,  1128,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2757,
       0,  2758,     0,     0,     0,     0,  2631,     0,     0,     0,
    1855,     0,   970,   568,   568,   568,     0,     0,     0,     0,
    2759,  2760,     0,   483,     0,     0,     0,   568,     0,     0,
    1787,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   568,   568,   568,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2674,     0,     0,
       0,  2761,     0,  2676,     0,  2678,     0,     0,     0,     0,
       0,     0,     0,   568,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1243,     0,     0,     0,     0,
    2762,     0,     0,     0,     0,     0,     0,     0,     0,  2763,
    2764,     0,  2765,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2766,  2767,  2768,     0,  2044,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   568,     0,     0,  2044,     0,
       0,  2769,  2770,  2771,     0,     0,     0,  2772,     0,     0,
    2773,  1320,     0,     0,     0,  1327,     0,     0,     0,     0,
       0,     0,     0,  2774,  2775,     0,     0,     0,     0,     0,
       0,     0,   483,     0,     0,     0,     0,     0,     0,  2743,
       0,     0,   483,     0,     0,     0,  2799,  2800,     0,  2776,
    2803,  2777,     0,     0,     0,     0,     0,     0,     0,     0,
     483,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2778,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2779,     0,
    2780,     0,     0,     0,     0,     0,     0,     0,     0,  1455,
    2781,     0,     0,     0,     0,     0,     0,     0,  1470,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2782,  2783,     0,     0,  2784,  2785,
    2786,  2787,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2323,  2946,     0,   568,     0,
       0,  2788,  2789,     0,     0,     0,     0,   568,     0,     0,
       0,     0,     0,  2631,     0,     0,     0,     0,     0,     0,
    2790,     0,     0,   568,     0,     0,     0,     0,     0,     0,
       0,  1927,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1787,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2044,     0,     0,     0,     0,     0,     0,  2044,     0,     0,
       0,     0,     0,     0,  1787,     0,     0,     0,     0,     0,
    2044,  1651,  1652,  1653,     0,     0,     0,     0,     0,     0,
    1662,  1663,     0,     0,  1666,     0,  1668,  1669,  1670,  1671,
       0,     0,     0,  1675,     0,     0,  1677,  1678,     0,  1679,
       0,  1680,  1681,     0,  1684,  1685,  1686,  1687,  1688,     0,
    1691,     0,  1693,  1694,  1695,     0,  1697,  1698,  1699,  1700,
       0,  1702,  1703,     0,  1709,     0,     0,  1713,  1714,  1715,
       0,  1717,  1718,  1719,  1720,     0,  1722,  1723,  1724,  1725,
       0,     0,     0,     0,  3088,  1732,  1733,     0,  1736,  1737,
    1738,  1739,  1740,     0,     0,     0,     0,  1744,     0,  1745,
    1746,  1747,  1748,  1749,     0,     0,  1752,  1754,  1755,  1756,
    1757,  1758,     0,  1760,  1761,     0,     0,     0,  1765,  1766,
    1767,     0,  1770,     0,  1771,     0,     0,     0,  1774,     0,
    1778,  1779,     0,     0,     0,     0,  1782,     0,     0,     0,
       0,     0,     0,     0,  1789,  1790,  1791,     0,     0,     0,
       0,     0,     0,  1327,     0,     0,  1799,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   621,     0,   583,   622,     0,     0,
       0,     0,     0,  3123,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   623,
     624,     0,     0,     0,     0,     0,  1787,     0,     0,   625,
       0,   626,     0,     0,     0,  1843,     0,     0,     0,     0,
       0,   568,     0,     0,     0,     0,     0,     0,     0,   627,
       0,   628,     0,     0,     0,     0,     0,     0,     0,   629,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1888,
       0,     0,  3088,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   568,     0, -1379,   630,     0,     0,
       0,   631,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   568,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   632,     0,   633,     0,     0,     0,     0,     0,  3242,
       0,  3243,     0,     0,     0,   634,     0,   635,     0,     0,
       0,   483,     0,     0,     0,     0,     0,  3257,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     636,   637,     0,     0,   638,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   639,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2342,     0,     0,     0,     0,     0,
       0,     0,   640,     0,     0,     0,     0,   641,     0,     0,
       0,     0,     0,     0,     0,     0,  2049,     0,     0,     0,
       0,     0,   568,     0,     0,     0,     0,     0,     0,     0,
       0,   642,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3330,     0,     0,     0,     0,     0,  3088,  3088,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3348,     0,   643,     0,     0,     0,     0,     0,
       0,     0,     0,   644,     0,     0,     0,     0,     0,     0,
       0,   568,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   645,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   646,   647,  3373,
       0,   648,   649,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3088,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   650,     0,     0,     0,     0,   651,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   652,
       0,     0,  2227,  2229,  2231,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2245,
   -1828,     0,     0,     0,   653,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   654,
       0,     0,     0,     0,  2271,  3257,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1787,   483,     0,     0,  2283,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3330,     0,  3330,     0,  3482,  2048,     0,
       0,     0,     0, -1828,     0,     0,     0,   655,     0,  3490,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3510,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1787,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3556,     0,     0,     0,     0,  3563,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   568,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3581,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3647,     0,     0,     0,     0,     0,     0,     0,
       0,  3658,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2509,     0,     0,  2510,     0,     0,  2512,  2513,
       0,     0,     0,     0,  1787,     0,  3689,     0,     0,     0,
       0,  2526,  3695,     0,  2529,     0,     0,     0,     0,     0,
       0,   568,     0,     0,     0,  1787,     0,  2536,     0,  2537,
       0,     0,     0,  2540,     0,  2541,  2542,     0,     0,     0,
    2545,  1787,  2546,  2547,     0,  2548,     0,  3729,  2549,     0,
    2550,  2551,     0,     0,     0,     0,  2555,  2556,     0,     0,
    2558,     0,  2559,     0,  2560,     0,  2561,     0,  2563,     0,
       0,     0,  3729,     0,     0,     0,     0,     0,     0,  2568,
    2569,     0,     0,  2570,     0,  2571,     0,     0,     0,     0,
       0,     0,     0,  2572,  2573,     0,  2574,     0,  2575,     0,
       0,  2576,  2577,  2578,     0,  2579,     0,     0,     0,     0,
       0,  2582,  2583,  2584,  2585,     0,     0,     0,     0,  2587,
    2588,  2589,     0,  2590,     0,  2592,     0,  2594,     0,  2596,
       0,  2597,     0,     0,     0,     0,     0,     0,  2599,     0,
    2600,     0,     0,  2602,  2603,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2612,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2621,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2639,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2683,     0,     0,     0,     0,
    2687,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2718,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2721,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2820,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2891,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2902,     0,
    2904,     0,  2906,     0,     0,     0,     0,     0,  2912,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2923,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2968,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3094,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3098,     0,     0,     0,
       0,     0,  3099,     0,     0,     0,     0,     0,     0,     0,
       0,  3103,  3104,     0,     0,     0,     0,  3105,     0,     0,
       0,  3106,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3110,     0,     0,     0,     0,     0,
    3112,     0,     0,  3113,  3114,     0,  3115,  3116,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3121,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3172,  3173,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2718,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2718,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2683,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3384,     0,     0,     0,     0,     0,  3386,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3402,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3414,     0,  3416,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2718,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3505,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3519,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3584,  3585,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3605,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3616,     0,     0,     0,     0,  3620,     0,     0,     0,     0,
       0,     0,     0,     0,  3630,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   122,     0,   747,   124,   125,   126,
     127,     0,     0,     0,     0,  3662,   128,     0,     0,   748,
       0,   749,   130,   131,   750,   133,  3670,   134,   751,   135,
       0,   752,   136,   753,   754,   755,   137,   756,     0,   138,
     139,   140,  1775,   141,     0,   142,   143,     0,     0,   144,
     757,   145,     0,   146,   758,   759,   148,     0,   149,   150,
     151,   760,   152,     0,   761,   154,     0,   155,   156,   157,
     158,   159,   762,   763,   160,     0,   161,   162,     0,   764,
     164,     0,   765,   766,   767,   165,     0,  3730,   166,   768,
     769,     0,   770,   771,     0,   167,   168,   772,   773,   774,
       0,     0,     0,     0,   775,   171,   776,     0,     0,   777,
     778,   172,     0,   173,     0,     0,     0,   779,   780,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,   781,   182,     0,   782,   783,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,   784,     0,   191,   785,   192,   786,   787,   193,   194,
       0,   788,   195,   196,   197,   789,     0,   198,     0,     0,
     790,     0,   199,   200,     0,   791,   201,     0,   202,   792,
     793,   794,   795,     0,   796,   797,   204,   798,   799,   800,
     206,     0,   207,   801,     0,   802,   803,     0,   208,   209,
       0,   210,   804,     0,   211,     0,     0,     0,   805,   213,
     214,   215,   806,     0,   216,   217,     0,     0,     0,   218,
       0,     0,   807,   219,   808,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,   809,   226,     0,  1776,   810,   227,     0,   811,   228,
       0,     0,     0,   812,     0,   813,     0,   230,   814,     0,
     231,     0,   232,   815,     0,     0,   816,     0,     0,     0,
       0,   817,   233,   234,   235,   236,   237,   238,   818,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   819,   248,
     249,   250,   820,   251,   252,     0,     0,     0,   253,   254,
     255,   821,   257,     0,     0,   822,   259,   823,   824,   260,
       0,   261,   825,   826,   827,   828,   829,   830,   831,   266,
     267,   268,   269,     0,   832,   270,   271,     0,   272,   273,
     274,   833,   834,   835,   275,     0,   836,   837,     0,   276,
     277,     0,   838,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     839,   840,   286,   841,   842,   843,   844,   845,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   846,
     297,   298,   299,   300,   301,   302,   303,   847,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,   848,   849,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,   850,   318,   319,   851,   320,
     321,   852,   322,   853,   324,   325,     0,   854,   327,     0,
     328,   855,   329,   330,   331,     0,     0,     0,     0,   332,
       0,     0,   333,   334,   335,     0,     0,   336,     0,     0,
       0,   337,   338,   339,   340,     0,   341,   342,   343,     0,
       0,     0,     0,     0,     0,   344,   345,     0,   346,     0,
       0,   347,     0,     0,   348,   349,   856,   857,   350,   351,
       0,   352,   858,   354,   859,   860,   861,   355,   356,   357,
     358,   862,   359,   360,     0,   361,   362,     0,   676,   363,
     863,   864,   865,   866,     0,     0,     0,     0,  1777,   368,
       0,   369,   867,   868,   869,   371,   372,   373,     0,   870,
     374,   375,   871,     0,   376,     0,     0,   872,   873,   377,
       0,     0,   378,     0,   379,     0,   874,   381,     0,     0,
     875,   876,   877,   878,   879,   382,     0,     0,   383,   880,
       0,   384,   385,   881,     0,     0,     0,     0,   387,     0,
     388,   389,     0,   882,     0,   883,     0,     0,     0,     0,
     884,     0,     0,     0,   885,   886,     0,     0,     0,     0,
     887,     0,   888,     0,     0,   889,   890,     0,   891,   892,
     122,     0,   747,   124,   125,   126,   127,  2679,     0,     0,
       0,     0,   128,     0,     0,   748,     0,   749,   130,   131,
     750,   133,     0,   134,   751,   135,     0,  2680,   136,   753,
     754,   755,   137,   756,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,   757,   145,     0,   146,
     758,   759,   148,     0,   149,   150,   151,   760,   152,     0,
     761,   154,     0,   155,   156,   157,   158,   159,   762,   763,
     160,     0,   161,   162,     0,   764,   164,     0,   765,   766,
     767,   165,     0,     0,   166,   768,   769,     0,   770,   771,
       0,   167,   168,   772,   773,   774,     0,     0,     0,     0,
     775,   171,   776,     0,     0,   777,  2681,   172,     0,   173,
       0,     0,     0,   779,   780,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,   781,   182,     0,   782,   783,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,   784,     0,   191,
     785,   192,   786,   787,   193,   194,     0,   788,   195,   196,
     197,   789,     0,   198,     0,     0,   790,     0,   199,   200,
       0,   791,   201,     0,   202,   792,   793,   794,   795,     0,
     796,   797,   204,   798,   799,   800,   206,     0,   207,   801,
       0,   802,   803,     0,   208,   209,     0,   210,   804,     0,
     211,     0,     0,     0,   805,   213,   214,   215,   806,     0,
     216,   217,     0,     0,     0,   218,     0,     0,   807,   219,
     808,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   809,   226,     0,
       0,   810,   227,     0,   811,   228,     0,     0,     0,   812,
       0,   813,     0,   230,   814,     0,   231,     0,   232,   815,
       0,     0,   816,     0,     0,     0,     0,   817,   233,   234,
     235,   236,   237,   238,   818,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   819,   248,   249,   250,   820,   251,
     252,     0,     0,     0,   253,   254,   255,   821,   257,     0,
       0,   822,   259,   823,   824,   260,     0,   261,   825,   826,
     827,   828,   829,   830,   831,   266,   267,   268,   269,     0,
     832,   270,   271,     0,   272,   273,   274,   833,   834,   835,
     275,     0,   836,   837,     0,   276,   277,     0,   838,  2682,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   839,   840,   286,   841,
     842,   843,   844,   845,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   846,   297,   298,   299,   300,
     301,   302,   303,   847,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,   848,
     849,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,   850,   318,   319,   851,   320,   321,   852,   322,   853,
     324,   325,     0,   854,   327,     0,   328,   855,   329,   330,
     331,     0,     0,     0,     0,   332,     0,     0,   333,   334,
     335,     0,     0,   336,     0,     0,     0,   337,   338,   339,
     340,     0,   341,   342,   343,     0,     0,     0,     0,     0,
       0,   344,   345,     0,   346,     0,     0,   347,     0,     0,
     348,   349,   856,   857,   350,   351,     0,   352,   858,   354,
     859,   860,   861,   355,   356,   357,   358,   862,   359,   360,
       0,   361,   362,     0,   676,   363,   863,   864,   865,   866,
       0,     0,     0,     0,     0,   368,     0,   369,   867,   868,
     869,   371,   372,   373,     0,   870,   374,   375,   871,     0,
     376,     0,     0,   872,   873,   377,     0,     0,   378,     0,
     379,     0,   874,   381,     0,     0,   875,   876,   877,   878,
     879,   382,     0,     0,   383,   880,     0,   384,   385,   881,
       0,     0,     0,     0,   387,     0,   388,   389,     0,   882,
       0,   883,     0,     0,     0,     0,   884,     0,     0,     0,
     885,   886,     0,     0,     0,     0,   887,     0,   888,     0,
       0,   889,   890,     0,   891,   892,   122,     0,   747,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   748,     0,   749,   130,   131,   750,   133,     0,   134,
     751,   135,     0,   752,   136,   753,   754,   755,   137,   756,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   757,   145,     0,   146,   758,   759,   148,     0,
     149,   150,   151,   760,   152,     0,   761,   154,     0,   155,
     156,   157,   158,   159,   762,   763,   160,     0,   161,   162,
       0,   764,   164,     0,   765,   766,   767,   165,     0,     0,
     166,   768,   769,     0,   770,   771,     0,   167,   168,   772,
     773,   774,     0,     0,     0,     0,   775,   171,   776,     0,
       0,   777,   778,   172,     0,   173,     0,     0,     0,   779,
     780,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,   781,   182,     0,
     782,   783,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,   784,     0,   191,   785,   192,   786,   787,
     193,   194,     0,   788,   195,   196,   197,   789,     0,   198,
       0,     0,   790,     0,   199,   200,     0,   791,   201,     0,
     202,   792,   793,   794,   795,     0,   796,   797,   204,   798,
     799,   800,   206,     0,   207,   801,     0,   802,   803,     0,
     208,   209,     0,   210,   804,     0,   211,     0,     0,     0,
     805,   213,   214,   215,   806,     0,   216,   217,     0,     0,
       0,   218,     0,     0,   807,   219,   808,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   809,   226,     0,     0,   810,   227,     0,
     811,   228,     0,     0,     0,   812,     0,   813,     0,   230,
     814,     0,   231,     0,   232,   815,     0,     0,   816,     0,
       0,     0,     0,   817,   233,   234,   235,   236,   237,   238,
     818,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     819,   248,   249,   250,   820,   251,   252,     0,     0,     0,
     253,   254,   255,   821,   257,     0,     0,   822,   259,   823,
     824,   260,     0,   261,   825,   826,   827,   828,   829,   830,
     831,   266,   267,   268,   269,     0,   832,   270,   271,     0,
     272,   273,   274,   833,   834,   835,   275,     0,   836,   837,
       0,   276,   277,     0,   838,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   839,   840,   286,   841,   842,   843,   844,   845,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   846,   297,   298,   299,   300,   301,   302,   303,   847,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,   848,   849,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,   850,   318,   319,
     851,   320,   321,   852,   322,   853,   324,   325,     0,   854,
     327,  1325,   328,   855,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,   856,   857,
     350,   351,     0,   352,   858,   354,   859,   860,   861,   355,
     356,   357,   358,   862,   359,   360,     0,   361,   362,     0,
     676,   363,   863,   864,   865,   866,     0,     0,     0,     0,
       0,   368,     0,   369,   867,   868,   869,   371,   372,   373,
       0,   870,   374,   375,   871,     0,   376,     0,     0,   872,
     873,   377,     0,     0,   378,     0,   379,     0,   874,   381,
       0,     0,   875,   876,   877,   878,   879,   382,     0,     0,
     383,   880,     0,   384,   385,   881,     0,     0,     0,     0,
     387,     0,   388,   389,     0,   882,     0,   883,     0,     0,
       0,     0,   884,     0,     0,     0,   885,   886,     0,     0,
       0,     0,   887,     0,  1326,     0,     0,   889,   890,     0,
     891,   892,   122,     0,   747,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   748,     0,   749,
     130,   131,   750,   133,     0,   134,   751,   135,     0,   752,
     136,   753,   754,   755,   137,   756,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,   757,   145,
       0,   146,   758,   759,   148,     0,   149,   150,   151,   760,
     152,     0,   761,   154,     0,   155,   156,   157,   158,   159,
     762,   763,   160,     0,   161,   162,     0,   764,   164,     0,
     765,   766,   767,   165,     0,     0,   166,   768,   769,     0,
     770,   771,     0,   167,   168,   772,   773,   774,     0,     0,
       0,     0,   775,   171,   776,     0,     0,   777,   778,   172,
       0,   173,     0,     0,     0,   779,   780,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,   781,   182,     0,   782,   783,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,   784,
       0,   191,   785,   192,   786,   787,   193,   194,     0,   788,
     195,   196,   197,   789,     0,   198,     0,     0,   790,     0,
     199,   200,     0,   791,   201,     0,   202,   792,   793,   794,
     795,     0,   796,   797,   204,   798,   799,   800,   206,     0,
     207,   801,     0,   802,   803,     0,   208,   209,     0,   210,
     804,     0,   211,     0,     0,     0,   805,   213,   214,   215,
     806,     0,   216,   217,     0,     0,     0,   218,     0,     0,
     807,   219,   808,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   809,
     226,     0,     0,   810,   227,     0,   811,   228,     0,     0,
       0,   812,     0,   813,     0,   230,   814,     0,   231,     0,
     232,   815,     0,     0,   816,     0,     0,     0,     0,   817,
     233,   234,   235,   236,   237,   238,   818,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   819,   248,   249,   250,
     820,   251,   252,     0,     0,     0,   253,   254,   255,   821,
     257,     0,     0,   822,   259,   823,   824,   260,     0,   261,
     825,   826,   827,   828,   829,   830,   831,   266,   267,   268,
     269,     0,   832,   270,   271,     0,   272,   273,   274,   833,
     834,   835,   275,     0,   836,   837,     0,   276,   277,     0,
     838,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   839,   840,
     286,   841,   842,   843,   844,   845,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   846,   297,   298,
     299,   300,   301,   302,   303,   847,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,   848,   849,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,   850,   318,   319,   851,   320,   321,   852,
     322,   853,   324,   325,     0,   854,   327,     0,   328,   855,
     329,   330,   331,     0,     0,     0,     0,   332,     0,     0,
     333,   334,   335,     0,     0,   336,     0,     0,     0,   337,
     338,   339,   340,     0,   341,   342,   343,     0,     0,     0,
       0,     0,     0,   344,   345,     0,   346,     0,     0,   347,
       0,     0,   348,   349,   856,   857,   350,   351,     0,   352,
     858,   354,   859,   860,   861,   355,   356,   357,   358,   862,
     359,   360,     0,   361,   362,     0,   676,   363,   863,   864,
     865,   866,     0,     0,     0,     0,     0,   368,     0,   369,
     867,   868,   869,   371,   372,   373,     0,   870,   374,   375,
     871,     0,   376,     0,     0,   872,   873,   377,     0,     0,
     378,     0,   379,     0,   874,   381,     0,     0,   875,   876,
     877,   878,   879,   382,     0,     0,   383,   880,     0,   384,
     385,   881,     0,     0,     0,     0,   387,     0,   388,   389,
       0,   882,     0,   883,     0,     0,     0,     0,   884,     0,
       0,     0,   885,   886,     0,     0,     0,     0,   887,     0,
     888,  1609,     0,   889,   890,     0,   891,   892,   122,     0,
     747,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   748,     0,   749,   130,   131,   750,   133,
       0,   134,   751,   135,     0,   752,   136,   753,   754,   755,
     137,   756,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,   757,   145,     0,   146,   758,   759,
     148,     0,   149,   150,   151,   760,   152,     0,   761,   154,
       0,   155,   156,   157,   158,   159,   762,   763,   160,     0,
     161,   162,     0,   764,   164,     0,   765,   766,   767,   165,
       0,     0,   166,   768,   769,     0,   770,   771,     0,   167,
     168,   772,   773,   774,     0,     0,     0,     0,   775,   171,
     776,     0,     0,   777,   778,   172,     0,   173,     0,     0,
       0,   779,   780,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,   781,
     182,     0,   782,   783,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,   784,     0,   191,   785,   192,
     786,   787,   193,   194,     0,   788,   195,   196,   197,   789,
       0,   198,     0,     0,   790,     0,   199,   200,     0,   791,
     201,     0,   202,   792,   793,   794,   795,     0,   796,   797,
     204,   798,   799,   800,   206,     0,   207,   801,     0,   802,
     803,     0,   208,   209,     0,   210,   804,     0,   211,     0,
       0,     0,   805,   213,   214,   215,   806,     0,   216,   217,
       0,     0,     0,   218,     0,     0,   807,   219,   808,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,   809,   226,     0,     0,   810,
     227,     0,   811,   228,     0,     0,     0,   812,     0,   813,
       0,   230,   814,     0,   231,     0,   232,   815,     0,     0,
     816,     0,     0,     0,     0,   817,   233,   234,   235,   236,
     237,   238,   818,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   819,   248,   249,   250,   820,   251,   252,     0,
       0,     0,   253,   254,   255,   821,   257,     0,     0,   822,
     259,   823,   824,   260,     0,   261,   825,   826,   827,   828,
     829,   830,   831,   266,   267,   268,   269,     0,   832,   270,
     271,     0,   272,   273,   274,   833,   834,   835,   275,     0,
     836,   837,     0,   276,   277,     0,   838,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   839,   840,   286,   841,   842,   843,
     844,   845,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   846,   297,   298,   299,   300,   301,   302,
     303,   847,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,   848,   849,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,   850,
     318,   319,   851,   320,   321,   852,   322,   853,   324,   325,
       0,   854,   327,     0,   328,   855,   329,   330,   331,     0,
       0,     0,     0,   332,     0,     0,   333,   334,   335,     0,
       0,   336,     0,     0,     0,   337,   338,   339,   340,     0,
     341,   342,   343,     0,     0,     0,     0,     0,     0,   344,
     345,     0,   346,     0,     0,   347,     0,     0,   348,   349,
     856,   857,   350,   351,     0,   352,   858,   354,   859,   860,
     861,   355,   356,   357,   358,   862,   359,   360,     0,   361,
     362,     0,   676,   363,   863,   864,   865,   866,     0,     0,
       0,     0,     0,   368,     0,   369,   867,   868,   869,   371,
     372,   373,     0,   870,   374,   375,   871,     0,   376,     0,
       0,   872,   873,   377,     0,     0,   378,     0,   379,     0,
     874,   381,     0,     0,   875,   876,   877,   878,   879,   382,
       0,     0,   383,   880,     0,   384,   385,   881,     0,     0,
       0,     0,   387,     0,   388,   389,     0,   882,     0,   883,
       0,     0,     0,     0,   884,     0,     0,     0,   885,   886,
       0,     0,     0,     0,   887,     0,   888,  1716,     0,   889,
     890,     0,   891,   892,   122,     0,   747,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   748,
       0,   749,   130,   131,   750,   133,     0,   134,   751,   135,
       0,   752,   136,   753,   754,   755,   137,   756,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
     757,   145,     0,   146,   758,   759,   148,     0,   149,   150,
     151,   760,   152,     0,   761,   154,     0,   155,   156,   157,
     158,   159,   762,   763,   160,     0,   161,   162,     0,   764,
     164,     0,   765,   766,   767,   165,     0,     0,   166,   768,
     769,     0,   770,   771,     0,   167,   168,   772,   773,   774,
       0,     0,     0,     0,   775,   171,   776,     0,     0,   777,
     778,   172,     0,   173,     0,     0,     0,   779,   780,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,   781,   182,     0,   782,   783,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,   784,     0,   191,   785,   192,   786,   787,   193,   194,
       0,   788,   195,   196,   197,   789,     0,   198,     0,     0,
     790,     0,   199,   200,     0,   791,   201,     0,   202,   792,
     793,   794,   795,     0,   796,   797,   204,   798,   799,   800,
     206,     0,   207,   801,     0,   802,   803,     0,   208,   209,
       0,   210,   804,     0,   211,     0,     0,     0,   805,   213,
     214,   215,   806,     0,   216,   217,     0,     0,     0,   218,
       0,     0,   807,   219,   808,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,   809,   226,     0,     0,   810,   227,     0,   811,   228,
       0,     0,     0,   812,     0,   813,     0,   230,   814,     0,
     231,     0,   232,   815,     0,     0,   816,     0,     0,     0,
       0,   817,   233,   234,   235,   236,   237,   238,   818,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   819,   248,
     249,   250,   820,   251,   252,     0,     0,     0,   253,   254,
     255,   821,   257,     0,     0,   822,   259,   823,   824,   260,
       0,   261,   825,   826,   827,   828,   829,   830,   831,   266,
     267,   268,   269,     0,   832,   270,   271,     0,   272,   273,
     274,   833,   834,   835,   275,     0,   836,   837,     0,   276,
     277,     0,   838,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     839,   840,   286,   841,   842,   843,   844,   845,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   846,
     297,   298,   299,   300,   301,   302,   303,   847,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,   848,   849,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,   850,   318,   319,   851,   320,
     321,   852,   322,   853,   324,   325,     0,   854,   327,     0,
     328,   855,   329,   330,   331,     0,     0,     0,     0,   332,
       0,     0,   333,   334,   335,     0,     0,   336,     0,     0,
       0,   337,   338,   339,   340,     0,   341,   342,   343,     0,
       0,     0,     0,     0,     0,   344,   345,     0,   346,     0,
       0,   347,     0,     0,   348,   349,   856,   857,   350,   351,
       0,   352,   858,   354,   859,   860,   861,   355,   356,   357,
     358,   862,   359,   360,     0,   361,   362,     0,   676,   363,
     863,   864,   865,   866,     0,     0,     0,     0,     0,   368,
       0,   369,   867,   868,   869,   371,   372,   373,     0,   870,
     374,   375,   871,     0,   376,     0,     0,   872,   873,   377,
       0,     0,   378,     0,   379,     0,   874,   381,     0,     0,
     875,   876,   877,   878,   879,   382,     0,     0,   383,   880,
       0,   384,   385,   881,     0,     0,     0,     0,   387,     0,
     388,   389,     0,   882,     0,   883,     0,     0,     0,     0,
     884,     0,     0,     0,   885,   886,     0,     0,     0,     0,
     887,     0,   888,  1753,     0,   889,   890,     0,   891,   892,
     122,     0,   747,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   748,     0,   749,   130,   131,
     750,   133,     0,   134,   751,   135,     0,   752,   136,   753,
     754,   755,   137,   756,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,   757,   145,     0,   146,
     758,   759,   148,     0,   149,   150,   151,   760,   152,     0,
     761,   154,     0,   155,   156,   157,   158,   159,   762,   763,
     160,     0,   161,   162,     0,   764,   164,     0,   765,   766,
     767,   165,     0,     0,   166,   768,   769,     0,   770,   771,
       0,   167,   168,   772,   773,   774,     0,     0,     0,     0,
     775,   171,   776,     0,     0,   777,   778,   172,     0,   173,
       0,     0,     0,   779,   780,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,   781,   182,     0,   782,   783,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,   784,     0,   191,
     785,   192,   786,   787,   193,   194,     0,   788,   195,   196,
     197,   789,     0,   198,     0,     0,   790,     0,   199,   200,
       0,   791,   201,     0,   202,   792,   793,   794,   795,     0,
     796,   797,   204,   798,   799,   800,   206,     0,   207,   801,
       0,   802,   803,     0,   208,   209,     0,   210,   804,     0,
     211,     0,     0,     0,   805,   213,   214,   215,   806,     0,
     216,   217,     0,     0,     0,   218,     0,     0,   807,   219,
     808,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   809,   226,     0,
       0,   810,   227,     0,   811,   228,     0,     0,     0,   812,
       0,   813,     0,   230,   814,     0,   231,     0,   232,   815,
       0,     0,   816,     0,     0,     0,     0,   817,   233,   234,
     235,   236,   237,   238,   818,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   819,   248,   249,   250,   820,   251,
     252,     0,     0,     0,   253,   254,   255,   821,   257,     0,
       0,   822,   259,   823,   824,   260,     0,   261,   825,   826,
     827,   828,   829,   830,   831,   266,   267,   268,   269,     0,
     832,   270,   271,     0,   272,   273,   274,   833,   834,   835,
     275,     0,   836,   837,     0,   276,   277,     0,   838,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   839,   840,   286,   841,
     842,   843,   844,   845,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   846,   297,   298,   299,   300,
     301,   302,   303,   847,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,   848,
     849,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,   850,   318,   319,   851,   320,   321,   852,   322,   853,
     324,   325,     0,   854,   327,     0,   328,   855,   329,   330,
     331,     0,     0,     0,     0,   332,     0,     0,   333,   334,
     335,     0,     0,   336,     0,     0,     0,   337,   338,   339,
     340,     0,   341,   342,   343,     0,     0,     0,     0,     0,
       0,   344,   345,     0,   346,     0,     0,   347,     0,     0,
     348,   349,   856,   857,   350,   351,     0,   352,   858,   354,
     859,   860,   861,   355,   356,   357,   358,   862,   359,   360,
       0,   361,   362,     0,   676,   363,   863,   864,   865,   866,
       0,     0,     0,     0,     0,   368,     0,   369,   867,   868,
     869,   371,   372,   373,     0,   870,   374,   375,   871,     0,
     376,     0,     0,   872,   873,   377,     0,     0,   378,     0,
     379,     0,   874,   381,     0,     0,   875,   876,   877,   878,
     879,   382,     0,     0,   383,   880,     0,   384,   385,   881,
       0,     0,     0,     0,   387,     0,   388,   389,     0,   882,
       0,   883,     0,     0,     0,     0,   884,     0,     0,     0,
     885,   886,     0,     0,     0,     0,   887,     0,   888,  1781,
       0,   889,   890,     0,   891,   892,   122,     0,   747,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   748,     0,   749,   130,   131,   750,   133,     0,   134,
     751,   135,     0,   752,   136,   753,   754,   755,   137,   756,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   757,   145,     0,   146,   758,   759,   148,     0,
     149,   150,   151,   760,   152,     0,   761,   154,     0,   155,
     156,   157,   158,   159,   762,   763,   160,     0,   161,   162,
       0,   764,   164,     0,   765,   766,   767,   165,     0,     0,
     166,   768,   769,     0,   770,   771,     0,   167,   168,   772,
     773,   774,     0,     0,     0,     0,   775,   171,   776,     0,
       0,   777,   778,   172,     0,   173,     0,     0,     0,   779,
     780,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,   781,   182,     0,
     782,   783,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,   784,     0,   191,   785,   192,   786,   787,
     193,   194,     0,   788,   195,   196,   197,   789,     0,   198,
       0,     0,   790,     0,   199,   200,  2226,   791,   201,     0,
     202,   792,   793,   794,   795,     0,   796,   797,   204,   798,
     799,   800,   206,     0,   207,   801,     0,   802,   803,     0,
     208,   209,     0,   210,   804,     0,   211,     0,     0,     0,
     805,   213,   214,   215,   806,     0,   216,   217,     0,     0,
       0,   218,     0,     0,   807,   219,   808,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   809,   226,     0,     0,   810,   227,     0,
     811,   228,     0,     0,     0,   812,     0,   813,     0,   230,
     814,     0,   231,     0,   232,   815,     0,     0,   816,     0,
       0,     0,     0,   817,   233,   234,   235,   236,   237,   238,
     818,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     819,   248,   249,   250,   820,   251,   252,     0,     0,     0,
     253,   254,   255,   821,   257,     0,     0,   822,   259,   823,
     824,   260,     0,   261,   825,   826,   827,   828,   829,   830,
     831,   266,   267,   268,   269,     0,   832,   270,   271,     0,
     272,   273,   274,   833,   834,   835,   275,     0,   836,   837,
       0,   276,   277,     0,   838,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   839,   840,   286,   841,   842,   843,   844,   845,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   846,   297,   298,   299,   300,   301,   302,   303,   847,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,   848,   849,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,   850,   318,   319,
     851,   320,   321,   852,   322,   853,   324,   325,     0,   854,
     327,     0,   328,   855,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,   856,   857,
     350,   351,     0,   352,   858,   354,   859,   860,   861,   355,
     356,   357,   358,   862,   359,   360,     0,   361,   362,     0,
     676,   363,   863,   864,   865,   866,     0,     0,     0,     0,
       0,   368,     0,   369,   867,   868,   869,   371,   372,   373,
       0,   870,   374,   375,   871,     0,   376,     0,     0,   872,
     873,   377,     0,     0,   378,     0,   379,     0,   874,   381,
       0,     0,   875,   876,   877,   878,   879,   382,     0,     0,
     383,   880,     0,   384,   385,   881,     0,     0,     0,     0,
     387,     0,   388,   389,     0,   882,     0,   883,     0,     0,
       0,     0,   884,     0,     0,     0,   885,   886,     0,     0,
       0,     0,   887,     0,   888,     0,     0,   889,   890,     0,
     891,   892,   122,     0,   747,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   748,     0,   749,
     130,   131,   750,   133,     0,   134,   751,   135,     0,   752,
     136,   753,   754,   755,   137,   756,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,   757,   145,
       0,   146,   758,   759,   148,     0,   149,   150,   151,   760,
     152,     0,   761,   154,     0,   155,   156,   157,   158,   159,
     762,   763,   160,     0,   161,   162,     0,   764,   164,     0,
     765,   766,   767,   165,     0,     0,   166,   768,   769,     0,
     770,   771,     0,   167,   168,   772,   773,   774,     0,     0,
       0,     0,   775,   171,   776,     0,     0,   777,   778,   172,
       0,   173,     0,     0,     0,   779,   780,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,   781,   182,     0,   782,   783,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,   784,
       0,   191,   785,   192,   786,   787,   193,   194,     0,   788,
     195,   196,   197,   789,     0,   198,     0,     0,   790,     0,
     199,   200,  2228,   791,   201,     0,   202,   792,   793,   794,
     795,     0,   796,   797,   204,   798,   799,   800,   206,     0,
     207,   801,     0,   802,   803,     0,   208,   209,     0,   210,
     804,     0,   211,     0,     0,     0,   805,   213,   214,   215,
     806,     0,   216,   217,     0,     0,     0,   218,     0,     0,
     807,   219,   808,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   809,
     226,     0,     0,   810,   227,     0,   811,   228,     0,     0,
       0,   812,     0,   813,     0,   230,   814,     0,   231,     0,
     232,   815,     0,     0,   816,     0,     0,     0,     0,   817,
     233,   234,   235,   236,   237,   238,   818,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   819,   248,   249,   250,
     820,   251,   252,     0,     0,     0,   253,   254,   255,   821,
     257,     0,     0,   822,   259,   823,   824,   260,     0,   261,
     825,   826,   827,   828,   829,   830,   831,   266,   267,   268,
     269,     0,   832,   270,   271,     0,   272,   273,   274,   833,
     834,   835,   275,     0,   836,   837,     0,   276,   277,     0,
     838,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   839,   840,
     286,   841,   842,   843,   844,   845,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   846,   297,   298,
     299,   300,   301,   302,   303,   847,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,   848,   849,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,   850,   318,   319,   851,   320,   321,   852,
     322,   853,   324,   325,     0,   854,   327,     0,   328,   855,
     329,   330,   331,     0,     0,     0,     0,   332,     0,     0,
     333,   334,   335,     0,     0,   336,     0,     0,     0,   337,
     338,   339,   340,     0,   341,   342,   343,     0,     0,     0,
       0,     0,     0,   344,   345,     0,   346,     0,     0,   347,
       0,     0,   348,   349,   856,   857,   350,   351,     0,   352,
     858,   354,   859,   860,   861,   355,   356,   357,   358,   862,
     359,   360,     0,   361,   362,     0,   676,   363,   863,   864,
     865,   866,     0,     0,     0,     0,     0,   368,     0,   369,
     867,   868,   869,   371,   372,   373,     0,   870,   374,   375,
     871,     0,   376,     0,     0,   872,   873,   377,     0,     0,
     378,     0,   379,     0,   874,   381,     0,     0,   875,   876,
     877,   878,   879,   382,     0,     0,   383,   880,     0,   384,
     385,   881,     0,     0,     0,     0,   387,     0,   388,   389,
       0,   882,     0,   883,     0,     0,     0,     0,   884,     0,
       0,     0,   885,   886,     0,     0,     0,     0,   887,     0,
     888,     0,     0,   889,   890,     0,   891,   892,   122,     0,
     747,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   748,     0,   749,   130,   131,   750,   133,
       0,   134,   751,   135,     0,   752,   136,   753,   754,   755,
     137,   756,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,   757,   145,     0,   146,   758,   759,
     148,     0,   149,   150,   151,   760,   152,     0,   761,   154,
       0,   155,   156,   157,   158,   159,   762,   763,   160,     0,
     161,   162,     0,   764,   164,     0,   765,   766,   767,   165,
       0,     0,   166,   768,   769,     0,   770,   771,     0,   167,
     168,   772,   773,   774,     0,     0,     0,     0,   775,   171,
     776,     0,     0,   777,   778,   172,     0,   173,     0,     0,
       0,   779,   780,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,   781,
     182,     0,   782,   783,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,   784,     0,   191,   785,   192,
     786,   787,   193,   194,     0,   788,   195,   196,   197,   789,
       0,   198,     0,     0,   790,     0,   199,   200,  2230,   791,
     201,     0,   202,   792,   793,   794,   795,     0,   796,   797,
     204,   798,   799,   800,   206,     0,   207,   801,     0,   802,
     803,     0,   208,   209,     0,   210,   804,     0,   211,     0,
       0,     0,   805,   213,   214,   215,   806,     0,   216,   217,
       0,     0,     0,   218,     0,     0,   807,   219,   808,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,   809,   226,     0,     0,   810,
     227,     0,   811,   228,     0,     0,     0,   812,     0,   813,
       0,   230,   814,     0,   231,     0,   232,   815,     0,     0,
     816,     0,     0,     0,     0,   817,   233,   234,   235,   236,
     237,   238,   818,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   819,   248,   249,   250,   820,   251,   252,     0,
       0,     0,   253,   254,   255,   821,   257,     0,     0,   822,
     259,   823,   824,   260,     0,   261,   825,   826,   827,   828,
     829,   830,   831,   266,   267,   268,   269,     0,   832,   270,
     271,     0,   272,   273,   274,   833,   834,   835,   275,     0,
     836,   837,     0,   276,   277,     0,   838,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   839,   840,   286,   841,   842,   843,
     844,   845,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   846,   297,   298,   299,   300,   301,   302,
     303,   847,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,   848,   849,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,   850,
     318,   319,   851,   320,   321,   852,   322,   853,   324,   325,
       0,   854,   327,     0,   328,   855,   329,   330,   331,     0,
       0,     0,     0,   332,     0,     0,   333,   334,   335,     0,
       0,   336,     0,     0,     0,   337,   338,   339,   340,     0,
     341,   342,   343,     0,     0,     0,     0,     0,     0,   344,
     345,     0,   346,     0,     0,   347,     0,     0,   348,   349,
     856,   857,   350,   351,     0,   352,   858,   354,   859,   860,
     861,   355,   356,   357,   358,   862,   359,   360,     0,   361,
     362,     0,   676,   363,   863,   864,   865,   866,     0,     0,
       0,     0,     0,   368,     0,   369,   867,   868,   869,   371,
     372,   373,     0,   870,   374,   375,   871,     0,   376,     0,
       0,   872,   873,   377,     0,     0,   378,     0,   379,     0,
     874,   381,     0,     0,   875,   876,   877,   878,   879,   382,
       0,     0,   383,   880,     0,   384,   385,   881,     0,     0,
       0,     0,   387,     0,   388,   389,     0,   882,     0,   883,
       0,     0,     0,     0,   884,     0,     0,     0,   885,   886,
       0,     0,     0,     0,   887,     0,   888,     0,     0,   889,
     890,     0,   891,   892,   122,     0,   747,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   748,
       0,   749,   130,   131,   750,   133,     0,   134,   751,   135,
       0,   752,   136,   753,   754,   755,   137,   756,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
     757,   145,     0,   146,   758,   759,   148,     0,   149,   150,
     151,   760,   152,     0,   761,   154,     0,   155,   156,   157,
     158,   159,   762,   763,   160,     0,   161,   162,     0,   764,
     164,     0,   765,   766,   767,   165,     0,     0,   166,   768,
     769,     0,   770,   771,     0,   167,   168,   772,   773,   774,
       0,     0,     0,     0,   775,   171,   776,     0,     0,   777,
     778,   172,     0,   173,     0,     0,     0,   779,   780,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,   781,   182,     0,   782,   783,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,   784,     0,   191,   785,   192,   786,   787,   193,   194,
       0,   788,   195,   196,   197,   789,     0,   198,     0,     0,
     790,     0,   199,   200,     0,   791,   201,     0,   202,   792,
     793,   794,   795,     0,   796,   797,   204,   798,   799,   800,
     206,     0,   207,   801,     0,   802,   803,     0,   208,   209,
       0,   210,   804,     0,   211,     0,     0,     0,   805,   213,
     214,   215,   806,     0,   216,   217,     0,     0,     0,   218,
       0,     0,   807,   219,   808,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,   809,   226,     0,     0,   810,   227,     0,   811,   228,
       0,     0,     0,   812,     0,   813,     0,   230,   814,     0,
     231,     0,   232,   815,     0,     0,   816,     0,     0,     0,
       0,   817,   233,   234,   235,   236,   237,   238,   818,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   819,   248,
     249,   250,   820,   251,   252,     0,     0,     0,   253,   254,
     255,   821,   257,     0,     0,   822,   259,   823,   824,   260,
       0,   261,   825,   826,   827,   828,   829,   830,   831,   266,
     267,   268,   269,     0,   832,   270,   271,     0,   272,   273,
     274,   833,   834,   835,   275,     0,   836,   837,     0,   276,
     277,     0,   838,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     839,   840,   286,   841,   842,   843,   844,   845,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   846,
     297,   298,   299,   300,   301,   302,   303,   847,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,   848,   849,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,   850,   318,   319,   851,   320,
     321,   852,   322,   853,   324,   325,     0,   854,   327,     0,
     328,   855,   329,   330,   331,     0,     0,     0,     0,   332,
       0,     0,   333,   334,   335,     0,     0,   336,     0,     0,
       0,   337,   338,   339,   340,     0,   341,   342,   343,     0,
       0,     0,     0,     0,     0,   344,   345,     0,   346,     0,
       0,   347,     0,     0,   348,   349,   856,   857,   350,   351,
       0,   352,   858,   354,   859,   860,   861,   355,   356,   357,
     358,   862,   359,   360,     0,   361,   362,     0,   676,   363,
     863,   864,   865,   866,     0,     0,     0,     0,     0,   368,
       0,   369,   867,   868,   869,   371,   372,   373,     0,   870,
     374,   375,   871,     0,   376,     0,     0,   872,   873,   377,
       0,     0,   378,     0,   379,     0,   874,   381,     0,     0,
     875,   876,   877,   878,   879,   382,     0,     0,   383,   880,
       0,   384,   385,   881,     0,     0,     0,     0,   387,     0,
     388,   389,     0,   882,     0,   883,     0,     0,     0,     0,
     884,     0,     0,     0,   885,   886,     0,     0,     0,     0,
     887,     0,   888,     0,     0,   889,   890,     0,   891,   892,
     122,     0,   747,   124,   125,   126,   127,  1813,     0,     0,
       0,     0,  1814,     0,     0,   748,     0,   749,   130,   131,
     750,   133,     0,   134,   751,   135,     0,   752,   136,   753,
     754,   755,   137,   756,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,   757,   145,     0,   146,
     758,   759,   148,     0,   149,   150,   151,   760,   152,     0,
     761,   154,     0,   155,   156,   157,   158,   159,   762,   763,
     160,     0,   161,   162,     0,   764,   164,     0,   765,   766,
     767,   165,     0,     0,   166,   768,   769,     0,   770,   771,
       0,   167,   168,   772,   773,   774,     0,     0,     0,     0,
     775,   171,   776,     0,     0,   777,   778,   172,     0,   173,
       0,     0,     0,   779,   780,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,   781,   182,     0,   782,   783,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,   784,     0,   191,
     785,   192,   786,   787,   193,   194,     0,   788,   195,   196,
     197,   789,     0,   198,     0,     0,   790,     0,   199,   200,
       0,   791,   201,     0,   202,   792,   793,   794,   795,     0,
     796,   797,   204,   798,   799,   800,   206,     0,   207,   801,
       0,   802,   803,     0,   208,   209,     0,   210,   804,     0,
     211,     0,     0,     0,   805,   213,   214,   215,   806,     0,
     216,   217,     0,     0,     0,   218,     0,     0,   807,   219,
     808,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   809,   226,     0,
       0,   810,   227,     0,   811,   228,     0,     0,     0,   812,
       0,   813,     0,   230,   814,     0,   231,     0,   232,   815,
       0,     0,   816,     0,     0,     0,     0,   817,   233,   234,
     235,   236,   237,   238,   818,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   819,   248,   249,   250,   820,   251,
     252,     0,     0,     0,   253,   254,   255,   821,   257,     0,
       0,   822,   259,   823,   824,   260,     0,   261,   825,   826,
     827,   828,   829,   830,   831,   266,   267,   268,   269,     0,
     832,   270,   271,     0,   272,   273,   274,   833,     0,   835,
     275,     0,   836,   837,     0,   276,   277,     0,   838,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   839,   840,   286,   841,
     842,   843,   844,   845,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   846,   297,   298,   299,   300,
     301,   302,   303,   847,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,   848,
     849,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,   850,   318,   319,   851,   320,   321,   852,   322,   853,
     324,   325,     0,   854,   327,     0,   328,   855,   329,   330,
     331,     0,     0,     0,     0,   332,     0,     0,   333,   334,
     335,     0,     0,   336,     0,     0,     0,   337,   338,   339,
     340,     0,   341,   342,   343,     0,     0,     0,     0,     0,
       0,   344,   345,     0,   346,     0,     0,   347,     0,     0,
     348,   349,   856,   857,   350,   351,     0,   352,   858,   354,
     859,   860,   861,   355,   356,   357,   358,   862,   359,   360,
       0,   361,   362,     0,   676,   363,   863,   864,   865,   866,
       0,     0,     0,     0,     0,   368,     0,   369,   867,   868,
     869,   371,   372,   373,     0,   870,   374,   375,   871,     0,
     376,     0,     0,   872,   873,   377,     0,     0,   378,     0,
     379,     0,   874,   381,     0,     0,   875,   876,   877,   878,
     879,   382,     0,     0,   383,   880,     0,   384,   385,   881,
       0,     0,     0,     0,   387,     0,   388,   389,     0,   882,
       0,   883,     0,     0,     0,     0,   884,     0,     0,     0,
     885,   886,     0,     0,     0,     0,   887,     0,   888,     0,
       0,   889,   890,     0,   891,   892,   122,     0,   747,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   748,     0,   749,   130,   131,   750,   133,     0,   134,
     751,   135,     0,   752,   136,   753,   754,   755,   137,   756,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   757,   145,     0,   146,   758,   759,   148,     0,
     149,   150,   151,   760,   152,     0,   761,   154,     0,   155,
     156,   157,   158,   159,   762,   763,   160,     0,   161,   162,
       0,   764,   164,     0,   765,   766,   767,   165,     0,     0,
     166,   768,   769,     0,   770,   771,     0,   167,   168,   772,
     773,   774,     0,     0,     0,     0,   775,   171,   776,     0,
       0,   777,   778,   172,     0,   173,     0,     0,     0,   779,
     780,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,   781,   182,     0,
     782,   783,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,   784,     0,   191,   785,   192,   786,   787,
     193,   194,     0,   788,   195,   196,   197,   789,     0,   198,
       0,     0,   790,     0,   199,   200,     0,   791,   201,     0,
     202,   792,   793,   794,   795,     0,   796,   797,   204,   798,
     799,   800,   206,     0,   207,   801,     0,   802,   803,     0,
     208,   209,     0,   210,   804,     0,   211,     0,     0,     0,
     805,   213,   214,   215,   806,     0,   216,   217,     0,     0,
       0,   218,     0,     0,   807,   219,  2508,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   809,   226,     0,     0,   810,   227,     0,
     811,   228,     0,     0,     0,   812,     0,   813,     0,   230,
     814,     0,   231,     0,   232,   815,     0,     0,   816,     0,
       0,     0,     0,   817,   233,   234,   235,   236,   237,   238,
     818,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     819,   248,   249,   250,   820,   251,   252,     0,     0,     0,
     253,   254,   255,   821,   257,     0,     0,   822,   259,   823,
     824,   260,     0,   261,   825,   826,   827,   828,   829,   830,
     831,   266,   267,   268,   269,     0,   832,   270,   271,     0,
     272,   273,   274,   833,   834,   835,   275,     0,   836,   837,
       0,   276,   277,     0,   838,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   839,   840,   286,   841,   842,   843,   844,   845,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   846,   297,   298,   299,   300,   301,   302,   303,   847,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,   848,   849,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,   850,   318,   319,
     851,   320,   321,   852,   322,   853,   324,   325,     0,   854,
     327,     0,   328,   855,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,   856,   857,
     350,   351,     0,   352,   858,   354,   859,   860,   861,   355,
     356,   357,   358,   862,   359,   360,     0,   361,   362,     0,
     676,   363,   863,   864,   865,   866,     0,     0,     0,     0,
       0,   368,     0,   369,   867,   868,   869,   371,   372,   373,
       0,   870,   374,   375,   871,     0,   376,     0,     0,   872,
     873,   377,     0,     0,   378,     0,   379,     0,   874,   381,
       0,     0,   875,   876,   877,   878,   879,   382,     0,     0,
     383,   880,     0,   384,   385,   881,     0,     0,     0,     0,
     387,     0,   388,   389,     0,   882,     0,   883,     0,     0,
       0,     0,   884,     0,     0,     0,   885,   886,     0,     0,
       0,     0,   887,     0,   888,     0,     0,   889,   890,     0,
     891,   892,   122,     0,   747,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   748,     0,   749,
     130,   131,   750,   133,     0,   134,   751,   135,     0,   752,
     136,   753,   754,   755,   137,   756,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,   757,   145,
       0,   146,   758,   759,   148,     0,   149,   150,   151,   760,
     152,     0,   761,   154,     0,   155,   156,   157,   158,   159,
     762,   763,   160,     0,   161,   162,     0,   764,   164,     0,
     765,   766,   767,   165,     0,     0,   166,   768,   769,     0,
     770,   771,     0,   167,   168,   772,   773,   774,     0,     0,
       0,     0,   775,   171,   776,     0,     0,   777,   778,   172,
       0,   173,     0,     0,     0,   779,   780,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,   781,   182,     0,   782,   783,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,   784,
       0,   191,   785,   192,   786,   787,   193,   194,     0,   788,
     195,   196,   197,   789,     0,   198,     0,     0,   790,     0,
     199,   200,     0,   791,   201,     0,   202,   792,   793,   794,
     795,     0,   796,   797,   204,   798,   799,   800,   206,     0,
     207,   801,     0,   802,   803,     0,   208,   209,     0,   210,
     804,     0,   211,     0,     0,     0,   805,   213,   214,   215,
     806,     0,   216,   217,     0,     0,     0,   218,     0,     0,
     807,   219,  2581,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   809,
     226,     0,     0,   810,   227,     0,   811,   228,     0,     0,
       0,   812,     0,   813,     0,   230,   814,     0,   231,     0,
     232,   815,     0,     0,   816,     0,     0,     0,     0,   817,
     233,   234,   235,   236,   237,   238,   818,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   819,   248,   249,   250,
     820,   251,   252,     0,     0,     0,   253,   254,   255,   821,
     257,     0,     0,   822,   259,   823,   824,   260,     0,   261,
     825,   826,   827,   828,   829,   830,   831,   266,   267,   268,
     269,     0,   832,   270,   271,     0,   272,   273,   274,   833,
     834,   835,   275,     0,   836,   837,     0,   276,   277,     0,
     838,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   839,   840,
     286,   841,   842,   843,   844,   845,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   846,   297,   298,
     299,   300,   301,   302,   303,   847,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,   848,   849,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,   850,   318,   319,   851,   320,   321,   852,
     322,   853,   324,   325,     0,   854,   327,     0,   328,   855,
     329,   330,   331,     0,     0,     0,     0,   332,     0,     0,
     333,   334,   335,     0,     0,   336,     0,     0,     0,   337,
     338,   339,   340,     0,   341,   342,   343,     0,     0,     0,
       0,     0,     0,   344,   345,     0,   346,     0,     0,   347,
       0,     0,   348,   349,   856,   857,   350,   351,     0,   352,
     858,   354,   859,   860,   861,   355,   356,   357,   358,   862,
     359,   360,     0,   361,   362,     0,   676,   363,   863,   864,
     865,   866,     0,     0,     0,     0,     0,   368,     0,   369,
     867,   868,   869,   371,   372,   373,     0,   870,   374,   375,
     871,     0,   376,     0,     0,   872,   873,   377,     0,     0,
     378,     0,   379,     0,   874,   381,     0,     0,   875,   876,
     877,   878,   879,   382,     0,     0,   383,   880,     0,   384,
     385,   881,     0,     0,     0,     0,   387,     0,   388,   389,
       0,   882,     0,   883,     0,     0,     0,     0,   884,     0,
       0,     0,   885,   886,     0,     0,     0,     0,   887,     0,
     888,     0,     0,   889,   890,     0,   891,   892,   122,     0,
     747,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   748,     0,   749,   130,   131,   750,   133,
       0,   134,   751,   135,     0,   752,   136,   753,   754,   755,
     137,   756,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,   757,   145,     0,   146,   758,   759,
     148,     0,   149,   150,   151,   760,   152,     0,   761,   154,
       0,   155,   156,   157,   158,   159,   762,   763,   160,     0,
     161,   162,     0,   764,   164,     0,   765,   766,   767,   165,
       0,     0,   166,   768,   769,     0,   770,   771,     0,   167,
     168,   772,   773,   774,     0,     0,     0,     0,   775,   171,
     776,     0,     0,   777,  2930,   172,     0,   173,     0,     0,
       0,   779,   780,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,   781,
     182,     0,   782,   783,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,   784,     0,   191,   785,   192,
     786,   787,   193,   194,     0,   788,   195,   196,   197,   789,
       0,   198,     0,     0,   790,     0,   199,   200,     0,   791,
     201,     0,   202,   792,   793,   794,   795,     0,   796,   797,
     204,   798,   799,   800,   206,     0,   207,   801,     0,   802,
     803,     0,   208,   209,     0,   210,   804,     0,   211,     0,
       0,     0,   805,   213,   214,   215,   806,     0,   216,   217,
       0,     0,     0,   218,     0,     0,   807,   219,   808,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,   809,   226,     0,     0,   810,
     227,     0,   811,   228,     0,     0,     0,   812,     0,   813,
       0,   230,   814,     0,   231,     0,   232,   815,     0,     0,
     816,     0,     0,     0,     0,   817,   233,   234,   235,   236,
     237,   238,   818,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   819,   248,   249,   250,   820,   251,   252,     0,
       0,     0,   253,   254,   255,   821,   257,     0,     0,   822,
     259,   823,   824,   260,     0,   261,   825,   826,   827,   828,
     829,   830,   831,   266,   267,   268,   269,     0,   832,   270,
     271,     0,   272,   273,   274,   833,   834,   835,   275,     0,
     836,   837,     0,   276,   277,     0,   838,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   839,   840,   286,   841,   842,   843,
     844,   845,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   846,   297,   298,   299,   300,   301,   302,
     303,   847,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,   848,   849,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,   850,
     318,   319,   851,   320,   321,   852,   322,   853,   324,   325,
       0,   854,   327,     0,   328,   855,   329,   330,   331,     0,
       0,     0,     0,   332,     0,     0,   333,   334,   335,     0,
       0,   336,     0,     0,     0,   337,   338,   339,   340,     0,
     341,   342,   343,     0,     0,     0,     0,     0,     0,   344,
     345,     0,   346,     0,     0,   347,     0,     0,   348,   349,
     856,   857,   350,   351,     0,   352,   858,   354,   859,   860,
     861,   355,   356,   357,   358,   862,   359,   360,     0,   361,
     362,     0,   676,   363,   863,   864,   865,   866,     0,     0,
       0,     0,     0,   368,     0,   369,   867,   868,   869,   371,
     372,   373,     0,   870,   374,   375,   871,     0,   376,     0,
       0,   872,   873,   377,     0,     0,   378,     0,   379,     0,
     874,   381,     0,     0,   875,   876,   877,   878,   879,   382,
       0,     0,   383,   880,     0,   384,   385,   881,     0,     0,
       0,     0,   387,     0,   388,   389,     0,   882,     0,   883,
       0,     0,     0,     0,   884,     0,     0,     0,   885,   886,
       0,     0,     0,     0,   887,     0,   888,     0,     0,   889,
     890,     0,   891,   892,   122,     0,   747,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   748,
       0,   749,   130,   131,   750,   133,     0,   134,   751,   135,
       0,   752,   136,   753,   754,   755,   137,   756,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
     757,   145,     0,   146,   758,   759,   148,     0,   149,   150,
     151,   760,   152,     0,   761,   154,     0,   155,   156,   157,
     158,   159,   762,   763,   160,     0,   161,   162,     0,   764,
     164,     0,   765,   766,   767,   165,     0,     0,   166,   768,
     769,     0,   770,   771,     0,   167,   168,   772,   773,   774,
       0,     0,     0,     0,   775,   171,   776,     0,     0,   777,
     778,   172,     0,   173,     0,     0,     0,   779,   780,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,   781,   182,     0,   782,   783,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,   784,     0,   191,   785,   192,   786,   787,   193,   194,
       0,   788,   195,   196,   197,   789,     0,   198,     0,     0,
     790,     0,   199,   200,     0,   791,   201,     0,   202,   792,
     793,   794,   795,     0,   796,   797,   204,   798,   799,   800,
     206,     0,   207,   801,     0,   802,   803,     0,   208,   209,
       0,   210,   804,     0,   211,     0,     0,     0,   805,   213,
     214,   215,   806,     0,   216,   217,     0,     0,     0,   218,
       0,     0,   807,   219,   808,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,   809,   226,     0,     0,   810,   227,     0,   811,   228,
       0,     0,     0,   812,     0,   813,     0,   230,   814,     0,
     231,     0,   232,   815,     0,     0,   816,     0,     0,     0,
       0,   817,   233,   234,   235,   236,   237,   238,   818,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   819,   248,
     249,   250,   820,   251,   252,     0,     0,     0,   253,   254,
     255,   821,   257,     0,     0,   822,   259,   823,   824,   260,
       0,   261,   825,   826,   827,   828,   829,   830,   831,   266,
     267,   268,   269,     0,   832,   270,   271,     0,   272,   273,
     274,   833,     0,   835,   275,     0,   836,   837,     0,   276,
     277,     0,   838,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     839,   840,   286,   841,   842,   843,   844,   845,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   846,
     297,   298,   299,   300,   301,   302,   303,   847,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,   848,   849,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,   850,   318,   319,   851,   320,
     321,   852,   322,   853,   324,   325,     0,   854,   327,     0,
     328,   855,   329,   330,   331,     0,     0,     0,     0,   332,
       0,     0,   333,   334,   335,     0,     0,   336,     0,     0,
       0,   337,   338,   339,   340,     0,   341,   342,   343,     0,
       0,     0,     0,     0,     0,   344,   345,     0,   346,     0,
       0,   347,     0,     0,   348,   349,   856,   857,   350,   351,
       0,   352,   858,   354,   859,   860,   861,   355,   356,   357,
     358,   862,   359,   360,     0,   361,   362,     0,   676,   363,
     863,   864,   865,   866,     0,     0,     0,     0,     0,   368,
       0,   369,   867,   868,   869,   371,   372,   373,     0,   870,
     374,   375,   871,     0,   376,     0,     0,   872,   873,   377,
       0,     0,   378,     0,   379,     0,   874,   381,     0,     0,
     875,   876,   877,   878,   879,   382,     0,     0,   383,   880,
       0,   384,   385,   881,     0,     0,     0,     0,   387,     0,
     388,   389,     0,   882,     0,   883,     0,     0,     0,     0,
     884,     0,     0,     0,   885,   886,     0,     0,     0,     0,
     887,     0,   888,     0,     0,   889,   890,     0,   891,   892,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,  1991,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,  1992,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,  1121,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,  1122,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,     0,  2492,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,  1900,   328,     0,   329,   330,
     331,     0,     0,     0,     0,   332,     0,     0,   333,   334,
     335,     0,     0,   336,     0,     0,     0,   337,   338,   339,
     340,     0,   341,   342,   343,  1993,     0,     0,     0,     0,
       0,   344,   345,     0,   346,     0,     0,   347,     0,     0,
     348,   349,     0,     0,   350,   351,     0,   352,   353,   354,
       0,     0,     0,   355,   356,   357,   358,     0,   359,   360,
       0,   361,   362,     0,     0,   363,   364,   365,   366,   367,
       0,     0,     0,     0,     0,   368,     0,   369,     0,     0,
     370,   371,   372,   373,     0,     0,   374,   375,     0,     0,
     376,     0,     0,     0,     0,   377,     0,     0,   378,     0,
     379,     0,   380,   381,     0,     0,     0,     0,     0,     0,
       0,   382,     0,     0,   383,     0,     0,   384,   385,   386,
       0,     0,     0,     0,   387,     0,   388,   389,     0,     0,
       0,   390,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,  2040,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,     0,
     145,     0,   146,   147,     0,   148,     0,   149,   150,   151,
       0,   152,     0,   153,   154,     0,   155,   156,   157,   158,
     159,     0,     0,   160,     0,   161,   162,  1991,   163,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,   171,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
       0,     0,   191,     0,   192,     0,     0,   193,   194,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,   201,  1992,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,   208,   209,     0,
     210,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,     0,     0,   216,   217,  1121,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,  1122,     0,     0,   225,
       0,   226,     0,     0,     0,   227,     0,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,   275,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,     0,     0,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,     0,   320,   321,
       0,   322,   323,   324,   325,     0,   326,   327,     0,   328,
       0,   329,   330,   331,     0,     0,     0,     0,   332,     0,
       0,   333,   334,   335,     0,     0,   336,     0,     0,     0,
     337,   338,   339,   340,     0,   341,   342,   343,  1993,     0,
       0,     0,     0,     0,   344,   345,     0,   346,     0,     0,
     347,     0,     0,   348,   349,     0,     0,   350,   351,     0,
     352,   353,   354,     0,     0,     0,   355,   356,   357,   358,
       0,   359,   360,     0,   361,   362,     0,     0,   363,   364,
     365,   366,   367,     0,     0,     0,     0,     0,   368,     0,
     369,     0,     0,   370,   371,   372,   373,     0,     0,   374,
     375,     0,     0,   376,     0,     0,     0,     0,   377,     0,
       0,   378,     0,   379,     0,   380,   381,     0,     0,     0,
       0,     0,     0,     0,   382,     0,     0,   383,     0,     0,
     384,   385,   386,     0,     0,     0,     0,   387,     0,   388,
     389,     0,     0,     0,   390,     0,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,  2040,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,  1900,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,     0,     0,
     350,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
       0,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,   370,   371,   372,   373,
       0,     0,   374,   375,     0,     0,   376,     0,     0,     0,
       0,   377,     0,     0,   378,     0,   379,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,   389,     0,     0,     0,   390,     0,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,  2317,     0,   130,   131,   132,
     133,   892,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,     0,   329,   330,   331,
       0,     0,     0,     0,   332,     0,     0,   333,   334,   335,
       0,     0,   336,     0,     0,     0,   337,   338,   339,   340,
       0,   341,   342,   343,     0,     0,     0,     0,     0,     0,
     344,   345,     0,   346,     0,     0,   347,     0,     0,   348,
     349,     0,     0,   350,   351,     0,   352,   353,   354,     0,
       0,     0,   355,   356,   357,   358,     0,   359,   360,     0,
     361,   362,     0,     0,   363,   364,   365,   366,   367,     0,
       0,     0,     0,     0,   368,     0,   369,     0,     0,   370,
     371,   372,   373,     0,     0,   374,   375,     0,     0,   376,
       0,     0,     0,     0,   377,     0,     0,   378,     0,   379,
       0,   380,   381,     0,     0,     0,     0,     0,     0,     0,
     382,     0,     0,   383,     0,     0,   384,   385,   386,     0,
       0,     0,     0,   387,     0,   388,   389,     0,     0,     0,
     390,     0,     0,     0,     0,     0,     0,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,     0,  3682,   128,
       0,     0,   129,  3683,   892,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,     0,   145,     0,   146,   147,     0,   148,
       0,   149,   150,   151,     0,   152,     0,   153,   154,     0,
     155,   156,   157,   158,   159,     0,     0,   160,     0,   161,
     162,     0,   163,   164,     0,     0,     0,     0,   165,     0,
       0,   166,     0,     0,     0,     0,     0,     0,   167,   168,
       0,     0,   169,     0,     0,     0,     0,   170,   171,     0,
       0,     0,     0,     0,   172,     0,   173,     0,     0,     0,
       0,     0,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,     0,   182,
       0,     0,     0,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,     0,     0,   191,     0,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,   203,   204,
       0,     0,   205,   206,     0,   207,     0,     0,     0,     0,
       0,   208,   209,     0,   210,     0,     0,   211,     0,     0,
       0,   212,   213,   214,   215,     0,     0,   216,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,   994,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,     0,   226,     0,     0,     0,   227,
       0,     0,   228,     0,     0,     0,     0,     0,   229,     0,
     230,     0,     0,   231,     0,   232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,   234,   235,   236,   237,
     238,     0,   239,   240,   241,   242,   243,   244,   245,   246,
     247,     0,   248,   249,   250,     0,   251,   252,     0,     0,
       0,   253,   254,   255,   256,   257,     0,     0,   258,   259,
       0,     0,   260,     0,   261,     0,   262,     0,     0,   263,
     264,   265,   266,   267,   268,   269,     0,     0,   270,   271,
       0,   272,   273,   274,     0,     0,     0,   275,     0,     0,
       0,     0,   276,   277,     0,   278,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   285,     0,   286,     0,   287,     0,   288,
       0,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   300,   301,   302,   303,
       0,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,     0,     0,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,     0,   320,   321,     0,   322,   323,   324,   325,     0,
     326,   327,     0,   328,     0,   329,   330,   331,     0,     0,
       0,     0,   332,     0,     0,   333,   334,   335,     0,     0,
     336,     0,     0,     0,   337,   338,   339,   340,     0,   341,
     342,   343,     0,     0,     0,     0,     0,     0,   344,   345,
       0,   346,     0,     0,   347,     0,     0,   348,   349,     0,
       0,   350,   351,     0,   352,   353,   354,     0,     0,     0,
     355,   356,   357,   358,     0,   359,   360,     0,   361,   362,
       0,     0,   363,   364,   365,   366,   367,     0,     0,     0,
       0,     0,   368,     0,   369,     0,     0,   370,   371,   372,
     373,     0,     0,   374,   375,     0,     0,   376,     0,     0,
       0,     0,   377,     0,     0,   378,     0,   379,     0,   380,
     381,     0,     0,     0,     0,     0,     0,     0,   382,     0,
       0,   383,     0,     0,   384,   385,   386,     0,     0,     0,
       0,   387,     0,   388,   389,     0,     0,     0,   390,     0,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,   426,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,     0,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,     0,   328,     0,   329,   330,
     331,     0,     0,     0,     0,   332,     0,     0,   333,   334,
     335,     0,     0,   336,     0,     0,     0,   337,   338,   339,
     340,     0,   341,   342,   343,     0,     0,     0,     0,     0,
       0,   344,   345,     0,   346,     0,     0,   347,     0,     0,
     348,   349,     0,     0,   350,   351,     0,   352,   353,   354,
       0,     0,     0,   355,   356,   357,   358,     0,   359,   360,
       0,   361,   362,     0,     0,   363,   364,   365,   366,   367,
       0,     0,     0,     0,     0,   368,     0,   369,     0,     0,
     370,   371,   372,   373,     0,     0,   374,   375,     0,     0,
     376,     0,     0,     0,     0,   377,     0,     0,   378,     0,
     379,     0,   380,   381,     0,     0,     0,     0,     0,     0,
       0,   382,     0,     0,   383,     0,     0,   384,   385,   386,
       0,     0,     0,     0,   387,     0,   388,   389,     0,     0,
       0,   390,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,  1858,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,   426,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,     0,
     145,     0,   146,   147,     0,   148,     0,   149,   150,   151,
       0,   152,     0,   153,   154,     0,   155,   156,   157,   158,
     159,     0,     0,   160,     0,   161,   162,     0,   163,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,   171,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
       0,     0,   191,     0,   192,     0,     0,   193,   194,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,   208,   209,     0,
     210,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,     0,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
       0,   226,     0,     0,     0,   227,     0,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,   275,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,     0,     0,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,     0,   320,   321,
       0,   322,   323,   324,   325,     0,   326,   327,     0,   328,
       0,   329,   330,   331,     0,     0,     0,     0,   332,     0,
       0,   333,   334,   335,     0,     0,   336,     0,     0,     0,
     337,   338,   339,   340,     0,   341,   342,   343,     0,     0,
       0,     0,     0,     0,   344,   345,     0,   346,     0,     0,
     347,     0,     0,   348,   349,     0,     0,   350,   351,     0,
     352,   353,   354,     0,     0,     0,   355,   356,   357,   358,
       0,   359,   360,     0,   361,   362,     0,     0,   363,   364,
     365,   366,   367,     0,     0,     0,     0,     0,   368,     0,
     369,     0,     0,   370,   371,   372,   373,     0,     0,   374,
     375,     0,     0,   376,     0,     0,     0,     0,   377,     0,
       0,   378,     0,   379,     0,   380,   381,     0,     0,     0,
       0,     0,     0,     0,   382,     0,     0,   383,     0,     0,
     384,   385,   386,     0,     0,     0,     0,   387,     0,   388,
     389,     0,     0,     0,   390,     0,     0,     0,     0,     0,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,  2039,     0,   128,     0,     0,   129,     0,  2040,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,   328,     0,   329,
     330,   331,     0,     0,     0,     0,   332,     0,     0,   333,
     334,   335,     0,     0,   336,     0,     0,     0,   337,   338,
     339,   340,     0,   341,   342,   343,     0,     0,     0,     0,
       0,     0,   344,   345,     0,   346,     0,     0,   347,     0,
       0,   348,   349,     0,     0,   350,   351,     0,   352,   353,
     354,     0,     0,     0,   355,   356,   357,   358,     0,   359,
     360,     0,   361,   362,     0,     0,   363,   364,   365,   366,
     367,     0,     0,     0,     0,     0,   368,     0,   369,     0,
       0,   370,   371,   372,   373,     0,     0,   374,   375,     0,
       0,   376,     0,     0,     0,     0,   377,     0,     0,   378,
       0,   379,     0,   380,   381,     0,     0,     0,     0,     0,
       0,     0,   382,     0,     0,   383,     0,     0,   384,   385,
     386,     0,     0,     0,     0,   387,     0,   388,   389,     0,
       0,     0,   390,     0,     0,     0,     0,     0,     0,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,  3683,   892,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,     0,   329,   330,   331,
       0,     0,     0,     0,   332,     0,     0,   333,   334,   335,
       0,     0,   336,     0,     0,     0,   337,   338,   339,   340,
       0,   341,   342,   343,     0,     0,     0,     0,     0,     0,
     344,   345,     0,   346,     0,     0,   347,     0,     0,   348,
     349,     0,     0,   350,   351,     0,   352,   353,   354,     0,
       0,     0,   355,   356,   357,   358,     0,   359,   360,     0,
     361,   362,     0,     0,   363,   364,   365,   366,   367,     0,
       0,     0,     0,     0,   368,     0,   369,     0,     0,   370,
     371,   372,   373,     0,     0,   374,   375,     0,     0,   376,
       0,     0,     0,     0,   377,     0,     0,   378,     0,   379,
       0,   380,   381,     0,     0,     0,     0,     0,     0,     0,
     382,     0,     0,   383,     0,     0,   384,   385,   386,     0,
       0,     0,     0,   387,     0,   388,   389,     0,     0,     0,
     390,     0,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,   426,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,     0,   145,
       0,   146,   147,     0,   148,     0,   149,   150,   151,     0,
     152,     0,   153,   154,     0,   155,   156,   157,   158,   159,
       0,     0,   160,     0,   161,   162,     0,   163,   164,     0,
       0,     0,     0,   165,     0,     0,   166,     0,     0,     0,
       0,     0,     0,   167,   168,     0,     0,   169,     0,     0,
       0,     0,   170,   171,     0,     0,     0,     0,     0,   172,
       0,   173,     0,     0,     0,     0,     0,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,     0,   182,     0,     0,     0,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,     0,
       0,   191,     0,   480,     0,     0,   193,   194,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,   201,     0,   202,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,   205,   206,     0,
     207,     0,     0,     0,     0,     0,   208,   209,     0,   210,
       0,     0,   211,     0,     0,     0,   212,   213,   214,   215,
       0,     0,   216,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,     0,
     226,     0,     0,     0,   227,     0,     0,   228,     0,     0,
       0,     0,     0,   229,     0,   230,     0,     0,   231,     0,
     232,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     233,   234,   235,   236,   237,   238,     0,   239,   240,   241,
     242,   243,   244,   245,   246,   247,     0,   248,   249,   250,
       0,   251,   252,     0,     0,     0,   253,   254,   255,   256,
     257,     0,     0,   258,   259,     0,     0,   260,     0,   261,
       0,   262,     0,     0,   263,   264,   265,   266,   267,   268,
     269,     0,     0,   270,   271,     0,   272,   273,   274,     0,
       0,     0,   275,     0,     0,     0,     0,   276,   277,     0,
     278,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   285,     0,
     286,     0,   287,     0,   288,     0,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   300,   301,   302,   303,     0,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,     0,     0,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,     0,   320,   321,     0,
     322,   323,   324,   325,     0,   326,   327,     0,   328,     0,
     329,   330,   331,     0,     0,     0,     0,   332,     0,     0,
     333,   334,   335,     0,     0,   336,     0,     0,     0,   337,
     338,   339,   340,     0,   341,   342,   343,     0,     0,     0,
       0,     0,     0,   344,   345,     0,   346,     0,     0,   347,
       0,     0,   348,   349,     0,     0,   350,   351,     0,   352,
     353,   354,     0,     0,     0,   355,   356,   357,   358,     0,
     359,   360,     0,   361,   362,     0,     0,   363,   364,   365,
     366,   367,     0,     0,     0,     0,     0,   368,     0,   369,
       0,     0,   370,   371,   372,   373,     0,     0,   374,   375,
       0,     0,   376,     0,     0,     0,     0,   377,     0,     0,
     378,     0,   379,     0,   380,   381,     0,     0,     0,     0,
       0,     0,     0,   382,     0,     0,   383,     0,     0,   384,
     385,   386,     0,     0,     0,     0,   387,     0,   388,   389,
       0,     0,     0,   390,     0,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,   426,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,     0,   329,   330,   331,     0,     0,     0,     0,
     332,     0,     0,   333,   334,   335,     0,     0,   336,     0,
       0,     0,   337,   338,   339,   340,     0,   341,   342,   343,
       0,     0,     0,     0,     0,     0,   344,   345,     0,   346,
       0,     0,   347,     0,     0,   348,   349,     0,     0,   350,
     351,     0,   352,   353,   354,     0,     0,     0,   355,   356,
     357,   358,     0,   359,   360,     0,   361,   362,     0,     0,
     363,   364,   365,   366,   367,     0,     0,     0,     0,     0,
     368,     0,   369,     0,     0,   370,   371,   372,   373,     0,
       0,   374,   375,     0,     0,   376,     0,     0,     0,     0,
     377,     0,     0,   378,     0,   379,     0,   380,   381,     0,
       0,     0,     0,     0,     0,     0,   382,     0,     0,   383,
       0,     0,   384,   385,   386,     0,     0,     0,     0,   387,
       0,   388,   389,     0,     0,     0,   390,     0,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
     892,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,   328,     0,   329,   330,   331,     0,
       0,     0,     0,   332,     0,     0,   333,   334,   335,     0,
       0,   336,     0,     0,     0,   337,   338,   339,   340,     0,
     341,   342,   343,     0,     0,     0,     0,     0,     0,   344,
     345,     0,   346,     0,     0,   347,     0,     0,   348,   349,
       0,     0,   350,   351,     0,   352,   353,   354,     0,     0,
       0,   355,   356,   357,   358,     0,   359,   360,     0,   361,
     362,     0,     0,   363,   364,   365,   366,   367,     0,     0,
       0,     0,     0,   368,     0,   369,     0,     0,   370,   371,
     372,   373,     0,     0,   374,   375,     0,     0,   376,     0,
       0,     0,     0,   377,     0,     0,   378,     0,   379,     0,
     380,   381,     0,     0,     0,     0,     0,     0,     0,   382,
       0,     0,   383,     0,     0,   384,   385,   386,     0,     0,
       0,     0,   387,     0,   388,   389,     0,     0,     0,   390,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,  2040,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,   565,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,   328,     0,   329,
     330,   331,     0,     0,     0,     0,   332,     0,     0,   333,
     334,   335,     0,     0,   336,     0,     0,     0,   337,   338,
     339,   340,     0,   341,   342,   343,     0,     0,     0,     0,
       0,     0,   344,   345,     0,   346,     0,     0,   347,     0,
       0,   348,   349,     0,     0,   350,   351,     0,   352,   353,
     354,     0,     0,     0,   355,   356,   357,   358,     0,   359,
     360,     0,   361,   362,     0,   566,   363,   364,   365,   366,
     367,     0,     0,     0,     0,     0,   368,     0,   369,     0,
       0,   370,   371,   372,   373,     0,     0,   374,   375,     0,
       0,   376,     0,     0,     0,     0,   377,     0,     0,   378,
       0,   379,     0,   380,   381,     0,     0,     0,     0,     0,
       0,     0,   382,     0,     0,   383,     0,     0,   384,   385,
     386,     0,     0,     0,     0,   387,     0,   388,   389,     0,
       0,   122,   390,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,  1800,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,   565,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,   328,     0,   329,
     330,   331,     0,     0,     0,     0,   332,     0,     0,   333,
     334,   335,     0,     0,   336,     0,     0,     0,   337,   338,
     339,   340,     0,   341,   342,   343,     0,     0,     0,     0,
       0,     0,   344,   345,     0,   346,     0,     0,   347,     0,
       0,   348,   349,     0,     0,   350,   351,     0,   352,   353,
     354,     0,     0,     0,   355,   356,   357,   358,     0,   359,
     360,     0,   361,   362,     0,   566,   363,   364,   365,   366,
     367,     0,     0,     0,     0,     0,   368,     0,   369,     0,
       0,   370,   371,   372,   373,     0,     0,   374,   375,     0,
       0,   376,     0,     0,     0,     0,   377,     0,     0,   378,
       0,   379,     0,   380,   381,     0,     0,     0,     0,     0,
       0,     0,   382,     0,     0,   383,     0,     0,   384,   385,
     386,     0,     0,     0,     0,   387,     0,   388,   389,     0,
       0,   122,   390,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,  2357,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,   565,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,   328,     0,   329,
     330,   331,     0,     0,     0,     0,   332,     0,     0,   333,
     334,   335,     0,     0,   336,     0,     0,     0,   337,   338,
     339,   340,     0,   341,   342,   343,     0,     0,     0,     0,
       0,     0,   344,   345,     0,   346,     0,     0,   347,     0,
       0,   348,   349,     0,     0,   350,   351,     0,   352,   353,
     354,     0,     0,     0,   355,   356,   357,   358,     0,   359,
     360,     0,   361,   362,     0,   566,   363,   364,   365,   366,
     367,     0,     0,     0,     0,     0,   368,     0,   369,     0,
       0,   370,   371,   372,   373,     0,     0,   374,   375,     0,
       0,   376,     0,     0,     0,     0,   377,     0,     0,   378,
       0,   379,     0,   380,   381,     0,     0,     0,     0,     0,
       0,     0,   382,     0,     0,   383,     0,     0,   384,   385,
     386,     0,     0,     0,     0,   387,     0,   388,   389,     0,
       0,   122,   390,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,     0,     0,     0,   130,
     131,   132,     0,     0,  -186,  2953,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,     0,     0,     0,     0,   144,     0,   145,     0,
     146,     0,     0,     0,     0,   149,   150,  3525,     0,   152,
       0,   153,   154,     0,     0,   156,     0,   158,   159,     0,
       0,   160,     0,   161,   162,     0,     0,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,     0,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,     0,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,     0,   184,   185,
     186,     0,     0,   187,     0,   188,   189,     0,     0,     0,
     191,     0,   192,     0,     0,   193,   194,  3526,     0,   195,
     196,   197,     0,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,     0,   209,     0,     0,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,  3527,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,  3528,     0,     0,     0,     0,     0,     0,     0,   226,
       0,     0,     0,   227,  3529,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,  -186,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,  3530,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,     0,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,     0,   311,
    -186,     0,   312,     0,     0,   314,     0,     0,   316,   317,
    3531,     0,     0,     0,   319,     0,   320,   321,     0,   322,
     323,   324,     0,     0,   326,     0,     0,   328,     0,   329,
     330,   331,     0,     0,     0,     0,   332,     0,     0,   333,
     334,   335,     0,     0,   336,     0,     0,     0,   337,     0,
     339,     0,     0,   341,   342,   343,     0,     0,     0,     0,
       0,     0,   344,   345,     0,   346,     0,     0,   347,     0,
       0,     0,   349,     0,     0,     0,   351,     0,   352,   353,
     354,     0,     0,     0,   355,   356,   357,   358,     0,   359,
     360,     0,   361,   362,     0,     0,   363,   364,   365,   366,
     367,     0,     0,     0,     0,     0,   368,     0,   369,     0,
       0,     0,   371,   372,   373,     0,     0,   374,   375,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,     0,   380,   381,     0,     0,     0,     0,     0,
       0,     0,   382,     0,     0,   383,     0,     0,   384,   385,
     386,     0,     0,  -186,     0,   387,     0,   388,     0,     0,
       0,     0,   390,     0,     0,     0,     0,  3532,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,  3734,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,   328,     0,   329,   330,   331,     0,
       0,     0,     0,   332,     0,     0,   333,   334,   335,     0,
       0,   336,     0,     0,     0,   337,   338,   339,   340,     0,
     341,   342,   343,     0,     0,     0,     0,     0,     0,   344,
     345,     0,   346,     0,     0,   347,     0,     0,   348,   349,
       0,     0,   350,   351,     0,   352,   353,   354,     0,     0,
       0,   355,   356,   357,   358,     0,   359,   360,     0,   361,
     362,     0,     0,   363,   364,   365,   366,   367,     0,     0,
       0,     0,     0,   368,     0,   369,     0,     0,   370,   371,
     372,   373,     0,     0,   374,   375,     0,     0,   376,     0,
       0,     0,     0,   377,     0,     0,   378,     0,   379,     0,
     380,   381,     0,     0,     0,     0,     0,     0,     0,   382,
       0,     0,   383,     0,     0,   384,   385,   386,     0,     0,
       0,     0,   387,     0,   388,   389,     0,     0,     0,   390,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
    1648,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,     0,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,     0,   328,     0,   329,   330,
     331,     0,     0,     0,     0,   332,     0,     0,   333,   334,
     335,     0,     0,   336,     0,     0,     0,   337,   338,   339,
     340,     0,   341,   342,   343,     0,     0,     0,     0,     0,
       0,   344,   345,     0,   346,     0,     0,   347,     0,     0,
     348,   349,     0,     0,   350,   351,     0,   352,   353,   354,
       0,     0,     0,   355,   356,   357,   358,     0,   359,   360,
       0,   361,   362,     0,     0,   363,   364,   365,   366,   367,
       0,     0,     0,     0,     0,   368,     0,   369,     0,     0,
     370,   371,   372,   373,     0,     0,   374,   375,     0,     0,
     376,     0,     0,     0,     0,   377,     0,     0,   378,     0,
     379,     0,   380,   381,     0,     0,     0,     0,     0,     0,
       0,   382,     0,     0,   383,     0,     0,   384,   385,   386,
       0,     0,     0,     0,   387,     0,   388,   389,     0,     0,
       0,   390,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,  2343,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,     0,   145,
       0,   146,   147,     0,   148,     0,   149,   150,   151,     0,
     152,     0,   153,   154,     0,   155,   156,   157,   158,   159,
       0,     0,   160,     0,   161,   162,     0,   163,   164,     0,
       0,     0,     0,   165,     0,     0,   166,     0,     0,     0,
       0,     0,     0,   167,   168,     0,     0,   169,     0,     0,
       0,     0,   170,   171,     0,     0,     0,     0,     0,   172,
       0,   173,     0,     0,     0,     0,     0,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,     0,   182,     0,     0,     0,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,     0,
       0,   191,     0,   192,     0,     0,   193,   194,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,   201,     0,   202,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,   205,   206,     0,
     207,     0,     0,     0,     0,     0,   208,   209,     0,   210,
       0,     0,   211,     0,     0,     0,   212,   213,   214,   215,
       0,     0,   216,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,     0,
     226,     0,     0,     0,   227,     0,     0,   228,     0,     0,
       0,     0,     0,   229,     0,   230,     0,     0,   231,     0,
     232,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     233,   234,   235,   236,   237,   238,     0,   239,   240,   241,
     242,   243,   244,   245,   246,   247,     0,   248,   249,   250,
       0,   251,   252,     0,     0,     0,   253,   254,   255,   256,
     257,     0,     0,   258,   259,     0,     0,   260,     0,   261,
       0,   262,     0,     0,   263,   264,   265,   266,   267,   268,
     269,     0,     0,   270,   271,     0,   272,   273,   274,     0,
       0,     0,   275,     0,     0,     0,     0,   276,   277,     0,
     278,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   285,     0,
     286,     0,   287,     0,   288,     0,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   300,   301,   302,   303,     0,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,     0,     0,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,     0,   320,   321,     0,
     322,   323,   324,   325,     0,   326,   327,     0,   328,     0,
     329,   330,   331,     0,     0,     0,     0,   332,     0,     0,
     333,   334,   335,     0,     0,   336,     0,     0,     0,   337,
     338,   339,   340,     0,   341,   342,   343,     0,     0,     0,
       0,     0,     0,   344,   345,     0,   346,     0,     0,   347,
       0,     0,   348,   349,     0,     0,   350,   351,     0,   352,
     353,   354,     0,     0,     0,   355,   356,   357,   358,     0,
     359,   360,     0,   361,   362,     0,     0,   363,   364,   365,
     366,   367,     0,     0,     0,     0,     0,   368,     0,   369,
       0,     0,   370,   371,   372,   373,     0,     0,   374,   375,
       0,     0,   376,     0,     0,     0,     0,   377,     0,     0,
     378,     0,   379,     0,   380,   381,     0,     0,     0,     0,
       0,     0,     0,   382,     0,     0,   383,     0,     0,   384,
     385,   386,     0,     0,     0,     0,   387,     0,   388,   389,
       0,     0,     0,   390,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,  2634,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,     0,   329,   330,   331,     0,     0,     0,     0,   332,
       0,     0,   333,   334,   335,     0,     0,   336,     0,     0,
       0,   337,   338,   339,   340,     0,   341,   342,   343,     0,
       0,     0,     0,     0,     0,   344,   345,     0,   346,     0,
       0,   347,     0,     0,   348,   349,     0,     0,   350,   351,
       0,   352,   353,   354,     0,     0,     0,   355,   356,   357,
     358,     0,   359,   360,     0,   361,   362,     0,     0,   363,
     364,   365,   366,   367,     0,     0,     0,     0,     0,   368,
       0,   369,     0,     0,   370,   371,   372,   373,     0,     0,
     374,   375,     0,     0,   376,     0,     0,     0,     0,   377,
       0,     0,   378,     0,   379,     0,   380,   381,     0,     0,
       0,     0,     0,     0,     0,   382,     0,     0,   383,     0,
       0,   384,   385,   386,     0,     0,     0,     0,   387,     0,
     388,   389,     0,     0,     0,   390,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,  2958,     0,   128,     0,
       0,     0,     0,     0,   130,   131,   132,     0,     0,  -186,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,     0,     0,     0,
       0,   144,     0,   145,     0,   146,     0,     0,     0,     0,
     149,   150,  3525,     0,   152,     0,   153,   154,     0,     0,
     156,     0,   158,   159,     0,     0,   160,     0,   161,   162,
       0,     0,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,     0,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,     0,
       0,     0,   179,   180,   181,     0,  -201,     0,   182,     0,
       0,     0,  -201,   184,   185,   186,     0,     0,   187,     0,
     188,   189,     0,     0,     0,   191,     0,   192,     0,     0,
     193,   194,  3526,     0,   195,   196,   197,     0,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
       0,   209,     0,     0,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,  3527,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,  3528,     0,     0,     0,
       0,     0,     0,     0,   226,     0,     0,     0,   227,  3529,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
    -186,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,  3530,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,     0,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,     0,   311,  -186,     0,   312,     0,     0,
     314,     0,     0,   316,   317,  3531,     0,     0,     0,   319,
       0,   320,   321,     0,   322,   323,   324,     0,     0,   326,
       0,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,     0,   339,     0,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,     0,   349,     0,     0,
       0,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
       0,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,     0,   371,   372,   373,
       0,     0,   374,   375,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,  -186,     0,
     387,     0,   388,     0,     0,     0,     0,   390,     0,     0,
    -201,   122,  3532,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,     0,     0,     0,   130,
     131,   132,     0,     0,  -186,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,     0,     0,     0,     0,   144,     0,   145,     0,
     146,     0,     0,     0,     0,   149,   150,  3525,     0,   152,
       0,   153,   154,     0,     0,   156,     0,   158,   159,     0,
       0,   160,     0,   161,   162,     0,     0,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,     0,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,     0,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,  -222,   184,   185,
     186,     0,     0,   187,     0,   188,   189,     0,     0,     0,
     191,     0,   192,     0,     0,   193,   194,  3526,     0,   195,
     196,   197,     0,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,     0,   209,     0,     0,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,  3527,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,  3528,     0,     0,     0,     0,     0,     0,     0,   226,
       0,     0,     0,   227,  3529,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,  -186,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,  3530,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,     0,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,     0,   311,
    -186,     0,   312,     0,     0,   314,     0,     0,   316,   317,
    3531,     0,     0,     0,   319,     0,   320,   321,     0,   322,
     323,   324,     0,     0,   326,     0,     0,   328,     0,   329,
     330,   331,     0,     0,     0,     0,   332,     0,     0,   333,
     334,   335,     0,     0,   336,     0,     0,     0,   337,     0,
     339,     0,     0,   341,   342,   343,     0,     0,     0,     0,
       0,     0,   344,   345,     0,   346,     0,     0,   347,     0,
       0,     0,   349,     0,     0,     0,   351,     0,   352,   353,
     354,     0,     0,     0,   355,   356,   357,   358,     0,   359,
     360,     0,   361,   362,     0,     0,   363,   364,   365,   366,
     367,     0,     0,     0,     0,     0,   368,     0,   369,     0,
       0,     0,   371,   372,   373,     0,     0,   374,   375,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,     0,   380,   381,     0,     0,     0,     0,     0,
       0,     0,   382,     0,     0,   383,     0,     0,   384,   385,
     386,  -222,     0,  -186,     0,   387,     0,   388,     0,     0,
       0,     0,   390,     0,     0,  -222,   122,  3532,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,     0,     0,     0,   130,   131,   132,     0,     0,  -186,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,     0,     0,     0,
       0,   144,     0,   145,     0,   146,     0,     0,     0,     0,
     149,   150,  3525,     0,   152,     0,   153,   154,     0,     0,
     156,     0,   158,   159,     0,     0,   160,     0,   161,   162,
       0,     0,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,     0,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,     0,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,  -219,   184,   185,   186,     0,     0,   187,     0,
     188,   189,     0,     0,     0,   191,     0,   192,     0,     0,
     193,   194,  3526,     0,   195,   196,   197,     0,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
       0,   209,     0,     0,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,  3527,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,  3528,     0,     0,     0,
       0,     0,     0,     0,   226,     0,     0,     0,   227,  3529,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
    -186,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,  3530,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,     0,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,     0,   311,  -186,     0,   312,     0,     0,
     314,     0,     0,   316,   317,  3531,     0,     0,     0,   319,
       0,   320,   321,     0,   322,   323,   324,     0,     0,   326,
       0,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,     0,   339,     0,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,     0,   349,     0,     0,
       0,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
       0,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,     0,   371,   372,   373,
       0,     0,   374,   375,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,  -219,     0,  -186,     0,
     387,     0,   388,     0,     0,     0,     0,   390,     0,     0,
    -219,   122,  3532,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,     0,     0,     0,   130,
     131,   132,     0,     0,  -186,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,     0,     0,     0,     0,   144,     0,   145,     0,
     146,     0,     0,     0,     0,   149,   150,  3525,     0,   152,
       0,   153,   154,     0,     0,   156,     0,   158,   159,     0,
       0,   160,     0,   161,   162,     0,     0,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,     0,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,     0,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,  3612,   184,   185,
     186,     0,     0,   187,     0,   188,   189,     0,     0,     0,
     191,     0,   192,     0,     0,   193,   194,  3526,     0,   195,
     196,   197,     0,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,     0,   209,     0,     0,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,  3527,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,  3528,     0,     0,     0,     0,     0,     0,     0,   226,
       0,     0,     0,   227,  3529,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,  -186,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,  3530,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,     0,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,     0,   311,
    -186,     0,   312,     0,     0,   314,     0,     0,   316,   317,
    3531,     0,     0,     0,   319,     0,   320,   321,     0,   322,
     323,   324,     0,     0,   326,     0,     0,   328,     0,   329,
     330,   331,     0,     0,     0,     0,   332,     0,     0,   333,
     334,   335,     0,     0,   336,     0,     0,     0,   337,     0,
     339,     0,     0,   341,   342,   343,     0,     0,     0,     0,
       0,     0,   344,   345,     0,   346,     0,     0,   347,     0,
       0,     0,   349,     0,     0,     0,   351,     0,   352,   353,
     354,     0,     0,     0,   355,   356,   357,   358,     0,   359,
     360,     0,   361,   362,     0,     0,   363,   364,   365,   366,
     367,     0,     0,     0,     0,     0,   368,     0,   369,     0,
       0,     0,   371,   372,   373,     0,     0,   374,   375,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,     0,   380,   381,     0,     0,     0,     0,     0,
       0,     0,   382,     0,     0,   383,     0,     0,   384,   385,
     386,     0,     0,  -186,     0,   387,     0,   388,     0,     0,
       0,     0,   390,     0,     0,     0,   122,  3532,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,     0,     0,     0,   130,   131,   132,     0,     0,  -186,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,     0,     0,     0,
       0,   144,     0,   145,     0,   146,     0,     0,     0,     0,
     149,   150,  3525,     0,   152,     0,   153,   154,     0,     0,
     156,     0,   158,   159,     0,     0,   160,     0,   161,   162,
       0,     0,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,     0,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,     0,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,  -224,   184,   185,   186,     0,     0,   187,     0,
     188,   189,     0,     0,     0,   191,     0,   192,     0,     0,
     193,   194,  3526,     0,   195,   196,   197,     0,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
       0,   209,     0,     0,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,  3527,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,  3528,     0,     0,     0,
       0,     0,     0,     0,   226,     0,     0,     0,   227,  3529,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
    -186,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,  3530,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,     0,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,     0,   311,  -186,     0,   312,     0,     0,
     314,     0,     0,   316,   317,  3531,     0,     0,     0,   319,
       0,   320,   321,     0,   322,   323,   324,     0,     0,   326,
       0,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,     0,   339,     0,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,     0,   349,     0,     0,
       0,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
       0,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,     0,   371,   372,   373,
       0,     0,   374,   375,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,  -186,     0,
     387,     0,   388,     0,     0,     0,     0,   390,     0,     0,
       0,   122,  3532,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,     0,     0,     0,   130,
     131,   132,     0,     0,  -186,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,     0,     0,     0,     0,   144,     0,   145,     0,
     146,     0,     0,     0,     0,   149,   150,  3525,     0,   152,
       0,   153,   154,     0,     0,   156,     0,   158,   159,     0,
       0,   160,     0,   161,   162,     0,     0,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,     0,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,     0,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,  3659,   184,   185,
     186,     0,     0,   187,     0,   188,   189,     0,     0,     0,
     191,     0,   192,     0,     0,   193,   194,  3526,     0,   195,
     196,   197,     0,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,     0,   209,     0,     0,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,  3527,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,  3528,     0,     0,     0,     0,     0,     0,     0,   226,
       0,     0,     0,   227,  3529,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,  -186,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,  3530,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,     0,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,     0,   311,
    -186,     0,   312,     0,     0,   314,     0,     0,   316,   317,
    3531,     0,     0,     0,   319,     0,   320,   321,     0,   322,
     323,   324,     0,     0,   326,     0,     0,   328,     0,   329,
     330,   331,     0,     0,     0,     0,   332,     0,     0,   333,
     334,   335,     0,     0,   336,     0,     0,     0,   337,     0,
     339,     0,     0,   341,   342,   343,     0,     0,     0,     0,
       0,     0,   344,   345,     0,   346,     0,     0,   347,     0,
       0,     0,   349,     0,     0,     0,   351,     0,   352,   353,
     354,     0,     0,     0,   355,   356,   357,   358,     0,   359,
     360,     0,   361,   362,     0,     0,   363,   364,   365,   366,
     367,     0,     0,     0,     0,     0,   368,     0,   369,     0,
       0,     0,   371,   372,   373,     0,     0,   374,   375,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,     0,   380,   381,     0,     0,     0,     0,     0,
       0,     0,   382,     0,     0,   383,     0,     0,   384,   385,
     386,     0,     0,  -186,     0,   387,     0,   388,     0,     0,
       0,     0,   390,     0,     0,     0,   122,  3532,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,     0,     0,     0,   130,   131,   132,     0,     0,  -186,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,     0,     0,     0,
       0,   144,     0,   145,     0,   146,     0,     0,     0,     0,
     149,   150,  3525,     0,   152,     0,   153,   154,     0,     0,
     156,     0,   158,   159,     0,     0,   160,     0,   161,   162,
       0,     0,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,     0,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,     0,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,  3700,   184,   185,   186,     0,     0,   187,     0,
     188,   189,     0,     0,     0,   191,     0,   192,     0,     0,
     193,   194,  3526,     0,   195,   196,   197,     0,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
       0,   209,     0,     0,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,  3527,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,  3528,     0,     0,     0,
       0,     0,     0,     0,   226,     0,     0,     0,   227,  3529,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
    -186,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,  3530,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,     0,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,     0,   311,  -186,     0,   312,     0,     0,
     314,     0,     0,   316,   317,  3531,     0,     0,     0,   319,
       0,   320,   321,     0,   322,   323,   324,     0,     0,   326,
       0,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,     0,   339,     0,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,     0,   349,     0,     0,
       0,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
       0,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,     0,   371,   372,   373,
       0,     0,   374,   375,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,  -186,     0,
     387,     0,   388,     0,     0,     0,     0,   390,     0,     0,
       0,   122,  3532,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,     0,     0,     0,   130,
     131,   132,     0,     0,  -186,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,     0,     0,     0,     0,   144,     0,   145,     0,
     146,     0,     0,     0,     0,   149,   150,  3525,     0,   152,
       0,   153,   154,     0,     0,   156,     0,   158,   159,     0,
       0,   160,     0,   161,   162,     0,     0,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,     0,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,     0,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,  -205,   184,   185,
     186,     0,     0,   187,     0,   188,   189,     0,     0,     0,
     191,     0,   192,     0,     0,   193,   194,  3526,     0,   195,
     196,   197,     0,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,     0,   209,     0,     0,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,  3527,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,  3528,     0,     0,     0,     0,     0,     0,     0,   226,
       0,     0,     0,   227,  3529,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,  -186,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,  3530,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,     0,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,     0,   311,
    -186,     0,   312,     0,     0,   314,     0,     0,   316,   317,
    3531,     0,     0,     0,   319,     0,   320,   321,     0,   322,
     323,   324,     0,     0,   326,     0,     0,   328,     0,   329,
     330,   331,     0,     0,     0,     0,   332,     0,     0,   333,
     334,   335,     0,     0,   336,     0,     0,     0,   337,     0,
     339,     0,     0,   341,   342,   343,     0,     0,     0,     0,
       0,     0,   344,   345,     0,   346,     0,     0,   347,     0,
       0,     0,   349,     0,     0,     0,   351,     0,   352,   353,
     354,     0,     0,     0,   355,   356,   357,   358,     0,   359,
     360,     0,   361,   362,     0,     0,   363,   364,   365,   366,
     367,     0,     0,     0,     0,     0,   368,     0,   369,     0,
       0,     0,   371,   372,   373,     0,     0,   374,   375,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,     0,   380,   381,     0,     0,     0,     0,     0,
       0,     0,   382,     0,     0,   383,     0,     0,   384,   385,
     386,     0,     0,  -186,     0,   387,     0,   388,     0,     0,
       0,     0,   390,     0,     0,     0,   122,  3532,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,     0,     0,     0,   130,   131,   132,     0,     0,  -186,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,     0,     0,     0,
       0,   144,     0,   145,     0,   146,     0,     0,     0,     0,
     149,   150,  3525,     0,   152,     0,   153,   154,     0,     0,
     156,     0,   158,   159,     0,     0,   160,     0,   161,   162,
       0,     0,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,     0,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,     0,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,     0,   184,   185,   186,     0,     0,   187,     0,
     188,   189,     0,     0,     0,   191,     0,   192,     0,     0,
     193,   194,  3526,     0,   195,   196,   197,     0,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
       0,   209,     0,     0,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,  3527,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,  3528,     0,     0,     0,
       0,     0,     0,     0,   226,     0,     0,     0,   227,  3529,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
    -186,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,  3530,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,     0,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,     0,   311,  -186,     0,   312,     0,     0,
     314,     0,     0,   316,   317,  3531,     0,     0,     0,   319,
       0,   320,   321,     0,   322,   323,   324,     0,     0,   326,
       0,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,     0,   339,     0,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,     0,   349,     0,     0,
       0,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
       0,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,     0,   371,   372,   373,
       0,     0,   374,   375,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,  -186,     0,
     387,     0,   388,     0,     0,     0,     0,   390,     0,     0,
       0,   122,  3532,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,     0,     0,     0,   130,
     131,   132,     0,     0,  -186,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,     0,     0,     0,     0,   144,     0,   145,     0,
     146,     0,     0,     0,     0,   149,   150,  3525,     0,   152,
       0,   153,   154,     0,     0,   156,     0,   158,   159,     0,
       0,   160,     0,   161,   162,     0,     0,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,     0,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,     0,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,     0,   184,   185,
     186,     0,     0,   187,     0,   188,   189,     0,     0,     0,
     191,     0,   192,     0,     0,   193,   194,  3526,     0,   195,
     196,   197,     0,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,     0,   209,     0,     0,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,  3527,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,  3528,     0,     0,     0,     0,     0,     0,     0,   226,
       0,     0,     0,   227,  3529,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,  -186,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,  3530,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,     0,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,     0,   311,
    -186,     0,   312,     0,     0,   314,     0,     0,   316,   317,
    3531,     0,     0,     0,   319,     0,   320,   321,     0,   322,
     323,   324,     0,     0,   326,     0,     0,   328,     0,   329,
     330,   331,     0,     0,     0,     0,   332,     0,     0,   333,
     334,   335,     0,     0,   336,     0,     0,     0,   337,     0,
     339,     0,     0,   341,   342,   343,     0,     0,     0,     0,
       0,     0,   344,   345,     0,   346,     0,     0,   347,     0,
       0,     0,   349,     0,     0,     0,   351,     0,   352,   353,
     354,     0,     0,     0,   355,   356,   357,   358,     0,   359,
     360,     0,   361,   362,     0,     0,   363,   364,   365,   366,
     367,     0,     0,     0,     0,     0,   368,     0,   369,     0,
       0,     0,   371,   372,   373,     0,     0,   374,   375,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,  3615,
       0,     0,     0,   380,   381,     0,     0,     0,     0,     0,
       0,     0,   382,     0,     0,   383,     0,     0,   384,   385,
     386,     0,     0,  -186,     0,   387,     0,   388,     0,     0,
       0,     0,   390,     0,     0,     0,   122,  3532,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,  1619,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,  1620,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,  1622,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,  1623,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,   718,   719,     0,   275,     0,     0,  1625,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,  3722,  3712,  3723,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,     0,     0,
     350,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
       0,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,   370,   371,   372,   373,
       0,  1636,   374,   375,     0,     0,   376,     0,     0,     0,
       0,   377,     0,     0,   378,     0,   379,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,   389,     0,     0,   122,   390,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,  2349,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,  2350,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,  1978,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,   565,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,  1979,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,     0,     0,
     350,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
     566,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,   370,   371,   372,   373,
       0,     0,   374,   375,     0,     0,   376,     0,     0,     0,
       0,   377,     0,     0,   378,     0,   379,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,   389,     0,     0,   122,   390,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,  2359,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,  2360,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,   565,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,     0,     0,
     350,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
     566,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,   370,   371,   372,   373,
       0,     0,   374,   375,     0,     0,   376,     0,     0,     0,
       0,   377,     0,     0,   378,     0,   379,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,   389,     0,     0,   122,   390,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,  2349,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,  2350,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,   565,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,     0,     0,
     350,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
     566,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,   370,   371,   372,   373,
       0,     0,   374,   375,     0,     0,   376,     0,     0,     0,
       0,   377,     0,     0,   378,     0,   379,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,   389,     0,     0,   122,   390,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,   722,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,   565,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,     0,     0,
     350,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
     566,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,   370,   371,   372,   373,
       0,     0,   374,   375,     0,     0,   376,     0,     0,     0,
       0,   377,     0,     0,   378,     0,   379,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,   389,     0,     0,   122,   390,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,   674,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,   675,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,     0,     0,
     350,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
     676,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,   370,   371,   372,   373,
       0,     0,   374,   375,     0,     0,   376,     0,     0,     0,
       0,   377,     0,     0,   378,     0,   379,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,   389,     0,     0,   122,   390,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,  2398,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,   565,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,     0,     0,
     350,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
     566,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,   370,   371,   372,   373,
       0,     0,   374,   375,     0,     0,   376,     0,     0,     0,
       0,   377,     0,     0,   378,     0,   379,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,   389,     0,     0,   122,   390,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,  2349,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,   565,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,     0,     0,
     350,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
     566,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,   370,   371,   372,   373,
       0,     0,   374,   375,     0,     0,   376,     0,     0,     0,
       0,   377,     0,     0,   378,     0,   379,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,   389,     0,     0,   122,   390,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,   565,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,     0,     0,
     350,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
     566,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,   370,   371,   372,   373,
       0,     0,   374,   375,     0,     0,   376,     0,     0,     0,
       0,   377,     0,     0,   378,     0,   379,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,   389,     0,     0,   122,   390,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,  2339,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,     0,     0,
     350,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
     566,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,   370,   371,   372,   373,
       0,     0,   374,   375,     0,     0,   376,     0,     0,     0,
       0,   377,     0,     0,   378,     0,   379,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,   389,     0,     0,   122,   390,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,  3654,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,  3655,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,     0,     0,
     350,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
       0,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,   370,   371,   372,   373,
       0,     0,   374,   375,     0,     0,   376,     0,     0,     0,
       0,   377,     0,     0,   378,     0,   379,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,   389,     0,     0,   122,   390,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,   741,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,     0,     0,
     350,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
       0,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,   370,   371,   372,   373,
       0,     0,   374,   375,     0,     0,   376,     0,     0,     0,
       0,   377,     0,     0,   378,     0,   379,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,   389,     0,     0,   122,   390,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,  1117,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,     0,     0,
     350,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
       0,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,   370,   371,   372,   373,
       0,     0,   374,   375,     0,     0,   376,     0,     0,     0,
       0,   377,     0,     0,   378,     0,   379,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,   389,     0,     0,   122,   390,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,  1925,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,     0,     0,
     350,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
       0,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,  1926,     0,   369,     0,     0,   370,   371,   372,   373,
       0,     0,   374,   375,     0,     0,   376,     0,     0,     0,
       0,   377,     0,     0,   378,     0,   379,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,   389,     0,     0,   122,   390,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,  2046,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,     0,     0,
     350,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
       0,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,   370,   371,   372,   373,
       0,     0,   374,   375,     0,     0,   376,     0,     0,     0,
       0,   377,     0,     0,   378,     0,   379,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,   389,     0,     0,   122,   390,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,     0,     0,
     350,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
     566,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,   370,   371,   372,   373,
       0,     0,   374,   375,     0,     0,   376,     0,     0,     0,
       0,   377,     0,     0,   378,     0,   379,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,   389,     0,     0,   122,   390,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,  1925,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,     0,     0,
     350,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
       0,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,   370,   371,   372,   373,
       0,     0,   374,   375,     0,     0,   376,     0,     0,     0,
       0,   377,     0,     0,   378,     0,   379,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,   389,     0,     0,   122,   390,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,     0,     0,
     350,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
       0,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,   370,   371,   372,   373,
       0,     0,   374,   375,     0,     0,   376,     0,     0,     0,
       0,   377,     0,     0,   378,     0,   379,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,   389,     0,     0,   122,   390,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,  1417,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,  1418,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,   338,   339,   340,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,   348,   349,     0,     0,
     350,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
       0,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,   370,   371,   372,   373,
       0,     0,   374,   375,     0,     0,   376,     0,     0,     0,
       0,   377,     0,     0,   378,     0,   379,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,   389,     0,     0,   122,   390,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,     0,     0,     0,   130,   131,   132,     0,     0,     0,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,     0,     0,     0,
       0,   144,     0,   145,     0,   146,     0,     0,     0,     0,
     149,   150,     0,     0,   152,     0,   153,   154,     0,     0,
     156,     0,   158,   159,     0,     0,   160,     0,   161,   162,
       0,     0,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,     0,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,     0,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,     0,   184,   185,   186,     0,     0,   187,     0,
     188,   189,     0,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
       0,   209,     0,     0,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,     0,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,     0,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,     0,   311,     0,     0,   312,     0,     0,
     314,     0,     0,   316,   317,     0,     0,     0,     0,   319,
       0,   320,   321,     0,   322,   323,   324,     0,     0,   326,
       0,     0,   328,     0,   329,   330,   331,     0,     0,     0,
       0,   332,     0,     0,   333,   334,   335,     0,     0,   336,
       0,     0,     0,   337,     0,   339,     0,     0,   341,   342,
     343,     0,     0,     0,     0,     0,     0,   344,   345,     0,
     346,     0,     0,   347,     0,     0,     0,   349,     0,     0,
       0,   351,     0,   352,   353,   354,     0,     0,     0,   355,
     356,   357,   358,     0,   359,   360,     0,   361,   362,     0,
       0,   363,   364,   365,   366,   367,     0,     0,     0,     0,
       0,   368,     0,   369,     0,     0,     0,   371,   372,   373,
       0,     0,   374,   375,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,     0,   380,   381,
       0,     0,     0,     0,     0,     0,     0,   382,     0,     0,
     383,     0,     0,   384,   385,   386,     0,     0,     0,     0,
     387,     0,   388,     0,     0,     0,     0,   390
};

static const short yycheck[] =
{
       7,   467,   468,   469,   505,   471,   455,   473,   475,   606,
     980,   752,    19,  1315,   430,    22,   729,   730,   731,   768,
     769,   770,    29,   629,   530,   501,   502,  1188,   774,  1033,
    1315,   655,    39,  1224,  1794,   689,  1982,   631,  1096,   108,
    1876,   110,    49,    22,  1935,   834,  1904,   582,  1397,  1336,
     656,  1190,  1191,  1192,  2090,   531,  1343,  1960,  1928,  1929,
    1930,   655,  2375,  2108,  1203,  1968,  1540,  1970,  1222,  1967,
    2115,  2735,  1216,  1332,  2324,  1506,  1110,  1644,     3,  1553,
      87,   462,   588,  1919,  1278,  2720,   835,  1942,  1943,  1354,
    1355,    56,     3,    18,    18,     3,  1997,     3,     3,  2712,
     107,   108,    16,   110,     3,    32,     3,     3,    87,  1453,
    2001,    16,  1256,   862,   121,     3,    16,   863,  1257,  1058,
     866,  1260,  1061,    10,   600,   514,   875,   876,   877,   693,
    2021,  2022,    18,  1072,  1073,  1195,  1196,    95,  1198,    49,
      34,    59,   121,    16,   885,   886,   887,    54,   693,    18,
    1289,  1290,  1346,    27,  1348,  1294,    58,    69,    28,  2084,
    1991,  1649,    34,   135,   905,    20,  1997,    20,   115,  2000,
      55,    56,  2003,  1233,   229,  1314,   657,  1316,   175,    32,
     130,    60,  2765,  2014,  2015,  2768,   175,    11,  1248,  1520,
     156,   697,  2023,    46,   169,   115,    59,   229,    63,  2990,
      55,    56,    55,    56,  2787,   111,  1266,  1267,  1268,  1647,
    2793,  1114,   593,  1183,   630,   111,   147,  1277,   156,    20,
     145,   145,  2080,   689,   700,    63,   217,    11,  1288,  2419,
    2997,    32,    58,    77,    61,   175,   129,   172,    20,   214,
     156,   145,    32,  2826,   252,    46,   341,   238,   270,   156,
      32,   175,   159,    96,    55,    56,    34,   111,   253,   145,
      64,    66,   205,   347,    46,   172,  3534,   413,   170,   236,
      94,   131,   214,    55,    56,   324,   145,  1992,  1993,    58,
     407,    12,   249,   287,    32,   263,   108,  2311,    49,   430,
      64,  2647,  2994,   113,    38,   344,   476,   236,  1966,   221,
     415,    12,   417,   223,   419,   107,   421,   229,    56,   203,
     453,   540,   289,    12,   107,   343,   234,   214,   111,    12,
     573,  2996,   100,   361,   474,    19,  2939,    94,   112,   107,
     517,   203,  3445,   361,    97,   558,   516,   100,  2317,   126,
     138,   499,   253,    50,   170,   253,   229,    89,   498,    97,
     148,    58,   100,   540,   253,   179,   585,   352,  3149,   217,
     108,  2717,   585,  3038,   166,   253,  1530,   344,   390,   252,
    2394,   234,   287,   166,   217,   149,   120,   381,  1542,  1543,
     158,  1545,  1546,  1547,   270,  1952,  1550,   175,   166,   532,
     214,  1555,   299,    12,   125,  1559,  1560,  1561,   899,   269,
    1564,  1565,  1566,  1567,  1568,   227,  1570,  1571,  1572,   416,
     203,     8,   179,   331,   125,   229,   382,   532,   145,   426,
     673,    40,   116,   430,   567,   203,   125,   585,   435,  1590,
    1084,  1037,   125,   440,  1595,   357,   321,   583,  3021,  1045,
    1601,    37,   583,  1604,   382,   172,   912,  3030,  3716,   416,
     270,   455,  3087,   352,   930,   462,   435,   526,   585,   528,
     529,   499,    81,   405,   352,   267,   382,    86,  1074,  1075,
     372,   499,   479,   412,   267,   382,   361,  1915,  3180,  3181,
     430,  2427,   489,   337,  2382,  1020,   493,   374,  2358,   267,
     585,   540,   499,  1239,   501,   502,   356,   287,   476,   506,
     507,   411,  1096,    52,   390,  3618,   590,   983,   405,   516,
     489,   204,   395,   520,    49,  2416,  1655,   993,   525,   526,
    2390,   528,   529,   530,   531,  2092,   313,  1430,  3141,  2430,
     585,   526,  1038,   476,   404,  2725,   338,   381,   560,  1103,
    1574,   573,   330,   447,  3179,   338,   372,   325,   556,   353,
     374,   258,   350,   446,   158,   473,   334,   564,  1103,   337,
     338,  1500,  1308,   390,   539,  2039,   484,   164,   984,   391,
     354,   376,   538,   580,  3341,  2500,   455,  1921,   326,   353,
    1115,   588,   589,   548,   471,  2416,   593,   534,   585,  1070,
     971,  1730,   583,   600,   552,  1734,   585,   569,  1162,  2430,
     538,   580,  1904,  2091,  1345,   499,  2080,   374,  3399,   521,
     589,   476,   231,   994,   534,   394,   540,  1162,  1084,  1904,
    1361,   484,   553,   630,   511,   527,  1820,   499,  1959,  1768,
    2943,  1825,  1826,   583,   508,   508,  1025,   587,   476,   508,
    1831,  1795,  1833,   561,   584,   556,  1387,   585,   556,   584,
     411,  2089,   495,   558,    12,    13,   583,   556,  1107,   573,
     482,   585,   584,  1817,  2914,   552,   591,  1969,   556,   585,
     525,   495,   525,   573,   560,   585,   418,  2656,   585,  3314,
     591,   300,   689,   591,  1969,   591,   591,   557,   493,   572,
     697,   590,   591,   700,   591,   591,   703,   704,   551,  2414,
     498,   527,   590,   591,   589,   453,   289,   512,   430,  3373,
      58,   559,    28,   301,  3378,  2383,  2384,   164,   520,    67,
     447,   499,  2024,   501,   525,   704,   504,   520,   495,    87,
     583,    79,   739,   337,   741,  1116,   514,  1797,   501,  2024,
     359,   504,   520,   525,   558,   523,  3381,  1213,   325,  1165,
     214,    94,   430,   191,    70,   253,   504,   115,   177,   573,
     739,   344,   741,  2330,  2331,   547,   548,   107,   325,  3082,
     499,   129,   465,   466,   467,   468,   469,   470,    75,  3362,
    2650,  3364,   430,   430,   532,   552,   335,   112,   481,   179,
     577,   578,   579,   151,   407,  2653,   243,   575,   576,  2702,
     335,   107,    12,  2706,  2702,   163,   270,    12,  2706,   112,
     406,   175,  1973,   179,   426,   221,   430,   105,  2688,   430,
     258,  2722,   170,   229,   420,   141,   166,    94,  2664,   407,
     178,  3466,  1298,   113,   192,   178,  1302,   349,  1339,   430,
     459,  2002,   526,  2004,  2008,   441,   475,     4,  2009,  3432,
     479,  3434,     9,    10,   352,  2019,   585,  2122,  2123,   217,
     166,   583,   226,   203,  2025,   223,  2027,  2028,  2029,   217,
      27,   490,  1496,   325,   217,    32,   411,   495,   175,    36,
    3544,  3012,  1488,   890,  3015,   892,   174,  1393,   335,   335,
     238,  2722,  1498,  1499,  3507,   158,  1502,  1503,  1433,   512,
     584,  1525,  1496,   228,   262,   583,   107,    23,  1443,   497,
     514,   446,   179,   258,  1330,   125,   325,   924,   382,   499,
     125,   209,   499,   930,   204,   228,   530,   267,  1404,  1435,
    1436,  1525,  1467,   511,   522,   583,   583,  2504,  1942,  1943,
     587,   360,   499,  2374,   172,   924,   523,  2983,    64,   398,
     217,   357,    68,   399,   545,   546,  2814,  1026,  1027,   116,
     967,   267,   969,  2818,   971,   166,   523,  1036,    68,   583,
    1386,  3016,   583,   270,   508,  1044,   983,   984,    12,  2173,
      80,   540,  1398,   455,   374,   175,   993,   994,   352,  2276,
     270,   336,   583,    71,    72,   111,  1531,  1004,   338,   455,
     583,  1971,   203,  2262,  2038,     0,   583,   445,   374,   589,
    2312,  3675,  3262,   476,  1953,  1464,     3,   375,   306,  1026,
    1027,  1028,  1029,   472,   372,   584,   314,  2312,   370,  1036,
    2174,  1038,   338,   111,   262,   454,   394,  1044,   510,   229,
     267,   175,   400,   383,  3528,  3529,   386,   499,   406,  1028,
    1029,   585,   229,  2113,   370,   133,  1591,  1592,  2118,  1594,
    1067,  1596,  1597,  1598,  1599,  1600,   267,  1602,  1603,   332,
     333,   523,   430,  2133,   337,   252,   392,  2975,  2976,   191,
    2140,   145,    76,  1824,  2433,  3216,   549,   165,  1067,     8,
     499,   125,   380,   451,   452,  2155,  2156,  2967,    92,  1168,
    1169,   417,  2162,   370,   107,   495,  1113,   374,    27,  1116,
    2170,   338,   460,   420,   523,  3151,  2270,   460,   555,   253,
      12,    13,   238,  2277,  2094,  2017,   495,    88,   555,   495,
     488,   583,   569,  3617,  1113,   362,  1541,   338,  3451,  1544,
     428,   241,   569,  2035,  2711,   435,   258,    67,  1553,  2209,
     440,   351,   495,   496,   354,   332,   333,  1562,  1165,   475,
    1167,  1168,  1169,   166,  1171,  2295,  2296,  2297,  3213,   217,
     275,   276,    54,  1180,   583,  1182,   534,   555,   536,   527,
     520,    34,   112,  3496,   527,   145,   146,   430,   590,   496,
     238,   569,  1171,   508,   537,    87,  2326,  2327,  2328,   390,
     203,    88,    16,   446,   493,    88,   495,    20,   213,  1216,
      68,   311,   403,    88,   520,    28,   332,   333,   395,   495,
      33,   337,    80,   115,   184,   496,  3084,  2287,   344,   496,
     537,   217,  3363,   345,  3365,   335,   583,   129,   198,  2713,
    2714,  2715,   213,   590,   511,   552,  1712,   100,   537,  1256,
     170,   514,   443,   493,   107,   495,   372,   347,   219,   151,
      55,    56,  3165,   121,   267,   422,   554,   530,  2742,    64,
     537,   163,   232,   548,   156,   236,   551,   159,   566,   192,
     437,   458,   332,   333,   244,   552,   443,   583,   249,   389,
     172,   396,   397,   520,   590,  2515,   175,   217,   956,  2519,
     192,   959,   545,   546,   962,   158,   463,  3415,  1315,  3417,
    3570,   271,   226,   166,  1780,   393,   449,   450,   238,   520,
     575,   576,   558,  1330,  1412,   217,  1414,   270,   444,    15,
      16,   223,   219,   445,   584,   338,   219,  2624,   584,   585,
     583,  2532,  2533,   590,   219,   584,   585,   145,  3608,   236,
     203,  3010,  3011,   236,   471,  2657,    11,  1445,  1446,  1447,
     583,   236,   249,   324,   457,   458,   249,   460,   328,  3028,
     262,   471,  2657,   152,   249,  3034,   405,   290,   291,  1386,
     540,   294,   295,   241,  1391,   373,  1393,  1922,  3648,  2754,
     344,  1398,  2757,  2758,   420,   572,   573,  1404,  3057,  1406,
     349,  3060,   493,  3663,  1411,  1412,   344,  1414,  2710,  2774,
     585,   527,  3672,   214,   267,   584,   585,   299,    47,  1426,
      88,   175,  1429,   584,   585,  2710,   120,   263,  1435,  1436,
    1437,  1438,  1411,  1412,  2736,  1414,    47,   324,  1445,  1446,
    1447,   324,   584,   585,   585,    13,  3706,  1426,  3708,   324,
    1429,  2736,   372,   311,   344,   416,  1463,   344,  1437,  1438,
     463,   344,   584,   585,   526,  1472,  1445,  1446,  1447,   344,
    2005,  2006,   325,   426,   332,   333,  2265,   335,   584,   585,
    3316,   577,  1489,   375,   337,   338,   145,   468,   469,   263,
     471,  2026,   473,   150,  1501,  2553,   584,   585,   584,   585,
     382,   516,   394,   584,   585,   164,  1513,   446,   400,   584,
     585,   205,  1519,  1929,   406,  1931,  1932,   520,   583,    87,
     481,   253,  1501,   584,   585,   184,   584,   585,  2748,   416,
    2660,   389,  2273,   416,   172,   584,   585,   287,   430,   198,
    1519,   416,   584,   585,   584,   585,  1615,   115,   584,   585,
     263,   219,   584,   585,   584,   585,   493,  2617,  2007,   451,
     452,   129,  2782,  2783,   476,  1981,  1982,   476,   236,   263,
    2790,  1578,   142,  2286,   584,   585,   476,  2797,   584,   585,
    1587,   249,    78,   151,   243,   244,   585,  3478,    55,    56,
    1352,  1353,  3462,   287,   481,   163,   488,   346,   481,   476,
       3,  2017,  3548,   489,   584,   585,   481,   584,  1615,  3369,
     584,   585,   271,   471,   429,    18,  3501,   584,   585,  2035,
     584,   585,   584,   585,   192,   584,   585,   584,   585,  2820,
    1356,  1357,  1358,  1359,  1360,  1642,  2938,   552,  1645,   584,
     585,    52,   534,   399,   536,   152,   499,   583,   501,   217,
     211,   504,   585,  2938,     3,   223,   324,     6,   584,   585,
    2126,   514,   589,  1642,    13,  1354,  1355,   520,  2134,   585,
     523,   330,   552,     3,    23,    24,   584,   585,   583,   373,
     584,   585,   584,   585,   590,    88,   583,   381,    18,  3574,
     584,   585,  2108,   563,   262,   584,   585,  2714,  2715,  2115,
    2891,  1299,  1300,    47,    53,  3590,   590,  3592,    57,   585,
     584,   585,   371,   584,   585,   409,   584,   585,   583,    68,
     584,   585,   575,   576,   584,   585,   583,  2324,    77,   584,
     585,   574,   584,   585,    83,   584,   585,   584,   585,   584,
     585,  2365,   145,   584,   585,   583,  3631,    96,   416,  3634,
     584,   585,  3186,  3187,  2666,  2667,   583,  3642,    88,  2636,
    2637,   455,   111,  2928,  2929,   114,   169,  2373,   580,   172,
     589,  2365,   583,   583,   123,   124,   583,   583,   583,   583,
     129,   583,   476,   583,  3669,   493,   583,   583,   137,   583,
     583,   583,   195,   583,   143,  3680,  1803,   583,   201,   493,
     583,   495,   583,  2309,  2339,   583,   583,   375,  3693,   499,
     583,   214,   583,   481,  2818,   145,   219,   583,   583,   583,
     169,   583,   583,   226,   583,   583,   394,   287,   583,   258,
     583,   583,   400,   236,   585,  3720,  3721,   583,   406,  3724,
     583,  2257,   172,   583,   583,   583,   249,   583,   583,  2355,
     253,   585,   583,   583,   583,   583,   583,   583,   583,   262,
    2920,   583,   430,   583,   583,   195,   215,   583,   217,   583,
     287,   201,   583,   583,   583,   224,   583,   583,   583,   583,
     583,   583,   583,   451,   452,   583,   583,   583,   583,   219,
     583,   583,   583,  2428,   583,   583,   226,  1904,   583,   583,
    2435,   583,   583,   583,   583,   583,   236,   583,   583,   583,
      23,    24,   583,   583,   583,  1922,  1923,   583,   583,   249,
     488,   324,  1929,   253,  1931,  1932,   508,   583,   508,   583,
     583,   583,   262,   583,   583,   583,   583,   583,   583,  2680,
     583,   344,   583,   292,    57,   558,   583,   583,   583,   352,
     583,   583,   583,   583,   229,    68,   583,   583,   307,   583,
     583,   583,  1969,   312,    77,   585,   534,   585,   536,   585,
     585,   374,   499,   585,  1981,  1982,   585,   577,   172,   230,
     491,   160,   172,    96,  1991,   533,   585,   585,  2464,   457,
    1997,   363,   583,  2000,   324,   584,  2003,   585,   111,   145,
    2970,   114,   145,   352,   145,   145,   145,  2014,  2015,   358,
    2017,  2427,   361,   416,   344,   145,  2023,  2024,   145,   145,
     145,   145,   352,   145,   145,   145,  2033,   145,  2035,   145,
     143,   585,  2039,  2040,   535,   384,   385,   584,   387,    45,
     344,   179,   175,   446,   374,    64,    12,   584,   499,   584,
     125,     9,   401,   584,  2033,   584,   555,   590,   584,   583,
     252,   576,   585,   390,   556,   218,   175,   584,   590,   192,
     455,   381,  2079,  2080,   423,   446,   585,   585,   481,   172,
      45,    23,    24,   471,   471,   471,   416,   471,   471,   429,
      67,   122,  2805,  3395,   508,   237,   494,   494,   122,    45,
    2079,  2108,   237,   585,   217,   585,   540,   590,  2115,   585,
     584,   224,   584,    55,    56,    57,   446,    18,   175,   585,
     584,  2128,    64,   526,   585,   584,    68,   584,   584,   584,
     584,   584,   577,   585,   584,    77,   539,   540,  3277,   585,
    3301,  3302,  3303,  3304,   584,   588,   585,   585,   584,   584,
     447,   481,   585,   556,    96,   558,   584,   584,   590,   585,
     585,   585,   585,   585,   584,   583,   585,  2174,   517,   111,
     585,   584,   114,   585,   583,   585,   584,   526,   585,   292,
     585,   584,   585,   584,   262,   585,   585,   583,   591,   584,
     508,   585,   585,   585,   307,   584,   526,   560,   499,   573,
     590,   143,   583,   585,  3506,   584,   584,   584,   584,   584,
     540,  2924,   273,   274,   275,   276,   277,   278,   585,   584,
     281,   282,   283,   284,   285,   286,   556,   288,   558,   584,
     584,  3291,   584,   584,   584,   508,   585,   585,   584,   584,
     508,   584,   591,   585,   585,   358,   585,   585,   361,   584,
    2257,   584,   584,  2669,   584,   585,   584,   258,   508,   585,
     585,   591,   584,   584,   349,   585,   585,   584,   584,  2685,
     585,   384,   385,   584,   387,   217,   584,   584,   584,   584,
     583,  2288,   224,   585,   175,  2292,   175,  2294,  2295,  2296,
    2297,   590,   585,   175,   226,   175,   590,   233,  2305,   590,
     558,   338,  2309,   585,   355,  2312,   236,   236,   303,    96,
     423,    96,   238,   238,   583,   499,   590,  2914,   583,  2326,
    2327,  2328,   583,   352,   577,   584,  2305,   584,   225,   338,
     338,   175,  2339,   175,   175,   396,   397,   584,  2345,   584,
    2347,   584,   338,   570,   141,   584,   584,   577,  2355,   590,
     292,   584,   584,   590,   590,     7,   584,   583,   344,   214,
     585,   584,   175,   534,  3666,   307,   590,    19,   229,   250,
      22,    64,   275,   236,   236,   344,   585,    29,   238,   238,
     585,  3666,    18,   344,    18,  3687,   584,    39,    18,   253,
     583,   227,   227,   584,   583,    23,    24,    49,   584,   584,
     583,  3703,   584,   584,   517,   585,   584,   584,   584,  2416,
     584,   584,   584,   526,   584,   590,   358,   584,  3703,   361,
    2427,   584,   584,  2430,   585,   584,   584,    55,    56,    57,
     584,   132,   584,   584,  2969,    87,    64,  3183,  3184,  3185,
      68,  3602,   384,   385,   247,   387,  3100,   430,   585,    77,
     584,   195,   584,   584,   590,   107,   108,  2464,   110,   448,
     570,   145,   355,   236,  2471,   584,   583,  2474,    96,   121,
     584,  2478,  2479,   585,   585,  2482,   584,  3226,   585,   584,
     584,   423,   584,   111,   584,  2492,   114,   584,   584,   584,
     584,   236,   584,   584,   584,  2474,   101,   102,   103,   104,
     105,   584,  3037,   584,   111,   585,   585,   584,   584,   111,
     584,   584,   584,  2492,   585,   143,   585,   584,   584,   584,
     584,   584,    23,    24,   583,   585,   584,   338,   584,   584,
     584,   583,   585,  3246,  3247,   584,  3697,  2953,   585,   584,
     583,   585,   583,   369,   583,   583,   338,   583,  3709,   583,
     590,   584,   584,  3207,    55,    56,    57,   584,   584,   442,
     338,    41,   381,    64,  3013,   558,  3220,    68,   584,   174,
     584,   584,   584,  3734,   338,   517,    77,   584,   226,   584,
     590,   585,    45,   201,   526,   585,   310,   499,   390,   217,
     499,  3126,   236,   540,   172,    96,   224,   540,   583,   583,
    3016,   206,   207,   208,   209,   583,   338,   338,   583,    32,
     111,  3360,   551,   114,   551,   583,   338,   534,   111,   238,
    3036,   238,   337,   558,   252,   338,   338,   338,   338,   338,
     584,   519,   585,   583,  3100,   584,   584,   310,   154,   584,
     584,   499,   143,   585,   584,   499,   499,   585,   238,    66,
    2657,  2658,   585,  2660,   585,    16,   584,   584,   334,   236,
     584,  3374,  2669,   584,   292,  3262,   107,   540,  2675,   584,
     584,   584,   540,   584,   584,   546,   584,   584,  2685,   307,
     584,   172,   584,   338,   584,   584,  2693,   585,   584,   584,
     584,   338,   584,   349,   584,   534,   495,   302,   584,   304,
     305,   306,   255,  2710,   276,   583,   585,   584,   583,   314,
      58,   583,   349,    58,   584,  2722,   217,   584,  3253,   584,
     374,    45,  2729,   224,    45,   166,   138,   584,   584,  2736,
     358,    45,   145,   361,   394,  2742,     5,   349,  3154,   349,
     134,  3207,   413,    45,   584,    45,    45,   585,   585,   121,
     584,   584,   424,    16,  3220,   555,   384,   385,   588,   387,
     592,   583,   203,   280,   416,   175,   555,   584,   145,   226,
     141,   591,   584,   213,   426,   380,   585,   570,   430,  3433,
     555,   141,   109,   435,   269,   591,   128,   592,   440,   214,
     571,   292,   338,   591,   585,   423,   570,  3213,   141,   583,
     199,   591,   585,   141,   255,   446,   307,   172,   571,  2816,
     462,   404,   570,   172,   172,  3469,  3470,   111,  3472,   557,
     546,   173,   427,   428,  3596,  1850,   267,   479,  3257,  1605,
    3377,  3250,  3734,  3697,  3705,  3628,  3587,   489,  3628,  3594,
    3083,   493,   410,   695,  2812,  3178,  2080,   499,  1162,   501,
     502,  1103,  2742,  1574,   506,   507,  2042,   358,    44,  3513,
     361,  3515,  3516,  1578,   516,  3578,  1995,  1540,   520,  2798,
    2729,  3205,  3045,   525,   526,  2999,   528,   529,   530,   531,
    3036,  2765,  2685,   384,   385,  2765,   387,  3421,  2730,   517,
    3430,  3197,  3346,  2087,   335,  1175,  3264,   338,   526,  3220,
    2038,  1508,  1899,  3370,  1158,  1437,  2305,   474,  2915,  3622,
     704,  1881,   564,  1081,   618,  1913,   688,  3311,  1452,  3126,
    2923,   107,   423,  2924,  2116,  2700,  3420,  1203,   580,  1253,
    1351,  2938,  2278,  1349,  3175,  3622,   588,   589,  3154,  2736,
    1918,   593,  1877,   971,  3445,  1903,  2953,  2652,   600,   554,
    2938,  2651,   994,  2710,  3687,   583,  3506,   464,  1180,   741,
     565,   566,   521,   455,   999,  2642,  1403,  3433,  3577,  1497,
    3408,  3597,  3476,  3703,  3038,  2657,  2357,  1458,   630,  2693,
     166,  2964,  1012,  3162,  1002,  1429,   447,  2994,   601,  3299,
     431,   964,   433,   434,   435,   436,   437,   438,   439,   440,
    2292,  1167,  3305,  3469,  3470,   448,  3472,   605,  3122,  3016,
     491,  2078,  1325,  2809,   200,  3080,   517,   203,   737,    -1,
      -1,    -1,    -1,    -1,    -1,   526,    -1,    -1,    -1,  3036,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   689,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   697,    -1,  3513,   700,  3515,
    3516,   703,   704,    -1,  3061,    -1,  3063,    -1,    -1,  3508,
      -1,    -1,    -1,    -1,    -1,    -1,  3073,    -1,    -1,    -1,
      -1,    -1,  3079,    -1,    -1,    -1,    -1,    -1,    -1,   520,
      -1,   267,    -1,    -1,    -1,    -1,    -1,   739,    -1,   741,
      -1,    -1,     6,    -1,  3073,    -1,    -1,    -1,    -1,    13,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    23,
      24,    -1,    -1,    -1,    -1,    -1,    -1,  3618,    -1,  3126,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3501,    -1,  3548,    -1,    -1,    -1,    -1,    -1,    -1,    53,
      -1,    -1,    -1,    57,    -1,    -1,    -1,  3154,    -1,   335,
      -1,    -1,   338,    -1,    68,    -1,    -1,  3528,  3529,    -1,
      -1,    -1,    -1,    77,    -1,    -1,    -1,  3174,    -1,    83,
      -1,    -1,    -1,  3180,  3181,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    -1,    -1,    -1,    -1,  3194,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   111,  3569,  3570,
     114,    -1,    -1,  3574,    -1,    -1,  3213,    -1,  3709,   123,
      -1,    -1,    -1,    -1,    -1,   129,    -1,    -1,    -1,  3590,
      -1,  3592,    -1,   137,    -1,    -1,    -1,    -1,    -1,   143,
      -1,    -1,    -1,  3734,    -1,    -1,    -1,  3608,   890,   425,
     892,    -1,    -1,    -1,  3251,   431,  3617,   433,   434,   435,
     436,   437,   438,   439,   440,   169,    -1,  3264,    -1,    -1,
    3631,    -1,    -1,  3634,    -1,    -1,  3732,  3683,    -1,    -1,
      -1,  3642,   924,    -1,    -1,    -1,    -1,  3648,   930,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3663,    -1,    -1,    -1,    -1,    -1,  3669,    -1,
      -1,  3672,    -1,   217,    -1,    -1,    -1,    -1,    -1,  3680,
     224,    -1,    -1,    -1,    -1,   967,    -1,   969,    -1,   971,
      -1,    -1,  3693,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   983,   984,    -1,   520,  3706,    -1,  3708,    -1,    -1,
      -1,   993,   994,    -1,    -1,    -1,    -1,    -1,    -1,  3720,
    3721,    -1,  1004,  3724,    -1,    -1,    -1,    -1,    -1,    -1,
    1012,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3377,    -1,    -1,    -1,  1026,  1027,  1028,  1029,   292,    -1,
      -1,    -1,    -1,    -1,  1036,    -1,  1038,    -1,  3395,  3396,
      -1,    -1,  1044,   307,    -1,    -1,    -1,    -1,   312,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3415,    -1,
    3417,    -1,  3419,  3420,    -1,  1067,    -1,  3396,    -1,    -1,
      -1,    -1,    -1,    -1,  3431,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   352,    -1,
      -1,    -1,    -1,    -1,   358,    -1,    -1,   361,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3467,  1113,    -1,    -1,  1116,    -1,    -1,    -1,    -1,    -1,
     384,   385,    -1,   387,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   401,    -1,    -1,
      -1,    -1,    -1,    -1,  3501,    -1,    -1,    -1,    -1,  3506,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   423,
      -1,    -1,    -1,  1165,    -1,  1167,  1168,  1169,  3525,  1171,
      -1,  3528,  3529,  3530,    -1,    -1,    -1,    -1,  1180,    -1,
    1182,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3548,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3559,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3569,  3570,  1216,    -1,    -1,  3574,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3590,    -1,  3592,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3608,    -1,   517,  1256,    -1,    -1,    -1,    -1,    -1,
    3617,    -1,   526,    -1,    -1,    -1,    -1,  3624,    -1,    -1,
      -1,    -1,    -1,    -1,  3631,    -1,  3633,  3634,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3642,    -1,    -1,    -1,    -1,
      -1,  3648,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3663,    -1,    -1,  3666,
      -1,  3668,  3669,  1315,    -1,  3672,    -1,  3674,    -1,    -1,
      -1,    -1,    -1,  3680,    -1,    -1,  3683,    -1,  1330,    -1,
    3687,    -1,    -1,    -1,    -1,    -1,  3693,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3703,    -1,    -1,  3706,
      -1,  3708,  3709,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3720,  3721,    -1,    -1,  3724,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3734,    -1,    -1,
      -1,    -1,    -1,    -1,  1386,    -1,    -1,    -1,    -1,  1391,
      -1,  1393,    -1,    -1,    -1,    -1,  1398,    -1,    -1,    -1,
      -1,    -1,  1404,    -1,  1406,    -1,    -1,    -1,    -1,  1411,
    1412,    -1,  1414,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1426,    -1,    -1,  1429,    -1,     3,
      -1,    -1,    -1,  1435,  1436,  1437,  1438,    -1,    -1,    13,
      14,    -1,    -1,  1445,  1446,  1447,    -1,    -1,    -1,    -1,
      -1,    -1,    26,    -1,    28,    -1,    -1,    -1,    -1,    -1,
      -1,  1463,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1472,    -1,    -1,    47,    48,    -1,    -1,    -1,    -1,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,  1489,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    -1,  1501,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1513,    -1,    87,    -1,    -1,    -1,  1519,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   115,   116,   117,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   128,   129,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1578,   151,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1587,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1615,    -1,    -1,    -1,    -1,   192,    -1,
      -1,    -1,    -1,    -1,    -1,   199,    -1,    -1,   202,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1642,    -1,    -1,  1645,    -1,    -1,    -1,    -1,    -1,   223,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   239,    -1,    -1,    -1,    13,
      14,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    26,   257,    -1,    -1,    -1,    -1,   262,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    47,    48,    -1,    -1,    -1,    -1,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   115,   116,   117,   348,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   128,   129,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   370,    -1,    -1,    -1,
      -1,  1803,    -1,    -1,    -1,   379,    -1,   151,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   168,   399,    -1,   401,   402,    -1,
      -1,   405,    -1,    -1,   408,    -1,   410,    -1,    -1,    -1,
      -1,   415,    -1,   417,    -1,    -1,    -1,    -1,   192,    -1,
      -1,    -1,   426,    -1,    -1,   199,   430,    -1,   202,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   446,    -1,    -1,    -1,    -1,   451,    -1,   223,
      -1,   455,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   239,    -1,    -1,    -1,    -1,
      -1,   475,  1904,    -1,    -1,   479,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   257,    -1,    -1,    -1,    -1,   262,    -1,
    1922,  1923,    -1,    -1,    -1,    -1,    -1,  1929,    -1,  1931,
    1932,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   531,    -1,    -1,
     534,    -1,    -1,    -1,    -1,   539,    -1,  1969,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1981,
    1982,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   562,  1991,
      -1,    -1,    -1,    -1,    -1,  1997,    -1,    -1,  2000,    -1,
      -1,  2003,    -1,    -1,   348,    -1,    -1,    -1,    -1,   583,
      -1,    -1,  2014,  2015,    -1,  2017,    -1,    -1,    -1,    -1,
      -1,  2023,  2024,    -1,    -1,    -1,   370,    -1,    -1,    -1,
      -1,  2033,    -1,  2035,    -1,   379,    -1,  2039,  2040,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   399,    -1,   401,   402,    -1,
      -1,   405,    -1,    -1,   408,    -1,   410,    -1,    -1,    -1,
      -1,   415,    -1,   417,    -1,    -1,    -1,  2079,  2080,    -1,
     523,    -1,   426,    -1,    -1,    -1,   430,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   446,    -1,    -1,    -1,  2108,   451,    -1,    -1,
      -1,   455,    -1,  2115,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2128,    -1,    -1,    -1,
      -1,   475,    -1,   576,    -1,   479,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    31,    32,    -1,    -1,    -1,
      -1,    37,    -1,    39,    -1,    41,    42,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      56,   515,  2174,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   531,    -1,    -1,
     534,    -1,    -1,    -1,    -1,   539,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    97,    -1,    -1,   100,    -1,    -1,    -1,   562,    -1,
      -1,    -1,   108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   583,
      -1,   127,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2257,    -1,    -1,   144,    -1,
      -1,    -1,    -1,    -1,   707,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   165,
      -1,   167,    -1,    -1,    -1,    -1,  2288,    -1,    -1,    -1,
    2292,    -1,  2294,  2295,  2296,  2297,    -1,    -1,    -1,    -1,
     186,   187,    -1,  2305,    -1,    -1,    -1,  2309,    -1,    -1,
    2312,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2326,  2327,  2328,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2339,    -1,    -1,
      -1,   227,    -1,  2345,    -1,  2347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2355,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   808,    -1,    -1,    -1,    -1,
     256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   265,
     266,    -1,   268,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     296,   297,   298,    -1,  2416,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2427,    -1,    -1,  2430,    -1,
      -1,   317,   318,   319,    -1,    -1,    -1,   323,    -1,    -1,
     326,   884,    -1,    -1,    -1,   888,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2464,    -1,    -1,    -1,    -1,    -1,    -1,  2471,
      -1,    -1,  2474,    -1,    -1,    -1,  2478,  2479,    -1,   365,
    2482,   367,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2492,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   391,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   444,    -1,
     446,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1012,
     456,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1021,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   500,   501,    -1,    -1,   504,   505,
     506,   507,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2657,  2658,    -1,  2660,    -1,
      -1,   547,   548,    -1,    -1,    -1,    -1,  2669,    -1,    -1,
      -1,    -1,    -1,  2675,    -1,    -1,    -1,    -1,    -1,    -1,
     566,    -1,    -1,  2685,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2693,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2710,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2722,    -1,    -1,    -1,    -1,    -1,    -1,  2729,    -1,    -1,
      -1,    -1,    -1,    -1,  2736,    -1,    -1,    -1,    -1,    -1,
    2742,  1184,  1185,  1186,    -1,    -1,    -1,    -1,    -1,    -1,
    1193,  1194,    -1,    -1,  1197,    -1,  1199,  1200,  1201,  1202,
      -1,    -1,    -1,  1206,    -1,    -1,  1209,  1210,    -1,  1212,
      -1,  1214,  1215,    -1,  1217,  1218,  1219,  1220,  1221,    -1,
    1223,    -1,  1225,  1226,  1227,    -1,  1229,  1230,  1231,  1232,
      -1,  1234,  1235,    -1,  1237,    -1,    -1,  1240,  1241,  1242,
      -1,  1244,  1245,  1246,  1247,    -1,  1249,  1250,  1251,  1252,
      -1,    -1,    -1,    -1,  2816,  1258,  1259,    -1,  1261,  1262,
    1263,  1264,  1265,    -1,    -1,    -1,    -1,  1270,    -1,  1272,
    1273,  1274,  1275,  1276,    -1,    -1,  1279,  1280,  1281,  1282,
    1283,  1284,    -1,  1286,  1287,    -1,    -1,    -1,  1291,  1292,
    1293,    -1,  1295,    -1,  1297,    -1,    -1,    -1,  1301,    -1,
    1303,  1304,    -1,    -1,    -1,    -1,  1309,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1317,  1318,  1319,    -1,    -1,    -1,
      -1,    -1,    -1,  1326,    -1,    -1,  1329,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    30,    -1,    32,    33,    -1,    -1,
      -1,    -1,    -1,  2915,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    -1,  2938,    -1,    -1,    65,
      -1,    67,    -1,    -1,    -1,  1388,    -1,    -1,    -1,    -1,
      -1,  2953,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    85,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1432,
      -1,    -1,  2994,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3016,    -1,   142,   143,    -1,    -1,
      -1,   147,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3036,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,  3061,
      -1,  3063,    -1,    -1,    -1,   191,    -1,   193,    -1,    -1,
      -1,  3073,    -1,    -1,    -1,    -1,    -1,  3079,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     216,   217,    -1,    -1,   220,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   237,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3126,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   258,    -1,    -1,    -1,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1589,    -1,    -1,    -1,
      -1,    -1,  3154,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   287,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3174,    -1,    -1,    -1,    -1,    -1,  3180,  3181,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3194,    -1,   320,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   329,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3213,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   373,   374,  3251,
      -1,   377,   378,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   440,    -1,    -1,    -1,    -1,   445,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   455,
      -1,    -1,  1775,  1776,  1777,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1792,
     476,    -1,    -1,    -1,   480,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   495,
      -1,    -1,    -1,    -1,  1817,  3377,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3395,  3396,    -1,    -1,  1840,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3415,    -1,  3417,    -1,  3419,  3420,    -1,
      -1,    -1,    -1,   549,    -1,    -1,    -1,   553,    -1,  3431,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3467,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3506,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3525,    -1,    -1,    -1,    -1,  3530,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3548,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3559,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3624,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3633,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2095,    -1,    -1,  2098,    -1,    -1,  2101,  2102,
      -1,    -1,    -1,    -1,  3666,    -1,  3668,    -1,    -1,    -1,
      -1,  2114,  3674,    -1,  2117,    -1,    -1,    -1,    -1,    -1,
      -1,  3683,    -1,    -1,    -1,  3687,    -1,  2130,    -1,  2132,
      -1,    -1,    -1,  2136,    -1,  2138,  2139,    -1,    -1,    -1,
    2143,  3703,  2145,  2146,    -1,  2148,    -1,  3709,  2151,    -1,
    2153,  2154,    -1,    -1,    -1,    -1,  2159,  2160,    -1,    -1,
    2163,    -1,  2165,    -1,  2167,    -1,  2169,    -1,  2171,    -1,
      -1,    -1,  3734,    -1,    -1,    -1,    -1,    -1,    -1,  2182,
    2183,    -1,    -1,  2186,    -1,  2188,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2196,  2197,    -1,  2199,    -1,  2201,    -1,
      -1,  2204,  2205,  2206,    -1,  2208,    -1,    -1,    -1,    -1,
      -1,  2214,  2215,  2216,  2217,    -1,    -1,    -1,    -1,  2222,
    2223,  2224,    -1,  2226,    -1,  2228,    -1,  2230,    -1,  2232,
      -1,  2234,    -1,    -1,    -1,    -1,    -1,    -1,  2241,    -1,
    2243,    -1,    -1,  2246,  2247,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2258,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2277,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2299,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2348,    -1,    -1,    -1,    -1,
    2353,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2397,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2411,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2508,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2581,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2591,    -1,
    2593,    -1,  2595,    -1,    -1,    -1,    -1,    -1,  2601,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2626,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2694,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2839,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2849,    -1,    -1,    -1,
      -1,    -1,  2855,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2864,  2865,    -1,    -1,    -1,    -1,  2870,    -1,    -1,
      -1,  2874,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2887,    -1,    -1,    -1,    -1,    -1,
    2893,    -1,    -1,  2896,  2897,    -1,  2899,  2900,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2913,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2979,  2980,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2990,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3149,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3162,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3273,    -1,    -1,    -1,    -1,    -1,  3279,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3315,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3325,    -1,  3327,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3399,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3456,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3479,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3564,  3565,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3583,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3593,    -1,    -1,    -1,    -1,  3598,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3607,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,  3638,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,  3649,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    42,    43,    44,    -1,    46,    47,    -1,    -1,    50,
      51,    52,    -1,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    73,    74,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    83,    84,    85,    86,    -1,  3710,    89,    90,
      91,    -1,    93,    94,    -1,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
     111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,   152,    -1,   154,   155,   156,   157,   158,   159,   160,
      -1,   162,   163,   164,   165,   166,    -1,   168,    -1,    -1,
     171,    -1,   173,   174,    -1,   176,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,   186,   187,   188,   189,   190,
     191,    -1,   193,   194,    -1,   196,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,   242,   243,    -1,   245,   246,   247,    -1,   249,   250,
      -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,
      -1,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,   308,   309,   310,
      -1,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,    -1,   325,   326,   327,    -1,   329,   330,
     331,   332,   333,   334,   335,    -1,   337,   338,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,   388,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,    -1,    -1,    -1,    -1,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,   477,   478,   479,   480,
      -1,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   494,    -1,   496,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,   509,   510,
      -1,   512,   513,   514,   515,   516,   517,   518,    -1,   520,
     521,   522,   523,    -1,   525,    -1,    -1,   528,   529,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
     541,   542,   543,   544,   545,   546,    -1,    -1,   549,   550,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,   564,    -1,   566,    -1,    -1,    -1,    -1,
     571,    -1,    -1,    -1,   575,   576,    -1,    -1,    -1,    -1,
     581,    -1,   583,    -1,    -1,   586,   587,    -1,   589,   590,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    73,    74,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    83,    84,
      85,    86,    -1,    -1,    89,    90,    91,    -1,    93,    94,
      -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,   111,   112,    -1,   114,
      -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,   154,
     155,   156,   157,   158,   159,   160,    -1,   162,   163,   164,
     165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,
      -1,   176,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,   186,   187,   188,   189,   190,   191,    -1,   193,   194,
      -1,   196,   197,    -1,   199,   200,    -1,   202,   203,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,
     225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,
      -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,
      -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
      -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,   308,   309,   310,    -1,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    -1,
     325,   326,   327,    -1,   329,   330,   331,   332,   333,   334,
     335,    -1,   337,   338,    -1,   340,   341,    -1,   343,   344,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,   428,   429,    -1,   431,   432,   433,   434,
     435,    -1,    -1,    -1,    -1,   440,    -1,    -1,   443,   444,
     445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,
     455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,
     475,   476,   477,   478,   479,   480,    -1,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
      -1,   496,   497,    -1,   499,   500,   501,   502,   503,   504,
      -1,    -1,    -1,    -1,    -1,   510,    -1,   512,   513,   514,
     515,   516,   517,   518,    -1,   520,   521,   522,   523,    -1,
     525,    -1,    -1,   528,   529,   530,    -1,    -1,   533,    -1,
     535,    -1,   537,   538,    -1,    -1,   541,   542,   543,   544,
     545,   546,    -1,    -1,   549,   550,    -1,   552,   553,   554,
      -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,   564,
      -1,   566,    -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,
     575,   576,    -1,    -1,    -1,    -1,   581,    -1,   583,    -1,
      -1,   586,   587,    -1,   589,   590,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,   430,   431,   432,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,   477,   478,
     479,   480,    -1,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,    -1,   496,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,   513,   514,   515,   516,   517,   518,
      -1,   520,   521,   522,   523,    -1,   525,    -1,    -1,   528,
     529,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,   541,   542,   543,   544,   545,   546,    -1,    -1,
     549,   550,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,   564,    -1,   566,    -1,    -1,
      -1,    -1,   571,    -1,    -1,    -1,   575,   576,    -1,    -1,
      -1,    -1,   581,    -1,   583,    -1,    -1,   586,   587,    -1,
     589,   590,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,    52,
      -1,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      83,    84,    85,    86,    -1,    -1,    89,    90,    91,    -1,
      93,    94,    -1,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,   112,
      -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,   152,
      -1,   154,   155,   156,   157,   158,   159,   160,    -1,   162,
     163,   164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,
     173,   174,    -1,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,   186,   187,   188,   189,   190,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
     213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
     223,   224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,
      -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,   308,   309,   310,    -1,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,    -1,   325,   326,   327,    -1,   329,   330,   331,   332,
     333,   334,   335,    -1,   337,   338,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,   388,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,   428,   429,    -1,   431,   432,
     433,   434,   435,    -1,    -1,    -1,    -1,   440,    -1,    -1,
     443,   444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,
     453,   454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,
      -1,    -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,
      -1,    -1,   475,   476,   477,   478,   479,   480,    -1,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   494,    -1,   496,   497,    -1,   499,   500,   501,   502,
     503,   504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,
     513,   514,   515,   516,   517,   518,    -1,   520,   521,   522,
     523,    -1,   525,    -1,    -1,   528,   529,   530,    -1,    -1,
     533,    -1,   535,    -1,   537,   538,    -1,    -1,   541,   542,
     543,   544,   545,   546,    -1,    -1,   549,   550,    -1,   552,
     553,   554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,
      -1,   564,    -1,   566,    -1,    -1,    -1,    -1,   571,    -1,
      -1,    -1,   575,   576,    -1,    -1,    -1,    -1,   581,    -1,
     583,   584,    -1,   586,   587,    -1,   589,   590,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    51,    52,    -1,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    73,    74,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    83,    84,    85,    86,
      -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,    96,
      97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,
      -1,   118,   119,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,    -1,   154,   155,   156,
     157,   158,   159,   160,    -1,   162,   163,   164,   165,   166,
      -1,   168,    -1,    -1,   171,    -1,   173,   174,    -1,   176,
     177,    -1,   179,   180,   181,   182,   183,    -1,   185,   186,
     187,   188,   189,   190,   191,    -1,   193,   194,    -1,   196,
     197,    -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,
     247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
     267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,   308,   309,   310,    -1,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,    -1,   325,   326,
     327,    -1,   329,   330,   331,   332,   333,   334,   335,    -1,
     337,   338,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
      -1,   428,   429,    -1,   431,   432,   433,   434,   435,    -1,
      -1,    -1,    -1,   440,    -1,    -1,   443,   444,   445,    -1,
      -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,
     457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,   466,
     467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,
     477,   478,   479,   480,    -1,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   494,    -1,   496,
     497,    -1,   499,   500,   501,   502,   503,   504,    -1,    -1,
      -1,    -1,    -1,   510,    -1,   512,   513,   514,   515,   516,
     517,   518,    -1,   520,   521,   522,   523,    -1,   525,    -1,
      -1,   528,   529,   530,    -1,    -1,   533,    -1,   535,    -1,
     537,   538,    -1,    -1,   541,   542,   543,   544,   545,   546,
      -1,    -1,   549,   550,    -1,   552,   553,   554,    -1,    -1,
      -1,    -1,   559,    -1,   561,   562,    -1,   564,    -1,   566,
      -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,   575,   576,
      -1,    -1,    -1,    -1,   581,    -1,   583,   584,    -1,   586,
     587,    -1,   589,   590,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      51,    52,    -1,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    73,    74,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    83,    84,    85,    86,    -1,    -1,    89,    90,
      91,    -1,    93,    94,    -1,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
     111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,   152,    -1,   154,   155,   156,   157,   158,   159,   160,
      -1,   162,   163,   164,   165,   166,    -1,   168,    -1,    -1,
     171,    -1,   173,   174,    -1,   176,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,   186,   187,   188,   189,   190,
     191,    -1,   193,   194,    -1,   196,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,   242,   243,    -1,    -1,   246,   247,    -1,   249,   250,
      -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,
      -1,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,   308,   309,   310,
      -1,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,    -1,   325,   326,   327,    -1,   329,   330,
     331,   332,   333,   334,   335,    -1,   337,   338,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,   388,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,    -1,    -1,    -1,    -1,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,   477,   478,   479,   480,
      -1,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   494,    -1,   496,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,   513,   514,   515,   516,   517,   518,    -1,   520,
     521,   522,   523,    -1,   525,    -1,    -1,   528,   529,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
     541,   542,   543,   544,   545,   546,    -1,    -1,   549,   550,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,   564,    -1,   566,    -1,    -1,    -1,    -1,
     571,    -1,    -1,    -1,   575,   576,    -1,    -1,    -1,    -1,
     581,    -1,   583,   584,    -1,   586,   587,    -1,   589,   590,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    73,    74,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    83,    84,
      85,    86,    -1,    -1,    89,    90,    91,    -1,    93,    94,
      -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,   111,   112,    -1,   114,
      -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,   154,
     155,   156,   157,   158,   159,   160,    -1,   162,   163,   164,
     165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,
      -1,   176,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,   186,   187,   188,   189,   190,   191,    -1,   193,   194,
      -1,   196,   197,    -1,   199,   200,    -1,   202,   203,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,
     225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,
      -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,
      -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
      -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,   308,   309,   310,    -1,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    -1,
     325,   326,   327,    -1,   329,   330,   331,   332,   333,   334,
     335,    -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,   428,   429,    -1,   431,   432,   433,   434,
     435,    -1,    -1,    -1,    -1,   440,    -1,    -1,   443,   444,
     445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,
     455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,
     475,   476,   477,   478,   479,   480,    -1,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
      -1,   496,   497,    -1,   499,   500,   501,   502,   503,   504,
      -1,    -1,    -1,    -1,    -1,   510,    -1,   512,   513,   514,
     515,   516,   517,   518,    -1,   520,   521,   522,   523,    -1,
     525,    -1,    -1,   528,   529,   530,    -1,    -1,   533,    -1,
     535,    -1,   537,   538,    -1,    -1,   541,   542,   543,   544,
     545,   546,    -1,    -1,   549,   550,    -1,   552,   553,   554,
      -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,   564,
      -1,   566,    -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,
     575,   576,    -1,    -1,    -1,    -1,   581,    -1,   583,   584,
      -1,   586,   587,    -1,   589,   590,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,   175,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,   432,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,   477,   478,
     479,   480,    -1,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,    -1,   496,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,   513,   514,   515,   516,   517,   518,
      -1,   520,   521,   522,   523,    -1,   525,    -1,    -1,   528,
     529,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,   541,   542,   543,   544,   545,   546,    -1,    -1,
     549,   550,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,   564,    -1,   566,    -1,    -1,
      -1,    -1,   571,    -1,    -1,    -1,   575,   576,    -1,    -1,
      -1,    -1,   581,    -1,   583,    -1,    -1,   586,   587,    -1,
     589,   590,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,    52,
      -1,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      83,    84,    85,    86,    -1,    -1,    89,    90,    91,    -1,
      93,    94,    -1,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,   112,
      -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,   152,
      -1,   154,   155,   156,   157,   158,   159,   160,    -1,   162,
     163,   164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,
     173,   174,   175,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,   186,   187,   188,   189,   190,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
     213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
     223,   224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,
      -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,   308,   309,   310,    -1,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,    -1,   325,   326,   327,    -1,   329,   330,   331,   332,
     333,   334,   335,    -1,   337,   338,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,   388,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,   428,   429,    -1,   431,   432,
     433,   434,   435,    -1,    -1,    -1,    -1,   440,    -1,    -1,
     443,   444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,
     453,   454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,
      -1,    -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,
      -1,    -1,   475,   476,   477,   478,   479,   480,    -1,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   494,    -1,   496,   497,    -1,   499,   500,   501,   502,
     503,   504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,
     513,   514,   515,   516,   517,   518,    -1,   520,   521,   522,
     523,    -1,   525,    -1,    -1,   528,   529,   530,    -1,    -1,
     533,    -1,   535,    -1,   537,   538,    -1,    -1,   541,   542,
     543,   544,   545,   546,    -1,    -1,   549,   550,    -1,   552,
     553,   554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,
      -1,   564,    -1,   566,    -1,    -1,    -1,    -1,   571,    -1,
      -1,    -1,   575,   576,    -1,    -1,    -1,    -1,   581,    -1,
     583,    -1,    -1,   586,   587,    -1,   589,   590,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    51,    52,    -1,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    73,    74,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    83,    84,    85,    86,
      -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,    96,
      97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,
      -1,   118,   119,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,    -1,   154,   155,   156,
     157,   158,   159,   160,    -1,   162,   163,   164,   165,   166,
      -1,   168,    -1,    -1,   171,    -1,   173,   174,   175,   176,
     177,    -1,   179,   180,   181,   182,   183,    -1,   185,   186,
     187,   188,   189,   190,   191,    -1,   193,   194,    -1,   196,
     197,    -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,
     247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
     267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,   308,   309,   310,    -1,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,    -1,   325,   326,
     327,    -1,   329,   330,   331,   332,   333,   334,   335,    -1,
     337,   338,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
      -1,   428,   429,    -1,   431,   432,   433,   434,   435,    -1,
      -1,    -1,    -1,   440,    -1,    -1,   443,   444,   445,    -1,
      -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,
     457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,   466,
     467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,
     477,   478,   479,   480,    -1,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   494,    -1,   496,
     497,    -1,   499,   500,   501,   502,   503,   504,    -1,    -1,
      -1,    -1,    -1,   510,    -1,   512,   513,   514,   515,   516,
     517,   518,    -1,   520,   521,   522,   523,    -1,   525,    -1,
      -1,   528,   529,   530,    -1,    -1,   533,    -1,   535,    -1,
     537,   538,    -1,    -1,   541,   542,   543,   544,   545,   546,
      -1,    -1,   549,   550,    -1,   552,   553,   554,    -1,    -1,
      -1,    -1,   559,    -1,   561,   562,    -1,   564,    -1,   566,
      -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,   575,   576,
      -1,    -1,    -1,    -1,   581,    -1,   583,    -1,    -1,   586,
     587,    -1,   589,   590,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      51,    52,    -1,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    73,    74,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    83,    84,    85,    86,    -1,    -1,    89,    90,
      91,    -1,    93,    94,    -1,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
     111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,   152,    -1,   154,   155,   156,   157,   158,   159,   160,
      -1,   162,   163,   164,   165,   166,    -1,   168,    -1,    -1,
     171,    -1,   173,   174,    -1,   176,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,   186,   187,   188,   189,   190,
     191,    -1,   193,   194,    -1,   196,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,   242,   243,    -1,    -1,   246,   247,    -1,   249,   250,
      -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,
      -1,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,   308,   309,   310,
      -1,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,    -1,   325,   326,   327,    -1,   329,   330,
     331,   332,   333,   334,   335,    -1,   337,   338,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,   388,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,    -1,    -1,    -1,    -1,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,   477,   478,   479,   480,
      -1,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   494,    -1,   496,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,   513,   514,   515,   516,   517,   518,    -1,   520,
     521,   522,   523,    -1,   525,    -1,    -1,   528,   529,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
     541,   542,   543,   544,   545,   546,    -1,    -1,   549,   550,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,   564,    -1,   566,    -1,    -1,    -1,    -1,
     571,    -1,    -1,    -1,   575,   576,    -1,    -1,    -1,    -1,
     581,    -1,   583,    -1,    -1,   586,   587,    -1,   589,   590,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    73,    74,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    83,    84,
      85,    86,    -1,    -1,    89,    90,    91,    -1,    93,    94,
      -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,   111,   112,    -1,   114,
      -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,   154,
     155,   156,   157,   158,   159,   160,    -1,   162,   163,   164,
     165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,
      -1,   176,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,   186,   187,   188,   189,   190,   191,    -1,   193,   194,
      -1,   196,   197,    -1,   199,   200,    -1,   202,   203,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,
     225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,
      -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,
      -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
      -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,   308,   309,   310,    -1,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    -1,
     325,   326,   327,    -1,   329,   330,   331,   332,    -1,   334,
     335,    -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,   428,   429,    -1,   431,   432,   433,   434,
     435,    -1,    -1,    -1,    -1,   440,    -1,    -1,   443,   444,
     445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,
     455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,
     475,   476,   477,   478,   479,   480,    -1,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
      -1,   496,   497,    -1,   499,   500,   501,   502,   503,   504,
      -1,    -1,    -1,    -1,    -1,   510,    -1,   512,   513,   514,
     515,   516,   517,   518,    -1,   520,   521,   522,   523,    -1,
     525,    -1,    -1,   528,   529,   530,    -1,    -1,   533,    -1,
     535,    -1,   537,   538,    -1,    -1,   541,   542,   543,   544,
     545,   546,    -1,    -1,   549,   550,    -1,   552,   553,   554,
      -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,   564,
      -1,   566,    -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,
     575,   576,    -1,    -1,    -1,    -1,   581,    -1,   583,    -1,
      -1,   586,   587,    -1,   589,   590,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,   432,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,   477,   478,
     479,   480,    -1,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,    -1,   496,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,   513,   514,   515,   516,   517,   518,
      -1,   520,   521,   522,   523,    -1,   525,    -1,    -1,   528,
     529,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,   541,   542,   543,   544,   545,   546,    -1,    -1,
     549,   550,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,   564,    -1,   566,    -1,    -1,
      -1,    -1,   571,    -1,    -1,    -1,   575,   576,    -1,    -1,
      -1,    -1,   581,    -1,   583,    -1,    -1,   586,   587,    -1,
     589,   590,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,    52,
      -1,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      83,    84,    85,    86,    -1,    -1,    89,    90,    91,    -1,
      93,    94,    -1,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,   112,
      -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,   152,
      -1,   154,   155,   156,   157,   158,   159,   160,    -1,   162,
     163,   164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,
     173,   174,    -1,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,   186,   187,   188,   189,   190,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
     213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
     223,   224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,
      -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,   308,   309,   310,    -1,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,    -1,   325,   326,   327,    -1,   329,   330,   331,   332,
     333,   334,   335,    -1,   337,   338,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,   388,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,   428,   429,    -1,   431,   432,
     433,   434,   435,    -1,    -1,    -1,    -1,   440,    -1,    -1,
     443,   444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,
     453,   454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,
      -1,    -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,
      -1,    -1,   475,   476,   477,   478,   479,   480,    -1,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   494,    -1,   496,   497,    -1,   499,   500,   501,   502,
     503,   504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,
     513,   514,   515,   516,   517,   518,    -1,   520,   521,   522,
     523,    -1,   525,    -1,    -1,   528,   529,   530,    -1,    -1,
     533,    -1,   535,    -1,   537,   538,    -1,    -1,   541,   542,
     543,   544,   545,   546,    -1,    -1,   549,   550,    -1,   552,
     553,   554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,
      -1,   564,    -1,   566,    -1,    -1,    -1,    -1,   571,    -1,
      -1,    -1,   575,   576,    -1,    -1,    -1,    -1,   581,    -1,
     583,    -1,    -1,   586,   587,    -1,   589,   590,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    51,    52,    -1,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    73,    74,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    83,    84,    85,    86,
      -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,    96,
      97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,
      -1,   118,   119,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,    -1,   154,   155,   156,
     157,   158,   159,   160,    -1,   162,   163,   164,   165,   166,
      -1,   168,    -1,    -1,   171,    -1,   173,   174,    -1,   176,
     177,    -1,   179,   180,   181,   182,   183,    -1,   185,   186,
     187,   188,   189,   190,   191,    -1,   193,   194,    -1,   196,
     197,    -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,
     247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
     267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,   308,   309,   310,    -1,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,    -1,   325,   326,
     327,    -1,   329,   330,   331,   332,   333,   334,   335,    -1,
     337,   338,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
      -1,   428,   429,    -1,   431,   432,   433,   434,   435,    -1,
      -1,    -1,    -1,   440,    -1,    -1,   443,   444,   445,    -1,
      -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,
     457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,   466,
     467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,
     477,   478,   479,   480,    -1,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   494,    -1,   496,
     497,    -1,   499,   500,   501,   502,   503,   504,    -1,    -1,
      -1,    -1,    -1,   510,    -1,   512,   513,   514,   515,   516,
     517,   518,    -1,   520,   521,   522,   523,    -1,   525,    -1,
      -1,   528,   529,   530,    -1,    -1,   533,    -1,   535,    -1,
     537,   538,    -1,    -1,   541,   542,   543,   544,   545,   546,
      -1,    -1,   549,   550,    -1,   552,   553,   554,    -1,    -1,
      -1,    -1,   559,    -1,   561,   562,    -1,   564,    -1,   566,
      -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,   575,   576,
      -1,    -1,    -1,    -1,   581,    -1,   583,    -1,    -1,   586,
     587,    -1,   589,   590,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      51,    52,    -1,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    73,    74,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    83,    84,    85,    86,    -1,    -1,    89,    90,
      91,    -1,    93,    94,    -1,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
     111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,   152,    -1,   154,   155,   156,   157,   158,   159,   160,
      -1,   162,   163,   164,   165,   166,    -1,   168,    -1,    -1,
     171,    -1,   173,   174,    -1,   176,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,   186,   187,   188,   189,   190,
     191,    -1,   193,   194,    -1,   196,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,   242,   243,    -1,    -1,   246,   247,    -1,   249,   250,
      -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,
      -1,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,   308,   309,   310,
      -1,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,    -1,   325,   326,   327,    -1,   329,   330,
     331,   332,    -1,   334,   335,    -1,   337,   338,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,   388,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,    -1,    -1,    -1,    -1,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,   477,   478,   479,   480,
      -1,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   494,    -1,   496,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,   513,   514,   515,   516,   517,   518,    -1,   520,
     521,   522,   523,    -1,   525,    -1,    -1,   528,   529,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
     541,   542,   543,   544,   545,   546,    -1,    -1,   549,   550,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,   564,    -1,   566,    -1,    -1,    -1,    -1,
     571,    -1,    -1,    -1,   575,   576,    -1,    -1,    -1,    -1,
     581,    -1,   583,    -1,    -1,   586,   587,    -1,   589,   590,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    79,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,   178,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,   217,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,   238,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,    -1,   252,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,   430,   431,    -1,   433,   434,
     435,    -1,    -1,    -1,    -1,   440,    -1,    -1,   443,   444,
     445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,
     455,    -1,   457,   458,   459,   460,    -1,    -1,    -1,    -1,
      -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,
     475,   476,    -1,    -1,   479,   480,    -1,   482,   483,   484,
      -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,   494,
      -1,   496,   497,    -1,    -1,   500,   501,   502,   503,   504,
      -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,
     515,   516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,
     525,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,
     535,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,
      -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,    -1,
      -1,   566,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,   590,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      52,    -1,    54,    55,    -1,    57,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    79,    80,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,   178,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,
     202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,   217,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,   238,    -1,    -1,   241,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,
      -1,   423,   424,   425,   426,    -1,   428,   429,    -1,   431,
      -1,   433,   434,   435,    -1,    -1,    -1,    -1,   440,    -1,
      -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,    -1,
     452,   453,   454,   455,    -1,   457,   458,   459,   460,    -1,
      -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,    -1,
     472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,    -1,
     482,   483,   484,    -1,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,   501,
     502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,    -1,
     512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,   521,
     522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,    -1,
      -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,    -1,
     552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,   561,
     562,    -1,    -1,    -1,   566,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,   590,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,   430,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
      -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,    -1,   566,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,   584,    -1,    23,    24,    25,
      26,   590,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,    -1,   433,   434,   435,
      -1,    -1,    -1,    -1,   440,    -1,    -1,   443,   444,   445,
      -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,
      -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,
     466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,
     476,    -1,    -1,   479,   480,    -1,   482,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,   493,   494,    -1,
     496,   497,    -1,    -1,   500,   501,   502,   503,   504,    -1,
      -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,   515,
     516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,   525,
      -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,   535,
      -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,    -1,
      -1,    -1,    -1,   559,    -1,   561,   562,    -1,    -1,    -1,
     566,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,   584,    17,
      -1,    -1,    20,   589,   590,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,
      -1,    59,    60,    61,    -1,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    -1,    -1,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,
      -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,
      -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,
      -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,
     168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,
      -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,
      -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,    -1,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,   226,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,
     258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
      -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,
     318,   319,   320,   321,   322,   323,    -1,    -1,   326,   327,
      -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,
      -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,    -1,   363,    -1,   365,    -1,   367,
      -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
      -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,
     418,    -1,   420,   421,    -1,   423,   424,   425,   426,    -1,
     428,   429,    -1,   431,    -1,   433,   434,   435,    -1,    -1,
      -1,    -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,
     448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,
     458,   459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,
      -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,
      -1,   479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,
     488,   489,   490,   491,    -1,   493,   494,    -1,   496,   497,
      -1,    -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,
      -1,    -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,
     518,    -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,
      -1,    -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,
     538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,
      -1,   549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,
      -1,   559,    -1,   561,   562,    -1,    -1,    -1,   566,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,   590,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,    -1,   431,    -1,   433,   434,
     435,    -1,    -1,    -1,    -1,   440,    -1,    -1,   443,   444,
     445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,
     455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,
     475,   476,    -1,    -1,   479,   480,    -1,   482,   483,   484,
      -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,   494,
      -1,   496,   497,    -1,    -1,   500,   501,   502,   503,   504,
      -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,
     515,   516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,
     525,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,
     535,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,
      -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,    -1,
      -1,   566,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,   577,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,   590,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      52,    -1,    54,    55,    -1,    57,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,
     202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,
      -1,   423,   424,   425,   426,    -1,   428,   429,    -1,   431,
      -1,   433,   434,   435,    -1,    -1,    -1,    -1,   440,    -1,
      -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,    -1,
     452,   453,   454,   455,    -1,   457,   458,   459,    -1,    -1,
      -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,    -1,
     472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,    -1,
     482,   483,   484,    -1,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,   501,
     502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,    -1,
     512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,   521,
     522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,    -1,
      -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,    -1,
     552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,   561,
     562,    -1,    -1,    -1,   566,    -1,    -1,    -1,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,   583,    -1,    17,    -1,    -1,    20,    -1,   590,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,    -1,   433,
     434,   435,    -1,    -1,    -1,    -1,   440,    -1,    -1,   443,
     444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,
     454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,
      -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,
      -1,   475,   476,    -1,    -1,   479,   480,    -1,   482,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,
     494,    -1,   496,   497,    -1,    -1,   500,   501,   502,   503,
     504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,
      -1,   515,   516,   517,   518,    -1,    -1,   521,   522,    -1,
      -1,   525,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,
      -1,   535,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,
     554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,
      -1,    -1,   566,    -1,    -1,    -1,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,   589,   590,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,    -1,   433,   434,   435,
      -1,    -1,    -1,    -1,   440,    -1,    -1,   443,   444,   445,
      -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,
      -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,
     466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,
     476,    -1,    -1,   479,   480,    -1,   482,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,   493,   494,    -1,
     496,   497,    -1,    -1,   500,   501,   502,   503,   504,    -1,
      -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,   515,
     516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,   525,
      -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,   535,
      -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,    -1,
      -1,    -1,    -1,   559,    -1,   561,   562,    -1,    -1,    -1,
     566,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,   590,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,
      -1,    54,    55,    -1,    57,    -1,    59,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,
      -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,
      -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,
      -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,
     163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,
     173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,
      -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
      -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,
     243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,
     263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,   290,   291,   292,
      -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,
      -1,   314,    -1,    -1,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,
      -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,
     423,   424,   425,   426,    -1,   428,   429,    -1,   431,    -1,
     433,   434,   435,    -1,    -1,    -1,    -1,   440,    -1,    -1,
     443,   444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,
     453,   454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,
      -1,    -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,
      -1,    -1,   475,   476,    -1,    -1,   479,   480,    -1,   482,
     483,   484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,
     493,   494,    -1,   496,   497,    -1,    -1,   500,   501,   502,
     503,   504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,
      -1,    -1,   515,   516,   517,   518,    -1,    -1,   521,   522,
      -1,    -1,   525,    -1,    -1,    -1,    -1,   530,    -1,    -1,
     533,    -1,   535,    -1,   537,   538,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,
      -1,    -1,    -1,   566,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,   590,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,    -1,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,    -1,   566,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
     590,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,   431,    -1,   433,   434,   435,    -1,
      -1,    -1,    -1,   440,    -1,    -1,   443,   444,   445,    -1,
      -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,
     457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,   466,
     467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,
      -1,    -1,   479,   480,    -1,   482,   483,   484,    -1,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,   496,
     497,    -1,    -1,   500,   501,   502,   503,   504,    -1,    -1,
      -1,    -1,    -1,   510,    -1,   512,    -1,    -1,   515,   516,
     517,   518,    -1,    -1,   521,   522,    -1,    -1,   525,    -1,
      -1,    -1,    -1,   530,    -1,    -1,   533,    -1,   535,    -1,
     537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,
      -1,    -1,   549,    -1,    -1,   552,   553,   554,    -1,    -1,
      -1,    -1,   559,    -1,   561,   562,    -1,    -1,    -1,   566,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,   590,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,   251,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,    -1,   433,
     434,   435,    -1,    -1,    -1,    -1,   440,    -1,    -1,   443,
     444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,
     454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,
      -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,
      -1,   475,   476,    -1,    -1,   479,   480,    -1,   482,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,
     494,    -1,   496,   497,    -1,   499,   500,   501,   502,   503,
     504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,
      -1,   515,   516,   517,   518,    -1,    -1,   521,   522,    -1,
      -1,   525,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,
      -1,   535,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,
     554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,
      -1,     5,   566,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,   589,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,   251,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,    -1,   433,
     434,   435,    -1,    -1,    -1,    -1,   440,    -1,    -1,   443,
     444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,
     454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,
      -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,
      -1,   475,   476,    -1,    -1,   479,   480,    -1,   482,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,
     494,    -1,   496,   497,    -1,   499,   500,   501,   502,   503,
     504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,
      -1,   515,   516,   517,   518,    -1,    -1,   521,   522,    -1,
      -1,   525,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,
      -1,   535,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,
     554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,
      -1,     5,   566,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,   589,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,   251,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,    -1,   433,
     434,   435,    -1,    -1,    -1,    -1,   440,    -1,    -1,   443,
     444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,
     454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,
      -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,
      -1,   475,   476,    -1,    -1,   479,   480,    -1,   482,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,
     494,    -1,   496,   497,    -1,   499,   500,   501,   502,   503,
     504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,
      -1,   515,   516,   517,   518,    -1,    -1,   521,   522,    -1,
      -1,   525,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,
      -1,   535,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,
     554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,
      -1,     5,   566,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,
      24,    25,    -1,    -1,    28,   589,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    -1,    -1,    -1,    -1,    50,    -1,    52,    -1,
      54,    -1,    -1,    -1,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    -1,    69,    -1,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    -1,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,    -1,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,   161,    -1,   163,
     164,   165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,   235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,
      -1,    -1,    -1,   247,   248,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,    -1,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,    -1,   403,
     404,    -1,   406,    -1,    -1,   409,    -1,    -1,   412,   413,
     414,    -1,    -1,    -1,   418,    -1,   420,   421,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,   431,    -1,   433,
     434,   435,    -1,    -1,    -1,    -1,   440,    -1,    -1,   443,
     444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,    -1,
     454,    -1,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,
      -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,
      -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,
     494,    -1,   496,   497,    -1,    -1,   500,   501,   502,   503,
     504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,
      -1,    -1,   516,   517,   518,    -1,    -1,   521,   522,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,
      -1,    -1,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,
     554,    -1,    -1,   557,    -1,   559,    -1,   561,    -1,    -1,
      -1,    -1,   566,    -1,    -1,    -1,    -1,   571,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,   585,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,   431,    -1,   433,   434,   435,    -1,
      -1,    -1,    -1,   440,    -1,    -1,   443,   444,   445,    -1,
      -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,
     457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,   466,
     467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,
      -1,    -1,   479,   480,    -1,   482,   483,   484,    -1,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,   496,
     497,    -1,    -1,   500,   501,   502,   503,   504,    -1,    -1,
      -1,    -1,    -1,   510,    -1,   512,    -1,    -1,   515,   516,
     517,   518,    -1,    -1,   521,   522,    -1,    -1,   525,    -1,
      -1,    -1,    -1,   530,    -1,    -1,   533,    -1,   535,    -1,
     537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,
      -1,    -1,   549,    -1,    -1,   552,   553,   554,    -1,    -1,
      -1,    -1,   559,    -1,   561,   562,    -1,    -1,    -1,   566,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
     577,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,    -1,   431,    -1,   433,   434,
     435,    -1,    -1,    -1,    -1,   440,    -1,    -1,   443,   444,
     445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,
     455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,
     475,   476,    -1,    -1,   479,   480,    -1,   482,   483,   484,
      -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,   494,
      -1,   496,   497,    -1,    -1,   500,   501,   502,   503,   504,
      -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,
     515,   516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,
     525,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,
     535,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,
      -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,    -1,
      -1,   566,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,   577,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,
      -1,    54,    55,    -1,    57,    -1,    59,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,
      -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,
      -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,
      -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,
     163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,
     173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,
      -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
      -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,
     243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,
     263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,   290,   291,   292,
      -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,
      -1,   314,    -1,    -1,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,
      -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,
     423,   424,   425,   426,    -1,   428,   429,    -1,   431,    -1,
     433,   434,   435,    -1,    -1,    -1,    -1,   440,    -1,    -1,
     443,   444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,
     453,   454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,
      -1,    -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,
      -1,    -1,   475,   476,    -1,    -1,   479,   480,    -1,   482,
     483,   484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,
     493,   494,    -1,   496,   497,    -1,    -1,   500,   501,   502,
     503,   504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,
      -1,    -1,   515,   516,   517,   518,    -1,    -1,   521,   522,
      -1,    -1,   525,    -1,    -1,    -1,    -1,   530,    -1,    -1,
     533,    -1,   535,    -1,   537,   538,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,
      -1,    -1,    -1,   566,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,   577,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,    -1,   433,   434,   435,    -1,    -1,    -1,    -1,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,    -1,   566,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,   577,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,
      -1,    50,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    -1,
      69,    -1,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,    -1,
      -1,    -1,   131,   132,   133,    -1,   135,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,    -1,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,   163,   164,   165,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
      -1,   200,    -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,   235,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,   247,   248,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,    -1,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,    -1,   403,   404,    -1,   406,    -1,    -1,
     409,    -1,    -1,   412,   413,   414,    -1,    -1,    -1,   418,
      -1,   420,   421,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,    -1,   454,    -1,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,    -1,   476,    -1,    -1,
      -1,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
      -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,    -1,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,    -1,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,   557,    -1,
     559,    -1,   561,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,     5,   571,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,
      24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    -1,    -1,    -1,    -1,    50,    -1,    52,    -1,
      54,    -1,    -1,    -1,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    -1,    69,    -1,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    -1,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,    -1,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,   161,    -1,   163,
     164,   165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,   235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,
      -1,    -1,    -1,   247,   248,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,    -1,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,    -1,   403,
     404,    -1,   406,    -1,    -1,   409,    -1,    -1,   412,   413,
     414,    -1,    -1,    -1,   418,    -1,   420,   421,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,   431,    -1,   433,
     434,   435,    -1,    -1,    -1,    -1,   440,    -1,    -1,   443,
     444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,    -1,
     454,    -1,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,
      -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,
      -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,
     494,    -1,   496,   497,    -1,    -1,   500,   501,   502,   503,
     504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,
      -1,    -1,   516,   517,   518,    -1,    -1,   521,   522,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,
      -1,    -1,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,
     554,   555,    -1,   557,    -1,   559,    -1,   561,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,     5,   571,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,
      -1,    50,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    -1,
      69,    -1,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,    -1,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,    -1,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,   163,   164,   165,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
      -1,   200,    -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,   235,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,   247,   248,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,    -1,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,    -1,   403,   404,    -1,   406,    -1,    -1,
     409,    -1,    -1,   412,   413,   414,    -1,    -1,    -1,   418,
      -1,   420,   421,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,    -1,   454,    -1,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,    -1,   476,    -1,    -1,
      -1,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
      -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,    -1,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,    -1,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,   555,    -1,   557,    -1,
     559,    -1,   561,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,     5,   571,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,
      24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    -1,    -1,    -1,    -1,    50,    -1,    52,    -1,
      54,    -1,    -1,    -1,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    -1,    69,    -1,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    -1,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,    -1,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,   161,    -1,   163,
     164,   165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,   235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,
      -1,    -1,    -1,   247,   248,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,    -1,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,    -1,   403,
     404,    -1,   406,    -1,    -1,   409,    -1,    -1,   412,   413,
     414,    -1,    -1,    -1,   418,    -1,   420,   421,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,   431,    -1,   433,
     434,   435,    -1,    -1,    -1,    -1,   440,    -1,    -1,   443,
     444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,    -1,
     454,    -1,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,
      -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,
      -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,
     494,    -1,   496,   497,    -1,    -1,   500,   501,   502,   503,
     504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,
      -1,    -1,   516,   517,   518,    -1,    -1,   521,   522,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,
      -1,    -1,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,
     554,    -1,    -1,   557,    -1,   559,    -1,   561,    -1,    -1,
      -1,    -1,   566,    -1,    -1,    -1,     5,   571,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,
      -1,    50,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    -1,
      69,    -1,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,    -1,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,    -1,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,   163,   164,   165,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
      -1,   200,    -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,   235,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,   247,   248,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,    -1,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,    -1,   403,   404,    -1,   406,    -1,    -1,
     409,    -1,    -1,   412,   413,   414,    -1,    -1,    -1,   418,
      -1,   420,   421,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,    -1,   454,    -1,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,    -1,   476,    -1,    -1,
      -1,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
      -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,    -1,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,    -1,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,   557,    -1,
     559,    -1,   561,    -1,    -1,    -1,    -1,   566,    -1,    -1,
      -1,     5,   571,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,
      24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    -1,    -1,    -1,    -1,    50,    -1,    52,    -1,
      54,    -1,    -1,    -1,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    -1,    69,    -1,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    -1,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,    -1,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,   161,    -1,   163,
     164,   165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,   235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,
      -1,    -1,    -1,   247,   248,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,    -1,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,    -1,   403,
     404,    -1,   406,    -1,    -1,   409,    -1,    -1,   412,   413,
     414,    -1,    -1,    -1,   418,    -1,   420,   421,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,   431,    -1,   433,
     434,   435,    -1,    -1,    -1,    -1,   440,    -1,    -1,   443,
     444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,    -1,
     454,    -1,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,
      -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,
      -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,
     494,    -1,   496,   497,    -1,    -1,   500,   501,   502,   503,
     504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,
      -1,    -1,   516,   517,   518,    -1,    -1,   521,   522,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,
      -1,    -1,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,
     554,    -1,    -1,   557,    -1,   559,    -1,   561,    -1,    -1,
      -1,    -1,   566,    -1,    -1,    -1,     5,   571,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,
      -1,    50,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    -1,
      69,    -1,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,    -1,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,    -1,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,   163,   164,   165,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
      -1,   200,    -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,   235,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,   247,   248,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,    -1,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,    -1,   403,   404,    -1,   406,    -1,    -1,
     409,    -1,    -1,   412,   413,   414,    -1,    -1,    -1,   418,
      -1,   420,   421,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,    -1,   454,    -1,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,    -1,   476,    -1,    -1,
      -1,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
      -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,    -1,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,    -1,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,   557,    -1,
     559,    -1,   561,    -1,    -1,    -1,    -1,   566,    -1,    -1,
      -1,     5,   571,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,
      24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    -1,    -1,    -1,    -1,    50,    -1,    52,    -1,
      54,    -1,    -1,    -1,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    -1,    69,    -1,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    -1,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,    -1,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,   161,    -1,   163,
     164,   165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,   235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,
      -1,    -1,    -1,   247,   248,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,    -1,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,    -1,   403,
     404,    -1,   406,    -1,    -1,   409,    -1,    -1,   412,   413,
     414,    -1,    -1,    -1,   418,    -1,   420,   421,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,   431,    -1,   433,
     434,   435,    -1,    -1,    -1,    -1,   440,    -1,    -1,   443,
     444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,    -1,
     454,    -1,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,
      -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,
      -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,
     494,    -1,   496,   497,    -1,    -1,   500,   501,   502,   503,
     504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,
      -1,    -1,   516,   517,   518,    -1,    -1,   521,   522,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,
      -1,    -1,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,
     554,    -1,    -1,   557,    -1,   559,    -1,   561,    -1,    -1,
      -1,    -1,   566,    -1,    -1,    -1,     5,   571,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,
      -1,    50,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    -1,
      69,    -1,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,    -1,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,    -1,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,    -1,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,   163,   164,   165,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
      -1,   200,    -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,   235,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,   247,   248,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,    -1,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,    -1,   403,   404,    -1,   406,    -1,    -1,
     409,    -1,    -1,   412,   413,   414,    -1,    -1,    -1,   418,
      -1,   420,   421,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,    -1,   454,    -1,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,    -1,   476,    -1,    -1,
      -1,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
      -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,    -1,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,    -1,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,   557,    -1,
     559,    -1,   561,    -1,    -1,    -1,    -1,   566,    -1,    -1,
      -1,     5,   571,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,
      24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    -1,    -1,    -1,    -1,    50,    -1,    52,    -1,
      54,    -1,    -1,    -1,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    -1,    69,    -1,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    -1,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,    -1,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,   161,    -1,   163,
     164,   165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,   235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,
      -1,    -1,    -1,   247,   248,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,    -1,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,    -1,   403,
     404,    -1,   406,    -1,    -1,   409,    -1,    -1,   412,   413,
     414,    -1,    -1,    -1,   418,    -1,   420,   421,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,   431,    -1,   433,
     434,   435,    -1,    -1,    -1,    -1,   440,    -1,    -1,   443,
     444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,    -1,
     454,    -1,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,
      -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,
      -1,    -1,   476,    -1,    -1,    -1,   480,    -1,   482,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,
     494,    -1,   496,   497,    -1,    -1,   500,   501,   502,   503,
     504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,
      -1,    -1,   516,   517,   518,    -1,    -1,   521,   522,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,
      -1,    -1,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,
     554,    -1,    -1,   557,    -1,   559,    -1,   561,    -1,    -1,
      -1,    -1,   566,    -1,    -1,    -1,     5,   571,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,   166,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,   267,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,   332,   333,    -1,   335,    -1,    -1,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,   462,   463,   464,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
      -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,   520,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,     5,   566,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    32,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,   145,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,   447,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,     5,   566,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    32,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,     5,   566,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    32,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,     5,   566,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    91,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,     5,   566,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    34,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,     5,   566,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,     5,   566,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    32,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,     5,   566,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,     5,   566,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    18,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,     5,   566,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    82,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,   153,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
      -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,     5,   566,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,   175,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
      -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,     5,   566,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
      -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,     5,   566,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
      -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,     5,   566,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,   372,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
      -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,     5,   566,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,     5,   566,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
      -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,     5,   566,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
      -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,     5,   566,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,
     479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
      -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,    -1,     5,   566,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,    -1,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,
      -1,    50,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,
      59,    60,    -1,    -1,    63,    -1,    65,    66,    -1,    -1,
      69,    -1,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,    -1,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,    -1,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,    -1,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
      -1,   200,    -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,    -1,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,    -1,   403,    -1,    -1,   406,    -1,    -1,
     409,    -1,    -1,   412,   413,    -1,    -1,    -1,    -1,   418,
      -1,   420,   421,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,   431,    -1,   433,   434,   435,    -1,    -1,    -1,
      -1,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,    -1,   454,    -1,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,    -1,   476,    -1,    -1,
      -1,   480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,   496,   497,    -1,
      -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,    -1,    -1,    -1,   516,   517,   518,
      -1,    -1,   521,   522,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   530,    -1,    -1,   533,    -1,    -1,    -1,   537,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,
     549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,    -1,    -1,    -1,    -1,   566
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short yystos[] =
{
       0,     3,    13,    14,    26,    28,    47,    48,    53,    57,
      58,    70,    87,   106,   115,   116,   117,   128,   129,   151,
     168,   192,   199,   202,   223,   239,   257,   262,   348,   370,
     379,   399,   401,   402,   405,   408,   410,   415,   417,   426,
     430,   446,   451,   455,   475,   479,   515,   531,   534,   539,
     562,   583,   594,   595,   596,   597,   598,   599,   601,   606,
     608,   613,   631,   796,   814,   817,   825,   827,   829,   832,
     837,   839,   844,   847,   852,   856,   864,   865,  1014,  1016,
    1022,  1025,  1050,  1058,  1069,  1075,  1089,  1092,  1095,  1101,
    1105,  1109,  1112,  1113,  1159,  1176,  1182,  1184,  1191,  1193,
    1218,  1224,  1225,  1226,  1227,  1265,    11,    94,   179,   214,
     374,   810,  1246,  1247,   258,   336,   846,   493,   495,  1178,
    1219,   217,     5,     7,     8,     9,    10,    11,    17,    20,
      23,    24,    25,    26,    28,    30,    33,    37,    40,    41,
      42,    44,    46,    47,    50,    52,    54,    55,    57,    59,
      60,    61,    63,    65,    66,    68,    69,    70,    71,    72,
      75,    77,    78,    80,    81,    86,    89,    96,    97,   100,
     105,   106,   112,   114,   120,   122,   123,   124,   128,   131,
     132,   133,   137,   141,   142,   143,   144,   147,   149,   150,
     151,   154,   156,   159,   160,   163,   164,   165,   168,   173,
     174,   177,   179,   186,   187,   190,   191,   193,   199,   200,
     202,   205,   209,   210,   211,   212,   215,   216,   220,   224,
     228,   230,   231,   233,   234,   241,   243,   247,   250,   256,
     258,   261,   263,   273,   274,   275,   276,   277,   278,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   290,   291,
     292,   294,   295,   299,   300,   301,   302,   303,   306,   307,
     310,   312,   314,   317,   318,   319,   320,   321,   322,   323,
     326,   327,   329,   330,   331,   335,   340,   341,   343,   345,
     346,   347,   358,   359,   360,   361,   363,   365,   367,   370,
     371,   373,   375,   376,   377,   378,   380,   381,   382,   383,
     384,   385,   386,   387,   392,   393,   396,   397,   398,   400,
     402,   403,   406,   408,   409,   410,   412,   413,   417,   418,
     420,   421,   423,   424,   425,   426,   428,   429,   431,   433,
     434,   435,   440,   443,   444,   445,   448,   452,   453,   454,
     455,   457,   458,   459,   466,   467,   469,   472,   475,   476,
     479,   480,   482,   483,   484,   488,   489,   490,   491,   493,
     494,   496,   497,   500,   501,   502,   503,   504,   510,   512,
     515,   516,   517,   518,   521,   522,   525,   530,   533,   535,
     537,   538,   546,   549,   552,   553,   554,   559,   561,   562,
     566,   619,  1149,  1153,  1157,  1158,   287,  1178,  1178,   559,
    1220,    94,   178,   460,   496,   527,   537,   617,   711,   712,
     713,   786,  1059,  1015,    94,   179,   217,   374,   496,   511,
     537,   552,  1021,  1153,   846,   618,   590,  1147,  1148,  1153,
     607,  1023,  1110,    96,   217,   495,  1178,   846,  1153,  1106,
     426,   537,  1178,   846,  1026,  1102,  1178,   618,  1220,  1153,
     867,   869,   870,   349,  1161,  1076,   475,   479,   455,   510,
     455,   495,  1070,  1183,  1051,  1153,    28,    70,   141,   370,
     392,   417,   475,  1267,   430,   583,   866,     0,     3,   370,
     156,  1093,  1147,  1153,   145,   802,  1153,   619,   619,   495,
     112,  1243,  1178,   828,  1220,   853,   854,  1147,   632,   590,
     508,   830,   840,    16,  1221,   213,   714,   618,   354,  1241,
    1243,  1244,  1245,  1246,   495,   712,   217,   214,   270,   382,
    1067,  1068,   931,   932,   213,  1020,  1020,  1153,  1020,  1020,
     618,  1020,  1178,   602,  1096,    12,    13,    87,   115,   129,
     151,   163,   192,   217,   223,   262,   375,   394,   400,   406,
     430,   451,   452,   488,   534,   536,  1194,  1196,  1198,  1199,
    1153,   347,    61,   390,   590,   251,   499,  1150,  1153,  1155,
     113,   204,   270,  1028,    77,   381,  1111,  1114,   226,  1147,
    1177,  1178,   175,    32,   287,  1081,  1107,  1153,   618,   848,
    1178,   113,   270,  1029,  1057,   287,   381,   455,  1103,  1104,
     826,    12,  1192,  1196,   508,  1221,   868,    12,   125,   204,
     465,   466,   467,   468,   469,   470,   481,   874,   875,   876,
    1160,    30,    33,    55,    56,    65,    67,    85,    87,    95,
     143,   147,   177,   179,   191,   193,   216,   217,   220,   237,
     258,   263,   287,   320,   329,   347,   373,   374,   377,   378,
     440,   445,   455,   480,   495,   553,   759,   785,  1077,  1081,
    1082,  1084,  1167,   819,   820,   819,   819,   558,   818,   819,
    1019,  1147,  1178,  1057,    34,   203,   499,  1135,  1151,  1266,
    1266,  1266,  1266,  1266,   869,   866,   584,  1153,  1091,  1090,
     301,   497,   522,   798,   800,   799,  1147,   145,   471,  1248,
     838,  1018,  1019,   229,   585,   860,   861,   583,   633,  1153,
     609,  1018,  1018,    52,   335,   335,   399,  1222,   332,   333,
     903,  1153,    91,  1155,  1156,  1209,  1210,   405,    10,   374,
     511,   726,  1242,  1248,  1249,  1257,  1259,  1243,  1246,   714,
    1153,   175,  1060,  1064,  1065,  1153,  1067,     7,    20,    22,
      25,    29,    32,    34,    35,    36,    38,    51,    55,    56,
      62,    65,    73,    74,    80,    83,    84,    85,    90,    91,
      93,    94,    98,    99,   100,   105,   107,   110,   111,   118,
     119,   136,   139,   140,   152,   155,   157,   158,   162,   166,
     171,   176,   180,   181,   182,   183,   185,   186,   188,   189,
     190,   194,   196,   197,   203,   209,   213,   223,   225,   242,
     246,   249,   254,   256,   259,   264,   267,   272,   279,   289,
     293,   302,   306,   308,   309,   313,   314,   315,   316,   317,
     318,   319,   325,   332,   333,   334,   337,   338,   343,   361,
     362,   364,   365,   366,   367,   368,   380,   388,   404,   405,
     416,   419,   422,   424,   428,   432,   477,   478,   483,   485,
     486,   487,   492,   501,   502,   503,   504,   513,   514,   515,
     520,   523,   528,   529,   537,   541,   542,   543,   544,   545,
     550,   554,   564,   566,   571,   575,   576,   581,   583,   586,
     587,   589,   590,   885,   888,   891,   892,   893,   894,   895,
     896,   897,   898,   899,   900,   904,   907,   908,   910,   917,
     921,   933,  1134,  1136,  1138,  1139,  1143,  1145,  1149,  1151,
    1153,   152,  1153,   619,   344,   619,   619,  1156,  1208,  1018,
    1020,   540,   603,   120,   205,   263,   287,   373,   381,   409,
     455,   476,   493,  1097,  1098,  1178,   373,  1197,   420,   420,
     496,   537,   552,   349,  1201,   493,  1203,    60,   455,  1200,
      95,   552,  1202,   344,   585,    18,   145,   974,   975,  1185,
    1153,   810,   885,    75,   175,   270,  1115,  1121,    47,   175,
    1147,  1179,  1180,   845,   589,   600,  1150,   263,   849,  1156,
     850,   851,  1147,   833,   226,  1019,  1030,  1031,    47,   585,
    1018,  1197,   344,   426,  1223,  1222,   526,  1228,  1229,   577,
     878,   879,   880,   876,  1162,  1163,  1164,   263,   150,   446,
     252,   556,  1088,   516,   583,    94,   179,   374,   495,   552,
    1088,   721,  1155,   253,   993,   995,    63,   476,   172,   476,
     476,   476,   287,   493,    63,   476,    12,    40,    81,    86,
     231,   300,   359,   459,   490,  1071,  1072,  1073,   476,   205,
     476,   476,   516,   993,  1088,   175,   229,  1085,   263,   142,
      66,   376,   493,   512,   476,   549,   816,   398,   472,   821,
     822,   815,    78,   810,   585,   346,  1269,   489,  1270,   236,
     412,  1268,   584,  1229,  1231,  1232,  1233,   864,  1094,  1135,
    1153,   111,   708,   709,   710,   719,   720,   768,   626,   626,
     797,  1156,   429,   552,  1018,   508,   585,   111,   855,  1153,
     854,   217,   238,   783,   784,   862,   634,   635,   885,   273,
     274,   275,   276,   277,   278,   281,   282,   283,   284,   285,
     286,   288,   396,   397,   610,   611,   612,   156,   382,   831,
      54,   156,   159,   172,   299,   382,   841,   842,   843,    52,
     399,   152,   616,   583,   884,   589,   211,   585,   880,   880,
     880,   552,  1249,  1147,   517,   540,   787,  1064,  1147,  1153,
     585,  1062,   590,  1066,   583,   583,   583,   583,   583,   908,
     583,   583,   583,   583,   583,   583,   583,   583,   583,   583,
     583,   583,   583,   583,   884,   884,   583,   884,   583,   583,
     583,   523,   583,  1134,   583,   583,   583,   583,   583,   583,
     583,   583,   583,   583,   583,   583,   583,   583,   583,   583,
     583,   583,   583,   583,   583,   583,   583,   583,   583,   583,
     583,   583,   583,   885,   583,   583,   583,   583,   583,   583,
     583,   583,   583,   583,   934,   935,   936,   583,   583,   583,
     583,   583,   583,   583,   583,   583,   583,   583,   583,   891,
     583,   884,   583,   583,   583,   583,   583,   583,   583,   583,
     583,   583,   583,   583,   583,   583,   583,   583,   583,   583,
     583,   583,   583,   583,   583,   583,   884,   583,  1134,   583,
     583,   583,  1134,   583,   583,    34,   203,   499,   583,   583,
     583,   884,   884,   884,   583,   583,   583,   583,   583,   583,
     885,   938,   908,   908,   908,   430,   583,   885,  1236,  1153,
     922,  1153,   563,   886,   889,   145,   146,   184,   198,   232,
     244,   271,   328,   905,   229,   252,   395,   458,   572,   573,
     903,   574,   449,   450,   575,   576,   126,   313,   577,   578,
     579,   580,   908,   101,   102,   103,   104,   105,   174,   206,
     207,   208,   209,   302,   304,   305,   306,   314,   380,   427,
     428,   554,   565,   566,   971,   972,    64,   353,   585,  1151,
     583,   590,  1147,   585,    49,   411,   811,  1018,   589,   604,
     605,    47,   558,   585,  1099,   493,   583,  1211,  1211,  1211,
    1211,   179,   374,   495,  1195,  1199,  1153,   164,   330,  1153,
    1186,  1187,  1030,   287,   258,  1120,   857,   287,   975,   585,
    1018,  1155,    27,   508,  1108,   585,   508,   585,   508,  1018,
    1031,  1027,  1104,   175,   585,   179,   374,  1195,  1153,    12,
     125,  1235,   585,   871,   882,   885,  1141,  1153,   585,   191,
     258,   345,   445,  1165,  1166,  1169,  1170,   229,  1086,  1150,
     885,   577,   714,   619,   619,  1147,  1147,  1078,   267,   338,
     520,   996,   997,  1136,   619,  1088,  1156,   172,  1083,  1085,
     619,  1088,   230,   491,   160,   172,  1074,   585,  1083,  1083,
    1147,  1085,  1083,  1083,  1088,  1088,   533,   823,   585,   823,
     457,   430,   583,   587,   941,   942,   943,   944,   953,   954,
     962,  1135,   363,  1271,   352,   989,   995,  1234,   710,    64,
     759,    68,    80,   241,   311,   335,   389,   471,   628,   630,
       6,    13,    23,    24,    53,    57,    68,    77,    83,    96,
     114,   123,   124,   129,   137,   143,   169,   215,   217,   224,
     292,   307,   312,   352,   358,   361,   384,   385,   387,   401,
     423,   517,   526,   716,   718,   719,   720,   803,   804,   805,
     985,   112,   228,  1147,   841,  1150,  1019,   583,   584,   585,
     145,   145,   145,   145,   145,   145,   145,   145,   145,   145,
     145,   145,   145,   145,   145,   585,   535,   842,   708,   584,
    1155,    45,  1210,   619,   619,   179,  1147,   614,    44,   107,
     166,   200,   203,   267,   335,   338,   425,   431,   433,   434,
     435,   436,   437,   438,   439,   440,   520,   788,   789,   790,
     999,   788,   344,  1063,  1061,   590,  1065,   175,   577,  1153,
     975,   885,   885,   885,    12,   125,   927,   976,   999,   927,
     927,   927,   885,   885,   931,   931,   885,   931,   885,   885,
     885,   885,   125,   927,   976,   885,   584,   885,   885,   885,
     885,   885,  1143,  1153,   885,   885,   885,   885,   885,   583,
    1236,   885,   971,   885,   885,   885,   584,   885,   885,   885,
     885,   931,   885,   885,    97,   100,   501,   504,   973,   885,
     125,   924,  1134,   885,   885,   885,   584,   885,   885,   885,
     885,   931,   885,   885,   885,   885,   935,     9,   937,  1143,
     125,   927,   885,   885,   125,   927,   885,   885,   885,   885,
     885,   931,   931,   931,   885,   885,   885,   885,   885,   885,
     931,   895,   885,   584,   885,   885,   885,   885,   885,   584,
     885,   885,   931,   927,   927,   885,   885,   885,   125,   927,
     885,   885,   972,   972,   885,    43,   245,   509,   885,   885,
    1134,   584,   885,   584,   927,  1144,  1145,  1153,   927,   885,
     885,   885,   555,   940,  1239,  1239,   584,   585,   584,   885,
     589,   923,  1155,   590,   888,   887,   890,   894,   158,   337,
     514,   530,   903,    12,    17,   894,   906,   583,   908,   895,
     252,   895,   896,   229,   252,   395,   572,   897,   898,   898,
     899,   907,   899,   907,   900,   900,   900,   900,   900,   908,
     576,  1155,   908,   885,   909,  1153,  1017,  1156,   811,  1155,
     585,   390,  1098,  1018,  1100,  1153,  1212,  1213,   577,  1147,
    1153,  1207,  1207,  1207,   145,   164,   184,   198,   243,   244,
     271,   330,   371,  1188,  1190,   556,   977,  1024,   218,   858,
     859,  1147,   270,   390,   560,  1181,  1180,   841,   885,  1150,
    1156,  1156,   851,  1147,   156,   382,   538,   834,   835,   836,
     430,   446,   545,   546,   583,   704,  1032,  1035,  1150,   192,
    1207,  1207,  1207,  1230,   879,   175,   226,   872,   873,   988,
     989,  1010,   881,   590,  1163,   111,   510,  1153,  1172,   321,
     361,   589,   759,  1171,  1150,   175,  1087,   584,  1153,   263,
     476,  1080,   341,   585,   455,  1088,  1153,   381,   993,  1073,
    1088,  1088,  1083,  1147,  1088,  1088,   612,   824,   822,   961,
    1153,    88,   219,   236,   249,   324,   416,   481,   952,   446,
     585,  1147,   961,   585,   172,  1272,    45,   993,   145,   447,
    1041,  1042,  1042,  1150,   471,   471,   471,   471,   471,   429,
      67,    79,   178,   460,   731,   734,   735,   781,   783,   809,
     809,  1042,  1042,   809,  1042,  1042,  1042,   508,   122,  1042,
     237,   494,   170,   372,   783,   809,   237,  1042,   494,   122,
    1042,  1042,  1042,   809,    45,  1042,  1042,  1042,  1042,  1042,
      18,   145,   508,   813,  1042,  1042,  1042,   716,   585,   583,
     590,   730,   736,  1146,  1153,   801,   372,   969,  1153,   885,
     999,  1150,  1150,   107,   166,   267,   338,   520,  1000,  1150,
     999,  1150,  1150,  1150,  1150,  1150,   999,  1150,  1150,   999,
     611,   361,   499,  1261,     8,    27,   696,   619,  1250,   252,
     583,   698,   715,   717,   718,   435,   440,   585,  1147,   540,
     977,  1153,   942,   590,  1066,   585,   584,   584,   585,   927,
     584,   928,   585,   584,   584,   584,    18,   584,   540,   584,
     584,   584,   584,   585,   585,   540,   585,   585,   918,   584,
     577,   584,   585,   585,   584,   584,   585,   584,   590,   584,
     585,   584,   585,   585,   585,   584,   585,   584,   585,   175,
     585,   585,   584,   585,   584,   585,   585,   584,   585,   584,
     584,   585,   584,   585,   585,   585,   920,   585,   584,   585,
     585,   584,   585,   585,   584,   585,   584,   585,   584,   585,
     585,   585,   584,   583,   585,   927,   584,   584,   584,   927,
     584,   584,   585,   585,   584,   584,   585,   584,   585,   584,
     584,   584,   584,   584,   584,   584,   585,   585,   584,   585,
     584,   229,   584,   584,   585,   585,   585,   584,   585,   585,
     584,   584,   584,   584,   585,   175,   585,   585,   927,   584,
     584,   584,   585,   585,   585,   584,   175,   885,   175,   885,
     175,   885,   175,   584,   585,   585,   584,   584,   584,   584,
     584,   585,   584,   585,   584,   885,   555,   569,   939,   867,
    1238,  1236,   931,   588,   191,   258,   445,  1168,   447,  1153,
     351,   354,   901,    15,    16,   902,   158,   337,   514,   530,
     583,   885,  1236,   149,   981,   895,    16,   583,   908,   895,
     895,   971,   971,   885,   912,   913,   914,   583,   590,   605,
     262,   584,   585,   590,   590,   508,   508,   508,  1189,   978,
     994,   995,  1032,   499,  1152,   585,   860,   560,   258,   508,
     835,   705,  1033,   583,  1038,  1043,  1038,   584,   704,  1034,
    1140,  1141,  1144,  1153,  1036,   349,   175,   175,   175,   865,
     130,   942,  1011,   172,   262,   877,  1010,   994,   873,    18,
     883,  1150,  1153,   577,  1153,   590,   233,   590,  1041,    32,
     111,   760,   761,  1041,  1155,   172,  1041,   589,  1155,    32,
     111,   763,   764,  1155,  1000,  1079,   147,   553,   997,   997,
     558,   338,   977,  1083,   585,   956,   961,   941,   236,   236,
     355,   963,   236,   249,   416,   963,   953,   941,  1053,  1054,
    1144,   941,   975,   958,   959,   999,   303,   990,   111,   765,
     767,  1155,   761,    96,    96,   112,   228,   793,  1146,   784,
     784,    58,   170,   372,   527,   733,   782,   732,   733,   793,
    1146,  1000,   999,  1146,   999,  1150,  1150,   759,  1042,   999,
     238,   238,  1146,  1146,   721,  1042,   164,   243,   335,   724,
    1000,  1000,  1146,   986,   987,  1144,   111,   999,  1150,   999,
     999,   383,   386,   723,   999,  1147,    71,    72,   111,   133,
     165,   393,   722,   721,   583,   805,   728,   729,   730,   731,
    1153,     8,   164,   812,   394,   732,   773,   737,   590,   583,
    1251,   584,   585,   499,   583,   115,   223,   534,   697,  1260,
    1251,  1147,   252,   699,   704,   728,   214,   405,   701,  1122,
     585,   717,   789,   615,   942,   988,   977,   975,   225,   885,
     885,   584,   885,   885,    32,    56,    97,   100,   108,   326,
     453,   504,   532,   929,   760,   931,   885,   760,   929,   885,
     931,   584,   907,   907,  1151,  1153,   885,   885,   931,  1151,
     885,   885,   885,   931,   338,   885,   885,   885,   885,   885,
     885,   885,   931,   931,   338,   885,   885,   931,   885,   885,
     885,   885,   931,   885,   895,  1143,   584,   584,   885,   885,
     885,   885,   885,   885,   885,   885,   885,   885,   885,   885,
     931,   225,   885,   885,   885,   885,   584,   885,   885,   885,
     885,   175,   885,   175,   885,   175,   885,   885,   338,   885,
     885,   570,   885,   885,   141,  1240,   584,   584,   590,   590,
     590,  1155,   885,   888,   891,  1236,   584,   585,   584,   908,
     894,   885,  1236,   981,    16,   584,   880,   915,   916,   930,
     931,  1153,  1213,   577,   577,  1209,  1209,  1209,   583,   885,
     344,  1048,  1116,   859,   214,   863,  1156,   874,  1039,  1040,
    1144,  1044,   585,   583,  1035,   584,   584,   585,   590,  1228,
     175,  1209,  1209,  1209,   977,   977,   131,   356,  1006,  1007,
    1012,   534,   229,  1150,  1153,   590,  1153,   250,  1153,    12,
      32,   111,   344,   885,  1175,    64,   766,   885,  1156,   343,
     361,   499,  1174,  1168,  1041,   993,   275,  1088,   612,  1231,
     957,   249,   236,   953,   963,   963,   236,   344,   344,   540,
     585,  1052,  1041,   169,   214,   539,   965,   874,   885,   991,
    1142,   885,   238,   238,   784,   793,   787,   129,   446,   806,
     761,  1150,   793,   811,  1150,   807,   585,    19,   116,   992,
    1018,   584,   585,  1153,  1147,    31,    32,    37,    39,    41,
      42,    56,    97,   100,   108,   127,   144,   165,   167,   186,
     187,   227,   256,   265,   266,   268,   296,   297,   298,   317,
     318,   319,   323,   326,   339,   340,   365,   367,   391,   444,
     446,   456,   500,   501,   504,   505,   506,   507,   547,   548,
     566,   738,   741,   742,   743,   744,   745,   746,   747,  1153,
    1153,  1252,    18,  1153,  1262,   344,   413,   583,   620,    18,
    1147,   584,   584,    18,   707,   717,   583,   977,   253,   998,
     885,   584,   584,   584,   583,   753,   753,   583,   748,   749,
     753,   227,   227,   584,   584,   584,   584,   584,   584,   585,
     919,   971,   971,   584,   584,   584,   584,   584,   584,   585,
     584,   584,   584,   584,   584,   585,   584,   584,   584,   584,
     584,   926,   989,   585,   585,   585,   584,   584,   584,   584,
     585,   584,   584,   584,   585,   229,   558,   911,   584,   584,
     584,   584,   584,   584,   584,   584,   584,   585,   584,   584,
     584,   885,   584,   172,   584,   584,   585,   585,   584,   585,
     585,   584,   885,   584,   885,   584,   885,   584,   584,   585,
     584,   584,   885,   570,  1237,   590,   794,   584,   931,   584,
     585,   584,   894,   885,   585,   584,   407,  1214,  1214,  1214,
     111,   885,  1046,  1047,   132,  1122,   247,   878,   585,  1041,
    1045,  1046,  1043,  1037,  1035,  1140,  1153,  1209,   994,   195,
     982,  1152,  1152,   589,  1008,  1009,  1155,   448,   577,   390,
     403,   443,  1173,   767,  1041,   583,   583,  1172,   885,   145,
     584,   943,   355,   941,   953,   236,   236,   941,   953,   946,
     945,   947,  1054,   977,  1047,   783,   966,   966,   966,   878,
     585,   992,   793,   787,   583,   111,   111,   736,   766,   738,
     987,   584,   729,   774,   583,   583,   753,   748,   369,   739,
     748,   748,    20,    32,    46,   525,   759,   769,    56,   547,
     742,   744,   769,   769,    56,   548,   548,   551,   748,   740,
     753,   753,   769,   583,   753,    23,    64,    68,   111,   337,
     344,   372,   444,   527,   755,   756,   757,   772,   903,   551,
     583,   769,    32,   583,   770,   583,   583,   753,   583,   749,
     754,   590,   584,   585,  1253,  1254,   221,   229,   357,   640,
     641,   642,   643,   880,   108,   227,   391,   482,   727,   621,
    1253,   584,   700,   715,   583,   704,   791,   792,  1153,   997,
     971,   338,   769,   338,   885,   584,   584,   584,   885,   885,
     442,   925,   338,   885,   885,   885,   885,    41,   381,   584,
     885,   971,   885,   885,   885,   885,   885,   584,   584,   584,
     338,   885,  1228,  1153,   584,   931,   881,   916,    59,   234,
     331,   473,   484,   561,  1205,  1206,   558,  1215,  1215,  1215,
     584,   585,  1049,   226,   706,  1040,  1047,   584,  1231,    45,
     201,   979,  1013,  1155,   585,   310,    69,   521,   390,  1174,
     499,   499,  1041,  1150,   975,   236,   344,   949,   953,   953,
     344,   951,   885,   885,   583,   988,   172,   964,   960,  1142,
     583,   583,   791,   100,   501,   504,   575,   576,  1137,  1138,
     812,   755,   289,   344,   583,   775,   777,   778,   779,   338,
     338,   453,   532,   567,   750,   751,   752,   583,   750,   750,
     770,    20,   525,   759,   771,   770,   760,   769,   551,   750,
     583,   769,   338,   750,   765,  1150,   334,   758,  1137,   534,
     111,   238,   757,   238,   337,   338,   338,   338,   338,   750,
     338,   750,  1153,  1153,   558,  1256,   430,   583,  1255,   584,
     585,   638,  1147,   519,   636,   637,   639,  1153,  1256,  1231,
     701,   704,   702,   584,   585,   992,   583,   584,   584,   584,
     585,   584,   584,   585,   584,  1135,   584,   585,   584,   585,
     584,   584,   310,   154,   584,   584,   584,   584,   584,   584,
     584,   585,  1240,   584,   883,   499,   499,   499,    16,  1204,
     192,   290,   291,   294,   295,  1216,  1217,  1047,   238,  1117,
     725,   873,   994,   983,  1142,   980,   988,    66,  1123,  1009,
     584,   584,  1175,    16,   941,   948,   540,   950,   540,   970,
    1153,   998,   236,   967,   725,   992,   791,   791,   584,  1139,
    1139,   808,   177,   360,   454,   115,   534,   776,  1153,   779,
     584,   584,   752,   795,  1135,   760,   770,   795,   584,   884,
     334,   546,   584,   584,   584,   584,    50,    58,   258,   880,
     880,  1263,   642,  1153,   172,  1150,   584,   585,   638,   584,
    1228,   792,   338,   338,   885,   927,   885,   931,  1205,   349,
     999,   999,   999,   999,  1217,   534,   495,   877,   558,   585,
     984,   992,   885,   994,   138,   148,   350,   498,  1124,  1125,
     255,  1126,   276,   344,   885,   583,   885,   583,   584,   585,
     583,   584,   584,   812,    49,   335,   411,   446,   780,   780,
     584,   585,   584,   585,   584,   884,   769,   770,   769,   770,
      58,   349,    58,   867,   866,   627,   738,   880,   622,   639,
     738,   703,   992,   584,   584,   584,   585,   584,   584,   584,
    1055,  1056,  1144,  1147,    89,   418,  1142,   374,  1001,    45,
      45,   138,    45,  1125,   474,   498,  1127,  1128,   145,   955,
     970,   970,  1153,   968,   969,   773,     5,   111,   337,   777,
    1153,   769,  1135,   769,   349,   349,   584,   121,   628,   629,
     903,  1264,   134,   413,  1231,   885,   585,  1041,  1118,   992,
    1153,  1135,  1135,    45,  1135,    45,    45,  1128,  1000,   885,
     584,   584,   584,  1231,   121,    61,   161,   213,   235,   248,
     347,   414,   571,   660,   661,   664,   673,   674,   677,   688,
    1149,  1154,  1158,   424,   623,   584,  1056,  1047,   759,   762,
    1002,  1135,  1135,  1135,    16,   588,  1153,   175,   330,   666,
     663,  1154,  1154,  1153,   662,   675,   678,   596,    28,   269,
     404,   557,   691,   592,  1258,   738,   761,  1119,   583,   280,
     175,  1153,   668,   669,   885,   885,   555,   680,   684,   692,
     645,   660,   645,   693,   689,   660,   624,  1123,   880,  1003,
    1004,  1005,   145,   226,   141,   885,   676,   685,   569,   684,
     687,   646,   141,   660,   591,   533,   885,   691,   627,  1126,
     885,   584,   585,   999,   665,   213,   570,   555,   679,   681,
     885,   645,   141,   109,   644,   647,   269,   591,   695,   128,
     690,  1154,   625,   214,  1129,  1005,   667,  1153,   670,   682,
     681,   687,   686,   571,    82,   153,   652,   658,  1153,   141,
     660,   591,   885,   694,   660,   338,   583,  1130,   585,   645,
     885,   141,   570,   199,   585,   648,    76,    92,   591,   141,
     645,   255,   584,   589,  1131,  1132,  1144,   446,  1133,  1153,
     671,   683,   571,   645,   172,  1153,   738,   172,   172,   404,
     141,  1155,   584,   585,  1055,   135,   569,   672,   570,   649,
     111,   659,   463,   655,   999,   650,   651,   557,  1132,   668,
     645,   645,   462,   464,   653,   654,   655,   657,   903,  1153,
     885,   546,   656,   596,   585,   660,   173,  1151,   654
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)		\
   ((Current).first_line   = (Rhs)[1].first_line,	\
    (Current).first_column = (Rhs)[1].first_column,	\
    (Current).last_line    = (Rhs)[N].last_line,	\
    (Current).last_column  = (Rhs)[N].last_column)
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if defined (YYMAXDEPTH) && YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1227 "sql_yacc.yy"
    {
	   THD *thd= YYTHD;
	   if (!thd->bootstrap &&
	      (!(thd->lex->select_lex.options & OPTION_FOUND_COMMENT)))
	   {
	     my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
	     MYSQL_YYABORT;
	   }
	   else
	   {
	     thd->lex->sql_command= SQLCOM_EMPTY_QUERY;
	   }
	}
    break;

  case 3:
#line 1240 "sql_yacc.yy"
    {}
    break;

  case 53:
#line 1300 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_DEALLOCATE_PREPARE;
          lex->prepared_stmt_name= yyvsp[0].lex_str;
        }
    break;

  case 56:
#line 1315 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_PREPARE;
          lex->prepared_stmt_name= yyvsp[-2].lex_str;
        }
    break;

  case 57:
#line 1324 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= yyvsp[0].lex_str;
          lex->prepared_stmt_code_is_varref= FALSE;
        }
    break;

  case 58:
#line 1331 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= yyvsp[0].lex_str;
          lex->prepared_stmt_code_is_varref= TRUE;
        }
    break;

  case 59:
#line 1340 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_EXECUTE;
          lex->prepared_stmt_name= yyvsp[0].lex_str;
        }
    break;

  case 60:
#line 1347 "sql_yacc.yy"
    {}
    break;

  case 65:
#line 1361 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          LEX_STRING *lexstr= (LEX_STRING*)sql_memdup(&yyvsp[0].lex_str, sizeof(LEX_STRING));
          if (!lexstr || lex->prepared_stmt_params.push_back(lexstr))
              MYSQL_YYABORT;
        }
    break;

  case 66:
#line 1373 "sql_yacc.yy"
    {
         if (Lex->sphead)
         {
           my_error(ER_SP_BADSTATEMENT, MYF(0), "HELP");
           MYSQL_YYABORT;
         }
       }
    break;

  case 67:
#line 1381 "sql_yacc.yy"
    {
	  LEX *lex= Lex;
	  lex->sql_command= SQLCOM_HELP;
	  lex->help_arg= yyvsp[0].lex_str.str;
       }
    break;

  case 68:
#line 1391 "sql_yacc.yy"
    {
	  LEX *lex = Lex;
	  lex->sql_command = SQLCOM_CHANGE_MASTER;
	  bzero((char*) &lex->mi, sizeof(lex->mi));
        }
    break;

  case 69:
#line 1397 "sql_yacc.yy"
    {}
    break;

  case 72:
#line 1406 "sql_yacc.yy"
    {
	 Lex->mi.host = yyvsp[0].lex_str.str;
       }
    break;

  case 73:
#line 1411 "sql_yacc.yy"
    {
	 Lex->mi.user = yyvsp[0].lex_str.str;
       }
    break;

  case 74:
#line 1416 "sql_yacc.yy"
    {
	 Lex->mi.password = yyvsp[0].lex_str.str;
       }
    break;

  case 75:
#line 1421 "sql_yacc.yy"
    {
	 Lex->mi.port = yyvsp[0].ulong_num;
       }
    break;

  case 76:
#line 1426 "sql_yacc.yy"
    {
	 Lex->mi.connect_retry = yyvsp[0].ulong_num;
       }
    break;

  case 77:
#line 1430 "sql_yacc.yy"
    {
           Lex->mi.ssl= yyvsp[0].ulong_num ? 
               LEX_MASTER_INFO::SSL_ENABLE : LEX_MASTER_INFO::SSL_DISABLE;
         }
    break;

  case 78:
#line 1435 "sql_yacc.yy"
    {
           Lex->mi.ssl_ca= yyvsp[0].lex_str.str;
         }
    break;

  case 79:
#line 1439 "sql_yacc.yy"
    {
           Lex->mi.ssl_capath= yyvsp[0].lex_str.str;
         }
    break;

  case 80:
#line 1443 "sql_yacc.yy"
    {
           Lex->mi.ssl_cert= yyvsp[0].lex_str.str;
         }
    break;

  case 81:
#line 1447 "sql_yacc.yy"
    {
           Lex->mi.ssl_cipher= yyvsp[0].lex_str.str;
         }
    break;

  case 82:
#line 1451 "sql_yacc.yy"
    {
           Lex->mi.ssl_key= yyvsp[0].lex_str.str;
	 }
    break;

  case 84:
#line 1460 "sql_yacc.yy"
    {
	 Lex->mi.log_file_name = yyvsp[0].lex_str.str;
       }
    break;

  case 85:
#line 1464 "sql_yacc.yy"
    {
           Lex->mi.pos = yyvsp[0].ulonglong_number;
           /* 
              If the user specified a value < BIN_LOG_HEADER_SIZE, adjust it
              instead of causing subsequent errors. 
              We need to do it in this file, because only there we know that 
              MASTER_LOG_POS has been explicitely specified. On the contrary
              in change_master() (sql_repl.cc) we cannot distinguish between 0
              (MASTER_LOG_POS explicitely specified as 0) and 0 (unspecified),
              whereas we want to distinguish (specified 0 means "read the binlog
              from 0" (4 in fact), unspecified means "don't change the position
              (keep the preceding value)").
           */
           Lex->mi.pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.pos);
         }
    break;

  case 86:
#line 1480 "sql_yacc.yy"
    {
           Lex->mi.relay_log_name = yyvsp[0].lex_str.str;
         }
    break;

  case 87:
#line 1484 "sql_yacc.yy"
    {
           Lex->mi.relay_log_pos = yyvsp[0].ulong_num;
           /* Adjust if < BIN_LOG_HEADER_SIZE (same comment as Lex->mi.pos) */
           Lex->mi.relay_log_pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.relay_log_pos);
         }
    break;

  case 88:
#line 1495 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex=Lex;
	  lex->sql_command= SQLCOM_CREATE_TABLE;
	  if (!lex->select_lex.add_table_to_list(thd, yyvsp[0].table, NULL,
						 TL_OPTION_UPDATING,
						 TL_WRITE))
	    MYSQL_YYABORT;
          lex->alter_info.reset();
#ifdef ENABLE_SENNA
	  lex->senna_clear();
#endif
	  lex->col_list.empty();
	  lex->change=NullS;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.options=yyvsp[-3].num | yyvsp[-1].num;
	  lex->create_info.db_type= (enum db_type) lex->thd->variables.table_type;
	  lex->create_info.default_table_charset= NULL;
	}
    break;

  case 89:
#line 1515 "sql_yacc.yy"
    { Lex->current_select= &Lex->select_lex; }
    break;

  case 90:
#line 1517 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command= SQLCOM_CREATE_INDEX;
	    if (!lex->current_select->add_table_to_list(lex->thd, yyvsp[0].table, NULL,
							TL_OPTION_UPDATING))
	      MYSQL_YYABORT;
            lex->alter_info.reset();
            lex->alter_info.flags= ALTER_ADD_INDEX;
	    lex->col_list.empty();
	    lex->change=NullS;
	  }
    break;

  case 91:
#line 1529 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
#ifdef ENABLE_SENNA
            Key *key= new Key(yyvsp[-9].key_type,yyvsp[-7].lex_str.str, yyvsp[-6].key_alg, 0, lex->col_list,
                              lex->senna_flags, lex->senna_initial_n_segments);
            lex->alter_info.key_list.push_back(key);
            lex->senna_clear();
#else /* ENABLE_SENNA */
            Key *key= new Key(yyvsp[-9].key_type, yyvsp[-7].lex_str.str, yyvsp[-6].key_alg, 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);
#endif /* ENABLE_SENNA */
	    lex->col_list.empty();
	  }
    break;

  case 92:
#line 1543 "sql_yacc.yy"
    {
             Lex->create_info.default_table_charset= NULL;
             Lex->create_info.used_fields= 0;
          }
    break;

  case 93:
#line 1548 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command=SQLCOM_CREATE_DB;
	    lex->name=yyvsp[-2].lex_str.str;
            lex->create_info.options=yyvsp[-3].num;
	  }
    break;

  case 94:
#line 1555 "sql_yacc.yy"
    {
            Lex->create_view_mode= VIEW_CREATE_NEW;
            Lex->create_view_algorithm= VIEW_ALGORITHM_UNDEFINED;
            Lex->create_view_suid= TRUE;
	  }
    break;

  case 95:
#line 1561 "sql_yacc.yy"
    {}
    break;

  case 96:
#line 1563 "sql_yacc.yy"
    {
	    Lex->sql_command = SQLCOM_CREATE_USER;
          }
    break;

  case 97:
#line 1570 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          lex->users_list.empty();
          lex->columns.empty();
          lex->grant= lex->grant_tot_col= 0;
	  lex->all_privileges= 0;
          lex->select_lex.db= 0;
          lex->ssl_type= SSL_TYPE_NOT_SPECIFIED;
          lex->ssl_cipher= lex->x509_subject= lex->x509_issuer= 0;
          bzero((char *)&(lex->mqh),sizeof(lex->mqh));
        }
    break;

  case 98:
#line 1585 "sql_yacc.yy"
    {
            if (!yyvsp[-2].lex_str.str || check_db_name(yyvsp[-2].lex_str.str))
            {
	      my_error(ER_WRONG_DB_NAME, MYF(0), yyvsp[-2].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    if (check_routine_name(yyvsp[0].lex_str))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    yyval.spname= new sp_name(yyvsp[-2].lex_str, yyvsp[0].lex_str, true);
	    yyval.spname->init_qname(YYTHD);
	  }
    break;

  case 99:
#line 1600 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
            LEX_STRING db;
	    if (check_routine_name(yyvsp[0].lex_str))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
            if (thd->copy_db_to(&db.str, &db.length))
              MYSQL_YYABORT;
	    yyval.spname= new sp_name(db, yyvsp[0].lex_str, false);
            if (yyval.spname)
	      yyval.spname->init_qname(YYTHD);
	  }
    break;

  case 100:
#line 1618 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            if (lex->definer != NULL)
            {
              /*
                 DEFINER is a concept meaningful when interpreting SQL code.
                 UDF functions are compiled.
                 Using DEFINER with UDF has therefore no semantic,
                 and is considered a parsing error.
              */
	      my_error(ER_WRONG_USAGE, MYF(0), "SONAME", "DEFINER");
              MYSQL_YYABORT;
            }
	    lex->sql_command = SQLCOM_CREATE_FUNCTION;
	    lex->udf.name = lex->spname->m_name;
	    lex->udf.returns=(Item_result) yyvsp[-2].num;
	    lex->udf.dl=yyvsp[0].lex_str.str;
	  }
    break;

  case 101:
#line 1637 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;
	    sp_head *sp;

            /* 
              First check if AGGREGATE was used, in that case it's a
              syntax error.
            */
            if (lex->udf.type == UDFTYPE_AGGREGATE)
            {
              my_error(ER_SP_NO_AGGREGATE, MYF(0));
              MYSQL_YYABORT;
            }

	    if (lex->sphead)
	    {
	      my_error(ER_SP_NO_RECURSIVE_CREATE, MYF(0), "FUNCTION");
	      MYSQL_YYABORT;
	    }
	    /* Order is important here: new - reset - init */
	    sp= new sp_head();
	    sp->reset_thd_mem_root(thd);
	    sp->init(lex);
            sp->init_sp_name(thd, lex->spname);

	    sp->m_type= TYPE_ENUM_FUNCTION;
	    lex->sphead= sp;
	    /*
	     * We have to turn of CLIENT_MULTI_QUERIES while parsing a
	     * stored procedure, otherwise yylex will chop it into pieces
	     * at each ';'.
	     */
	    sp->m_old_cmq= thd->client_capabilities & CLIENT_MULTI_QUERIES;
	    thd->client_capabilities &= ~CLIENT_MULTI_QUERIES;
	    lex->sphead->m_param_begin= lip->tok_start+1;
	  }
    break;

  case 102:
#line 1676 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    lex->sphead->m_param_end= lip->tok_start;
	  }
    break;

  case 103:
#line 1684 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    lex->charset= NULL;
	    lex->length= lex->dec= NULL;
	    lex->interval_list.empty();
	    lex->type= 0;
	  }
    break;

  case 104:
#line 1692 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->fill_field_definition(YYTHD, lex,
                                          (enum enum_field_types) yyvsp[0].num,
                                          &sp->m_return_field_def))
              MYSQL_YYABORT;

	    bzero((char *)&lex->sp_chistics, sizeof(st_sp_chistics));
	  }
    break;

  case 105:
#line 1704 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    lex->sphead->m_chistics= &lex->sp_chistics;
	    lex->sphead->m_body_begin= lip->tok_start;
	  }
    break;

  case 106:
#line 1713 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->is_not_allowed_in_function("function"))
              MYSQL_YYABORT;

	    lex->sql_command= SQLCOM_CREATE_SPFUNCTION;
	    sp->init_strings(YYTHD, lex);
            if (!(sp->m_flags & sp_head::HAS_RETURN))
            {
              my_error(ER_SP_NORETURN, MYF(0), sp->m_qname.str);
              MYSQL_YYABORT;
            }
	    /* Restore flag if it was cleared above */
	    if (sp->m_old_cmq)
	      YYTHD->client_capabilities |= CLIENT_MULTI_QUERIES;
	    sp->restore_thd_mem_root(YYTHD);
	  }
    break;

  case 107:
#line 1735 "sql_yacc.yy"
    {}
    break;

  case 108:
#line 1736 "sql_yacc.yy"
    {}
    break;

  case 109:
#line 1740 "sql_yacc.yy"
    {}
    break;

  case 110:
#line 1741 "sql_yacc.yy"
    {}
    break;

  case 111:
#line 1747 "sql_yacc.yy"
    { Lex->sp_chistics.comment= yyvsp[0].lex_str; }
    break;

  case 112:
#line 1749 "sql_yacc.yy"
    { /* Just parse it, we only have one language for now. */ }
    break;

  case 113:
#line 1751 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_NO_SQL; }
    break;

  case 114:
#line 1753 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_CONTAINS_SQL; }
    break;

  case 115:
#line 1755 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_READS_SQL_DATA; }
    break;

  case 116:
#line 1757 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_MODIFIES_SQL_DATA; }
    break;

  case 117:
#line 1759 "sql_yacc.yy"
    { }
    break;

  case 118:
#line 1764 "sql_yacc.yy"
    { }
    break;

  case 119:
#line 1765 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= TRUE; }
    break;

  case 120:
#line 1766 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= FALSE; }
    break;

  case 121:
#line 1771 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_SUID;
	  }
    break;

  case 122:
#line 1775 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_NOT_SUID;
	  }
    break;

  case 123:
#line 1782 "sql_yacc.yy"
    {
	    LEX *lex = Lex;

	    lex->sql_command= SQLCOM_CALL;
	    lex->spname= yyvsp[0].spname;
	    lex->value_list.empty();
	    sp_add_used_routine(lex, YYTHD, yyvsp[0].spname, TYPE_ENUM_PROCEDURE);
	  }
    break;

  case 124:
#line 1790 "sql_yacc.yy"
    {}
    break;

  case 129:
#line 1806 "sql_yacc.yy"
    {
	    Lex->value_list.push_back(yyvsp[0].item);
	  }
    break;

  case 130:
#line 1810 "sql_yacc.yy"
    {
	    Lex->value_list.push_back(yyvsp[0].item);
	  }
    break;

  case 135:
#line 1828 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->length= 0;
	    lex->dec= 0;
	    lex->type= 0;
	  
	    lex->default_value= 0;
	    lex->on_update_value= 0;
	  
	    lex->comment= null_lex_str;
	    lex->charset= NULL;
	  
	    lex->interval_list.empty();
	    lex->uint_geom_type= 0;
	  }
    break;

  case 136:
#line 1848 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&yyvsp[-2].lex_str, TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), yyvsp[-2].lex_str.str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&yyvsp[-2].lex_str,
                                                     (enum enum_field_types)yyvsp[0].num,
                                                     sp_param_in);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) yyvsp[0].num,
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 141:
#line 1885 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&yyvsp[-1].lex_str, TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), yyvsp[-1].lex_str.str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&yyvsp[-1].lex_str,
                                                     (enum enum_field_types)yyvsp[0].num,
                                                     (sp_param_mode_t)yyvsp[-3].num);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) yyvsp[0].num,
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 142:
#line 1910 "sql_yacc.yy"
    { yyval.num= sp_param_in; }
    break;

  case 143:
#line 1911 "sql_yacc.yy"
    { yyval.num= sp_param_in; }
    break;

  case 144:
#line 1912 "sql_yacc.yy"
    { yyval.num= sp_param_out; }
    break;

  case 145:
#line 1913 "sql_yacc.yy"
    { yyval.num= sp_param_inout; }
    break;

  case 146:
#line 1917 "sql_yacc.yy"
    {}
    break;

  case 148:
#line 1922 "sql_yacc.yy"
    {}
    break;

  case 150:
#line 1928 "sql_yacc.yy"
    {
	    yyval.spblock.vars= yyval.spblock.conds= yyval.spblock.hndlrs= yyval.spblock.curs= 0;
	  }
    break;

  case 151:
#line 1932 "sql_yacc.yy"
    {
	    /* We check for declarations out of (standard) order this way
	       because letting the grammar rules reflect it caused tricky
	       shift/reduce conflicts with the wrong result. (And we get
	       better error handling this way.) */
	    if ((yyvsp[-1].spblock.vars || yyvsp[-1].spblock.conds) && (yyvsp[-2].spblock.curs || yyvsp[-2].spblock.hndlrs))
	    { /* Variable or condition following cursor or handler */
	      my_message(ER_SP_VARCOND_AFTER_CURSHNDLR,
                         ER(ER_SP_VARCOND_AFTER_CURSHNDLR), MYF(0));
	      MYSQL_YYABORT;
	    }
	    if (yyvsp[-1].spblock.curs && yyvsp[-2].spblock.hndlrs)
	    { /* Cursor following handler */
	      my_message(ER_SP_CURSOR_AFTER_HANDLER,
                         ER(ER_SP_CURSOR_AFTER_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    yyval.spblock.vars= yyvsp[-2].spblock.vars + yyvsp[-1].spblock.vars;
	    yyval.spblock.conds= yyvsp[-2].spblock.conds + yyvsp[-1].spblock.conds;
	    yyval.spblock.hndlrs= yyvsp[-2].spblock.hndlrs + yyvsp[-1].spblock.hndlrs;
	    yyval.spblock.curs= yyvsp[-2].spblock.curs + yyvsp[-1].spblock.curs;
	  }
    break;

  case 152:
#line 1958 "sql_yacc.yy"
    {
            LEX *lex= Lex;

            lex->sphead->reset_lex(YYTHD);
            lex->spcont->declare_var_boundary(yyvsp[0].num);
          }
    break;

  case 153:
#line 1966 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *pctx= lex->spcont;
            uint num_vars= pctx->context_var_count();
            enum enum_field_types var_type= (enum enum_field_types) yyvsp[-1].num;
            Item *dflt_value_item= yyvsp[0].item;
            
            if (!dflt_value_item)
            {
              dflt_value_item= new Item_null();
              /* QQ Set to the var_type with null_value? */
            }
            
            for (uint i = num_vars-yyvsp[-3].num ; i < num_vars ; i++)
            {
              uint var_idx= pctx->var_context2runtime(i);
              sp_variable_t *spvar= pctx->find_variable(var_idx);
            
              if (!spvar)
                MYSQL_YYABORT;
            
              spvar->type= var_type;
              spvar->dflt= dflt_value_item;
            
              if (lex->sphead->fill_field_definition(YYTHD, lex, var_type,
                                                     &spvar->field_def))
              {
                MYSQL_YYABORT;
              }
            
              spvar->field_def.field_name= spvar->name.str;
              spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
            
              /* The last instruction is responsible for freeing LEX. */

              lex->sphead->add_instr(
                new sp_instr_set(lex->sphead->instructions(), pctx, var_idx,
                                 dflt_value_item, var_type, lex,
                                 (i == num_vars - 1)));
            }

            pctx->declare_var_boundary(0);
            lex->sphead->restore_lex(YYTHD);

            yyval.spblock.vars= yyvsp[-3].num;
            yyval.spblock.conds= yyval.spblock.hndlrs= yyval.spblock.curs= 0;
          }
    break;

  case 154:
#line 2014 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_cond(&yyvsp[-3].lex_str, TRUE))
	    {
	      my_error(ER_SP_DUP_COND, MYF(0), yyvsp[-3].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    YYTHD->lex->spcont->push_cond(&yyvsp[-3].lex_str, yyvsp[0].spcondtype);
	    yyval.spblock.vars= yyval.spblock.hndlrs= yyval.spblock.curs= 0;
	    yyval.spblock.conds= 1;
	  }
    break;

  case 155:
#line 2028 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            lex->spcont= lex->spcont->push_context(LABEL_HANDLER_SCOPE);

	    sp_pcontext *ctx= lex->spcont;
	    sp_instr_hpush_jump *i=
              new sp_instr_hpush_jump(sp->instructions(), ctx, yyvsp[-2].num,
	                              ctx->current_var_count());

	    sp->add_instr(i);
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 156:
#line 2043 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *hlab= lex->spcont->pop_label(); /* After this hdlr */
	    sp_instr_hreturn *i;

	    if (yyvsp[-5].num == SP_HANDLER_CONTINUE)
	    {
	      i= new sp_instr_hreturn(sp->instructions(), ctx,
	                              ctx->current_var_count());
	      sp->add_instr(i);
	    }
	    else
	    {  /* EXIT or UNDO handler, just jump to the end of the block */
	      i= new sp_instr_hreturn(sp->instructions(), ctx, 0);

	      sp->add_instr(i);
	      sp->push_backpatch(i, lex->spcont->last_label()); /* Block end */
	    }
	    lex->sphead->backpatch(hlab);

            lex->spcont= ctx->pop_context();

	    yyval.spblock.vars= yyval.spblock.conds= yyval.spblock.curs= 0;
	    yyval.spblock.hndlrs= yyvsp[-1].num;
	    lex->spcont->add_handlers(yyvsp[-1].num);
	  }
    break;

  case 157:
#line 2072 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint offp;
	    sp_instr_cpush *i;

	    if (ctx->find_cursor(&yyvsp[-3].lex_str, &offp, TRUE))
	    {
	      my_error(ER_SP_DUP_CURS, MYF(0), yyvsp[-3].lex_str.str);
	      delete yyvsp[0].lex;
	      MYSQL_YYABORT;
	    }
            i= new sp_instr_cpush(sp->instructions(), ctx, yyvsp[0].lex,
                                  ctx->current_cursor_count());
	    sp->add_instr(i);
	    ctx->push_cursor(&yyvsp[-3].lex_str);
	    yyval.spblock.vars= yyval.spblock.conds= yyval.spblock.hndlrs= 0;
	    yyval.spblock.curs= 1;
	  }
    break;

  case 158:
#line 2095 "sql_yacc.yy"
    {
	    Lex->sphead->reset_lex(YYTHD);

	    /* We use statement here just be able to get a better
	       error message. Using 'select' works too, but will then
	       result in a generic "syntax error" if a non-select
	       statement is given. */
	  }
    break;

  case 159:
#line 2104 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sql_command != SQLCOM_SELECT)
	    {
	      my_message(ER_SP_BAD_CURSOR_QUERY, ER(ER_SP_BAD_CURSOR_QUERY),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    if (lex->result)
	    {
	      my_message(ER_SP_BAD_CURSOR_SELECT, ER(ER_SP_BAD_CURSOR_SELECT),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    lex->sp_lex_in_use= TRUE;
	    yyval.lex= lex;
	    lex->sphead->restore_lex(YYTHD);
	  }
    break;

  case 160:
#line 2126 "sql_yacc.yy"
    { yyval.num= SP_HANDLER_EXIT; }
    break;

  case 161:
#line 2127 "sql_yacc.yy"
    { yyval.num= SP_HANDLER_CONTINUE; }
    break;

  case 162:
#line 2133 "sql_yacc.yy"
    { yyval.num= 1; }
    break;

  case 163:
#line 2135 "sql_yacc.yy"
    { yyval.num+= 1; }
    break;

  case 164:
#line 2140 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont->parent_context();

	    if (ctx->find_handler(yyvsp[0].spcondtype))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
                (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition(yyvsp[0].spcondtype);
	      ctx->push_handler(yyvsp[0].spcondtype);
	    }
	  }
    break;

  case 165:
#line 2163 "sql_yacc.yy"
    {			/* mysql errno */
	    yyval.spcondtype= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    yyval.spcondtype->type= sp_cond_type_t::number;
	    yyval.spcondtype->mysqlerr= yyvsp[0].ulong_num;
	  }
    break;

  case 166:
#line 2169 "sql_yacc.yy"
    {		/* SQLSTATE */
	    if (!sp_cond_check(&yyvsp[0].lex_str))
	    {
	      my_error(ER_SP_BAD_SQLSTATE, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    yyval.spcondtype= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    yyval.spcondtype->type= sp_cond_type_t::state;
	    memcpy(yyval.spcondtype->sqlstate, yyvsp[0].lex_str.str, 5);
	    yyval.spcondtype->sqlstate[5]= '\0';
	  }
    break;

  case 167:
#line 2183 "sql_yacc.yy"
    {}
    break;

  case 168:
#line 2184 "sql_yacc.yy"
    {}
    break;

  case 169:
#line 2189 "sql_yacc.yy"
    {
	    yyval.spcondtype= yyvsp[0].spcondtype;
	  }
    break;

  case 170:
#line 2193 "sql_yacc.yy"
    {
	    yyval.spcondtype= Lex->spcont->find_cond(&yyvsp[0].lex_str);
	    if (yyval.spcondtype == NULL)
	    {
	      my_error(ER_SP_COND_MISMATCH, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	  }
    break;

  case 171:
#line 2202 "sql_yacc.yy"
    {
	    yyval.spcondtype= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    yyval.spcondtype->type= sp_cond_type_t::warning;
	  }
    break;

  case 172:
#line 2207 "sql_yacc.yy"
    {
	    yyval.spcondtype= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    yyval.spcondtype->type= sp_cond_type_t::notfound;
	  }
    break;

  case 173:
#line 2212 "sql_yacc.yy"
    {
	    yyval.spcondtype= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    yyval.spcondtype->type= sp_cond_type_t::exception;
	  }
    break;

  case 174:
#line 2220 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&yyvsp[0].lex_str, TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&yyvsp[0].lex_str, (enum_field_types)0, sp_param_in);
	    yyval.num= 1;
	  }
    break;

  case 175:
#line 2235 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&yyvsp[0].lex_str, TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&yyvsp[0].lex_str, (enum_field_types)0, sp_param_in);
	    yyval.num= yyvsp[-2].num + 1;
	  }
    break;

  case 176:
#line 2252 "sql_yacc.yy"
    { yyval.item = NULL; }
    break;

  case 177:
#line 2253 "sql_yacc.yy"
    { yyval.item = yyvsp[0].item; }
    break;

  case 178:
#line 2257 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    lex->sphead->reset_lex(thd);
	    lex->sphead->m_tmp_query= lip->tok_start;
	  }
    break;

  case 179:
#line 2266 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;
	    sp_head *sp= lex->sphead;

            sp->m_flags|= sp_get_flags_for_command(lex);
	    if (lex->sql_command == SQLCOM_CHANGE_DB)
	    { /* "USE db" doesn't work in a procedure */
	      my_error(ER_SP_BADSTATEMENT, MYF(0), "USE");
	      MYSQL_YYABORT;
	    }
	    /*
              Don't add an instruction for SET statements, since all
              instructions for them were already added during processing
              of "set" rule.
	    */
            DBUG_ASSERT(lex->sql_command != SQLCOM_SET_OPTION ||
                        lex->var_list.is_empty());
            if (lex->sql_command != SQLCOM_SET_OPTION)
	    {
              sp_instr_stmt *i=new sp_instr_stmt(sp->instructions(),
                                                 lex->spcont, lex);

              /*
                Extract the query statement from the tokenizer.  The
                end is either lex->ptr, if there was no lookahead,
                lex->tok_end otherwise.
              */
              if (yychar == YYEMPTY)
                i->m_query.length= lip->ptr - sp->m_tmp_query;
              else
                i->m_query.length= lip->tok_end - sp->m_tmp_query;
              i->m_query.str= strmake_root(thd->mem_root,
                                           sp->m_tmp_query,
                                           i->m_query.length);
              sp->add_instr(i);
            }
	    sp->restore_lex(thd);
          }
    break;

  case 180:
#line 2307 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 181:
#line 2309 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

	    if (sp->m_type != TYPE_ENUM_FUNCTION)
	    {
	      my_message(ER_SP_BADRETURN, ER(ER_SP_BADRETURN), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_freturn *i;

	      i= new sp_instr_freturn(sp->instructions(), lex->spcont, yyvsp[0].item,
                                      sp->m_return_field_def.sql_type, lex);
	      sp->add_instr(i);
	      sp->m_flags|= sp_head::HAS_RETURN;
	    }
	    sp->restore_lex(YYTHD);
	  }
    break;

  case 182:
#line 2330 "sql_yacc.yy"
    { Lex->sphead->new_cont_backpatch(NULL); }
    break;

  case 183:
#line 2332 "sql_yacc.yy"
    { Lex->sphead->do_cont_backpatch(); }
    break;

  case 185:
#line 2335 "sql_yacc.yy"
    {}
    break;

  case 186:
#line 2336 "sql_yacc.yy"
    { /* Unlabeled controls get a secret label. */
	    LEX *lex= Lex;

	    lex->spcont->push_label((char *)"", lex->sphead->instructions());
	  }
    break;

  case 187:
#line 2342 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 188:
#line 2348 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp = lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label(yyvsp[0].lex_str.str);

	    if (! lab)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "LEAVE", yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx);
	      sp->push_backpatch(i, lab);  /* Jumping forward */
              sp->add_instr(i);
	    }
	  }
    break;

  case 189:
#line 2377 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label(yyvsp[0].lex_str.str);

	    if (! lab || lab->type != SP_LAB_ITER)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "ITERATE", yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx, lab->ip); /* Jump back */
              sp->add_instr(i);
	    }
	  }
    break;

  case 190:
#line 2405 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_copen *i;

	    if (! lex->spcont->find_cursor(&yyvsp[0].lex_str, &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_copen(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 191:
#line 2420 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cfetch *i;

	    if (! lex->spcont->find_cursor(&yyvsp[-1].lex_str, &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), yyvsp[-1].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cfetch(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 192:
#line 2435 "sql_yacc.yy"
    { }
    break;

  case 193:
#line 2437 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cclose *i;

	    if (! lex->spcont->find_cursor(&yyvsp[0].lex_str, &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cclose(sp->instructions(), lex->spcont,  offset);
	    sp->add_instr(i);
	  }
    break;

  case 197:
#line 2461 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&yyvsp[0].lex_str)))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 198:
#line 2482 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&yyvsp[0].lex_str)))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 199:
#line 2504 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 200:
#line 2506 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, ctx,
                                                               yyvsp[-1].item, lex);

	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
            sp->add_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 201:
#line 2520 "sql_yacc.yy"
    {
	    sp_head *sp= Lex->sphead;
	    sp_pcontext *ctx= Lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump *i = new sp_instr_jump(ip, ctx);

	    sp->add_instr(i);
	    sp->backpatch(ctx->pop_label());
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 202:
#line 2531 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 208:
#line 2551 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
            lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 209:
#line 2557 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (case_stmt_action_expr(lex, yyvsp[0].item))
              MYSQL_YYABORT;

            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 210:
#line 2568 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, true);
          }
    break;

  case 211:
#line 2576 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
          }
    break;

  case 212:
#line 2584 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, false);
          }
    break;

  case 217:
#line 2602 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 218:
#line 2606 "sql_yacc.yy"
    {
            /* Simple case: <caseval> = <whenval> */

            LEX *lex= Lex;
            case_stmt_action_when(lex, yyvsp[0].item, true);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 219:
#line 2615 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 220:
#line 2623 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 221:
#line 2627 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_when(lex, yyvsp[0].item, false);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 222:
#line 2634 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 223:
#line 2642 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_head *sp= lex->sphead;
            uint ip= sp->instructions();
            sp_instr_error *i= new sp_instr_error(ip, lex->spcont,
                                                  ER_SP_CASE_NOT_FOUND);
            sp->add_instr(i);
          }
    break;

  case 225:
#line 2655 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label(yyvsp[-1].lex_str.str);

	    if (lab)
	    {
	      my_error(ER_SP_LABEL_REDEFINE, MYF(0), yyvsp[-1].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      lab= lex->spcont->push_label(yyvsp[-1].lex_str.str,
	                                   lex->sphead->instructions());
	      lab->type= SP_LAB_ITER;
	    }
	  }
    break;

  case 226:
#line 2673 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (yyvsp[0].lex_str.str)
	    {
	      sp_label_t *lab= lex->spcont->find_label(yyvsp[0].lex_str.str);

	      if (!lab ||
	          my_strcasecmp(system_charset_info, yyvsp[0].lex_str.str, lab->name) != 0)
	      {
	        my_error(ER_SP_LABEL_MISMATCH, MYF(0), yyvsp[0].lex_str.str);
	        MYSQL_YYABORT;
	      }
	    }
	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 227:
#line 2692 "sql_yacc.yy"
    { yyval.lex_str= null_lex_str; }
    break;

  case 228:
#line 2693 "sql_yacc.yy"
    { yyval.lex_str= yyvsp[0].lex_str; }
    break;

  case 229:
#line 2698 "sql_yacc.yy"
    { /* QQ This is just a dummy for grouping declarations and statements
	       together. No [[NOT] ATOMIC] yet, and we need to figure out how
	       make it coexist with the existing BEGIN COMMIT/ROLLBACK. */
	    LEX *lex= Lex;
	    sp_label_t *lab= lex->spcont->last_label();

	    lab->type= SP_LAB_BEGIN;
	    lex->spcont= lex->spcont->push_context(LABEL_DEFAULT_SCOPE);
	  }
    break;

  case 230:
#line 2710 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

  	    sp->backpatch(ctx->last_label());	/* We always have a label */
	    if (yyvsp[-2].spblock.hndlrs)
	      sp->add_instr(new sp_instr_hpop(sp->instructions(), ctx,
					      yyvsp[-2].spblock.hndlrs));
	    if (yyvsp[-2].spblock.curs)
	      sp->add_instr(new sp_instr_cpop(sp->instructions(), ctx,
					      yyvsp[-2].spblock.curs));
	    lex->spcont= ctx->pop_context();
	  }
    break;

  case 231:
#line 2726 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
	  }
    break;

  case 232:
#line 2735 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 233:
#line 2737 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
							       yyvsp[-1].item, lex);

	    /* Jumping forward */
	    sp->push_backpatch(i, lex->spcont->last_label());
            sp->new_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 234:
#line 2751 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
            lex->sphead->do_cont_backpatch();
	  }
    break;

  case 235:
#line 2761 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 236:
#line 2763 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
                                                               yyvsp[-2].item, lab->ip,
                                                               lex);
            lex->sphead->add_instr(i);
            lex->sphead->restore_lex(YYTHD);
            /* We can shortcut the cont_backpatch here */
            i->m_cont_dest= ip+1;
	  }
    break;

  case 237:
#line 2779 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_BEFORE; }
    break;

  case 238:
#line 2781 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_AFTER; }
    break;

  case 239:
#line 2786 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_INSERT; }
    break;

  case 240:
#line 2788 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_UPDATE; }
    break;

  case 241:
#line 2790 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_DELETE; }
    break;

  case 242:
#line 2794 "sql_yacc.yy"
    {}
    break;

  case 243:
#line 2795 "sql_yacc.yy"
    {}
    break;

  case 244:
#line 2797 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, yyvsp[0].table, NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 245:
#line 2803 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, yyvsp[-1].table, NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 246:
#line 2811 "sql_yacc.yy"
    {}
    break;

  case 247:
#line 2812 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 248:
#line 2812 "sql_yacc.yy"
    {}
    break;

  case 249:
#line 2816 "sql_yacc.yy"
    {}
    break;

  case 250:
#line 2818 "sql_yacc.yy"
    { Select->set_braces(0);}
    break;

  case 251:
#line 2818 "sql_yacc.yy"
    {}
    break;

  case 252:
#line 2820 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 253:
#line 2820 "sql_yacc.yy"
    {}
    break;

  case 254:
#line 2825 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->lock_option= using_update_log ? TL_READ_NO_INSERT : TL_READ;
	    if (lex->sql_command == SQLCOM_INSERT)
	      lex->sql_command= SQLCOM_INSERT_SELECT;
	    else if (lex->sql_command == SQLCOM_REPLACE)
	      lex->sql_command= SQLCOM_REPLACE_SELECT;
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    lex->current_select->table_list.save_and_clear(&lex->save_list);
	    mysql_init_select(lex);
	    lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 255:
#line 2841 "sql_yacc.yy"
    {
	    Select->parsing_place= NO_MATTER;
	  }
    break;

  case 256:
#line 2845 "sql_yacc.yy"
    {
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    Lex->current_select->table_list.push_front(&Lex->save_list);
	  }
    break;

  case 257:
#line 2855 "sql_yacc.yy"
    {}
    break;

  case 258:
#line 2856 "sql_yacc.yy"
    {}
    break;

  case 259:
#line 2859 "sql_yacc.yy"
    {}
    break;

  case 260:
#line 2860 "sql_yacc.yy"
    {}
    break;

  case 261:
#line 2863 "sql_yacc.yy"
    {}
    break;

  case 262:
#line 2864 "sql_yacc.yy"
    {}
    break;

  case 263:
#line 2867 "sql_yacc.yy"
    {}
    break;

  case 264:
#line 2868 "sql_yacc.yy"
    {}
    break;

  case 265:
#line 2871 "sql_yacc.yy"
    { yyval.num= 0; }
    break;

  case 266:
#line 2872 "sql_yacc.yy"
    { yyval.num= yyvsp[0].num;}
    break;

  case 267:
#line 2875 "sql_yacc.yy"
    { yyval.num=yyvsp[0].num; }
    break;

  case 268:
#line 2876 "sql_yacc.yy"
    { yyval.num= yyvsp[-1].num | yyvsp[0].num; }
    break;

  case 269:
#line 2879 "sql_yacc.yy"
    { yyval.num=HA_LEX_CREATE_TMP_TABLE; }
    break;

  case 270:
#line 2882 "sql_yacc.yy"
    { yyval.num= 0; }
    break;

  case 271:
#line 2883 "sql_yacc.yy"
    { yyval.num=HA_LEX_CREATE_IF_NOT_EXISTS; }
    break;

  case 279:
#line 2899 "sql_yacc.yy"
    { Lex->create_info.db_type= yyvsp[0].db_type; Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 280:
#line 2900 "sql_yacc.yy"
    { Lex->create_info.db_type= yyvsp[0].db_type; WARN_DEPRECATED("TYPE=storage_engine","ENGINE=storage_engine");   Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 281:
#line 2901 "sql_yacc.yy"
    { Lex->create_info.max_rows= yyvsp[0].ulonglong_number; Lex->create_info.used_fields|= HA_CREATE_USED_MAX_ROWS;}
    break;

  case 282:
#line 2902 "sql_yacc.yy"
    { Lex->create_info.min_rows= yyvsp[0].ulonglong_number; Lex->create_info.used_fields|= HA_CREATE_USED_MIN_ROWS;}
    break;

  case 283:
#line 2903 "sql_yacc.yy"
    { Lex->create_info.avg_row_length=yyvsp[0].ulong_num; Lex->create_info.used_fields|= HA_CREATE_USED_AVG_ROW_LENGTH;}
    break;

  case 284:
#line 2904 "sql_yacc.yy"
    { Lex->create_info.password=yyvsp[0].lex_str.str; Lex->create_info.used_fields|= HA_CREATE_USED_PASSWORD; }
    break;

  case 285:
#line 2905 "sql_yacc.yy"
    { Lex->create_info.comment=yyvsp[0].lex_str; Lex->create_info.used_fields|= HA_CREATE_USED_COMMENT; }
    break;

  case 286:
#line 2906 "sql_yacc.yy"
    { Lex->create_info.auto_increment_value=yyvsp[0].ulonglong_number; Lex->create_info.used_fields|= HA_CREATE_USED_AUTO;}
    break;

  case 287:
#line 2908 "sql_yacc.yy"
    {
            switch(yyvsp[0].ulong_num) {
            case 0:
                Lex->create_info.table_options|= HA_OPTION_NO_PACK_KEYS;
                break;
            case 1:
                Lex->create_info.table_options|= HA_OPTION_PACK_KEYS;
                break;
            default:
                my_parse_error(ER(ER_SYNTAX_ERROR));
                MYSQL_YYABORT;
            }
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 288:
#line 2923 "sql_yacc.yy"
    {
            Lex->create_info.table_options&=
              ~(HA_OPTION_PACK_KEYS | HA_OPTION_NO_PACK_KEYS);
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 289:
#line 2928 "sql_yacc.yy"
    { Lex->create_info.table_options|= yyvsp[0].ulong_num ? HA_OPTION_CHECKSUM : HA_OPTION_NO_CHECKSUM; Lex->create_info.used_fields|= HA_CREATE_USED_CHECKSUM; }
    break;

  case 290:
#line 2929 "sql_yacc.yy"
    { Lex->create_info.table_options|= yyvsp[0].ulong_num ? HA_OPTION_DELAY_KEY_WRITE : HA_OPTION_NO_DELAY_KEY_WRITE;  Lex->create_info.used_fields|= HA_CREATE_USED_DELAY_KEY_WRITE; }
    break;

  case 291:
#line 2930 "sql_yacc.yy"
    { Lex->create_info.row_type= yyvsp[0].row_type;  Lex->create_info.used_fields|= HA_CREATE_USED_ROW_FORMAT; }
    break;

  case 292:
#line 2932 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_TYPE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 293:
#line 2937 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKS", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 294:
#line 2942 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKSIZE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 295:
#line 2947 "sql_yacc.yy"
    {
	    /* Move the union list to the merge_list */
	    LEX *lex=Lex;
	    TABLE_LIST *table_list= lex->select_lex.get_table_list();
	    lex->create_info.merge_list= lex->select_lex.table_list;
	    lex->create_info.merge_list.elements--;
	    lex->create_info.merge_list.first=
	      (byte*) (table_list->next_local);
	    lex->select_lex.table_list.elements=1;
	    lex->select_lex.table_list.next=
	      (byte**) &(table_list->next_local);
	    table_list->next_local= 0;
	    lex->create_info.used_fields|= HA_CREATE_USED_UNION;
	  }
    break;

  case 298:
#line 2963 "sql_yacc.yy"
    { Lex->create_info.merge_insert_method= yyvsp[0].ulong_num; Lex->create_info.used_fields|= HA_CREATE_USED_INSERT_METHOD;}
    break;

  case 299:
#line 2964 "sql_yacc.yy"
    { Lex->create_info.data_file_name= yyvsp[0].lex_str.str; Lex->create_info.used_fields|= HA_CREATE_USED_DATADIR; }
    break;

  case 300:
#line 2965 "sql_yacc.yy"
    { Lex->create_info.index_file_name= yyvsp[0].lex_str.str;  Lex->create_info.used_fields|= HA_CREATE_USED_INDEXDIR; }
    break;

  case 301:
#line 2966 "sql_yacc.yy"
    { Lex->create_info.connect_string.str= yyvsp[0].lex_str.str; Lex->create_info.connect_string.length= yyvsp[0].lex_str.length;  Lex->create_info.used_fields|= HA_CREATE_USED_CONNECTION; }
    break;

  case 302:
#line 2971 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && yyvsp[0].charset &&
               !my_charset_same(cinfo->default_table_charset,yyvsp[0].charset))
          {
            my_error(ER_CONFLICTING_DECLARATIONS, MYF(0),
                     "CHARACTER SET ", cinfo->default_table_charset->csname,
                     "CHARACTER SET ", yyvsp[0].charset->csname);
            MYSQL_YYABORT;
          }
	  Lex->create_info.default_table_charset= yyvsp[0].charset;
          Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 303:
#line 2988 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && yyvsp[0].charset &&
               !my_charset_same(cinfo->default_table_charset,yyvsp[0].charset))
            {
              my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       yyvsp[0].charset->name, cinfo->default_table_charset->csname);
              MYSQL_YYABORT;
            }
            Lex->create_info.default_table_charset= yyvsp[0].charset;
            Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 304:
#line 3004 "sql_yacc.yy"
    {
	  yyval.db_type = ha_resolve_by_name(yyvsp[0].lex_str.str,yyvsp[0].lex_str.length);
	  if (yyval.db_type == DB_TYPE_UNKNOWN) {
	    my_error(ER_UNKNOWN_STORAGE_ENGINE, MYF(0), yyvsp[0].lex_str.str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 305:
#line 3013 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_DEFAULT; }
    break;

  case 306:
#line 3014 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_FIXED; }
    break;

  case 307:
#line 3015 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_DYNAMIC; }
    break;

  case 308:
#line 3016 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_COMPRESSED; }
    break;

  case 309:
#line 3017 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_REDUNDANT; }
    break;

  case 310:
#line 3018 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_COMPACT; }
    break;

  case 311:
#line 3021 "sql_yacc.yy"
    { yyval.ulong_num= RAID_TYPE_0; }
    break;

  case 312:
#line 3022 "sql_yacc.yy"
    { yyval.ulong_num= RAID_TYPE_0; }
    break;

  case 313:
#line 3023 "sql_yacc.yy"
    { yyval.ulong_num=yyvsp[0].ulong_num;}
    break;

  case 314:
#line 3026 "sql_yacc.yy"
    { yyval.ulong_num= MERGE_INSERT_DISABLED; }
    break;

  case 315:
#line 3027 "sql_yacc.yy"
    { yyval.ulong_num= MERGE_INSERT_TO_FIRST; }
    break;

  case 316:
#line 3028 "sql_yacc.yy"
    { yyval.ulong_num= MERGE_INSERT_TO_LAST; }
    break;

  case 317:
#line 3031 "sql_yacc.yy"
    {}
    break;

  case 319:
#line 3035 "sql_yacc.yy"
    { yyval.udf_type = UDFTYPE_FUNCTION; }
    break;

  case 320:
#line 3036 "sql_yacc.yy"
    { yyval.udf_type = UDFTYPE_AGGREGATE; }
    break;

  case 321:
#line 3039 "sql_yacc.yy"
    {yyval.num = (int) STRING_RESULT; }
    break;

  case 322:
#line 3040 "sql_yacc.yy"
    {yyval.num = (int) REAL_RESULT; }
    break;

  case 323:
#line 3041 "sql_yacc.yy"
    {yyval.num = (int) DECIMAL_RESULT; }
    break;

  case 324:
#line 3042 "sql_yacc.yy"
    {yyval.num = (int) INT_RESULT; }
    break;

  case 330:
#line 3057 "sql_yacc.yy"
    {
#ifdef ENABLE_SENNA
            Lex->senna_clear();
#endif /* ENABLE_SENNA */
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 331:
#line 3067 "sql_yacc.yy"
    {
            LEX *lex=Lex;
#ifdef ENABLE_SENNA
            Key *key= new Key(yyvsp[-5].key_type,yyvsp[-4].simple_string, yyvsp[-3].key_alg, 0, lex->col_list,
                              lex->senna_flags, lex->senna_initial_n_segments);
            lex->alter_info.key_list.push_back(key);
            lex->senna_clear();
#else /* ENABLE_SENNA */
            Key *key= new Key(yyvsp[-5].key_type, yyvsp[-4].simple_string, yyvsp[-3].key_alg, 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);
#endif /* ENABLE_SENNA */
            lex->col_list.empty();              /* Alloced by sql_alloc */
	  }
    break;

  case 332:
#line 3081 "sql_yacc.