/*
 * Decompiled with CFR 0.152.
 */
package ts.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import ts.util.file.DirectoryNotEmptyException;
import ts.util.file.FileAlreadyExistsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileOperation {
    protected FileOperation() {
    }

    public static List<File> list(File file) throws FileNotFoundException, IOException {
        assert (file != null) : "@param:baseDir is null.";
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        LinkedList<File> linkedList = new LinkedList<File>();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            if (!file.isDirectory()) {
                linkedList.add(file);
                return linkedList;
            }
            throw new IOException(file.getPath());
        }
        for (int i = 0; i < fileArray.length; ++i) {
            linkedList.add(fileArray[i]);
        }
        return linkedList;
    }

    public static List<File> listRecursive(File file) throws FileNotFoundException, IOException {
        assert (file != null) : "@param:baseDir is null.";
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        LinkedList<File> linkedList = new LinkedList<File>();
        if (!file.isDirectory()) {
            linkedList.add(file);
            return linkedList;
        }
        return FileOperation.listInner(file, linkedList);
    }

    private static List<File> listInner(File file, List<File> list) throws IOException {
        assert (file != null) : "@param:dir is null.";
        assert (list != null) : "@param:fileLst is null.";
        assert (file.exists()) : "@param:dir does not exist.";
        assert (file.isDirectory()) : "@param:dir is not a directory.";
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException(file.getPath());
        }
        for (int i = 0; i < fileArray.length; ++i) {
            list.add(fileArray[i]);
            if (!fileArray[i].isDirectory()) continue;
            FileOperation.listInner(fileArray[i], list);
        }
        return list;
    }

    public static void delete(File file) throws FileNotFoundException, DirectoryNotEmptyException, IOException {
        assert (file != null) : "@parm:file is null.";
        if (!file.delete()) {
            if (!file.exists()) {
                throw new FileNotFoundException(file.getPath());
            }
            if (file.isDirectory() && file.list().length > 0) {
                throw new DirectoryNotEmptyException(file.getPath());
            }
            throw new IOException(file.getPath());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void deleteRecursive(File file) throws FileNotFoundException, IOException {
        assert (file != null) : "@parm:file is null.";
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        if (!file.isDirectory()) {
            if (file.delete()) return;
            throw new IOException(file.getPath());
        }
        File file2 = FileOperation.createTempDirectory("__del", "", file.getParentFile());
        if (file.renameTo(new File(file2, file.getName()))) {
            FileOperation.deleteInner(file2);
            return;
        }
        FileOperation.deleteInner(file2);
        throw new IOException(file.getPath());
    }

    private static void deleteInner(File file) throws IOException {
        assert (file != null) : "@param:dir is null.";
        assert (file.exists()) : "@param:dir does not exist.";
        assert (file.isDirectory()) : "@param:dir is not a directory.";
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException(file.getPath());
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                FileOperation.deleteInner(fileArray[i]);
                continue;
            }
            if (fileArray[i].delete()) continue;
            throw new IOException(file.getPath());
        }
        if (!file.delete()) {
            throw new IOException(file.getPath());
        }
    }

    public static void copy(File file, File file2) throws FileNotFoundException, DirectoryNotEmptyException, FileAlreadyExistsException, IOException {
        assert (file != null) : "@param:src is null.";
        assert (file2 != null) : "@param:dst is null.";
        if (file.isDirectory()) {
            if (file2.exists()) {
                throw new FileAlreadyExistsException(file2.getPath());
            }
            if (file.list().length > 0) {
                throw new DirectoryNotEmptyException(file.getPath());
            }
            file2.mkdirs();
            return;
        }
        if (file2.exists()) {
            throw new FileAlreadyExistsException(file2.getPath());
        }
        FileOperation.copyFile(file, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File file, File file2) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while (fileInputStream.read(byArray) >= 0) {
                fileOutputStream.write(byArray);
            }
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void copyRecursive(File file, File file2) throws FileNotFoundException, FileAlreadyExistsException, IOException {
        assert (file != null) : "@param:src is null.";
        assert (file2 != null) : "@param:dst is null.";
        if (file2.exists()) {
            throw new FileAlreadyExistsException(file2.getPath());
        }
        if (file.isDirectory()) {
            FileOperation.copyInner(file, file2);
        } else {
            FileOperation.copyFile(file, file2);
        }
    }

    private static void copyInner(File file, File file2) throws IOException {
        assert (file != null) : "@param:src is null.";
        assert (file2 != null) : "@param:dst is null.";
        assert (file.exists()) : "@param:src does not exists.";
        assert (file.isDirectory()) : "@param:src is not a directory.";
        assert (!file2.exists()) : "@param:dst already exists.";
        file2.mkdirs();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException(file.getPath());
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = new File(file2, fileArray[i].getName());
            if (fileArray[i].isDirectory()) {
                FileOperation.copyInner(fileArray[i], file3);
                continue;
            }
            FileOperation.copyFile(fileArray[i], file3);
        }
    }

    public static void move(File file, File file2) throws FileAlreadyExistsException, DirectoryNotEmptyException, IOException {
        assert (file != null) : "@param:src is null.";
        assert (file2 != null) : "@param:dst is null.";
        if (file.isDirectory()) {
            if (file2.exists()) {
                throw new FileAlreadyExistsException(file2.getPath());
            }
            if (file.list().length > 0) {
                throw new DirectoryNotEmptyException(file.getPath());
            }
            file.renameTo(file2);
            return;
        }
        if (file2.exists()) {
            throw new FileAlreadyExistsException(file2.getPath());
        }
        file.renameTo(file2);
    }

    public static void moveRecursive(File file, File file2) throws FileAlreadyExistsException, DirectoryNotEmptyException, IOException {
        assert (file != null) : "@param:src is null.";
        assert (file2 != null) : "@param:dst is null.";
        if (file2.exists()) {
            throw new FileAlreadyExistsException(file2.getPath());
        }
        file.renameTo(file2);
    }

    public static File createTempFile(String string, String string2, File file) throws IllegalArgumentException, IOException {
        assert (string != null) : "@param:prefix is null.";
        assert (string2 != null) : "@param:prefix is null.";
        assert (file != null) : "@param:dir is null.";
        return File.createTempFile(string, string2, file);
    }

    public static File createTempDirectory(String string, String string2, File file) throws IllegalArgumentException, IOException {
        assert (string != null) : "@param:prefix is null.";
        assert (string2 != null) : "@param:prefix is null.";
        assert (file != null) : "@param:dir is null.";
        File file2 = File.createTempFile(string, string2, file);
        file2.delete();
        file2.mkdirs();
        return file2;
    }
}

