/*
 * ElementTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.resource.hierarchy;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import java.util.*;

/**
 * <code>Element</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/15 15:28:05 $
 */
public class ElementTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(ElementTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- test case -- */

  public void createRootElement()
  {
    MSG("ʏ̏ꍇ");

    Element e = Element.createRootElement();
    EQUAL(e.getName(), "");
    NULL(e.getValue());
    NULL(e.getParent());

    try {
      e.setValue("");
      NG();
    } catch (AssertionError ex) {
      OK(ex);
    } catch (Exception ex) {
      NG(ex);
    }

    try {
      e.putAttribute("aa", "bb");
      NG();
    } catch (AssertionError ex) {
      OK(ex);
    } catch (Exception ex) {
      NG(ex);
    }
  }

  public void constructor_name()
  {
    MSG("ʏ̏ꍇ");
    Element e = new Element("");
    EQUAL(e.getName(), "");
    NULL(e.getValue());
    NULL(e.getParent());
  }

  public void constructor_name_1()
  {
    MSG("k̏ꍇ");

    try {
      Element e = new Element(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void constructor_name_2()
  {
    MSG("󕶎̏ꍇ");
    try {
      Element e = new Element("");
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void setValue()
  {
    MSG("ʏ̏ꍇ");

    Element elem = new Element("");
    NULL(elem.getValue());

    EQUAL(elem.setValue("aaa"), null);
    EQUAL(elem.getValue(), "aaa");

    EQUAL(elem.setValue(""), "aaa");
    EQUAL(elem.getValue(), "");

    EQUAL(elem.setValue(null), "");
    EQUAL(elem.getValue(), null);
  }

  public void putAttribute()
  {
    MSG("ʏ̏ꍇ");

    Element e = new Element("sample");
    AttributeMap attrs = e.getAttributes();

    EQUAL(attrs.size(), 0);
    EQUAL(attrs.get("aaa"), null);
    EQUAL(attrs.get("bbb"), null);
    EQUAL(attrs.get("ccc"), null);

    e.putAttribute("aaa", "");
    EQUAL(attrs.size(), 1);
    EQUAL(attrs.get("aaa"), "");
    EQUAL(attrs.get("bbb"), null);
    EQUAL(attrs.get("ccc"), null);

    e.putAttribute("ccc", "");
    EQUAL(attrs.size(), 2);
    EQUAL(attrs.get("aaa"), "");
    EQUAL(attrs.get("bbb"), null);
    EQUAL(attrs.get("ccc"), "");

    e.putAttribute("aaa", "");
    EQUAL(attrs.size(), 2);
    EQUAL(attrs.get("aaa"), "");
    EQUAL(attrs.get("bbb"), null);
    EQUAL(attrs.get("ccc"), "");
  }

  public void putAttribute_1()
  {
    MSG("k̏ꍇ");

    Element elem = new Element("");
    try {
      elem.putAttribute(null, "");
      OK();
    } catch (AssertionError e) {
      OK(e);
    }
    try {
      elem.putAttribute("aaa", null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void putAttribute_2()
  {
    MSG("󕶎̏ꍇ");

    Element elem = new Element("");
    try {
      elem.putAttribute("", "");
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void addChild()
  {
    MSG("ʏ̏ꍇ");

    List<Element> cL;

    Element elem = new Element("");
    NULL(elem.getParent());

    NULL(elem.getFirstChild(""));
    NULL(elem.getFirstChild(""));
    cL = elem.getChildren("");
    EQUAL(cL.size(), 0);
    cL = elem.getChildren("");
    EQUAL(cL.size(), 0);
    cL = elem.getAllChildren();
    EQUAL(cL.size(), 0);

    Element c1 = new Element("");
    NULL(c1.getParent());
    elem.addChild(c1);
    EQUAL(c1.getParent(), elem);

    EQUAL(elem.getFirstChild(""), c1);
    NULL(elem.getFirstChild(""));
    cL = elem.getChildren("");
    EQUAL(cL.size(), 1);
    EQUAL(cL.get(0), c1);
    cL = elem.getChildren("");
    EQUAL(cL.size(), 0);
    cL = elem.getAllChildren();
    EQUAL(cL.size(), 1);
    EQUAL(cL.get(0), c1);

    Element c2 = new Element("");
    NULL(c2.getParent());
    elem.addChild(c2);
    EQUAL(c2.getParent(), elem);

    EQUAL(elem.getFirstChild(""), c1);
    EQUAL(elem.getFirstChild(""), c2);
    cL = elem.getChildren("");
    EQUAL(cL.size(), 1);
    EQUAL(cL.get(0), c1);
    cL = elem.getChildren("");
    EQUAL(cL.size(), 1);
    EQUAL(cL.get(0), c2);
    cL = elem.getAllChildren();
    EQUAL(cL.size(), 2);
    EQUAL(cL.get(0), c1);
    EQUAL(cL.get(1), c2);

    Element c3 = new Element("");
    Element c4 = new Element("");
    NULL(c3.getParent());
    NULL(c4.getParent());
    elem.addChild(c3);
    elem.addChild(c4);
    EQUAL(c3.getParent(), elem);
    EQUAL(c4.getParent(), elem);

    EQUAL(elem.getFirstChild(""), c1);
    EQUAL(elem.getFirstChild(""), c2);
    cL = elem.getChildren("");
    EQUAL(cL.size(), 2);
    EQUAL(cL.get(0), c1);
    EQUAL(cL.get(1), c4);
    cL = elem.getChildren("");
    EQUAL(cL.size(), 2);
    EQUAL(cL.get(0), c2);
    EQUAL(cL.get(1), c3);
    cL = elem.getAllChildren();
    EQUAL(cL.size(), 4);
    EQUAL(cL.get(0), c1);
    EQUAL(cL.get(1), c4);
    EQUAL(cL.get(2), c2);
    EQUAL(cL.get(3), c3);
  }

  public void addChild_1()
  {
    MSG("k̏ꍇ");

    Element elem = new Element("aaa");
    try {
      elem.addChild(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void removeChildren()
  {
    MSG("ʏ̏ꍇ");

    Element e0 = new Element("aaa");
    Element e1 = new Element("bbb");
    Element e2 = new Element("ccc");
    Element e3 = new Element("ddd");
    Element e4 = new Element("ccc");
    e0.addChild(e1);
    e0.addChild(e2);
    e0.addChild(e3);
    e0.addChild(e4);

    List<Element> eL = e0.getAllChildren();
    EQUAL(eL.size(), 4);
    EQUAL(eL.get(0), e1);
    EQUAL(eL.get(1), e2);
    EQUAL(eL.get(2), e4);
    EQUAL(eL.get(3), e3);

    e0.removeChildren("ddd");
    eL = e0.getAllChildren();
    EQUAL(eL.size(), 3);
    EQUAL(eL.get(0), e1);
    EQUAL(eL.get(1), e2);
    EQUAL(eL.get(2), e4);

    e0.removeChildren("ccc");
    eL = e0.getAllChildren();
    EQUAL(eL.size(), 1);
    EQUAL(eL.get(0), e1);

    e0.removeChildren("fff");
    eL = e0.getAllChildren();
    EQUAL(eL.size(), 1);
    EQUAL(eL.get(0), e1);

    e0.removeChildren("bbb");
    eL = e0.getAllChildren();
    EQUAL(eL.size(), 0);
  }

  public void removeChildren_1()
  {
    MSG("k̏ꍇ");

    Element elem = new Element("aaa");
    try {
      elem.removeChildren(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void removeAllChildren()
  {
    MSG("ʏ̏ꍇ");

    Element e0 = new Element("aaa");
    e0.removeAllChildren();

    List<Element> eL = e0.getAllChildren();
    EQUAL(eL.size(), 0);

    Element e1 = new Element("bbb");
    Element e2 = new Element("ccc");
    Element e3 = new Element("ddd");
    Element e4 = new Element("ccc");
    e0.addChild(e1);
    e0.addChild(e2);
    e0.addChild(e3);
    e0.addChild(e4);

    eL = e0.getAllChildren();
    EQUAL(eL.size(), 4);
    EQUAL(eL.get(0), e1);
    EQUAL(eL.get(1), e2);
    EQUAL(eL.get(2), e4);
    EQUAL(eL.get(3), e3);

    e0.removeAllChildren();
    eL = e0.getAllChildren();
    EQUAL(eL.size(), 0);
  }
}
