/*
 * MethodInvokerTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.ObjectInspector;
import ts.tester.function.print.*;
import java.lang.reflect.*;

/**
 * <code>MethodInvoker</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:48 $
 */
public class MethodInvokerTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(MethodInvokerTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- inner cases -- */

  class TesterEx extends Tester
  {
    StringBuffer log_ =new StringBuffer();
    boolean throwException_ = false;

    @Override protected void initTesting() {
      log_.append("[INIT:(test)]");
    }
    @Override protected void preTesting() {
      log_.append("[PRE:(test)]");
    }
    @Override protected void initInvocation(String method) {
      log_.append("[INIT:" + method + "]");
    }
    @Override protected void preInvocation(String method) {
      log_.append("[PRE:" + method + "]");
    }
    @Override protected void postInvocation(String method) {
      log_.append("[POST:" + method + "]");
    }
    @Override protected void endInvocation(String method) {
      log_.append("[END:" + method + "]");
    }
    @Override protected void postTesting() {
      log_.append("[POST:(test)]");
    }
    @Override protected void endTesting() {
      log_.append("[END:(test)]");
    }
    public void test_case_01() {
      log_.append("[EXEC:test_case_01]");
    }
    public void test_case_02() {
      log_.append("[EXEC:test_case_02]");
    }
    public void not_test_case_01(int v) {
      log_.append("[EXEC:not_test_case_01]");
    }
    public int not_test_case_02() {
      log_.append("[EXEC:not_test_case_02]");
      return 0;
    }
    public String not_test_case_03(String s) {
      log_.append("[EXEC:not_test_case_03]");
      return "";
    }
    protected void not_test_case_04() {
      log_.append("[EXEC:not_test_case_04]");
    }
    void not_test_case_05() {
      log_.append("[EXEC:not_test_case_05]");
    }
    private void not_test_case_06() {
      log_.append("[EXEC:not_test_case_06]");
    }
    public void throw_exception() {
      log_.append("[EXEC:throw_exception]");
      if (throwException_)
        throw new ArrayIndexOutOfBoundsException(1);
    }
  }

  /* -- test case -- */

  public void constructor()
  {
    MSG("ftHgRXgN^̊mF");
    MethodInvoker mi = new MethodInvoker();
    NOTNULL(mi);
  }

  public void invokeMethod_tester_method_args()
  {
    MSG("ʏ̑");
    TesterEx tester = new TesterEx();
    MethodInvoker mi = new MethodInvoker();

    Class[] types = new Class[3];
    types[0] = Tester.class;
    types[1] = Method.class;
    types[2] = Object[].class;

    Object[] values = new Object[3];
    values[0] = tester;
    try {
      values[1] = TesterEx.class.getDeclaredMethod("test_case_01",new Class[0]);
    } catch (NoSuchMethodException e) {
      NG(e);
      return;
    }
    values[2] = new Object[0];

    try {
      ObjectInspector oi = new ObjectInspector(this);
      oi.invokeMethod(mi, "invokeMethod", types, values);
    } catch (Exception e) {
      NG(e);
    }

    EQUAL(tester.log_.toString(),
      "[INIT:test_case_01]" +
      "[PRE:test_case_01]" +
      "[EXEC:test_case_01]" +
      "[POST:test_case_01]" +
      "[END:test_case_01]" +
    "");
  }

  public void invokeMethod_tester_method_args_1()
  {
    MSG("\bh̎sɗOX[ꍇ");

    TesterEx tester = new TesterEx();
    MethodInvoker mi = new MethodInvoker();

    Class[] types = new Class[3];
    types[0] = Tester.class;
    types[1] = Method.class;
    types[2] = Object[].class;

    Object[] values = new Object[3];
    values[0] = tester;
    try {
      values[1] = TesterEx.class.getDeclaredMethod("test_case_01",new Class[0]);
    } catch (NoSuchMethodException e) {
      NG(e);
      return;
    }
    values[2] = new Object[0];

    try {
      ObjectInspector oi = new ObjectInspector(this);
      oi.invokeMethod(mi, "invokeMethod", types, values);
    } catch (Exception e) {
      NG(e);
    }

    EQUAL(tester.log_.toString(),
      "[INIT:test_case_01]" +
      "[PRE:test_case_01]" +
      "[EXEC:test_case_01]" +
      "[POST:test_case_01]" +
      "[END:test_case_01]" +
    "");
  }

  public void invokeMethod_tester_methodName()
  {
    MSG("ʏ̑");
    TesterEx tester = new TesterEx();

    try {
      MethodInvoker.invokeMethod(tester, "test_case_01");
    } catch (Exception e) {
      NG(e);
    }

    EQUAL(tester.log_.toString(),
      "[INIT:test_case_01]" +
      "[PRE:test_case_01]" +
      "[EXEC:test_case_01]" +
      "[POST:test_case_01]" +
      "[END:test_case_01]" +
    "");
  }

  public void invokeMethod_tester_methodName_01()
  {
    MSG("k̏ꍇ");
    try {
      MethodInvoker.invokeMethod(null, null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }

    try {
      MethodInvoker.invokeMethod(null, "test_case_01");
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }

    try {
      TesterEx tester = new TesterEx();
      MethodInvoker.invokeMethod(tester, null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void invokeMethod_tester_methodName_02()
  {
    MSG("w肳ꂽÓAE߂lȂ̃\bh݂Ȃꍇ");

    TesterEx tester = new TesterEx();

    try {
      MethodInvoker.invokeMethod(tester, "test_case_X");
      NG();
    } catch (NoSuchMethodException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      MethodInvoker.invokeMethod(tester, "");
      NG();
    } catch (NoSuchMethodException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      MethodInvoker.invokeMethod(tester, "not_test_case_01");
      NG();
    } catch (NoSuchMethodException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      MethodInvoker.invokeMethod(tester, "not_test_case_02");
      NG();
    } catch (NoSuchMethodException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      MethodInvoker.invokeMethod(tester, "not_test_case_03");
      NG();
    } catch (NoSuchMethodException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void invokeMethod_tester_methodName_03()
  {
    MSG("w肳ꂽÕ\bh̃ANZXwqpubNłȂꍇ");

    TesterEx tester = new TesterEx();

    try {
      MethodInvoker.invokeMethod(tester, "not_test_case_04");
      NG();
    } catch (IllegalAccessException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      MethodInvoker.invokeMethod(tester, "not_test_case_05");
      NG();
    } catch (IllegalAccessException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      MethodInvoker.invokeMethod(tester, "not_test_case_06");
      NG();
    } catch (IllegalAccessException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void invokeMethod_tester_methodName_04()
  {
    MSG("\bh̎sɗOX[ꍇ");

    TesterEx tester = new TesterEx();
    tester.throwException_ = true;

    try {
      MethodInvoker.invokeMethod(tester, "throw_exception");
      NG();
    } catch (ArrayIndexOutOfBoundsException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void invokeAllMethods_tester()
  {
    MSG("ʏ̑̏ꍇ");

    TesterEx tester = new TesterEx();

    try {
      MethodInvoker.invokeAllMethods(tester);
      MATCH(tester.log_.toString(), 
        "[INIT:test_case_01]" +
        "[PRE:test_case_01]" +
        "[EXEC:test_case_01]" +
        "[POST:test_case_01]" +
        "[END:test_case_01]" +
        "[INIT:test_case_02]" +
        "[PRE:test_case_02]" +
        "[EXEC:test_case_02]" +
        "[POST:test_case_02]" +
        "[END:test_case_02]" +
        "[INIT:throw_exception]" +
        "[PRE:throw_exception]" +
        "[EXEC:throw_exception]" +
        "[POST:throw_exception]" +
        "[END:throw_exception]" +
      "");
    } catch (Exception e) {
      NG(e);
    }
  }

  public void invokeAllMethods_tester_01()
  {
    MSG("k̏ꍇ");

    TesterEx tester = new TesterEx();

    try {
      MethodInvoker.invokeAllMethods(null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void invokeAllMethods_tester_02()
  {
    MSG("eXgP[XE\bhŗOX[ꍇ");

    TesterEx tester = new TesterEx();
    tester.throwException_ = true;

    try {
      MethodInvoker.invokeAllMethods(tester);
      NG();
    } catch (ArrayIndexOutOfBoundsException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }
}
