/*
 * RangeTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.ObjectInspector;
import ts.tester.function.print.*;

/**
 * <code>Range</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.3 $, $Date: 2007/05/27 16:13:06 $
 */
public class RangeTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(RangeTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  @Override
  protected void preTesting()
  {
    MSG("RangeNX̋@\sB");
  }

  /* -- test case -- */

  public void constructor_start_end()
  {
    MSG("JnlƏIlɂƂRXgN^̊mFB");

    Range<Integer> range = new Range<Integer>(100, 200);
    EQUAL(range.getStart().intValue(), 100);
    EQUAL(range.getEnd().intValue(), 200);
  }

  public void constructor_start_end_1()
  {
    MSG("JnlƏIl̑召֌Wt̏ꍇB");

    Range<Integer> range = new Range<Integer>(500, -200);
    EQUAL(range.getStart().intValue(), -200);
    EQUAL(range.getEnd().intValue(), 500);
  }

  public void constructor_start_end_2()
  {
    MSG("k̏ꍇB");

    try {
      Range<Integer> range = new Range<Integer>(null, 200);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG();
    }

    try {
      Range<Integer> range = new Range<Integer>(100, null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setRange_start_end()
  {
    MSG("JnlƏIlݒ肷郁\bh̊mFB");

    Range<Long> range = new Range<Long>(0L, 0L);
    EQUAL(range.getStart().longValue(), 0L);
    EQUAL(range.getEnd().longValue(), 0L);

    range.setRange(30L, 40L);
    EQUAL(range.getStart().longValue(), 30L);
    EQUAL(range.getEnd().longValue(), 40L);
  }

  public void setRange_start_end_1()
  {
    MSG("JnlƏIl̑召֌Wt̏ꍇB");

    Range<Long> range = new Range<Long>(0L, 0L);
    EQUAL(range.getStart().longValue(), 0L);
    EQUAL(range.getEnd().longValue(), 0L);

    range.setRange(30L, -40L);
    EQUAL(range.getStart().longValue(), -40L);
    EQUAL(range.getEnd().longValue(), 30L);
  }

  public void setRange_start_end_2()
  {
    MSG("k̏ꍇB");

    Range<Long> range = new Range<Long>(0L, 0L);
    try {
      range.setRange(null, 1L);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
    try {
      range.setRange(1L, null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void equals_obj()
  {
    MSG("IuWFNg̓eǂ𔻒肷郁\bh̊mFB");

    Range<Integer> r1 = new Range<Integer>(1,3);
    Range<Integer> r2 = new Range<Integer>(1,3);
    Range<Integer> r3 = new Range<Integer>(3,1);
    Range<Integer> r4 = new Range<Integer>(2,2);
    Range<Integer> r5 = new Range<Integer>(2,3);
    Range<Integer> r6 = new Range<Integer>(1,2);

    TRUE(r1.equals(r1));
    TRUE(r1.equals(r2));
    TRUE(r1.equals(r3));
    FALSE(r1.equals(r4));
    FALSE(r1.equals(r5));
    FALSE(r1.equals(r6));
  }

  public void equals_obj_1()
  {
    MSG("k̏ꍇB");

    Range<Integer> r1 = new Range<Integer>(1, 10);
    FALSE(r1.equals(null));
  }

  public void equals_obj_2()
  {
    MSG("RangeIuWFNgłȂꍇB");

    Range<Integer> r1 = new Range<Integer>(1, 10);
    FALSE(r1.equals(new Integer(1)));
  }

  public void encompass_value()
  {
    MSG("w肳ꂽl͈͓ɂ邩ǂ𔻒肷郁\bh̊mFB");

    Range<String> range = new Range<String>("b", "d");
    TRUE(range.encompass("b"));
    TRUE(range.encompass("c"));
    TRUE(range.encompass("d"));
    FALSE(range.encompass("a"));
    FALSE(range.encompass("e"));
    FALSE(range.encompass("f"));
  }

  public void encompass_value_1()
  {
    MSG("k̏ꍇB");

    Range<String> range = new Range<String>("a", "d");
    try {
      range.encompass((String) null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void encompass_range()
  {
    MSG("w肳ꂽ͈͈͓͂ǂ𔻒肷郁\bh̊mFB");

    Range<String> range = new Range<String>("C", "K");
    Range<String> r1 = new Range<String>("D", "J");
    TRUE(range.encompass(r1));
    Range<String> r2 = new Range<String>("C", "K");
    TRUE(range.encompass(r2));
    Range<String> r3 = new Range<String>("C", "C");
    TRUE(range.encompass(r3));
    Range<String> r4 = new Range<String>("E", "E");
    TRUE(range.encompass(r4));
    Range<String> r5 = new Range<String>("K", "K");
    TRUE(range.encompass(r5));
    Range<String> r6 = new Range<String>("B", "L");
    FALSE(range.encompass(r6));
    Range<String> r7 = new Range<String>("B", "J");
    FALSE(range.encompass(r7));
    Range<String> r8 = new Range<String>("E", "L");
    FALSE(range.encompass(r8));
  }

  public void encompass_range_1()
  {
    MSG("k̏ꍇB");

    Range<String> range = new Range<String>("a", "d");
    try {
      range.encompass((Range<String>) null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void intersectsWith_range()
  {
    MSG("dȂ͈͂擾郁\bh̊mFB");

    Range<Integer> r1 = new Range<Integer>(4, 8);
    Range<Integer> r2 = new Range<Integer>(4, 8);
    Range<Integer> r3 = new Range<Integer>(6, 7);
    Range<Integer> r4 = new Range<Integer>(2, 9);
    Range<Integer> r5 = new Range<Integer>(2, 6);
    Range<Integer> r6 = new Range<Integer>(5, 9);
    Range<Integer> r7 = new Range<Integer>(1, 2);
    Range<Integer> r8 = new Range<Integer>(9, 9);

    EQUAL(r1.intersectsWith(r1), new Range<Integer>(4, 8));
    EQUAL(r1.intersectsWith(r2), new Range<Integer>(4, 8));
    EQUAL(r1.intersectsWith(r3), new Range<Integer>(6, 7));
    EQUAL(r1.intersectsWith(r4), new Range<Integer>(4, 8));
    EQUAL(r1.intersectsWith(r5), new Range<Integer>(4, 6));
    EQUAL(r1.intersectsWith(r6), new Range<Integer>(5, 8));
    NULL(r1.intersectsWith(r7));
    NULL(r1.intersectsWith(r8));
  }

  public void intersectsWith_range_1()
  {
    MSG("k̏ꍇB");

    Range<Long> range = new Range<Long>(-10L, 10L);
    try {
      range.intersectsWith(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void expandsWith_value()
  {
    MSG("͈͂w肳ꂽlŊg郁\bh̊mFB");

    Range<Integer> r1 = new Range<Integer>(1, 10);
    EQUAL(r1.expandsWith(0), new Range<Integer>(0, 10));
    EQUAL(r1.expandsWith(20), new Range<Integer>(1, 20));
    EQUAL(r1.expandsWith(5), new Range<Integer>(1, 10));
  }

  public void expandsWith_value_1()
  {
    MSG("k̏ꍇB");

    Range<Long> range = new Range<Long>(-10L, 10L);
    try {
      range.expandsWith((Long) null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void expandsWith_range()
  {
    MSG("͈͂w肳ꂽ͈͂Ŋg郁\bh̊mFB");

    Range<Integer> r1 = new Range<Integer>(3, 6);
    EQUAL(r1.expandsWith(new Range<Integer>(3,6)), new Range<Integer>(3,6));
    EQUAL(r1.expandsWith(new Range<Integer>(1,9)), new Range<Integer>(1,9));
    EQUAL(r1.expandsWith(new Range<Integer>(5,5)), new Range<Integer>(3,6));
    EQUAL(r1.expandsWith(new Range<Integer>(1,4)), new Range<Integer>(1,6));
    EQUAL(r1.expandsWith(new Range<Integer>(5,8)), new Range<Integer>(3,8));
  }

  public void expandsWith_range_1()
  {
    MSG("k̏ꍇB");
    
    Range<Long> range = new Range<Long>(-10L, 10L);
    try {
      range.expandsWith((Range<Long>) null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }
}
