/*
 * FileFilterGroupOrTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.ObjectInspector;
import ts.tester.function.print.*;
import java.io.File;
import java.io.FileFilter;
import java.util.*;

/**
 * {@link ts.util.file.FileFilterGroupOr FileFilterGroupOr}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/05/27 16:13:08 $
 */
public class FileFilterGroupOrTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(FileFilterGroupOrTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("FileFilterGroupOr NX̋@\sB");
  }
  

  /* -- test case -- */

  public void constructor()
  {
    MSG("ftHgERXgN^̊mFB");

    ObjectInspector oi = new ObjectInspector(this);
    oi.expect("filterLst_", Collections.EMPTY_LIST);
    try {
      oi.inspect(new FileFilterGroupOr());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void addFilter()
  {
    MSG("qtB^̒ǉ̊mFB");

    List<FileFilter> lst = new LinkedList<FileFilter>();

    ObjectInspector oi = new ObjectInspector(this);
    oi.expect("filterLst_", lst);

    FileFilterGroupOr filterOr = new FileFilterGroupOr();

    FileFilter child = new FileSizeFilter(0, 1024*1024);
    filterOr.addFilter(child);
    lst.add(child);

    try {
      oi.inspect(filterOr);
    } catch (Exception e) {
      NG(e);
    } 

    FileFilter child2 = new FileTypeFilter(FileType.Directory);
    filterOr.addFilter(child2);
    lst.add(child2);

    try {
      oi.inspect(filterOr);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void addFilter_1()
  {
    MSG("k̏ꍇB");

    FileFilterGroupOr filterOr = new FileFilterGroupOr();
    try {
      filterOr.addFilter(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void accept()
  {
    MSG("̊mFB");

    FileFilterGroupOr filterOr = new FileFilterGroupOr();
    FALSE(filterOr.accept(new File("./src")));
    FALSE(filterOr.accept(new File("./src/javadoc.css")));

    filterOr.addFilter(new FileTypeFilter(FileType.File));
    FALSE(filterOr.accept(new File("./src")));
    TRUE(filterOr.accept(new File("./src/javadoc.css")));

    filterOr.addFilter(new FileTypeFilter(FileType.Directory));
    TRUE(filterOr.accept(new File("./src")));
    TRUE(filterOr.accept(new File("./src/javadoc.css")));
  }
}

