/*
 * FileTypeFilterTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.tester.function.ObjectInspector;
import java.io.File;
import java.io.FileFilter;

/**
 * {@link ts.util.file.FileTypeFilter FileTypeFilter}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/05/27 16:13:12 $
 */
public class FileTypeFilterTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(FileTypeFilterTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("FileTypeFilter NX̋@\sB");
  }

  private ObjectInspector oi_ = new ObjectInspector(this);

  /* -- test case -- */

  public void constructor_filetype()
  {
    MSG("t@CE^CvɂƂRXgN^̊mFB");

    FileFilter filter = new FileTypeFilter(FileType.File);
    oi_.expect("type_", FileType.File);
    try {
      oi_.inspect(filter);
    } catch (Exception e) {
      NG(e);
    }

    filter = new FileTypeFilter(FileType.Directory);
    oi_.expect("type_", FileType.Directory);
    try {
      oi_.inspect(filter);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void accept()
  {
    MSG("t@CE^CvY邩ǂ̔̊mFB");

    FileTypeFilter filter = new FileTypeFilter(FileType.File);
    TRUE(filter.accept(new File("./build.xml")));
    FALSE(filter.accept(new File("./src")));

    filter = new FileTypeFilter(FileType.Directory);
    FALSE(filter.accept(new File("./build.xml")));
    TRUE(filter.accept(new File("./src")));
  }

  public void accept_1()
  {
    MSG("k̏ꍇB");

    FileTypeFilter filter = new FileTypeFilter(FileType.File);
    try {
      filter.accept(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }
}

