/*
 * CaseResultTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.coverage;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import java.util.*;

/**
 * <code>CaseResult</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:48 $
 */
public class CaseResultTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(CaseResultTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- test case -- */

  public void constructor()
  {
    PassResult<Integer> top = new PassResult<Integer>();

    CaseResult<Integer> case1 = new CaseResult<Integer>(top);
    NOTNULL(case1);
    EQUAL(case1.countAllResults(), 0);
    EQUAL(case1.countPassedResults(), 0);
    EQUAL(case1.containsKeyOfResult(1), false);
    EQUAL(case1.containsKeyOfResult(2), false);
    EQUAL(case1.containsKeyOfResult(3), false);
    EQUAL(case1.getPassCountOfResult(1), 0);
    EQUAL(case1.getPassCountOfResult(2), 0);
    EQUAL(case1.getPassCountOfResult(3), 0);
    FALSE(case1.enumAllResultKeys().hasMoreElements());
    FALSE(case1.enumPassedResultKeys().hasMoreElements());
    FALSE(case1.enumNotPassedResultKeys().hasMoreElements());

    CaseResult<Integer> case2 = new CaseResult<Integer>(case1);
    NOTNULL(case2);
    EQUAL(case2.countAllResults(), 0);
    EQUAL(case2.countPassedResults(), 0);
    EQUAL(case2.containsKeyOfResult(1), false);
    EQUAL(case2.containsKeyOfResult(2), false);
    EQUAL(case2.containsKeyOfResult(3), false);
    EQUAL(case2.getPassCountOfResult(1), 0);
    EQUAL(case2.getPassCountOfResult(2), 0);
    EQUAL(case2.getPassCountOfResult(3), 0);
    FALSE(case2.enumAllResultKeys().hasMoreElements());
    FALSE(case2.enumPassedResultKeys().hasMoreElements());
    FALSE(case2.enumNotPassedResultKeys().hasMoreElements());
  }

  public void constructor_1()
  {
    try {
      CaseResult<Integer> case1 = new CaseResult<Integer>(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void addResult()
  {
    Enumeration<Integer> e;

    PassResult<Integer> top = new PassResult<Integer>();
    CaseResult<Integer> case11 = new CaseResult<Integer>(top);
    CaseResult<Integer> case12 = new CaseResult<Integer>(top);
    CaseResult<Integer> case21 = new CaseResult<Integer>(case11);
    CaseResult<Integer> case22 = new CaseResult<Integer>(case11);
    CaseResult<Integer> case23 = new CaseResult<Integer>(case12);

    top.addResult(1);
    case11.addResult(2);
    case12.addResult(3);
    case12.addResult(4);
    case21.addResult(5);
    case21.addResult(6);
    case21.addResult(7);
    case22.addResult(8);
    case23.addResult(9);
    case12.addResult(10);
    top.addResult(11);

    EQUAL(top.countAllResults(), 11);
    EQUAL(top.countPassedResults(), 0);
    EQUAL(top.containsKeyOfResult(1), true);
    EQUAL(top.containsKeyOfResult(2), true);
    EQUAL(top.containsKeyOfResult(3), true);
    EQUAL(top.getPassCountOfResult(1), 0);
    EQUAL(top.getPassCountOfResult(2), 0);
    EQUAL(top.getPassCountOfResult(3), 0);
    e = top.enumAllResultKeys();
    for (int i=0; i<11; i++) {
      TRUE(e.hasMoreElements());
      EQUAL(e.nextElement(), new Integer(i+1));
    }
    FALSE(e.hasMoreElements());
    e = top.enumPassedResultKeys();
    for (int i=0; i<0; i++) {
      TRUE(e.hasMoreElements());
      EQUAL(e.nextElement(), new Integer(i+1));
    }
    FALSE(e.hasMoreElements());
    e = top.enumNotPassedResultKeys();
    for (int i=0; i<11; i++) {
      TRUE(e.hasMoreElements());
      EQUAL(e.nextElement(), new Integer(i+1));
    }
    FALSE(e.hasMoreElements());

    EQUAL(case11.countAllResults(), 5);
    EQUAL(case11.countPassedResults(), 0);
    e = case11.enumAllResultKeys();
    TRUE(e.hasMoreElements());
    EQUAL(e.nextElement(), new Integer(2));
    TRUE(e.hasMoreElements());
    EQUAL(e.nextElement(), new Integer(5));
    TRUE(e.hasMoreElements());
    EQUAL(e.nextElement(), new Integer(6));
    TRUE(e.hasMoreElements());
    EQUAL(e.nextElement(), new Integer(7));
    TRUE(e.hasMoreElements());
    EQUAL(e.nextElement(), new Integer(8));
    FALSE(e.hasMoreElements());
    e = case11.enumPassedResultKeys();
    FALSE(e.hasMoreElements());

    EQUAL(case12.countAllResults(), 4);
    EQUAL(case12.countPassedResults(), 0);
    e = case12.enumAllResultKeys();
    TRUE(e.hasMoreElements());
    EQUAL(e.nextElement(), new Integer(3));
    TRUE(e.hasMoreElements());
    EQUAL(e.nextElement(), new Integer(4));
    TRUE(e.hasMoreElements());
    EQUAL(e.nextElement(), new Integer(9));
    TRUE(e.hasMoreElements());
    EQUAL(e.nextElement(), new Integer(10));
    FALSE(e.hasMoreElements());
    e = case12.enumPassedResultKeys();
    FALSE(e.hasMoreElements());

    EQUAL(case21.countAllResults(), 3);
    EQUAL(case21.countPassedResults(), 0);
    e = case21.enumAllResultKeys();
    TRUE(e.hasMoreElements());
    EQUAL(e.nextElement(), new Integer(5));
    TRUE(e.hasMoreElements());
    EQUAL(e.nextElement(), new Integer(6));
    TRUE(e.hasMoreElements());
    EQUAL(e.nextElement(), new Integer(7));
    FALSE(e.hasMoreElements());
    e = case21.enumPassedResultKeys();
    FALSE(e.hasMoreElements());

    EQUAL(case22.countAllResults(), 1);
    EQUAL(case22.countPassedResults(), 0);
    e = case22.enumAllResultKeys();
    TRUE(e.hasMoreElements());
    EQUAL(e.nextElement(), new Integer(8));
    FALSE(e.hasMoreElements());
    e = case22.enumPassedResultKeys();
    FALSE(e.hasMoreElements());

    EQUAL(case23.countAllResults(), 1);
    EQUAL(case23.countPassedResults(), 0);
    e = case23.enumAllResultKeys();
    TRUE(e.hasMoreElements());
    EQUAL(e.nextElement(), new Integer(9));
    FALSE(e.hasMoreElements());
    e = case23.enumPassedResultKeys();
    FALSE(e.hasMoreElements());
  }

  public void addResult_1()
  {
    PassResult<Integer> top = new PassResult<Integer>();
    CaseResult<Integer> case1 = new CaseResult<Integer>(top);

    try {
      case1.addResult(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void incrementPassCountOfResult()
  {
    PassResult<Integer> top = new PassResult<Integer>();
    CaseResult<Integer> case1 = new CaseResult<Integer>(top);
    CaseResult<Integer> case2 = new CaseResult<Integer>(top);

    top.addResult(1);
    case1.addResult(2);
    case1.addResult(3);
    case1.addResult(4);
    case2.addResult(5);
    case2.addResult(6);
    case2.addResult(7);
    case2.addResult(8);
    case2.addResult(9);
    case1.addResult(10);
    top.addResult(11);

    case1.incrementPassCountOfResult(4); 
    EQUAL(top.countAllResults(), 11);
    EQUAL(top.countPassedResults(), 1);
    EQUAL(top.passedRatio(), 1.0f/11.0f);
    EQUAL(top.getPassCountOfResult(1), 0);
    EQUAL(top.getPassCountOfResult(2), 0);
    EQUAL(top.getPassCountOfResult(3), 0);
    EQUAL(top.getPassCountOfResult(4), 1);
    EQUAL(case1.countAllResults(), 4);
    EQUAL(case1.countPassedResults(), 1);
    EQUAL(case1.passedRatio(), 1.0f/4.0f);
    EQUAL(case1.getPassCountOfResult(1), 0);
    EQUAL(case1.getPassCountOfResult(2), 0);
    EQUAL(case1.getPassCountOfResult(3), 0);
    EQUAL(case1.getPassCountOfResult(4), 1);
    EQUAL(case2.countAllResults(), 5);
    EQUAL(case2.countPassedResults(), 0);
    EQUAL(case2.passedRatio(), 0.0f/5.0f);
    EQUAL(case2.getPassCountOfResult(1), 0);
    EQUAL(case2.getPassCountOfResult(2), 0);
    EQUAL(case2.getPassCountOfResult(3), 0);
    EQUAL(case2.getPassCountOfResult(4), 1);
  }

  public void incrementPassCount_of_parent()
  {
    Enumeration<Integer> e;

    PassResult<Integer> top = new PassResult<Integer>();
    CaseResult<Integer> case11 = new CaseResult<Integer>(top);
    CaseResult<Integer> case12 = new CaseResult<Integer>(top);
    CaseResult<Integer> case21 = new CaseResult<Integer>(case11);
    CaseResult<Integer> case22 = new CaseResult<Integer>(case11);
    CaseResult<Integer> case23 = new CaseResult<Integer>(case12);

    top.addResult(1);
    case11.addResult(2);
    case12.addResult(3);
    case12.addResult(4);
    case21.addResult(5);
    case21.addResult(6);
    case21.addResult(7);
    case22.addResult(8);
    case23.addResult(9);
    case12.addResult(10);
    top.addResult(11);

    top.incrementPassCountOfResult(1); 
    top.incrementPassCountOfResult(3);
    top.incrementPassCountOfResult(4);
    top.incrementPassCountOfResult(5);
    top.incrementPassCountOfResult(8);
    top.incrementPassCountOfResult(9);
    top.incrementPassCountOfResult(11); 

    top.incrementPassCountOfResult(1); 
    top.incrementPassCountOfResult(4);
    top.incrementPassCountOfResult(5);
    top.incrementPassCountOfResult(5);
    top.incrementPassCountOfResult(5);
    top.incrementPassCountOfResult(6);
    top.incrementPassCountOfResult(11); 

    EQUAL(top.countAllResults(), 11);
    EQUAL(top.countPassedResults(), 8);
    EQUAL(top.passedRatio(), 8.0f/11.0f);
    EQUAL(top.getPassCountOfResult(1), 2);
    EQUAL(top.getPassCountOfResult(2), 0);
    EQUAL(top.getPassCountOfResult(3), 1);
    EQUAL(top.getPassCountOfResult(4), 2);
    EQUAL(top.getPassCountOfResult(5), 4);
    EQUAL(top.getPassCountOfResult(6), 1);
    EQUAL(top.getPassCountOfResult(7), 0);
    EQUAL(top.getPassCountOfResult(8), 1);
    EQUAL(top.getPassCountOfResult(9), 1);
    EQUAL(top.getPassCountOfResult(10), 0);
    EQUAL(top.getPassCountOfResult(11), 2);

    EQUAL(case11.countAllResults(), 5);     // 2,5,6,7,8
    EQUAL(case11.countPassedResults(), 3);
    EQUAL(case11.passedRatio(), 3.0f/5.0f);
    EQUAL(case11.getPassCountOfResult(2), 0);
    EQUAL(case11.getPassCountOfResult(5), 4);
    EQUAL(case11.getPassCountOfResult(6), 1);
    EQUAL(case11.getPassCountOfResult(7), 0);
    EQUAL(case11.getPassCountOfResult(8), 1);

    EQUAL(case12.countAllResults(), 4); // 3,4,9,10
    EQUAL(case12.countPassedResults(), 3);
    EQUAL(case12.passedRatio(), 3.0f/4.0f);
    EQUAL(case12.getPassCountOfResult(3), 1);
    EQUAL(case12.getPassCountOfResult(4), 2);
    EQUAL(case12.getPassCountOfResult(9), 1);
    EQUAL(case12.getPassCountOfResult(10), 0);

    EQUAL(case21.countAllResults(), 3); // 5,6,7
    EQUAL(case21.countPassedResults(), 2);
    EQUAL(case21.passedRatio(), 2.0f/3.0f);
    EQUAL(case21.getPassCountOfResult(5), 4);
    EQUAL(case21.getPassCountOfResult(6), 1);
    EQUAL(case21.getPassCountOfResult(7), 0);

    EQUAL(case22.countAllResults(), 1); // 8
    EQUAL(case22.countPassedResults(), 1);
    EQUAL(case22.passedRatio(), 1.0f);
    EQUAL(case22.getPassCountOfResult(8), 1);

    EQUAL(case23.countAllResults(), 1); // 9
    EQUAL(case23.countPassedResults(), 1);
    EQUAL(case23.passedRatio(), 1.0f);
    EQUAL(case23.getPassCountOfResult(9), 1);
  }

  public void enumPassedResultKeys()
  {
    MSG("ʏ̑");
    PassResult<Integer> top = new PassResult<Integer>();
    CaseResult<Integer> case1 = new CaseResult<Integer>(top);

    case1.addResult(2);
    case1.addResult(3);
    case1.incrementPassCountOfResult(2); 
    Enumeration<Integer> e = case1.enumPassedResultKeys();
    TRUE(e.hasMoreElements());
    EQUAL(e.nextElement(), new Integer(2));
    FALSE(e.hasMoreElements());
  }

  public void enumNotPassedResultKeys()
  {
    MSG("ʏ̑");
    PassResult<Integer> top = new PassResult<Integer>();
    CaseResult<Integer> case1 = new CaseResult<Integer>(top);

    case1.addResult(2);
    case1.addResult(3);
    case1.incrementPassCountOfResult(2); 
    Enumeration<Integer> e = case1.enumNotPassedResultKeys();
    TRUE(e.hasMoreElements());
    EQUAL(e.nextElement(), new Integer(3));
    FALSE(e.hasMoreElements());
  }
}
