/*
 * ResultTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.coverage;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import java.util.*;

/**
 * <code>Result</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:49 $
 */
public class ResultTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(ResultTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- inner class -- */

  private class ResultEx<K> extends Result<K>
  {
    int countAllResults_ = 0;
    int countPassedResults_ = 0;
    @Override public void addResult(K resultKey)
    {}
    @Override public int countAllResults()
    { return countAllResults_; }
    @Override public int countPassedResults()
    { return countPassedResults_; }
    @Override public void incrementPassCountOfResult(K resultKey)
    {}
    @Override public boolean containsKeyOfResult(K resultKey)
    { return true; }
    @Override public int getPassCountOfResult(K resultKey)
    { return 0; }
    @Override public Enumeration<K> enumAllResultKeys()
    { return null; }
    @Override public Enumeration<K> enumPassedResultKeys()
    { return null; }
    @Override public Enumeration<K> enumNotPassedResultKeys()
    { return null; }
  }

  /* -- test case -- */

  public void constructor()
  {
    MSG("ʏ̑");

    ResultEx<String> r = new ResultEx<String>();
    NOTNULL(r);
  }

  public void passedRatio()
  {
    MSG("ʏ̑");

    ResultEx<String> r = new ResultEx<String>();
    r.countAllResults_ = 100;
    r.countPassedResults_ = 30;
    EQUAL(r.passedRatio(), 0.3f);
  }

  public void passedRatio_1()
  {
    MSG("S[̏ꍇ");

    ResultEx<String> r = new ResultEx<String>();
    r.countAllResults_ = 0;
    r.countPassedResults_ = 0;
    EQUAL(r.passedRatio(), 0.0f);

    r.countAllResults_ = 0;
    r.countPassedResults_ = 1;
    EQUAL(r.passedRatio(), 0.0f);
  }
}
