/*
 * FunctionTesterTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.coverage;

import ts.tester.function.print.*;

/**
 * <code>FunctionTester</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.3 $, $Date: 2007/05/07 15:20:00 $
 */
public class FunctionTesterTest extends FunctionTester
{
  public static void main(String[] args)
  {
    setTargetClass(AClass.class);
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("V"));
      setPrinter(group);
      run(FunctionTesterTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- inner class -- */

  static class AClass 
  {
    private String text_ = "";

    AClass() {}

    void setText(String s) {
      assert (s != null) : "@param:s is null.";
      text_ = s;
    }

    String getText() {
      return text_ ;
    }

    void appendTest(String s) {
      assert (s != null) : "@param:s is null.";
      text_ += s;
    }
  }

  /* -- test case -- */

  public void constructor()
  {
    AClass c = new AClass();
    NOTNULL(c);
  }

  public void setText()
  {
    AClass c = new AClass();
    c.setText("");
    EQUAL(c.getText(), "");
  }

  public void setText_1()
  {
    AClass c = new AClass();
    try {
      c.setText(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void appendTest()
  {
    AClass c = new AClass();
    c.appendTest("AA");
    EQUAL(c.getText(), "AA");
    c.appendTest("BB");
    EQUAL(c.getText(), "AABB");
    c.appendTest("CC");
    EQUAL(c.getText(), "AABBCC");
  }

  public void coverage_stxetx()
  {
    System.err.println("xxx\u0002yyy\u0003zzz\u001buuu");
    System.out.println("xxx\u0002yyy\u0003zzz\u001buuu");
    OK();
  }
}
