/*
 * _CaseIdentifierTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.coverage;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.tester.function.*;
import ts.tester.util.ObjectSerializer;

/**
 * <code>_CaseIdentifier</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:50 $
 */
public class _CaseIdentifierTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(_CaseIdentifierTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("_CaseIdentifierNX̋@\sB");
  }

  /* -- test case -- */

  public void default_constructor()
  {
    MSG("ʏ̑̏ꍇ");

    _CaseIdentifier id = new _CaseIdentifier();
    EQUAL(id.getCaseName(), "");
    OK("" + id.idNo_);
  }

  public void constructor_caseName()
  {
    MSG("ʏ̑̏ꍇ");

    _CaseIdentifier id = new _CaseIdentifier("");
    EQUAL(id.getCaseName(), "");
    OK("" + id.idNo_);

    id = new _CaseIdentifier("");
    EQUAL(id.getCaseName(), "");
    OK("" + id.idNo_);
  }

  public void constructor_caseName_1()
  {
    MSG("k̏ꍇ");

    try {
      _CaseIdentifier id = new _CaseIdentifier(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void _equals()
  {
    MSG("ʏ̏ꍇ");

    _CaseIdentifier id0 = new _CaseIdentifier("a");
    _CaseIdentifier id1 = new _CaseIdentifier("a");
    _CaseIdentifier id2 = new _CaseIdentifier("b");

    id2.idNo_ = id0.idNo_;

    TRUE (id0.equals(id0));
    FALSE(id0.equals(id1));
    FALSE(id1.equals(id0));
    TRUE (id0.equals(id2));
    TRUE (id2.equals(id0));
  }

  public void _equals_1()
  {
    MSG("k̏ꍇ");

    _CaseIdentifier id0 = new _CaseIdentifier();

    FALSE(id0.equals(null));
  }

  public void _equals_2()
  {
    MSG("_CaseIdentifierIuWFNgłȂꍇB");

    _CaseIdentifier id0 = new _CaseIdentifier();

    FALSE(id0.equals(""));
  }

  public void serialize()
  {
    MSG("ʏ̑");

    _CaseIdentifier id0 = new _CaseIdentifier("");
    _CaseIdentifier id1 = null;

    try {
      byte[] bs = ObjectSerializer.serializeToByteArray(id0);
      id1 = (_CaseIdentifier) ObjectSerializer.deserialize(bs);
    } catch (Exception e) {
      NG(e);
    }

    EQUAL(id0.getCaseName(), id1.getCaseName());
    EQUAL(id0.hashCode(), id1.hashCode());
    EQUAL(id0, id1);
  }
}
