/*
 * _CaseResult class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.coverage;

import ts.tester.function.ResultType;
import ts.tester.function.Result;
import ts.tester.function.CaseResult;
import java.io.Serializable;

/**
 * JobWvZXŐ鎎P[X茋ʃNXB 
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:50 $
 */
class _CaseResult extends CaseResult
{
  /** P[XʃIuWFNgB */
  private _CaseIdentifier id_ ;

  /** e茋ʃ^Cv̏Wvli[zB */
  private int[] countByResultType_ = new int[ ResultType.values().length ];

  /**
   * P[XƐe̎P[XʃIuWFNgɂƂRXgN^B
   *
   * @param  name P[XB
   * @param  parent e̎P[X茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public _CaseResult(String name, CaseResult parent)
  {
    super(name, parent);
    id_ = new _CaseIdentifier(name);
  }

  /**
   * P[XʃIuWFNg擾B
   *
   * @return P[XʃIuWFNgB
   */
  public _CaseIdentifier getId()
  {
    return id_ ;
  }

  /**
   * w肳ꂽʃ^Cv̌ʐ擾B
   *
   * @param  type ʃ^CvB
   * @return ʐB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public int count(ResultType type)
  {
    assert (type != null) : "@param:type is null.";

    return countByResultType_[type.ordinal()];
  }

  /**
   * q̔茋ʃIuWFNgǉB
   *
   * @param  result 茋ʃIuWFNgB
   */
  public void addChildResult(Result result)
  {
    Object added = null;
    if (result instanceof _CaseResult) {
      added = ((_CaseResult) result).getId();
    }
    else if (result instanceof Serializable) {
      added = result;
    }

    _Printer.output(new _PrintEvent(
      _PrintEventType.CHILD_RESULT_ADDED, getId(), added));

    for (ResultType type : ResultType.values()) {
      countByResultType_[type.ordinal()] += result.count(type);
    }
  }
}
