/*
 * HtmlPrinter class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.print;

import ts.tester.coverage.Coverage;
import ts.tester.coverage.Coverage.MethodKey;
import ts.tester.coverage.CoveragePrinter;
import ts.tester.coverage.LineCoverage;
import ts.tester.coverage.CaseResult;
import ts.tester.coverage.PassResult;
import ts.tester.coverage.Result;
import ts.util.resource.Resource;
import ts.util.CountUp;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Method;
import com.sun.jdi.Location;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Enumeration;
import java.util.Collection;
import java.util.Iterator;
import java.util.HashMap;

/**
 * JobWvʂo͂悤
 * {@link ts.tester.function.print.HtmlPrinter}NXgʏo
 * NXłB
 * <br>
 * @\sNX̎sʂHTML`̃t@Cɏo͂B
 * o͐̃t@CyHTMLev[ǵARXgN^̈Ɏw肵
 * \[Xt@C̒ɋLqB
 * <br>
 * \[Xt@CŎw\Ȃ\[XL[̈ꗗ\Ɏ:
 * <table border="1">
 * <tr>
 *  <th>L[</th>
 *  <th></th>
 * </tr>
 * <tr>
 *  <td>printer.html.toFile</td>
 *  <td>o͐̃t@C</td>
 * </tr>
 * <tr>
 *  <td>printer.html.format.header</td>
 *  <td>o͂HTMLev[g̃wb_</td>
 * </tr>
 * <tr>
 *  <td>printer.html.format.precases</td>
 *  <td>printer.html.format.casȇOɏo͂HTMLev[gB</td>
 * </tr>
 * <tr>
 *  <td>printer.html.format.case</td>
 *  <td>@\s\bh̐JԂHTMLev[gB</td>
 * </tr>
 * <tr>
 *  <td>printer.html.format.postcases</td>
 *  <td>printer.html.format.casěɏo͂HTMLev[gB</td>
 * </tr>
 * <tr>
 *  <td>printer.html.format.coverage.header</td>
 *  <td>o͂HTMLev[g̃JobWEwb_B</td>
 * </tr>
 * <tr>
 *  <td>printer.html.format.coverage.class.premethods</td>
 *  <td>o͂HTMLev[g̃NXEJobW̃\bhOB</td>
 * </tr>
 * <tr>
 *  <td>printer.html.format.coverage.class.method</td>
 *  <td>o͂HTMLev[g̃NXEJobW̃\bhB</td>
 * </tr>
 * <tr>
 *  <td>printer.html.format.coverage.class.postmethods</td>
 *  <td>o͂HTMLev[g̃NXEJxbW̃\bh㕔B</td>
 * </tr>
 * <tr>
 *  <td>printer.html.format.coverage.footer</td>
 *  <td>o͂HTMLev[g̃JobWEtb^B</td>
 * </tr>
 * <tr>
 *  <td>printer.html.format.footer</td>
 *  <td>o͂HTMLev[g̃tb^B</td>
 * </tr>
 * </table>
 * <p>
 * HTMLev[g̍\́Aȉ̐}̂悤ɂȂB
 * <blockquote>
 *  <table border="1" cellspacing="0" cellpadding="5">
 *  <tr>
 *    <td align="center">&nbsp; printer.html.format.header &nbsp;</td>
 *  </tr>
 *  <tr>
 *    <td align="center">&nbsp; printer.html.format.precases &nbsp;</td>
 *  </tr>
 *  <tr>
 *    <td align="center">:<br>&nbsp; printer.html.format.cases &nbsp;<br>:</td>
 *  </tr>
 *  <tr>
 *    <td align="center">&nbsp; printer.html.format.postcases &nbsp;</td>
 *  </tr>
 *  <tr>
 *    <td align="center">&nbsp; printer.html.format.coverage.header &nbsp;</td>
 *  </tr>
 *  <tr>
 *    <td align="center">:
 *    <table border="1" cellspacing="0" cellpadding="5">
 *    <tr>
 *      <td align="center">&nbsp; printer.html.format.coverage.class.premethods &nbsp;</td>
 *    </tr>
 *    <tr>
 *      <td align="center">:<br>&nbsp; printer.html.format.coverage.class.method &nbsp;<br>:</td>
 *    </tr>
 *    <tr>
 *      <td align="center">&nbsp; printer.html.format.coverage.class.postmethods &nbsp;</td>
 *    </tr>
 *    </table>:
 *    </td>
 *  </tr>
 *  <tr>
 *    <td align="center">&nbsp; printer.html.format.coverage.footer &nbsp;</td>
 *  </tr>
 *  <tr>
 *    <td align="center">&nbsp; printer.html.format.footer &nbsp;</td>
 *  </tr>
 *  </table>
 * </blockquote>
 * <p>
 * HTMLev[gŎgpł鏑wqɂ́Aȉ̂̂:
 * <table border="1">
 * <tr>
 *  <th>wq</th>
 *  <th></th>
 * </tr>
 * <tr>
 *  <td>${test.name}</td>
 *  <td>@\i@\sNXj</td>
 * </tr>
 * <tr>
 *  <td>${test.lastname}</td>
 *  <td>@\sNX̖</td>
 * </tr>
 * <tr>
 *  <td>${test.package-dir}</td>
 *  <td>@\sNX̃pbP[WEpX</td>
 * </tr>
 * <tr>
 *  <td>${test.message}</td>
 *  <td>@\̐</td>
 * </tr>
 * <tr>
 *  <td>${test.tester}</td>
 *  <td>@\̎{Җ</td>
 * </tr>
 * <tr>
 *  <td>${test.date[.<i>simple-date-format</i>]}</td>
 *  <td>@\̎{</td>
 * </tr>
 * <tr>
 *  <td>${test.judge}</td>
 *  <td>@\Ŝ̔茋{"pass"|"reject"}</td>
 * </tr>
 * <tr>
 *  <td>${test.check}</td>
 *  <td>@\Ŝ̔萔</td>
 * </tr>
 * <tr>
 *  <td>${test.good}</td>
 *  <td>@\Ŝ̍i</td>
 * </tr>
 * <tr>
 *  <td>${test.nogood}</td>
 *  <td>@\Ŝ̕si</td>
 * </tr>
 * <tr>
 *  <td>${test.knownbug}</td>
 *  <td>@\Ŝ̊ms</td>
 * </tr>
 * <tr>
 *  <td>${test.child}</td>
 *  <td>@\Ŝ̔茋ʐ</td>
 * </tr>
 * <tr>
 *  <td>${test.empty}</td>
 *  <td>@\Ŝ̋󃁃\bh</td>
 * </tr>
 * <tr>
 *  <td>${test.incomplete}</td>
 *  <td>@\Ŝ̓r\bh</td>
 * </tr>
 * <tr>
 *  <td>${case.name}</td>
 *  <td>@\P[Xi= @\s\bhj</td>
 * </tr>
 * <tr>
 *  <td>${case.message}</td>
 *  <td>@\P[X̐</td>
 * </tr>
 * <tr>
 *  <td>${case.judge}</td>
 *  <td>@\P[X̔茋{"pass"|"reject"}</td>
 * </tr>
 * <tr>
 *  <td>${case.check}</td>
 *  <td>@\P[X̔萔</td>
 * </tr>
 * <tr>
 *  <td>${case.good}</td>
 *  <td>@\P[X̍i</td>
 * </tr>
 * <tr>
 *  <td>${case.nogood}</td>
 *  <td>@\P[X̕si</td>
 * </tr>
 * <tr>
 *  <td>${case.knownbug}</td>
 *  <td>@\P[X̊ms</td>
 * </tr>
 * <tr>
 *  <td>${case.child}</td>
 *  <td>@\P[X̉ʂ̔萔</td>
 * </tr>
 * <tr>
 *  <td>${case.empty}</td>
 *  <td>@\P[X̋󃁃\bh</td>
 * </tr>
 * <tr>
 *  <td>${case.incomplete}</td>
 *  <td>@\P[X̎r\bh</td>
 * </tr>
 * <tr>
 *  <td>${case.index}</td>
 *  <td>@\P[X̃CfbNX</td>
 * </tr>
 * <tr>
 *  <td>${class-coverage.name}</td>
 *  <td>NXEJobW̑ΏۃNX̖O</td>
 * </tr>
 * <tr>
 *  <td>${class-coverage.lastname}</td>
 *  <td>NXEJobW̑ΏۃNX̖</td>
 * </tr>
 * <tr>
 *  <td>${class-coverage.package-dir}</td>
 *  <td>NXEJobW̑ΏۃNX̃pbP[WEfBNg</td>
 * </tr>
 * <tr>
 *  <td>${class-coverage.index}</td>
 *  <td>NXEJobW̑ΏۃNX̃CfbNX</td>
 * </tr>
 * <tr>
 *  <td>${class-coverage.lines}</td>
 *  <td>NXEJobW̑ΏۃNX̑Ss</td>
 * </tr>
 * <tr>
 *  <td>${class-coverage.passed}</td>
 *  <td>NXEJobW̑ΏۃNX̒ʉߍs</td>
 * </tr>
 * <tr>
 *  <td>${class-coverage.unpassed}</td>
 *  <td>NXEJobW̑ΏۃNX̔ʉߍs</td>
 * </tr>
 * <tr>
 *  <td>${class-coverage.passed-ratio}</td>
 *  <td>NXEJobW̑ΏۃNX̍sʉߗ</td>
 * </tr>
 * <tr>
 *  <td>${class-coverage.unpassed-ratio}</td>
 *  <td>NXEJobW̑ΏۃNX̍sʉߗ</td>
 * </tr>
 * <tr>
 *  <td>${class-coverage.passed-lines}</td>
 *  <td>NXEJobW̑ΏۃNX̒ʉߍsԍ̈ꗗ</td>
 * </tr>
 * <tr>
 *  <td>${class-coverage.unpassed-ratio}</td>
 *  <td>NXEJobW̑ΏۃNX̔ʉߍsԍ̈ꗗ</td>
 * </tr>
 * <tr>
 *  <td>${method-coverage.name}</td>
 *  <td>\bhEJobW̑Ώۃ\bh̖O</td>
 * </tr>
 * <tr>
 *  <td>${method-coverage.index}</td>
 *  <td>\bhEJobW̑Ώۃ\bh̃CfbNX</td>
 * </tr>
 * <tr>
 *  <td>${method-coverage.lines}</td>
 *  <td>\bhEJobW̑Ώۃ\bh̑Ss</td>
 * </tr>
 * <tr>
 *  <td>${method-coverage.passed}</td>
 *  <td>\bhEJobW̑Ώۃ\bh̒ʉߍs</td>
 * </tr>
 * <tr>
 *  <td>${method-coverage.unpassed}</td>
 *  <td>\bhEJobW̑Ώۃ\bh̔ʉߍs</td>
 * </tr>
 * <tr>
 *  <td>${method-coverage.passed-ratio}</td>
 *  <td>\bhEJobW̑Ώۃ\bh̍sʉߗ</td>
 * </tr>
 * <tr>
 *  <td>${method-coverage.unpassed-ratio}</td>
 *  <td>\bhEJobW̑Ώۃ\bh̍sʉߗ</td>
 * </tr>
 * <tr>
 *  <td>${method-coverage.passed-lines}</td>
 *  <td>\bhEJobW̑Ώۃ\bh̒ʉߍsԍ̈ꗗ</td>
 * </tr>
 * <tr>
 *  <td>${method-coverage.unpassed-lines}</td>
 *  <td>\bhEJobW̑Ώۃ\bh̔ʉߍsԍ̈ꗗ</td>
 * </tr>
 * <tr>
 *  <td>${src-coverage.name}</td>
 *  <td>\[XEJobW̑Ώۃ\[Xt@C̃pX</td>
 * </tr>
 * <tr>
 *  <td>${src-coverage.index}</td>
 *  <td>\[XEJobW̑Ώۃ\[Xt@C̃CfbNX</td>
 * </tr>
 * <tr>
 *  <td>${src-coverage.lines}</td>
 *  <td>\[XEJobW̑Ώۃ\[Xt@C̑Ss</td>
 * </tr>
 * <tr>
 *  <td>${src-coverage.passed}</td>
 *  <td>\[XEJobW̑Ώۃ\[Xt@C̒ʉߍs</td>
 * </tr>
 * <tr>
 *  <td>${src-coverage.unpassed}</td>
 *  <td>\[XEJobW̑Ώۃ\[Xt@C̔ʉߍs</td>
 * </tr>
 * <tr>
 *  <td>${src-coverage.passed-ratio}</td>
 *  <td>\[XEJobW̑Ώۃ\[Xt@C̍sʉߗ</td>
 * </tr>
 * <tr>
 *  <td>${src-coverage.unpassed-ratio}</td>
 *  <td>\[XEJobW̑Ώۃ\[Xt@C̍sʉߗ</td>
 * </tr>
 * <tr>
 *  <td>${src-coverage.passed-lines}</td>
 *  <td>\[XEJobW̑Ώۃ\[Xt@C̒ʉߍsԍ̈ꗗ</td>
 * </tr>
 * <tr>
 *  <td>${src-coverage.unpassed-lines}</td>
 *  <td>\[XEJobW̑Ώۃ\[Xt@C̔ʉߍsԍ̈ꗗ</td>
 * </tr>
 * </table>
 *
 * @author  V. 
 * @version $Revision: 1.3 $, $Date: 2007/06/25 16:07:41 $
 */
public class HtmlPrinter extends HtmlPrinterBase
  implements CoveragePrinter
{
  /** HTMLy[W̃JobWEwb_\[XL[B */
  protected static final String KEY_COVERAGE_HEADER =
    "printer.html.format.coverage.header";

  /** HTMLy[W̃JobWEtb^\[XL[B */
  protected static final String KEY_COVERAGE_FOOTER =
    "printer.html.format.coverage.footer";

  /** HTMLy[W̃NXEJobW̃\bhO\[XL[B */
  protected static final String KEY_CLASS_COVERAGE_PREMETHODS =
    "printer.html.format.coverage.class.premethods";

  /** HTMLy[W̃NXEJobW̃\bh㕔\[XL[B */
  protected static final String KEY_CLASS_COVERAGE_POSTMETHODS =
    "printer.html.format.coverage.class.postmethods";

  /** HTMLy[W̃NXEJobW̃\bh\[XL[B */
  protected static final String KEY_METHOD_COVERAGE = 
    "printer.html.format.coverage.class.method";

  /** S̃JobWwqB */
  protected static final String FMT_SRC_COVERAGE = "src-coverage"; 

  /** NXEJobWwqB */
  protected static final String FMT_CLASS_COVERAGE = "class-coverage";

  /** \bhEJobWwqB */
  protected static final String FMT_METHOD_COVERAGE = "method-coverage";

  /** OwqB */
  //protected static final String OPT_NAME = ".name";

  /** CfbNXwqB*/
  //protected static final String OPT_INDEX = ".index";

  /** SswqB */
  protected static final String OPT_LINES = ".lines";

  /** ʉߍswqB */
  protected static final String OPT_PASSED = ".passed";

  /** ʉߍswqB*/
  protected static final String OPT_UNPASSED = ".unpassed";

  /** ʉߗwqB */
  protected static final String OPT_PASSED_RATIO = ".passed-ratio";

  /** ʉߗwqB */
  protected static final String OPT_UNPASSED_RATIO = ".unpassed-ratio";

  /** ʉߍs̈ꗗwqB */
  protected static final String OPT_PASSED_LINES=".passed-lines";

  /** ʉߍs̈ꗗwqB */
  protected static final String OPT_UNPASSED_LINES=".unpassed-lines";

  /** JobWvIuWFNgB */
  private Coverage coverage_ = null;

  /** wqli[}bvB */
  private Map<String,Object> replacedMap_ = new HashMap<String,Object>();

  /**
   * ftHgRXgN^B
   */
  protected HtmlPrinter()
  {}

  /**
   * ftHg̃\[Xt@C[hāÃNX̃CX^X쐬
   * B
   *
   * @param  testerName {ҖB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public HtmlPrinter(String testerName)
  {
    super(testerName);
  }

  /**
   * {ҖHTMLev[g`郊\[XIuWFNgɂƂ
   * RXgN^B
   *
   * @param  testerName {ҖB
   * @param  resource HTMLev[g`郊\[XIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public HtmlPrinter(String testerName, Resource resource)
  {
    super(testerName, resource);
  }

  /**
   * JobWv̏sB
   *
   * @param  coverage JobWvIuWFNgB
   */
  public void prepareCoverage(Coverage coverage)
  {
    coverage_ = coverage;
  }

  /**
   * JobWv̌㏈sB
   *
   * @param  coverage JobWvIuWFNgB
   */
  public void postCoverage(Coverage coverage)
  {
    outputHtmlFileForCoverage();
  }

  /**
   * s̓o^ɌĂяo郁\bhB
   *
   * @param  location o^ꂽs{@link com.sun.jdi.Location Location}
   *           IuWFNgB
   */
  public void entryLine(Location location)
  {}

  /**
   * NX̓o^ɌĂяo郁\bhB
   *
   * @param  refType o^ꂽNX̓C^[tFCX
   *           {@link com.sun.jdi.ReferenceType ReferenceType}IuWFNgB
   */
  public void entryClass(ReferenceType refType)
  {}

  /**
   * \bhĂяoɌĂяo郁\bhB
   *
   * @param  method Ăяoꂽ\bh{@link com.sun.jdi.Method Method}
   *           IuWFNgB
   */
  public void entryMethod(Method method)
  {}

  /**
   * \bhIɌĂяo郁\bhB
   *
   * @param  method I\bh{@link com.sun.jdi.Method Method}
   *           IuWFNgB
   */
  public void exitMethod(Method method)
  {}

  /**
   * s̒ʉߎɌĂяo郁\bhB
   *
   * @param  location ʉ߂s{@link com.sun.jdi.Location Location}
   *           IuWFNgB
   */
  public void passLine(Location location)
  {}

  /**
   * ʂHTMLt@Cɏo͂B
   * <br>
   * {@link ts.tester.function.print.HtmlPrinterBase#testEnded(CaseResult)
   * testEnded}\bhĂ΂B
   * <br>
   * ۂɂ́Awqli[}bvÃIuWFNg
   * ݒ肵Ă邾ŁAHTMLt@Cւ̏o͍͂sĂȂB
   * <br>
   * HTMLt@Cւ̏o͂sĂ̂{@link #outputHtmlFileForCoverage()}
   * \bhłB{@link #outputHtmlFileForCoverage()}
   * {@link #postCoverage(Coverage)}\bhĂ΂B
   *
   * @param  objMap wquli[}bvB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected void outputHtmlFile(Map<String, Object> objMap)
  {
    assert (objMap != null) : "@param:objMap is null.";

    replacedMap_ = objMap;
  }

  /**
   * ʂHTMLt@Cɏo͂B
   * <br>
   * ̃\bh́A{@link #postCoverage(Coverage)}\bhĂ΂B
   */
  protected void outputHtmlFileForCoverage()
  {
    Collection<String> classColl = null;
    if (coverage_ != null) {
      classColl = coverage_.allClassNames();
      Iterator<String> classIt = classColl.iterator();
      if (classIt.hasNext()) {
        String className = classIt.next();
        replacedMap_.put(FMT_CLASS_COVERAGE, className);
  
        Collection<MethodKey> methodColl = coverage_.methodKeysOf(className);
        Iterator<MethodKey> methodIt = methodColl.iterator();
        if (methodIt.hasNext()) {
          replacedMap_.put(FMT_METHOD_COVERAGE, methodIt.next());
        }
      }
    }

    CountUp nonCounter = new CountUp(1,1);
    replacedMap_.put(FMT_SRC_COVERAGE    + OPT_INDEX, nonCounter);
    replacedMap_.put(FMT_CLASS_COVERAGE  + OPT_INDEX, nonCounter);
    replacedMap_.put(FMT_METHOD_COVERAGE + OPT_INDEX, nonCounter);

    FileWriter fw = null;
    try {
      String path = getReplacedString(KEY_TOFILE, replacedMap_);
      File file = new File(path);
      File dir = file.getParentFile();
      if (dir != null && !dir.exists()) {
        dir.mkdirs();
      }

      fw = new FileWriter(path);
      PrintWriter pw = new PrintWriter(fw);


      pw.println(getReplacedString(KEY_HEADER, replacedMap_));
      pw.flush();

      pw.println(getReplacedString(KEY_PRECASES, replacedMap_));
      pw.flush();

      _CaseResult testResult = (_CaseResult) replacedMap_.get(FMT_TEST);
      for (ts.tester.function.Result caseResult : testResult.resultList()) {
        Object old = replacedMap_.put(FMT_CASE, caseResult);

        pw.println(getReplacedString(KEY_CASE, replacedMap_));
        pw.flush();

        replacedMap_.put(FMT_CASE, old);
      }

      pw.println(getReplacedString(KEY_POSTCASES, replacedMap_));
      pw.flush();

      if (coverage_ != null) {
        pw.println(getReplacedString(KEY_COVERAGE_HEADER, replacedMap_));
        pw.flush();

        CountUp srcCounter = new CountUp();
        CountUp clsCounter = new CountUp();
        replacedMap_.put(FMT_SRC_COVERAGE   + OPT_INDEX, srcCounter);
        replacedMap_.put(FMT_CLASS_COVERAGE + OPT_INDEX, clsCounter);
  
        Iterator<String> classIt = classColl.iterator();
        while (classIt.hasNext()) {
          clsCounter.increment();
          String className = classIt.next();
          Object oldClassName = replacedMap_.put(FMT_CLASS_COVERAGE, className);
  
          pw.println(getReplacedString(
            KEY_CLASS_COVERAGE_PREMETHODS, replacedMap_));
          pw.flush();
  
          CountUp mtdCounter = new CountUp();
          replacedMap_.put(FMT_METHOD_COVERAGE + OPT_INDEX, mtdCounter);
  
          Collection<MethodKey> methodColl = coverage_.methodKeysOf(className);
          Iterator<MethodKey> methodIt = methodColl.iterator();
          while (methodIt.hasNext()) {
            srcCounter.increment();
            mtdCounter.increment();
            MethodKey methodKey = methodIt.next();
            Object oldMethod = replacedMap_.put(FMT_METHOD_COVERAGE, methodKey);
  
            pw.println(getReplacedString(KEY_METHOD_COVERAGE, replacedMap_));
            pw.flush();
  
            replacedMap_.put(FMT_METHOD_COVERAGE, oldMethod);
          }
  
          pw.println(getReplacedString(
            KEY_CLASS_COVERAGE_POSTMETHODS, replacedMap_));
          pw.flush();
  
          replacedMap_.put(FMT_CLASS_COVERAGE, oldClassName);
        }
  
        replacedMap_.remove(FMT_SRC_COVERAGE   + OPT_INDEX);
        replacedMap_.remove(FMT_CLASS_COVERAGE + OPT_INDEX);
  
        pw.println(getReplacedString(KEY_COVERAGE_FOOTER, replacedMap_));
        pw.flush();
      }

      pw.println(getReplacedString(KEY_FOOTER, replacedMap_));
      pw.flush();
    }
    catch (Exception e) {
      System.err.println(e.toString());
    }
    finally {
      if (fw != null) try { fw.close(); } catch (Exception e) {}
    }
  }

  /**
   * wqۂ̒lɕϊB
   * <br>
   * wqulIuWFNǵÃ}bvɑ΂Ĉȉ
   * wqw肷邱ƂɂĎoƂłB
   * <table border="1">
   * <tr>
   *  <th>wq</th>
   *  <th></th>
   * </tr>
   * <tr>
   *  <td>{@link ts.tester.function.print.HtmlPrinterBase#FMT_TEST
   *      FMT_TEST}</td>
   *  <td>sNXɑ΂{@link
   *      ts.tester.function.print.HtmlPrinterBase._CaseResult _CaseResult}
   *      IuWFNgB
   * </tr>
   * <tr>
   *  <td>{@link ts.tester.function.print.HtmlPrinterBase#FMT_CASE
   *      FMT_CASE}</td>
   *  <td>s\bhɑ΂{@link
   *      ts.tester.function.print.HtmlPrinterBase._CaseResult}
   *      IuWFNgB</td>
   * </tr>
   * <tr>
   *  <td>{@link ts.tester.function.print.HtmlPrinter#FMT_CLASS_COVERAGE
   *      FMT_COVERAGE_CLASS}</td>
   *  <td>NXEJobWi[{@link ts.tester.coverage.CaseResult}
   *      IuWFNgB</td>
   * </tr>
   * <tr>
   *  <td>{@link ts.tester.function.print.HtmlPrinter#FMT_METHOD_COVERAGE
   *      FMT_COVERAGE_METHOD}</td>
   *  <td>\bhEJobWi[{@link
   *      ts.tester.coverage.CaseResult}IuWFNgB</td>
   * </tr>
   * <tr>
   *  <td>{@link ts.tester.function.print.HtmlPrinter#FMT_SRC_COVERAGE
   *      FMT_SRC_COVERAGE}</td>
   *  <td>Ŝ̃JobWi[{@link
   *      ts.tester.coverage.CaseResult}IuWFNgB</td>
   * </tr>
   * </table>
   *
   * @param  arg wqB
   * @param  objMap wquli[}bvB
   * @return ϊ̕B
   */
  @Override
  protected String replaceArgument(String arg, Map<String, Object> objMap)
  {
    assert (arg != null) : "@param:arg is null.";
    assert (objMap != null) : "@param:objMap is null.";

    if (arg.startsWith(FMT_CLASS_COVERAGE)) {
      Object obj = objMap.get(FMT_CLASS_COVERAGE);
      if (obj == null || !(obj instanceof String)) {
        return "--";
      }
      String className = obj.toString();

      if (coverage_ instanceof LineCoverage) {
        LineCoverage lc = (LineCoverage) coverage_;
        Result<Integer> passRes = null, clsRes = null;
        for (String srcPath : lc.allSourcePaths()) {
          passRes = lc.getPassResult(srcPath);
          clsRes = lc.getClassResult(className, passRes);

          String opt = arg.substring(FMT_CLASS_COVERAGE.length());
          if (opt.equals(OPT_NAME)) {
            return className;
          }
          else if (opt.equals(OPT_LASTNAME)) {
            return getClassLastName(className);
          }
          else if (opt.equals(OPT_PACKAGEDIR)) {
            return getPackageDir(className);
          }
          else if (opt.equals(OPT_INDEX)) {
            CountUp c = (CountUp) objMap.get(FMT_CLASS_COVERAGE + OPT_INDEX);
            return String.valueOf(c.currentValue());
          }
          else if (opt.equals(OPT_LINES)) {
            return String.valueOf(clsRes.countAllResults());
          }
          else if (opt.equals(OPT_PASSED)) {
            return String.valueOf(clsRes.countPassedResults());
          }
          else if (opt.equals(OPT_UNPASSED)) {
            return String.valueOf(
              clsRes.countAllResults() - clsRes.countPassedResults());
          }
          else if (opt.equals(OPT_PASSED_RATIO)) {
            return String.valueOf((int)(clsRes.passedRatio() * 100.0f));
          }
          else if (opt.equals(OPT_UNPASSED_RATIO)) {
            return String.valueOf(100 - (int)(clsRes.passedRatio() * 100.0f));
          }
          else if (opt.equals(OPT_PASSED_LINES)) {
            StringBuffer buf = new StringBuffer();
            Enumeration<Integer> e = clsRes.enumPassedResultKeys();
            while (e.hasMoreElements()) {
              int line = e.nextElement();
              if (clsRes.getPassCountOfResult(line) > 0) {
                buf.append(" ").append(line);
              }
            }
            return buf.toString();
          }
          else if (opt.equals(OPT_UNPASSED_LINES)) {
            StringBuffer buf = new StringBuffer();
            Enumeration<Integer> e = clsRes.enumNotPassedResultKeys();
            while (e.hasMoreElements()) {
              int line = e.nextElement();
              if (clsRes.getPassCountOfResult(line) == 0) {
                buf.append(" ").append(line);
              }
            }
            return buf.toString();
          }
        }
      }
    }
    else if (arg.startsWith(FMT_METHOD_COVERAGE)) {
      Object obj = objMap.get(FMT_METHOD_COVERAGE);
      if (obj == null || !(obj instanceof MethodKey)) {
        return "--";
      }
      MethodKey methodKey = (MethodKey) obj;

      Result<Integer> passRes = null, clsRes = null, mtdRes = null;
      if (coverage_ instanceof LineCoverage) {
        LineCoverage lc = (LineCoverage) coverage_;
        for (String srcPath : lc.allSourcePaths()) {
          passRes = lc.getPassResult(srcPath);
          clsRes = lc.getClassResult(methodKey.getClassName(), passRes);
          mtdRes = lc.getMethodResult(methodKey, clsRes);

          String opt = arg.substring(FMT_METHOD_COVERAGE.length());
          if (opt.equals(OPT_NAME)) {
            return methodKey.getMethodName();
          }
          else if (opt.equals(OPT_INDEX)) {
            CountUp c = (CountUp) objMap.get(FMT_METHOD_COVERAGE + OPT_INDEX);
            return String.valueOf(c.currentValue());
          }
          else if (opt.equals(OPT_LINES)) {
            return String.valueOf(mtdRes.countAllResults());
          }
          else if (opt.equals(OPT_PASSED)) {
            return String.valueOf(mtdRes.countPassedResults());
          }
          else if (opt.equals(OPT_UNPASSED)) {
            return String.valueOf(
              mtdRes.countAllResults() - mtdRes.countPassedResults());
          }
          else if (opt.equals(OPT_PASSED_RATIO)) {
            return String.valueOf((int)(mtdRes.passedRatio() * 100.0f));
          }
          else if (opt.equals(OPT_UNPASSED_RATIO)) {
            return String.valueOf(100 - (int)(mtdRes.passedRatio() * 100.0f));
          }
          else if (opt.equals(OPT_PASSED_LINES)) {
            StringBuffer buf = new StringBuffer();
            Enumeration<Integer> e = mtdRes.enumPassedResultKeys();
            while (e.hasMoreElements()) {
              int line = e.nextElement();
              if (mtdRes.getPassCountOfResult(line) > 0) {
                buf.append(" ").append(line);
              }
            }
            return buf.toString();
          }
          else if (opt.equals(OPT_UNPASSED_LINES)) {
            StringBuffer buf = new StringBuffer();
            Enumeration<Integer> e = mtdRes.enumNotPassedResultKeys();
            while (e.hasMoreElements()) {
              int line = e.nextElement();
              if (mtdRes.getPassCountOfResult(line) == 0) {
                buf.append(" ").append(line);
              }
            }
            return buf.toString();
          }
        }
      }
    }
    else if (arg.startsWith(FMT_SRC_COVERAGE)) {
      Result<Integer> passRes = null;
      if (coverage_ instanceof LineCoverage) {
        LineCoverage lc = (LineCoverage) coverage_;
        
        for (String srcPath : lc.allSourcePaths()) {
          passRes = lc.getPassResult(srcPath);

          String opt = arg.substring(FMT_SRC_COVERAGE.length());
          if (opt.equals(OPT_NAME)) {
            return srcPath;
          }
          else if (opt.equals(OPT_INDEX)) {
            CountUp c = (CountUp) objMap.get(FMT_SRC_COVERAGE + OPT_INDEX);
            return String.valueOf(c.currentValue());
          }
          else if (opt.equals(OPT_LINES)) {
            return String.valueOf(passRes.countAllResults());
          }
          else if (opt.equals(OPT_PASSED)) {
            return String.valueOf(passRes.countPassedResults());
          }
          else if (opt.equals(OPT_UNPASSED)) {
            return String.valueOf(
              passRes.countAllResults() - passRes.countPassedResults());
          }
          else if (opt.equals(OPT_PASSED_RATIO)) {
            return String.valueOf((int)(passRes.passedRatio() * 100.0f));
          }
          else if (opt.equals(OPT_UNPASSED_RATIO)) {
            return String.valueOf(100 - (int)(passRes.passedRatio() * 100.0f));
          }
          else if (opt.equals(OPT_PASSED_LINES)) {
            StringBuffer buf = new StringBuffer();
            Enumeration<Integer> e = passRes.enumPassedResultKeys();
            while (e.hasMoreElements()) {
              int line = e.nextElement();
              if (passRes.getPassCountOfResult(line) > 0) {
                buf.append(" ").append(line);
              }
            }
            return buf.toString();
          }
          else if (opt.equals(OPT_UNPASSED_LINES)) {
            StringBuffer buf = new StringBuffer();
            Enumeration<Integer> e = passRes.enumNotPassedResultKeys();
            while (e.hasMoreElements()) {
              int line = e.nextElement();
              if (passRes.getPassCountOfResult(line) == 0) {
                buf.append(" ").append(line);
              }
            }
            return buf.toString();
          }
        }
      }
    }

    return super.replaceArgument(arg, objMap);
  }
}
