/*
 * OutOfRangeExceptionTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.tester.util.ObjectSerializer;
import java.math.BigDecimal;

/**
 * <code>OutOfRangeException</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.3 $, $Date: 2007/05/27 16:13:06 $
 */
public class OutOfRangeExceptionTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(OutOfRangeExceptionTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  @Override
  protected void preTesting()
  {
    MSG("OutOfRangeExceptionNX̋@\sB");
  }

  /* -- text case -- */

  public void constructor_int_int_int()
  {
    MSG("int^̈ƂRXgN^̊mFB");

    OutOfRangeException exc = new OutOfRangeException(1, 2, 3);
    EQUAL(exc.getValue(), new Integer(1));
    EQUAL(exc.getStart(), new Integer(2));
    EQUAL(exc.getEnd(), new Integer(3));
    EQUAL(exc.getMessage(), "1 is out of range (2,3).");

    exc = new OutOfRangeException(1, 3, 2);
    EQUAL(exc.getValue(), new Integer(1));
    EQUAL(exc.getStart(), new Integer(2));
    EQUAL(exc.getEnd(), new Integer(3));
    EQUAL(exc.getMessage(), "1 is out of range (2,3).");
  }

  public void constructor_long_long_long()
  {
    MSG("long^̈ƂRXgN^̊mFB");

    OutOfRangeException exc = new OutOfRangeException(1L, 2L, 3L);
    EQUAL(exc.getValue(), new Long(1));
    EQUAL(exc.getStart(), new Long(2));
    EQUAL(exc.getEnd(), new Long(3));
    EQUAL(exc.getMessage(), "1 is out of range (2,3).");

    exc = new OutOfRangeException(1L, 3L, 2L);
    EQUAL(exc.getValue(), new Long(1));
    EQUAL(exc.getStart(), new Long(2));
    EQUAL(exc.getEnd(), new Long(3));
    EQUAL(exc.getMessage(), "1 is out of range (2,3).");
  }

  public void constructor_float_float_float()
  {
    MSG("float^̈ƂRXgN^̊mFB");

    OutOfRangeException exc = new OutOfRangeException(0.1f, 0.2f, 0.3f);
    EQUAL(exc.getValue(), new Float(0.1f));
    EQUAL(exc.getStart(), new Float(0.2f));
    EQUAL(exc.getEnd(), new Float(0.3f));
    EQUAL(exc.getMessage(), "0.1 is out of range (0.2,0.3).");

    exc = new OutOfRangeException(0.1f, 0.3f, 0.2f);
    EQUAL(exc.getValue(), new Float(0.1f));
    EQUAL(exc.getStart(), new Float(0.2f));
    EQUAL(exc.getEnd(), new Float(0.3f));
    EQUAL(exc.getMessage(), "0.1 is out of range (0.2,0.3).");
  }

  public void constructor_double_double_double()
  {
    MSG("double^̈ƂRXgN^̊mFB");

    OutOfRangeException exc = new OutOfRangeException(0.1, 0.2, 0.3);
    EQUAL(exc.getValue(), new Double(0.1));
    EQUAL(exc.getStart(), new Double(0.2));
    EQUAL(exc.getEnd(), new Double(0.3));
    EQUAL(exc.getMessage(), "0.1 is out of range (0.2,0.3).");

    exc = new OutOfRangeException(0.1, 0.3, 0.2);
    EQUAL(exc.getValue(), new Double(0.1));
    EQUAL(exc.getStart(), new Double(0.2));
    EQUAL(exc.getEnd(), new Double(0.3));
    EQUAL(exc.getMessage(), "0.1 is out of range (0.2,0.3).");
  }

  public void constructor_BigDecimal_BigDecimal_BigDecimal()
  {
    MSG("BigDecimalIuWFNgw肵RXgN^̊mFB");

    MSG("- ʏ̏ꍇ");
    OutOfRangeException exc = new OutOfRangeException(
      new BigDecimal("-0.1"),
      new BigDecimal("-0.2"),
      new BigDecimal("-0.3")
    );
    EQUAL(exc.getValue(), new BigDecimal("-0.1"));
    EQUAL(exc.getStart(), new BigDecimal("-0.3"));
    EQUAL(exc.getEnd()  , new BigDecimal("-0.2"));
    EQUAL(exc.getMessage(), "-0.1 is out of range (-0.3,-0.2).");

    exc = new OutOfRangeException(
      new BigDecimal("-0.1"),
      new BigDecimal("-0.3"),
      new BigDecimal("-0.2")
    );
    EQUAL(exc.getValue(), new BigDecimal("-0.1"));
    EQUAL(exc.getStart(), new BigDecimal("-0.3"));
    EQUAL(exc.getEnd()  , new BigDecimal("-0.2"));
    EQUAL(exc.getMessage(), "-0.1 is out of range (-0.3,-0.2).");

    MSG("- ̑SĂɃkw肵ꍇ");
    exc = new OutOfRangeException(
      (BigDecimal)null, (BigDecimal)null, (BigDecimal)null);
    EQUAL(exc.getValue(), null);
    EQUAL(exc.getStart(), null);
    EQUAL(exc.getEnd()  , null);
    EQUAL(exc.getMessage(), null);

    MSG("- ͈͂zlɒʏBigDecimalAȊOɃkw肵ꍇ");
    exc = new OutOfRangeException(new BigDecimal(1.0), null, null);
    EQUAL(exc.getValue(), new BigDecimal(1.0));
    EQUAL(exc.getStart(), null);
    EQUAL(exc.getEnd()  , null);
    EQUAL(exc.getMessage(), "1 is out of range (-,-).");

    MSG("- ͈͂̊JnlɒʏBigDecimalAȊOɃkw肵ꍇ");
    exc = new OutOfRangeException(null, new BigDecimal(1.0), null);
    EQUAL(exc.getValue(), null);
    EQUAL(exc.getStart(), new BigDecimal(1.0));
    EQUAL(exc.getEnd()  , null);
    EQUAL(exc.getMessage(), "? is out of range (1,-).");

    MSG("- ͈͂̏IlɒʏBigDecimalAȊOɃkw肵ꍇ");
    exc = new OutOfRangeException(null, null, new BigDecimal(1.0));
    EQUAL(exc.getValue(), null);
    EQUAL(exc.getStart(), null);
    EQUAL(exc.getEnd()  , new BigDecimal(1.0));
    EQUAL(exc.getMessage(), "? is out of range (-,1).");
  }

  public void constructor_msg()
  {
    MSG("bZ[WɂƂRXgN^̊mFB");

    OutOfRangeException exc = new OutOfRangeException("Hello!");
    EQUAL(exc.getValue(), null);
    EQUAL(exc.getStart(), null);
    EQUAL(exc.getEnd()  , null);
    EQUAL(exc.getMessage(), "Hello!");
  }

  public void _toString()
  {
    MSG("toString()\bh̊mFB");

    OutOfRangeException exc = new OutOfRangeException("Hello!");
    OK(exc.toString());

    exc = new OutOfRangeException(1, 2, 3);
    OK(exc.toString());
  }

  public void serialize()
  {
    MSG("VACY̊mFB");

    ObjectSerializer os = new ObjectSerializer();

    OutOfRangeException exc = new OutOfRangeException("");
    try {
      byte[] bytes = os.serializeToByteArray(exc);
      OutOfRangeException newExc = (OutOfRangeException)os.deserialize(bytes);
      EQUAL(newExc.getMessage(), exc.getMessage());
    } catch (Exception e) {
      NG(e);
    }
  }
}
