/*
 * FileAlreadyExistsExceptionTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import java.io.IOException;

/**
 * <code>FileAlreadyExistsException</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.3 $, $Date: 2007/05/27 16:13:08 $
 */
public class FileAlreadyExistsExceptionTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(FileAlreadyExistsExceptionTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- test case -- */

  public void constructor_path()
  {
    MSG("ʏ̑̏ꍇ");
    try {
      throw new FileAlreadyExistsException("aaa/bbb.ccc");
    } catch (FileAlreadyExistsException e) {
      EQUAL(e.getPath(), "aaa/bbb.ccc");
      NULL(e.getMessage());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_path_01()
  {
    MSG("k̏ꍇ");
    try {
      throw new FileAlreadyExistsException(null);
    } catch (FileAlreadyExistsException e) {
      NULL(e.getPath());
      NULL(e.getMessage());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_path_msg()
  {
    MSG("ʏ̑̏ꍇ");
    try {
      throw new FileAlreadyExistsException("aaa/bbb.ccc", "");
    } catch (FileAlreadyExistsException e) {
      EQUAL(e.getPath(), "aaa/bbb.ccc");
      EQUAL(e.getMessage(), "");
    } catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_path_msg_01()
  {
    MSG("k̏ꍇ");
    try {
      throw new FileAlreadyExistsException(null, null);
    } catch (FileAlreadyExistsException e) {
      NULL(e.getPath());
      NULL(e.getMessage());
    } catch (Exception e) {
      NG(e);
    }

    try {
      throw new FileAlreadyExistsException("aaa/bbb.ccc", null);
    } catch (FileAlreadyExistsException e) {
      EQUAL(e.getPath(), "aaa/bbb.ccc");
      NULL(e.getMessage());
    } catch (Exception e) {
      NG(e);
    }

    try {
      throw new FileAlreadyExistsException(null, "");
    } catch (FileAlreadyExistsException e) {
      NULL(e.getPath());
      EQUAL(e.getMessage(), "");
    } catch (Exception e) {
      NG(e);
    }
  }

  public void super_class()
  {
    MSG("IOExceptionpĂ邩ǂ");
    try {
      throw new FileAlreadyExistsException("aaa/bbb.ccc", "");
    } catch (IOException e) {
      EQUAL(e.getMessage(), "");
    } catch (Exception e) {
      NG(e);
    }
  }

  public void _toString()
  {
    MSG("ObZ[Ww肵Ȃꍇ");

    try {
      throw new FileAlreadyExistsException("aaa/bbb");
    } catch (Exception e) {
      EQUAL(e.toString(), "ts.util.file.FileAlreadyExistsException: The file already exists: aaa/bbb");
    }
  }

  public void _toString_1()
  {
    MSG("ObZ[Ww肵ꍇ");

    try {
      throw new FileAlreadyExistsException("aaa/bbb", "ccc");
    } catch (Exception e) {
      EQUAL(e.toString(),
        "ts.util.file.FileAlreadyExistsException: ccc: aaa/bbb");
    }
    try {
      throw new FileAlreadyExistsException("aaa/bbb", null);
    } catch (Exception e) {
      EQUAL(e.toString(), "ts.util.file.FileAlreadyExistsException: The file already exists: aaa/bbb");
    }
  }
}
