/*
 * Decompiled with CFR 0.152.
 */
package ts.tester.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ts.tester.Tester;
import ts.tester.function.CaseResult;
import ts.tester.function.CheckResult;
import ts.tester.function.ResultType;
import ts.tester.function.print.ConsolePrinter;
import ts.tester.function.print.Printer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionTester
extends Tester {
    private static Printer printerSpecified_ = new ConsolePrinter();
    private Printer printerUsing_;
    private CaseResult rootCaseResult_;
    private CaseResult inprocessingCaseResult_ = this.rootCaseResult_ = CaseResult.NULL;
    private boolean isPart_ = false;

    public FunctionTester() {
        this.printerUsing_ = printerSpecified_;
    }

    protected static Printer getSpecifiedOrDefaultPrinter() {
        if (printerSpecified_ == null) {
            return new ConsolePrinter();
        }
        Printer printer = printerSpecified_;
        printer.setStopped(false);
        return printer;
    }

    public static void setPrinter(Printer printer) {
        assert (printer != null) : "@param:printer is null.";
        printerSpecified_ = printer;
    }

    public Printer printer() {
        return this.printerUsing_;
    }

    public void addPart(FunctionTester functionTester) {
        if (functionTester == null) {
            return;
        }
        functionTester.isPart_ = true;
        functionTester.printerUsing_ = this.printerUsing_;
        functionTester.inprocessingCaseResult_ = this.inprocessingCaseResult_;
        functionTester.rootCaseResult_ = this.rootCaseResult_;
        super.addTester(functionTester);
    }

    private void checkStopped() throws TestStoppedException {
        if (this.printer().isStopped()) {
            throw new TestStoppedException(this.inprocessingCaseResult_.getName());
        }
    }

    private CaseResult createRootCaseResult() {
        CaseResult caseResult = this.printer().createCaseResult(this.getClass().getName(), CaseResult.NULL);
        if (caseResult == null) {
            return CaseResult.NULL;
        }
        this.printer().testStarted(caseResult);
        this.checkStopped();
        return caseResult;
    }

    private CaseResult createChildCaseResult(String string, CaseResult caseResult) {
        assert (string != null) : "@param:name is null.";
        assert (caseResult != null) : "@param:parent is null.";
        CaseResult caseResult2 = this.printer().createCaseResult(string, caseResult);
        if (caseResult2 == null) {
            return CaseResult.NULL;
        }
        this.printer().caseStarted(caseResult2);
        this.checkStopped();
        return caseResult2;
    }

    @Override
    protected final void initTesting() {
        if (this.isPart_) {
            return;
        }
        this.printerUsing_ = FunctionTester.getSpecifiedOrDefaultPrinter();
        this.rootCaseResult_ = this.inprocessingCaseResult_ = this.createRootCaseResult();
    }

    @Override
    protected final void initInvocation(String string) {
        this.checkStopped();
        this.inprocessingCaseResult_ = this.createChildCaseResult(string, this.inprocessingCaseResult_);
    }

    @Override
    protected void endInvocation(String string) {
        this.checkStopped();
        CaseResult caseResult = this.inprocessingCaseResult_;
        CaseResult caseResult2 = caseResult.getParentCaseResult();
        boolean bl = true;
        for (ResultType resultType : ResultType.values()) {
            if (caseResult.count(resultType) <= 0) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.entryCheck(CheckResult.Empty(), caseResult);
        }
        caseResult2.addChildResult(caseResult);
        this.printer().caseEnded(caseResult);
        this.inprocessingCaseResult_ = caseResult2;
        this.checkStopped();
    }

    @Override
    protected void endTesting() {
        if (this.isPart_) {
            return;
        }
        this.checkStopped();
        CaseResult caseResult = this.inprocessingCaseResult_;
        CaseResult caseResult2 = caseResult.getParentCaseResult();
        caseResult2.addChildResult(caseResult);
        this.printer().testEnded(this.rootCaseResult_);
        this.inprocessingCaseResult_ = this.rootCaseResult_;
    }

    @Override
    protected void stopTesting(Exception exception) throws Exception {
        assert (exception != null) : "@param:e is null.";
        CaseResult caseResult = this.inprocessingCaseResult_;
        this.printer().setStopped(false);
        this.inprocessingCaseResult_ = this.rootCaseResult_;
        if (exception instanceof TestStoppedException) {
            this.printer().testStopped(caseResult);
        }
        throw exception;
    }

    private void entryCheck(CheckResult checkResult) {
        this.entryCheck(checkResult, this.inprocessingCaseResult_);
    }

    private void entryCheck(CheckResult checkResult, CaseResult caseResult) {
        assert (checkResult != null) : "@param:check is null.";
        assert (caseResult != null) : "@param:parent is null.";
        this.checkStopped();
        checkResult.obtainFilePosition(this.getClass(), this.inprocessingCaseResult_.getName());
        caseResult.addChildResult(checkResult);
        this.printer().checkOccured(checkResult, caseResult);
        this.checkStopped();
    }

    protected void MSG(String string) {
        this.checkStopped();
        this.inprocessingCaseResult_.addMessage(string);
        this.printer().messageNoted(string, this.inprocessingCaseResult_);
        this.checkStopped();
    }

    protected void OK() {
        CheckResult checkResult = CheckResult.OK();
        checkResult.setMethod("OK");
        this.entryCheck(checkResult);
    }

    protected void OK(String string) {
        CheckResult checkResult = CheckResult.OK();
        checkResult.setMethod("OK");
        checkResult.setMessage(string);
        this.entryCheck(checkResult);
    }

    protected void OK(Throwable throwable) {
        assert (throwable != null) : "@param:exc is null";
        CheckResult checkResult = CheckResult.OK();
        checkResult.setMethod("OK");
        checkResult.setMessage(throwable.getClass().getName() + ": " + throwable.getMessage());
        this.entryCheck(checkResult);
    }

    protected void NG() {
        CheckResult checkResult = CheckResult.NG();
        checkResult.setMethod("NG");
        this.entryCheck(checkResult);
    }

    protected void NG(String string) {
        CheckResult checkResult = CheckResult.NG();
        checkResult.setMethod("NG");
        checkResult.setMessage(string);
        this.entryCheck(checkResult);
    }

    protected void NG(Throwable throwable) {
        assert (throwable != null) : "@param:exc is null";
        CheckResult checkResult = CheckResult.NG();
        checkResult.setMethod("NG");
        checkResult.setMessage(throwable.getClass().getName() + ": " + throwable.getMessage());
        this.entryCheck(checkResult);
    }

    protected void KNOWNBUG() {
        CheckResult checkResult = CheckResult.KnownBug();
        checkResult.setMethod("KNOWNBUG");
        this.entryCheck(checkResult);
    }

    protected void KNOWNBUG(String string) {
        CheckResult checkResult = CheckResult.KnownBug();
        checkResult.setMethod("KNOWNBUG");
        checkResult.setMessage(string);
        this.entryCheck(checkResult);
    }

    protected void KNOWNBUG(Throwable throwable) {
        assert (throwable != null) : "@param:exc is null";
        CheckResult checkResult = CheckResult.KnownBug();
        checkResult.setMethod("KNOWNBUG");
        checkResult.setMessage(throwable.getClass().getName() + ": " + throwable.getMessage());
        this.entryCheck(checkResult);
    }

    protected void INCOMPLETE() {
        CheckResult checkResult = CheckResult.Incomplete();
        checkResult.setMethod("INCOMPLETE");
        this.entryCheck(checkResult);
    }

    protected void NULL(Object object) {
        CheckResult checkResult = object == null ? CheckResult.OK() : CheckResult.NG();
        checkResult.setMethod("NULL");
        checkResult.setResultValue(object);
        this.entryCheck(checkResult);
    }

    protected void NULL(Object object, String string) {
        CheckResult checkResult;
        if (object == null) {
            checkResult = CheckResult.OK();
        } else {
            checkResult = CheckResult.KnownBug();
            checkResult.setMessage(string);
        }
        checkResult.setMethod("NULL");
        checkResult.setResultValue(object);
        this.entryCheck(checkResult);
    }

    protected void NOTNULL(Object object) {
        CheckResult checkResult = object != null ? CheckResult.OK() : CheckResult.NG();
        checkResult.setMethod("NOTNULL");
        checkResult.setResultValue(object);
        this.entryCheck(checkResult);
    }

    protected void NOTNULL(Object object, String string) {
        CheckResult checkResult;
        if (object != null) {
            checkResult = CheckResult.OK();
        } else {
            checkResult = CheckResult.KnownBug();
            checkResult.setMessage(string);
        }
        checkResult.setMethod("NOTNULL");
        checkResult.setResultValue(object);
        this.entryCheck(checkResult);
    }

    protected void TRUE(boolean bl) {
        CheckResult checkResult;
        if (bl) {
            checkResult = CheckResult.OK();
            checkResult.setResultValue(Boolean.TRUE);
        } else {
            checkResult = CheckResult.NG();
            checkResult.setResultValue(Boolean.FALSE);
        }
        checkResult.setMethod("TRUE");
        this.entryCheck(checkResult);
    }

    protected void TRUE(boolean bl, String string) {
        CheckResult checkResult;
        if (bl) {
            checkResult = CheckResult.OK();
            checkResult.setResultValue(Boolean.TRUE);
        } else {
            checkResult = CheckResult.KnownBug();
            checkResult.setMessage(string);
            checkResult.setResultValue(Boolean.FALSE);
        }
        checkResult.setMethod("TRUE");
        this.entryCheck(checkResult);
    }

    protected void FALSE(boolean bl) {
        CheckResult checkResult;
        if (!bl) {
            checkResult = CheckResult.OK();
            checkResult.setResultValue(Boolean.FALSE);
        } else {
            checkResult = CheckResult.NG();
            checkResult.setResultValue(Boolean.TRUE);
        }
        checkResult.setMethod("FALSE");
        this.entryCheck(checkResult);
    }

    protected void FALSE(boolean bl, String string) {
        CheckResult checkResult;
        if (!bl) {
            checkResult = CheckResult.OK();
            checkResult.setResultValue(Boolean.FALSE);
        } else {
            checkResult = CheckResult.KnownBug();
            checkResult.setMessage(string);
            checkResult.setResultValue(Boolean.TRUE);
        }
        checkResult.setMethod("FALSE");
        this.entryCheck(checkResult);
    }

    private CheckResult checkIdentify(String string, Object object, Object object2) {
        CheckResult checkResult = object == object2 ? CheckResult.OK() : CheckResult.NG();
        checkResult.setMethod(string);
        checkResult.setResultValue(object);
        checkResult.setExpectValue(object2);
        return checkResult;
    }

    private CheckResult checkIdentify(String string, Object object, Object object2, String string2) {
        CheckResult checkResult;
        if (object == object2) {
            checkResult = CheckResult.OK();
        } else {
            checkResult = CheckResult.KnownBug();
            checkResult.setMessage(string2);
        }
        checkResult.setMethod(string);
        checkResult.setResultValue(object);
        checkResult.setExpectValue(object2);
        return checkResult;
    }

    private CheckResult checkNotIdentify(String string, Object object, Object object2) {
        CheckResult checkResult = object != object2 ? CheckResult.OK() : CheckResult.NG();
        checkResult.setMethod(string);
        checkResult.setResultValue(object);
        checkResult.setExpectValue(object2);
        return checkResult;
    }

    private CheckResult checkNotIdentify(String string, Object object, Object object2, String string2) {
        CheckResult checkResult;
        if (object != object2) {
            checkResult = CheckResult.OK();
        } else {
            checkResult = CheckResult.KnownBug();
            checkResult.setMessage(string2);
        }
        checkResult.setMethod(string);
        checkResult.setResultValue(object);
        checkResult.setExpectValue(object2);
        return checkResult;
    }

    private CheckResult checkEquals(String string, Object object, Object object2) {
        if (object == null || object2 == null) {
            return this.checkIdentify(string, object, object2);
        }
        CheckResult checkResult = object.equals(object2) ? CheckResult.OK() : CheckResult.NG();
        checkResult.setMethod(string);
        checkResult.setResultValue(object);
        checkResult.setExpectValue(object2);
        return checkResult;
    }

    private CheckResult checkEquals(String string, Object object, Object object2, String string2) {
        CheckResult checkResult;
        if (object == null || object2 == null) {
            return this.checkIdentify(string, object, object2, string2);
        }
        if (object.equals(object2)) {
            checkResult = CheckResult.OK();
        } else {
            checkResult = CheckResult.KnownBug();
            checkResult.setMessage(string2);
        }
        checkResult.setMethod(string);
        checkResult.setResultValue(object);
        checkResult.setExpectValue(object2);
        return checkResult;
    }

    private CheckResult checkEquals(String string, int n, int n2) {
        return this.checkEquals(string, new Integer(n), new Integer(n2));
    }

    private CheckResult checkEquals(String string, int n, int n2, String string2) {
        return this.checkEquals(string, new Integer(n), new Integer(n2), string2);
    }

    private CheckResult checkNotEquals(String string, Object object, Object object2) {
        if (object == null || object2 == null) {
            return this.checkNotIdentify(string, object, object2);
        }
        CheckResult checkResult = !object.equals(object2) ? CheckResult.OK() : CheckResult.NG();
        checkResult.setMethod(string);
        checkResult.setResultValue(object);
        checkResult.setExpectValue(object2);
        return checkResult;
    }

    private CheckResult checkNotEquals(String string, Object object, Object object2, String string2) {
        CheckResult checkResult;
        if (object == null || object2 == null) {
            return this.checkNotIdentify(string, object, object2, string2);
        }
        if (!object.equals(object2)) {
            checkResult = CheckResult.OK();
        } else {
            checkResult = CheckResult.KnownBug();
            checkResult.setMessage(string2);
        }
        checkResult.setMethod(string);
        checkResult.setResultValue(object);
        checkResult.setExpectValue(object2);
        return checkResult;
    }

    protected void EQUAL(Object object, Object object2) {
        this.entryCheck(this.checkEquals("EQUAL", object, object2));
    }

    protected void EQUAL(Object object, Object object2, String string) {
        this.entryCheck(this.checkEquals("EQUAL", object, object2, string));
    }

    protected void NOTEQUAL(Object object, Object object2) {
        this.entryCheck(this.checkNotEquals("NOTEQUAL", object, object2));
    }

    protected void NOTEQUAL(Object object, Object object2, String string) {
        this.entryCheck(this.checkNotEquals("NOTEQUAL", object, object2, string));
    }

    protected void EQUAL(boolean bl, boolean bl2) {
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl4 = bl2 ? Boolean.TRUE : Boolean.FALSE;
        this.entryCheck(this.checkEquals("EQUAL", bl3, bl4));
    }

    protected void EQUAL(boolean bl, boolean bl2, String string) {
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl4 = bl2 ? Boolean.TRUE : Boolean.FALSE;
        this.entryCheck(this.checkEquals("EQUAL", bl3, bl4, string));
    }

    protected void NOTEQUAL(boolean bl, boolean bl2) {
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl4 = bl2 ? Boolean.TRUE : Boolean.FALSE;
        this.entryCheck(this.checkNotEquals("NOTEQUAL", bl3, bl4));
    }

    protected void NOTEQUAL(boolean bl, boolean bl2, String string) {
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl4 = bl2 ? Boolean.TRUE : Boolean.FALSE;
        this.entryCheck(this.checkNotEquals("NOTEQUAL", bl3, bl4, string));
    }

    protected void EQUAL(byte by, byte by2) {
        this.entryCheck(this.checkEquals("EQUAL", new Byte(by), new Byte(by2)));
    }

    protected void EQUAL(byte by, byte by2, String string) {
        this.entryCheck(this.checkEquals("EQUAL", new Byte(by), new Byte(by2), string));
    }

    protected void NOTEQUAL(byte by, byte by2) {
        this.entryCheck(this.checkNotEquals("NOTEQUAL", new Byte(by), new Byte(by2)));
    }

    protected void NOTEQUAL(byte by, byte by2, String string) {
        this.entryCheck(this.checkNotEquals("NOTEQUAL", new Byte(by), new Byte(by2), string));
    }

    protected void EQUAL(char c, char c2) {
        this.entryCheck(this.checkEquals("EQUAL", new Character(c), new Character(c2)));
    }

    protected void EQUAL(char c, char c2, String string) {
        this.entryCheck(this.checkEquals("EQUAL", new Character(c), new Character(c2), string));
    }

    protected void NOTEQUAL(char c, char c2) {
        this.entryCheck(this.checkNotEquals("NOTEQUAL", new Character(c), new Character(c2)));
    }

    protected void NOTEQUAL(char c, char c2, String string) {
        this.entryCheck(this.checkNotEquals("NOTEQUAL", new Character(c), new Character(c2), string));
    }

    protected void EQUAL(short s, short s2) {
        this.entryCheck(this.checkEquals("EQUAL", new Short(s), new Short(s2)));
    }

    protected void EQUAL(short s, short s2, String string) {
        this.entryCheck(this.checkEquals("EQUAL", new Short(s), new Short(s2), string));
    }

    protected void NOTEQUAL(short s, short s2) {
        this.entryCheck(this.checkNotEquals("NOTEQUAL", new Short(s), new Short(s2)));
    }

    protected void NOTEQUAL(short s, short s2, String string) {
        this.entryCheck(this.checkNotEquals("NOTEQUAL", new Short(s), new Short(s2), string));
    }

    protected void EQUAL(int n, int n2) {
        this.entryCheck(this.checkEquals("EQUAL", new Integer(n), new Integer(n2)));
    }

    protected void EQUAL(int n, int n2, String string) {
        this.entryCheck(this.checkEquals("EQUAL", new Integer(n), new Integer(n2), string));
    }

    protected void NOTEQUAL(int n, int n2) {
        this.entryCheck(this.checkNotEquals("NOTEQUAL", new Integer(n), new Integer(n2)));
    }

    protected void NOTEQUAL(int n, int n2, String string) {
        this.entryCheck(this.checkNotEquals("NOTEQUAL", new Integer(n), new Integer(n2), string));
    }

    protected void EQUAL(long l, long l2) {
        this.entryCheck(this.checkEquals("EQUAL", new Long(l), new Long(l2)));
    }

    protected void EQUAL(long l, long l2, String string) {
        this.entryCheck(this.checkEquals("EQUAL", new Long(l), new Long(l2), string));
    }

    protected void NOTEQUAL(long l, long l2) {
        this.entryCheck(this.checkNotEquals("NOTEQUAL", new Long(l), new Long(l2)));
    }

    protected void NOTEQUAL(long l, long l2, String string) {
        this.entryCheck(this.checkNotEquals("NOTEQUAL", new Long(l), new Long(l2), string));
    }

    protected void EQUAL(float f, float f2) {
        this.entryCheck(this.checkEquals("EQUAL", new Float(f), new Float(f2)));
    }

    protected void EQUAL(float f, float f2, String string) {
        this.entryCheck(this.checkEquals("EQUAL", new Float(f), new Float(f2), string));
    }

    protected void NOTEQUAL(float f, float f2) {
        this.entryCheck(this.checkNotEquals("NOTEQUAL", new Float(f), new Float(f2)));
    }

    protected void NOTEQUAL(float f, float f2, String string) {
        this.entryCheck(this.checkNotEquals("NOTEQUAL", new Float(f), new Float(f2), string));
    }

    protected void EQUAL(double d, double d2) {
        this.entryCheck(this.checkEquals("EQUAL", new Double(d), new Double(d2)));
    }

    protected void EQUAL(double d, double d2, String string) {
        this.entryCheck(this.checkEquals("EQUAL", new Double(d), new Double(d2), string));
    }

    protected void NOTEQUAL(double d, double d2) {
        this.entryCheck(this.checkNotEquals("NOTEQUAL", new Double(d), new Double(d2)));
    }

    protected void NOTEQUAL(double d, double d2, String string) {
        this.entryCheck(this.checkNotEquals("NOTEQUAL", new Double(d), new Double(d2), string));
    }

    protected void EQUAL(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null || objectArray2 == null) {
            this.entryCheck(this.checkIdentify("EQUAL", objectArray, objectArray2));
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Object[]", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", objectArray.length, objectArray2.length);
        checkResult.setName("length");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(objectArray.length, objectArray2.length);
        for (int i = 0; i < n; ++i) {
            Object object = i < objectArray.length ? objectArray[i] : CheckResult.NODATA;
            Object object2 = i < objectArray2.length ? objectArray2[i] : CheckResult.NODATA;
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected void EQUAL(Object[] objectArray, Object[] objectArray2, String string) {
        if (objectArray == null || objectArray2 == null) {
            this.entryCheck(this.checkIdentify("EQUAL", objectArray, objectArray2, string));
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Object[]", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", objectArray.length, objectArray2.length, string);
        checkResult.setName("length");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(objectArray.length, objectArray2.length);
        for (int i = 0; i < n; ++i) {
            Object object = i < objectArray.length ? objectArray[i] : CheckResult.NODATA;
            Object object2 = i < objectArray2.length ? objectArray2[i] : CheckResult.NODATA;
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2, string);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected void EQUAL(boolean[] blArray, boolean[] blArray2) {
        if (blArray == null || blArray2 == null) {
            this.entryCheck(this.checkIdentify("EQUAL", blArray, blArray2));
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Object[]", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", blArray.length, blArray2.length);
        checkResult.setName("length");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(blArray.length, blArray2.length);
        for (int i = 0; i < n; ++i) {
            Object object = CheckResult.NODATA;
            if (i < blArray.length) {
                object = blArray[i] ? Boolean.TRUE : Boolean.FALSE;
            }
            Object object2 = CheckResult.NODATA;
            if (i < blArray2.length) {
                object2 = blArray2[i] ? Boolean.TRUE : Boolean.FALSE;
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2);
            checkResult2.setName("String.valueOf(i)");
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected void EQUAL(boolean[] blArray, boolean[] blArray2, String string) {
        if (blArray == null || blArray2 == null) {
            this.entryCheck(this.checkIdentify("EQUAL", blArray, blArray2, string));
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Object[]", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", blArray.length, blArray2.length, string);
        checkResult.setName("length");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(blArray.length, blArray2.length);
        for (int i = 0; i < n; ++i) {
            Object object = CheckResult.NODATA;
            if (i < blArray.length) {
                object = blArray[i] ? Boolean.TRUE : Boolean.FALSE;
            }
            Object object2 = CheckResult.NODATA;
            if (i < blArray2.length) {
                object2 = blArray2[i] ? Boolean.TRUE : Boolean.FALSE;
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2, string);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected void EQUAL(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            this.entryCheck(this.checkIdentify("EQUAL", byArray, byArray2));
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Object[]", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", byArray.length, byArray2.length);
        checkResult.setName("length");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(byArray.length, byArray2.length);
        for (int i = 0; i < n; ++i) {
            Object object = CheckResult.NODATA;
            if (i < byArray.length) {
                object = new Byte(byArray[i]);
            }
            Object object2 = CheckResult.NODATA;
            if (i < byArray2.length) {
                object2 = new Byte(byArray2[i]);
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected void EQUAL(byte[] byArray, byte[] byArray2, String string) {
        if (byArray == null || byArray2 == null) {
            this.entryCheck(this.checkIdentify("EQUAL", byArray, byArray2, string));
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Object[]", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", byArray.length, byArray2.length, string);
        checkResult.setName("length");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(byArray.length, byArray2.length);
        for (int i = 0; i < n; ++i) {
            Object object = CheckResult.NODATA;
            if (i < byArray.length) {
                object = new Byte(byArray[i]);
            }
            Object object2 = CheckResult.NODATA;
            if (i < byArray2.length) {
                object2 = new Byte(byArray2[i]);
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2, string);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected void EQUAL(char[] cArray, char[] cArray2) {
        if (cArray == null || cArray2 == null) {
            this.entryCheck(this.checkIdentify("EQUAL", cArray, cArray2));
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Object[]", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", cArray.length, cArray2.length);
        checkResult.setName("length");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(cArray.length, cArray2.length);
        for (int i = 0; i < n; ++i) {
            Object object = CheckResult.NODATA;
            if (i < cArray.length) {
                object = new Character(cArray[i]);
            }
            Object object2 = CheckResult.NODATA;
            if (i < cArray2.length) {
                object2 = new Character(cArray2[i]);
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected void EQUAL(char[] cArray, char[] cArray2, String string) {
        if (cArray == null || cArray2 == null) {
            this.entryCheck(this.checkIdentify("EQUAL", cArray, cArray2, string));
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Object[]", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", cArray.length, cArray2.length, string);
        checkResult.setName("length");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(cArray.length, cArray2.length);
        for (int i = 0; i < n; ++i) {
            Object object = CheckResult.NODATA;
            if (i < cArray.length) {
                object = new Character(cArray[i]);
            }
            Object object2 = CheckResult.NODATA;
            if (i < cArray2.length) {
                object2 = new Character(cArray2[i]);
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2, string);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected void EQUAL(short[] sArray, short[] sArray2) {
        if (sArray == null || sArray2 == null) {
            this.entryCheck(this.checkIdentify("EQUAL", sArray, sArray2));
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Object[]", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", sArray.length, sArray2.length);
        checkResult.setName("length");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(sArray.length, sArray2.length);
        for (int i = 0; i < n; ++i) {
            Object object = CheckResult.NODATA;
            if (i < sArray.length) {
                object = new Short(sArray[i]);
            }
            Object object2 = CheckResult.NODATA;
            if (i < sArray2.length) {
                object2 = new Short(sArray2[i]);
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected void EQUAL(short[] sArray, short[] sArray2, String string) {
        if (sArray == null || sArray2 == null) {
            this.entryCheck(this.checkIdentify("EQUAL", sArray, sArray2, string));
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Object[]", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", sArray.length, sArray2.length, string);
        checkResult.setName("length");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(sArray.length, sArray2.length);
        for (int i = 0; i < n; ++i) {
            Object object = CheckResult.NODATA;
            if (i < sArray.length) {
                object = new Short(sArray[i]);
            }
            Object object2 = CheckResult.NODATA;
            if (i < sArray2.length) {
                object2 = new Short(sArray2[i]);
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2, string);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected void EQUAL(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            this.entryCheck(this.checkIdentify("EQUAL", nArray, nArray2));
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Object[]", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", nArray.length, nArray2.length);
        checkResult.setName("length");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(nArray.length, nArray2.length);
        for (int i = 0; i < n; ++i) {
            Object object = CheckResult.NODATA;
            if (i < nArray.length) {
                object = new Integer(nArray[i]);
            }
            Object object2 = CheckResult.NODATA;
            if (i < nArray2.length) {
                object2 = new Integer(nArray2[i]);
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected void EQUAL(int[] nArray, int[] nArray2, String string) {
        if (nArray == null || nArray2 == null) {
            this.entryCheck(this.checkIdentify("EQUAL", nArray, nArray2, string));
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Object[]", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", nArray.length, nArray2.length, string);
        checkResult.setName("length");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(nArray.length, nArray2.length);
        for (int i = 0; i < n; ++i) {
            Object object = CheckResult.NODATA;
            if (i < nArray.length) {
                object = new Integer(nArray[i]);
            }
            Object object2 = CheckResult.NODATA;
            if (i < nArray2.length) {
                object2 = new Integer(nArray2[i]);
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2, string);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected void EQUAL(long[] lArray, long[] lArray2) {
        if (lArray == null || lArray2 == null) {
            this.entryCheck(this.checkIdentify("EQUAL", lArray, lArray2));
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Object[]", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", lArray.length, lArray2.length);
        checkResult.setName("length");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(lArray.length, lArray2.length);
        for (int i = 0; i < n; ++i) {
            Object object = CheckResult.NODATA;
            if (i < lArray.length) {
                object = new Long(lArray[i]);
            }
            Object object2 = CheckResult.NODATA;
            if (i < lArray2.length) {
                object2 = new Long(lArray2[i]);
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected void EQUAL(long[] lArray, long[] lArray2, String string) {
        if (lArray == null || lArray2 == null) {
            this.entryCheck(this.checkIdentify("EQUAL", lArray, lArray2, string));
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Object[]", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", lArray.length, lArray2.length, string);
        checkResult.setName("length");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(lArray.length, lArray2.length);
        for (int i = 0; i < n; ++i) {
            Object object = CheckResult.NODATA;
            if (i < lArray.length) {
                object = new Long(lArray[i]);
            }
            Object object2 = CheckResult.NODATA;
            if (i < lArray2.length) {
                object2 = new Long(lArray2[i]);
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2, string);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected void EQUAL(float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            this.entryCheck(this.checkIdentify("EQUAL", fArray, fArray2));
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Object[]", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", fArray.length, fArray2.length);
        checkResult.setName("length");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(fArray.length, fArray2.length);
        for (int i = 0; i < n; ++i) {
            Object object = CheckResult.NODATA;
            if (i < fArray.length) {
                object = new Float(fArray[i]);
            }
            Object object2 = CheckResult.NODATA;
            if (i < fArray2.length) {
                object2 = new Float(fArray2[i]);
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected void EQUAL(float[] fArray, float[] fArray2, String string) {
        if (fArray == null || fArray2 == null) {
            this.entryCheck(this.checkIdentify("EQUAL", fArray, fArray2, string));
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Object[]", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", fArray.length, fArray2.length, string);
        checkResult.setName("length");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(fArray.length, fArray2.length);
        for (int i = 0; i < n; ++i) {
            Object object = CheckResult.NODATA;
            if (i < fArray.length) {
                object = new Float(fArray[i]);
            }
            Object object2 = CheckResult.NODATA;
            if (i < fArray2.length) {
                object2 = new Float(fArray2[i]);
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2, string);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected void EQUAL(double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            this.entryCheck(this.checkIdentify("EQUAL", dArray, dArray2));
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Object[]", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", dArray.length, dArray2.length);
        checkResult.setName("length");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(dArray.length, dArray2.length);
        for (int i = 0; i < n; ++i) {
            Object object = CheckResult.NODATA;
            if (i < dArray.length) {
                object = new Double(dArray[i]);
            }
            Object object2 = CheckResult.NODATA;
            if (i < dArray2.length) {
                object2 = new Double(dArray2[i]);
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected void EQUAL(double[] dArray, double[] dArray2, String string) {
        if (dArray == null || dArray2 == null) {
            this.entryCheck(this.checkIdentify("EQUAL", dArray, dArray2, string));
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Object[]", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", dArray.length, dArray2.length, string);
        checkResult.setName("length");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(dArray.length, dArray2.length);
        for (int i = 0; i < n; ++i) {
            Object object = CheckResult.NODATA;
            if (i < dArray.length) {
                object = new Double(dArray[i]);
            }
            Object object2 = CheckResult.NODATA;
            if (i < dArray2.length) {
                object2 = new Double(dArray2[i]);
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2, string);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected <T> void EQUAL(Collection<T> collection, Collection<T> collection2) {
        if (collection == null || collection2 == null) {
            this.entryCheck(this.checkIdentify("EQUAL", collection, collection2));
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Collection", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", collection.size(), collection2.size());
        checkResult.setName("size");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(collection.size(), collection2.size());
        ResultComparator resultComparator = new ResultComparator();
        ArrayList<T> arrayList = new ArrayList<T>(n);
        ArrayList<T> arrayList2 = new ArrayList<T>(n);
        arrayList.addAll(collection);
        arrayList2.addAll(collection2);
        Collections.sort(arrayList, resultComparator);
        Collections.sort(arrayList2, resultComparator);
        Iterator iterator = arrayList.iterator();
        Iterator iterator2 = arrayList2.iterator();
        for (int i = 0; i < n; ++i) {
            Object object = CheckResult.NODATA;
            if (iterator.hasNext()) {
                object = iterator.next();
            }
            Object object2 = CheckResult.NODATA;
            if (iterator2.hasNext()) {
                object2 = iterator2.next();
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected <T> void EQUAL(Collection<T> collection, Collection<T> collection2, String string) {
        if (collection == null || collection2 == null) {
            CheckResult checkResult = this.checkIdentify("EQUAL", collection, collection2, string);
            this.entryCheck(checkResult);
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Collection", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", collection.size(), collection2.size(), string);
        checkResult.setName("size");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(collection.size(), collection2.size());
        ResultComparator resultComparator = new ResultComparator();
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        ArrayList<T> arrayList2 = new ArrayList<T>(collection2);
        Collections.sort(arrayList, resultComparator);
        Collections.sort(arrayList2, resultComparator);
        Iterator iterator = arrayList.iterator();
        Iterator iterator2 = arrayList2.iterator();
        for (int i = 0; i < n; ++i) {
            Object object = CheckResult.NODATA;
            if (iterator.hasNext()) {
                object = iterator.next();
            }
            Object object2 = CheckResult.NODATA;
            if (iterator2.hasNext()) {
                object2 = iterator2.next();
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2, string);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected <T> void EQUAL(List<T> list, List<T> list2) {
        if (list == null || list2 == null) {
            CheckResult checkResult = this.checkIdentify("EQUAL", list, list2);
            this.entryCheck(checkResult);
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("List", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", list.size(), list2.size());
        checkResult.setName("size");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(list.size(), list2.size());
        Iterator<T> iterator = list.iterator();
        Iterator<T> iterator2 = list2.iterator();
        for (int i = 0; i < n; ++i) {
            Object object = CheckResult.NODATA;
            if (iterator.hasNext()) {
                object = iterator.next();
            }
            Object object2 = CheckResult.NODATA;
            if (iterator2.hasNext()) {
                object2 = iterator2.next();
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected <T> void EQUAL(List<T> list, List<T> list2, String string) {
        if (list == null || list2 == null) {
            CheckResult checkResult = this.checkIdentify("EQUAL", list, list2, string);
            this.entryCheck(checkResult);
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("List", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", list.size(), list2.size(), string);
        checkResult.setName("size");
        this.entryCheck(checkResult, caseResult);
        int n = Math.max(list.size(), list2.size());
        Iterator<T> iterator = list.iterator();
        Iterator<T> iterator2 = list2.iterator();
        for (int i = 0; i < n; ++i) {
            Object object = CheckResult.NODATA;
            if (iterator.hasNext()) {
                object = iterator.next();
            }
            Object object2 = CheckResult.NODATA;
            if (iterator2.hasNext()) {
                object2 = iterator2.next();
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2, string);
            checkResult2.setName(String.valueOf(i));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected <K, V> void EQUAL(Map<K, V> map, Map<K, V> map2) {
        if (map == null || map2 == null) {
            CheckResult checkResult = this.checkIdentify("EQUAL", map, map2);
            this.entryCheck(checkResult);
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Map", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", map.size(), map2.size());
        checkResult.setName("size");
        this.entryCheck(checkResult, caseResult);
        HashSet<K> hashSet = new HashSet<K>();
        hashSet.addAll(map.keySet());
        hashSet.addAll(map2.keySet());
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList, new ResultComparator());
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList.get(i);
            Object object = CheckResult.NODATA;
            if (map.containsKey(e)) {
                object = map.get(e);
            }
            Object object2 = CheckResult.NODATA;
            if (map2.containsKey(e)) {
                object2 = map2.get(e);
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2);
            checkResult2.setName(String.valueOf(e));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected <K, V> void EQUAL(Map<K, V> map, Map<K, V> map2, String string) {
        if (map == null || map2 == null) {
            CheckResult checkResult = this.checkIdentify("EQUAL", map, map2, string);
            this.entryCheck(checkResult);
            return;
        }
        CaseResult caseResult = this.createChildCaseResult("Map", this.inprocessingCaseResult_);
        CheckResult checkResult = this.checkEquals("EQUAL", map.size(), map2.size(), string);
        checkResult.setName("size");
        this.entryCheck(checkResult, caseResult);
        HashSet<K> hashSet = new HashSet<K>();
        hashSet.addAll(map.keySet());
        hashSet.addAll(map2.keySet());
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList, new ResultComparator());
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList.get(i);
            Object object = CheckResult.NODATA;
            if (map.containsKey(e)) {
                object = map.get(e);
            }
            Object object2 = CheckResult.NODATA;
            if (map2.containsKey(e)) {
                object2 = map2.get(e);
            }
            CheckResult checkResult2 = this.checkEquals("EQUAL", object, object2, string);
            checkResult2.setName(String.valueOf(e));
            this.entryCheck(checkResult2, caseResult);
        }
        this.inprocessingCaseResult_.addChildResult(caseResult);
    }

    protected void MATCH(String string, String string2) {
        if (string == null && string2 == null) {
            CheckResult checkResult = CheckResult.OK();
            checkResult.setMethod("MATCH");
            checkResult.setResultValue(null);
            this.entryCheck(checkResult);
            return;
        }
        if (string == null || string2 == null) {
            CheckResult checkResult = CheckResult.NG();
            checkResult.setMethod("MATCH");
            checkResult.setResultValue(null);
            this.entryCheck(checkResult);
            return;
        }
        boolean bl = string.length() == string2.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n = Math.min(string.length(), string2.length());
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != string2.charAt(i)) {
                bl = false;
                break;
            }
            stringBuffer.append(string.charAt(i));
        }
        if (bl) {
            CheckResult checkResult = CheckResult.OK();
            checkResult.setMethod("MATCH");
            checkResult.setResultValue(stringBuffer.toString());
            this.entryCheck(checkResult);
        } else {
            CheckResult checkResult = CheckResult.NG();
            checkResult.setMethod("MATCH");
            checkResult.setResultValue(stringBuffer.toString());
            this.entryCheck(checkResult);
        }
    }

    protected void MATCH(String string, String string2, String string3) {
        if (string == null && string2 == null) {
            CheckResult checkResult = CheckResult.OK();
            checkResult.setMethod("MATCH");
            checkResult.setResultValue(null);
            this.entryCheck(checkResult);
            return;
        }
        if (string == null || string2 == null) {
            CheckResult checkResult = CheckResult.KnownBug();
            checkResult.setMethod("MATCH");
            checkResult.setResultValue(null);
            checkResult.setMessage(string3);
            this.entryCheck(checkResult);
            return;
        }
        boolean bl = string.length() == string2.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n = Math.min(string.length(), string2.length());
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != string2.charAt(i)) {
                bl = false;
                break;
            }
            stringBuffer.append(string.charAt(i));
        }
        if (bl) {
            CheckResult checkResult = CheckResult.OK();
            checkResult.setMethod("MATCH");
            checkResult.setResultValue(stringBuffer.toString());
            this.entryCheck(checkResult);
        } else {
            CheckResult checkResult = CheckResult.KnownBug();
            checkResult.setMethod("MATCH");
            checkResult.setName("match");
            checkResult.setResultValue(stringBuffer.toString());
            checkResult.setMessage(string3);
            this.entryCheck(checkResult);
        }
    }

    protected void MATCH(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        this.MATCH(stringBuffer != null ? stringBuffer.toString() : null, stringBuffer2 != null ? stringBuffer2.toString() : null);
    }

    protected void MATCH(StringBuffer stringBuffer, StringBuffer stringBuffer2, String string) {
        this.MATCH(stringBuffer != null ? stringBuffer.toString() : null, stringBuffer2 != null ? stringBuffer2.toString() : null, string);
    }

    protected void IDENTIFY(Object object, Object object2) {
        this.entryCheck(this.checkIdentify("IDENTIFY", object, object2));
    }

    protected void IDENTIFY(Object object, Object object2, String string) {
        this.entryCheck(this.checkIdentify("IDENTIFY", object, object2, string));
    }

    protected void POSITIVE(short s) {
        CheckResult checkResult = s > 0 ? CheckResult.OK() : CheckResult.NG();
        checkResult.setMethod("POSITIVE");
        checkResult.setResultValue(new Short(s));
        this.entryCheck(checkResult);
    }

    protected void POSITIVE(int n) {
        CheckResult checkResult = n > 0 ? CheckResult.OK() : CheckResult.NG();
        checkResult.setMethod("POSITIVE");
        checkResult.setResultValue(new Integer(n));
        this.entryCheck(checkResult);
    }

    protected void POSITIVE(long l) {
        CheckResult checkResult = l > 0L ? CheckResult.OK() : CheckResult.NG();
        checkResult.setMethod("POSITIVE");
        checkResult.setResultValue(new Long(l));
        this.entryCheck(checkResult);
    }

    protected void POSITIVE(float f) {
        CheckResult checkResult = f > 0.0f ? CheckResult.OK() : CheckResult.NG();
        checkResult.setMethod("POSITIVE");
        checkResult.setResultValue(new Float(f));
        this.entryCheck(checkResult);
    }

    protected void POSITIVE(double d) {
        CheckResult checkResult = d > 0.0 ? CheckResult.OK() : CheckResult.NG();
        checkResult.setMethod("POSITIVE");
        checkResult.setResultValue(new Double(d));
        this.entryCheck(checkResult);
    }

    protected void NEGATIVE(short s) {
        CheckResult checkResult = s < 0 ? CheckResult.OK() : CheckResult.NG();
        checkResult.setMethod("NEGATIVE");
        checkResult.setResultValue(new Short(s));
        this.entryCheck(checkResult);
    }

    protected void NEGATIVE(int n) {
        CheckResult checkResult = n < 0 ? CheckResult.OK() : CheckResult.NG();
        checkResult.setMethod("NEGATIVE");
        checkResult.setResultValue(new Integer(n));
        this.entryCheck(checkResult);
    }

    protected void NEGATIVE(long l) {
        CheckResult checkResult = l < 0L ? CheckResult.OK() : CheckResult.NG();
        checkResult.setMethod("NEGATIVE");
        checkResult.setResultValue(new Long(l));
        this.entryCheck(checkResult);
    }

    protected void NEGATIVE(float f) {
        CheckResult checkResult = f < 0.0f ? CheckResult.OK() : CheckResult.NG();
        checkResult.setMethod("NEGATIVE");
        checkResult.setResultValue(new Float(f));
        this.entryCheck(checkResult);
    }

    protected void NEGATIVE(double d) {
        CheckResult checkResult = d < 0.0 ? CheckResult.OK() : CheckResult.NG();
        checkResult.setMethod("NEGATIVE");
        checkResult.setResultValue(new Double(d));
        this.entryCheck(checkResult);
    }

    protected void POSITIVE(short s, String string) {
        CheckResult checkResult;
        if (s > 0) {
            checkResult = CheckResult.OK();
        } else {
            checkResult = CheckResult.KnownBug();
            checkResult.setMessage(string);
        }
        checkResult.setMethod("POSITIVE");
        checkResult.setResultValue(new Short(s));
        this.entryCheck(checkResult);
    }

    protected void POSITIVE(int n, String string) {
        CheckResult checkResult;
        if (n > 0) {
            checkResult = CheckResult.OK();
        } else {
            checkResult = CheckResult.KnownBug();
            checkResult.setMessage(string);
        }
        checkResult.setMethod("POSITIVE");
        checkResult.setResultValue(new Integer(n));
        this.entryCheck(checkResult);
    }

    protected void POSITIVE(long l, String string) {
        CheckResult checkResult;
        if (l > 0L) {
            checkResult = CheckResult.OK();
        } else {
            checkResult = CheckResult.KnownBug();
            checkResult.setMessage(string);
        }
        checkResult.setMethod("POSITIVE");
        checkResult.setResultValue(new Long(l));
        this.entryCheck(checkResult);
    }

    protected void POSITIVE(float f, String string) {
        CheckResult checkResult;
        if (f > 0.0f) {
            checkResult = CheckResult.OK();
        } else {
            checkResult = CheckResult.KnownBug();
            checkResult.setMessage(string);
        }
        checkResult.setMethod("POSITIVE");
        checkResult.setResultValue(new Float(f));
        this.entryCheck(checkResult);
    }

    protected void POSITIVE(double d, String string) {
        CheckResult checkResult;
        if (d > 0.0) {
            checkResult = CheckResult.OK();
        } else {
            checkResult = CheckResult.KnownBug();
            checkResult.setMessage(string);
        }
        checkResult.setMethod("POSITIVE");
        checkResult.setResultValue(new Double(d));
        this.entryCheck(checkResult);
    }

    protected void NEGATIVE(short s, String string) {
        CheckResult checkResult;
        if (s < 0) {
            checkResult = CheckResult.OK();
        } else {
            checkResult = CheckResult.KnownBug();
            checkResult.setMessage(string);
        }
        checkResult.setMethod("NEGATIVE");
        checkResult.setResultValue(new Short(s));
        this.entryCheck(checkResult);
    }

    protected void NEGATIVE(int n, String string) {
        CheckResult checkResult;
        if (n < 0) {
            checkResult = CheckResult.OK();
        } else {
            checkResult = CheckResult.KnownBug();
            checkResult.setMessage(string);
        }
        checkResult.setMethod("NEGATIVE");
        checkResult.setResultValue(new Integer(n));
        this.entryCheck(checkResult);
    }

    protected void NEGATIVE(long l, String string) {
        CheckResult checkResult;
        if (l < 0L) {
            checkResult = CheckResult.OK();
        } else {
            checkResult = CheckResult.NG();
            checkResult.setMessage(string);
        }
        checkResult.setMethod("NEGATIVE");
        checkResult.setResultValue(new Long(l));
        this.entryCheck(checkResult);
    }

    protected void NEGATIVE(float f, String string) {
        CheckResult checkResult;
        if (f < 0.0f) {
            checkResult = CheckResult.OK();
        } else {
            checkResult = CheckResult.NG();
            checkResult.setMessage(string);
        }
        checkResult.setMethod("NEGATIVE");
        checkResult.setResultValue(new Float(f));
        this.entryCheck(checkResult);
    }

    protected void NEGATIVE(double d, String string) {
        CheckResult checkResult;
        if (d < 0.0) {
            checkResult = CheckResult.OK();
        } else {
            checkResult = CheckResult.NG();
            checkResult.setMessage(string);
        }
        checkResult.setMethod("NEGATIVE");
        checkResult.setResultValue(new Double(d));
        this.entryCheck(checkResult);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultComparator<T>
    implements Comparator<T> {
        ResultComparator() {
        }

        @Override
        public int compare(T t, T t2) {
            if (t == null) {
                if (t2 == null) {
                    return 0;
                }
                return 1;
            }
            if (t2 == null) {
                return -1;
            }
            int n = t.getClass().getName().compareTo(t2.getClass().getName());
            if (n != 0) {
                return n;
            }
            int n2 = t.hashCode() - t2.hashCode();
            if (n2 != 0) {
                return n2;
            }
            return t.toString().compareTo(t2.toString());
        }
    }

    private class TestStoppedException
    extends RuntimeException {
        static final long serialVersionUID = 3833601781206791512L;

        public TestStoppedException() {
        }

        public TestStoppedException(String string) {
            super(string);
        }
    }
}

