/*
 * CheckResultTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.tester.util.*;

/**
 * <code>CheckResult</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.3 $, $Date: 2007/10/08 16:11:08 $
 */
public class CheckResultTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(CheckResultTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- test case -- */

  public void constants()
  {
    MSG("萔l̊mF");

    OK(String.valueOf(CheckResult.UNSET));
    OK(String.valueOf(CheckResult.NODATA));
    FALSE(CheckResult.UNSET == CheckResult.NODATA);
    FALSE(CheckResult.UNSET.equals(CheckResult.NODATA));
    FALSE(CheckResult.NODATA.equals(CheckResult.UNSET));
  }

  public void enums()
  {
    MSG("񋓃f[^̊mF");

    EQUAL(ResultType.NG.toString(), "NG");
    EQUAL(ResultType.KnownBug.toString(), "KnownBug");
    EQUAL(ResultType.Empty.toString(), "Empty");
    EQUAL(ResultType.Incomplete.toString(), "Incomplete");
  }

  public void setMethod()
  {
    MSG("ʏ̑̏ꍇB");

    CheckResult r = CheckResult.OK();
    EQUAL(r.getMethod(), "");
    r.setMethod("");
    EQUAL(r.getMethod(), "");
  }

  public void setMethod_1()
  {
    MSG("k̏ꍇ");

    CheckResult r = CheckResult.NG();
    EQUAL(r.getMethod(), "");
    try {
      r.setMethod(null); NG();
    } catch (AssertionError e) {
      OK(e.toString());
    }
    EQUAL(r.getMethod(), "");
    r.setMethod("ABC");
    EQUAL(r.getMethod(), "ABC");
    try {
      r.setMethod(null); NG("aaa");
    } catch (AssertionError e) {
      OK(e.toString());
    }
    EQUAL(r.getMethod(), "ABC");
  }

  public void setMessage()
  {
    MSG("ʏ̑̏ꍇ");

    CheckResult r = CheckResult.OK();
    EQUAL(r.getMessage(), "");
    r.setMessage("");
    EQUAL(r.getMessage(), "");
  }

  public void setMessage_1()
  {
    MSG("k̏ꍇ");

    CheckResult r = CheckResult.NG();
    EQUAL(r.getMessage(), "");
    try {
      r.setMessage(null); NG();
    } catch (AssertionError e) {
      OK(e.toString());
    }
    EQUAL(r.getMessage(), "");
    r.setMessage("ABC");
    EQUAL(r.getMessage(), "ABC");
    try {
      r.setMessage(null); NG("aaa");
    } catch (AssertionError e) {
      OK(e.toString());
    }
    EQUAL(r.getMessage(), "ABC");
  }

  public void setResultValue()
  {
    MSG("ʏ̑̏ꍇ");
    CheckResult r = CheckResult.OK();
    TRUE(r.getResultValue() == CheckResult.UNSET);
    r.setResultValue(new Integer(123));
    EQUAL(r.getResultValue(), new Integer(123));
  }

  public void setResultValue_1()
  {
    MSG("k̏ꍇ");
    CheckResult r = CheckResult.OK();
    TRUE(r.getResultValue() == CheckResult.UNSET);
    r.setResultValue(null);
    EQUAL(r.getResultValue(), null);
  }

  public void setResultValue_2()
  {
    MSG("CheckResult.UNSET̏ꍇ");
    CheckResult r = CheckResult.OK();
    TRUE(r.getResultValue() == CheckResult.UNSET);
    r.setResultValue(new Integer(123));
    EQUAL(r.getResultValue(), new Integer(123));
    try {
      r.setResultValue(CheckResult.UNSET);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    }
    EQUAL(r.getResultValue(), new Integer(123));
  }

  public void setResultValue_3()
  {
    MSG("CheckResult.NODATȀꍇ");
    CheckResult r = CheckResult.OK();
    TRUE(r.getResultValue() == CheckResult.UNSET);
    r.setResultValue(new Long(999L));
    EQUAL(r.getResultValue(), new Long(999L));
    r.setResultValue(CheckResult.NODATA);
    EQUAL(r.getResultValue(), CheckResult.NODATA);
  }

  public void setExpectValue()
  {
    MSG("ʏ̑̏ꍇ");
    CheckResult r = CheckResult.NG();
    TRUE(r.getExpectValue() == CheckResult.UNSET);
    r.setExpectValue(new Double(0.123));
    EQUAL(r.getExpectValue(), new Double(0.123));
  }

  public void setExpectValue_1()
  {
    MSG("k̏ꍇ");
    CheckResult r = CheckResult.NG();
    TRUE(r.getExpectValue() == CheckResult.UNSET);
    r.setExpectValue(null);
    EQUAL(r.getExpectValue(), null);
  }

  public void setExpectValue_2()
  {
    MSG("CheckResult.UNSET̏ꍇ");
    CheckResult r = CheckResult.NG();
    TRUE(r.getExpectValue() == CheckResult.UNSET);
    r.setExpectValue("");
    EQUAL(r.getExpectValue(), "");
    try {
      r.setExpectValue(CheckResult.UNSET);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    }
    EQUAL(r.getExpectValue(), "");
  }

  public void setExpectValue_3()
  {
    MSG("CheckResult.NODATȀꍇ");
    CheckResult r = CheckResult.OK();
    TRUE(r.getExpectValue() == CheckResult.UNSET);
    r.setExpectValue("");
    EQUAL(r.getExpectValue(), "");
    r.setExpectValue(CheckResult.NODATA);
    EQUAL(r.getExpectValue(), CheckResult.NODATA);
  }

  public void OKs()
  {
    MSG("ʏ̑̊mF");

    CheckResult r = CheckResult.OK();
    FALSE(r.is(ResultType.NG));
    FALSE(r.is(ResultType.KnownBug));
    FALSE(r.is(ResultType.Empty));
    FALSE(r.is(ResultType.Incomplete));
    EQUAL(r.getMessage(), "");
    TRUE(r.getExpectValue() == CheckResult.UNSET);
    TRUE(r.getResultValue() == CheckResult.UNSET);
    EQUAL(r.getFileName(), "");
    EQUAL(r.getLineNumber(), 1);
    EQUAL(r.getLineNumber(), 1);
    EQUAL(r.getName(), "");
  }

  public void OK_name()
  {
    MSG("ʏ̑̊mF");

    CheckResult r = CheckResult.OK("");
    FALSE(r.is(ResultType.NG));
    FALSE(r.is(ResultType.KnownBug));
    FALSE(r.is(ResultType.Empty));
    FALSE(r.is(ResultType.Incomplete));
    EQUAL(r.getMessage(), "");
    TRUE(r.getExpectValue() == CheckResult.UNSET);
    TRUE(r.getResultValue() == CheckResult.UNSET);
    EQUAL(r.getFileName(), "");
    EQUAL(r.getLineNumber(), 1);
    EQUAL(r.getName(), "");
  }

  public void OK_name_1()
  {
    MSG("k̏ꍇ");

    try {
      CheckResult.OK(null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void NGs()
  {
    MSG("ʏ̑̏ꍇ");

    CheckResult r = CheckResult.NG();
    TRUE(r.is(ResultType.NG));
    FALSE(r.is(ResultType.KnownBug));
    FALSE(r.is(ResultType.Empty));
    FALSE(r.is(ResultType.Incomplete));
    EQUAL(r.getMessage(), "");
    TRUE(r.getExpectValue() == CheckResult.UNSET);
    TRUE(r.getResultValue() == CheckResult.UNSET);
    EQUAL(r.getFileName(), "");
    EQUAL(r.getLineNumber(), 1);
    EQUAL(r.getName(), "");
  }

  public void NG_name()
  {
    MSG("ʏ̑̏ꍇ");

    CheckResult r = CheckResult.NG("aaa");
    TRUE(r.is(ResultType.NG));
    FALSE(r.is(ResultType.KnownBug));
    FALSE(r.is(ResultType.Empty));
    FALSE(r.is(ResultType.Incomplete));
    EQUAL(r.getMessage(), "");
    TRUE(r.getExpectValue() == CheckResult.UNSET);
    TRUE(r.getResultValue() == CheckResult.UNSET);
    EQUAL(r.getFileName(), "");
    EQUAL(r.getLineNumber(), 1);
    EQUAL(r.getName(), "aaa");
  }

  public void NG_name_1()
  {
    MSG("k̏ꍇ");

    try {
      CheckResult.NG(null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void KnownBugs()
  {
    MSG("ʏ̑̏ꍇ");

    CheckResult r = CheckResult.KnownBug();
    FALSE(r.is(ResultType.NG));
    TRUE(r.is(ResultType.KnownBug));
    FALSE(r.is(ResultType.Empty));
    FALSE(r.is(ResultType.Incomplete));
    EQUAL(r.getMessage(), "");
    TRUE(r.getExpectValue() == CheckResult.UNSET);
    TRUE(r.getResultValue() == CheckResult.UNSET);
    EQUAL(r.getFileName(), "");
    EQUAL(r.getLineNumber(), 1);
    EQUAL(r.getName(), "");
  }

  public void KnownBugs_name()
  {
    MSG("ʏ̑̏ꍇ");

    CheckResult r = CheckResult.KnownBug("nnn");
    FALSE(r.is(ResultType.NG));
    TRUE(r.is(ResultType.KnownBug));
    FALSE(r.is(ResultType.Empty));
    FALSE(r.is(ResultType.Incomplete));
    EQUAL(r.getMessage(), "");
    TRUE(r.getExpectValue() == CheckResult.UNSET);
    TRUE(r.getResultValue() == CheckResult.UNSET);
    EQUAL(r.getFileName(), "");
    EQUAL(r.getLineNumber(), 1);
    EQUAL(r.getName(), "nnn");
  }

  public void KnownBugs_name_1()
  {
    MSG("k̏ꍇ");

    try { 
      CheckResult r = CheckResult.KnownBug(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void Emptys()
  {
    MSG("ʏ̑̏ꍇ");

    CheckResult r = CheckResult.Empty();
    FALSE(r.is(ResultType.NG));
    FALSE(r.is(ResultType.KnownBug));
    TRUE (r.is(ResultType.Empty));
    FALSE(r.is(ResultType.Incomplete));
    EQUAL(r.getMessage(), "");
    TRUE(r.getResultValue() == CheckResult.UNSET);
    TRUE(r.getExpectValue() == CheckResult.UNSET);
    EQUAL(r.getFileName(), "");
    EQUAL(r.getLineNumber(), 1);
    EQUAL(r.getName(), "");
  }

  public void Incomplete()
  {
    MSG("ʏ̑̏ꍇ");

    CheckResult r = CheckResult.Incomplete();
    FALSE(r.is(ResultType.NG));
    FALSE(r.is(ResultType.KnownBug));
    FALSE(r.is(ResultType.Empty));
    TRUE (r.is(ResultType.Incomplete));
    EQUAL(r.getMessage(), "");
    TRUE(r.getResultValue() == CheckResult.UNSET);
    TRUE(r.getExpectValue() == CheckResult.UNSET);
    EQUAL(r.getFileName(), "");
    EQUAL(r.getLineNumber(), 1);
    EQUAL(r.getName(), "");
  }

  public void count_type()
  {
    CheckResult r = CheckResult.OK();
    EQUAL(r.count(ResultType.NG), 0);
    EQUAL(r.count(ResultType.KnownBug), 0);
    EQUAL(r.count(ResultType.Empty), 0);
    EQUAL(r.count(ResultType.Incomplete), 0);

    r = CheckResult.NG();
    EQUAL(r.count(ResultType.NG), 1);
    EQUAL(r.count(ResultType.KnownBug), 0);
    EQUAL(r.count(ResultType.Empty), 0);
    EQUAL(r.count(ResultType.Incomplete), 0);

    r = CheckResult.KnownBug();
    EQUAL(r.count(ResultType.NG), 0);
    EQUAL(r.count(ResultType.KnownBug), 1);
    EQUAL(r.count(ResultType.Empty), 0);
    EQUAL(r.count(ResultType.Incomplete), 0);

    r = CheckResult.Empty();
    EQUAL(r.count(ResultType.NG), 0);
    EQUAL(r.count(ResultType.KnownBug), 0);
    EQUAL(r.count(ResultType.Empty), 1);
    EQUAL(r.count(ResultType.Incomplete), 0);

    r = CheckResult.Incomplete();
    EQUAL(r.count(ResultType.NG), 0);
    EQUAL(r.count(ResultType.KnownBug), 0);
    EQUAL(r.count(ResultType.Empty), 0);
    EQUAL(r.count(ResultType.Incomplete), 1);
  }

  public void serialize_and_deserialize()
  {
    MSG("VACYyуfVACY̎");

    ObjectSerializer os = new ObjectSerializer();
    try {
      CheckResult r = CheckResult.OK();
      byte[] bs = os.serializeToByteArray(r);
      r = (CheckResult) os.deserialize(bs);

      EQUAL(r.count(ResultType.NG), 0);
      EQUAL(r.count(ResultType.KnownBug), 0);
      EQUAL(r.count(ResultType.Empty), 0);
      EQUAL(r.count(ResultType.Incomplete), 0);
      TRUE(r.getResultValue() == CheckResult.UNSET);
      TRUE(r.getExpectValue() == CheckResult.UNSET);
    } catch (Exception e) {
      e.printStackTrace();
      NG(e);
    }
  
    try {
      CheckResult r = CheckResult.NG();
      byte[] bs = os.serializeToByteArray(r);
      r = (CheckResult) os.deserialize(bs);

      EQUAL(r.count(ResultType.NG), 1);
      EQUAL(r.count(ResultType.KnownBug), 0);
      EQUAL(r.count(ResultType.Empty), 0);
      EQUAL(r.count(ResultType.Incomplete), 0);
      TRUE(r.getResultValue() == CheckResult.UNSET);
      TRUE(r.getExpectValue() == CheckResult.UNSET);
    } catch (Exception e) {
      e.printStackTrace();
      NG(e);
    }

    try {
      CheckResult r = CheckResult.KnownBug();
      byte[] bs = os.serializeToByteArray(r);
      r = (CheckResult) os.deserialize(bs);

      EQUAL(r.count(ResultType.NG), 0);
      EQUAL(r.count(ResultType.KnownBug), 1);
      EQUAL(r.count(ResultType.Empty), 0);
      EQUAL(r.count(ResultType.Incomplete), 0);
      TRUE(r.getResultValue() == CheckResult.UNSET);
      TRUE(r.getExpectValue() == CheckResult.UNSET);
    } catch (Exception e) {
      e.printStackTrace();
      NG(e);
    }
  
    try {
      CheckResult r = CheckResult.Empty();
      byte[] bs = os.serializeToByteArray(r);
      r = (CheckResult) os.deserialize(bs);

      EQUAL(r.count(ResultType.NG), 0);
      EQUAL(r.count(ResultType.KnownBug), 0);
      EQUAL(r.count(ResultType.Empty), 1);
      EQUAL(r.count(ResultType.Incomplete), 0);
      TRUE(r.getResultValue() == CheckResult.UNSET);
      TRUE(r.getExpectValue() == CheckResult.UNSET);
    } catch (Exception e) {
      e.printStackTrace();
      NG(e);
    }

    try {
      CheckResult r = CheckResult.Incomplete();
      byte[] bs = os.serializeToByteArray(r);
      r = (CheckResult) os.deserialize(bs);

      EQUAL(r.count(ResultType.NG), 0);
      EQUAL(r.count(ResultType.KnownBug), 0);
      EQUAL(r.count(ResultType.Empty), 0);
      EQUAL(r.count(ResultType.Incomplete), 1);
      TRUE(r.getResultValue() == CheckResult.UNSET);
      TRUE(r.getExpectValue() == CheckResult.UNSET);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void serialize_and_deserialize_2()
  {
    MSG("VACYyуfVACY̎(2)");

    ObjectSerializer os = new ObjectSerializer();
    try {
      CheckResult r = CheckResult.NG();
      r.setExpectValue("ABC");
      r.setResultValue("XYZ");

      byte[] bs = os.serializeToByteArray(r);
      r = (CheckResult) os.deserialize(bs);

      EQUAL(r.count(ResultType.NG), 1);
      EQUAL(r.count(ResultType.KnownBug), 0);
      EQUAL(r.count(ResultType.Empty), 0);
      EQUAL(r.count(ResultType.Incomplete), 0);
      EQUAL(r.getExpectValue(), "ABC");
      EQUAL(r.getResultValue(), "XYZ");
    } catch (Exception e) {
      e.printStackTrace();
      NG(e);
    }
  }

  public void serialize_and_deserialize_3()
  {
    MSG("VACYyуfVACY̎(3)");

    ObjectSerializer os = new ObjectSerializer();
    try {
      CheckResult r = CheckResult.NG();
      r.setExpectValue(CheckResult.NODATA);

      byte[] bs = os.serializeToByteArray(r);
      r = (CheckResult) os.deserialize(bs);

      EQUAL(r.count(ResultType.NG), 1);
      EQUAL(r.count(ResultType.KnownBug), 0);
      EQUAL(r.count(ResultType.Empty), 0);
      EQUAL(r.count(ResultType.Incomplete), 0);
      TRUE(r.getExpectValue() == CheckResult.NODATA);
      TRUE(r.getResultValue() == CheckResult.UNSET);

    } catch (Exception e) {
      e.printStackTrace();
      NG(e);
    }

    try {
      CheckResult r = CheckResult.NG();
      r.setResultValue(CheckResult.NODATA);

      byte[] bs = os.serializeToByteArray(r);
      r = (CheckResult) os.deserialize(bs);

      EQUAL(r.count(ResultType.NG), 1);
      EQUAL(r.count(ResultType.KnownBug), 0);
      EQUAL(r.count(ResultType.Empty), 0);
      EQUAL(r.count(ResultType.Incomplete), 0);
      TRUE(r.getExpectValue() == CheckResult.UNSET);
      TRUE(r.getResultValue() == CheckResult.NODATA);

    } catch (Exception e) {
      e.printStackTrace();
      NG(e);
    }
  }

  public void serialize_and_deserialize_4()
  {
    MSG("VACYyуfVACY̎(4)");

    class _CaseResult extends CaseResult {
      _CaseResult() { super("", CaseResult.NULL); }
      public void addChildResult(Result result) {}
      public int count(ResultType type) { return 0; }
    }

    ObjectSerializer os = new ObjectSerializer();
    try {
      CheckResult r = CheckResult.NG();
      _CaseResult c1 = new _CaseResult();
      _CaseResult c2 = new _CaseResult();
      r.setExpectValue(c1);
      r.setResultValue(c2);
      byte[] bs = os.serializeToByteArray(r);
      r = (CheckResult) os.deserialize(bs);

      EQUAL(r.count(ResultType.NG), 1);
      EQUAL(r.count(ResultType.KnownBug), 0);
      EQUAL(r.count(ResultType.Empty), 0);
      EQUAL(r.count(ResultType.Incomplete), 0);
      NOTNULL(r.getExpectValue());
      NOTNULL(r.getResultValue());
    }
    catch (Exception e) {
      NG(e);
    }
  }
}

