/*
 * FunctionTester class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function;

import ts.tester.Tester;
import ts.tester.function.print.Printer;
import ts.tester.function.print.ConsolePrinter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;

/**
 * @\sNXB
 * <br>
 * ̃NX̔hNXŎꂽP[X\bhsǍʂWv
 * Ď̍iEsi𔻒肷B
 * P[X\bhƂ́AhNXɒɎꂽAE߂lȂŁA
 * ANZXwqpubÑ\bĥƂłB
 * <br>
 * ̌ʂ́A{@link ts.tester.function.print.Printer Printer}IuWFNg
 * gďo͂B
 * {@link ts.tester.function.print.Printer Printer}NX́Ao͐o͕@
 * ɉĔhNXpӂB
 * {@link ts.tester.function.print.Printer Printer}IuWFNg̐ݒ́A
 * {@link ts.tester.function.FunctionTester#setPrinter(ts.tester.function.print.Printer) setPrinter}\bhgčsB
 *
 * @author  V. 
 * @version $Revision: 1.4 $, $Date: 2007/10/08 16:11:08 $
 */
public class FunctionTester extends Tester
{
  /** ʂ̏o͂Ɏgp{@link ts.tester.function.print.Printer Printer}
   *  IuWFNgB
   */
  private static Printer printerSpecified_ = new ConsolePrinter();

  /** ۂ̏o͂Ɏgp{@link ts.tester.function.print.Printer Printer}
   *  IuWFNgB
   */
  private Printer printerUsing_ ;

  /** ŏʂ̎P[XʃIuWFNgB */
  private CaseResult rootCaseResult_ ;

  /** ݏ̎P[XʃIuWFNgB */
  private CaseResult inprocessingCaseResult_;

  /** ̋@\sIuWFNg̈ꕔƂĎs邩ǂtOB */
  private boolean isPart_ = false;

  /**
   * ftHgRXgN^B
   */
  public FunctionTester()
  {
    rootCaseResult_ = CaseResult.NULL;
    inprocessingCaseResult_ = rootCaseResult_;

    printerUsing_ = printerSpecified_ ;
  }

  /**
   * OɎw肳ꂽo̓IuWFNg΂ԂAw肳ĂȂ
   * ftHg̏o̓IuWFNgԂB
   * <br>
   * {@link ts.tester.function.FunctionTester#setPrinter(
   * ts.tester.function.print.Printer) setPrinter}\bhgĐݒ肳ꂽ
   * o̓IuWFNg΂ԂB
   * xݒ肳ĂȂ΁AɃftHg̏o̓IuWFNgԂB
   * <br>
   * ftHg̏o̓IuWFNg̏ꍇ́A
   * {@link ts.tester.function.print.ConsolePrinter ConsolePrinter}
   * IuWFNgԂB
   *
   * @return {@link ts.tester.function.print.Printer}IuWFNgB
   */
  protected static Printer getSpecifiedOrDefaultPrinter()
  {
    if (printerSpecified_ == null) {
      return new ConsolePrinter();
    }

    Printer p = printerSpecified_;
    p.setStopped(false);
    return p;
  }

  /**
   * o̓IuWFNgݒ肷B
   * <br>
   * ʂ̏o͂Ɏgp
   * {@link ts.tester.function.print.Printer Printer}IuWFNgݒ肷B
   *
   * @param  printer o̓IuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static void setPrinter(Printer printer)
  {
    assert (printer != null) : "@param:printer is null.";

    printerSpecified_ = printer;
  }

  /**
   * o̓IuWFNg擾B
   * <br>
   * ʂ̏o͂Ɏgp
   * {@link ts.tester.function.print.Printer Printer}IuWFNg擾B
   *
   * @return  o̓IuWFNgB
   */
  public Printer printer()
  {
    return printerUsing_ ;
  }

  /**
   * ̃IuWFNgs@\̈ꕔƂĎs
   * {@link ts.tester.function.FunctionTester FunctionTester}IuWFNg
   * ǉB
   * <br>
   * k̏ꍇ͖B
   *
   * @param  tester {@link ts.tester.function.FunctionTester FunctionTester}
   *           IuWFNgB
   */
  public void addPart(FunctionTester tester)
  {
    if (tester == null) {
      return;
    }

    tester.isPart_ = true;
    tester.printerUsing_ = this.printerUsing_ ;
    tester.inprocessingCaseResult_ = this.inprocessingCaseResult_ ;
    tester.rootCaseResult_ = this.rootCaseResult_ ;

    super.addTester(tester);
  }

  /**
   * ̒fwmFB
   * <br>
   * {@link ts.tester.function.print.Printer Printer}IuWFNg̒ftO
   * ̒l<tt>true</tt>̏ꍇ́AOX[B
   *
   * @throws TestStoppedException ̒fwoĂꍇB
   */
  private void checkStopped() throws TestStoppedException
  {
    if (printer().isStopped()) {
      throw new TestStoppedException(inprocessingCaseResult_.getName());
    }
  }

  /**
   * ŏʂ̎P[XʔIuWFNg쐬B
   * <br>
   * ۂɍ쐬ŝ́Ao̓IuWFNgłB
   * o̓IuWFNgkԂꍇ́A̔sȂ
   * P[XʔIuWFNgԂB
   *
   * @return ŏʂ̎P[XʔIuWFNgB
   */
  private CaseResult createRootCaseResult()
  {
    CaseResult c = printer().createCaseResult(
      getClass().getName(), CaseResult.NULL);

    if (c == null) {
      return CaseResult.NULL;
    }
    printer().testStarted(c);
    checkStopped();
    return c;
  }

  /**
   * P[XʔIuWFNg쐬B
   * <br>
   * ۂɍ쐬ŝ́Ao̓IuWFNgłB
   * o̓IuWFNgkԂꍇ́A̔sȂ
   * P[XʔIuWFNgԂB
   *
   * @param  name sP[XB
   * @param  parent ʂ̎P[X茋ʃIuWFNgB
   * @return P[XʔIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  private CaseResult createChildCaseResult(String name, CaseResult parent)
  {
    assert (name != null) : "@param:name is null.";
    assert (parent != null) : "@param:parent is null.";

    CaseResult c = printer().createCaseResult(name, parent);

    if (c == null) {
      return CaseResult.NULL;
    }
    printer().caseStarted(c);
    checkStopped();
    return c;
  }

  /**
   * Ŝ̏sB
   *
   * @throws TestStoppedException ̒fwoĂꍇB
   */
  @Override protected final void initTesting()
  {
    if (isPart_ ) {
      return;
    }

    printerUsing_ = getSpecifiedOrDefaultPrinter();
    inprocessingCaseResult_ = createRootCaseResult();
    rootCaseResult_ = inprocessingCaseResult_ ;
  }

  /**
   * P[X茋ʃIuWFNg̏sB
   *
   * @param  methodName \bhB
   * @throws TestStoppedException ̒fwoĂꍇB
   */
  @Override protected final void initInvocation(String methodName)
  {
    checkStopped();

    inprocessingCaseResult_ = createChildCaseResult(
      methodName, inprocessingCaseResult_);
  }

  /**
   * P[X茋ʃIuWFNg̏IsB
   *
   * @param  methodName \bhB
   * @throws TestStoppedException ̒fwoĂꍇB
   */
  @Override protected void endInvocation(String methodName)
  {
    checkStopped();

    CaseResult current = inprocessingCaseResult_;
    CaseResult parent = current.getParentCaseResult();

    boolean isEmpty = true;
    for (ResultType type : ResultType.values()) {
      if (current.count(type) > 0) {
        isEmpty = false;
        break;
      }
    }
    if (isEmpty) {
      entryCheck(CheckResult.Empty(), current);
    }

    parent.addChildResult(current);
    printer().caseEnded(current);

    inprocessingCaseResult_ = parent;
    checkStopped();
  }

  /**
   * Ŝ̏IsB
   *
   * @throws TestStoppedException ̒fwoĂꍇB
   */
  @Override protected void endTesting()
  {
    if (isPart_) {
      return;
    }

    checkStopped();

    CaseResult current = inprocessingCaseResult_;
    CaseResult parent = current.getParentCaseResult();

    parent.addChildResult(current);
    printer().testEnded(rootCaseResult_);

    inprocessingCaseResult_ = rootCaseResult_;
  }

  /**
   * fꂽꍇɌĂ΂郁\bhB
   *
   * @param  e f̌ƂȂOIuWFNgB
   * @throws Exception ̗OIuWFNg̃\bhŏȂ
   *           ꍇA܂͂̃\bhŐVɗOX[ꂽꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  @Override protected void stopTesting(Exception e) throws Exception
  {
    assert (e != null) : "@param:e is null.";

    CaseResult current = inprocessingCaseResult_ ;
    printer().setStopped(false);
    inprocessingCaseResult_ = rootCaseResult_;
    
    if (e instanceof TestStoppedException) {
      printer().testStopped(current);
    }

    throw e;
  }

  /**
   * 茋ʃIuWFNgA݂̎P[XʃIuWFNgɓo^B
   *
   * @param  check 茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  private void entryCheck(CheckResult check)
  {
    entryCheck(check, inprocessingCaseResult_);
  }

  /**
   * 茋ʃIuWFNgAw肳ꂽP[XʃIuWFNgɓo^B
   *
   * @param  check 茋ʃIuWFNgB
   * @param  parent P[XʃIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  private void entryCheck(CheckResult check, CaseResult parent)
  {
    assert (check != null) : "@param:check is null.";
    assert (parent != null) : "@param:parent is null.";

    checkStopped();
    check.obtainFilePosition(getClass(), inprocessingCaseResult_.getName());
    parent.addChildResult(check);
    printer().checkOccured(check, parent);
    checkStopped();
  }

  /**
   * \bhɑΉ鎎P[XʃIuWFNgɃbZ[Wo^B
   *
   * @param  msg bZ[WB
   * @throws TestStoppedException ̒fwoĂꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected void MSG(String msg)
  {
    checkStopped();
    inprocessingCaseResult_.addMessage(msg);
    printer().messageNoted(msg, inprocessingCaseResult_);
    checkStopped();
  }

  /**
   * i茋ʂP[XʃIuWFNgɓo^B
   *
   * @throws TestStoppedException ̒fwoĂꍇB
   */
  protected void OK()
  {
    CheckResult c = CheckResult.OK();
    c.setMethod("OK");
    entryCheck(c);
  }

  /**
   * i茋ʂɃbZ[WYĎP[XʃIuWFNgɓo^
   * B
   *
   * @param  msg 茋ʂɓY郁bZ[WB
   * @throws TestStoppedException ̒fwoĂꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected void OK(String msg)
  {
    CheckResult c = CheckResult.OK();
    c.setMethod("OK");
    c.setMessage(msg);
    entryCheck(c);
  }

  /**
   * i茋ʂɗO̓eYĎP[X
   * IuWFNgɓo^B
   * <br>
   * Oɓe\́AONXƗObZ[WA
   * B
   *
   * @param  exc OIuWFNgB
   * @throws TestStoppedException ̒fwoĂꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected void OK(Throwable exc)
  {
    assert (exc != null) : "@param:exc is null";

    CheckResult c = CheckResult.OK();
    c.setMethod("OK");
    c.setMessage(exc.getClass().getName() + ": " + exc.getMessage());
    entryCheck(c);
  }

  /**
   * si茋ʂP[XʃIuWFNgɓo^B
   *
   * @throws TestStoppedException ̒fwoĂꍇB
   */
  protected void NG()
  {
    CheckResult c = CheckResult.NG();
    c.setMethod("NG");
    entryCheck(c);
  }

  /**
   * si茋ʂɃbZ[WYĎP[XʃIuWFNgɓo^
   * B
   *
   * @param  msg 茋ʂɓY郁bZ[WB
   * @throws TestStoppedException ̒fwoĂꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected void NG(String msg)
  {
    CheckResult c = CheckResult.NG();
    c.setMethod("NG");
    c.setMessage(msg);
    entryCheck(c);
  }

  /**
   * si茋ʂɗO̓eYĎP[X
   * IuWFNgɓo^B
   * <br>
   * Oɓe\́AONXƗObZ[WA
   * B
   *
   * @param  exc OIuWFNgB
   * @throws TestStoppedException ̒fwoĂꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected void NG(Throwable exc)
  {
    assert (exc != null) : "@param:exc is null";

    CheckResult c = CheckResult.NG();
    c.setMethod("NG");
    c.setMessage(exc.getClass().getName() + ": " + exc.getMessage());
    entryCheck(c);
  }

  /**
   * ms茋ʂP[XʃIuWFNgɓo^B
   *
   * @throws TestStoppedException ̒fwoĂꍇB
   */
  protected void KNOWNBUG()
  {
    CheckResult c = CheckResult.KnownBug();
    c.setMethod("KNOWNBUG");
    entryCheck(c);
  }

  /**
   * ms茋ʂɃbZ[WYĎP[XʃIuWFNg
   * o^B
   *
   * @param  msg 茋ʂɓY郁bZ[WB
   * @throws TestStoppedException ̒fwoĂꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected void KNOWNBUG(String msg)
  {
    CheckResult c = CheckResult.KnownBug();
    c.setMethod("KNOWNBUG");
    c.setMessage(msg);
    entryCheck(c);
  }

  /**
   * ms茋ʂɗO̓eYĎP[X
   * IuWFNgɓo^B
   * <br>
   * Oɓe\́AONXƗObZ[WA
   * B
   *
   * @param  exc OIuWFNgB
   * @throws TestStoppedException ̒fwoĂꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected void KNOWNBUG(Throwable exc)
  {
    assert (exc != null) : "@param:exc is null";

    CheckResult c = CheckResult.KnownBug();
    c.setMethod("KNOWNBUG");
    c.setMessage(exc.getClass().getName() + ": " + exc.getMessage());
    entryCheck(c);
  }

  /**
   * P[X\bhrł邱Ƃ茋ʃIuWFNgA
   * P[XʃIuWFNgɓo^B
   */
  protected void INCOMPLETE()
  {
    CheckResult c = CheckResult.Incomplete();
    c.setMethod("INCOMPLETE");
    entryCheck(c);
  }

  /**
   * ̃IuWFNgkǂ𔻒肵āǍʂP[X
   * IuWFNgɓo^B
   *
   * @param  result lB
   * @throws AssertionError l{@link ts.tester.function.CheckResult#UNSET
   *           CheckResult.UNSET}ꍇifobO[ĥ݁jB
   */
  protected void NULL(Object result)
  {
    CheckResult c = (result == null) ? CheckResult.OK() : CheckResult.NG();
    c.setMethod("NULL");
    c.setResultValue(result);
    entryCheck(c);
  }

  /**
   * ̃IuWFNgkǂ𔻒肵āǍʂP[X
   * IuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  reason ms̗RB
   * @throws AssertionError l{@link ts.tester.function.CheckResult#UNSET
   *           CheckResult.UNSET}ꍇA͊ms̗Rk̏ꍇ
   *          ifobO[ĥ݁jB
   */
  protected void NULL(Object result, String reason)
  {
    CheckResult c;
    if (result == null) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.KnownBug();
      c.setMessage(reason);
    }
    c.setMethod("NULL");
    c.setResultValue(result);
    entryCheck(c);
  }

  /**
   * ̃IuWFNgkłȂǂ𔻒肵āǍʂP[X
   * IuWFNgɓo^B
   *
   * @param  result lB
   * @throws AssertionError l{@link ts.tester.function.CheckResult#UNSET
   *           CheckResult.UNSET}ꍇifobO[ĥ݁jB
   */
  protected void NOTNULL(Object result)
  {
    CheckResult c = (result != null) ? CheckResult.OK() : CheckResult.NG();
    c.setMethod("NOTNULL");
    c.setResultValue(result);
    entryCheck(c);
  }

  /**
   * ̃IuWFNgkłȂǂ𔻒肵āǍʂP[X
   * IuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  reason ms̗RB
   * @throws AssertionError l{@link ts.tester.function.CheckResult#UNSET
   *           CheckResult.UNSET}ꍇA͊ms̗Rk̏ꍇ
   *           ifobO[ĥ݁jB
   */
  protected void NOTNULL(Object result, String reason)
  {
    CheckResult c;
    if (result != null) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.KnownBug();
      c.setMessage(reason);
    }
    c.setMethod("NOTNULL");
    c.setResultValue(result);
    entryCheck(c);
  }

  /**
   * ^ǂ𔻒肵āǍʂP[XʃIuWFNgɓo^
   * B
   * <br>
   * ^̏ꍇ͔茋ʂiƂAłȂΕsiƂB
   *
   * @param  v ̑ΏۂƂȂ<code>boolean</code>lB
   */
  protected void TRUE(boolean v)
  {
    CheckResult c;
    if (v) {
      c = CheckResult.OK();
      c.setResultValue(Boolean.TRUE);
    }
    else {
      c = CheckResult.NG();
      c.setResultValue(Boolean.FALSE);
    }
    c.setMethod("TRUE");
    entryCheck(c);
  }

  /**
   * ^ǂ𔻒肵āǍʂP[XʃIuWFNgɓo^
   * B
   * <br>
   * ^̏ꍇ͔茋ʂiƂAłȂΕsiƂB
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  v ̑ΏۂƂȂ<code>boolean</code>lB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void TRUE(boolean v, String reason)
  {
    CheckResult c;
    if (v) {
      c = CheckResult.OK();
      c.setResultValue(Boolean.TRUE);
    }
    else {
      c = CheckResult.KnownBug();
      c.setMessage(reason);
      c.setResultValue(Boolean.FALSE);
    }
    c.setMethod("TRUE");
    entryCheck(c);
  }

  /**
   * Uǂ𔻒肵āǍʂP[XʃIuWFNgɓo^
   * B
   * <br>
   * Ȕꍇ͔茋ʂiƂAłȂΕsiƂB
   *
   * @param  v ̑ΏۂƂȂ<code>boolean</code>lB
   */
  protected void FALSE(boolean v)
  {
    CheckResult c;
    if (! v) {
      c = CheckResult.OK();
      c.setResultValue(Boolean.FALSE);
    }
    else {
      c = CheckResult.NG();
      c.setResultValue(Boolean.TRUE);
    }
    c.setMethod("FALSE");
    entryCheck(c);
  }

  /**
   * Uǂ𔻒肵āǍʂP[XʃIuWFNgɓo^
   * B
   * <br>
   * Ȕꍇ͔茋ʂiƂAłȂΕsiƂB
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  v ̑ΏۂƂȂ<code>boolean</code>lB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void FALSE(boolean v, String reason)
  {
    CheckResult c;
    if (! v) {
      c = CheckResult.OK();
      c.setResultValue(Boolean.FALSE);
    }
    else {
      c = CheckResult.KnownBug();
      c.setMessage(reason);
      c.setResultValue(Boolean.TRUE);
    }
    c.setMethod("FALSE");
    entryCheck(c);
  }

  /**
   * w肳ꂽ̃IuWFNgꂩǂ𔻒肵ʂԂB
   * <br>
   * IuWFNg̔r{@link java.lang.Object#equals(java.lang.Object)
   * Object.equals(Object)}\bhł͂ȂA<code>==</code>pB
   *
   * @param  name 胁\bhB
   * @param  result lB
   * @param  expect ҒlB
   * @return 茋ʃIuWFNgB
   * @throws AssertionError 胁\bhk̏ꍇA͎lEҒl
   *           {@link ts.tester.function.CheckResult#UNSET CheckResult.UNSET}
   *           ꍇifobO[ĥ݁jB
   */
  private CheckResult checkIdentify(String name, Object result, Object expect)
  {
    CheckResult c;
    if (result == expect) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.NG();
    }
    c.setMethod(name);
    c.setResultValue(result);
    c.setExpectValue(expect);
    return c;
  }

  /**
   * w肳ꂽ̃IuWFNgꂩǂ𔻒肵ʂԂB
   * <br>
   * IuWFNg̔r{@link java.lang.Object#equals(java.lang.Object)
   * Object.equals(Object)}\bhł͂ȂA<code>==</code>pB
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  name 胁\bhB
   * @param  result lB
   * @param  expect ҒlB
   * @return 茋ʃIuWFNgB
   * @throws AssertionError 胁\bhk̏ꍇA͎lEҒl
   *           {@link ts.tester.function.CheckResult#UNSET CheckResult.UNSET}
   *           ꍇA͊ms̗Rk̏ꍇ
   *           ifobO[ĥ݁jB
   */
  private CheckResult checkIdentify(
    String name, Object result, Object expect, String reason)
  {
    CheckResult c;
    if (result == expect) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.KnownBug();
      c.setMessage(reason);
    }
    c.setMethod(name);
    c.setResultValue(result);
    c.setExpectValue(expect);
    return c;
  }

  /**
   * w肳ꂽ̃IuWFNgłȂǂ𔻒肵ʂԂB
   * <br>
   * IuWFNg̔r{@link java.lang.Object#equals(java.lang.Object)
   * Object.equals(Object)}\bhł͂ȂA<code>!=</code>pB
   *
   * @param  name 胁\bhB
   * @param  result lB
   * @param  expect ҒlB
   * @return 茋ʃIuWFNgB
   * @throws AssertionError 胁\bhk̏ꍇA͎lEҒl
   *           {@link ts.tester.function.CheckResult#UNSET CheckResult.UNSET}
   *           ꍇA͈̕񂪃k̏ꍇ
   *           ifobO[ĥ݁jB
   */
  private CheckResult checkNotIdentify(
    String name, Object result, Object expect)
  {
    CheckResult c;
    if (result != expect) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.NG();
    }
    c.setMethod(name);
    c.setResultValue(result);
    c.setExpectValue(expect);
    return c;
  }

  /**
   * w肳ꂽ̃IuWFNgłȂǂ𔻒肵ʂԂB
   * <br>
   * IuWFNg̔r{@link java.lang.Object#equals(java.lang.Object)
   * Object.equals(Object)}\bhł͂ȂA<code>!=</code>pB
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  name   胁\bhB
   * @param  result lB
   * @param  expect ҒlB
   * @return 茋ʃIuWFNgB
   * @throws AssertionError 胁\bhk̏ꍇA͎lEҒl
   *           {@link ts.tester.function.CheckResult#UNSET CheckResult.UNSET}
   *           ꍇA͊ms̗Rk̏ꍇ
   *           ifobO[ĥ݁jB
   */
  private CheckResult checkNotIdentify(
    String name, Object result, Object expect, String reason)
  {
    CheckResult c;
    if (result != expect) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.KnownBug();
      c.setMessage(reason);
    }
    c.setMethod(name);
    c.setResultValue(result);
    c.setExpectValue(expect);
    return c;
  }

  /**
   * w肳ꂽ̃IuWFNg̒lǂ𔻒肵ʂԂB
   *
   * @param  name   胁\bhB
   * @param  result lB
   * @param  expect ҒlB
   * @return 茋ʃIuWFNgB
   * @throws AssertionError 胁\bhk̏ꍇAlEҒl
   *           {@link ts.tester.function.CheckResult#UNSET
   *           CheckResult.UNSET}ꍇifobO[ĥ݁jB
   */
  private CheckResult checkEquals(String name, Object result, Object expect)
  {
    if (result == null || expect == null) {
      return checkIdentify(name, result, expect);
    }

    CheckResult c;
    if (result.equals(expect)) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.NG();
    }
    c.setMethod(name);
    c.setResultValue(result);
    c.setExpectValue(expect);
    return c;
  }

  /**
   * w肳ꂽ̃IuWFNg̒lǂ𔻒肵ʂԂB
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  name   胁\bhB
   * @param  result lB
   * @param  expect ҒlB
   * @return 茋ʃIuWFNgB
   * @throws AssertionError 胁\bhk̏ꍇA͎lEҒl
   *           {@link ts.tester.function.CheckResult#UNSET
   *           CheckResult.UNSET}ꍇA͊ms̗Rk̏ꍇ
   *           ifobO[ĥ݁jB
   */
  private CheckResult checkEquals(
    String name, Object result, Object expect, String reason)
  {
    if (result == null || expect == null) {
      return checkIdentify(name, result, expect, reason);
    }

    CheckResult c;
    if (result.equals(expect)) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.KnownBug();
      c.setMessage(reason);
    }
    c.setMethod(name);
    c.setResultValue(result);
    c.setExpectValue(expect);
    return c;
  }

  /**
   * w肳ꂽ̐lǂ𔻒肵ʂԂB
   *
   * @param  name   胁\bhB
   * @param  result lB
   * @param  expect ҒlB
   * @return 茋ʃIuWFNgB
   * @throws AssertionError 胁\bhk̏ꍇifobOE[ĥ݁jB
   */
  private CheckResult checkEquals(String name, int result, int expect)
  {
    return checkEquals(name, new Integer(result), new Integer(expect));
  }

  /**
   * w肳ꂽ̐lǂ𔻒肵ʂԂB
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  name   胁\bhB
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @return 茋ʃIuWFNgB
   * @throws AssertionError 胁\bhA͊ms̗Rk̏ꍇ
   *          ifobO[ĥ݁jB
   */
  private CheckResult checkEquals(
    String name, int result, int expect, String reason)
  {
    return checkEquals(name, new Integer(result), new Integer(expect), reason);
  }

  /**
   * w肳ꂽ̃IuWFNg̒lȂǂ𔻒肵ʂԂB
   *
   * @param  name   胁\bhB
   * @param  result lB
   * @param  expect ҒlB
   * @return 茋ʃIuWFNgB
   * @throws AssertionError 胁\bhk̏ꍇA͎lEҒl
   *           {@link ts.tester.function.CheckResult#UNSET
   *           CheckResult.UNSET}ꍇifobO[ĥ݁jB
   */
  private CheckResult checkNotEquals(String name, Object result, Object expect)
  {
    if (result == null || expect == null) {
      return checkNotIdentify(name, result, expect);
    }

    CheckResult c;
    if (! result.equals(expect)) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.NG();
    }
    c.setMethod(name);
    c.setResultValue(result);
    c.setExpectValue(expect);
    return c;
  }

  /**
   * w肳ꂽ̃IuWFNg̒lȂǂ𔻒肵ʂԂB
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  name   胁\bhB
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @return 茋ʃIuWFNgB
   * @throws AssertionError 胁\bhk̏ꍇA͎lEҒl
   *           {@link ts.tester.function.CheckResult#UNSET
   *           CheckResult.UNSET}ꍇA͊ms̗Rk̏ꍇ
   *           ifobO[ĥ݁jB
   */
  private CheckResult checkNotEquals(
    String name, Object result, Object expect, String reason)
  {
    if (result == null || expect == null) {
      return checkNotIdentify(name, result, expect, reason);
    }

    CheckResult c;
    if (! result.equals(expect)) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.KnownBug();
      c.setMessage(reason);
    }
    c.setMethod(name);
    c.setResultValue(result);
    c.setExpectValue(expect);
    return c;
  }

  /**
   * w肳ꂽ̃IuWFNg̒lǂ𔻒肵āǍʂ
   * P[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @throws AssertionError l͊Ғl
   *           {@link ts.tester.function.CheckResult#UNSET
   *           CheckResult.UNSET}ꍇifobO[ĥ݁jB
   */
  protected void EQUAL(Object result, Object expect)
  {
    entryCheck(checkEquals("EQUAL", result, expect));
  }

  /**
   * w肳ꂽ̃IuWFNg̒lǂ𔻒肵āǍʂ
   * P[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError l͊Ғl
   *           {@link ts.tester.function.CheckResult#UNSET
   *           CheckResult.UNSET}ꍇA͊ms̗Rk̏ꍇ
   *          ifobO[ĥ݁jB
   */
  protected void EQUAL(Object result, Object expect, String reason)
  {
    entryCheck(checkEquals("EQUAL", result, expect, reason));
  }

  /**
   * w肳ꂽ̃IuWFNg̒lȂǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @throws AssertionError l͊Ғl
   *           {@link ts.tester.function.CheckResult#UNSET CheckResult.UNSET}
   *           ꍇifobO[ĥ݁jB
   */
  protected void NOTEQUAL(Object result, Object expect)
  {
    entryCheck(checkNotEquals("NOTEQUAL", result, expect));
  }

  /**
   * w肳ꂽ̃IuWFNg̒lȂǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError l͊Ғl
   *           {@link ts.tester.function.CheckResult#UNSET CheckResult.UNSET}
   *           ꍇA͊ms̗Rk̏ꍇ
   *           ifobO[ĥ݁jB
   */
  protected void NOTEQUAL(Object result, Object expect, String reason)
  {
    entryCheck(checkNotEquals("NOTEQUAL", result, expect, reason));
  }

  /**
   * w肳ꂽ<code>boolean</code>lǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void EQUAL(boolean result, boolean expect)
  {
    Boolean b1 = (result) ? Boolean.TRUE : Boolean.FALSE;
    Boolean b2 = (expect) ? Boolean.TRUE : Boolean.FALSE;
    entryCheck(checkEquals("EQUAL", b1, b2));
  }

  /**
   * w肳ꂽ<code>boolean</code>lǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void EQUAL(boolean result, boolean expect, String reason)
  {
    Boolean b1 = (result) ? Boolean.TRUE : Boolean.FALSE;
    Boolean b2 = (expect) ? Boolean.TRUE : Boolean.FALSE;
    entryCheck(checkEquals("EQUAL", b1, b2, reason));
  }

  /**
   * w肳ꂽ<code>boolean</code>lȂǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void NOTEQUAL(boolean result, boolean expect)
  {
    Boolean b1 = (result) ? Boolean.TRUE : Boolean.FALSE;
    Boolean b2 = (expect) ? Boolean.TRUE : Boolean.FALSE;
    entryCheck(checkNotEquals("NOTEQUAL", b1, b2));
  }

  /**
   * w肳ꂽ<code>boolean</code>lȂǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void NOTEQUAL(boolean result, boolean expect, String reason)
  {
    Boolean b1 = (result) ? Boolean.TRUE : Boolean.FALSE;
    Boolean b2 = (expect) ? Boolean.TRUE : Boolean.FALSE;
    entryCheck(checkNotEquals("NOTEQUAL", b1, b2, reason));
  }

  /**
   * w肳ꂽ<code>byte</code>lǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void EQUAL(byte result, byte expect)
  {
    entryCheck(checkEquals("EQUAL", new Byte(result), new Byte(expect)));
  }

  /**
   * w肳ꂽ<code>byte</code>lǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void EQUAL(byte result, byte expect, String reason)
  {
    entryCheck(checkEquals(
      "EQUAL", new Byte(result), new Byte(expect), reason));
  }

  /**
   * w肳ꂽ<code>byte</code>lȂǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void NOTEQUAL(byte result, byte expect)
  {
    entryCheck(checkNotEquals(
      "NOTEQUAL", new Byte(result), new Byte(expect)));
  }

  /**
   * w肳ꂽ<code>byte</code>lȂǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void NOTEQUAL(byte result, byte expect, String reason)
  {
    entryCheck(checkNotEquals(
      "NOTEQUAL", new Byte(result), new Byte(expect), reason));
  }

  /**
   * w肳ꂽ<code>char</code>lǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void EQUAL(char result, char expect)
  {
    entryCheck(checkEquals(
      "EQUAL", new Character(result), new Character(expect)));
  }

  /**
   * w肳ꂽ<code>char</code>lǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void EQUAL(char result, char expect, String reason)
  {
    entryCheck(checkEquals(
      "EQUAL", new Character(result), new Character(expect), reason));
  }

  /**
   * w肳ꂽ<code>char</code>lȂǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void NOTEQUAL(char result, char expect)
  {
    entryCheck(checkNotEquals(
      "NOTEQUAL", new Character(result), new Character(expect)));
  }

  /**
   * w肳ꂽ<code>char</code>lȂǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void NOTEQUAL(char result, char expect, String reason)
  {
    entryCheck(checkNotEquals(
      "NOTEQUAL", new Character(result), new Character(expect), reason));
  }

  /**
   * w肳ꂽ<code>short</code>lǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void EQUAL(short result, short expect)
  {
    entryCheck(checkEquals(
      "EQUAL", new Short(result), new Short(expect)));
  }

  /**
   * w肳ꂽ<code>short</code>lǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void EQUAL(short result, short expect, String reason)
  {
    entryCheck(checkEquals(
      "EQUAL", new Short(result), new Short(expect), reason));
  }

  /**
   * w肳ꂽ<code>short</code>lȂǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void NOTEQUAL(short result, short expect)
  {
    entryCheck(checkNotEquals(
      "NOTEQUAL", new Short(result), new Short(expect)));
  }

  /**
   * w肳ꂽ<code>short</code>lȂǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void NOTEQUAL(short result, short expect, String reason)
  {
    entryCheck(checkNotEquals(
      "NOTEQUAL", new Short(result), new Short(expect), reason));
  }

  /**
   * w肳ꂽ<code>int</code>lǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void EQUAL(int result, int expect)
  {
    entryCheck(checkEquals(
      "EQUAL", new Integer(result), new Integer(expect)));
  }

  /**
   * w肳ꂽ<code>int</code>lǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void EQUAL(int result, int expect, String reason)
  {
    entryCheck(checkEquals(
      "EQUAL", new Integer(result), new Integer(expect), reason));
  }

  /**
   * w肳ꂽ<code>int</code>lȂǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void NOTEQUAL(int result, int expect)
  {
    entryCheck(checkNotEquals(
      "NOTEQUAL", new Integer(result), new Integer(expect)));
  }

  /**
   * w肳ꂽ<code>int</code>lȂǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void NOTEQUAL(int result, int expect, String reason)
  {
    entryCheck(checkNotEquals(
      "NOTEQUAL", new Integer(result), new Integer(expect), reason));
  }

  /**
   * w肳ꂽ<code>long</code>lǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void EQUAL(long result, long expect)
  {
    entryCheck(checkEquals(
      "EQUAL", new Long(result), new Long(expect)));
  }

  /**
   * w肳ꂽ<code>long</code>lǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void EQUAL(long result, long expect, String reason)
  {
    entryCheck(checkEquals(
      "EQUAL", new Long(result), new Long(expect), reason));
  }

  /**
   * w肳ꂽ<code>long</code>lȂǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void NOTEQUAL(long result, long expect)
  {
    entryCheck(checkNotEquals(
      "NOTEQUAL", new Long(result), new Long(expect)));
  }

  /**
   * w肳ꂽ<code>long</code>lȂǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void NOTEQUAL(long result, long expect, String reason)
  {
    entryCheck(checkNotEquals(
      "NOTEQUAL", new Long(result), new Long(expect), reason));
  }

  /**
   * w肳ꂽ<code>float</code>lǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void EQUAL(float result, float expect)
  {
    entryCheck(checkEquals(
      "EQUAL", new Float(result), new Float(expect)));
  }

  /**
   * w肳ꂽ<code>float</code>lǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void EQUAL(float result, float expect, String reason)
  {
    entryCheck(checkEquals(
      "EQUAL", new Float(result), new Float(expect), reason));
  }

  /**
   * w肳ꂽ<code>float</code>lȂǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void NOTEQUAL(float result, float expect)
  {
    entryCheck(checkNotEquals(
      "NOTEQUAL", new Float(result), new Float(expect)));
  }

  /**
   * w肳ꂽ<code>float</code>lȂǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void NOTEQUAL(float result, float expect, String reason)
  {
    entryCheck(checkNotEquals(
      "NOTEQUAL", new Float(result), new Float(expect), reason));
  }

  /**
   * w肳ꂽ<code>double</code>lǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void EQUAL(double result, double expect)
  {
    entryCheck(checkEquals(
      "EQUAL", new Double(result), new Double(expect)));
  }

  /**
   * w肳ꂽ<code>double</code>lǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void EQUAL(double result, double expect, String reason)
  {
    entryCheck(checkEquals(
      "EQUAL", new Double(result), new Double(expect), reason));
  }

  /**
   * w肳ꂽ<code>double</code>lȂǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void NOTEQUAL(double result, double expect)
  {
    entryCheck(checkNotEquals(
      "NOTEQUAL", new Double(result), new Double(expect)));
  }

  /**
   * w肳ꂽ<code>double</code>lȂǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void NOTEQUAL(double result, double expect, String reason)
  {
    entryCheck(checkNotEquals(
      "NOTEQUAL", new Double(result), new Double(expect), reason));
  }

  /**
   * w肳ꂽ̔z̃TCYvfIuWFNg̒lǂ𔻒
   * āǍʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void EQUAL(Object[] result, Object[] expect)
  {
    if (result == null || expect == null) {
      entryCheck(checkIdentify("EQUAL", result, expect));
      return;
    }

    CaseResult array = createChildCaseResult(
      "Object[]", inprocessingCaseResult_);

    CheckResult len = checkEquals("EQUAL", result.length, expect.length);
    len.setName("length");
    entryCheck(len, array);

    int n = Math.max(result.length, expect.length);
    for (int i=0; i<n; i++) {
      Object e1 = (i < result.length) ? result[i] : CheckResult.NODATA;
      Object e2 = (i < expect.length) ? expect[i] : CheckResult.NODATA;
      CheckResult c = checkEquals("EQUAL", e1, e2);
      c.setName(String.valueOf(i));
      entryCheck(c, array);
    }

    inprocessingCaseResult_.addChildResult(array);
  }

  /**
   * w肳ꂽ̔z̃TCYvfIuWFNg̒lǂ𔻒
   * āǍʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void EQUAL(Object[] result, Object[] expect, String reason)
  {
    if (result == null || expect == null) {
      entryCheck(checkIdentify("EQUAL", result, expect, reason));
      return;
    }

    CaseResult array = createChildCaseResult(
      "Object[]", inprocessingCaseResult_);

    CheckResult len = checkEquals(
      "EQUAL", result.length, expect.length, reason);
    len.setName("length");
    entryCheck(len, array);

    int n = Math.max(result.length, expect.length);
    for (int i=0; i<n; i++) {
      Object e1 = (i < result.length) ? result[i] : CheckResult.NODATA;
      Object e2 = (i < expect.length) ? expect[i] : CheckResult.NODATA;
      CheckResult c = checkEquals("EQUAL", e1, e2, reason);
      c.setName(String.valueOf(i));
      entryCheck(c, array);
    }

    inprocessingCaseResult_.addChildResult(array);
  }

  /**
   * w肳ꂽ̔z̃TCYvf<code>boolean</code>lǂ
   * 𔻒肵āǍʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void EQUAL(boolean[] result, boolean[] expect)
  {
    if (result == null || expect == null) {
      entryCheck(checkIdentify("EQUAL", result, expect));
      return;
    }

    CaseResult array = createChildCaseResult(
      "Object[]", inprocessingCaseResult_);

    CheckResult len = checkEquals("EQUAL", result.length, expect.length);
    len.setName("length");
    entryCheck(len, array);

    int n = Math.max(result.length, expect.length);
    for (int i=0; i<n; i++) {
      Object e1 = CheckResult.NODATA;
      if (i < result.length) {
        e1 = (result[i]) ? Boolean.TRUE : Boolean.FALSE;
      }
      Object e2 = CheckResult.NODATA;
      if (i < expect.length) {
        e2 = (expect[i]) ? Boolean.TRUE : Boolean.FALSE;
      }
      CheckResult c = checkEquals("EQUAL", e1, e2);
      c.setName("String.valueOf(i)");
      entryCheck(c, array);
    }

    inprocessingCaseResult_.addChildResult(array);
  }

  /**
   * w肳ꂽ̔z̃TCYvf<code>boolean</code>lǂ
   * 𔻒肵āǍʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void EQUAL(boolean[] result, boolean[] expect, String reason)
  {
    if (result == null || expect == null) {
      entryCheck(checkIdentify("EQUAL", result, expect, reason));
      return;
    }

    CaseResult array = createChildCaseResult(
      "Object[]", inprocessingCaseResult_);

    CheckResult len = checkEquals(
      "EQUAL", result.length, expect.length, reason);
    len.setName("length");
    entryCheck(len, array);

    int n = Math.max(result.length, expect.length);
    for (int i=0; i<n; i++) {
      Object e1 = CheckResult.NODATA;
      if (i < result.length) {
        e1 = (result[i]) ? Boolean.TRUE : Boolean.FALSE;
      }
      Object e2 = CheckResult.NODATA;
      if (i < expect.length) {
        e2 = (expect[i]) ? Boolean.TRUE : Boolean.FALSE;
      }
      CheckResult c = checkEquals("EQUAL", e1, e2, reason);
      c.setName(String.valueOf(i));
      entryCheck(c, array);
    }

    inprocessingCaseResult_.addChildResult(array);
  }

  /**
   * w肳ꂽ̔z̃TCYvf<code>byte</code>lǂ
   * 𔻒肵āǍʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void EQUAL(byte[] result, byte[] expect)
  {
    if (result == null || expect == null) {
      entryCheck(checkIdentify("EQUAL", result, expect));
      return;
    }

    CaseResult array = createChildCaseResult(
      "Object[]", inprocessingCaseResult_);

    CheckResult len = checkEquals("EQUAL", result.length, expect.length);
    len.setName("length");
    entryCheck(len, array);

    int n = Math.max(result.length, expect.length);
    for (int i=0; i<n; i++) {
      Object e1 = CheckResult.NODATA;
      if (i < result.length) {
        e1 = new Byte(result[i]);
      }
      Object e2 = CheckResult.NODATA;
      if (i < expect.length) {
        e2 = new Byte(expect[i]);
      }
      CheckResult c = checkEquals("EQUAL", e1, e2);
      c.setName(String.valueOf(i));
      entryCheck(c, array);
    }

    inprocessingCaseResult_.addChildResult(array);
  }

  /**
   * w肳ꂽ̔z̃TCYvf<code>byte</code>lǂ
   * 𔻒肵āǍʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void EQUAL(byte[] result, byte[] expect, String reason)
  {
    if (result == null || expect == null) {
      entryCheck(checkIdentify("EQUAL", result, expect, reason));
      return;
    }

    CaseResult array = createChildCaseResult(
      "Object[]", inprocessingCaseResult_);

    CheckResult len = checkEquals(
      "EQUAL", result.length, expect.length, reason);
    len.setName("length");
    entryCheck(len, array);

    int n = Math.max(result.length, expect.length);
    for (int i=0; i<n; i++) {
      Object e1 = CheckResult.NODATA;
      if (i < result.length) {
        e1 = new Byte(result[i]);
      }
      Object e2 = CheckResult.NODATA;
      if (i < expect.length) {
        e2 = new Byte(expect[i]);
      }
      CheckResult c = checkEquals("EQUAL", e1, e2, reason);
      c.setName(String.valueOf(i));
      entryCheck(c, array);
    }

    inprocessingCaseResult_.addChildResult(array);
  }

  /**
   * w肳ꂽ̔z̃TCYvf<code>char</code>lǂ
   * 𔻒肵āǍʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void EQUAL(char[] result, char[] expect)
  {
    if (result == null || expect == null) {
      entryCheck(checkIdentify("EQUAL", result, expect));
      return;
    }

    CaseResult array = createChildCaseResult(
      "Object[]", inprocessingCaseResult_);

    CheckResult len = checkEquals("EQUAL", result.length, expect.length);
    len.setName("length");
    entryCheck(len, array);

    int n = Math.max(result.length, expect.length);
    for (int i=0; i<n; i++) {
      Object e1 = CheckResult.NODATA;
      if (i < result.length) {
        e1 = new Character(result[i]);
      }
      Object e2 = CheckResult.NODATA;
      if (i < expect.length) {
        e2 = new Character(expect[i]);
      }
      CheckResult c = checkEquals("EQUAL", e1, e2);
      c.setName(String.valueOf(i));
      entryCheck(c, array);
    }

    inprocessingCaseResult_.addChildResult(array);
  }

  /**
   * w肳ꂽ̔z̃TCYvf<code>char</code>lǂ
   * 𔻒肵āǍʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void EQUAL(char[] result, char[] expect, String reason)
  {
    if (result == null || expect == null) {
      entryCheck(checkIdentify("EQUAL", result, expect, reason));
      return;
    }

    CaseResult array = createChildCaseResult(
      "Object[]", inprocessingCaseResult_);

    CheckResult len = checkEquals(
      "EQUAL", result.length, expect.length, reason);
    len.setName("length");
    entryCheck(len, array);

    int n = Math.max(result.length, expect.length);
    for (int i=0; i<n; i++) {
      Object e1 = CheckResult.NODATA;
      if (i < result.length) {
        e1 = new Character(result[i]);
      }
      Object e2 = CheckResult.NODATA;
      if (i < expect.length) {
        e2 = new Character(expect[i]);
      }
      CheckResult c = checkEquals("EQUAL", e1, e2, reason);
      c.setName(String.valueOf(i));
      entryCheck(c, array);
    }

    inprocessingCaseResult_.addChildResult(array);
  }

  /**
   * w肳ꂽ̔z̃TCYvf<code>short</code>lǂ
   * 𔻒肵āǍʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void EQUAL(short[] result, short[] expect)
  {
    if (result == null || expect == null) {
      entryCheck(checkIdentify("EQUAL", result, expect));
      return;
    }

    CaseResult array = createChildCaseResult(
      "Object[]", inprocessingCaseResult_);

    CheckResult len = checkEquals("EQUAL", result.length, expect.length);
    len.setName("length");
    entryCheck(len, array);

    int n = Math.max(result.length, expect.length);
    for (int i=0; i<n; i++) {
      Object e1 = CheckResult.NODATA;
      if (i < result.length) {
        e1 = new Short(result[i]);
      }
      Object e2 = CheckResult.NODATA;
      if (i < expect.length) {
        e2 = new Short(expect[i]);
      }
      CheckResult c = checkEquals("EQUAL", e1, e2);
      c.setName(String.valueOf(i));
      entryCheck(c, array);
    }

    inprocessingCaseResult_.addChildResult(array);
  }

  /**
   * w肳ꂽ̔z̃TCYvf<code>short</code>lǂ
   * 𔻒肵āǍʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void EQUAL(short[] result, short[] expect, String reason)
  {
    if (result == null || expect == null) {
      entryCheck(checkIdentify("EQUAL", result, expect, reason));
      return;
    }

    CaseResult array = createChildCaseResult(
      "Object[]", inprocessingCaseResult_);

    CheckResult len = checkEquals(
      "EQUAL", result.length, expect.length, reason);
    len.setName("length");
    entryCheck(len, array);

    int n = Math.max(result.length, expect.length);
    for (int i=0; i<n; i++) {
      Object e1 = CheckResult.NODATA;
      if (i < result.length) {
        e1 = new Short(result[i]);
      }
      Object e2 = CheckResult.NODATA;
      if (i < expect.length) {
        e2 = new Short(expect[i]);
      }
      CheckResult c = checkEquals("EQUAL", e1, e2, reason);
      c.setName(String.valueOf(i));
      entryCheck(c, array);
    }

    inprocessingCaseResult_.addChildResult(array);
  }

  /**
   * w肳ꂽ̔z̃TCYvf<code>int</code>lǂ
   * 𔻒肵āǍʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void EQUAL(int[] result, int[] expect)
  {
    if (result == null || expect == null) {
      entryCheck(checkIdentify("EQUAL", result, expect));
      return;
    }

    CaseResult array = createChildCaseResult(
      "Object[]", inprocessingCaseResult_);

    CheckResult len = checkEquals("EQUAL", result.length, expect.length);
    len.setName("length");
    entryCheck(len, array);

    int n = Math.max(result.length, expect.length);
    for (int i=0; i<n; i++) {
      Object e1 = CheckResult.NODATA;
      if (i < result.length) {
        e1 = new Integer(result[i]);
      }
      Object e2 = CheckResult.NODATA;
      if (i < expect.length) {
        e2 = new Integer(expect[i]);
      }
      CheckResult c = checkEquals("EQUAL", e1, e2);
      c.setName(String.valueOf(i));
      entryCheck(c, array);
    }

    inprocessingCaseResult_.addChildResult(array);
  }

  /**
   * w肳ꂽ̔z̃TCYvf<code>int</code>lǂ
   * 𔻒肵āǍʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void EQUAL(int[] result, int[] expect, String reason)
  {
    if (result == null || expect == null) {
      entryCheck(checkIdentify("EQUAL", result, expect, reason));
      return;
    }

    CaseResult array = createChildCaseResult(
      "Object[]", inprocessingCaseResult_);

    CheckResult len = checkEquals(
      "EQUAL", result.length, expect.length, reason);
    len.setName("length");
    entryCheck(len, array);

    int n = Math.max(result.length, expect.length);
    for (int i=0; i<n; i++) {
      Object e1 = CheckResult.NODATA;
      if (i < result.length) {
        e1 = new Integer(result[i]);
      }
      Object e2 = CheckResult.NODATA;
      if (i < expect.length) {
        e2 = new Integer(expect[i]);
      }
      CheckResult c = checkEquals("EQUAL", e1, e2, reason);
      c.setName(String.valueOf(i));
      entryCheck(c, array);
    }

    inprocessingCaseResult_.addChildResult(array);
  }

  /**
   * w肳ꂽ̔z̃TCYvf<code>long</code>lǂ
   * 𔻒肵āǍʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void EQUAL(long[] result, long[] expect)
  {
    if (result == null || expect == null) {
      entryCheck(checkIdentify("EQUAL", result, expect));
      return;
    }

    CaseResult array = createChildCaseResult(
      "Object[]", inprocessingCaseResult_);

    CheckResult len = checkEquals("EQUAL", result.length, expect.length);
    len.setName("length");
    entryCheck(len, array);

    int n = Math.max(result.length, expect.length);
    for (int i=0; i<n; i++) {
      Object e1 = CheckResult.NODATA;
      if (i < result.length) {
        e1 = new Long(result[i]);
      }
      Object e2 = CheckResult.NODATA;
      if (i < expect.length) {
        e2 = new Long(expect[i]);
      }
      CheckResult c = checkEquals("EQUAL", e1, e2);
      c.setName(String.valueOf(i));
      entryCheck(c, array);
    }

    inprocessingCaseResult_.addChildResult(array);
  }

  /**
   * w肳ꂽ̔z̃TCYvf<code>long</code>lǂ
   * 𔻒肵āǍʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void EQUAL(long[] result, long[] expect, String reason)
  {
    if (result == null || expect == null) {
      entryCheck(checkIdentify("EQUAL", result, expect, reason));
      return;
    }

    CaseResult array = createChildCaseResult(
      "Object[]", inprocessingCaseResult_);

    CheckResult len = checkEquals(
      "EQUAL", result.length, expect.length, reason);
    len.setName("length");
    entryCheck(len, array);

    int n = Math.max(result.length, expect.length);
    for (int i=0; i<n; i++) {
      Object e1 = CheckResult.NODATA;
      if (i < result.length) {
        e1 = new Long(result[i]);
      }
      Object e2 = CheckResult.NODATA;
      if (i < expect.length) {
        e2 = new Long(expect[i]);
      }
      CheckResult c = checkEquals("EQUAL", e1, e2, reason);
      c.setName(String.valueOf(i));
      entryCheck(c, array);
    }

    inprocessingCaseResult_.addChildResult(array);
  }

  /**
   * w肳ꂽ̔z̃TCYvf<code>float</code>lǂ
   * 𔻒肵āǍʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void EQUAL(float[] result, float[] expect)
  {
    if (result == null || expect == null) {
      entryCheck(checkIdentify("EQUAL", result, expect));
      return;
    }

    CaseResult array = createChildCaseResult(
      "Object[]", inprocessingCaseResult_);

    CheckResult len = checkEquals("EQUAL", result.length, expect.length);
    len.setName("length");
    entryCheck(len, array);

    int n = Math.max(result.length, expect.length);
    for (int i=0; i<n; i++) {
      Object e1 = CheckResult.NODATA;
      if (i < result.length) {
        e1 = new Float(result[i]);
      }
      Object e2 = CheckResult.NODATA;
      if (i < expect.length) {
        e2 = new Float(expect[i]);
      }
      CheckResult c = checkEquals("EQUAL", e1, e2);
      c.setName(String.valueOf(i));
      entryCheck(c, array);
    }

    inprocessingCaseResult_.addChildResult(array);
  }

  /**
   * w肳ꂽ̔z̃TCYvf<code>float</code>lǂ
   * 𔻒肵āǍʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void EQUAL(float[] result, float[] expect, String reason)
  {
    if (result == null || expect == null) {
      entryCheck(checkIdentify("EQUAL", result, expect, reason));
      return;
    }

    CaseResult array = createChildCaseResult(
      "Object[]", inprocessingCaseResult_);

    CheckResult len = checkEquals(
      "EQUAL", result.length, expect.length, reason);
    len.setName("length");
    entryCheck(len, array);

    int n = Math.max(result.length, expect.length);
    for (int i=0; i<n; i++) {
      Object e1 = CheckResult.NODATA;
      if (i < result.length) {
        e1 = new Float(result[i]);
      }
      Object e2 = CheckResult.NODATA;
      if (i < expect.length) {
        e2 = new Float(expect[i]);
      }
      CheckResult c = checkEquals("EQUAL", e1, e2, reason);
      c.setName(String.valueOf(i));
      entryCheck(c, array);
    }

    inprocessingCaseResult_.addChildResult(array);
  }

  /**
   * w肳ꂽ̔z̃TCYvf<code>double</code>lǂ
   * 𔻒肵āǍʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void EQUAL(double[] result, double[] expect)
  {
    if (result == null || expect == null) {
      entryCheck(checkIdentify("EQUAL", result, expect));
      return;
    }

    CaseResult array = createChildCaseResult(
      "Object[]", inprocessingCaseResult_);

    CheckResult len = checkEquals("EQUAL", result.length, expect.length);
    len.setName("length");
    entryCheck(len, array);

    int n = Math.max(result.length, expect.length);
    for (int i=0; i<n; i++) {
      Object e1 = CheckResult.NODATA;
      if (i < result.length) {
        e1 = new Double(result[i]);
      }
      Object e2 = CheckResult.NODATA;
      if (i < expect.length) {
        e2 = new Double(expect[i]);
      }
      CheckResult c = checkEquals("EQUAL", e1, e2);
      c.setName(String.valueOf(i));
      entryCheck(c, array);
    }

    inprocessingCaseResult_.addChildResult(array);
  }

  /**
   * w肳ꂽ̔z̃TCYvf<code>double</code>lǂ
   * 𔻒肵āǍʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void EQUAL(double[] result, double[] expect, String reason)
  {
    if (result == null || expect == null) {
      entryCheck(checkIdentify("EQUAL", result, expect, reason));
      return;
    }

    CaseResult array = createChildCaseResult(
      "Object[]", inprocessingCaseResult_);

    CheckResult len = checkEquals(
      "EQUAL", result.length, expect.length, reason);
    len.setName("length");
    entryCheck(len, array);

    int n = Math.max(result.length, expect.length);
    for (int i=0; i<n; i++) {
      Object e1 = CheckResult.NODATA;
      if (i < result.length) {
        e1 = new Double(result[i]);
      }
      Object e2 = CheckResult.NODATA;
      if (i < expect.length) {
        e2 = new Double(expect[i]);
      }
      CheckResult c = checkEquals("EQUAL", e1, e2, reason);
      c.setName(String.valueOf(i));
      entryCheck(c, array);
    }

    inprocessingCaseResult_.addChildResult(array);
  }

  /**
   * w肳ꂽ̃RNVIuWFNg̃TCYvfIuWFNg̒l
   * ǂ𔻒肵āǍʂP[XʃIuWFNgɓo^B
   * <br>
   * AAvf̊i[͖ƂȂB
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected <T> void EQUAL(Collection<T> result, Collection<T> expect)
  {
    if (result == null || expect == null) {
      entryCheck(checkIdentify("EQUAL", result, expect));
      return;
    }

    CaseResult coll = createChildCaseResult(
      "Collection", inprocessingCaseResult_);

    CheckResult size = checkEquals("EQUAL", result.size(), expect.size());
    size.setName("size");
    entryCheck(size, coll);

    int n = Math.max(result.size(), expect.size());
    ResultComparator<T> cmp = new ResultComparator<T>();

    List<T> rLst = new ArrayList<T>(n);
    List<T> eLst = new ArrayList<T>(n);
    rLst.addAll(result);
    eLst.addAll(expect);
    Collections.<T>sort(rLst, cmp);
    Collections.<T>sort(eLst, cmp);
    Iterator<T> rIt = rLst.iterator();
    Iterator<T> eIt = eLst.iterator();

    for (int i=0; i<n; i++) {
      Object e1 = CheckResult.NODATA;
      if (rIt.hasNext()) {
        e1 = rIt.next();
      }
      Object e2 = CheckResult.NODATA;
      if (eIt.hasNext()) {
        e2 = eIt.next();
      }
      CheckResult c = checkEquals("EQUAL", e1, e2);
      c.setName(String.valueOf(i));
      entryCheck(c, coll);
    }

    inprocessingCaseResult_.addChildResult(coll);
  }

  /**
   * w肳ꂽ̃RNVIuWFNg̃TCYvfIuWFNg̒l
   * ǂ𔻒肵āǍʂP[XʃIuWFNgɓo^B
   * <br>
   * AAvf̊i[͖ƂȂB
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected <T> void EQUAL(
    Collection<T> result, Collection<T> expect, String reason)
  {
    if (result == null || expect == null) {
      CheckResult c = checkIdentify("EQUAL", result, expect, reason);
      entryCheck(c);
      return;
    }

    CaseResult coll = createChildCaseResult(
      "Collection", inprocessingCaseResult_);

    CheckResult size = checkEquals(
      "EQUAL", result.size(), expect.size(), reason);
    size.setName("size");
    entryCheck(size, coll);

    int n = Math.max(result.size(), expect.size());
    ResultComparator<T> cmp = new ResultComparator<T>();

    List<T> rLst = new ArrayList<T>(result);
    List<T> eLst = new ArrayList<T>(expect);
    Collections.<T>sort(rLst, cmp);
    Collections.<T>sort(eLst, cmp);
    Iterator<T> rIt = rLst.iterator();
    Iterator<T> eIt = eLst.iterator();

    for (int i=0; i<n; i++) {
      Object e1 = CheckResult.NODATA;
      if (rIt.hasNext()) {
        e1 = rIt.next();
      }
      Object e2 = CheckResult.NODATA;
      if (eIt.hasNext()) {
        e2 = eIt.next();
      }
      CheckResult c = checkEquals("EQUAL", e1, e2, reason);
      c.setName(String.valueOf(i));
      entryCheck(c, coll);
    }

    inprocessingCaseResult_.addChildResult(coll);
  }

  /**
   * w肳ꂽ̃XgIuWFNg̃TCYvfIuWFNg̒l
   * ǂ𔻒肵āǍʂP[XʃIuWFNgɓo^B
   * <br>
   * vf̊i[vĂ邩ǂ̑ΏۂƂB
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected <T> void EQUAL(List<T> result, List<T> expect)
  {
    if (result == null || expect == null) {
      CheckResult c = checkIdentify("EQUAL", result, expect);
      entryCheck(c);
      return;
    }

    CaseResult list = createChildCaseResult(
      "List", inprocessingCaseResult_);

    CheckResult size = checkEquals("EQUAL", result.size(), expect.size());
    size.setName("size");
    entryCheck(size, list);

    int n = Math.max(result.size(), expect.size());
    Iterator<T> rIt = result.iterator();
    Iterator<T> eIt = expect.iterator();
    for (int i=0; i<n; i++) {
      Object e1 = CheckResult.NODATA;
      if (rIt.hasNext()) {
        e1 = rIt.next();
      }
      Object e2 = CheckResult.NODATA;
      if (eIt.hasNext()) {
        e2 = eIt.next();
      }
      CheckResult c = checkEquals("EQUAL", e1, e2);
      c.setName(String.valueOf(i));
      entryCheck(c, list);
    }

    inprocessingCaseResult_.addChildResult(list);
  }

  /**
   * w肳ꂽ̃XgIuWFNg̃TCYvfIuWFNg̒l
   * ǂ𔻒肵āǍʂP[XʃIuWFNgɓo^B
   * <br>
   * vf̊i[vĂ邩ǂ̑ΏۂƂB
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected <T> void EQUAL(List<T> result, List<T> expect, String reason)
  {
    if (result == null || expect == null) {
      CheckResult c = checkIdentify("EQUAL", result, expect, reason);
      entryCheck(c);
      return;
    }

    CaseResult list = createChildCaseResult(
      "List", inprocessingCaseResult_);

    CheckResult size = checkEquals(
      "EQUAL", result.size(), expect.size(), reason);
    size.setName("size");
    entryCheck(size, list);

    int n = Math.max(result.size(), expect.size());
    Iterator<T> rIt = result.iterator();
    Iterator<T> eIt = expect.iterator();
    for (int i=0; i<n; i++) {
      Object e1 = CheckResult.NODATA;
      if (rIt.hasNext()) {
        e1 = rIt.next();
      }
      Object e2 = CheckResult.NODATA;
      if (eIt.hasNext()) {
        e2 = eIt.next();
      }
      CheckResult c = checkEquals("EQUAL", e1, e2, reason);
      c.setName(String.valueOf(i));
      entryCheck(c, list);
    }

    inprocessingCaseResult_.addChildResult(list);
  }

  /**
   * w肳ꂽ̃}bvIuWFNg̃TCYvf̃L[ƒl̑Ή
   * ǂ𔻒肵āǍʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected <K,V> void EQUAL(Map<K,V> result, Map<K,V> expect)
  {
    if (result == null || expect == null) {
      CheckResult c = checkIdentify("EQUAL", result, expect);
      entryCheck(c);
      return;
    }

    CaseResult map = createChildCaseResult(
      "Map", inprocessingCaseResult_);

    CheckResult size = checkEquals("EQUAL", result.size(), expect.size());
    size.setName("size");
    entryCheck(size, map);

    Set<K> keySet = new HashSet<K>();
    keySet.addAll(result.keySet());
    keySet.addAll(expect.keySet());

    List<K> keyLst = new ArrayList<K>(keySet);
    Collections.<K>sort(keyLst, new ResultComparator<K>());

    int n = keyLst.size();
    for (int i=0; i<n; i++) {
      Object key = keyLst.get(i);

      Object e1 = CheckResult.NODATA;
      if (result.containsKey(key)) {
        e1 = result.get(key);
      }

      Object e2 = CheckResult.NODATA;
      if (expect.containsKey(key)) {
        e2 = expect.get(key);
      }

      CheckResult c = checkEquals("EQUAL", e1, e2);
      c.setName(String.valueOf(key));
      entryCheck(c, map);
    }

    inprocessingCaseResult_.addChildResult(map);
  }

  /**
   * w肳ꂽ̃}bvIuWFNg̃TCYvf̃L[ƒl̑Ή
   * ǂ𔻒肵āǍʂP[XʃIuWFNgɓo^B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected <K,V> void EQUAL(Map<K,V> result, Map<K,V> expect, String reason)
  {
    if (result == null || expect == null) {
      CheckResult c = checkIdentify("EQUAL", result, expect, reason);
      entryCheck(c);
      return;
    }

    CaseResult map = createChildCaseResult(
      "Map", inprocessingCaseResult_);

    CheckResult size = checkEquals(
      "EQUAL", result.size(), expect.size(), reason);
    size.setName("size");
    entryCheck(size, map);

    Set<K> keySet = new HashSet<K>();
    keySet.addAll(result.keySet());
    keySet.addAll(expect.keySet());

    List<K> keyLst = new ArrayList<K>(keySet);
    Collections.<K>sort(keyLst, new ResultComparator<K>());

    int n = keyLst.size();
    for (int i=0; i<n; i++) {
      Object key = keyLst.get(i);

      Object e1 = CheckResult.NODATA;
      if (result.containsKey(key)) {
        e1 = result.get(key);
      }

      Object e2 = CheckResult.NODATA;
      if (expect.containsKey(key)) {
        e2 = expect.get(key);
      }

      CheckResult c = checkEquals("EQUAL", e1, e2, reason);
      c.setName(String.valueOf(key));
      entryCheck(c, map);
    }

    inprocessingCaseResult_.addChildResult(map);
  }

  /**
   * w肳ꂽ̕rA҂vȂȂʒu܂ł𔻒茋ʂ
   * i[āAP[XʃIuWFNgɓo^B
   * <br>
   * ̍̕Ō܂ňvꍇ͔iƂB
   * vȂꂽA̎_Ŕrł؂AsiƂB
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void MATCH(String result, String expect)
  {
    if (result == null && expect == null) {
      CheckResult c = CheckResult.OK();
      c.setMethod("MATCH");
      c.setResultValue(null);
      entryCheck(c);
      return;
    }
    else if (result == null || expect == null) {
      CheckResult c = CheckResult.NG();
      c.setMethod("MATCH");
      c.setResultValue(null);
      entryCheck(c);
      return;
    }

    boolean isOK = (result.length() == expect.length()) ? true : false;

    StringBuffer buf = new StringBuffer();
    int n = Math.min(result.length(), expect.length());
    for (int i=0; i<n; i++) {
      if (result.charAt(i) != expect.charAt(i)) {
        isOK = false;
        break;
      }
      buf.append(result.charAt(i));
    }

    if (isOK) {
      CheckResult c = CheckResult.OK();
      c.setMethod("MATCH");
      c.setResultValue(buf.toString());
      entryCheck(c);
    }
    else {
      CheckResult c = CheckResult.NG();
      c.setMethod("MATCH");
      c.setResultValue(buf.toString());
      entryCheck(c);
    }
  }

  /**
   * w肳ꂽ̕rA҂vȂȂʒu܂ł𔻒茋ʂ
   * i[āAP[XʃIuWFNgɓo^B
   * <br>
   * ̍̕Ō܂ňvꍇ͔iƂB
   * vȂꂽA̎_Ŕrł؂B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void MATCH(String result, String expect, String reason)
  {
    if (result == null && expect == null) {
      CheckResult c = CheckResult.OK();
      c.setMethod("MATCH");
      c.setResultValue(null);
      entryCheck(c);
      return;
    }
    else if (result == null || expect == null) {
      CheckResult c = CheckResult.KnownBug();
      c.setMethod("MATCH");
      c.setResultValue(null);
      c.setMessage(reason);
      entryCheck(c);
      return;
    }

    boolean isOK = (result.length() == expect.length()) ? true : false;

    StringBuffer buf = new StringBuffer();
    int n = Math.min(result.length(), expect.length());
    for (int i=0; i<n; i++) {
      if (result.charAt(i) != expect.charAt(i)) {
        isOK = false;
        break;
      }
      buf.append(result.charAt(i));
    }

    if (isOK) {
      CheckResult c = CheckResult.OK();
      c.setMethod("MATCH");
      c.setResultValue(buf.toString());
      entryCheck(c);
    }
    else {
      CheckResult c = CheckResult.KnownBug();
      c.setMethod("MATCH");
      c.setName("match");
      c.setResultValue(buf.toString());
      c.setMessage(reason);
      entryCheck(c);
    }
  }

  /**
   * w肳ꂽ̕rA҂vȂȂʒu܂ł𔻒茋ʂ
   * i[āAP[XʃIuWFNgɓo^B
   * <br>
   * ̍̕Ō܂ňvꍇ͔iƂB
   * vȂꂽA̎_Ŕrł؂AsiƂB
   *
   * @param  result lB
   * @param  expect ҒlB
   */
  protected void MATCH(StringBuffer result, StringBuffer expect)
  {
    MATCH(
      (result != null) ? result.toString() : null,
      (expect != null) ? expect.toString() : null
    );
  }

  /**
   * w肳ꂽ̕rA҂vȂȂʒu܂ł𔻒茋ʂ
   * i[āAP[XʃIuWFNgɓo^B
   * <br>
   * ̍̕Ō܂ňvꍇ͔iƂB
   * vȂꂽA̎_Ŕrł؂B
   * <br>
   * 茋ʂiłȂꍇ͊msƂēo^B
   * ̕ɂ́Ams̗Rݒ肷B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void MATCH(StringBuffer result, StringBuffer expect, String reason)
  {
    MATCH(
      (result != null) ? result.toString() : null,
      (expect != null) ? expect.toString() : null,
      reason
    );
  }

  /**
   * w肳ꂽ̃IuWFNg̃IuWFNgł邩ǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @throws AssertionError l͊Ғl
   *           {@link ts.tester.function.CheckResult#UNSET CheckResult.UNSET}
   *           ꍇifobO[ĥ݁jB
   */
  protected void IDENTIFY(Object result, Object expect)
  {
    entryCheck(checkIdentify("IDENTIFY", result, expect));
  }

  /**
   * w肳ꂽ̃IuWFNg̃IuWFNgł邩ǂ𔻒肵āA
   * ̌ʂP[XʃIuWFNgɓo^B
   *
   * @param  result lB
   * @param  expect ҒlB
   * @param  reason ms̗RB
   * @throws AssertionError l͊ҒlA
   *           {@link ts.tester.function.CheckResult#UNSET CheckResult.UNSET}
   *           ꍇA͊ms̗Rk̏ꍇ
   *          ifobO[ĥ݁jB
   */
  protected void IDENTIFY(Object result, Object expect, String reason)
  {
    entryCheck(checkIdentify("IDENTIFY", result, expect, reason));
  }

  /**
   * w肳ꂽlǂ𔻒肵āǍʂP[XʃIuWFNg
   * ɓo^B
   *
   * @param  result lB
   */
  protected void POSITIVE(short result)
  {
    CheckResult c;
    if (result > 0) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.NG();
    }
    c.setMethod("POSITIVE");
    c.setResultValue(new Short(result));
    entryCheck(c);
  }

  /**
   * w肳ꂽlǂ𔻒肵āǍʂP[XʃIuWFNg
   * ɓo^B
   *
   * @param  result lB
   */
  protected void POSITIVE(int result)
  {
    CheckResult c;
    if (result > 0) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.NG();
    }
    c.setMethod("POSITIVE");
    c.setResultValue(new Integer(result));
    entryCheck(c);
  }

  /**
   * w肳ꂽlǂ𔻒肵āǍʂP[XʃIuWFNg
   * ɓo^B
   *
   * @param  result lB
   */
  protected void POSITIVE(long result)
  {
    CheckResult c;
    if (result > 0) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.NG();
    }
    c.setMethod("POSITIVE");
    c.setResultValue(new Long(result));
    entryCheck(c);
  }

  /**
   * w肳ꂽlǂ𔻒肵āǍʂP[XʃIuWFNg
   * ɓo^B
   *
   * @param  result lB
   */
  protected void POSITIVE(float result)
  {
    CheckResult c;
    if (result > 0) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.NG();
    }
    c.setMethod("POSITIVE");
    c.setResultValue(new Float(result));
    entryCheck(c);
  }

  /**
   * w肳ꂽlǂ𔻒肵āǍʂP[XʃIuWFNg
   * ɓo^B
   *
   * @param  result lB
   */
  protected void POSITIVE(double result)
  {
    CheckResult c;
    if (result > 0) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.NG();
    }
    c.setMethod("POSITIVE");
    c.setResultValue(new Double(result));
    entryCheck(c);
  }

  /**
   * w肳ꂽlǂ𔻒肵āǍʂP[XʃIuWFNg
   * ɓo^B
   *
   * @param  result lB
   */
  protected void NEGATIVE(short result)
  {
    CheckResult c;
    if (result < 0) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.NG();
    }
    c.setMethod("NEGATIVE");
    c.setResultValue(new Short(result));
    entryCheck(c);
  }

  /**
   * w肳ꂽlǂ𔻒肵āǍʂP[XʃIuWFNg
   * ɓo^B
   *
   * @param  result lB
   */
  protected void NEGATIVE(int result)
  {
    CheckResult c;
    if (result < 0) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.NG();
    }
    c.setMethod("NEGATIVE");
    c.setResultValue(new Integer(result));
    entryCheck(c);
  }

  /**
   * w肳ꂽlǂ𔻒肵āǍʂP[XʃIuWFNg
   * ɓo^B
   *
   * @param  result lB
   */
  protected void NEGATIVE(long result)
  {
    CheckResult c;
    if (result < 0) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.NG();
    }
    c.setMethod("NEGATIVE");
    c.setResultValue(new Long(result));
    entryCheck(c);
  }

  /**
   * w肳ꂽlǂ𔻒肵āǍʂP[XʃIuWFNg
   * ɓo^B
   *
   * @param  result lB
   */
  protected void NEGATIVE(float result)
  {
    CheckResult c;
    if (result < 0) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.NG();
    }
    c.setMethod("NEGATIVE");
    c.setResultValue(new Float(result));
    entryCheck(c);
  }

  /**
   * w肳ꂽlǂ𔻒肵āǍʂP[XʃIuWFNg
   * ɓo^B
   *
   * @param  result lB
   */
  protected void NEGATIVE(double result)
  {
    CheckResult c;
    if (result < 0) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.NG();
    }
    c.setMethod("NEGATIVE");
    c.setResultValue(new Double(result));
    entryCheck(c);
  }

  /**
   * w肳ꂽlǂ𔻒肵āǍʂP[XʃIuWFNg
   * ɓo^B
   *
   * @param  result lB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void POSITIVE(short result, String reason)
  {
    CheckResult c;
    if (result > 0) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.KnownBug();
      c.setMessage(reason);
    }
    c.setMethod("POSITIVE");
    c.setResultValue(new Short(result));
    entryCheck(c);
  }

  /**
   * w肳ꂽlǂ𔻒肵āǍʂP[XʃIuWFNg
   * ɓo^B
   *
   * @param  result lB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void POSITIVE(int result, String reason)
  {
    CheckResult c;
    if (result > 0) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.KnownBug();
      c.setMessage(reason);
    }
    c.setMethod("POSITIVE");
    c.setResultValue(new Integer(result));
    entryCheck(c);
  }

  /**
   * w肳ꂽlǂ𔻒肵āǍʂP[XʃIuWFNg
   * ɓo^B
   *
   * @param  result lB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void POSITIVE(long result, String reason)
  {
    CheckResult c;
    if (result > 0) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.KnownBug();
      c.setMessage(reason);
    }
    c.setMethod("POSITIVE");
    c.setResultValue(new Long(result));
    entryCheck(c);
  }

  /**
   * w肳ꂽlǂ𔻒肵āǍʂP[XʃIuWFNg
   * ɓo^B
   *
   * @param  result lB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void POSITIVE(float result, String reason)
  {
    CheckResult c;
    if (result > 0) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.KnownBug();
      c.setMessage(reason);
    }
    c.setMethod("POSITIVE");
    c.setResultValue(new Float(result));
    entryCheck(c);
  }

  /**
   * w肳ꂽlǂ𔻒肵āǍʂP[XʃIuWFNg
   * ɓo^B
   *
   * @param  result lB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void POSITIVE(double result, String reason)
  {
    CheckResult c;
    if (result > 0) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.KnownBug();
      c.setMessage(reason);
    }
    c.setMethod("POSITIVE");
    c.setResultValue(new Double(result));
    entryCheck(c);
  }

  /**
   * w肳ꂽlǂ𔻒肵āǍʂP[XʃIuWFNg
   * ɓo^B
   *
   * @param  result lB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void NEGATIVE(short result, String reason)
  {
    CheckResult c;
    if (result < 0) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.KnownBug();
      c.setMessage(reason);
    }
    c.setMethod("NEGATIVE");
    c.setResultValue(new Short(result));
    entryCheck(c);
  }

  /**
   * w肳ꂽlǂ𔻒肵āǍʂP[XʃIuWFNg
   * ɓo^B
   *
   * @param  result lB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void NEGATIVE(int result, String reason)
  {
    CheckResult c;
    if (result < 0) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.KnownBug();
      c.setMessage(reason);
    }
    c.setMethod("NEGATIVE");
    c.setResultValue(new Integer(result));
    entryCheck(c);
  }

  /**
   * w肳ꂽlǂ𔻒肵āǍʂP[XʃIuWFNg
   * ɓo^B
   *
   * @param  result lB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void NEGATIVE(long result, String reason)
  {
    CheckResult c;
    if (result < 0) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.NG();
      c.setMessage(reason);
    }
    c.setMethod("NEGATIVE");
    c.setResultValue(new Long(result));
    entryCheck(c);
  }

  /**
   * w肳ꂽlǂ𔻒肵āǍʂP[XʃIuWFNg
   * ɓo^B
   *
   * @param  result lB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void NEGATIVE(float result, String reason)
  {
    CheckResult c;
    if (result < 0) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.NG();
      c.setMessage(reason);
    }
    c.setMethod("NEGATIVE");
    c.setResultValue(new Float(result));
    entryCheck(c);
  }

  /**
   * w肳ꂽlǂ𔻒肵āǍʂP[XʃIuWFNg
   * ɓo^B
   *
   * @param  result lB
   * @param  reason ms̗RB
   * @throws AssertionError ms̗Rk̏ꍇifobO[ĥ݁jB
   */
  protected void NEGATIVE(double result, String reason)
  {
    CheckResult c;
    if (result < 0) {
      c = CheckResult.OK();
    }
    else {
      c = CheckResult.NG();
      c.setMessage(reason);
    }
    c.setMethod("NEGATIVE");
    c.setResultValue(new Double(result));
    entryCheck(c);
  }

  /* -- inner class -- */

  /**
   * ̒fɃX[ONXB
   */
  private class TestStoppedException extends RuntimeException
  {
    /** VAo[WIDB */
    static final long serialVersionUID = 3833601781206791512L;

    /**
     * ftHgRXgN^B
     */
    public TestStoppedException()
    {}

    /**
     * ObZ[WɂƂRXgN^B
     *
     * @param  msg ObZ[WB
     */
    public TestStoppedException(String msg)
    {
      super(msg);
    }
  }

  /**
   * IuWFNg̕ёւɎgp{@link java.util.Comparator Comparator}
   * ̔hNXB
   * <br>
   * IuWFNg̃NXAnbVlAl
   * {@link java.lang.Object#toString() toString}̌)gĕёւ
   * sB
   * <br>
   * AIuWFNg̒lk̏ꍇ́ÃIuWFNgɔzuB
   */
  private class ResultComparator<T> implements Comparator<T>
  {
    /**
     * ftHgRXgN^B
     */
    ResultComparator()
    {}

    /**
     * ̃IuWFNg̑召rB
     *
     * @param  o1 rΏۂƂȂIuWFNg1B
     * @param  o2 rΏۂƂȂIuWFNg2B
     * @return <tt>o1</tt><tt>o2</tt>ƔrāAꍇ͕̒lA
     *           傫ꍇ͐̒lAꍇ̓[ԂB
     */
    public int compare(T o1, T o2)
    {
      if (o1 == null) {
        if (o2 == null) {
          return 0;
        }
        else {
          return 1;
        }
      }
      else if (o2 == null) {
        return -1;
      }

      int ret0 = o1.getClass().getName().compareTo(o2.getClass().getName());
      if (ret0 != 0) {
        return ret0;
      }

      int ret1 = (o1.hashCode() - o2.hashCode());
      if (ret1 != 0) {
        return ret1;
      }

      return (o1.toString().compareTo(o2.toString()));
    }
  }
}
