/*
 * ConsolePrinterBase class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.print;

import ts.tester.function.Result;
import ts.tester.function.ResultType;
import ts.tester.function.CaseResult;
import ts.tester.function.CheckResult;
import java.io.PrintWriter;
import java.lang.reflect.Method;

/**
 * ʂR\[o͂{@link ts.tester.function.print.Printer Printer} 
 * NX̔hNXB
 *
 * @author  V. 
 * @version $Revision: 1.3 $, $Date: 2007/10/08 16:11:08 $
 */
public class ConsolePrinterBase extends AbstractPrinter
{
  /** o̓IuWFNgB */
  private PrintWriter writer_ ;

  /**
   * ftHgRXgN^B
   */
  public ConsolePrinterBase()
  {
    writer_ = new PrintWriter(System.out);
  }

  /**
   * o̓IuWFNgɂƂRXgN^B 
   *
   * @param  writer o̓IuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public ConsolePrinterBase(PrintWriter writer)
  {
    assert (writer != null) : "@param:writer is null";

    writer_ = writer;
  }

  /**
   * o̓IuWFNg擾B
   *
   * @return o̓IuWFNgB
   */
  protected PrintWriter writer()
  {
    return writer_ ;
  }

  /**
   * w肳ꂽO̎P[X茋ʃIuWFNg쐬B
   * <br>
   * ʂ{@link ts.tester.function.Result Result}IuWFNg󂯎
   * ɁA̓eR\[o͂āAsiȂǂWv鎎P[X茋
   * IuWFNg쐬B
   *
   * @param  name P[XB
   * @param  parent e̎P[X茋ʃIuWFNgB
   * @return P[X茋ʃIuWFNgB
   * @throws AssertionError Ƀkw肳ꂽꍇifobO[ĥ݁jB
   */
  public CaseResult createCaseResult(String name, CaseResult parent)
  {
    return new _CaseResult(name, parent);
  }

  /**
   * Ŝ̊JnɌĂяo郁\bhB
   *
   * @param  root ŏʂ̎P[X茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇB͈
   *           {@link ts.tester.function.print.ConsolePrinterBase
   *           ConsolePrinterBase}
   *           NXpɒ`ꂽP[X茋ʃNX̃CX^X
   *           ȂꍇifobO[ĥ݁jB
   */
  @Override public void testStarted(CaseResult root)
  {
    assert (root != null) : "@param:root is null.";
    assert (root instanceof _CaseResult) :
      "@param:root is an instance of unsupported CaseResult class.";

    _CaseResult result = (_CaseResult) root;
    result.printAsTestStarted();
  }

  /**
   * ̏IɌĂяo郁\bhB
   *
   * @param  root ŏʂ̎P[X茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇB͈
   *           {@link ts.tester.function.print.ConsolePrinterBase
   *           ConsolePrinterBase}
   *           NXpɒ`ꂽP[X茋ʃNX̃CX^X
   *           ȂꍇifobO[ĥ݁jB
   */
  @Override public void testEnded(CaseResult root)
  {
    assert (root != null) : "@param:root is null.";
    assert (root instanceof _CaseResult) :
      "@param:root is an instance of unsupported CaseResult class.";

    _CaseResult result = (_CaseResult) root;
    result.printAsTestEnded();
  }

  /**
   * P[X̊JnɌĂяo郁\bhB
   *
   * @param  current Jn鎎P[X̔茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇB͈
   *           {@link ts.tester.function.print.ConsolePrinterBase
   *           ConsolePrinterBase}
   *           NXpɒ`ꂽP[X茋ʃNX̃CX^X
   *           ȂꍇifobO[ĥ݁jB
   */
  @Override public void caseStarted(CaseResult current)
  {
    assert (current != null) : "@param:current is null.";
    assert (current instanceof _CaseResult) :
      "@param:current is an instance of unsupported CaseResult class.";

    _CaseResult result = (_CaseResult) current;
    result.printAsCaseStarted();
  }

  /**
   * P[X̏IɌĂяo郁\bhB
   *
   * @param  current IP[X̔茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇB͈
   *           {@link ts.tester.function.print.ConsolePrinterBase
   *           ConsolePrinterBase}
   *           NXpɒ`ꂽP[X茋ʃNX̃CX^X
   *           ȂꍇifobO[ĥ݁jB
   */
  @Override public void caseEnded(CaseResult current)
  {
    assert (current != null) : "@param:current is null.";
    assert (current instanceof _CaseResult) :
      "@param:current is an instance of unsupported CaseResult class.";

    _CaseResult result = (_CaseResult) current;
    result.printAsCaseEnded();
  }

  /**
   * 肪sꂽɌĂяo郁\bhB
   *
   * @param  check sꂽ{@link ts.tester.function.CheckResult CheckResult}
   *           IuWFNgB
   * @param  current ݎs̎P[X̔茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇB<tt>current</tt>
   *           {@link ts.tester.function.print.ConsolePrinterBase
   *           ConsolePrinterBase}
   *           NXpɒ`ꂽP[X茋ʃNX̃CX^X
   *           ȂꍇifobO[ĥ݁jB
   */
  @Override public void checkOccured(CheckResult check, CaseResult current)
  {
    assert (check != null) : "@param:check is null.";
    assert (current != null) : "@param:current is null.";
    assert (current instanceof _CaseResult) :
      "@param:current is an instance of unsupported CaseResult class.";

    _CaseResult result = (_CaseResult) current;
    result.printCheck(check);
  }

  /**
   * bZ[W̓o^ꍇɌĂяo郁\bhB
   *
   * @param  message o^郁bZ[WB
   * @param  current ݎs̎P[X̔茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇB<tt>current</tt>
   *           {@link ts.tester.function.print.ConsolePrinterBase
   *           ConsolePrinterBase}
   *           NXpɒ`ꂽP[X茋ʃNX̃CX^X
   *           ȂꍇifobO[ĥ݁jB
   */
  @Override public void messageNoted(String message, CaseResult current)
  {
    assert (message != null) : "@param:message is null.";
    assert (current != null) : "@param:current is null.";
    assert (current instanceof _CaseResult) :
      "@param:current is an instance of unsupported CaseResult class.";

    _CaseResult result = (_CaseResult) current;
    result.printMessage(message);
  }

  /* -- inner class -- */

  /**
   * {@link ts.tester.function.print.ConsolePrinterBase
   * ConsolePrinterBase}p̎P[X茋ʃNXB
   * <br>
   * ʂ{@link ts.tester.function.Result Result}IuWFNg󂯎
   * ɁA̓eR\[o͂āAsiȂǂWvB
   */
  private class _CaseResult extends CaseResult
  {
    /** P[X̊KwB */
    private int level_ ;

    /** e茋ʃ^Cv̏Wvli[zB */
    private int[] countByResultType_ = new int[ ResultType.values().length ];

    /**
     * P[XƐe̎P[X茋ʃIuWFNgɂƂ
     * RXgN^B
     *
     * @param  name P[XB
     * @param  parent e̎P[X茋ʃIuWFNgB
     * @throws AssertionError k̏ꍇifobO[ĥ݁jB
     */
    _CaseResult(String name, CaseResult parent)
    {
      super(name, parent);

      if (parent instanceof _CaseResult) {
        this.level_ = ((_CaseResult) parent).getLevel() + 1;
      }
      else {
        this.level_ = 0;
      }
    }

    /**
     * P[X̊Kw擾B
     *
     * @return P[X̊KwB
     */
    private int getLevel()
    {
      return level_ ;
    }

    /**
     * w肳ꂽʃ^Cv̌ʐ擾B
     *
     * @param  type ʃ^CvB
     * @return 茋ʐB
     * @throws AssertionError k̏ꍇifobO[ĥ݁jB
     */
    @Override public int count(ResultType type)
    {
      assert (type != null) : "@param:type is null.";

      return countByResultType_[type.ordinal()];
    }

    /**
     * w肳ꂽ茋ʃIuWFNg̕sȂǂZB
     *
     * @param  result 茋ʃIuWFNgB
     * @throws AssertionError k̏ꍇifobO[ĥ݁jB
     */
    @Override public void addChildResult(Result result)
    {
      assert (result != null) : "@param:result is null.";

      for (ResultType type : ResultType.values()) {
        countByResultType_[type.ordinal()] += result.count(type);
      }
    }

    /**
     * Jnɏo͂s\bhB
     */
    private void printAsTestStarted()
    {
      StringBuffer buf = new StringBuffer();
      if (getLevel() > 0) {
        for (int i=1; i<getLevel(); i++) {
          buf.append("b ");
        }
        buf.append(" ");
      }
      buf.append(getName());

      writer().println(buf.toString());
      writer().flush();
    }

    /**
     * Iɏo͂s\bhB
     */
    private void printAsTestEnded()
    {
      int ng = count(ResultType.NG);
      int kb = count(ResultType.KnownBug);
      int em = count(ResultType.Empty);
      int in = count(ResultType.Incomplete);

      if (ng > 0) {
        writer().println("xxxxxxxxxx " + ng + " NGs exist. xxxxxxxxxx");
        writer().println("(T_T)(T_T)(T_T)(T_T)(T_T)(T_T)(T_T)");
      }
      else {
        writer().println("=============== OK! ===============");
        writer().println("(^o^)(^o^)(^o^)(^o^)(^o^)(^o^)(^o^)");
      }

      if (kb > 0) {
        writer().println("... and " + kb + " known bugs exist.");
      }
      if (em > 0) {
        writer().println("... and " + em + " empty cases exist.");
      }
      if (in > 0) {
        writer().println("... and " + in + " incomplete cases exist.");
      }

      writer().flush();
    }

    /**
     * P[XJnɏo͂s\bhB
     */
    private void printAsCaseStarted()
    {
      StringBuffer buf = new StringBuffer();
      if (getLevel() > 0) {
        for (int i=1; i<getLevel(); i++) {
          buf.append(" ");
        }
        buf.append(" ");
      }
      buf.append(getName());

      writer().println(buf.toString());
      writer().flush();
    }

    /**
     * P[XIɏo͂s\bhB
     */
    private void printAsCaseEnded()
    {
      StringBuffer buf = new StringBuffer();
      if (getLevel() > 0) {
        for (int i=1; i<getLevel(); i++) {
          buf.append(" ");
        }
        buf.append(" ");
      }

      buf.append("< ");
      if (count(ResultType.Empty) > 0) {
        buf.append("*EMPTY*");
      }
      else {
        buf.append("NG:").append(count(ResultType.NG));
        buf.append(", Known bug:").append(count(ResultType.KnownBug));

        if (count(ResultType.Incomplete) > 0) {
          buf.append(", *INCOMPLETE*");
        }
      }
      buf.append(" >");

      writer().println(buf.toString());
      writer().flush();
    }

    /**
     * 茋ʂo͂郁\bhB
     *
     * @param  check 茋ʃIuWFNgB
     */
    private void printCheck(CheckResult check)
    {
      StringBuffer buf = new StringBuffer();
      for (int i=0; i<getLevel(); i++) {
        buf.append(" ");
      }
      buf.append(" ");

      if  (check.getMethod().length() > 0) {
        buf.append("[").append(check.getMethod()).append("] ");
      }
      if  (check.getName().length() > 0) {
        buf.append(check.getName()).append(" ");
      }

      if (check.getResultValue() == CheckResult.UNSET) {
        // none.
      }
      else if (check.getExpectValue() == CheckResult.UNSET) {
        buf.append("result: ").append(check.getResultValue());
      }
      else {
        buf.append("result: ").append(check.getResultValue());
        buf.append(" / expect: ").append(check.getExpectValue());
      }

      if (check.is(ResultType.NG)) {
        buf.append(" ... NG");
        buf.append(" (line:").append(check.getLineNumber()).append(")");
      }
      else if (check.is(ResultType.KnownBug)) {
        buf.append(" ... known bug");
        buf.append(" (line:").append(check.getLineNumber()).append(")");
      }
      else if (check.is(ResultType.Incomplete)) {
        buf.append(" ... incomplete");
        buf.append(" (line:").append(check.getLineNumber()).append(")");
      }
      else if (check.is(ResultType.Empty)) {
        return;
      }
      else {
        buf.append(" ... OK");
      }

      if  (check.getMessage().length() > 0) {
        buf.append(" ").append(check.getMessage());
      }

      writer().println(buf.toString());
      writer().flush();
    }

    /**
     * bZ[Wo͂郁\bhB
     *
     * @param  message bZ[WB
     */
    private void printMessage(String message)
    {
      StringBuffer buf = new StringBuffer();
      for (int i=0; i<getLevel(); i++) {
        buf.append(" ");
      }
      buf.append(" ").append(message);

      writer().println(buf.toString());
      writer().flush();
    }
  }
}
