/*
 * PrinterGroupTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.print;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.tester.coverage.*;
import com.sun.jdi.*;
import java.util.*;

/**
 * <code>PrinterGroup</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.3 $, $Date: 2007/05/07 15:20:00 $
 */
public class PrinterGroupTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      group.addPrinter(new ConsolePrinter());
      setPrinter(group);

      run(PrinterGroupTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("PrinterGroupNX̋@\sB");
  }

  StringBuffer log_ = null;

  protected void preInvocation(String method)
  {
    log_ = new StringBuffer();
  }

  /* -- inner class -- */

  class CoveragePrinterEx extends ConsolePrinter
  {
    String name_ = "";
    CoveragePrinterEx(String name) {
      name_ = name;
    }
    public void prepareCoverage(Coverage coverage) {
      log_.append("prepareCoverage(" + name_ + ")|");
    }
    public void postCoverage(Coverage coverage) {
      log_.append("postCoverage(" + name_ + ")|");
    }
    public void entryClass(ReferenceType refType) {
      log_.append("entryClass(" + name_ + ")|");
    }
    public void entryLine(Location location) {
      log_.append("entryLine(" + name_ + ")|");
    }
    public void entryMethod(Method method) {
      log_.append("entryMethod(" + name_ + ")|");
    }
    public void exitMethod(Method method) {
      log_.append("exitMethod(" + name_ + ")|");
    }
    public void passLine(Location location) {
      log_.append("passLine(" + name_ + ")|");
    }
  }

  class ReferenceTypeEx implements ReferenceType {
    List<String> sourcePathLst_ = new LinkedList<String>();
    public String name() { return ""; }
    public String genericSignature() { return ""; }
    public ClassLoaderReference classLoader() { return null; }
    public String sourceName() throws AbsentInformationException
    { return null; }
    public List<String> sourceNames(String s)
    throws AbsentInformationException { return null; }
    public List<String> sourcePaths(String s)
    throws AbsentInformationException { return sourcePathLst_; }
    public String sourceDebugExtension() throws AbsentInformationException
    { return null; }
    public boolean isStatic() { return true; }
    public boolean isAbstract() { return true; }
    public boolean isFinal() { return true; }
    public boolean isPrepared() { return true; }
    public boolean isVerified() { return true; }
    public boolean isInitialized() { return true; }
    public boolean failedToInitialize() { return true; }
    public List<Field> fields() { return null; }
    public List<Field> visibleFields() { return null; }
    public List<Field> allFields() { return null; }
    public Field fieldByName(String s) { return null; }
    public List<Method> methods() { return null; }
    public List<Method> visibleMethods() { return null; }
    public List<Method> allMethods() { return null; }
    public List<Method> methodsByName(String s) { return null; }
    public List<Method> methodsByName(String s, String t) { return null; }
    public List<ReferenceType> nestedTypes() { return null; }
    public Value getValue(Field f) { return null; }
    public Map<Field, Value> getValues(List l) { return null; }
    public ClassObjectReference classObject() { return null; }
    public List<Location> allLineLocations() throws AbsentInformationException
    { return null; }
    public List<Location> allLineLocations(String s, String t)
    throws AbsentInformationException { return null; }
    public List<Location> locationsOfLine(int n)
    throws AbsentInformationException { return null; }
    public List<Location> locationsOfLine(String s, String t, int n)
    throws AbsentInformationException { return null; }
    public List<String> availableStrata() { return null; }
    public String defaultStratum() { return null; }
    public boolean equals(Object o) { return true; }
    public int hashCode() { return 0; }
    public String signature() { return ""; }
    public VirtualMachine virtualMachine() { return null; }
    public int compareTo(ReferenceType r) { return 0; }
    public int modifiers() { return 0; }
    public boolean isPrivate() { return false; }
    public boolean isPackagePrivate() { return false; }
    public boolean isProtected() { return false; }
    public boolean isPublic() { return false; }
    // for JDK1.6
    public List<ObjectReference> instances(long v) { return null; }
    public int majorVersion() { return 0; }
    public int minorVersion() { return 0; }
    public int constantPoolCount() { return 0; }
    public byte[] constantPool() { return new byte[0]; }
  }

  class MethodEx implements Method
  {
    public String returnTypeName() { return ""; }
    public Type returnType() throws ClassNotLoadedException { return null; }
    public List<String> argumentTypeNames() { return null; }
    public List<Type> argumentTypes() throws ClassNotLoadedException
    { return null; }
    public boolean isAbstract() { return false; }
    public boolean isSynchronized() { return false; }
    public boolean isNative() { return false; }
    public boolean isVarArgs() { return false; }
    public boolean isBridge() { return false; }
    public boolean isConstructor() { return false; }
    public boolean isStaticInitializer() { return false; }
    public boolean isObsolete() { return false; }
    public List<Location> allLineLocations() throws AbsentInformationException
    { return null; }
    public List<Location> allLineLocations(String s1, String s2)
    throws AbsentInformationException { return null; }
    public List<Location> locationsOfLine(int n)
    throws AbsentInformationException { return null; }
    public List<Location> locationsOfLine(String s1, String s2, int n)
    throws AbsentInformationException { return null; }
    public Location locationOfCodeIndex(long n) { return null; }
    public List<LocalVariable> variables() throws AbsentInformationException
    { return null; }
    public List<LocalVariable> variablesByName(String s)
    throws AbsentInformationException { return null; }
    public List<LocalVariable> arguments() throws AbsentInformationException
    { return null; }
    public byte[] bytecodes() { return null; }
    public Location location() { return null; }
    public boolean equals(Object o) { return false; }
    public int hashCode() { return 0; }
    public int compareTo(Method o) { return 0; }
    public String name() { return ""; }
    public String signature() { return ""; }
    public String genericSignature() { return ""; }
    public ReferenceType declaringType() { return null; }
    public boolean isStatic() { return false; }
    public boolean isFinal() { return false; }
    public boolean isSynthetic() { return false; }
    public VirtualMachine virtualMachine() { return null; }
    public boolean isPublic() { return false; }
    public boolean isProtected() { return false; }
    public boolean isPackagePrivate() { return false; }
    public boolean isPrivate() { return false; }
    public int modifiers() { return 0; }
  }

  class LocationEx implements Location 
  {
    public ReferenceType declaringType() { return null; }
    public Method method() { return null; }
    public long codeIndex() { return 0L; }
    public String sourceName() throws AbsentInformationException { return ""; }
    public String sourceName(String name) throws AbsentInformationException
    { return ""; }
    public String sourcePath() throws AbsentInformationException { return ""; }
    public String sourcePath(String name) throws AbsentInformationException
    { return ""; }
    public int lineNumber() { return 0; }
    public int lineNumber(String s) { return 0; }
    public boolean equals(Object o) { return false; }
    public int hashCode() { return 0; }
    public int compareTo(Location o) { return 0; }
    public VirtualMachine virtualMachine() { return null; }
    public String toString() { return ""; }
  }

  /* -- test case -- */

  public void constructor()
  {
    MSG("ftHgRXgN^̊mFB");

    PrinterGroup printer = new PrinterGroup();
    TRUE(printer instanceof Printer);
    TRUE(printer instanceof PrinterGroupBase);
  }

  public void prepareCoverage()
  {
    LineCoverage cov = new LineCoverage(this.getClass());

    PrinterGroup printer = new PrinterGroup();
    printer.addPrinter(new CoveragePrinterEx("aaa"));
    printer.addPrinter(new CoveragePrinterEx("bbb"));
    printer.prepareCoverage(cov);

    EQUAL(log_.toString(), "prepareCoverage(aaa)|prepareCoverage(bbb)|");
  }

  public void prepareCoverage_0()
  {
    MSG("k̏ꍇB");

    PrinterGroup printer = new PrinterGroup();
    try {
      printer.prepareCoverage(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void postCoverage()
  {
    LineCoverage cov = new LineCoverage(this.getClass());

    PrinterGroup printer = new PrinterGroup();
    printer.addPrinter(new CoveragePrinterEx("aaa"));
    printer.addPrinter(new CoveragePrinterEx("bbb"));
    printer.postCoverage(cov);

    EQUAL(log_.toString(), "postCoverage(aaa)|postCoverage(bbb)|");
  }

  public void postCoverage_0()
  {
    MSG("k̏ꍇB");

    PrinterGroup printer = new PrinterGroup();
    try {
      printer.postCoverage(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void entryClass()
  {
    LineCoverage cov = new LineCoverage(this.getClass());

    PrinterGroup printer = new PrinterGroup();
    printer.addPrinter(new CoveragePrinterEx("aaa"));
    printer.addPrinter(new CoveragePrinterEx("bbb"));
    printer.entryClass(new ReferenceTypeEx());

    EQUAL(log_.toString(), "entryClass(aaa)|entryClass(bbb)|");
  }

  public void entryClass_0()
  {
    MSG("k̏ꍇB");

    PrinterGroup printer = new PrinterGroup();
    try {
      printer.entryClass(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void entryLine()
  {
    LineCoverage cov = new LineCoverage(this.getClass());

    PrinterGroup printer = new PrinterGroup();
    printer.addPrinter(new CoveragePrinterEx("aaa"));
    printer.addPrinter(new CoveragePrinterEx("bbb"));
    printer.entryLine(new LocationEx());

    EQUAL(log_.toString(), "entryLine(aaa)|entryLine(bbb)|");
  }

  public void entryLine_0()
  {
    MSG("k̏ꍇB");

    PrinterGroup printer = new PrinterGroup();
    try {
      printer.entryLine(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void entryMethod()
  {
    LineCoverage cov = new LineCoverage(this.getClass());

    PrinterGroup printer = new PrinterGroup();
    printer.addPrinter(new CoveragePrinterEx("aaa"));
    printer.addPrinter(new CoveragePrinterEx("bbb"));
    printer.entryMethod(new MethodEx());

    EQUAL(log_.toString(), "entryMethod(aaa)|entryMethod(bbb)|");
  }

  public void entryMethod_0()
  {
    MSG("k̏ꍇB");

    PrinterGroup printer = new PrinterGroup();
    try {
      printer.entryMethod(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void exitMethod()
  {
    LineCoverage cov = new LineCoverage(this.getClass());

    PrinterGroup printer = new PrinterGroup();
    printer.addPrinter(new CoveragePrinterEx("aaa"));
    printer.addPrinter(new CoveragePrinterEx("bbb"));
    printer.exitMethod(new MethodEx());

    EQUAL(log_.toString(), "exitMethod(aaa)|exitMethod(bbb)|");
  }

  public void exitMethod_0()
  {
    MSG("k̏ꍇB");

    PrinterGroup printer = new PrinterGroup();
    try {
      printer.exitMethod(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void passLine()
  {
    LineCoverage cov = new LineCoverage(this.getClass());

    PrinterGroup printer = new PrinterGroup();
    printer.addPrinter(new CoveragePrinterEx("aaa"));
    printer.addPrinter(new CoveragePrinterEx("bbb"));
    printer.passLine(new LocationEx());

    EQUAL(log_.toString(), "passLine(aaa)|passLine(bbb)|");
  }

  public void passLine_0()
  {
    MSG("k̏ꍇB");

    PrinterGroup printer = new PrinterGroup();
    try {
      printer.passLine(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }
}
