/*
 * PrinterGroup class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.print;

import ts.tester.coverage.Coverage;
import ts.tester.coverage.CoveragePrinter;
import ts.tester.coverage.LineCoverage;
import ts.tester.coverage.Result;
import ts.tester.coverage.CoveragePrinter;
import ts.tester.function.print.Printer;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Method;
import com.sun.jdi.Location;

/**
 * JobWvʂo͂ł悤Ɋgʏo̓O[vNXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:52 $
 */
public class PrinterGroup extends PrinterGroupBase
  implements CoveragePrinter
{
  /**
   * ftHgRXgN^B
   */
  public PrinterGroup()
  {}

  /**
   * JobWv̏sB
   *
   * @param  coverage JobWvIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void prepareCoverage(Coverage coverage)
  {
    assert (coverage != null) : "@param:coverage is null.";

    for (Printer p : printerList()) {
      if (p instanceof CoveragePrinter) {
        CoveragePrinter cp = (CoveragePrinter) p;
        cp.prepareCoverage(coverage);
      }
    }
  }

  /**
   * JobWv̌㏈sB
   *
   * @param  coverage JobWvIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void postCoverage(Coverage coverage)
  {
    assert (coverage != null) : "@param:coverage is null.";

    for (Printer p : printerList()) {
      if (p instanceof CoveragePrinter) {
        CoveragePrinter cp = (CoveragePrinter) p;
        cp.postCoverage(coverage);
      }
    }
  }

  /**
   * NX̓o^ɌĂяo郁\bhB
   *
   * @param  refType o^ꂽNX̓C^[tFCX
   *           {@link com.sun.jdi.ReferenceType ReferenceType}IuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void entryClass(ReferenceType refType)
  {
    assert (refType != null) : "@param:refType is null.";

    for (Printer p : printerList()) {
      if (p instanceof CoveragePrinter) {
        CoveragePrinter cp = (CoveragePrinter) p;
        cp.entryClass(refType);
      }
    }
  }

  /**
   * s̓o^ɌĂяo郁\bhB
   *
   * @param  location o^ꂽs{@link com.sun.jdi.Location Location}
   *           IuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void entryLine(Location location)
  {
    assert (location != null) : "@param:location is null.";

    for (Printer p : printerList()) {
      if (p instanceof CoveragePrinter) {
        CoveragePrinter cp = (CoveragePrinter) p;
        cp.entryLine(location);
      }
    }
  }

  /**
   * \bhĂяoɌĂяo郁\bhB
   *
   * @param  method Ăяoꂽ\bh{@link com.sun.jdi.Method Method}
   *           IuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void entryMethod(Method method)
  {
    assert (method != null) : "@param:method is null.";

    for (Printer p : printerList()) {
      if (p instanceof CoveragePrinter) {
        CoveragePrinter cp = (CoveragePrinter) p;
        cp.entryMethod(method);
      }
    }
  }

  /**
   * \bhIɌĂяo郁\bhB
   *
   * @param  method I\bh{@link com.sun.jdi.Method Method}
   *           IuWFNgB
   */
  public void exitMethod(Method method)
  {
    assert (method != null) : "@param:method is null.";

    for (Printer p : printerList()) {
      if (p instanceof CoveragePrinter) {
        CoveragePrinter cp = (CoveragePrinter) p;
        cp.exitMethod(method);
      }
    }
  }

  /**
   * s̒ʉߎɌĂяo郁\bhB
   *
   * @param  location ʉ߂s{@link com.sun.jdi.Location Location}
   *           IuWFNgB
   */
  public void passLine(Location location)
  {
    assert (location != null) : "@param:location is null.";

    for (Printer p : printerList()) {
      if (p instanceof CoveragePrinter) {
        CoveragePrinter cp = (CoveragePrinter) p;
        cp.passLine(location);
      }
    }
  }
}
