/*
 * Decompiled with CFR 0.152.
 */
package ts.util.table;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ts.util.table.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Record<C, V>
implements Map<C, V>,
Serializable {
    protected abstract Header<C> header();

    @Override
    public int size() {
        return this.header().columnCount();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.header().hasColumn(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.values().contains(object);
    }

    @Override
    public V get(Object object) {
        if (!this.header().hasColumn(object)) {
            return null;
        }
        return this.getValue(object);
    }

    @Override
    public V put(C c, V v) {
        this.header().addColumn(c);
        return this.putValue(c, v);
    }

    @Override
    public V remove(Object object) {
        if (!this.header().hasColumn(object)) {
            this.removeValue(object);
            return null;
        }
        return this.removeValue(object);
    }

    @Override
    public void putAll(Map<? extends C, ? extends V> map) {
        for (Map.Entry<C, V> entry : map.entrySet()) {
            this.header().addColumn(entry.getKey());
            this.putValue(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        for (C c : this.keySet()) {
            this.removeValue(c);
        }
    }

    @Override
    public Set<C> keySet() {
        return new AbstractSet<C>(){

            @Override
            public Iterator<C> iterator() {
                return new Iterator<C>(){
                    private Enumeration<C> it_;
                    private Object column_;
                    {
                        this.it_ = Record.this.header().columns();
                        this.column_ = this;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it_.hasMoreElements();
                    }

                    @Override
                    public C next() {
                        Object c = this.it_.nextElement();
                        this.column_ = c;
                        return c;
                    }

                    @Override
                    public void remove() {
                        Record.this.remove(this.column_);
                    }
                };
            }

            @Override
            public int size() {
                return Record.this.header().columnCount();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private Enumeration<C> it_;
                    private Object column_;
                    {
                        this.it_ = Record.this.header().columns();
                        this.column_ = this;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it_.hasMoreElements();
                    }

                    @Override
                    public V next() {
                        Object c = this.it_.nextElement();
                        this.column_ = c;
                        return Record.this.getValue(c);
                    }

                    @Override
                    public void remove() {
                        Record.this.remove(this.column_);
                    }
                };
            }

            @Override
            public int size() {
                return Record.this.header().columnCount();
            }
        };
    }

    @Override
    public Set<Map.Entry<C, V>> entrySet() {
        return new AbstractSet<Map.Entry<C, V>>(){

            @Override
            public Iterator<Map.Entry<C, V>> iterator() {
                return new Iterator<Map.Entry<C, V>>(){
                    private Enumeration<C> it_;
                    private Object column_;
                    {
                        this.it_ = Record.this.header().columns();
                        this.column_ = this;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it_.hasMoreElements();
                    }

                    @Override
                    public Map.Entry<C, V> next() {
                        Object c = this.it_.nextElement();
                        this.column_ = c;
                        return new SimpleEntry(c, Record.this.getValue(c));
                    }

                    @Override
                    public void remove() {
                        Record.this.remove(this.column_);
                    }
                };
            }

            @Override
            public int size() {
                return Record.this.header().columnCount();
            }
        };
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Map)) {
            return false;
        }
        Map<C, V> map = this._cast_to_map(object);
        if (map.size() != this.size()) {
            return false;
        }
        Enumeration<C> enumeration = this.header().columns();
        while (enumeration.hasMoreElements()) {
            C c = enumeration.nextElement();
            V v = this.getValue(c);
            V v2 = map.get(c);
            if (!(v == null ? v2 != null || !map.containsKey(c) : !v.equals(v2))) continue;
            return false;
        }
        return true;
    }

    private Map<C, V> _cast_to_map(Object object) {
        return (Map)object;
    }

    @Override
    public int hashCode() {
        int n = 0;
        Enumeration<C> enumeration = this.header().columns();
        while (enumeration.hasMoreElements()) {
            C c = enumeration.nextElement();
            V v = this.getValue(c);
            n += (c == null ? 0 : c.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }
        return n;
    }

    public String toString() {
        V v;
        Enumeration<C> enumeration = this.header().columns();
        if (!enumeration.hasMoreElements()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        C c = enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            v = this.getValue(c);
            stringBuilder.append(c == this ? "(this Map)" : String.valueOf(c));
            stringBuilder.append('=');
            stringBuilder.append(v == this ? "(this Map)" : String.valueOf(v));
            stringBuilder.append(", ");
            c = enumeration.nextElement();
        }
        v = this.getValue(c);
        stringBuilder.append(c == this ? "(this Map)" : String.valueOf(c));
        stringBuilder.append('=');
        stringBuilder.append(v == this ? "(this Map)" : String.valueOf(v));
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    protected abstract V getValue(Object var1);

    protected abstract V putValue(C var1, V var2);

    protected abstract V removeValue(Object var1);

    public boolean satisfyCondition(Map<C, V> map) {
        assert (map != null) : "@param:condition is null.";
        for (Map.Entry<C, V> entry : map.entrySet()) {
            C c = entry.getKey();
            V v = entry.getValue();
            if (!this.header().hasColumn(c)) {
                return false;
            }
            V v2 = this.getValue(c);
            if (!(v == null ? v2 != null : !v.equals(v2))) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleEntry<C, V>
    implements Map.Entry<C, V>,
    Serializable {
        static final long serialVersionUID = -6771737537141833033L;
        private final C key_;
        private V value_;

        public SimpleEntry(C c, V v) {
            this.key_ = c;
            this.value_ = v;
        }

        public SimpleEntry(Map.Entry<? extends C, ? extends V> entry) {
            this.key_ = entry.getKey();
            this.value_ = entry.getValue();
        }

        @Override
        public C getKey() {
            return this.key_;
        }

        @Override
        public V getValue() {
            return this.value_;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value_;
            this.value_ = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (!(this.key_ == entry.getKey() || this.key_ != null && this.key_.equals(entry.getKey()))) {
                return false;
            }
            return this.value_ == entry.getValue() || this.value_ != null && this.value_.equals(entry.getValue());
            {
            }
        }

        @Override
        public int hashCode() {
            return (this.key_ == null ? 0 : this.key_.hashCode()) ^ (this.value_ == null ? 0 : this.value_.hashCode());
        }

        public String toString() {
            return this.key_ + "=" + this.value_;
        }
    }
}

