/*
 * Decompiled with CFR 0.152.
 */
package ts.util.text;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import ts.util.text.StringOperation;
import ts.util.text.StringSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringCutter {
    protected StringCutter() {
    }

    public static List<String> split(String string, String string2) {
        assert (string != null) : "@param:string is null.";
        assert (string2 != null) : "@param:delimiter is null.";
        int n = StringOperation.length(string2);
        if (n == 0) {
            throw new IllegalArgumentException("@param:delimiter is empty.");
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        StringSequence stringSequence = new StringSequence(string, -1);
        StringSequence stringSequence2 = stringSequence.copy();
        while (stringSequence.next().validIndex()) {
            if (!stringSequence.startsWith(string2)) continue;
            linkedList.add(stringSequence2.followingString(stringSequence));
            stringSequence.next(n - 1);
            stringSequence2 = stringSequence.copy();
        }
        linkedList.add(stringSequence2.followingString());
        return linkedList;
    }

    public static List<String> splitIgnoreCase(String string, String string2) {
        assert (string != null) : "@param:string is null.";
        assert (string2 != null) : "@param:delimiter is null.";
        int n = StringOperation.length(string2);
        if (n == 0) {
            throw new IllegalArgumentException("@param:delimiter is empty.");
        }
        string2 = string2.toUpperCase();
        LinkedList<String> linkedList = new LinkedList<String>();
        StringSequence stringSequence = new StringSequence(string.toUpperCase(), -1);
        StringSequence stringSequence2 = new StringSequence(string, -1);
        while (stringSequence.next().validIndex()) {
            if (!stringSequence.startsWith(string2)) continue;
            linkedList.add(stringSequence2.followingString(stringSequence));
            stringSequence.next(n - 1);
            stringSequence2.next(stringSequence.index() - stringSequence2.index());
        }
        linkedList.add(stringSequence2.followingString());
        return linkedList;
    }

    public static List<String> split(String string, String[] stringArray) {
        assert (string != null) : "@param:string is null.";
        assert (stringArray != null) : "@param:delimiters is null.";
        String[] stringArray2 = StringCutter.createNewArrayWithSorting(stringArray);
        LinkedList<String> linkedList = new LinkedList<String>();
        StringSequence stringSequence = new StringSequence(string, -1);
        StringSequence stringSequence2 = stringSequence.copy();
        while (stringSequence.next().validIndex()) {
            String string2 = StringCutter.findStarting(stringSequence.substring(), stringArray2);
            if (string2 == null) continue;
            linkedList.add(stringSequence2.followingString(stringSequence));
            stringSequence.next(StringOperation.length(string2) - 1);
            stringSequence2 = stringSequence.copy();
        }
        linkedList.add(stringSequence2.followingString());
        return linkedList;
    }

    public static List<String> splitIgnoreCase(String string, String[] stringArray) {
        assert (string != null) : "@param:string is null.";
        assert (stringArray != null) : "@param:delimiters is null.";
        String[] stringArray2 = StringCutter.createUpperCaseArrayWithSorting(stringArray);
        LinkedList<String> linkedList = new LinkedList<String>();
        StringSequence stringSequence = new StringSequence(string.toUpperCase(), -1);
        StringSequence stringSequence2 = new StringSequence(string, -1);
        while (stringSequence.next().validIndex()) {
            String string2 = StringCutter.findStarting(stringSequence.substring(), stringArray2);
            if (string2 == null) continue;
            linkedList.add(stringSequence2.followingString(stringSequence));
            stringSequence.next(StringOperation.length(string2) - 1);
            stringSequence2.next(stringSequence.index() - stringSequence2.index());
        }
        linkedList.add(stringSequence2.followingString());
        return linkedList;
    }

    private static String[] createNewArrayWithSorting(String[] stringArray) {
        Object[] objectArray = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || StringOperation.isEmpty(stringArray[i])) {
                throw new IllegalArgumentException("@param:strArr has elements which are null or empty string.");
            }
            objectArray[i] = stringArray[i];
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    private static String[] createUpperCaseArrayWithSorting(String[] stringArray) {
        Object[] objectArray = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || StringOperation.isEmpty(stringArray[i])) {
                throw new IllegalArgumentException("@param:strArr has elements which are null or empty string.");
            }
            objectArray[i] = stringArray[i].toUpperCase();
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    private static String findStarting(String string, String[] stringArray) {
        for (int i = stringArray.length - 1; i >= 0; --i) {
            int n = Math.min(string.length(), stringArray[i].length());
            String string2 = string.substring(0, n);
            int n2 = string2.compareTo(stringArray[i]);
            if (n2 == 0) {
                return stringArray[i];
            }
            if (n2 > 0) break;
        }
        return null;
    }
}

