/*
 * Lifetime class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.lifetime;

import java.util.Date;
import java.util.List;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Enumeration;
import java.util.Collections;
import java.lang.reflect.Method;

/**
 * IuWFNg̐Ԃ\NXB
 * <br>
 * {@link ts.util.lifetime.Life Life}C^[tFCXCvg
 * IuWFNg̐ԂB
 * <br>
 * Ⴆ΁ÃNXXbhɍ킹Ĕh
 * {@link ts.util.lifetime.ThreadLifetime ThreadLifetime}NX́Aw肳ꂽ
 * Xbh̏Iɍ킹āAo^ꂽ{@link ts.util.lifetime.Life Life}
 * IuWFNgɏIʒmB
 * <br>
 * o^ꂽ{@link ts.util.lifetime.Life Life}IuWFNgɂ́Ao^
 * {@link ts.util.lifetime.Life#wasBorn() wasBorn()}\bhĂяoAI
 * ʒmɂ{@link ts.util.lifetime.Life#willDie() willDie()}\bhĂяoB
 * <br>
 * o^ꂽ{@link ts.util.lifetime.Life}IuWFNg̃NX
 * {@link ts.util.lifetime.EventfulLife}NX̔hNXłꍇ́A
 * ̃IuWFNg{@link ts.util.lifetime.EventfulLife#happens()}\bh
 * w肳ꂽ^C~OŌĂяo߂̎dg݂񋟂B
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/06/25 16:20:44 $
 */
public class Lifetime
{
  /** {@link ts.util.lifetime.Life Life}IuWFNgi[郊XgB } */
  private List<Life> lifeLst_ ;

  /** 
   * {@link ts.util.lifetime.EventfulLife EventfulLife}IuWFNĝ߂
   * ^C}[B 
   */
  private Timer lifeTimer_ = new Timer(true);

  /**
   * ftHgRXgN^B
   */
  public Lifetime()
  {
    lifeLst_ = createLifeList();
  }

  /**
   * {@link ts.util.lifetime.Life Life}IuWFNgi[郊Xg쐬B
   *
   * @return {@link ts.util.lifetime.Life Life}IuWFNgi[郊XgB
   */
  protected List<Life> createLifeList()
  {
    return new LinkedList<Life>();
  }

  /**
   * w肳ꂽO{@link ts.util.lifetime.Life Life}IuWFNg̃\bh
   * 擾B
   * <br>
   * AAΏۂƂȂ̂́AȂ̃\bĥ݂łB
   * <br>
   * w肳ꂽÖȂ̃\bh݂Ȃꍇ́AkԂB
   *
   * @param  life {@link ts.util.lifetime.Life Life}IuWFNgB
   * @param  methodName \bhB
   */
  private Method getLifeMethod(Life life, String methodName)
  {
    try {
      return life.getClass().getMethod(methodName);
    }
    catch (Exception e) {
      return null;
    }
  }

  /**
   * {@link ts.util.lifetime.Life Life}IuWFNgǉB
   * <br>
   * {@link ts.util.lifetime.Life Life}IuWFNgo^A
   * {@link ts.util.lifetime.Life#wasBorn() wasBorn()}\bhĂяoB
   *
   * @param  life {@link ts.util.lifetime.Life Life}IuWFNgB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public synchronized void add(Life life)
  {
    assert (life != null) : "@param:life is null.";

    lifeLst_.add(life);

    try {
      life.wasBorn();
    }
    catch (Exception e) {
      catchException(e, life, getLifeMethod(life, "wasBorn"));
    }

    if (life instanceof PeriodicEventfulLife) {
      setupPeriodicEvent(PeriodicEventfulLife.class.cast(life));
    }
    else if (life instanceof ScheduledEventfulLife) {
      setupScheduledEvent(ScheduledEventfulLife.class.cast(life));
    }
  }

  /**
   * {@link ts.util.lifetime.ScheduledEventfulLife ScheduledEventfulLife}
   * IuWFNgɑ΂āAw̃Cxgݒ肷B
   *
   * @param  life {@link ts.util.lifetime.ScheduledEventfulLife
   *           ScheduledEventfulLife}IuWFNgB
   */
  protected void setupScheduledEvent(final ScheduledEventfulLife life)
  {
    class ScheduleThread extends Thread {
      public void run() {
        try {
          Date nextTime = null;
          try {
            nextTime = life.getNextTime();
          }
          catch (Exception e) {
            catchException(e, life, getLifeMethod(life, "getNextTime"));
            throw e;
          }

          if (nextTime.getTime() > System.currentTimeMillis()) {
            TimerTask task = new TimerTask() {
              public void run() {
                try {
                  life.happens();
                }
                catch (Exception e) {
                  catchException(e, life, getLifeMethod(life, "happens"));
                }
                new ScheduleThread().start();
              }
            };
            lifeTimer_.schedule(task, nextTime);
          }
        }
        catch (Exception e) {
          new ScheduleThread().start();
        }
      }
    }

    new ScheduleThread().start();
  }

  /**
   * {@link ts.util.lifetime.PeriodicEventfulLife PeriodicEventfulLife}
   * IuWFNgɑ΂āAÑCxgݒ肷B
   *
   * @param  life {@link ts.util.lifetime.PeriodicEventfulLife
   *           PeriodicEventfulLife}IuWFNgB
   */
  protected void setupPeriodicEvent(final PeriodicEventfulLife life)
  {
    long interval = life.getInterval();
    if (interval > 0) {
      try {
        TimerTask task = new TimerTask() {
          public void run() {
            try {
              life.happens();
            }
            catch (Exception e) {
              catchException(e, life, getLifeMethod(life, "happens"));
            }
          }
        };
        lifeTimer_.schedule(task, 0L, interval);
      }
      catch (RuntimeException e) {
        setupPeriodicEvent(life);
      }
    }
  }

  /**
   * {@link ts.util.lifetime.Life Life}IuWFNg̐ԂIB
   * <br>
   * o^Ă{@link ts.util.lifetime.Life Life}IuWFNg
   * IuWFNg폜āA{@link ts.util.lifetime.Life#willDie() willDie()}
   * \bhĂяoB
   */
  protected synchronized void kill()
  {
    lifeTimer_.cancel();
    lifeTimer_ = new Timer(true);

    for (Life life : lifeLst_) {
      try {
        life.willDie();
      }
      catch (Exception e) {
        catchException(e, life, getLifeMethod(life, "willDie"));
      }
    }

    while (! lifeLst_.isEmpty()) {
      lifeLst_.remove(0);
    }
  }

  /**
   * {@link ts.util.lifetime.Life Life}IuWFNg̃\bhsėO
   * ۂɁA̗O󂯎B
   * <br>
   * Oɉ炩̏sꍇ́Ã\bhI[o[Ch
   * B
   * <br>
   * ̃NXł́AȂB
   *
   * @param  exc  OB
   * @param  life OX[{@link ts.util.lifetime.Life Life}
   *           IuWFNgB
   * @param  method OX[{@link ts.util.lifetime.Life Life}
   *           IuWFNg̃\bhB
   */
  protected void catchException(Exception exc, Life life, Method method)
  {}

  /**
   * ̃IuWFNgɊi[Ă{@link ts.util.lifetime.Life Life}
   * IuWFNg񋓂B
   *
   * @return {@link ts.util.lifetime.Life Life}IuWFNg̗񋓃IuWFNgB
   */
  protected Enumeration<Life> enumeration()
  {
    return Collections.enumeration(lifeLst_);
  }

  /**
   * ̃IuWFNgK[x[WERNVɂĔjۂɌĂяo
   * 郁\bhłB
   * <br>
   * jOɁA{@link #kill()}\bhĂяoĂB
   *
   * @throws Throwable ̃\bhŗOG[ꍇB
   */
  protected void finalize() throws Throwable
  {
    kill();
    super.finalize();
  }
}

