/*
 * RuntimeLifetimeTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.lifetime;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;

/**
 * {@link ts.util.lifetime.RuntimeLifetime RuntimeLifetime}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/06/25 16:20:45 $
 */
public class RuntimeLifetimeTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(RuntimeLifetimeTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("RuntimeLifetime NX̋@\sB");
  }

  /* -- inner classes -- */

  void log(String msg) {
    System.out.println(msg);
  }

  class LifeA implements Life {
    public void wasBorn() {
      log(getClass().getSimpleName() + " was born!");
    }
    public void willDie() {
      log(getClass().getSimpleName() + " will die!");
    }
  }
  class LifeB extends LifeA {}
  class LifeC extends LifeA {}
  

  /* -- test case -- */

  public void constructor()
  {
    MSG("ftHgERXgN^B");

    NOTNULL(new RuntimeLifetime());
  }

  public void setLifeLong()
  {
    MSG("RuntimeIuWFNgɂ鐶Ԃ̐ݒ");

    Life lifeA0 = new LifeA();
    Life lifeB1 = new LifeB();
    Life lifeA2 = new LifeA();
    Life lifeC3 = new LifeC();

    RuntimeLifetime lifetime0 = new RuntimeLifetime();
    RuntimeLifetime lifetime1 = new RuntimeLifetime();

    lifetime1.add(lifeA0);
    lifetime1.add(lifeB1);
    lifetime1.add(lifeA2);
    lifetime1.add(lifeC3);

    lifetime0.setLifeLong(Runtime.getRuntime());
    lifetime1.setLifeLong(Runtime.getRuntime());

    OK();
  }
}

