/*
 * Decompiled with CFR 0.152.
 */
package ts.util.text;

import java.util.Collection;
import ts.util.text.StringOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class StringSequence
implements Cloneable {
    private final String str_;
    private final int codePointCount_;
    private int charIndex_;
    private int codePointIndex_;

    public StringSequence(String string) {
        assert (string != null) : "@param:str is null.";
        this.str_ = string;
        this.codePointCount_ = string.codePointCount(0, string.length());
        this.charIndex_ = 0;
        this.codePointIndex_ = 0;
    }

    public StringSequence(String string, int n) throws IndexOutOfBoundsException {
        assert (string != null) : "@param:str is null.";
        int n2 = n == -1 ? -1 : StringOperation.offsetByCodePoints(string, 0, n);
        this.str_ = string;
        this.codePointCount_ = string.codePointCount(0, string.length());
        this.charIndex_ = n2;
        this.codePointIndex_ = n;
    }

    protected StringSequence(StringSequence stringSequence) {
        assert (stringSequence != null) : "@param:seq is null.";
        this.str_ = stringSequence.str_;
        this.codePointCount_ = stringSequence.codePointCount_;
        this.charIndex_ = stringSequence.charIndex_;
        this.codePointIndex_ = stringSequence.codePointIndex_;
    }

    public StringSequence copy() {
        return new StringSequence(this);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof StringSequence) {
            return this.substring().equals(((StringSequence)StringSequence.class.cast(object)).substring());
        }
        return false;
    }

    public int hashCode() {
        return this.substring().hashCode();
    }

    public boolean validIndex() {
        return 0 <= this.charIndex_ && this.charIndex_ < this.str_.length();
    }

    public boolean hasNext() {
        return this.codePointIndex_ < this.codePointCount_ - 1;
    }

    public boolean hasPrevious() {
        return this.codePointIndex_ > 0;
    }

    public StringSequence next() {
        return this.next(1);
    }

    public StringSequence next(int n) {
        if (n > 0) {
            this._next(n);
        } else if (n < 0) {
            this._prev(-n);
        }
        return this;
    }

    public StringSequence previous() {
        return this.previous(1);
    }

    public StringSequence previous(int n) {
        if (n > 0) {
            this._prev(n);
        } else if (n < 0) {
            this._next(-n);
        }
        return this;
    }

    private void _next(int n) {
        assert (n > 0);
        int n2 = this.codePointIndex_ + n;
        try {
            this.charIndex_ = StringOperation.offsetByCodePoints(this.str_, 0, n2);
            this.codePointIndex_ = n2;
        }
        catch (Exception exception) {
            this.charIndex_ = this.str_.length();
            this.codePointIndex_ = this.codePointCount_;
        }
    }

    private void _prev(int n) {
        assert (n > 0);
        int n2 = this.codePointIndex_ - n;
        try {
            this.charIndex_ = StringOperation.offsetByCodePoints(this.str_, 0, n2);
            this.codePointIndex_ = n2;
        }
        catch (Exception exception) {
            this.charIndex_ = -1;
            this.codePointIndex_ = -1;
        }
    }

    public int index() {
        return this.codePointIndex_;
    }

    public String character() {
        try {
            return this.str_.substring(this.charIndex_, StringOperation.offsetByCodePoints(this.str_, this.charIndex_, 1));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return "";
        }
    }

    public String substring() {
        return this.charIndex_ <= 0 ? this.str_ : this.str_.substring(this.charIndex_);
    }

    public String substring(StringSequence stringSequence) throws IndexOutOfBoundsException {
        assert (stringSequence != null) : "@param:endSeq is null.";
        return this.str_.substring(Math.max(this.charIndex_, 0), Math.max(stringSequence.charIndex_, 0));
    }

    public String followingString() {
        if (this.charIndex_ < 0) {
            return this.str_;
        }
        if (this.charIndex_ < this.str_.length()) {
            return this.str_.substring(StringOperation.offsetByCodePoints(this.str_, this.charIndex_, 1));
        }
        return "";
    }

    public String followingString(StringSequence stringSequence) throws IndexOutOfBoundsException {
        assert (stringSequence != null) : "@param:endSeq is null.";
        int n = this.charIndex_;
        int n2 = stringSequence.charIndex_;
        if (n == n2) {
            return "";
        }
        int n3 = this.str_.length();
        n = n < 0 ? 0 : (n >= n3 ? n : StringOperation.offsetByCodePoints(this.str_, n, 1));
        n2 = n2 < 0 ? 0 : n2;
        return this.str_.substring(n, n2);
    }

    public int restLength() {
        return this.codePointCount_ - this.codePointIndex_;
    }

    public int indexOf(String string) {
        return StringOperation.indexOf(this.str_, string, this.codePointIndex_);
    }

    public int lastIndexOf(String string) {
        int n = StringOperation.lastIndexOf(this.substring(), string);
        return n < 0 ? n : Math.max(this.index(), 0) + n;
    }

    public boolean startsWith(String string) {
        return StringOperation.startsWith(this.substring(), string);
    }

    public boolean endsWith(String string) {
        return StringOperation.endsWith(this.substring(), string);
    }

    public String startsWithOneOf(Collection<String> collection) {
        assert (collection != null) : "@param:strs is null.";
        assert (!collection.contains(null)) : "@param:strs contains null.";
        assert (!collection.contains("")) : "@param:strs contains an empty string.";
        for (String string : collection) {
            if (string == null || !this.startsWith(string) || StringOperation.isEmpty(string)) continue;
            return string;
        }
        return null;
    }

    public StringSequence startsWithOneOf(Collection<StringSequence> collection) {
        assert (collection != null) : "@param:seqs is null.";
        assert (!collection.contains(null)) : "@param:seqs contains null.";
        assert (!collection.contains(new StringSequence(""))) : "@param:seqs contains an empty string.";
        for (StringSequence stringSequence : collection) {
            if (stringSequence == null || !this.startsWith(stringSequence.substring()) || stringSequence.restLength() <= 0) continue;
            return stringSequence;
        }
        return null;
    }

    public boolean contains(String string) {
        return StringOperation.contains(this.substring(), string);
    }

    public StringSequence nextUntil(String string) {
        assert (string != null) : "@param:searched is null.";
        int n = this.str_.indexOf(string, this.charIndex_);
        if (n < 0) {
            this.charIndex_ = this.str_.length();
            this.codePointIndex_ = this.codePointCount_;
        } else if (n > 0) {
            this.charIndex_ = n;
            this.codePointIndex_ = this.str_.codePointCount(0, n);
        } else {
            this.charIndex_ = 0;
            this.codePointIndex_ = 0;
        }
        return this;
    }

    public StringSequence skipWhitespaces() {
        for (int i = Math.max(this.charIndex_, 0); i < this.str_.length(); i += this.str_.codePointCount(i, i + 1)) {
            if (Character.isWhitespace(this.str_.codePointAt(i))) continue;
            this.charIndex_ = i;
            this.codePointIndex_ = this.str_.codePointCount(0, i);
            return this;
        }
        this.charIndex_ = this.str_.length();
        this.codePointIndex_ = this.codePointCount_;
        return this;
    }
}

