/*
 * FileNameRegexFilter class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import java.io.File;
import java.io.FileFilter;

/**
 * t@Cɑ΂鐳K\Ƃt@CEtB^ENXB
 *
 * @author  V.
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:46 $
 */
public class FileNameRegexFilter implements FileFilter
{
  /** t@Cɑ΂鐳K\B */
  private String fileNameRegex_ ;

  /**
   * t@Cɑ΂鐳K\ɂƂRXgN^B
   *
   * @param regex K\B
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public FileNameRegexFilter(String regex)
  {
    assert (regex != null) : "@param:regex is null.";

    fileNameRegex_ = regex;
  }

  /**
   * w肳ꂽt@C̖OÃIuWFNg̎K\ɍv邩
   * ǂ𔻒肷B
   *
   * @param  file Ώۂ̃t@CB
   * @return t@C̖OK\ɍvꍇ<tt>true</tt>ԂB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public boolean accept(File file)
  {
    assert (file != null) : "@param:file is null.";

    return file.getName().matches(fileNameRegex_);
  }
}

