package ts.graph;

import ts.tester.function.coverage.FunctionTester;
import java.awt.*;
import java.io.File;

public class FillStyleTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      run(FillStyleTest.class, (args.length > 0) ? args[0] : null);
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- test casses -- */

  public void constructor_color()
  {
    MSG("FɂƂRXgN^B");

    FillStyle fstyle = new FillStyle(Color.cyan);
    EQUAL(fstyle.getColor(), Color.cyan);
    FALSE(fstyle.hasOutline());
  }

  public void constructor_color_needOutline()
  {
    MSG("FƊOg̗LɂƂRXgN^B");

    FillStyle fstyle = new FillStyle(Color.orange, true);
    EQUAL(fstyle.getColor(), Color.orange);
    TRUE (fstyle.hasOutline());
  }

  public void loadStyle()
  {
    MSG("OtBbNEIuWFNgɃX^C𔽉fB");

    final String path = "test\\FillStyle\\loadStyle.png";
    new File(path).getParentFile().mkdir();

    GraphImage gi = new GraphImage() {
      protected void drawGraph(Rectangle drawRect) {
        setFillStyle(new FillStyle(Color.cyan));
        fillRect(50, 50, 150, 100);
      }
    };
    gi.setSize(200, 200);
    gi.setBgColor(Color.white);
    gi.setMargin(10, 10, 10, 10);
    gi.setBorderStyle(new LineStyle(Color.black, 2));

    try {
      gi.createImageFile(GraphImage.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }
}
