/*
 * TextStyle class.
 *
 * Copyright (C) 2010 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.graph;

import java.util.Map;
import java.util.HashMap;
import java.awt.Graphics2D;
import java.awt.Font;
import java.awt.Color;
import java.awt.font.TextAttribute;

/**
 * eLXg̃X^C\NXB
 * <br>
 * eLXg̃tHgTCYFA{[ĥC^bN̂ɂ邩ǂ
 * ȂǂێB
 *
 * @author V.
 * @version $Id: TextStyle.java,v 1.1 2010-10-16 13:47:02 tayu Exp $
 */
public class TextStyle
{
  /** eLXg̃X^Ci[}bvB */
  private Map<TextAttribute, Object> attrMap_
    = new HashMap<TextAttribute, Object>();

  /**
   * ftHgERXgN^B
   */
  public TextStyle()
  {}

  /**
   * FɂƂRXgN^B
   * <br>
   * Ƀkw肵ꍇ́AFݒ肷B
   *
   * @param  color FɂƂRXgN^B
   */
  public TextStyle(Color color)
  {
    setColor(color);
  }

  /**
   * tHgETCYɂƂRXgN^B
   * <br>
   * FɃkw肵ꍇ́AFݒ肷B
   * tHgETCYɕ̒lw肵ꍇ́A0ݒ肷B
   *
   * @param  color FɂƂRXgN^B
   * @param  size tHgETCYɂƂRXgN^B
   */
  public TextStyle(Color color, float size)
  {
    setColor(color);
    setSize(size);
  }

  /**
   * FAtHgAtHgETCYɂƂRXgN^B
   * <br>
   * FɃkw肵ꍇ́AFݒ肷B
   * tHgɃkw肳ꂽꍇ́AtHgύXȂB
   * tHgETCYɕ̒lw肳ꂽꍇ́A0ݒ肷B
   *
   * @param  color FɂƂRXgN^B
   * @param  fontFamily tHgB
   * @param  size tHgETCYB
   */
  public TextStyle(Color color, String fontFamily, float size)
  {
    setColor(color);
    setFontFamily(fontFamily);
    setSize(size);
  }

  /**
   * FAtHgETCYA{[ĥɂ邩ǂAC^bN̂ɂ邩
   * ǂɂƂRXgN^B
   * <br>
   * FɃkw肵ꍇ́AFݒ肷B
   * tHgETCYɕ̒lw肳ꂽꍇ́A0ݒ肷B
   *
   * @param  color FɂƂRXgN^B
   * @param  size tHgETCYB
   * @param  bold {[ĥɂꍇ<tt>true</tt>B
   * @param  italic C^bN̂ɂꍇ<tt>true</tt>B
   */
  public TextStyle(Color color, float size, boolean bold, boolean italic)
  {
    setColor(color);
    setSize(size);
    setBold(bold);
    setItalic(italic);
  }

  /**
   * Fݒ肷B
   * <br>
   * Ƀkw肵ꍇ́AFݒ肷B
   *
   * @param  color FB
   */
  public void setColor(Color color)
  {
    attrMap_.put(TextAttribute.FOREGROUND, 
      (color != null) ? color : Color.black);
  }

  /**
   * wiFݒ肷B
   * <br>
   * Ƀkw肵ꍇ́Aɐݒ肷B
   */
  public void setBackGroundColor(Color color)
  {
    attrMap_.put(TextAttribute.BACKGROUND,
      (color != null) ? color : ColorStyle.TRANSPARENT);
  }

  /**
   * tHgETCYݒ肷B
   * <br>
   * ɕ̒lw肵ꍇ0ݒ肷B
   *
   * @param  size tHgETCYɂƂRXgN^B
   */
  public void setSize(float size)
  {
    attrMap_.put(TextAttribute.SIZE, new Float((size < 0.0f) ? 0.0f : size));
  }

  /**
   * tHgݒ肷B
   * <br>
   * Ƀkw肵ꍇ́AtHgύXȂB
   *
   * @param  fontFamily tHgB
   */
  public void setFontFamily(String fontFamily)
  {
    if (fontFamily != null) {
      attrMap_.put(TextAttribute.FAMILY, fontFamily);
    }
    else {
      attrMap_.remove(TextAttribute.FAMILY);
    }
  }

  /**
   * {[ĥɂ邩ǂݒ肷B
   *
   * @param  on {[ĥɂꍇ<tt>true</tt>w肷B
   */
  public void setBold(boolean on)
  {
    if (on ) {
      attrMap_.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
    }
    else {
      attrMap_.remove(TextAttribute.WEIGHT);
    }
  }

  /**
   * C^bN̂ɂ邩ǂݒ肷B
   *
   * @param  on C^bN̂ɂꍇ<tt>true</tt>w肷B
   */
  public void setItalic(boolean on)
  {
    if (on) {
      attrMap_.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
    }
    else {
      attrMap_.remove(TextAttribute.POSTURE);
    }
  }

  /**
   * t邩ǂݒ肷B
   *
   * @param  on tꍇ<tt>true</tt>w肷B
   */
  public void setUnderline(boolean on)
  {
    if (on) {
      attrMap_.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
    }
    else {
      attrMap_.remove(TextAttribute.UNDERLINE);
    }
  }

  /**
   * i[}bv擾B
   *
   * @return i[}bvB
   */
  public Map<TextAttribute, Object> getAttributeMap()
  {
    return attrMap_ ;
  }

  /**
   * OtBbNXEIuWFNgɃeLXg𔽉fB
   *
   * @param  g OtBbNXEIuWFNgB
   */
  public void loadStyle(Graphics2D g)
  {
    g.setFont(new Font(getAttributeMap()));
  }
}

