/*
 * Decompiled with CFR 0.152.
 */
package ts.util.table;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ts.util.table.Constraint;
import ts.util.table.ConstraintViolationException;
import ts.util.table.Table;
import ts.util.table.Trigger;

public class ConstraintTrigger<C, V>
extends Trigger<C, V> {
    private boolean isImmediate_ = true;
    private List<Constraint<C, V>> constraintsForAppend_ = new LinkedList<Constraint<C, V>>();
    private List<Constraint<C, V>> constraintsForUpdate_ = new LinkedList<Constraint<C, V>>();
    private List<Constraint<C, V>> constraintsForDelete_ = new LinkedList<Constraint<C, V>>();

    public ConstraintTrigger() {
        this(true);
    }

    public ConstraintTrigger(boolean bl) {
        this.isImmediate_ = bl;
    }

    public void addConstraintForAppend(Constraint<C, V> constraint) {
        assert (constraint != null) : "@param:constraint is null.";
        this.constraintsForAppend_.add(constraint);
    }

    public void addConstraintForUpdate(Constraint<C, V> constraint) {
        assert (constraint != null) : "@param:constraint is null.";
        this.constraintsForUpdate_.add(constraint);
    }

    public void addConstraintForDelete(Constraint<C, V> constraint) {
        assert (constraint != null) : "@param:constraint is null.";
        this.constraintsForDelete_.add(constraint);
    }

    @Override
    protected void preAppend(Table<C, V> table, Map<C, V> map) {
        assert (table != null) : "@param:table is null.";
        assert (map != null) : "@param:record is null.";
        ConstraintViolationException constraintViolationException = null;
        ConstraintViolationException constraintViolationException2 = null;
        for (Constraint<C, V> constraint : this.constraintsForAppend_) {
            try {
                constraint.check(Trigger.Action.Append, table, map);
            }
            catch (ConstraintViolationException constraintViolationException3) {
                if (this.isImmediate_) {
                    throw constraintViolationException3;
                }
                if (constraintViolationException2 == null) {
                    constraintViolationException2 = constraintViolationException = constraintViolationException3;
                    continue;
                }
                constraintViolationException2.setNext(constraintViolationException3);
                constraintViolationException2 = constraintViolationException3;
            }
        }
        if (constraintViolationException != null) {
            throw constraintViolationException;
        }
    }

    @Override
    protected void preUpdate(Table<C, V> table, Map<C, V> map, Map<C, V> map2) {
        assert (table != null) : "@param:table is null.";
        assert (map != null) : "@param:record is null.";
        assert (map2 != null) : "@param:destination is null.";
        ConstraintViolationException constraintViolationException = null;
        ConstraintViolationException constraintViolationException2 = null;
        for (Constraint<C, V> constraint : this.constraintsForUpdate_) {
            try {
                constraint.check(Trigger.Action.Update, table, map);
            }
            catch (ConstraintViolationException constraintViolationException3) {
                if (this.isImmediate_) {
                    throw constraintViolationException3;
                }
                if (constraintViolationException2 == null) {
                    constraintViolationException2 = constraintViolationException = constraintViolationException3;
                    continue;
                }
                constraintViolationException2.setNext(constraintViolationException3);
                constraintViolationException2 = constraintViolationException3;
            }
        }
        if (constraintViolationException != null) {
            throw constraintViolationException;
        }
    }

    @Override
    protected void preDelete(Table<C, V> table, Map<C, V> map) {
        assert (table != null) : "@param:table is null.";
        assert (map != null) : "@param:record is null.";
        ConstraintViolationException constraintViolationException = null;
        ConstraintViolationException constraintViolationException2 = null;
        for (Constraint<C, V> constraint : this.constraintsForDelete_) {
            try {
                constraint.check(Trigger.Action.Delete, table, map);
            }
            catch (ConstraintViolationException constraintViolationException3) {
                if (this.isImmediate_) {
                    throw constraintViolationException3;
                }
                if (constraintViolationException2 == null) {
                    constraintViolationException2 = constraintViolationException = constraintViolationException3;
                    continue;
                }
                constraintViolationException2.setNext(constraintViolationException3);
                constraintViolationException2 = constraintViolationException3;
            }
        }
        if (constraintViolationException != null) {
            throw constraintViolationException;
        }
    }

    @Override
    protected final void postAppend(Table<C, V> table, Map<C, V> map) {
    }

    @Override
    protected final void postUpdate(Table<C, V> table, Map<C, V> map, Map<C, V> map2) {
    }

    @Override
    protected final void postDelete(Table<C, V> table, Map<C, V> map) {
    }
}

