/*
 * DateTimeTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.tester.util.ObjectSerializer;
import java.util.*;
import java.text.*;

/**
 * <code>DateTime</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:44 $
 */
public class DateTimeTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(DateTimeTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- test case -- */

  public void constants()
  {
    MSG("萔̊mF");

    EQUAL(DateTime.JANUARY, 1);
    EQUAL(DateTime.FEBRUARY, 2);
    EQUAL(DateTime.MARCH, 3);
    EQUAL(DateTime.APRIL, 4);
    EQUAL(DateTime.MAY, 5);
    EQUAL(DateTime.JUNE, 6);
    EQUAL(DateTime.JULY, 7);
    EQUAL(DateTime.AUGUST, 8);
    EQUAL(DateTime.SEPTEMBER, 9);
    EQUAL(DateTime.OCTOBER, 10);
    EQUAL(DateTime.NOVEMBER, 11);
    EQUAL(DateTime.DECEMBER, 12);
    EQUAL(DateTime.SUNDAY, 1);
    EQUAL(DateTime.MONDAY, 2);
    EQUAL(DateTime.TUESDAY, 3);
    EQUAL(DateTime.WEDNESDAY, 4);
    EQUAL(DateTime.THURSDAY, 5);
    EQUAL(DateTime.FRIDAY, 6);
    EQUAL(DateTime.SATURDAY, 7);
  }

  public void constructor()
  {
    MSG("ʏ̑");

    long tm1 = Calendar.getInstance().getTime().getTime();
    DateTime dttm = new DateTime();
    long tm2 = Calendar.getInstance().getTime().getTime();
    TRUE(dttm.getDateTimeMillis() >= tm1);
    TRUE(dttm.getDateTimeMillis() <= tm2);
  }

  public void constructor_DateTime()
  {
    MSG("ʏ̑");
    DateTime dttm0 = new DateTime(2006, 10, 11, 01, 23, 45);
    DateTime dttm1 = new DateTime(dttm0);
    EQUAL(dttm0, dttm1);
  }

  public void constructor_DateTime_1()
  {
    MSG("k̏ꍇ");
    try {
      new DateTime((DateTime) null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_DateTime_2()
  {
    MSG("J_ftHgł͂Ȃꍇ");

    TimeZone tz = TimeZone.getTimeZone("America/Los_Angeles");
    Calendar cal = new GregorianCalendar(tz);

    DateTime dttm0 = new DateTime(cal);
    DateTime dttm1 = new DateTime(dttm0);
    EQUAL(dttm0, dttm1);
  }

  public void constructor_long()
  {
    MSG("ʏ̑");

    DateTime dttm0 = new DateTime(0L);
    EQUAL(dttm0.getDateTimeMillis(), 0L);

    DateTime dttm1 = new DateTime(1234L);
    EQUAL(dttm1.getDateTimeMillis(), 1234L);
  }

  public void constructor_Date()
  {
    MSG("ʏ̑");
    Date date = new Date();

    DateTime dttm0 = new DateTime(date);
    EQUAL(dttm0.getDateTimeMillis(), date.getTime());

    Calendar cal = Calendar.getInstance();
    DateTime dttm1 = new DateTime(cal.getTime());
    EQUAL(dttm1.getDateTimeMillis(), cal.getTime().getTime());
  }

  public void constructor_Date_1()
  {
    MSG("k̏ꍇ");
    try {
      new DateTime((Date) null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_year_month_day()
  {
    MSG("ʏ̑");

    Calendar cal = new GregorianCalendar(2004, Calendar.APRIL, 2, 0, 0, 0);
    cal.set(Calendar.MILLISECOND, 0);
    DateTime dttm = new DateTime(2004, 4, 2);
    EQUAL(dttm.getDateTimeMillis(), cal.getTime().getTime());
  }

  public void constructor_year_month_day_1()
  {
    MSG("sȓtw肵ꍇ");

    try {
      DateTime dttm = new DateTime(2003, 4, 31);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      DateTime dttm = new DateTime(2004, 13, 1);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_year_month_day_2()
  {
    MSG("[NɊւmF");

    try {
      Calendar cal = new GregorianCalendar(2004, Calendar.FEBRUARY, 29, 0,0,0);
      cal.set(Calendar.MILLISECOND, 0);
      DateTime dttm = new DateTime(2004, 2, 29);
      EQUAL(dttm.getDateTimeMillis(), cal.getTime().getTime());
    } catch (Exception e) {
      NG(e);
    }

    try {
      DateTime dttm = new DateTime(2004, 2, 30);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      DateTime dttm = new DateTime(2003, 2, 29);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_y_m_d_hh_mm_ss()
  {
    MSG("ʏ̑");

    Calendar cal = new GregorianCalendar(2004, Calendar.MAY, 7, 10, 23, 45);
    cal.set(Calendar.MILLISECOND, 0);
    DateTime dttm = new DateTime(2004, 5, 7, 10, 23, 45);
    EQUAL(dttm.getDateTimeMillis(), cal.getTime().getTime());
  }

  public void constructor_y_m_d_hh_mm_ss_1()
  {
    MSG("sȓtw肵ꍇ");

    try {
      DateTime dttm = new DateTime(2004, 4, 31, 1, 2, 3);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      DateTime dttm = new DateTime(2003, 13, 1, 1, 2, 3);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_y_m_d_hh_mm_ss_2()
  {
    MSG("sȎw肵ꍇ");

    try {
      DateTime dttm = new DateTime(2004, 1, 1, 24, 45, 23);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      DateTime dttm = new DateTime(2004, 1, 1, 1, 60, 23);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      DateTime dttm = new DateTime(2004, 1, 1, 1, 1, 60);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_era_y_m_d_hh_mm_ss()
  {
    MSG("ʏ̑");

    Calendar cal = new GregorianCalendar(2004, Calendar.MAY, 7, 10, 23, 45);
    cal.set(Calendar.MILLISECOND, 0);
    DateTime dttm = new DateTime(GregorianCalendar.AD, 2004, 5, 7, 10, 23, 45);
    EQUAL(dttm.getDateTimeMillis(), cal.getTime().getTime());

    cal.set(Calendar.ERA, GregorianCalendar.BC);
    dttm = new DateTime(GregorianCalendar.BC, 2004, 5, 7, 10, 23, 45);
    EQUAL(dttm.getDateTimeMillis(), cal.getTime().getTime());
  }

  public void constructor_Calendar()
  {
    MSG("ʏ̏ꍇ");

    Calendar cal0 = new GregorianCalendar(2006,Calendar.APRIL,1, 2,3,4);
    DateTime dttm0 = new DateTime(cal0);
    EQUAL(dttm0.getDateTimeMillis(), cal0.getTime().getTime());
    EQUAL(dttm0.getCalendar(), cal0);

    Locale lc = Locale.US;
    TimeZone tz = TimeZone.getTimeZone("America/Los_Angeles");
    Calendar cal1 = new GregorianCalendar(tz, lc);
    cal1.set(2006,4-1,1, 2,3,4);
    cal1.set(Calendar.MILLISECOND, 0);
    DateTime dttm1 = new DateTime(cal1);
    EQUAL(dttm1.getDateTimeMillis(), cal1.getTime().getTime());
    EQUAL(dttm1.getCalendar(), cal1);
  }

  public void constructor_Calendar_1()
  {
    MSG("k̏ꍇ");

    try {
      DateTime dttm = new DateTime((Calendar) null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void getDate()
  {
    MSG("ʏ̑");

    try {
      DateTime dttm = new DateTime(2004, 2, 29, 11, 22, 33);
      Calendar cal = new GregorianCalendar(2004,Calendar.FEBRUARY,29,11,22,33);
      EQUAL(dttm.getDate(), cal.getTime());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void getSQLDate()
  {
    MSG("ʏ̑");

    try {
      DateTime dttm = new DateTime(2004, 2, 29, 11, 22, 33);
      Calendar cal = new GregorianCalendar(2004,Calendar.FEBRUARY,29,11,22,33);
      EQUAL(dttm.getSQLDate(), new java.sql.Date(cal.getTime().getTime()));
    } catch (Exception e) {
      NG(e);
    }
  }

  public void getSQLTime()
  {
    MSG("ʏ̑");

    try {
      DateTime dttm = new DateTime(2004, 2, 29, 11, 22, 33);
      Calendar cal = new GregorianCalendar(2004,Calendar.FEBRUARY,29,11,22,33);
      EQUAL(dttm.getSQLTime(), new java.sql.Time(cal.getTime().getTime()));
    } catch (Exception e) {
      NG(e);
    }
  }

  public void getSQLTimestamp()
  {
    MSG("ʏ̑");

    try {
      DateTime dttm = new DateTime(2004, 2, 29, 11, 22, 33);
      Calendar cal = new GregorianCalendar(2004,Calendar.FEBRUARY,29,11,22,33);
      EQUAL(dttm.getSQLTimestamp(),
        new java.sql.Timestamp(cal.getTime().getTime()));
    } catch (Exception e) {
      NG(e);
    }
  }

  public void getCalendar()
  {
    MSG("ʏ̑");

    DateTime dttm = new DateTime(2004, 4, 5, 12, 34, 56);
    Calendar cal0 = dttm.getCalendar();

    Calendar cal1 = new GregorianCalendar(2004, 4-1, 5, 12, 34, 56);
    cal1.set(Calendar.MILLISECOND, 0);

    EQUAL(cal0.getTimeInMillis(), cal1.getTimeInMillis());
  }

  public void getTimeZone()
  {
    MSG("ʏ̑");
    DateTime dttm0= new DateTime();
    EQUAL(dttm0.getTimeZone(), TimeZone.getTimeZone("Asia/Tokyo"));

    DateTime dttm1 = new DateTime(new GregorianCalendar(
      TimeZone.getTimeZone("America/Los_Angeles")));
    EQUAL(dttm1.getTimeZone(), TimeZone.getTimeZone("America/Los_Angeles"));
  }

  public void getDateElements()
  {
    MSG("ʏ̑");

    DateTime dttm = new DateTime(2004, 5, 6, 18, 43, 27);
    EQUAL(dttm.getEra(), GregorianCalendar.AD);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 6);
    EQUAL(dttm.getHour(), 18);
    EQUAL(dttm.getMinute(), 43);
    EQUAL(dttm.getSecond(), 27);

    dttm.setDateTime(GregorianCalendar.BC, 123, 12, 31, 10, 20, 30);
    EQUAL(dttm.getEra(), GregorianCalendar.BC);
    EQUAL(dttm.getYear(), 123);
    EQUAL(dttm.getMonth(), 12);
    EQUAL(dttm.getDay(), 31);
    EQUAL(dttm.getHour(), 10);
    EQUAL(dttm.getMinute(), 20);
    EQUAL(dttm.getSecond(), 30);
  }

  public void setDateTime()
  {
    MSG("ʏ̒l");

    DateTime dttm = new DateTime();
    dttm.setDateTime(1234567890L);
    EQUAL(dttm.getDateTimeMillis(), 1234567890L);
    EQUAL(dttm.getDate(), new Date(1234567890L));
  }

  public void setDateTime_long_1()
  {
    MSG("ɋElݒ肵ꍇ");

    DateTime dttm = new DateTime();
    dttm.setDateTime(0L);
    EQUAL(dttm.getDateTimeMillis(), 0L);
    EQUAL(dttm.getDate(), new Date(0L));

    dttm.setDateTime(Long.MAX_VALUE);
    EQUAL(dttm.getDateTimeMillis(), Long.MAX_VALUE);
    EQUAL(dttm.getDate(), new Date(Long.MAX_VALUE));

    dttm.setDateTime(Long.MIN_VALUE);
    EQUAL(dttm.getDateTimeMillis(), Long.MIN_VALUE);
    EQUAL(dttm.getDate(), new Date(Long.MIN_VALUE));
  }

  public void setDateTime_Date()
  {
    MSG("ʏ̏ꍇ");

    DateTime dttm = new DateTime();
    Date date = new Date();
    dttm.setDateTime(date);
    EQUAL(dttm.getDateTimeMillis(), date.getTime());

    Calendar cal = new GregorianCalendar(2004, 1, 30);
    dttm.setDateTime(cal.getTime());
    EQUAL(dttm.getDateTimeMillis(), cal.getTime().getTime());
  }

  public void setDateTime_Date_1()
  {
    MSG("Ƀkw肵ꍇ");

    DateTime dttm = new DateTime();
    try {
      dttm.setDateTime((Date) null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setDateTime_y_m_d()
  {
    MSG("ʏ̑");

    DateTime dttm = new DateTime();
    dttm.setDateTime(2004, 4, 2);
    Calendar cal = new GregorianCalendar(2004, Calendar.APRIL, 2, 0, 0, 0);
    cal.set(Calendar.MILLISECOND, 0);
    EQUAL(dttm.getDateTimeMillis(), cal.getTime().getTime());
  }

  public void setDateTime_y_m_d_1()
  {
    MSG("sȓw肵ꍇ");

    DateTime dttm = new DateTime();
    try {
      dttm.setDateTime(2003, 4, 31);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      dttm.setDateTime(2003, 4, 0);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setDateTime_y_m_d_2()
  {
    MSG("sȌw肵ꍇ");

    DateTime dttm = new DateTime();
    try {
      dttm.setDateTime(2004, 13, 2);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      dttm.setDateTime(2004, 0, 1);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setDateTime_y_m_d_hh_mm_ss()
  {
    MSG("ʏ̑");

    DateTime dttm = new DateTime();
    dttm.setDateTime(2004, 3, 4, 11, 22, 33);
    Calendar cal = Calendar.getInstance();
    cal.set(Calendar.ERA, GregorianCalendar.AD);
    cal.set(Calendar.YEAR, 2004);
    cal.set(Calendar.MONTH, Calendar.MARCH);
    cal.set(Calendar.DAY_OF_MONTH, 4);
    cal.set(Calendar.HOUR_OF_DAY, 11);
    cal.set(Calendar.MINUTE, 22);
    cal.set(Calendar.SECOND, 33);
    cal.set(Calendar.MILLISECOND, 0);
    EQUAL(dttm.getDateTimeMillis(), cal.getTime().getTime());
  }

  public void setDateTime_y_m_d_hh_mm_ss_1()
  {
    MSG("sȓw肵ꍇ");

    DateTime dttm = new DateTime();
    try {
      dttm.setDateTime(2003, 9, 31, 1, 1, 1);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setDateTime_y_m_d_hh_mm_ss_2()
  {
    MSG("sȌw肵ꍇ");

    DateTime dttm = new DateTime();
    try {
      dttm.setDateTime(2003, 13, 1, 2, 3, 4);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setDateTime_y_m_d_hh_mm_ss_3()
  {
    MSG("sȎw肵ꍇ");

    DateTime dttm = new DateTime();
    try {
      dttm.setDateTime(2003, 1, 1, 24, 34, 45);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setDateTime_y_m_d_hh_mm_ss_4()
  {
    MSG("sȕw肵ꍇ");

    DateTime dttm = new DateTime();
    try {
      dttm.setDateTime(2004, 11, 22, 1, 60, 11);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setDateTime_y_m_d_hh_mm_ss_5()
  {
    MSG("sȕbw肵ꍇ");

    DateTime dttm = new DateTime();
    try {
      dttm.setDateTime(2004, 11, 22, 33, 44, 60);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setDateTime_e_y_m_d_hh_mm_ss()
  {
    MSG("ʏ̑");

    DateTime dttm = new DateTime();
    dttm.setDateTime(GregorianCalendar.BC, 102, 3, 4, 11, 22, 33);
    Calendar cal = Calendar.getInstance();
    cal.set(Calendar.ERA, GregorianCalendar.BC);
    cal.set(Calendar.YEAR, 102);
    cal.set(Calendar.MONTH, Calendar.MARCH);
    cal.set(Calendar.DAY_OF_MONTH, 4);
    cal.set(Calendar.HOUR_OF_DAY, 11);
    cal.set(Calendar.MINUTE, 22);
    cal.set(Calendar.SECOND, 33);
    cal.set(Calendar.MILLISECOND, 0);
    EQUAL(dttm.getDateTimeMillis(), cal.getTime().getTime());
  }

  public void setDateTime_e_y_m_d_hh_mm_ss_1()
  {
    MSG("sȓw肵ꍇ");

    DateTime dttm = new DateTime();
    try {
      dttm.setDateTime(0, 2003, 9, 31, 1, 1, 1);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setDateTime_e_y_m_d_hh_mm_ss_2()
  {
    MSG("sȌw肵ꍇ");

    DateTime dttm = new DateTime();
    try {
      dttm.setDateTime(0, 2003, 13, 1, 2, 3, 4);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setDateTime_e_y_m_d_hh_mm_ss_3()
  {
    MSG("sȌw肵ꍇ");
    
    DateTime dttm = new DateTime();
    try {
      dttm.setDateTime(-1, 2004, 11, 22, 33, 44, 55);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setDateTime_e_y_m_d_hh_mm_ss_4()
  {
    MSG("sȎw肵ꍇ");

    DateTime dttm = new DateTime();
    try {
      dttm.setDateTime(0, 2003, 1, 1, 24, 34, 45);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setDateTime_e_y_m_d_hh_mm_ss_5()
  {
    MSG("sȕw肵ꍇ");

    DateTime dttm = new DateTime();
    try {
      dttm.setDateTime(0, 2004, 11, 22, 1, 60, 11);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setDateTime_e_y_m_d_hh_mm_ss_6()
  {
    MSG("sȕbw肵ꍇ");

    DateTime dttm = new DateTime();
    try {
      dttm.setDateTime(0, 2004, 11, 22, 33, 44, 60);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setStartTimeOfDay()
  {
    MSG("ʏ̑̏ꍇ");

    DateTime dttm = new DateTime(2004, 2, 29, 10, 23, 49);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 2);
    EQUAL(dttm.getDay(), 29);
    EQUAL(dttm.getHour(), 10);
    EQUAL(dttm.getMinute(), 23);
    EQUAL(dttm.getSecond(), 49);

    dttm.setStartTimeOfDay();
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 2);
    EQUAL(dttm.getDay(), 29);
    EQUAL(dttm.getHour(), 0);
    EQUAL(dttm.getMinute(), 0);
    EQUAL(dttm.getSecond(), 0);
  }

  public void setEndTimeOfDay()
  {
    MSG("ʏ̑̏ꍇ");

    DateTime dttm = new DateTime(2004, 3, 27, 10, 20, 30);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 3);
    EQUAL(dttm.getDay(), 27);
    EQUAL(dttm.getHour(), 10);
    EQUAL(dttm.getMinute(), 20);
    EQUAL(dttm.getSecond(), 30);

    dttm.setEndTimeOfDay();
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 3);
    EQUAL(dttm.getDay(), 27);
    EQUAL(dttm.getHour(), 23);
    EQUAL(dttm.getMinute(), 59);
    EQUAL(dttm.getSecond(), 59);
  }

  public void setStartDayOfMonth()
  {
    MSG("ʏ̑̏ꍇ");

    DateTime dttm = new DateTime(2004, 4, 18, 11, 22, 33);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 4);
    EQUAL(dttm.getDay(), 18);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    dttm.setStartDayOfMonth();
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 4);
    EQUAL(dttm.getDay(), 1);
    EQUAL(dttm.getHour(), 0);
    EQUAL(dttm.getMinute(), 0);
    EQUAL(dttm.getSecond(), 0);
  }

  public void setEndOfDayOfMonth()
  {
    MSG("ʏ̑̏ꍇ");

    DateTime dttm = new DateTime(2004, 4, 18, 11, 22, 33);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 4);
    EQUAL(dttm.getDay(), 18);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    dttm.setEndDayOfMonth();
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 4);
    EQUAL(dttm.getDay(), 30);
    EQUAL(dttm.getHour(), 23);
    EQUAL(dttm.getMinute(), 59);
    EQUAL(dttm.getSecond(), 59);
  }

  public void setStartDayOfWeek()
  {
    DateTime dttm = new DateTime();

    MSG("jɑ΂Ďs");
    dttm.setDateTime(2004, 9, 19, 12, 34, 56);
    EQUAL(dttm.getWeek(), DateTime.SUNDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 19);
    EQUAL(dttm.getHour(), 12);
    EQUAL(dttm.getMinute(), 34);
    EQUAL(dttm.getSecond(), 56);

    dttm.setStartDayOfWeek();
    EQUAL(dttm.getWeek(), DateTime.SUNDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 19);
    EQUAL(dttm.getHour(), 0);
    EQUAL(dttm.getMinute(), 0);
    EQUAL(dttm.getSecond(), 0);

    MSG("jɑ΂Ďs");
    dttm.setDateTime(2004, 9, 20, 12, 34, 56);
    EQUAL(dttm.getWeek(), DateTime.MONDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 20);
    EQUAL(dttm.getHour(), 12);
    EQUAL(dttm.getMinute(), 34);
    EQUAL(dttm.getSecond(), 56);

    dttm.setStartDayOfWeek();
    EQUAL(dttm.getWeek(), DateTime.SUNDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 19);
    EQUAL(dttm.getHour(), 0);
    EQUAL(dttm.getMinute(), 0);
    EQUAL(dttm.getSecond(), 0);

    MSG("Ηjɑ΂Ďs");
    dttm.setDateTime(2004, 9, 21, 12, 34, 56);
    EQUAL(dttm.getWeek(), DateTime.TUESDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 21);
    EQUAL(dttm.getHour(), 12);
    EQUAL(dttm.getMinute(), 34);
    EQUAL(dttm.getSecond(), 56);

    dttm.setStartDayOfWeek();
    EQUAL(dttm.getWeek(), DateTime.SUNDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 19);
    EQUAL(dttm.getHour(), 0);
    EQUAL(dttm.getMinute(), 0);
    EQUAL(dttm.getSecond(), 0);

    MSG("jɑ΂Ďs");
    dttm.setDateTime(2004, 9, 22, 12, 34, 56);
    EQUAL(dttm.getWeek(), DateTime.WEDNESDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 22);
    EQUAL(dttm.getHour(), 12);
    EQUAL(dttm.getMinute(), 34);
    EQUAL(dttm.getSecond(), 56);

    dttm.setStartDayOfWeek();
    EQUAL(dttm.getWeek(), DateTime.SUNDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 19);
    EQUAL(dttm.getHour(), 0);
    EQUAL(dttm.getMinute(), 0);
    EQUAL(dttm.getSecond(), 0);

    MSG("ؗjɑ΂Ďs");
    dttm.setDateTime(2004, 9, 23, 12, 34, 56);
    EQUAL(dttm.getWeek(), DateTime.THURSDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 23);
    EQUAL(dttm.getHour(), 12);
    EQUAL(dttm.getMinute(), 34);
    EQUAL(dttm.getSecond(), 56);

    dttm.setStartDayOfWeek();
    EQUAL(dttm.getWeek(), DateTime.SUNDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 19);
    EQUAL(dttm.getHour(), 0);
    EQUAL(dttm.getMinute(), 0);
    EQUAL(dttm.getSecond(), 0);

    MSG("jɑ΂Ďs");
    dttm.setDateTime(2004, 9, 24, 12, 34, 56);
    EQUAL(dttm.getWeek(), DateTime.FRIDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 24);
    EQUAL(dttm.getHour(), 12);
    EQUAL(dttm.getMinute(), 34);
    EQUAL(dttm.getSecond(), 56);

    dttm.setStartDayOfWeek();
    EQUAL(dttm.getWeek(), DateTime.SUNDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 19);
    EQUAL(dttm.getHour(), 0);
    EQUAL(dttm.getMinute(), 0);
    EQUAL(dttm.getSecond(), 0);

    MSG("yjɑ΂Ďs");
    dttm.setDateTime(2004, 9, 25, 12, 34, 56);
    EQUAL(dttm.getWeek(), DateTime.SATURDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 25);
    EQUAL(dttm.getHour(), 12);
    EQUAL(dttm.getMinute(), 34);
    EQUAL(dttm.getSecond(), 56);

    dttm.setStartDayOfWeek();
    EQUAL(dttm.getWeek(), DateTime.SUNDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 19);
    EQUAL(dttm.getHour(), 0);
    EQUAL(dttm.getMinute(), 0);
    EQUAL(dttm.getSecond(), 0);
  }

  public void setEndDayOfWeek()
  {
    DateTime dttm = new DateTime();

    MSG("jɑ΂Ďs");
    dttm.setDateTime(2004, 9, 19, 12, 34, 56);
    EQUAL(dttm.getWeek(), DateTime.SUNDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 19);
    EQUAL(dttm.getHour(), 12);
    EQUAL(dttm.getMinute(), 34);
    EQUAL(dttm.getSecond(), 56);

    dttm.setEndDayOfWeek();
    EQUAL(dttm.getWeek(), DateTime.SATURDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 25);
    EQUAL(dttm.getHour(), 23);
    EQUAL(dttm.getMinute(), 59);
    EQUAL(dttm.getSecond(), 59);

    MSG("jɑ΂Ďs");
    dttm.setDateTime(2004, 9, 20, 12, 34, 56);
    EQUAL(dttm.getWeek(), DateTime.MONDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 20);
    EQUAL(dttm.getHour(), 12);
    EQUAL(dttm.getMinute(), 34);
    EQUAL(dttm.getSecond(), 56);

    dttm.setEndDayOfWeek();
    EQUAL(dttm.getWeek(), DateTime.SATURDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 25);
    EQUAL(dttm.getHour(), 23);
    EQUAL(dttm.getMinute(), 59);
    EQUAL(dttm.getSecond(), 59);

    MSG("Ηjɑ΂Ďs");
    dttm.setDateTime(2004, 9, 21, 12, 34, 56);
    EQUAL(dttm.getWeek(), DateTime.TUESDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 21);
    EQUAL(dttm.getHour(), 12);
    EQUAL(dttm.getMinute(), 34);
    EQUAL(dttm.getSecond(), 56);

    dttm.setEndDayOfWeek();
    EQUAL(dttm.getWeek(), DateTime.SATURDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 25);
    EQUAL(dttm.getHour(), 23);
    EQUAL(dttm.getMinute(), 59);
    EQUAL(dttm.getSecond(), 59);

    MSG("jɑ΂Ďs");
    dttm.setDateTime(2004, 9, 22, 12, 34, 56);
    EQUAL(dttm.getWeek(), DateTime.WEDNESDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 22);
    EQUAL(dttm.getHour(), 12);
    EQUAL(dttm.getMinute(), 34);
    EQUAL(dttm.getSecond(), 56);

    dttm.setEndDayOfWeek();
    EQUAL(dttm.getWeek(), DateTime.SATURDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 25);
    EQUAL(dttm.getHour(), 23);
    EQUAL(dttm.getMinute(), 59);
    EQUAL(dttm.getSecond(), 59);

    MSG("ؗjɑ΂Ďs");
    dttm.setDateTime(2004, 9, 23, 12, 34, 56);
    EQUAL(dttm.getWeek(), DateTime.THURSDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 23);
    EQUAL(dttm.getHour(), 12);
    EQUAL(dttm.getMinute(), 34);
    EQUAL(dttm.getSecond(), 56);

    dttm.setEndDayOfWeek();
    EQUAL(dttm.getWeek(), DateTime.SATURDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 25);
    EQUAL(dttm.getHour(), 23);
    EQUAL(dttm.getMinute(), 59);
    EQUAL(dttm.getSecond(), 59);

    MSG("jɑ΂Ďs");
    dttm.setDateTime(2004, 9, 24, 12, 34, 56);
    EQUAL(dttm.getWeek(), DateTime.FRIDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 24);
    EQUAL(dttm.getHour(), 12);
    EQUAL(dttm.getMinute(), 34);
    EQUAL(dttm.getSecond(), 56);

    dttm.setEndDayOfWeek();
    EQUAL(dttm.getWeek(), DateTime.SATURDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 25);
    EQUAL(dttm.getHour(), 23);
    EQUAL(dttm.getMinute(), 59);
    EQUAL(dttm.getSecond(), 59);

    MSG("yjɑ΂Ďs");
    dttm.setDateTime(2004, 9, 25, 12, 34, 56);
    EQUAL(dttm.getWeek(), DateTime.SATURDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 25);
    EQUAL(dttm.getHour(), 12);
    EQUAL(dttm.getMinute(), 34);
    EQUAL(dttm.getSecond(), 56);

    dttm.setEndDayOfWeek();
    EQUAL(dttm.getWeek(), DateTime.SATURDAY);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 9);
    EQUAL(dttm.getDay(), 25);
    EQUAL(dttm.getHour(), 23);
    EQUAL(dttm.getMinute(), 59);
    EQUAL(dttm.getSecond(), 59);
  }

  public void addYear()
  {
    DateTime dttm = new DateTime(2004, 5, 2, 11, 22, 33);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 2);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("N1Z");
    dttm.addYear(1);
    EQUAL(dttm.getYear(), 2005);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 2);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("N1Z");
    dttm.addYear(-1);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 2);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("N5Z");
    dttm.addYear(-5);
    EQUAL(dttm.getYear(), 1999);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 2);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("N5Z");
    dttm.addYear(5);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 2);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("N10Z");
    dttm.addYear(10);
    EQUAL(dttm.getYear(), 2014);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 2);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("N10Z");
    dttm.addYear(-10);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 2);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);
  }

  public void addYear_1()
  {
    MSG("[N炻łȂN");
    DateTime dttm = new DateTime(2004, 2, 29, 10, 20, 30);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 2);
    EQUAL(dttm.getDay(), 29);
    EQUAL(dttm.getHour(), 10);
    EQUAL(dttm.getMinute(), 20);
    EQUAL(dttm.getSecond(), 30);

    dttm.addYear(1);
    EQUAL(dttm.getYear(), 2005);
    EQUAL(dttm.getMonth(), 2);
    EQUAL(dttm.getDay(), 28);
    EQUAL(dttm.getHour(), 10);
    EQUAL(dttm.getMinute(), 20);
    EQUAL(dttm.getSecond(), 30);
  }

  public void addMonth()
  {
    DateTime dttm = new DateTime(2004, 5, 2, 11, 22, 33);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 2);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("1Z");
    dttm.addMonth(1);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 6);
    EQUAL(dttm.getDay(), 2);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("1Z");
    dttm.addMonth(-1);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 2);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("5Z");
    dttm.addMonth(5);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 10);
    EQUAL(dttm.getDay(), 2);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("5Z");
    dttm.addMonth(-5);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 2);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("10Z");
    dttm.addMonth(10);
    EQUAL(dttm.getYear(), 2005);
    EQUAL(dttm.getMonth(), 3);
    EQUAL(dttm.getDay(), 2);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("10Z");
    dttm.addMonth(-10);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 2);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);
  }

  public void addMonth_1()
  {
    MSG("31܂ł̌30܂ł̌");
    DateTime dttm = new DateTime(2004, 5, 31, 10, 20, 30);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 31);
    dttm.addMonth(1);
    EQUAL(dttm.getMonth(), 6);
    EQUAL(dttm.getDay(), 30);
  }

  public void addMonth_2()
  {
    MSG("[N22912");
    DateTime dttm = new DateTime(2004, 2, 29, 1, 2, 3);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 2);
    EQUAL(dttm.getDay(), 29);
    dttm.addMonth(12);
    EQUAL(dttm.getYear(), 2005);
    EQUAL(dttm.getMonth(), 2);
    EQUAL(dttm.getDay(), 28);
  }

  public void addMonth_3()
  {
    MSG("N1Z");
    DateTime dttm = new DateTime(2004, 12, 31, 1, 2, 3);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 12);
    EQUAL(dttm.getDay(), 31);
    EQUAL(dttm.getHour(), 1);
    EQUAL(dttm.getMinute(), 2);
    EQUAL(dttm.getSecond(), 3);

    dttm.addMonth(1);
    EQUAL(dttm.getYear(), 2005);
    EQUAL(dttm.getMonth(), 1);
    EQUAL(dttm.getDay(), 31);
    EQUAL(dttm.getHour(), 1);
    EQUAL(dttm.getMinute(), 2);
    EQUAL(dttm.getSecond(), 3);
  }

  public void addMonth_4()
  {
    MSG("Nn1Z");
    DateTime dttm = new DateTime(2004, 1, 1, 0, 0, 0);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 1);
    EQUAL(dttm.getDay(), 1);
    EQUAL(dttm.getHour(), 0);
    EQUAL(dttm.getMinute(), 0);
    EQUAL(dttm.getSecond(), 0);

    dttm.addMonth(-1);
    EQUAL(dttm.getYear(), 2003);
    EQUAL(dttm.getMonth(), 12);
    EQUAL(dttm.getDay(), 1);
    EQUAL(dttm.getHour(), 0);
    EQUAL(dttm.getMinute(), 0);
    EQUAL(dttm.getSecond(), 0);
  }

  public void addDay()
  {
    DateTime dttm = new DateTime(2004, 5, 12, 11, 22, 33);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("1Z");
    dttm.addDay(1);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 13);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("1Z");
    dttm.addDay(-1);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("5Z");
    dttm.addDay(-5);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 7);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("5Z");
    dttm.addDay(5);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("10Z");
    dttm.addDay(10);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 22);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("10Z");
    dttm.addDay(-10);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);
  }

  public void addDay_1()
  {
    MSG("1Z");
    DateTime dttm = new DateTime(2004, 5, 31, 1, 2, 3);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 31);
    dttm.addDay(1);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 6);
    EQUAL(dttm.getDay(), 1);
  }

  public void addDay_2()
  {
    MSG("n1Z");
    DateTime dttm = new DateTime(2004, 6, 1, 5, 5, 5);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 6);
    EQUAL(dttm.getDay(), 1);
    dttm.addDay(-1);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 31);
  }

  public void addHour()
  {
    DateTime dttm = new DateTime(2004, 5, 12, 11, 22, 33);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("Ԃ1Z");
    dttm.addHour(1);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 12);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("Ԃ1Z");
    dttm.addHour(-1);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("Ԃ5Z");
    dttm.addHour(-5);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 6);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("Ԃ5Z");
    dttm.addHour(5);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("Ԃ10Z");
    dttm.addHour(10);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 21);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("Ԃ10Z");
    dttm.addHour(-10);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);
  }

  public void addMinute()
  {
    DateTime dttm = new DateTime(2004, 5, 12, 11, 12, 33);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 12);
    EQUAL(dttm.getSecond(), 33);

    MSG("1Z");
    dttm.addMinute(1);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 13);
    EQUAL(dttm.getSecond(), 33);

    MSG("1Z");
    dttm.addMinute(-1);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 12);
    EQUAL(dttm.getSecond(), 33);

    MSG("5Z");
    dttm.addMinute(-5);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 7);
    EQUAL(dttm.getSecond(), 33);

    MSG("5Z");
    dttm.addMinute(5);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 12);
    EQUAL(dttm.getSecond(), 33);

    MSG("10Z");
    dttm.addMinute(10);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("10Z");
    dttm.addMinute(-10);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 12);
    EQUAL(dttm.getSecond(), 33);
  }

  public void addSecond()
  {
    DateTime dttm = new DateTime(2004, 5, 12, 11, 22, 33);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("b1Z");
    dttm.addSecond(1);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 34);

    MSG("b1Z");
    dttm.addSecond(-1);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("b5Z");
    dttm.addSecond(-5);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 28);

    MSG("b5Z");
    dttm.addSecond(5);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);

    MSG("b10Z");
    dttm.addSecond(10);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 43);

    MSG("b10Z");
    dttm.addSecond(-10);
    EQUAL(dttm.getYear(), 2004);
    EQUAL(dttm.getMonth(), 5);
    EQUAL(dttm.getDay(), 12);
    EQUAL(dttm.getHour(), 11);
    EQUAL(dttm.getMinute(), 22);
    EQUAL(dttm.getSecond(), 33);
  }

  public void _hashCode()
  {
    MSG("lDateTimeIuWFNg̃nbVR[hƂmF");
    DateTime dttm0 = new DateTime(2004, 5, 6, 11, 22, 33);
    DateTime dttm1 = new DateTime(2004, 5, 6, 11, 22, 33);
    EQUAL(dttm0.hashCode(), dttm1.hashCode());
  }

  public void equals()
  {
    MSG("ʏ̑̏ꍇ");

    DateTime dttm0 = new DateTime(123456789L);
    DateTime dttm1 = new DateTime(123456789L);
    DateTime dttm2 = new DateTime(123456780L);
    TRUE(dttm0.equals(dttm0));
    TRUE(dttm0.equals(dttm1));
    TRUE(dttm1.equals(dttm0));
    FALSE(dttm0.equals(dttm2));
    FALSE(dttm2.equals(dttm1));
  }

  public void equals_1()
  {
    MSG("Ƀkw肵ꍇ");

    DateTime dttm = new DateTime(1234567890L);
    FALSE(dttm.equals(null));
  }

  public void equals_2()
  {
    MSG("ɑ̃IuWFNgw肵ꍇ");

    DateTime dttm = new DateTime(1234567890L);
    FALSE(dttm.equals(new Date(1234567890L)));
  }

  public void equals_3()
  {
    MSG("l͓łJ_[قȂꍇ");
    Calendar cal = new GregorianCalendar(
      TimeZone.getTimeZone("America/Los_Angeles"), Locale.US);
    cal.setTimeInMillis(123456789L);

    DateTime dttm0 = new DateTime(123456789L);
    DateTime dttm1 = new DateTime(cal);
    FALSE(dttm0.equals(dttm1));
  }

  public void compareTo()
  {
    MSG("ʏ̏ꍇ");

    DateTime dttm0 = new DateTime(123456789L);
    DateTime dttm1 = new DateTime(123456789L);
    DateTime dttm2 = new DateTime(123456790L);
    DateTime dttm3 = new DateTime(123456788L);

    EQUAL(dttm0.compareTo(dttm0), 0);
    EQUAL(dttm0.compareTo(dttm1), 0);
    TRUE(dttm0.compareTo(dttm2) < 0);
    TRUE(dttm3.compareTo(dttm0) < 0);
    TRUE(dttm3.compareTo(dttm1) < 0);
    TRUE(dttm0.compareTo(dttm3) > 0);
    TRUE(dttm2.compareTo(dttm0) > 0);
    TRUE(dttm2.compareTo(dttm3) > 0);
  }

  public void compareTo_1()
  {
    MSG("Ƀkw肵ꍇ");
    DateTime dttm = new DateTime(123456789L);
    try {
      dttm.compareTo(null);
      NG();
    } catch (NullPointerException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void compareTo_2()
  {
    MSG("J_قȂꍇB");

    Calendar cal = new GregorianCalendar(
      TimeZone.getTimeZone("America/Los_Angeles"), Locale.US);
    cal.setTimeInMillis(123456789L);

    DateTime dttm0 = new DateTime(123456789L);
    DateTime dttm1 = new DateTime(cal);

    try {
      dttm0.compareTo(dttm1);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void _toString()
  {
    MSG("ʏ̑̏ꍇ");
    DateTime dttm = new DateTime(2004, 9, 10, 1, 22, 3);
    EQUAL(dttm.toString(), "2004-09-10 01:22:03");
    EQUAL(DateTime.toString(dttm), "2004-09-10 01:22:03");
  }

  public void _toString_1()
  {
    MSG("k̏ꍇ");
    DateTime dttm = new DateTime(2004, 9, 10, 1, 22, 3);
    try {
      dttm.toString(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void _toString_2()
  {
    MSG("IȌꍇ");
    DateTime dttm = new DateTime();
    dttm.setDateTime(GregorianCalendar.BC, 2004, 9, 10, 1, 22, 3);
    EQUAL(dttm.toString(), "2004-09-10 01:22:03 (IO)");
    EQUAL(DateTime.toString(dttm), "2004-09-10 01:22:03 (IO)");
  }

  public void parseDateTime()
  {
    MSG("ʏ̑");
    try {
      EQUAL(DateTime.parseDateTime("2004-09-24 15:26:37"),
        new DateTime(2004, 9, 24, 15, 26, 37));
    } catch (Exception e) {
      NG(e);
    }
    try {
      EQUAL(DateTime.parseDateTime("2004-01-01 00:00:00"),
        new DateTime(2004, 1, 1, 0, 0, 0));
    } catch (Exception e) {
      NG(e);
    }
    try {
      EQUAL(DateTime.parseDateTime("2004-12-31 23:59:59"),
        new DateTime(2004, 12, 31, 23, 59, 59));
    } catch (Exception e) {
      NG(e);
    }
    try {
      EQUAL(DateTime.parseDateTime("2004-10-02"),
        new DateTime(2004, 10, 2, 0, 0, 0));
    } catch (Exception e) {
      NG(e);
    }
    try {
      EQUAL(DateTime.parseDateTime("2004-04-07 21:30:03 (IO)"),
        new DateTime(0, 2004, 4, 7, 21, 30, 3));
    } catch (Exception e) {
      NG(e);
    }
    try {
      EQUAL(DateTime.parseDateTime("2004-04-07 21:30:03 ()"),
        new DateTime(1, 2004, 4, 7, 21, 30, 3));
    } catch (Exception e) {
      NG(e);
    }
  }

  public void parseDateTime_1()
  {
    MSG("Ƀkw肵ꍇ");
    try {
      DateTime.parseDateTime(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void parseDateTime_2()
  {
    MSG("sȏꍇ");
    try {
      DateTime.parseDateTime("2004/04/04");
      NG();
    } catch (ParseException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
    try {
      DateTime.parseDateTime("20040823");
      NG();
    } catch (ParseException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void parseDateTime_3()
  {
    MSG("b͈͊Ȍꍇ");
    try {
      DateTime.parseDateTime("2004-00-21 01:23:45");
      NG();
    } catch (ParseException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
    try {
      DateTime.parseDateTime("2004-13-21 01:23:45");
      NG();
    } catch (ParseException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
    try {
      DateTime.parseDateTime("2004-04-00 01:23:45");
      NG();
    } catch (ParseException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
    try {
      DateTime.parseDateTime("2004-04-32 01:23:45");
      NG();
    } catch (ParseException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
    try {
      DateTime.parseDateTime("2004-04-04 24:59:59");
      NG();
    } catch (ParseException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
    try {
      DateTime.parseDateTime("2004-04-05 10:61:20");
      NG();
    } catch (ParseException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
    try {
      DateTime.parseDateTime("2004-04-06 21:29:63");
      NG();
    } catch (ParseException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void serializeAndDeserialize()
  {
    ObjectSerializer os = new ObjectSerializer();

    DateTime dttm = new DateTime(2004, 12, 13);
    try {
      byte[] bytes = os.serializeToByteArray(dttm);
      NOTNULL(bytes);
      DateTime newDttm = (DateTime) os.deserialize(bytes);
      EQUAL(newDttm, dttm);
      EQUAL(newDttm.getCalendar(), dttm.getCalendar());
    } catch (Exception e) {
      NG(e);
    }

    DateTime dttm1 = new DateTime(2004, 12, 13, 21, 50, 23);
    try {
      byte[] bytes = os.serializeToByteArray(dttm1);
      NOTNULL(bytes);
      DateTime newDttm = (DateTime) os.deserialize(bytes);
      EQUAL(newDttm, dttm1);
      EQUAL(newDttm.getCalendar(), dttm1.getCalendar());
    } catch (Exception e) {
      NG(e);
    }

    TimeZone zone = TimeZone.getTimeZone("GMT-8");
    Locale locale = Locale.ENGLISH;
    Calendar cal = Calendar.getInstance(zone, locale);
    DateTime dttm2 = new DateTime(cal);
    try {
      byte[] bytes = os.serializeToByteArray(dttm2);
      NOTNULL(bytes);
      DateTime newDttm = (DateTime) os.deserialize(bytes);
      EQUAL(newDttm, dttm2);
      EQUAL(newDttm.getCalendar(), dttm2.getCalendar());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void floorMinute()
  {
    MSG("ʏ̏ꍇ (15PʂŐ؂艺j");

    for (int i=0; i<15; i++) {
      DateTime dttm = new DateTime(2006, 1, 1, 0, i, 10);
      dttm.floorMinute(15);
      EQUAL(dttm, new DateTime(2006, 1, 1, 0, 0, 0));
    }
    for (int i=15; i<30; i++) {
      DateTime dttm = new DateTime(2006, 1, 1, 0, i, 10);
      dttm.floorMinute(15);
      EQUAL(dttm, new DateTime(2006, 1, 1, 0, 15, 0));
    }
    for (int i=30; i<45; i++) {
      DateTime dttm = new DateTime(2006, 1, 1, 0, i, 10);
      dttm.floorMinute(15);
      EQUAL(dttm, new DateTime(2006, 1, 1, 0, 30, 0));
    }
    for (int i=45; i<60; i++) {
      DateTime dttm = new DateTime(2006, 1, 1, 0, i, 10);
      dttm.floorMinute(15);
      EQUAL(dttm, new DateTime(2006, 1, 1, 0, 45, 0));
    }
  }

  public void floorMinute_1()
  {
    MSG("ʏ̏ꍇ (30PʂŐ؂艺j");

    for (int i=0; i<30; i++) {
      DateTime dttm = new DateTime(2006, 1, 1, 0, i, 10);
      dttm.floorMinute(30);
      EQUAL(dttm, new DateTime(2006, 1, 1, 0, 0, 0));
    }
    for (int i=30; i<60; i++) {
      DateTime dttm = new DateTime(2006, 1, 1, 0, i, 10);
      dttm.floorMinute(30);
      EQUAL(dttm, new DateTime(2006, 1, 1, 0, 30, 0));
    }
  }

  public void floorMinute_2()
  {
    MSG("ʏ̏ꍇ (60PʂŐ؂艺j");

    for (int i=0; i<60; i++) {
      DateTime dttm = new DateTime(2006, 1, 1, 0, i, 10);
      dttm.floorMinute(60);
      EQUAL(dttm, new DateTime(2006, 1, 1, 0, 0, 0));
    }
  }

  public void floorMinute_3()
  {
    MSG("0̏ꍇ");

    for (int i=0; i<60; i++) {
      DateTime dttm = new DateTime(2006, 1, 1, 0, i, 10);
      dttm.floorMinute(0);
      EQUAL(dttm, new DateTime(2006, 1, 1, 0, i, 10));
    }
  }

  public void floorMinute_4()
  {
    MSG("̏ꍇ");

    try {
      DateTime dttm = new DateTime(2006, 1, 1, 0, 1, 10);
      dttm.floorMinute(-1);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void ceilMinute()
  {
    MSG("ʏ̏ꍇ (15PʂŐ؂グj");

    for (int i=0; i<=0; i++) {
      DateTime dttm = new DateTime(2006, 1, 1, 0, i, 10);
      dttm.ceilMinute(15);
      EQUAL(dttm, new DateTime(2006, 1, 1, 0, 0, 0));
    }
    for (int i=1; i<=15; i++) {
      DateTime dttm = new DateTime(2006, 1, 1, 0, i, 10);
      dttm.ceilMinute(15);
      EQUAL(dttm, new DateTime(2006, 1, 1, 0, 15, 0));
    }
    for (int i=16; i<=30; i++) {
      DateTime dttm = new DateTime(2006, 1, 1, 0, i, 10);
      dttm.ceilMinute(15);
      EQUAL(dttm, new DateTime(2006, 1, 1, 0, 30, 0));
    }
    for (int i=31; i<=45; i++) {
      DateTime dttm = new DateTime(2006, 1, 1, 0, i, 10);
      dttm.ceilMinute(15);
      EQUAL(dttm, new DateTime(2006, 1, 1, 0, 45, 0));
    }
    for (int i=46; i<=59; i++) {
      DateTime dttm = new DateTime(2006, 1, 1, 0, i, 10);
      dttm.ceilMinute(15);
      EQUAL(dttm, new DateTime(2006, 1, 1, 1,  0, 0));
    }
  }

  public void ceilMinute_1()
  {
    MSG("ʏ̏ꍇ (30PʂŐ؂グj");

    for (int i=0; i<=0; i++) {
      DateTime dttm = new DateTime(2006, 1, 1, 0, i, 10);
      dttm.ceilMinute(30);
      EQUAL(dttm, new DateTime(2006, 1, 1, 0, 0, 0));
    }
    for (int i=1; i<=30; i++) {
      DateTime dttm = new DateTime(2006, 1, 1, 0, i, 10);
      dttm.ceilMinute(30);
      EQUAL(dttm, new DateTime(2006, 1, 1, 0, 30, 0));
    }
    for (int i=31; i<=59; i++) {
      DateTime dttm = new DateTime(2006, 1, 1, 0, i, 10);
      dttm.ceilMinute(30);
      EQUAL(dttm, new DateTime(2006, 1, 1, 1, 0, 0));
    }
  }

  public void ceilMinute_2()
  {
    MSG("ʏ̏ꍇ (60PʂŐ؂グj");

    for (int i=0; i<=0; i++) {
      DateTime dttm = new DateTime(2006, 1, 1, 0, i, 10);
      dttm.ceilMinute(60);
      EQUAL(dttm, new DateTime(2006, 1, 1, 0, 0, 0));
    }
    for (int i=1; i<60; i++) {
      DateTime dttm = new DateTime(2006, 1, 1, 0, i, 10);
      dttm.ceilMinute(60);
      EQUAL(dttm, new DateTime(2006, 1, 1, 1, 0, 0));
    }
  }

  public void ceilMinute_3()
  {
    MSG("0̏ꍇ");

    for (int i=0; i<60; i++) {
      DateTime dttm = new DateTime(2006, 1, 1, 0, i, 10);
      dttm.ceilMinute(0);
      EQUAL(dttm, new DateTime(2006, 1, 1, 0, i, 10));
    }
  }

  public void ceilMinute_4()
  {
    MSG("̏ꍇ");

    try {
      DateTime dttm = new DateTime(2006, 1, 1, 0, 1, 10);
      dttm.ceilMinute(-1);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }
}

