/*
 * AttributeMapTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.resource.hierarchy;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import java.util.Iterator;

/**
 * <code>AttributeMap</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:50 $
 */
public class AttributeMapTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(AttributeMapTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- test case -- */

  public void constructor()
  {
    MSG("ftHgRXgN^");

    AttributeMap attrs = new AttributeMap();
    NOTNULL(attrs);
  }

  public void putAndGet()
  {
    AttributeMap attrs = new AttributeMap();
    Iterator it;

    EQUAL(attrs.size(), 0);
    EQUAL(attrs.get("aaa"), null);
    EQUAL(attrs.get("bbb"), null);
    EQUAL(attrs.get("ccc"), null);
    EQUAL(attrs.get("ddd"), null);
    EQUAL(attrs.get("eee"), null);
    it = attrs.keySet().iterator();
    EQUAL(it.hasNext(), false);

    attrs.put("bbb", "BBB");
    EQUAL(attrs.size(), 1);
    EQUAL(attrs.get("aaa"), null);
    EQUAL(attrs.get("bbb"), "BBB");
    EQUAL(attrs.get("ccc"), null);
    EQUAL(attrs.get("ddd"), null);
    EQUAL(attrs.get("eee"), null);
    it = attrs.keySet().iterator();
    EQUAL(it.hasNext(), true);
    EQUAL(it.next(), "bbb");
    EQUAL(it.hasNext(), false);

    attrs.put("eee", "EEE");
    EQUAL(attrs.size(), 2);
    EQUAL(attrs.get("aaa"), null);
    EQUAL(attrs.get("bbb"), "BBB");
    EQUAL(attrs.get("ccc"), null);
    EQUAL(attrs.get("ddd"), null);
    EQUAL(attrs.get("eee"), "EEE");
    it = attrs.keySet().iterator();
    EQUAL(it.hasNext(), true);
    EQUAL(it.next(), "bbb");
    EQUAL(it.hasNext(), true);
    EQUAL(it.next(), "eee");
    EQUAL(it.hasNext(), false);

    attrs.put("ccc", "CCC");
    attrs.put("aaa", "AAA");
    attrs.put("ddd", "DDD");
    EQUAL(attrs.size(), 5);
    EQUAL(attrs.get("aaa"), "AAA");
    EQUAL(attrs.get("bbb"), "BBB");
    EQUAL(attrs.get("ccc"), "CCC");
    EQUAL(attrs.get("ddd"), "DDD");
    EQUAL(attrs.get("eee"), "EEE");
    it = attrs.keySet().iterator();
    EQUAL(it.hasNext(), true);
    EQUAL(it.next(), "aaa");
    EQUAL(it.hasNext(), true);
    EQUAL(it.next(), "bbb");
    EQUAL(it.hasNext(), true);
    EQUAL(it.next(), "ccc");
    EQUAL(it.hasNext(), true);
    EQUAL(it.next(), "ddd");
    EQUAL(it.hasNext(), true);
    EQUAL(it.next(), "eee");
    EQUAL(it.hasNext(), false);

    attrs.put("ddd", "XXX");
    EQUAL(attrs.size(), 5);
    EQUAL(attrs.get("aaa"), "AAA");
    EQUAL(attrs.get("bbb"), "BBB");
    EQUAL(attrs.get("ccc"), "CCC");
    EQUAL(attrs.get("ddd"), "XXX");
    EQUAL(attrs.get("eee"), "EEE");
    it = attrs.keySet().iterator();
    EQUAL(it.hasNext(), true);
    EQUAL(it.next(), "aaa");
    EQUAL(it.hasNext(), true);
    EQUAL(it.next(), "bbb");
    EQUAL(it.hasNext(), true);
    EQUAL(it.next(), "ccc");
    EQUAL(it.hasNext(), true);
    EQUAL(it.next(), "ddd");
    EQUAL(it.hasNext(), true);
    EQUAL(it.next(), "eee");
    EQUAL(it.hasNext(), false);

    attrs.remove("ccc");
    EQUAL(attrs.size(), 4);
    EQUAL(attrs.get("aaa"), "AAA");
    EQUAL(attrs.get("bbb"), "BBB");
    EQUAL(attrs.get("ccc"), null);
    EQUAL(attrs.get("ddd"), "XXX");
    EQUAL(attrs.get("eee"), "EEE");
    it = attrs.keySet().iterator();
    EQUAL(it.hasNext(), true);
    EQUAL(it.next(), "aaa");
    EQUAL(it.hasNext(), true);
    EQUAL(it.next(), "bbb");
    EQUAL(it.hasNext(), true);
    EQUAL(it.next(), "ddd");
    EQUAL(it.hasNext(), true);
    EQUAL(it.next(), "eee");
    EQUAL(it.hasNext(), false);
  }
}
