/*
 * ConstraintTrigger_nullTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.table;

import ts.tester.function.FunctionTester;
import ts.tester.function.print.*;
import java.util.Map;
import java.util.HashMap;

/**
 * {@link ts.util.table.ConstraintTrigger ConstraintTrigger}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:50 $
 */
public class ConstraintTrigger_nullTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      setPrinter(group);

      run(ConstraintTrigger_nullTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- test case -- */

  public void addConstraintForAppend_Constraint()
  {
    MSG("k̏ꍇB");

    ConstraintTrigger<String,String> trigger =
      new ConstraintTrigger<String,String>();

    Constraint<String,String> constraint = new Constraint<String,String>() {
      protected void check(Trigger.Action a, Table<String,String> t,
      Map<String,String> r) throws ConstraintViolationException {}
    };
    try {
      trigger.addConstraintForAppend(null);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
    catch (Exception e) {
      NG(e);
    }
  }

  public void addConstraintForUpdate_Constraint()
  {
    MSG("k̏ꍇB");

    ConstraintTrigger<String,String> trigger =
      new ConstraintTrigger<String,String>();

    Constraint<String,String> constraint = new Constraint<String,String>() {
      protected void check(Trigger.Action a, Table<String,String> t,
      Map<String,String> r) throws ConstraintViolationException {}
    };
    try {
      trigger.addConstraintForUpdate(null);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
    catch (Exception e) {
      NG(e);
    }
  }

  public void addConstraintForDelete_Constraint()
  {
    MSG("k̏ꍇB");

    ConstraintTrigger<String,String> trigger =
      new ConstraintTrigger<String,String>();

    Constraint<String,String> constraint = new Constraint<String,String>() {
      protected void check(Trigger.Action a, Table<String,String> t,
      Map<String,String> r) throws ConstraintViolationException {}
    };
    try {
      trigger.addConstraintForDelete(null);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
    catch (Exception e) {
      NG(e);
    }
  }

  public void preAppend_Table_Map()
  {
    MSG("k̏ꍇB");

    ConstraintTrigger<String,String> trigger =
      new ConstraintTrigger<String,String>();

    Table<String,String> tab = new MapListTable<String,String>();
    Map<String,String> rec = new HashMap<String,String>();
    try {
      trigger.preAppend(tab, null);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
    catch (Exception e) {
      NG(e);
    }

    try {
      trigger.preAppend(null, rec);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
    catch (Exception e) {
      NG(e);
    }
  }

  public void preUpdate_Table_Map_Map()
  {
    MSG("k̏ꍇB");

    ConstraintTrigger<String,String> trigger =
      new ConstraintTrigger<String,String>();

    Table<String,String> tab = new MapListTable<String,String>();
    Map<String,String> rec = new HashMap<String,String>();
    Map<String,String> dst = new HashMap<String,String>();
    try {
      trigger.preUpdate(null, rec, dst);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
    catch (Exception e) {
      NG(e);
    }

    try {
      trigger.preUpdate(tab, null, dst);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
    catch (Exception e) {
      NG(e);
    }

    try {
      trigger.preUpdate(tab, rec, null);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
    catch (Exception e) {
      NG(e);
    }
  }

  public void preDelete_Table_Map()
  {
    MSG("k̏ꍇB");

    ConstraintTrigger<String,String> trigger =
      new ConstraintTrigger<String,String>();

    Table<String,String> tab = new MapListTable<String,String>();
    Map<String,String> rec = new HashMap<String,String>();
    try {
      trigger.preDelete(null, rec);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
    catch (Exception e) {
      NG(e);
    }

    try {
      trigger.preDelete(tab, null);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
    catch (Exception e) {
      NG(e);
    }
  }

  public void postAppend_Table_Map()
  {
    MSG("k̏ꍇB");

    ConstraintTrigger<String,String> trigger =
      new ConstraintTrigger<String,String>();

    Table<String,String> tab = new MapListTable<String,String>();
    Map<String,String> rec = new HashMap<String,String>();

    trigger.postAppend(null, rec);
    OK();

    trigger.postAppend(tab, null);
    OK();
  }

  public void postUpdate_Table_Map_Map()
  {
    MSG("k̏ꍇB");

    ConstraintTrigger<String,String> trigger =
      new ConstraintTrigger<String,String>();

    Table<String,String> tab = new MapListTable<String,String>();
    Map<String,String> rec = new HashMap<String,String>();
    Map<String,String> dst = new HashMap<String,String>();

    trigger.postUpdate(null, rec, dst);
    OK();

    trigger.postUpdate(tab, null, dst);
    OK();

    trigger.postUpdate(tab, rec, null);
    OK();
  }

  public void postDelete_Table_Map()
  {
    MSG("k̏ꍇB");

    ConstraintTrigger<String,String> trigger =
      new ConstraintTrigger<String,String>();

    Table<String,String> tab = new MapListTable<String,String>();
    Map<String,String> rec = new HashMap<String,String>();

    trigger.postDelete(null, rec);
    OK();

    trigger.postDelete(tab, null);
    OK();
  }
}

