/*
 * Decompiled with CFR 0.152.
 */
package ts.util.table;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import ts.util.table.AbstractTable;
import ts.util.table.Header;
import ts.util.table.Record;

public class MapListTable<C, V>
extends AbstractTable<C, V> {
    static final long serialVersionUID = -2802871239990289562L;

    public MapListTable() {
    }

    public MapListTable(int n, int n2) {
        super(n, n2);
    }

    protected MapListTable(Header<C> header) {
        super(header);
    }

    @Override
    protected Header<C> createHeader(int n) {
        return new MapListTableHeader(n);
    }

    @Override
    protected Collection<Record<C, V>> createRecordCollection(int n) {
        assert (n >= 0) : "@param:initRecCapacity is negative.";
        return new LinkedList<Record<C, V>>();
    }

    @Override
    protected Record<C, V> createRecord(int n) {
        assert (n >= 0) : "@param:initColCapacity is negative.";
        return new MapListTableRecord();
    }

    protected class MapListTableRecord
    extends Record<C, V> {
        static final long serialVersionUID = 1964738182974536709L;
        private Map<C, V> valueMap_ = new HashMap();

        @Override
        protected Header<C> header() {
            return MapListTable.this.header();
        }

        @Override
        protected V getValue(Object object) {
            return this.valueMap_.get(object);
        }

        @Override
        protected V putValue(C c, V v) {
            return this.valueMap_.put(c, v);
        }

        @Override
        protected V removeValue(Object object) {
            return this.valueMap_.remove(object);
        }
    }

    protected class MapListTableHeader
    implements Header<C> {
        static final long serialVersionUID = 7045899894614584582L;
        private Set<C> columnSet_;

        public MapListTableHeader(int n) {
            assert (n >= 0) : "@param:initColCapacity is negative.";
            this.columnSet_ = new HashSet(n);
        }

        @Override
        public int columnCount() {
            return this.columnSet_.size();
        }

        @Override
        public Enumeration<C> columns() {
            return Collections.enumeration(this.columnSet_);
        }

        @Override
        public boolean hasColumn(Object object) {
            return this.columnSet_.contains(object);
        }

        @Override
        public void addColumn(C c) {
            this.columnSet_.add(c);
        }
    }
}

