/*
 * ConstraintTrigger class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.table;

import java.util.Map;
import java.util.List;
import java.util.LinkedList;

/**
 * e[uύXɁÃ`FbNĂяogKENXB
 * <br>
 * ̃IuWFNgɓo^ꂽ{@link ts.util.table.Constraint Constraint}
 * IuWFNg̃`FbNA{@link #preAppend(Table, java.util.Map)
 * preAppend}, {@link #preUpdate(Table, java.util.Map, java.util.Map)
 * preUpdate}, {@link #preDelete(Table, java.util.Map) preDelete}\bh
 * ꂩŎsB
 * <br>
 * {@link ts.util.table.Constraint Constraint}IuWFNg̃`FbN
 * ᔽƔ肳ꂽꍇ́A{@link
 * ts.util.table.ConstraintViolationException ConstraintViolationException}
 * ɃX[B
 * <br>
 * ÃIuWFNg𐶐鎞ɁARXgN^̈<tt>false</tt>
 * w肵ꍇ́ASĂ̐̃`FbNsĂAŏɔ
 * OX[BQԖڈȍ~ɔÓA{@link
 * ts.util.table.ConstraintViolationException#next()}\bhŘAIɎ擾
 * ƂłB
 *
 * @param  <C> e[ũJEL[̃^CvB
 * @param  <V> e[ũJl̃^CvB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2010-10-16 10:51:35 $
 */
public class ConstraintTrigger<C,V> extends Trigger<C,V>
{
  /** ᔽꍇɒɗOX[邩ǂtOB */
  private boolean isImmediate_ = true;

  /**
   * R[h̒ǉOɃ`FbNs{@link ts.util.table.Constraint
   * Constraint}IuWFNgi[郊XgB
   */
  private List<Constraint<C,V>> constraintsForAppend_ =
    new LinkedList<Constraint<C,V>>();

  /**
   * R[h̍XVOɃ`FbNs{@link ts.util.table.Constraint
   * Constraint}IuWFNgi[郊XgB
   */
  private List<Constraint<C,V>> constraintsForUpdate_ =
    new LinkedList<Constraint<C,V>>();

  /**
   * R[h̍폜OɃ`FbNs{@link ts.util.table.Constraint
   * Constraint}IuWFNgi[郊XgB
   */
  private List<Constraint<C,V>> constraintsForDelete_ =
    new LinkedList<Constraint<C,V>>();

  /**
   * ftHgRXgN^B
   * <br>
   * ̃`FbNŐᔽꍇ͒ɗOX[B
   */
  public ConstraintTrigger()
  {
    this(true);
  }

  /**
   * ̃`FbNŐᔽꍇɁAɗOX[邩ǂ
   * ɂƂRXgN^B
   *
   * @param  isImmediate ɗOX[ꍇ<tt>true</tt>B
   */
  public ConstraintTrigger(boolean isImmediate)
  {
    isImmediate_ = isImmediate;
  }

  /**
   * R[h̒ǉOɐᔽ̃`FbNs{@link
   * ts.util.table.Constraint Constraint}IuWFNgǉB
   *
   * @param constraint {@link ts.util.table.Constraint Constraint}IuWFNgB
   * @throws AssertionError k̏ꍇB
   */
  public void addConstraintForAppend(Constraint<C,V> constraint)
  {
    assert (constraint != null) : "@param:constraint is null.";
    constraintsForAppend_.add(constraint);
  }

  /**
   * R[h̍XVOɐᔽ̃`FbNs{@link
   * ts.util.table.Constraint Constraint}IuWFNgǉB
   *
   * @param constraint {@link ts.util.table.Constraint Constraint}IuWFNgB
   * @throws AssertionError k̏ꍇB
   */
  public void addConstraintForUpdate(Constraint<C,V> constraint)
  {
    assert (constraint != null) : "@param:constraint is null.";
    constraintsForUpdate_.add(constraint);
  }

  /**
   * R[h̍폜Oɐᔽ̃`FbNs{@link
   * ts.util.table.Constraint Constraint}IuWFNgǉB
   *
   * @param constraint {@link ts.util.table.Constraint Constraint}IuWFNgB
   * @throws AssertionError k̏ꍇB
   */
  public void addConstraintForDelete(Constraint<C,V> constraint)
  {
    assert (constraint != null) : "@param:constraint is null.";
    constraintsForDelete_.add(constraint);
  }

  /**
   * R[h̒ǉ̒OɌĂяo郁\bhB
   * <br>
   * R[h̒ǉOɐᔽ̃`FbNs{@link
   * ts.util.table.Constraint Constraint}IuWFNg̃`FbNĂяoB
   * 
   * @param  table e[uEIuWFNgB
   * @param  record ǉ郌R[hEIuWFNgB
   * @throws ConstraintViolationException ᔽꍇB
   */
  @Override
  protected void preAppend(Table<C,V> table, Map<C,V> record)
  {
    assert (table != null) : "@param:table is null.";
    assert (record != null) : "@param:record is null.";

    ConstraintViolationException top = null;
    ConstraintViolationException cur = null;

    for (Constraint<C,V> constraint : constraintsForAppend_) {
      try {
        constraint.check(Trigger.Action.Append, table, record);
      }
      catch (ConstraintViolationException e) {
        if (isImmediate_) throw e;

        if (cur == null) { cur = top = e; }
        else { cur.setNext(e); cur = e; }
      }
    }

    if (top != null) throw top;
  }

  /**
   * R[h̍XV̒OɌĂяo郁\bhB
   * <br>
   * R[h̍XVOɐᔽ̃`FbNs{@link
   * ts.util.table.Constraint Constraint}IuWFNg̃`FbNĂяoB
   * 
   * @param  table e[uEIuWFNgB
   * @param  record XV郌R[hEIuWFNgB
   * @param  destination XVJEL[Ƃ̒li[}bvB
   * @throws ConstraintViolationException ᔽꍇB
   */
  @Override
  protected void preUpdate(Table<C,V> table, Map<C,V> record,
    Map<C,V> destination)
  {
    assert (table != null) : "@param:table is null.";
    assert (record != null) : "@param:record is null.";
    assert (destination != null) : "@param:destination is null.";

    ConstraintViolationException top = null;
    ConstraintViolationException cur = null;

    for (Constraint<C,V> constraint : constraintsForUpdate_) {
      try {
        constraint.check(Trigger.Action.Update, table, record);
      }
      catch (ConstraintViolationException e) {
        if (isImmediate_) throw e;

        if (cur == null) { cur = top = e; }
        else { cur.setNext(e); cur = e; }
      }
    }

    if (top != null) throw top;
  }

  /**
   * R[h̍폜̒OɌĂяo郁\bhB
   * <br>
   * R[h̍폜Oɐᔽ̃`FbNs{@link
   * ts.util.table.Constraint Constraint}IuWFNg̃`FbNĂяoB
   * 
   * @param  table e[uEIuWFNgB
   * @param  record 폜郌R[hEIuWFNgB
   * @throws ConstraintViolationException ᔽꍇB
   */
  @Override
  protected void preDelete(Table<C,V> table, Map<C,V> record)
  {
    assert (table != null) : "@param:table is null.";
    assert (record != null) : "@param:record is null.";

    ConstraintViolationException top = null;
    ConstraintViolationException cur = null;

    for (Constraint<C,V> constraint : constraintsForDelete_) {
      try {
        constraint.check(Trigger.Action.Delete, table, record);
      }
      catch (ConstraintViolationException e) {
        if (isImmediate_) throw e;

        if (cur == null) { cur = top = e; }
        else { cur.setNext(e); cur = e; }
      }
    }

    if (top != null) throw top;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected final void postAppend(Table<C,V> table, Map<C,V> record)
  {}

  /**
   * {@inheritDoc}
   */
  @Override
  protected final void postUpdate(Table<C,V> table, Map<C,V> record,
    Map<C,V> destination)
  {}

  /**
   * {@inheritDoc}
   */
  @Override
  protected final void postDelete(Table<C,V> table, Map<C,V> record)
  {}
}

